import { NavigationMenu } from 'types/data';

const ComponentsNav: NavigationMenu = [
  {
    title: 'Actions',
    icon: 'hand-pointer',
    items: [
      {
        path: '/get-started/components/actions/button',
        label: 'Button',
        target: '',
      },
      {
        path: '/get-started/components/actions/disclosure',
        label: 'Disclosure',
        target: '',
      },
      {
        path: '/get-started/components/actions/accordion',
        label: 'Accordion',
        target: '',
      },
      {
        path: '/get-started/components/actions/expander',
        label: 'Expander',
        target: '',
      },
      {
        path: '/get-started/components/actions/icon-button',
        label: 'Icon button',
        target: '',
      },
      {
        path: '/get-started/components/actions/split-button',
        label: 'Split button',
        target: '',
      },
      {
        path: '/get-started/components/actions/toggle-button',
        label: 'Toggle button',
        target: '',
      },
    ],
  },
  {
    title: 'Dialogs',
    icon: 'message',
    items: [
      {
        path: '/get-started/components/dialogs/drawer',
        label: 'Drawer',
        target: '',
      },
      {
        path: '/get-started/components/dialogs/popover',
        label: 'Popover',
        target: '',
      },
      {
        path: '/get-started/components/dialogs/info-state',
        label: 'Info state',
        target: '',
      },
      {
        path: '/get-started/components/dialogs/modal',
        label: 'Modal',
        target: '',
      },
      {
        path: '/get-started/components/dialogs/snackbar',
        label: 'Snackbar',
        target: '',
      },
      {
        path: '/get-started/components/dialogs/tooltip',
        label: 'Tooltip',
        target: '',
      },
    ],
  },
  {
    title: 'Inputs',
    icon: 'news',
    items: [
      {
        path: '/get-started/components/inputs/autocomplete',
        label: 'Autocomplete',
        target: '',
      },
      {
        path: '/get-started/components/inputs/select',
        label: 'Select',
        target: '',
      },
      {
        path: '/get-started/components/inputs/selection-controls',
        label: 'Selection controls',
        target: '',
      },
      {
        path: '/get-started/components/inputs/slider',
        label: 'Slider',
        target: '',
      },
      {
        path: '/get-started/components/inputs/textfield',
        label: 'Textfield',
        target: '',
      },
      {
        path: '/get-started/components/inputs/input-group',
        label: 'Input group',
        target: '',
      },
    ],
  },
  {
    title: 'Layouts',
    icon: 'layer-group',
    items: [
      {
        path: '/get-started/components/layouts/card',
        label: 'Card',
        target: '',
      },
      {
        path: '/get-started/components/layouts/product-card',
        label: 'Product Card',
        target: '',
        tag: {
          color: 'green',
          label: 'new',
        },
      },
      {
        path: '/get-started/components/layouts/container',
        label: 'Container',
        target: '',
      },
      {
        path: '/get-started/components/layouts/grid',
        label: 'Grid',
        target: '',
      },
      {
        path: '/get-started/components/layouts/masonry',
        label: 'Masonry',
        target: '',
      },
      {
        path: '/get-started/components/layouts/overlay-container',
        label: 'Overlay container',
        target: '',
      },
      {
        path: '/get-started/components/layouts/separator',
        label: 'Separator',
        target: '',
      },
      {
        path: '/get-started/components/layouts/stack',
        label: 'Stack',
        target: '',
      },
      {
        path: '/get-started/components/layouts/table',
        label: 'Table',
        target: '',
      },
    ],
  },
  {
    title: 'Loading',
    icon: 'arrow-rotate-right',
    items: [
      {
        path: '/get-started/components/loading/circular-progress',
        label: 'Circular progress',
        target: '',
      },
      {
        path: '/get-started/components/loading/linear-progress',
        label: 'Linear progress',
        target: '',
      },
      {
        path: '/get-started/components/loading/skeleton',
        label: 'Skeleton',
        target: '',
      },
      {
        path: '/get-started/components/loading/spinner',
        label: 'Spinner',
        target: '',
      },
    ],
  },
  {
    title: 'Navigation',
    icon: 'compass',
    items: [
      {
        path: '/get-started/components/navigation/menu',
        label: 'Menu',
        target: '',
      },
      {
        path: '/get-started/components/navigation/tab',
        label: 'Tab',
        target: '',
      },
      {
        path: '/get-started/components/navigation/pagination',
        label: 'Pagination',
        target: '',
      },
    ],
  },
  {
    title: 'Typography',
    icon: 'text',
    items: [
      {
        path: '/get-started/components/typography/clamp-text',
        label: 'Clamp text',
        target: '',
      },
      {
        path: '/get-started/components/typography/list',
        label: 'List',
        target: '',
      },
      {
        path: '/get-started/components/typography/text',
        label: 'Text',
        target: '',
      },
    ],
  },
  {
    title: 'Widgets',
    icon: 'grid',
    items: [
      {
        path: '/get-started/components/widgets/avatar',
        label: 'Avatar',
        target: '',
      },
      {
        path: '/get-started/components/widgets/aspect-ratio',
        label: 'Aspect ratio',
        target: '',
      },
      {
        path: '/get-started/components/widgets/chip',
        label: 'Chip',
        target: '',
      },
      {
        path: '/get-started/components/widgets/datetime',
        label: 'Datetime',
        target: '',
      },
      {
        path: '/get-started/components/widgets/elevator',
        label: 'Elevator',
        target: '',
      },
      {
        path: '/get-started/components/widgets/symbol',
        label: 'Symbol',
        target: '',
      },
      {
        path: '/get-started/components/widgets/star-meter',
        label: 'Star meter',
        target: '',
      },
    ],
  },
];

export default ComponentsNav;
