#pragma once

/*
    Hey this file was generated by Structy from
    gem_settings.structy. Maybe don't edit it!
*/

#include "structy.h"

#include "fix16.h"

#define GEMSETTINGS_PACKED_SIZE 80

struct GemSettings {
    /* The ADC's internal gain correction register. */
    uint16_t adc_gain_corr;
    /* The ADC's internal offset correction register. */
    int16_t adc_offset_corr;
    /* The front-plate LED brightness. */
    uint16_t led_brightness;
    /* Configuration for the CV knob mins and maxs in volts, defaults to -1.2 to +1.2. */
    fix16_t castor_knob_min;
    fix16_t castor_knob_max;
    fix16_t pollux_knob_min;
    fix16_t pollux_knob_max;
    /* Maximum amount that the chorus can impact Pollux's frequency. */
    fix16_t chorus_max_intensity;
    /* The default LFO frequency in hertz. */
    fix16_t lfo_1_frequency;
    /* Error correction for the ADC readings for the CV input. */
    fix16_t cv_offset_error;
    fix16_t cv_gain_error;
    /* (Removed) Pitch input CV smoothing parameters. */
    fix16_t removed_smooth_initial_gain;
    fix16_t removed_smooth_sensitivity;
    /*  This is used to detect whether the pitch CV inputs have something
        patched. Basically, C&P checks if the input is near 0V and if it is,
        it assumes nothing is patched. If you routinely send 0V CV into C&P
        this can cause unexpected behavior, so in the case you can disable
        zero detection with zero_detection_enabled.

        The default is 350 which corresponds to just over 0V for C&P II.

        (previously named pollux_follower_threshold)
     */
    uint16_t zero_detection_threshold;
    /* (Removed) Route LFO to PWM for oscillators */
    bool removed_castor_lfo_pwm;
    bool removed_pollux_lfo_pwm;
    /* The firmware adjusts the pitch CV knobs so that it's easier to tune
        the oscillators. It does this by spreading the values near the center
        of the knob out so that the range at the center is more fine. This
        makes the knobs non-linear. This setting controls how "intense"
        this non-linearity is. A value of 0.33 is equivalent to a linear
        response. Higher values make it easier and easier to tune the
        oscillator but sacrifice the range, values lower than 0.33 will
        make it harder to tune and aren't recommended. */
    fix16_t pitch_knob_nonlinearity;
    /* The base CV offset applied to the pitch inputs. */
    fix16_t base_cv_offset;
    /* The ratio of the second LFO's frequency to the first. */
    fix16_t lfo_2_frequency_ratio;
    /* LFO 1's waveshape. */
    uint8_t lfo_1_waveshape;
    /* LFO 2's waveshape. */
    uint8_t lfo_2_waveshape;
    /* LFO 1's factor. */
    fix16_t lfo_1_factor;
    /* LFO 2's factor. */
    fix16_t lfo_2_factor;
    /*
    The bitmask applied to the pulse width DAC output. This allows emulating
    the behavior of Castor & Pollux's original firmware where timing issues
    caused pulse width modulation to "step".
     */
    uint16_t pulse_width_bitmask;
    /*
    Measured 8MHz oscillator frequency, used to fine tune the output pitch.
     */
    uint32_t osc8m_freq;
    /*
    Enables or disables zero volt detection used to check whether a patch
    cable is present at the pitch inputs.
     */
    bool zero_detection_enabled;
    /*
    Enables or disables quantization when Castor is in "Coarse" mode
     */
    bool quantization_enabled;
};

void GemSettings_init(struct GemSettings* inst);
struct StructyResult GemSettings_pack(const struct GemSettings* inst, uint8_t* buf);
struct StructyResult GemSettings_unpack(struct GemSettings* inst, const uint8_t* buf);
void GemSettings_print(const struct GemSettings* inst);
