﻿using Iced.Intel;

namespace Machine.X64.Runtime;

public partial class CpuRuntime
{
    private void RunCore(in Instruction instruction)
    {
        switch (instruction.Mnemonic)
        {
            case Mnemonic.INVALID:
                {
                    throw new InvalidOperationException("Undefined opcode");
                }

            case Mnemonic.Pop: pop(in instruction); break;
            case Mnemonic.Push: push(in instruction); break;
            case Mnemonic.Aaa: aaa(in instruction); break;
            case Mnemonic.Aad: aad(in instruction); break;
            case Mnemonic.Aam: aam(in instruction); break;
            case Mnemonic.Aas: aas(in instruction); break;
            case Mnemonic.Adc: adc(in instruction); break;
            case Mnemonic.Adcx: adcx(in instruction); break;
            case Mnemonic.Add: add(in instruction); break;
            case Mnemonic.Addpd: addpd(in instruction); break;
            case Mnemonic.Addps: addps(in instruction); break;
            case Mnemonic.Addsd: addsd(in instruction); break;
            case Mnemonic.Addss: addss(in instruction); break;
            case Mnemonic.Addsubpd: addsubpd(in instruction); break;
            case Mnemonic.Addsubps: addsubps(in instruction); break;
            case Mnemonic.Adox: adox(in instruction); break;
            case Mnemonic.And: and(in instruction); break;
            case Mnemonic.Andn: andn(in instruction); break;
            case Mnemonic.Andnpd: andnpd(in instruction); break;
            case Mnemonic.Andnps: andnps(in instruction); break;
            case Mnemonic.Andpd: andpd(in instruction); break;
            case Mnemonic.Andps: andps(in instruction); break;
            case Mnemonic.Blendpd: blendpd(in instruction); break;
            case Mnemonic.Blendps: blendps(in instruction); break;
            case Mnemonic.Blendvpd: blendvpd(in instruction); break;
            case Mnemonic.Blendvps: blendvps(in instruction); break;
            case Mnemonic.Blsi: blsi(in instruction); break;
            case Mnemonic.Blsmsk: blsmsk(in instruction); break;
            case Mnemonic.Blsr: blsr(in instruction); break;
            case Mnemonic.Bound: bound(in instruction); break;
            case Mnemonic.Bsf: bsf(in instruction); break;
            case Mnemonic.Bsr: bsr(in instruction); break;
            case Mnemonic.Bswap: bswap(in instruction); break;
            case Mnemonic.Bt: bt(in instruction); break;
            case Mnemonic.Btc: btc(in instruction); break;
            case Mnemonic.Btr: btr(in instruction); break;
            case Mnemonic.Bts: bts(in instruction); break;
            case Mnemonic.Call: call(in instruction); break;
            case Mnemonic.Cbw: cbw(in instruction); break;
            case Mnemonic.Cdq: cdq(in instruction); break;
            case Mnemonic.Clac: clac(in instruction); break;
            case Mnemonic.Clc: clc(in instruction); break;
            case Mnemonic.Cld: cld(in instruction); break;
            case Mnemonic.Cli: cli(in instruction); break;
            case Mnemonic.Cmc: cmc(in instruction); break;
            case Mnemonic.Cmova: cmova(in instruction); break;
            case Mnemonic.Cmovae: cmovae(in instruction); break;
            case Mnemonic.Cmovb: cmovb(in instruction); break;
            case Mnemonic.Cmovbe: cmovbe(in instruction); break;
            case Mnemonic.Cmove: cmove(in instruction); break;
            case Mnemonic.Cmovg: cmovg(in instruction); break;
            case Mnemonic.Cmovge: cmovge(in instruction); break;
            case Mnemonic.Cmovl: cmovl(in instruction); break;
            case Mnemonic.Cmovle: cmovle(in instruction); break;
            case Mnemonic.Cmovne: cmovne(in instruction); break;
            case Mnemonic.Cmovno: cmovno(in instruction); break;
            case Mnemonic.Cmovnp: cmovnp(in instruction); break;
            case Mnemonic.Cmovns: cmovns(in instruction); break;
            case Mnemonic.Cmovo: cmovo(in instruction); break;
            case Mnemonic.Cmovp: cmovp(in instruction); break;
            case Mnemonic.Cmovs: cmovs(in instruction); break;
            case Mnemonic.Cmp: cmp(in instruction); break;
            case Mnemonic.Cmppd: cmppd(in instruction); break;
            case Mnemonic.Cmpps: cmpps(in instruction); break;
            case Mnemonic.Cmpsb: cmpsb(in instruction); break;
            case Mnemonic.Cmpsw: cmpsw(in instruction); break;
            case Mnemonic.Cmpxchg: cmpxchg(in instruction); break;
            case Mnemonic.Cmpxchg8b: cmpxchg8b(in instruction); break;
            case Mnemonic.Comisd: comisd(in instruction); break;
            case Mnemonic.Comiss: comiss(in instruction); break;
            case Mnemonic.Crc32: crc32(in instruction); break;
            case Mnemonic.Cvtdq2pd: cvtdq2pd(in instruction); break;
            case Mnemonic.Cvtdq2ps: cvtdq2ps(in instruction); break;
            case Mnemonic.Cvtpd2dq: cvtpd2dq(in instruction); break;
            case Mnemonic.Cvtpd2pi: cvtpd2pi(in instruction); break;
            case Mnemonic.Cvtpd2ps: cvtpd2ps(in instruction); break;
            case Mnemonic.Cvtpi2pd: cvtpi2pd(in instruction); break;
            case Mnemonic.Cvtpi2ps: cvtpi2ps(in instruction); break;
            case Mnemonic.Cvtps2dq: cvtps2dq(in instruction); break;
            case Mnemonic.Cvtps2pd: cvtps2pd(in instruction); break;
            case Mnemonic.Cvtsd2si: cvtsd2si(in instruction); break;
            case Mnemonic.Cvtsd2ss: cvtsd2ss(in instruction); break;
            case Mnemonic.Cvtsi2sd: cvtsi2sd(in instruction); break;
            case Mnemonic.Cvtsi2ss: cvtsi2ss(in instruction); break;
            case Mnemonic.Cvtss2sd: cvtss2sd(in instruction); break;
            case Mnemonic.Cvtss2si: cvtss2si(in instruction); break;
            case Mnemonic.Cvttpd2dq: cvttpd2dq(in instruction); break;
            case Mnemonic.Cvttpd2pi: cvttpd2pi(in instruction); break;
            case Mnemonic.Cvttps2dq: cvttps2dq(in instruction); break;
            case Mnemonic.Cvttps2pi: cvttps2pi(in instruction); break;
            case Mnemonic.Cvttsd2si: cvttsd2si(in instruction); break;
            case Mnemonic.Cvttss2si: cvttss2si(in instruction); break;
            case Mnemonic.Cwd: cwd(in instruction); break;
            case Mnemonic.Cwde: cwde(in instruction); break;
            case Mnemonic.Daa: daa(in instruction); break;
            case Mnemonic.Das: das(in instruction); break;
            case Mnemonic.Dec: dec(in instruction); break;
            case Mnemonic.Div: div(in instruction); break;
            case Mnemonic.Divpd: divpd(in instruction); break;
            case Mnemonic.Divps: divps(in instruction); break;
            case Mnemonic.Divsd: divsd(in instruction); break;
            case Mnemonic.Divss: divss(in instruction); break;
            case Mnemonic.Dppd: dppd(in instruction); break;
            case Mnemonic.Dpps: dpps(in instruction); break;
            case Mnemonic.Enter: enter(in instruction); break;
            case Mnemonic.Extractps: extractps(in instruction); break;
            case Mnemonic.Fldcw: fldcw(in instruction); break;
            case Mnemonic.Fnclex: fnclex(in instruction); break;
            case Mnemonic.Fninit: fninit(in instruction); break;
            case Mnemonic.Fnstcw: fnstcw(in instruction); break;
            case Mnemonic.Fnstsw: fnstsw(in instruction); break;
            case Mnemonic.Haddpd: haddpd(in instruction); break;
            case Mnemonic.Haddps: haddps(in instruction); break;
            case Mnemonic.Hlt: hlt(in instruction); break;
            case Mnemonic.Hsubpd: hsubpd(in instruction); break;
            case Mnemonic.Hsubps: hsubps(in instruction); break;
            case Mnemonic.Idiv: idiv(in instruction); break;
            case Mnemonic.In: @in(in instruction); break;
            case Mnemonic.Inc: inc(in instruction); break;
            case Mnemonic.Insb: insb(in instruction); break;
            case Mnemonic.Insd: insd(in instruction); break;
            case Mnemonic.Insertps: insertps(in instruction); break;
            case Mnemonic.Insw: insw(in instruction); break;
            case Mnemonic.Ja: ja(in instruction); break;
            case Mnemonic.Jae: jae(in instruction); break;
            case Mnemonic.Jb: jb(in instruction); break;
            case Mnemonic.Jbe: jbe(in instruction); break;
            case Mnemonic.Jcxz: jcxz(in instruction); break;
            case Mnemonic.Je: je(in instruction); break;
            case Mnemonic.Jecxz: jecxz(in instruction); break;
            case Mnemonic.Jg: jg(in instruction); break;
            case Mnemonic.Jge: jge(in instruction); break;
            case Mnemonic.Jl: jl(in instruction); break;
            case Mnemonic.Jle: jle(in instruction); break;
            case Mnemonic.Jmp: jmp(in instruction); break;
            case Mnemonic.Jne: jne(in instruction); break;
            case Mnemonic.Jno: jno(in instruction); break;
            case Mnemonic.Jnp: jnp(in instruction); break;
            case Mnemonic.Jns: jns(in instruction); break;
            case Mnemonic.Jo: jo(in instruction); break;
            case Mnemonic.Jp: jp(in instruction); break;
            case Mnemonic.Js: js(in instruction); break;
            case Mnemonic.Kaddb: kaddb(in instruction); break;
            case Mnemonic.Kaddd: kaddd(in instruction); break;
            case Mnemonic.Kaddq: kaddq(in instruction); break;
            case Mnemonic.Kaddw: kaddw(in instruction); break;
            case Mnemonic.Kandb: kandb(in instruction); break;
            case Mnemonic.Kandd: kandd(in instruction); break;
            case Mnemonic.Kandnb: kandnb(in instruction); break;
            case Mnemonic.Kandnd: kandnd(in instruction); break;
            case Mnemonic.Kandnq: kandnq(in instruction); break;
            case Mnemonic.Kandnw: kandnw(in instruction); break;
            case Mnemonic.Kandq: kandq(in instruction); break;
            case Mnemonic.Kandw: kandw(in instruction); break;
            case Mnemonic.Korb: korb(in instruction); break;
            case Mnemonic.Kord: kord(in instruction); break;
            case Mnemonic.Korq: korq(in instruction); break;
            case Mnemonic.Korw: korw(in instruction); break;
            case Mnemonic.Kshiftlb: kshiftlb(in instruction); break;
            case Mnemonic.Kshiftld: kshiftld(in instruction); break;
            case Mnemonic.Kshiftlq: kshiftlq(in instruction); break;
            case Mnemonic.Kshiftlw: kshiftlw(in instruction); break;
            case Mnemonic.Kshiftrb: kshiftrb(in instruction); break;
            case Mnemonic.Kshiftrd: kshiftrd(in instruction); break;
            case Mnemonic.Kshiftrq: kshiftrq(in instruction); break;
            case Mnemonic.Kshiftrw: kshiftrw(in instruction); break;
            case Mnemonic.Kxnorb: kxnorb(in instruction); break;
            case Mnemonic.Kxnord: kxnord(in instruction); break;
            case Mnemonic.Kxnorq: kxnorq(in instruction); break;
            case Mnemonic.Kxnorw: kxnorw(in instruction); break;
            case Mnemonic.Kxorb: kxorb(in instruction); break;
            case Mnemonic.Kxord: kxord(in instruction); break;
            case Mnemonic.Kxorq: kxorq(in instruction); break;
            case Mnemonic.Kxorw: kxorw(in instruction); break;
            case Mnemonic.Lahf: lahf(in instruction); break;
            case Mnemonic.Lddqu: lddqu(in instruction); break;
            case Mnemonic.Ldmxcsr: ldmxcsr(in instruction); break;
            case Mnemonic.Leave: leave(in instruction); break;
            case Mnemonic.Lodsd: lodsd(in instruction); break;
            case Mnemonic.Lsl: lsl(in instruction); break;
            case Mnemonic.Lzcnt: lzcnt(in instruction); break;
            case Mnemonic.Maskmovdqu: maskmovdqu(in instruction); break;
            case Mnemonic.Maxpd: maxpd(in instruction); break;
            case Mnemonic.Maxps: maxps(in instruction); break;
            case Mnemonic.Maxsd: maxsd(in instruction); break;
            case Mnemonic.Maxss: maxss(in instruction); break;
            case Mnemonic.Minpd: minpd(in instruction); break;
            case Mnemonic.Minps: minps(in instruction); break;
            case Mnemonic.Minsd: minsd(in instruction); break;
            case Mnemonic.Minss: minss(in instruction); break;
            case Mnemonic.Mov: mov(in instruction); break;
            case Mnemonic.Movapd: movapd(in instruction); break;
            case Mnemonic.Movaps: movaps(in instruction); break;
            case Mnemonic.Movbe: movbe(in instruction); break;
            case Mnemonic.Movd: movd(in instruction); break;
            case Mnemonic.Movddup: movddup(in instruction); break;
            case Mnemonic.Movdir64b: movdir64b(in instruction); break;
            case Mnemonic.Movdiri: movdiri(in instruction); break;
            case Mnemonic.Movdq2q: movdq2q(in instruction); break;
            case Mnemonic.Movdqa: movdqa(in instruction); break;
            case Mnemonic.Movdqu: movdqu(in instruction); break;
            case Mnemonic.Movhlps: movhlps(in instruction); break;
            case Mnemonic.Movhpd: movhpd(in instruction); break;
            case Mnemonic.Movhps: movhps(in instruction); break;
            case Mnemonic.Movlhps: movlhps(in instruction); break;
            case Mnemonic.Movlpd: movlpd(in instruction); break;
            case Mnemonic.Movlps: movlps(in instruction); break;
            case Mnemonic.Movmskpd: movmskpd(in instruction); break;
            case Mnemonic.Movmskps: movmskps(in instruction); break;
            case Mnemonic.Movntdqa: movntdqa(in instruction); break;
            case Mnemonic.Movntpd: movntpd(in instruction); break;
            case Mnemonic.Movntps: movntps(in instruction); break;
            case Mnemonic.Movq: movq(in instruction); break;
            case Mnemonic.Movq2dq: movq2dq(in instruction); break;
            case Mnemonic.Movsd: movsd(in instruction); break;
            case Mnemonic.Movshdup: movshdup(in instruction); break;
            case Mnemonic.Movsldup: movsldup(in instruction); break;
            case Mnemonic.Movss: movss(in instruction); break;
            case Mnemonic.Movsx: movsx(in instruction); break;
            case Mnemonic.Movupd: movupd(in instruction); break;
            case Mnemonic.Movups: movups(in instruction); break;
            case Mnemonic.Movzx: movzx(in instruction); break;
            case Mnemonic.Mpsadbw: mpsadbw(in instruction); break;
            case Mnemonic.Mulpd: mulpd(in instruction); break;
            case Mnemonic.Mulps: mulps(in instruction); break;
            case Mnemonic.Mulsd: mulsd(in instruction); break;
            case Mnemonic.Mulss: mulss(in instruction); break;
            case Mnemonic.Neg: neg(in instruction); break;
            case Mnemonic.Nop: nop(in instruction); break;
            case Mnemonic.Not: not(in instruction); break;
            case Mnemonic.Or: or(in instruction); break;
            case Mnemonic.Orpd: orpd(in instruction); break;
            case Mnemonic.Orps: orps(in instruction); break;
            case Mnemonic.Out: @out(in instruction); break;
            case Mnemonic.Outsb: outsb(in instruction); break;
            case Mnemonic.Outsd: outsd(in instruction); break;
            case Mnemonic.Outsw: outsw(in instruction); break;
            case Mnemonic.Pabsb: pabsb(in instruction); break;
            case Mnemonic.Pabsd: pabsd(in instruction); break;
            case Mnemonic.Pabsw: pabsw(in instruction); break;
            case Mnemonic.Paddb: paddb(in instruction); break;
            case Mnemonic.Paddd: paddd(in instruction); break;
            case Mnemonic.Paddq: paddq(in instruction); break;
            case Mnemonic.Paddw: paddw(in instruction); break;
            case Mnemonic.Pand: pand(in instruction); break;
            case Mnemonic.Pandn: pandn(in instruction); break;
            case Mnemonic.Pavgb: pavgb(in instruction); break;
            case Mnemonic.Pavgw: pavgw(in instruction); break;
            case Mnemonic.Pblendvb: pblendvb(in instruction); break;
            case Mnemonic.Pblendw: pblendw(in instruction); break;
            case Mnemonic.Pcmpeqb: pcmpeqb(in instruction); break;
            case Mnemonic.Pcmpeqd: pcmpeqd(in instruction); break;
            case Mnemonic.Pcmpeqq: pcmpeqq(in instruction); break;
            case Mnemonic.Pcmpeqw: pcmpeqw(in instruction); break;
            case Mnemonic.Pcmpestri: pcmpestri(in instruction); break;
            case Mnemonic.Pcmpestrm: pcmpestrm(in instruction); break;
            case Mnemonic.Pcmpgtb: pcmpgtb(in instruction); break;
            case Mnemonic.Pcmpgtd: pcmpgtd(in instruction); break;
            case Mnemonic.Pcmpgtq: pcmpgtq(in instruction); break;
            case Mnemonic.Pcmpgtw: pcmpgtw(in instruction); break;
            case Mnemonic.Pcmpistri: pcmpistri(in instruction); break;
            case Mnemonic.Pcmpistrm: pcmpistrm(in instruction); break;
            case Mnemonic.Pextrb: pextrb(in instruction); break;
            case Mnemonic.Pextrd: pextrd(in instruction); break;
            case Mnemonic.Pextrq: pextrq(in instruction); break;
            case Mnemonic.Pextrw: pextrw(in instruction); break;
            case Mnemonic.Phaddd: phaddd(in instruction); break;
            case Mnemonic.Phaddw: phaddw(in instruction); break;
            case Mnemonic.Phminposuw: phminposuw(in instruction); break;
            case Mnemonic.Phsubd: phsubd(in instruction); break;
            case Mnemonic.Phsubw: phsubw(in instruction); break;
            case Mnemonic.Pinsrb: pinsrb(in instruction); break;
            case Mnemonic.Pinsrd: pinsrd(in instruction); break;
            case Mnemonic.Pinsrq: pinsrq(in instruction); break;
            case Mnemonic.Pinsrw: pinsrw(in instruction); break;
            case Mnemonic.Pmaddubsw: pmaddubsw(in instruction); break;
            case Mnemonic.Pmaxsb: pmaxsb(in instruction); break;
            case Mnemonic.Pmaxsd: pmaxsd(in instruction); break;
            case Mnemonic.Pmaxub: pmaxub(in instruction); break;
            case Mnemonic.Pmaxud: pmaxud(in instruction); break;
            case Mnemonic.Pmaxuw: pmaxuw(in instruction); break;
            case Mnemonic.Pminsb: pminsb(in instruction); break;
            case Mnemonic.Pminsd: pminsd(in instruction); break;
            case Mnemonic.Pminub: pminub(in instruction); break;
            case Mnemonic.Pminud: pminud(in instruction); break;
            case Mnemonic.Pminuw: pminuw(in instruction); break;
            case Mnemonic.Pmovmskb: pmovmskb(in instruction); break;
            case Mnemonic.Pmovsxbd: pmovsxbd(in instruction); break;
            case Mnemonic.Pmovsxbq: pmovsxbq(in instruction); break;
            case Mnemonic.Pmovsxbw: pmovsxbw(in instruction); break;
            case Mnemonic.Pmovsxdq: pmovsxdq(in instruction); break;
            case Mnemonic.Pmovsxwd: pmovsxwd(in instruction); break;
            case Mnemonic.Pmovsxwq: pmovsxwq(in instruction); break;
            case Mnemonic.Pmovzxbd: pmovzxbd(in instruction); break;
            case Mnemonic.Pmovzxbq: pmovzxbq(in instruction); break;
            case Mnemonic.Pmovzxbw: pmovzxbw(in instruction); break;
            case Mnemonic.Pmovzxdq: pmovzxdq(in instruction); break;
            case Mnemonic.Pmovzxwd: pmovzxwd(in instruction); break;
            case Mnemonic.Pmovzxwq: pmovzxwq(in instruction); break;
            case Mnemonic.Pmuldq: pmuldq(in instruction); break;
            case Mnemonic.Pmulhrsw: pmulhrsw(in instruction); break;
            case Mnemonic.Pmulhuw: pmulhuw(in instruction); break;
            case Mnemonic.Pmulhw: pmulhw(in instruction); break;
            case Mnemonic.Pmulld: pmulld(in instruction); break;
            case Mnemonic.Pmuludq: pmuludq(in instruction); break;
            case Mnemonic.Popa: popa(in instruction); break;
            case Mnemonic.Popad: popad(in instruction); break;
            case Mnemonic.Popcnt: popcnt(in instruction); break;
            case Mnemonic.Popf: popf(in instruction); break;
            case Mnemonic.Popfd: popfd(in instruction); break;
            case Mnemonic.Por: por(in instruction); break;
            case Mnemonic.Pshufb: pshufb(in instruction); break;
            case Mnemonic.Psignb: psignb(in instruction); break;
            case Mnemonic.Psignd: psignd(in instruction); break;
            case Mnemonic.Psignw: psignw(in instruction); break;
            case Mnemonic.Pslld: pslld(in instruction); break;
            case Mnemonic.Psllq: psllq(in instruction); break;
            case Mnemonic.Psllw: psllw(in instruction); break;
            case Mnemonic.Psrad: psrad(in instruction); break;
            case Mnemonic.Psraw: psraw(in instruction); break;
            case Mnemonic.Psrld: psrld(in instruction); break;
            case Mnemonic.Psrlq: psrlq(in instruction); break;
            case Mnemonic.Psrlw: psrlw(in instruction); break;
            case Mnemonic.Psubb: psubb(in instruction); break;
            case Mnemonic.Psubd: psubd(in instruction); break;
            case Mnemonic.Psubq: psubq(in instruction); break;
            case Mnemonic.Psubw: psubw(in instruction); break;
            case Mnemonic.Ptest: ptest(in instruction); break;
            case Mnemonic.Punpckhbw: punpckhbw(in instruction); break;
            case Mnemonic.Punpckhdq: punpckhdq(in instruction); break;
            case Mnemonic.Punpckhwd: punpckhwd(in instruction); break;
            case Mnemonic.Pusha: pusha(in instruction); break;
            case Mnemonic.Pushad: pushad(in instruction); break;
            case Mnemonic.Pushf: pushf(in instruction); break;
            case Mnemonic.Pushfd: pushfd(in instruction); break;
            case Mnemonic.Pxor: pxor(in instruction); break;
            case Mnemonic.Rcpps: rcpps(in instruction); break;
            case Mnemonic.Rcpss: rcpss(in instruction); break;
            case Mnemonic.Rdfsbase: rdfsbase(in instruction); break;
            case Mnemonic.Rdgsbase: rdgsbase(in instruction); break;
            case Mnemonic.Rdmsr: rdmsr(in instruction); break;
            case Mnemonic.Rdpkru: rdpkru(in instruction); break;
            case Mnemonic.Rdrand: rdrand(in instruction); break;
            case Mnemonic.Rdseed: rdseed(in instruction); break;
            case Mnemonic.Rdtsc: rdtsc(in instruction); break;
            case Mnemonic.Rol: rol(in instruction); break;
            case Mnemonic.Ror: ror(in instruction); break;
            case Mnemonic.Roundpd: roundpd(in instruction); break;
            case Mnemonic.Roundps: roundps(in instruction); break;
            case Mnemonic.Roundsd: roundsd(in instruction); break;
            case Mnemonic.Roundss: roundss(in instruction); break;
            case Mnemonic.Rsqrtps: rsqrtps(in instruction); break;
            case Mnemonic.Rsqrtss: rsqrtss(in instruction); break;
            case Mnemonic.Sahf: sahf(in instruction); break;
            case Mnemonic.Sbb: sbb(in instruction); break;
            case Mnemonic.Scasd: scasd(in instruction); break;
            case Mnemonic.Seta: seta(in instruction); break;
            case Mnemonic.Setae: setae(in instruction); break;
            case Mnemonic.Setb: setb(in instruction); break;
            case Mnemonic.Setbe: setbe(in instruction); break;
            case Mnemonic.Sete: sete(in instruction); break;
            case Mnemonic.Setg: setg(in instruction); break;
            case Mnemonic.Setge: setge(in instruction); break;
            case Mnemonic.Setl: setl(in instruction); break;
            case Mnemonic.Setle: setle(in instruction); break;
            case Mnemonic.Setne: setne(in instruction); break;
            case Mnemonic.Setno: setno(in instruction); break;
            case Mnemonic.Setnp: setnp(in instruction); break;
            case Mnemonic.Setns: setns(in instruction); break;
            case Mnemonic.Seto: seto(in instruction); break;
            case Mnemonic.Setp: setp(in instruction); break;
            case Mnemonic.Sets: sets(in instruction); break;
            case Mnemonic.Shl: shl(in instruction); break;
            case Mnemonic.Shld: shld(in instruction); break;
            case Mnemonic.Shr: shr(in instruction); break;
            case Mnemonic.Shrd: shrd(in instruction); break;
            case Mnemonic.Shufpd: shufpd(in instruction); break;
            case Mnemonic.Shufps: shufps(in instruction); break;
            case Mnemonic.Sqrtpd: sqrtpd(in instruction); break;
            case Mnemonic.Sqrtps: sqrtps(in instruction); break;
            case Mnemonic.Sqrtsd: sqrtsd(in instruction); break;
            case Mnemonic.Sqrtss: sqrtss(in instruction); break;
            case Mnemonic.Stac: stac(in instruction); break;
            case Mnemonic.Stc: stc(in instruction); break;
            case Mnemonic.Std: std(in instruction); break;
            case Mnemonic.Sti: sti(in instruction); break;
            case Mnemonic.Stmxcsr: stmxcsr(in instruction); break;
            case Mnemonic.Stosd: stosd(in instruction); break;
            case Mnemonic.Str: str(in instruction); break;
            case Mnemonic.Sub: sub(in instruction); break;
            case Mnemonic.Subpd: subpd(in instruction); break;
            case Mnemonic.Subps: subps(in instruction); break;
            case Mnemonic.Subsd: subsd(in instruction); break;
            case Mnemonic.Subss: subss(in instruction); break;
            case Mnemonic.Tzcnt: tzcnt(in instruction); break;
            case Mnemonic.Ucomisd: ucomisd(in instruction); break;
            case Mnemonic.Ucomiss: ucomiss(in instruction); break;
            case Mnemonic.Ud0: ud0(in instruction); break;
            case Mnemonic.Ud1: ud1(in instruction); break;
            case Mnemonic.Ud2: ud2(in instruction); break;
            case Mnemonic.Unpckhps: unpckhps(in instruction); break;
            case Mnemonic.Unpcklps: unpcklps(in instruction); break;
            case Mnemonic.V4fmaddps: v4fmaddps(in instruction); break;
            case Mnemonic.V4fmaddss: v4fmaddss(in instruction); break;
            case Mnemonic.V4fnmaddps: v4fnmaddps(in instruction); break;
            case Mnemonic.V4fnmaddss: v4fnmaddss(in instruction); break;
            case Mnemonic.Vaddpd: vaddpd(in instruction); break;
            case Mnemonic.Vaddph: vaddph(in instruction); break;
            case Mnemonic.Vaddps: vaddps(in instruction); break;
            case Mnemonic.Vaddsd: vaddsd(in instruction); break;
            case Mnemonic.Vaddsh: vaddsh(in instruction); break;
            case Mnemonic.Vaddss: vaddss(in instruction); break;
            case Mnemonic.Valignd: valignd(in instruction); break;
            case Mnemonic.Valignq: valignq(in instruction); break;
            case Mnemonic.Vandnpd: vandnpd(in instruction); break;
            case Mnemonic.Vandnps: vandnps(in instruction); break;
            case Mnemonic.Vandpd: vandpd(in instruction); break;
            case Mnemonic.Vandps: vandps(in instruction); break;
            case Mnemonic.Vblendmpd: vblendmpd(in instruction); break;
            case Mnemonic.Vblendmps: vblendmps(in instruction); break;
            case Mnemonic.Vbroadcasti32x2: vbroadcasti32x2(in instruction); break;
            case Mnemonic.Vbroadcasti32x4: vbroadcasti32x4(in instruction); break;
            case Mnemonic.Vbroadcasti32x8: vbroadcasti32x8(in instruction); break;
            case Mnemonic.Vbroadcasti64x2: vbroadcasti64x2(in instruction); break;
            case Mnemonic.Vbroadcasti64x4: vbroadcasti64x4(in instruction); break;
            case Mnemonic.Vbroadcastsd: vbroadcastsd(in instruction); break;
            case Mnemonic.Vbroadcastss: vbroadcastss(in instruction); break;
            case Mnemonic.Vcmppd: vcmppd(in instruction); break;
            case Mnemonic.Vcmpps: vcmpps(in instruction); break;
            case Mnemonic.Vcmpsd: vcmpsd(in instruction); break;
            case Mnemonic.Vcmpss: vcmpss(in instruction); break;
            case Mnemonic.Vcomisd: vcomisd(in instruction); break;
            case Mnemonic.Vcomiss: vcomiss(in instruction); break;
            case Mnemonic.Vcompresspd: vcompresspd(in instruction); break;
            case Mnemonic.Vcompressps: vcompressps(in instruction); break;
            case Mnemonic.Vcvtdq2pd: vcvtdq2pd(in instruction); break;
            case Mnemonic.Vcvtdq2ps: vcvtdq2ps(in instruction); break;
            case Mnemonic.Vcvtpd2dq: vcvtpd2dq(in instruction); break;
            case Mnemonic.Vcvtpd2ps: vcvtpd2ps(in instruction); break;
            case Mnemonic.Vcvtph2ps: vcvtph2ps(in instruction); break;
            case Mnemonic.Vcvtps2dq: vcvtps2dq(in instruction); break;
            case Mnemonic.Vcvtps2pd: vcvtps2pd(in instruction); break;
            case Mnemonic.Vcvtsd2si: vcvtsd2si(in instruction); break;
            case Mnemonic.Vcvtsd2ss: vcvtsd2ss(in instruction); break;
            case Mnemonic.Vcvtsi2sd: vcvtsi2sd(in instruction); break;
            case Mnemonic.Vcvtsi2ss: vcvtsi2ss(in instruction); break;
            case Mnemonic.Vcvtss2sd: vcvtss2sd(in instruction); break;
            case Mnemonic.Vcvtss2si: vcvtss2si(in instruction); break;
            case Mnemonic.Vcvttpd2dq: vcvttpd2dq(in instruction); break;
            case Mnemonic.Vcvttps2dq: vcvttps2dq(in instruction); break;
            case Mnemonic.Vcvttsd2si: vcvttsd2si(in instruction); break;
            case Mnemonic.Vcvttss2si: vcvttss2si(in instruction); break;
            case Mnemonic.Vdivpd: vdivpd(in instruction); break;
            case Mnemonic.Vdivph: vdivph(in instruction); break;
            case Mnemonic.Vdivps: vdivps(in instruction); break;
            case Mnemonic.Vdivsd: vdivsd(in instruction); break;
            case Mnemonic.Vdivsh: vdivsh(in instruction); break;
            case Mnemonic.Vdivss: vdivss(in instruction); break;
            case Mnemonic.Vexp2pd: vexp2pd(in instruction); break;
            case Mnemonic.Vexp2ps: vexp2ps(in instruction); break;
            case Mnemonic.Vexpandpd: vexpandpd(in instruction); break;
            case Mnemonic.Vexpandps: vexpandps(in instruction); break;
            case Mnemonic.Vextractf128: vextractf128(in instruction); break;
            case Mnemonic.Vextractps: vextractps(in instruction); break;
            case Mnemonic.Vfmadd132pd: Vfmadd132pd(in instruction); break;
            case Mnemonic.Vfmadd132ph: Vfmadd132ph(in instruction); break;
            case Mnemonic.Vfmadd132ps: Vfmadd132ps(in instruction); break;
            case Mnemonic.Vfmadd132sd: Vfmadd132sd(in instruction); break;
            case Mnemonic.Vfmadd132sh: Vfmadd132sh(in instruction); break;
            case Mnemonic.Vfmadd132ss: Vfmadd132ss(in instruction); break;
            case Mnemonic.Vfmadd213pd: Vfmadd213pd(in instruction); break;
            case Mnemonic.Vfmadd213ph: Vfmadd213ph(in instruction); break;
            case Mnemonic.Vfmadd213ps: Vfmadd213ps(in instruction); break;
            case Mnemonic.Vfmadd213sd: Vfmadd213sd(in instruction); break;
            case Mnemonic.Vfmadd213sh: Vfmadd213sh(in instruction); break;
            case Mnemonic.Vfmadd213ss: Vfmadd213ss(in instruction); break;
            case Mnemonic.Vfmadd231pd: Vfmadd231pd(in instruction); break;
            case Mnemonic.Vfmadd231ph: Vfmadd231ph(in instruction); break;
            case Mnemonic.Vfmadd231ps: Vfmadd231ps(in instruction); break;
            case Mnemonic.Vfmadd231sd: Vfmadd231sd(in instruction); break;
            case Mnemonic.Vfmadd231sh: Vfmadd231sh(in instruction); break;
            case Mnemonic.Vfmadd231ss: Vfmadd231ss(in instruction); break;
            case Mnemonic.Vfmaddsub132pd: Vfmaddsub132pd(in instruction); break;
            case Mnemonic.Vfmaddsub132ph: Vfmaddsub132ph(in instruction); break;
            case Mnemonic.Vfmaddsub132ps: Vfmaddsub132ps(in instruction); break;
            case Mnemonic.Vfmaddsub213pd: Vfmaddsub213pd(in instruction); break;
            case Mnemonic.Vfmaddsub213ph: Vfmaddsub213ph(in instruction); break;
            case Mnemonic.Vfmaddsub213ps: Vfmaddsub213ps(in instruction); break;
            case Mnemonic.Vfmaddsub231pd: Vfmaddsub231pd(in instruction); break;
            case Mnemonic.Vfmaddsub231ph: Vfmaddsub231ph(in instruction); break;
            case Mnemonic.Vfmaddsub231ps: Vfmaddsub231ps(in instruction); break;
            case Mnemonic.Vfmsub132pd: Vfmsub132pd(in instruction); break;
            case Mnemonic.Vfmsub132ph: Vfmsub132ph(in instruction); break;
            case Mnemonic.Vfmsub132ps: Vfmsub132ps(in instruction); break;
            case Mnemonic.Vfmsub132sd: Vfmsub132sd(in instruction); break;
            case Mnemonic.Vfmsub132sh: Vfmsub132sh(in instruction); break;
            case Mnemonic.Vfmsub132ss: Vfmsub132ss(in instruction); break;
            case Mnemonic.Vfmsub213pd: Vfmsub213pd(in instruction); break;
            case Mnemonic.Vfmsub213ph: Vfmsub213ph(in instruction); break;
            case Mnemonic.Vfmsub213ps: Vfmsub213ps(in instruction); break;
            case Mnemonic.Vfmsub213sd: Vfmsub213sd(in instruction); break;
            case Mnemonic.Vfmsub213sh: Vfmsub213sh(in instruction); break;
            case Mnemonic.Vfmsub213ss: Vfmsub213ss(in instruction); break;
            case Mnemonic.Vfmsub231pd: Vfmsub231pd(in instruction); break;
            case Mnemonic.Vfmsub231ph: Vfmsub231ph(in instruction); break;
            case Mnemonic.Vfmsub231ps: Vfmsub231ps(in instruction); break;
            case Mnemonic.Vfmsub231sd: Vfmsub231sd(in instruction); break;
            case Mnemonic.Vfmsub231sh: Vfmsub231sh(in instruction); break;
            case Mnemonic.Vfmsub231ss: Vfmsub231ss(in instruction); break;
            case Mnemonic.Vfmsubadd132pd: Vfmsubadd132pd(in instruction); break;
            case Mnemonic.Vfmsubadd132ph: Vfmsubadd132ph(in instruction); break;
            case Mnemonic.Vfmsubadd132ps: Vfmsubadd132ps(in instruction); break;
            case Mnemonic.Vfmsubadd213pd: Vfmsubadd213pd(in instruction); break;
            case Mnemonic.Vfmsubadd213ph: Vfmsubadd213ph(in instruction); break;
            case Mnemonic.Vfmsubadd213ps: Vfmsubadd213ps(in instruction); break;
            case Mnemonic.Vfmsubadd231pd: Vfmsubadd231pd(in instruction); break;
            case Mnemonic.Vfmsubadd231ph: Vfmsubadd231ph(in instruction); break;
            case Mnemonic.Vfmsubadd231ps: Vfmsubadd231ps(in instruction); break;
            case Mnemonic.Vfnmadd132pd: Vfnmadd132pd(in instruction); break;
            case Mnemonic.Vfnmadd132ph: Vfnmadd132ph(in instruction); break;
            case Mnemonic.Vfnmadd132ps: Vfnmadd132ps(in instruction); break;
            case Mnemonic.Vfnmadd132sd: Vfnmadd132sd(in instruction); break;
            case Mnemonic.Vfnmadd132sh: Vfnmadd132sh(in instruction); break;
            case Mnemonic.Vfnmadd132ss: Vfnmadd132ss(in instruction); break;
            case Mnemonic.Vfnmadd213pd: Vfnmadd213pd(in instruction); break;
            case Mnemonic.Vfnmadd213ph: Vfnmadd213ph(in instruction); break;
            case Mnemonic.Vfnmadd213ps: Vfnmadd213ps(in instruction); break;
            case Mnemonic.Vfnmadd213sd: Vfnmadd213sd(in instruction); break;
            case Mnemonic.Vfnmadd213sh: Vfnmadd213sh(in instruction); break;
            case Mnemonic.Vfnmadd213ss: Vfnmadd213ss(in instruction); break;
            case Mnemonic.Vfnmadd231pd: Vfnmadd231pd(in instruction); break;
            case Mnemonic.Vfnmadd231ph: Vfnmadd231ph(in instruction); break;
            case Mnemonic.Vfnmadd231ps: Vfnmadd231ps(in instruction); break;
            case Mnemonic.Vfnmadd231sd: Vfnmadd231sd(in instruction); break;
            case Mnemonic.Vfnmadd231sh: Vfnmadd231sh(in instruction); break;
            case Mnemonic.Vfnmadd231ss: Vfnmadd231ss(in instruction); break;
            case Mnemonic.Vfnmsub132pd: Vfnmsub132pd(in instruction); break;
            case Mnemonic.Vfnmsub132ph: Vfnmsub132ph(in instruction); break;
            case Mnemonic.Vfnmsub132ps: Vfnmsub132ps(in instruction); break;
            case Mnemonic.Vfnmsub132sd: Vfnmsub132sd(in instruction); break;
            case Mnemonic.Vfnmsub132sh: Vfnmsub132sh(in instruction); break;
            case Mnemonic.Vfnmsub132ss: Vfnmsub132ss(in instruction); break;
            case Mnemonic.Vfnmsub213pd: Vfnmsub213pd(in instruction); break;
            case Mnemonic.Vfnmsub213ph: Vfnmsub213ph(in instruction); break;
            case Mnemonic.Vfnmsub213ps: Vfnmsub213ps(in instruction); break;
            case Mnemonic.Vfnmsub213sd: Vfnmsub213sd(in instruction); break;
            case Mnemonic.Vfnmsub213sh: Vfnmsub213sh(in instruction); break;
            case Mnemonic.Vfnmsub213ss: Vfnmsub213ss(in instruction); break;
            case Mnemonic.Vfnmsub231pd: Vfnmsub231pd(in instruction); break;
            case Mnemonic.Vfnmsub231ph: Vfnmsub231ph(in instruction); break;
            case Mnemonic.Vfnmsub231ps: Vfnmsub231ps(in instruction); break;
            case Mnemonic.Vfnmsub231sd: Vfnmsub231sd(in instruction); break;
            case Mnemonic.Vfnmsub231sh: Vfnmsub231sh(in instruction); break;
            case Mnemonic.Vfnmsub231ss: Vfnmsub231ss(in instruction); break;
            case Mnemonic.Vgetexppd: vgetexppd(in instruction); break;
            case Mnemonic.Vgetexpph: vgetexpph(in instruction); break;
            case Mnemonic.Vgetexpps: vgetexpps(in instruction); break;
            case Mnemonic.Vgetexpsh: vgetexpsh(in instruction); break;
            case Mnemonic.Vgetmantph: vgetmantph(in instruction); break;
            case Mnemonic.Vgetmantsh: vgetmantsh(in instruction); break;
            case Mnemonic.Vgf2p8affineinvqb: vgf2p8affineinvqb(in instruction); break;
            case Mnemonic.Vgf2p8affineqb: vgf2p8affineqb(in instruction); break;
            case Mnemonic.Vgf2p8mulb: vgf2p8mulb(in instruction); break;
            case Mnemonic.Vinsertf128: vinsertf128(in instruction); break;
            case Mnemonic.Vinsertps: vinsertps(in instruction); break;
            case Mnemonic.Vmaskmovpd: vmaskmovpd(in instruction); break;
            case Mnemonic.Vmaskmovps: vmaskmovps(in instruction); break;
            case Mnemonic.Vmaxpd: vmaxpd(in instruction); break;
            case Mnemonic.Vmaxps: vmaxps(in instruction); break;
            case Mnemonic.Vmaxsd: vmaxsd(in instruction); break;
            case Mnemonic.Vmaxss: vmaxss(in instruction); break;
            case Mnemonic.Vminpd: vminpd(in instruction); break;
            case Mnemonic.Vminps: vminps(in instruction); break;
            case Mnemonic.Vminsd: vminsd(in instruction); break;
            case Mnemonic.Vminss: vminss(in instruction); break;
            case Mnemonic.Vmovapd: vmovapd(in instruction); break;
            case Mnemonic.Vmovaps: vmovaps(in instruction); break;
            case Mnemonic.Vmovd: vmovd(in instruction); break;
            case Mnemonic.Vmovddup: vmovddup(in instruction); break;
            case Mnemonic.Vmovhlps: vmovhlps(in instruction); break;
            case Mnemonic.Vmovhpd: vmovhpd(in instruction); break;
            case Mnemonic.Vmovhps: vmovhps(in instruction); break;
            case Mnemonic.Vmovlhps: vmovlhps(in instruction); break;
            case Mnemonic.Vmovlpd: vmovlpd(in instruction); break;
            case Mnemonic.Vmovlps: vmovlps(in instruction); break;
            case Mnemonic.Vmovntdqa: vmovntdqa(in instruction); break;
            case Mnemonic.Vmovq: vmovq(in instruction); break;
            case Mnemonic.Vmovsd: vmovsd(in instruction); break;
            case Mnemonic.Vmovsh: vmovsh(in instruction); break;
            case Mnemonic.Vmovshdup: vmovshdup(in instruction); break;
            case Mnemonic.Vmovsldup: vmovsldup(in instruction); break;
            case Mnemonic.Vmovss: vmovss(in instruction); break;
            case Mnemonic.Vmovupd: vmovupd(in instruction); break;
            case Mnemonic.Vmovups: vmovups(in instruction); break;
            case Mnemonic.Vmovw: vmovw(in instruction); break;
            case Mnemonic.Vmulpd: vmulpd(in instruction); break;
            case Mnemonic.Vmulph: vmulph(in instruction); break;
            case Mnemonic.Vmulps: vmulps(in instruction); break;
            case Mnemonic.Vmulsd: vmulsd(in instruction); break;
            case Mnemonic.Vmulsh: vmulsh(in instruction); break;
            case Mnemonic.Vmulss: vmulss(in instruction); break;
            case Mnemonic.Vorpd: vorpd(in instruction); break;
            case Mnemonic.Vorps: vorps(in instruction); break;
            case Mnemonic.Vp4dpwssd: vp4dpwssd(in instruction); break;
            case Mnemonic.Vpaddb: vpaddb(in instruction); break;
            case Mnemonic.Vpaddd: vpaddd(in instruction); break;
            case Mnemonic.Vpaddq: vpaddq(in instruction); break;
            case Mnemonic.Vpaddsb: vpaddsb(in instruction); break;
            case Mnemonic.Vpaddsw: vpaddsw(in instruction); break;
            case Mnemonic.Vpaddw: vpaddw(in instruction); break;
            case Mnemonic.Vpandd: vpandd(in instruction); break;
            case Mnemonic.Vpandnd: vpandnd(in instruction); break;
            case Mnemonic.Vpandnq: vpandnq(in instruction); break;
            case Mnemonic.Vpandq: vpandq(in instruction); break;
            case Mnemonic.Vpavgb: vpavgb(in instruction); break;
            case Mnemonic.Vpavgw: vpavgw(in instruction); break;
            case Mnemonic.Vpblendmb: vpblendmb(in instruction); break;
            case Mnemonic.Vpblendmd: vpblendmd(in instruction); break;
            case Mnemonic.Vpblendmq: vpblendmq(in instruction); break;
            case Mnemonic.Vpblendmw: vpblendmw(in instruction); break;
            case Mnemonic.Vpbroadcastb: vpbroadcastb(in instruction); break;
            case Mnemonic.Vpbroadcastd: vpbroadcastd(in instruction); break;
            case Mnemonic.Vpbroadcastmb2q: vpbroadcastmb2q(in instruction); break;
            case Mnemonic.Vpbroadcastmw2d: vpbroadcastmw2d(in instruction); break;
            case Mnemonic.Vpbroadcastq: vpbroadcastq(in instruction); break;
            case Mnemonic.Vpbroadcastw: vpbroadcastw(in instruction); break;
            case Mnemonic.Vpclmulqdq: vpclmulqdq(in instruction); break;
            case Mnemonic.Vpcmpb: vpcmpb(in instruction); break;
            case Mnemonic.Vpcmpd: vpcmpd(in instruction); break;
            case Mnemonic.Vpcmpq: vpcmpq(in instruction); break;
            case Mnemonic.Vpcmpub: vpcmpub(in instruction); break;
            case Mnemonic.Vpcmpud: vpcmpud(in instruction); break;
            case Mnemonic.Vpcmpuq: vpcmpuq(in instruction); break;
            case Mnemonic.Vpcmpuw: vpcmpuw(in instruction); break;
            case Mnemonic.Vpcmpw: vpcmpw(in instruction); break;
            case Mnemonic.Vpcompressd: vpcompressd(in instruction); break;
            case Mnemonic.Vpcompressq: vpcompressq(in instruction); break;
            case Mnemonic.Vpconflictd: vpconflictd(in instruction); break;
            case Mnemonic.Vpconflictq: vpconflictq(in instruction); break;
            case Mnemonic.Vpermb: vpermb(in instruction); break;
            case Mnemonic.Vpermi2d: vpermi2d(in instruction); break;
            case Mnemonic.Vpermi2pd: vpermi2pd(in instruction); break;
            case Mnemonic.Vpermi2ps: vpermi2ps(in instruction); break;
            case Mnemonic.Vpermi2q: vpermi2q(in instruction); break;
            case Mnemonic.Vpermt2b: vpermt2b(in instruction); break;
            case Mnemonic.Vpermt2w: vpermt2w(in instruction); break;
            case Mnemonic.Vpermw: vpermw(in instruction); break;
            case Mnemonic.Vpexpandd: vpexpandd(in instruction); break;
            case Mnemonic.Vpexpandq: vpexpandq(in instruction); break;
            case Mnemonic.Vpextrb: vpextrb(in instruction); break;
            case Mnemonic.Vpextrw: vpextrw(in instruction); break;
            case Mnemonic.Vplzcntd: vplzcntd(in instruction); break;
            case Mnemonic.Vplzcntq: vplzcntq(in instruction); break;
            case Mnemonic.Vpmaxsb: vpmaxsb(in instruction); break;
            case Mnemonic.Vpmaxsd: vpmaxsd(in instruction); break;
            case Mnemonic.Vpmaxsq: vpmaxsq(in instruction); break;
            case Mnemonic.Vpmaxsw: vpmaxsw(in instruction); break;
            case Mnemonic.Vpmaxub: vpmaxub(in instruction); break;
            case Mnemonic.Vpmaxud: vpmaxud(in instruction); break;
            case Mnemonic.Vpmaxuw: vpmaxuw(in instruction); break;
            case Mnemonic.Vpminsb: vpminsb(in instruction); break;
            case Mnemonic.Vpminsd: vpminsd(in instruction); break;
            case Mnemonic.Vpminsq: vpminsq(in instruction); break;
            case Mnemonic.Vpminsw: vpminsw(in instruction); break;
            case Mnemonic.Vpminub: vpminub(in instruction); break;
            case Mnemonic.Vpminud: vpminud(in instruction); break;
            case Mnemonic.Vpminuw: vpminuw(in instruction); break;
            case Mnemonic.Vpopcntb: vpopcntb(in instruction); break;
            case Mnemonic.Vpopcntd: vpopcntd(in instruction); break;
            case Mnemonic.Vpopcntq: vpopcntq(in instruction); break;
            case Mnemonic.Vpopcntw: vpopcntw(in instruction); break;
            case Mnemonic.Vpord: vpord(in instruction); break;
            case Mnemonic.Vporq: vporq(in instruction); break;
            case Mnemonic.Vpsubb: vpsubb(in instruction); break;
            case Mnemonic.Vpsubd: vpsubd(in instruction); break;
            case Mnemonic.Vpsubq: vpsubq(in instruction); break;
            case Mnemonic.Vpsubsb: vpsubsb(in instruction); break;
            case Mnemonic.Vpsubsw: vpsubsw(in instruction); break;
            case Mnemonic.Vpsubw: vpsubw(in instruction); break;
            case Mnemonic.Vptestmb: vptestmb(in instruction); break;
            case Mnemonic.Vptestmd: vptestmd(in instruction); break;
            case Mnemonic.Vptestmq: vptestmq(in instruction); break;
            case Mnemonic.Vptestmw: vptestmw(in instruction); break;
            case Mnemonic.Vptestnmb: vptestnmb(in instruction); break;
            case Mnemonic.Vptestnmd: vptestnmd(in instruction); break;
            case Mnemonic.Vptestnmq: vptestnmq(in instruction); break;
            case Mnemonic.Vptestnmw: vptestnmw(in instruction); break;
            case Mnemonic.Vpxord: vpxord(in instruction); break;
            case Mnemonic.Vpxorq: vpxorq(in instruction); break;
            case Mnemonic.Vrcp14pd: vrcp14pd(in instruction); break;
            case Mnemonic.Vrcp14ps: vrcp14ps(in instruction); break;
            case Mnemonic.Vrcp28pd: vrcp28pd(in instruction); break;
            case Mnemonic.Vrcp28ps: vrcp28ps(in instruction); break;
            case Mnemonic.Vrcp28sd: vrcp28sd(in instruction); break;
            case Mnemonic.Vrcp28ss: vrcp28ss(in instruction); break;
            case Mnemonic.Vrcpph: vrcpph(in instruction); break;
            case Mnemonic.Vrcpsh: vrcpsh(in instruction); break;
            case Mnemonic.Vrsqrt28pd: vrsqrt28pd(in instruction); break;
            case Mnemonic.Vrsqrt28ps: vrsqrt28ps(in instruction); break;
            case Mnemonic.Vrsqrt28sd: vrsqrt28sd(in instruction); break;
            case Mnemonic.Vrsqrt28ss: vrsqrt28ss(in instruction); break;
            case Mnemonic.Vrsqrtph: vrsqrtph(in instruction); break;
            case Mnemonic.Vrsqrtsh: vrsqrtsh(in instruction); break;
            case Mnemonic.Vshuff32x4: vshuff32x4(in instruction); break;
            case Mnemonic.Vsqrtpd: vsqrtpd(in instruction); break;
            case Mnemonic.Vsqrtph: vsqrtph(in instruction); break;
            case Mnemonic.Vsqrtps: vsqrtps(in instruction); break;
            case Mnemonic.Vsqrtsd: vsqrtsd(in instruction); break;
            case Mnemonic.Vsqrtsh: vsqrtsh(in instruction); break;
            case Mnemonic.Vsqrtss: vsqrtss(in instruction); break;
            case Mnemonic.Vsubpd: vsubpd(in instruction); break;
            case Mnemonic.Vsubph: vsubph(in instruction); break;
            case Mnemonic.Vsubps: vsubps(in instruction); break;
            case Mnemonic.Vsubsd: vsubsd(in instruction); break;
            case Mnemonic.Vsubsh: vsubsh(in instruction); break;
            case Mnemonic.Vsubss: vsubss(in instruction); break;
            case Mnemonic.Vxorpd: vxorpd(in instruction); break;
            case Mnemonic.Vxorps: vxorps(in instruction); break;
            case Mnemonic.Vzeroall: vzeroall(in instruction); break;
            case Mnemonic.Vzeroupper: vzeroupper(in instruction); break;
            case Mnemonic.Wrfsbase: wrfsbase(in instruction); break;
            case Mnemonic.Wrgsbase: wrgsbase(in instruction); break;
            case Mnemonic.Wrmsr: wrmsr(in instruction); break;
            case Mnemonic.Wrmsrns: wrmsrns(in instruction); break;
            case Mnemonic.Wrpkru: wrpkru(in instruction); break;
            case Mnemonic.Xadd: xadd(in instruction); break;
            case Mnemonic.Xchg: xchg(in instruction); break;
            case Mnemonic.Xlatb: xlatb(in instruction); break;
            case Mnemonic.Xor: xor(in instruction); break;
            case Mnemonic.Xorps: xorps(in instruction); break;

            default:
                ReportInvalidCodeUnderMnemonic(instruction.Code, instruction.Mnemonic);
                break;
        }
    }
}
