// <auto-generated>
// This file was generated automatically. 🖥️
// See /eng/BuildTools/X64/RegistersXmlToCSharp
// </auto-generated>

using System.Runtime.Intrinsics;

namespace Machine.X64.Component
{
public interface IProcessorRegisters
{
    /// <summary>
    /// Represents the RAX register.
    /// </summary>
    public ulong Rax { get; set; }
    /// <summary>
    /// Represents the RBX register.
    /// </summary>
    public ulong Rbx { get; set; }
    /// <summary>
    /// Represents the RCX register.
    /// </summary>
    public ulong Rcx { get; set; }
    /// <summary>
    /// Represents the RDX register.
    /// </summary>
    public ulong Rdx { get; set; }
    /// <summary>
    /// Represents the RSI register.
    /// </summary>
    public ulong Rsi { get; set; }
    /// <summary>
    /// Represents the RDI register.
    /// </summary>
    public ulong Rdi { get; set; }
    /// <summary>
    /// Represents the RSP register.
    /// </summary>
    public ulong Rsp { get; set; }
    /// <summary>
    /// Represents the RIP register.
    /// </summary>
    public ulong Rip { get; set; }
    /// <summary>
    /// Represents the RBP register.
    /// </summary>
    public ulong Rbp { get; set; }
    /// <summary>
    /// Represents the RFLAGS register.
    /// </summary>
    public ulong RFlags { get; set; }
    /// <summary>
    /// Represents the EAX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RAX register.
    /// </remarks>
    public uint Eax { get; set; }
    /// <summary>
    /// Represents the EBX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RBX register.
    /// </remarks>
    public uint Ebx { get; set; }
    /// <summary>
    /// Represents the ECX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RCX register.
    /// </remarks>
    public uint Ecx { get; set; }
    /// <summary>
    /// Represents the EDX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RDX register.
    /// </remarks>
    public uint Edx { get; set; }
    /// <summary>
    /// Represents the ESI register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RSI register.
    /// </remarks>
    public uint Esi { get; set; }
    /// <summary>
    /// Represents the EDI register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RDI register.
    /// </remarks>
    public uint Edi { get; set; }
    /// <summary>
    /// Represents the ESP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RSP register.
    /// </remarks>
    public uint Esp { get; set; }
    /// <summary>
    /// Represents the EIP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RIP register.
    /// </remarks>
    public uint Eip { get; set; }
    /// <summary>
    /// Represents the EBP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RBP register.
    /// </remarks>
    public uint Ebp { get; set; }
    /// <summary>
    /// Represents the EFLAGS register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RFLAGS register.
    /// </remarks>
    public uint EFlags { get; set; }
    /// <summary>
    /// Represents the AX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EAX register.
    /// </remarks>
    public ushort Ax { get; set; }
    /// <summary>
    /// Represents the BX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EBX register.
    /// </remarks>
    public ushort Bx { get; set; }
    /// <summary>
    /// Represents the CX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the ECX register.
    /// </remarks>
    public ushort Cx { get; set; }
    /// <summary>
    /// Represents the DX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EDX register.
    /// </remarks>
    public ushort Dx { get; set; }
    /// <summary>
    /// Represents the SI register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the ESI register.
    /// </remarks>
    public ushort Si { get; set; }
    /// <summary>
    /// Represents the DI register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EDI register.
    /// </remarks>
    public ushort Di { get; set; }
    /// <summary>
    /// Represents the SP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the ESP register.
    /// </remarks>
    public ushort Sp { get; set; }
    /// <summary>
    /// Represents the IP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EIP register.
    /// </remarks>
    public ushort Ip { get; set; }
    /// <summary>
    /// Represents the BP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EBP register.
    /// </remarks>
    public ushort Bp { get; set; }
    /// <summary>
    /// Represents the FLAGS register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EFLAGS register.
    /// </remarks>
    public ushort Flags { get; set; }
    /// <summary>
    /// Represents the CS register.
    /// </summary>
    public ushort Cs { get; set; }
    /// <summary>
    /// Represents the SS register.
    /// </summary>
    public ushort Ss { get; set; }
    /// <summary>
    /// Represents the DS register.
    /// </summary>
    public ushort Ds { get; set; }
    /// <summary>
    /// Represents the ES register.
    /// </summary>
    public ushort Es { get; set; }
    /// <summary>
    /// Represents the FS register.
    /// </summary>
    public ulong Fs { get; set; }
    /// <summary>
    /// Represents the GS register.
    /// </summary>
    public ulong Gs { get; set; }
    /// <summary>
    /// Represents the ZMM0 vector register.
    /// </summary>
    public Vector512<float> Zmm0 { get; set; }
    /// <summary>
    /// Represents the YMM0 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM0 register.
    /// </remarks>
    public Vector256<float> Ymm0 { get; set; }
    /// <summary>
    /// Represents the XMM0 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM0 register.
    /// </remarks>
    public Vector128<float> Xmm0 { get; set; }
    /// <summary>
    /// Represents the ZMM1 vector register.
    /// </summary>
    public Vector512<float> Zmm1 { get; set; }
    /// <summary>
    /// Represents the YMM1 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM1 register.
    /// </remarks>
    public Vector256<float> Ymm1 { get; set; }
    /// <summary>
    /// Represents the XMM1 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM1 register.
    /// </remarks>
    public Vector128<float> Xmm1 { get; set; }
    /// <summary>
    /// Represents the ZMM2 vector register.
    /// </summary>
    public Vector512<float> Zmm2 { get; set; }
    /// <summary>
    /// Represents the YMM2 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM2 register.
    /// </remarks>
    public Vector256<float> Ymm2 { get; set; }
    /// <summary>
    /// Represents the XMM2 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM2 register.
    /// </remarks>
    public Vector128<float> Xmm2 { get; set; }
    /// <summary>
    /// Represents the ZMM3 vector register.
    /// </summary>
    public Vector512<float> Zmm3 { get; set; }
    /// <summary>
    /// Represents the YMM3 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM3 register.
    /// </remarks>
    public Vector256<float> Ymm3 { get; set; }
    /// <summary>
    /// Represents the XMM3 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM3 register.
    /// </remarks>
    public Vector128<float> Xmm3 { get; set; }
    /// <summary>
    /// Represents the ZMM4 vector register.
    /// </summary>
    public Vector512<float> Zmm4 { get; set; }
    /// <summary>
    /// Represents the YMM4 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM4 register.
    /// </remarks>
    public Vector256<float> Ymm4 { get; set; }
    /// <summary>
    /// Represents the XMM4 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM4 register.
    /// </remarks>
    public Vector128<float> Xmm4 { get; set; }
    /// <summary>
    /// Represents the ZMM5 vector register.
    /// </summary>
    public Vector512<float> Zmm5 { get; set; }
    /// <summary>
    /// Represents the YMM5 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM5 register.
    /// </remarks>
    public Vector256<float> Ymm5 { get; set; }
    /// <summary>
    /// Represents the XMM5 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM5 register.
    /// </remarks>
    public Vector128<float> Xmm5 { get; set; }
    /// <summary>
    /// Represents the ZMM6 vector register.
    /// </summary>
    public Vector512<float> Zmm6 { get; set; }
    /// <summary>
    /// Represents the YMM6 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM6 register.
    /// </remarks>
    public Vector256<float> Ymm6 { get; set; }
    /// <summary>
    /// Represents the XMM6 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM6 register.
    /// </remarks>
    public Vector128<float> Xmm6 { get; set; }
    /// <summary>
    /// Represents the ZMM7 vector register.
    /// </summary>
    public Vector512<float> Zmm7 { get; set; }
    /// <summary>
    /// Represents the YMM7 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM7 register.
    /// </remarks>
    public Vector256<float> Ymm7 { get; set; }
    /// <summary>
    /// Represents the XMM7 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM7 register.
    /// </remarks>
    public Vector128<float> Xmm7 { get; set; }
    /// <summary>
    /// Represents the ZMM8 vector register.
    /// </summary>
    public Vector512<float> Zmm8 { get; set; }
    /// <summary>
    /// Represents the YMM8 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM8 register.
    /// </remarks>
    public Vector256<float> Ymm8 { get; set; }
    /// <summary>
    /// Represents the XMM8 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM8 register.
    /// </remarks>
    public Vector128<float> Xmm8 { get; set; }
    /// <summary>
    /// Represents the ZMM9 vector register.
    /// </summary>
    public Vector512<float> Zmm9 { get; set; }
    /// <summary>
    /// Represents the YMM9 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM9 register.
    /// </remarks>
    public Vector256<float> Ymm9 { get; set; }
    /// <summary>
    /// Represents the XMM9 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM9 register.
    /// </remarks>
    public Vector128<float> Xmm9 { get; set; }
    /// <summary>
    /// Represents the ZMM10 vector register.
    /// </summary>
    public Vector512<float> Zmm10 { get; set; }
    /// <summary>
    /// Represents the YMM10 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM10 register.
    /// </remarks>
    public Vector256<float> Ymm10 { get; set; }
    /// <summary>
    /// Represents the XMM10 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM10 register.
    /// </remarks>
    public Vector128<float> Xmm10 { get; set; }
    /// <summary>
    /// Represents the ZMM11 vector register.
    /// </summary>
    public Vector512<float> Zmm11 { get; set; }
    /// <summary>
    /// Represents the YMM11 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM11 register.
    /// </remarks>
    public Vector256<float> Ymm11 { get; set; }
    /// <summary>
    /// Represents the XMM11 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM11 register.
    /// </remarks>
    public Vector128<float> Xmm11 { get; set; }
    /// <summary>
    /// Represents the ZMM12 vector register.
    /// </summary>
    public Vector512<float> Zmm12 { get; set; }
    /// <summary>
    /// Represents the YMM12 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM12 register.
    /// </remarks>
    public Vector256<float> Ymm12 { get; set; }
    /// <summary>
    /// Represents the XMM12 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM12 register.
    /// </remarks>
    public Vector128<float> Xmm12 { get; set; }
    /// <summary>
    /// Represents the ZMM13 vector register.
    /// </summary>
    public Vector512<float> Zmm13 { get; set; }
    /// <summary>
    /// Represents the YMM13 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM13 register.
    /// </remarks>
    public Vector256<float> Ymm13 { get; set; }
    /// <summary>
    /// Represents the XMM13 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM13 register.
    /// </remarks>
    public Vector128<float> Xmm13 { get; set; }
    /// <summary>
    /// Represents the ZMM14 vector register.
    /// </summary>
    public Vector512<float> Zmm14 { get; set; }
    /// <summary>
    /// Represents the YMM14 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM14 register.
    /// </remarks>
    public Vector256<float> Ymm14 { get; set; }
    /// <summary>
    /// Represents the XMM14 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM14 register.
    /// </remarks>
    public Vector128<float> Xmm14 { get; set; }
    /// <summary>
    /// Represents the ZMM15 vector register.
    /// </summary>
    public Vector512<float> Zmm15 { get; set; }
    /// <summary>
    /// Represents the YMM15 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM15 register.
    /// </remarks>
    public Vector256<float> Ymm15 { get; set; }
    /// <summary>
    /// Represents the XMM15 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM15 register.
    /// </remarks>
    public Vector128<float> Xmm15 { get; set; }
    /// <summary>
    /// Represents the ZMM16 vector register.
    /// </summary>
    public Vector512<float> Zmm16 { get; set; }
    /// <summary>
    /// Represents the YMM16 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM16 register.
    /// </remarks>
    public Vector256<float> Ymm16 { get; set; }
    /// <summary>
    /// Represents the XMM16 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM16 register.
    /// </remarks>
    public Vector128<float> Xmm16 { get; set; }
    /// <summary>
    /// Represents the ZMM17 vector register.
    /// </summary>
    public Vector512<float> Zmm17 { get; set; }
    /// <summary>
    /// Represents the YMM17 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM17 register.
    /// </remarks>
    public Vector256<float> Ymm17 { get; set; }
    /// <summary>
    /// Represents the XMM17 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM17 register.
    /// </remarks>
    public Vector128<float> Xmm17 { get; set; }
    /// <summary>
    /// Represents the ZMM18 vector register.
    /// </summary>
    public Vector512<float> Zmm18 { get; set; }
    /// <summary>
    /// Represents the YMM18 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM18 register.
    /// </remarks>
    public Vector256<float> Ymm18 { get; set; }
    /// <summary>
    /// Represents the XMM18 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM18 register.
    /// </remarks>
    public Vector128<float> Xmm18 { get; set; }
    /// <summary>
    /// Represents the ZMM19 vector register.
    /// </summary>
    public Vector512<float> Zmm19 { get; set; }
    /// <summary>
    /// Represents the YMM19 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM19 register.
    /// </remarks>
    public Vector256<float> Ymm19 { get; set; }
    /// <summary>
    /// Represents the XMM19 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM19 register.
    /// </remarks>
    public Vector128<float> Xmm19 { get; set; }
    /// <summary>
    /// Represents the ZMM20 vector register.
    /// </summary>
    public Vector512<float> Zmm20 { get; set; }
    /// <summary>
    /// Represents the YMM20 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM20 register.
    /// </remarks>
    public Vector256<float> Ymm20 { get; set; }
    /// <summary>
    /// Represents the XMM20 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM20 register.
    /// </remarks>
    public Vector128<float> Xmm20 { get; set; }
    /// <summary>
    /// Represents the ZMM21 vector register.
    /// </summary>
    public Vector512<float> Zmm21 { get; set; }
    /// <summary>
    /// Represents the YMM21 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM21 register.
    /// </remarks>
    public Vector256<float> Ymm21 { get; set; }
    /// <summary>
    /// Represents the XMM21 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM21 register.
    /// </remarks>
    public Vector128<float> Xmm21 { get; set; }
    /// <summary>
    /// Represents the ZMM22 vector register.
    /// </summary>
    public Vector512<float> Zmm22 { get; set; }
    /// <summary>
    /// Represents the YMM22 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM22 register.
    /// </remarks>
    public Vector256<float> Ymm22 { get; set; }
    /// <summary>
    /// Represents the XMM22 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM22 register.
    /// </remarks>
    public Vector128<float> Xmm22 { get; set; }
    /// <summary>
    /// Represents the ZMM23 vector register.
    /// </summary>
    public Vector512<float> Zmm23 { get; set; }
    /// <summary>
    /// Represents the YMM23 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM23 register.
    /// </remarks>
    public Vector256<float> Ymm23 { get; set; }
    /// <summary>
    /// Represents the XMM23 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM23 register.
    /// </remarks>
    public Vector128<float> Xmm23 { get; set; }
    /// <summary>
    /// Represents the ZMM24 vector register.
    /// </summary>
    public Vector512<float> Zmm24 { get; set; }
    /// <summary>
    /// Represents the YMM24 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM24 register.
    /// </remarks>
    public Vector256<float> Ymm24 { get; set; }
    /// <summary>
    /// Represents the XMM24 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM24 register.
    /// </remarks>
    public Vector128<float> Xmm24 { get; set; }
    /// <summary>
    /// Represents the ZMM25 vector register.
    /// </summary>
    public Vector512<float> Zmm25 { get; set; }
    /// <summary>
    /// Represents the YMM25 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM25 register.
    /// </remarks>
    public Vector256<float> Ymm25 { get; set; }
    /// <summary>
    /// Represents the XMM25 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM25 register.
    /// </remarks>
    public Vector128<float> Xmm25 { get; set; }
    /// <summary>
    /// Represents the ZMM26 vector register.
    /// </summary>
    public Vector512<float> Zmm26 { get; set; }
    /// <summary>
    /// Represents the YMM26 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM26 register.
    /// </remarks>
    public Vector256<float> Ymm26 { get; set; }
    /// <summary>
    /// Represents the XMM26 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM26 register.
    /// </remarks>
    public Vector128<float> Xmm26 { get; set; }
    /// <summary>
    /// Represents the ZMM27 vector register.
    /// </summary>
    public Vector512<float> Zmm27 { get; set; }
    /// <summary>
    /// Represents the YMM27 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM27 register.
    /// </remarks>
    public Vector256<float> Ymm27 { get; set; }
    /// <summary>
    /// Represents the XMM27 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM27 register.
    /// </remarks>
    public Vector128<float> Xmm27 { get; set; }
    /// <summary>
    /// Represents the ZMM28 vector register.
    /// </summary>
    public Vector512<float> Zmm28 { get; set; }
    /// <summary>
    /// Represents the YMM28 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM28 register.
    /// </remarks>
    public Vector256<float> Ymm28 { get; set; }
    /// <summary>
    /// Represents the XMM28 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM28 register.
    /// </remarks>
    public Vector128<float> Xmm28 { get; set; }
    /// <summary>
    /// Represents the ZMM29 vector register.
    /// </summary>
    public Vector512<float> Zmm29 { get; set; }
    /// <summary>
    /// Represents the YMM29 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM29 register.
    /// </remarks>
    public Vector256<float> Ymm29 { get; set; }
    /// <summary>
    /// Represents the XMM29 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM29 register.
    /// </remarks>
    public Vector128<float> Xmm29 { get; set; }
    /// <summary>
    /// Represents the ZMM30 vector register.
    /// </summary>
    public Vector512<float> Zmm30 { get; set; }
    /// <summary>
    /// Represents the YMM30 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM30 register.
    /// </remarks>
    public Vector256<float> Ymm30 { get; set; }
    /// <summary>
    /// Represents the XMM30 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM30 register.
    /// </remarks>
    public Vector128<float> Xmm30 { get; set; }
    /// <summary>
    /// Represents the ZMM31 vector register.
    /// </summary>
    public Vector512<float> Zmm31 { get; set; }
    /// <summary>
    /// Represents the YMM31 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM31 register.
    /// </remarks>
    public Vector256<float> Ymm31 { get; set; }
    /// <summary>
    /// Represents the XMM31 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM31 register.
    /// </remarks>
    public Vector128<float> Xmm31 { get; set; }
    /// <summary>
    /// Represents the K0 register.
    /// </summary>
    public ulong K0 { get; set; }
    /// <summary>
    /// Represents the K1 register.
    /// </summary>
    public ulong K1 { get; set; }
    /// <summary>
    /// Represents the K2 register.
    /// </summary>
    public ulong K2 { get; set; }
    /// <summary>
    /// Represents the K3 register.
    /// </summary>
    public ulong K3 { get; set; }
    /// <summary>
    /// Represents the K4 register.
    /// </summary>
    public ulong K4 { get; set; }
    /// <summary>
    /// Represents the K5 register.
    /// </summary>
    public ulong K5 { get; set; }
    /// <summary>
    /// Represents the K6 register.
    /// </summary>
    public ulong K6 { get; set; }
    /// <summary>
    /// Represents the K7 register.
    /// </summary>
    public ulong K7 { get; set; }
    /// <summary>
    /// Represents the CR0 register.
    /// </summary>
    public ulong CR0 { get; set; }
    /// <summary>
    /// Represents the CR1 register.
    /// </summary>
    public ulong CR1 { get; set; }
    /// <summary>
    /// Represents the CR2 register.
    /// </summary>
    public ulong CR2 { get; set; }
    /// <summary>
    /// Represents the CR3 register.
    /// </summary>
    public ulong CR3 { get; set; }
    /// <summary>
    /// Represents the CR4 register.
    /// </summary>
    public ulong CR4 { get; set; }
    /// <summary>
    /// Represents the CR5 register.
    /// </summary>
    public ulong CR5 { get; set; }
    /// <summary>
    /// Represents the CR6 register.
    /// </summary>
    public ulong CR6 { get; set; }
    /// <summary>
    /// Represents the CR7 register.
    /// </summary>
    public ulong CR7 { get; set; }
    /// <summary>
    /// Represents the TR0 register.
    /// </summary>
    public ulong TR0 { get; set; }
    /// <summary>
    /// Represents the TR1 register.
    /// </summary>
    public ulong TR1 { get; set; }
    /// <summary>
    /// Represents the TR2 register.
    /// </summary>
    public ulong TR2 { get; set; }
    /// <summary>
    /// Represents the TR3 register.
    /// </summary>
    public ulong TR3 { get; set; }
    /// <summary>
    /// Represents the TR4 register.
    /// </summary>
    public ulong TR4 { get; set; }
    /// <summary>
    /// Represents the TR5 register.
    /// </summary>
    public ulong TR5 { get; set; }
    /// <summary>
    /// Represents the TR6 register.
    /// </summary>
    public ulong TR6 { get; set; }
    /// <summary>
    /// Represents the TR7 register.
    /// </summary>
    public ulong TR7 { get; set; }
    /// <summary>
    /// Represents the DR0 register.
    /// </summary>
    public ulong DR0 { get; set; }
    /// <summary>
    /// Represents the DR1 register.
    /// </summary>
    public ulong DR1 { get; set; }
    /// <summary>
    /// Represents the DR2 register.
    /// </summary>
    public ulong DR2 { get; set; }
    /// <summary>
    /// Represents the DR3 register.
    /// </summary>
    public ulong DR3 { get; set; }
    /// <summary>
    /// Represents the DR4 register.
    /// </summary>
    public ulong DR4 { get; set; }
    /// <summary>
    /// Represents the DR5 register.
    /// </summary>
    public ulong DR5 { get; set; }
    /// <summary>
    /// Represents the DR6 register.
    /// </summary>
    public ulong DR6 { get; set; }
    /// <summary>
    /// Represents the DR7 register.
    /// </summary>
    public ulong DR7 { get; set; }
    /// <summary>
    /// Represents the MM0 register.
    /// </summary>
    public ulong MM0 { get; set; }
    /// <summary>
    /// Represents the MM1 register.
    /// </summary>
    public ulong MM1 { get; set; }
    /// <summary>
    /// Represents the MM2 register.
    /// </summary>
    public ulong MM2 { get; set; }
    /// <summary>
    /// Represents the MM3 register.
    /// </summary>
    public ulong MM3 { get; set; }
    /// <summary>
    /// Represents the MM4 register.
    /// </summary>
    public ulong MM4 { get; set; }
    /// <summary>
    /// Represents the MM5 register.
    /// </summary>
    public ulong MM5 { get; set; }
    /// <summary>
    /// Represents the MM6 register.
    /// </summary>
    public ulong MM6 { get; set; }
    /// <summary>
    /// Represents the MM7 register.
    /// </summary>
    public ulong MM7 { get; set; }
    /// <summary>
    /// Represents the PKRU register.
    /// </summary>
    public ulong Pkru { get; set; }
    /// <summary>
    /// Represents the MSR register.
    /// </summary>
    public ulong Msr { get; set; }
    /// <summary>
    /// Gets/sets the <c>CF</c> (Carry Flag) flag.
    /// </summary>
    public bool RFlagsCF { get; set; }
    /// <summary>
    /// Gets/sets the <c>PF</c> (Parity Flag) flag.
    /// </summary>
    public bool RFlagsPF { get; set; }
    /// <summary>
    /// Gets/sets the <c>AF</c> (Auxiliary Flag) flag.
    /// </summary>
    public bool RFlagsAF { get; set; }
    /// <summary>
    /// Gets/sets the <c>ZF</c> (Zero Flag) flag.
    /// </summary>
    public bool RFlagsZF { get; set; }
    /// <summary>
    /// Gets/sets the <c>SF</c> (Sign Flag) flag.
    /// </summary>
    public bool RFlagsSF { get; set; }
    /// <summary>
    /// Gets/sets the <c>TF</c> (Trap Flag) flag.
    /// </summary>
    public bool RFlagsTF { get; set; }
    /// <summary>
    /// Gets/sets the <c>IF</c> (Interrupt Enable Flag) flag.
    /// </summary>
    public bool RFlagsIF { get; set; }
    /// <summary>
    /// Gets/sets the <c>DF</c> (Direction Flag) flag.
    /// </summary>
    public bool RFlagsDF { get; set; }
    /// <summary>
    /// Gets/sets the <c>OF</c> (Overflow Flag) flag.
    /// </summary>
    public bool RFlagsOF { get; set; }
    /// <summary>
    /// Gets/sets the <c>IOPL</c> (I/O Privilege Level Flag) flag.
    /// </summary>
    public bool RFlagsIOPL { get; set; }
    /// <summary>
    /// Gets/sets the <c>IOPL2</c> (I/O Privilege Level Flag (2)) flag.
    /// </summary>
    public bool RFlagsIOPL2 { get; set; }
    /// <summary>
    /// Gets/sets the <c>NT</c> (Nested Task Flag) flag.
    /// </summary>
    public bool RFlagsNT { get; set; }
    /// <summary>
    /// Gets/sets the <c>RF</c> (Resume Flag) flag.
    /// </summary>
    public bool RFlagsRF { get; set; }
    /// <summary>
    /// Gets/sets the <c>VM</c> (Virtual-8086 Mode Flag) flag.
    /// </summary>
    public bool RFlagsVM { get; set; }
    /// <summary>
    /// Gets/sets the <c>AC</c> (Alignment Check Flag) flag.
    /// </summary>
    public bool RFlagsAC { get; set; }
    /// <summary>
    /// Gets/sets the <c>VIF</c> (Virtual Interrupt Flag) flag.
    /// </summary>
    public bool RFlagsVIF { get; set; }
    /// <summary>
    /// Gets/sets the <c>VIP</c> (Virtual Interrupt Pending Flag) flag.
    /// </summary>
    public bool RFlagsVIP { get; set; }
    /// <summary>
    /// Gets/sets the <c>ID</c> (ID Flag) flag.
    /// </summary>
    public bool RFlagsID { get; set; }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>PE</c> (Protection Enable) flag.
    /// </summary>
    public bool CR0PE { get; set; }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>MP</c> (Monitor Coprocessor) flag.
    /// </summary>
    public bool CR0MP { get; set; }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>EM</c> (Emulation) flag.
    /// </summary>
    public bool CR0EM { get; set; }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>TS</c> (Task Switched) flag.
    /// </summary>
    public bool CR0TS { get; set; }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>ET</c> (Extension Type) flag.
    /// </summary>
    public bool CR0ET { get; set; }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>NE</c> (Numeric Error) flag.
    /// </summary>
    public bool CR0NE { get; set; }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>WP</c> (Write Protect) flag.
    /// </summary>
    public bool CR0WP { get; set; }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>AM</c> (Alignment Mask) flag.
    /// </summary>
    public bool CR0AM { get; set; }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>NW</c> (Not Write-through) flag.
    /// </summary>
    public bool CR0NW { get; set; }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>CD</c> (Cache Disable) flag.
    /// </summary>
    public bool CR0CD { get; set; }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>PG</c> (Paging) flag.
    /// </summary>
    public bool CR0PG { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>VME</c> (Virtual 8086 Mode Extensions) flag.
    /// </summary>
    public bool CR4VME { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PVI</c> (Protected-mode Virtual Interrupts) flag.
    /// </summary>
    public bool CR4PVI { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>TSD</c> (Time Stamp Disable) flag.
    /// </summary>
    public bool CR4TSD { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>DE</c> (Debugging Extensions) flag.
    /// </summary>
    public bool CR4DE { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PSE</c> (Page Size Extension) flag.
    /// </summary>
    public bool CR4PSE { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PAE</c> (Physical Address Extension) flag.
    /// </summary>
    public bool CR4PAE { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>MCE</c> (Machine Check Extension) flag.
    /// </summary>
    public bool CR4MCE { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PGE</c> (Page Global Enabled) flag.
    /// </summary>
    public bool CR4PGE { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PCE</c> (Performance-Monitoring Counter enable) flag.
    /// </summary>
    public bool CR4PCE { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>OSFXSR</c> (Operating system support for FXSAVE and FXRSTOR instructions) flag.
    /// </summary>
    public bool CR4OSFXSR { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>OSXMMEXCPT</c> (Operating System Support for Unmasked SIMD Floating-Point Exceptions) flag.
    /// </summary>
    public bool CR4OSXMMEXCPT { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>UMIP</c> (User-mode Instruction Prevention) flag.
    /// </summary>
    public bool CR4UMIP { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>LA57</c> (57-bit linear addresses) flag.
    /// </summary>
    public bool CR4LA57 { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>VMXE</c> (Virtual Machine Extensions Enable) flag.
    /// </summary>
    public bool CR4VMXE { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>SMXE</c> (Safer Mode Extensions Enable) flag.
    /// </summary>
    public bool CR4SMXE { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>FSGSBASE</c> (Enable RDFSBASE, RDGSBASE, WRFSBASE, and WRGSBASE instructions) flag.
    /// </summary>
    public bool CR4FSGSBASE { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PCIDE</c> (Process-Context Identifiers Enable) flag.
    /// </summary>
    public bool CR4PCIDE { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>OSXSAVE</c> (XSAVE and Processor Extended States Enable) flag.
    /// </summary>
    public bool CR4OSXSAVE { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>SMEP</c> (Supervisor Mode Execution Protection) flag.
    /// </summary>
    public bool CR4SMEP { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>SMAP</c> (Supervisor Mode Access Prevention) flag.
    /// </summary>
    public bool CR4SMAP { get; set; }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PKE</c> (Protection Key Enable) flag.
    /// </summary>
    public bool CR4PKE { get; set; }
}
public sealed class ProcessorRegisters  : IProcessorRegisters
{
    /// <summary>
    /// Represents the RAX register.
    /// </summary>
    public ulong Rax { get; set; }
    /// <summary>
    /// Represents the RBX register.
    /// </summary>
    public ulong Rbx { get; set; }
    /// <summary>
    /// Represents the RCX register.
    /// </summary>
    public ulong Rcx { get; set; }
    /// <summary>
    /// Represents the RDX register.
    /// </summary>
    public ulong Rdx { get; set; }
    /// <summary>
    /// Represents the RSI register.
    /// </summary>
    public ulong Rsi { get; set; }
    /// <summary>
    /// Represents the RDI register.
    /// </summary>
    public ulong Rdi { get; set; }
    /// <summary>
    /// Represents the RSP register.
    /// </summary>
    public ulong Rsp { get; set; }
    /// <summary>
    /// Represents the RIP register.
    /// </summary>
    public ulong Rip { get; set; }
    /// <summary>
    /// Represents the RBP register.
    /// </summary>
    public ulong Rbp { get; set; }
    /// <summary>
    /// Represents the RFLAGS register.
    /// </summary>
    public ulong RFlags { get; set; }
    /// <summary>
    /// Represents the EAX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RAX register.
    /// </remarks>
    public uint Eax
    {
        get => (uint)(Rax & 0x00000000FFFFFFFF);
        set => Rax = (ulong)((Rax & 0xFFFFFFFF00000000) | value);
    }
    /// <summary>
    /// Represents the EBX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RBX register.
    /// </remarks>
    public uint Ebx
    {
        get => (uint)(Rbx & 0x00000000FFFFFFFF);
        set => Rbx = (ulong)((Rbx & 0xFFFFFFFF00000000) | value);
    }
    /// <summary>
    /// Represents the ECX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RCX register.
    /// </remarks>
    public uint Ecx
    {
        get => (uint)(Rcx & 0x00000000FFFFFFFF);
        set => Rcx = (ulong)((Rcx & 0xFFFFFFFF00000000) | value);
    }
    /// <summary>
    /// Represents the EDX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RDX register.
    /// </remarks>
    public uint Edx
    {
        get => (uint)(Rdx & 0x00000000FFFFFFFF);
        set => Rdx = (ulong)((Rdx & 0xFFFFFFFF00000000) | value);
    }
    /// <summary>
    /// Represents the ESI register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RSI register.
    /// </remarks>
    public uint Esi
    {
        get => (uint)(Rsi & 0x00000000FFFFFFFF);
        set => Rsi = (ulong)((Rsi & 0xFFFFFFFF00000000) | value);
    }
    /// <summary>
    /// Represents the EDI register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RDI register.
    /// </remarks>
    public uint Edi
    {
        get => (uint)(Rdi & 0x00000000FFFFFFFF);
        set => Rdi = (ulong)((Rdi & 0xFFFFFFFF00000000) | value);
    }
    /// <summary>
    /// Represents the ESP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RSP register.
    /// </remarks>
    public uint Esp
    {
        get => (uint)(Rsp & 0x00000000FFFFFFFF);
        set => Rsp = (ulong)((Rsp & 0xFFFFFFFF00000000) | value);
    }
    /// <summary>
    /// Represents the EIP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RIP register.
    /// </remarks>
    public uint Eip
    {
        get => (uint)(Rip & 0x00000000FFFFFFFF);
        set => Rip = (ulong)((Rip & 0xFFFFFFFF00000000) | value);
    }
    /// <summary>
    /// Represents the EBP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RBP register.
    /// </remarks>
    public uint Ebp
    {
        get => (uint)(Rbp & 0x00000000FFFFFFFF);
        set => Rbp = (ulong)((Rbp & 0xFFFFFFFF00000000) | value);
    }
    /// <summary>
    /// Represents the EFLAGS register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the RFLAGS register.
    /// </remarks>
    public uint EFlags
    {
        get => (uint)(RFlags & 0x00000000FFFFFFFF);
        set => RFlags = (ulong)((RFlags & 0xFFFFFFFF00000000) | value);
    }
    /// <summary>
    /// Represents the AX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EAX register.
    /// </remarks>
    public ushort Ax
    {
        get => (ushort)(Eax & 0x0000FFFF);
        set => Eax = (uint)((Eax & 0xFFFF0000) | value);
    }
    /// <summary>
    /// Represents the BX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EBX register.
    /// </remarks>
    public ushort Bx
    {
        get => (ushort)(Ebx & 0x0000FFFF);
        set => Ebx = (uint)((Ebx & 0xFFFF0000) | value);
    }
    /// <summary>
    /// Represents the CX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the ECX register.
    /// </remarks>
    public ushort Cx
    {
        get => (ushort)(Ecx & 0x0000FFFF);
        set => Ecx = (uint)((Ecx & 0xFFFF0000) | value);
    }
    /// <summary>
    /// Represents the DX register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EDX register.
    /// </remarks>
    public ushort Dx
    {
        get => (ushort)(Edx & 0x0000FFFF);
        set => Edx = (uint)((Edx & 0xFFFF0000) | value);
    }
    /// <summary>
    /// Represents the SI register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the ESI register.
    /// </remarks>
    public ushort Si
    {
        get => (ushort)(Esi & 0x0000FFFF);
        set => Esi = (uint)((Esi & 0xFFFF0000) | value);
    }
    /// <summary>
    /// Represents the DI register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EDI register.
    /// </remarks>
    public ushort Di
    {
        get => (ushort)(Edi & 0x0000FFFF);
        set => Edi = (uint)((Edi & 0xFFFF0000) | value);
    }
    /// <summary>
    /// Represents the SP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the ESP register.
    /// </remarks>
    public ushort Sp
    {
        get => (ushort)(Esp & 0x0000FFFF);
        set => Esp = (uint)((Esp & 0xFFFF0000) | value);
    }
    /// <summary>
    /// Represents the IP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EIP register.
    /// </remarks>
    public ushort Ip
    {
        get => (ushort)(Eip & 0x0000FFFF);
        set => Eip = (uint)((Eip & 0xFFFF0000) | value);
    }
    /// <summary>
    /// Represents the BP register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EBP register.
    /// </remarks>
    public ushort Bp
    {
        get => (ushort)(Ebp & 0x0000FFFF);
        set => Ebp = (uint)((Ebp & 0xFFFF0000) | value);
    }
    /// <summary>
    /// Represents the FLAGS register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the EFLAGS register.
    /// </remarks>
    public ushort Flags
    {
        get => (ushort)(EFlags & 0x0000FFFF);
        set => EFlags = (uint)((EFlags & 0xFFFF0000) | value);
    }
    /// <summary>
    /// Represents the CS register.
    /// </summary>
    public ushort Cs { get; set; }
    /// <summary>
    /// Represents the SS register.
    /// </summary>
    public ushort Ss { get; set; }
    /// <summary>
    /// Represents the DS register.
    /// </summary>
    public ushort Ds { get; set; }
    /// <summary>
    /// Represents the ES register.
    /// </summary>
    public ushort Es { get; set; }
    /// <summary>
    /// Represents the FS register.
    /// </summary>
    public ulong Fs { get; set; }
    /// <summary>
    /// Represents the GS register.
    /// </summary>
    public ulong Gs { get; set; }
    /// <summary>
    /// Represents the ZMM0 vector register.
    /// </summary>
    public Vector512<float> Zmm0 { get; set; }
    /// <summary>
    /// Represents the YMM0 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM0 register.
    /// </remarks>
    public Vector256<float> Ymm0
    {
        get => Zmm0.GetLower();
        set => Zmm0 = Zmm0.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM0 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM0 register.
    /// </remarks>
    public Vector128<float> Xmm0
    {
        get => Ymm0.GetLower();
        set => Ymm0 = Ymm0.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM1 vector register.
    /// </summary>
    public Vector512<float> Zmm1 { get; set; }
    /// <summary>
    /// Represents the YMM1 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM1 register.
    /// </remarks>
    public Vector256<float> Ymm1
    {
        get => Zmm1.GetLower();
        set => Zmm1 = Zmm1.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM1 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM1 register.
    /// </remarks>
    public Vector128<float> Xmm1
    {
        get => Ymm1.GetLower();
        set => Ymm1 = Ymm1.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM2 vector register.
    /// </summary>
    public Vector512<float> Zmm2 { get; set; }
    /// <summary>
    /// Represents the YMM2 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM2 register.
    /// </remarks>
    public Vector256<float> Ymm2
    {
        get => Zmm2.GetLower();
        set => Zmm2 = Zmm2.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM2 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM2 register.
    /// </remarks>
    public Vector128<float> Xmm2
    {
        get => Ymm2.GetLower();
        set => Ymm2 = Ymm2.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM3 vector register.
    /// </summary>
    public Vector512<float> Zmm3 { get; set; }
    /// <summary>
    /// Represents the YMM3 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM3 register.
    /// </remarks>
    public Vector256<float> Ymm3
    {
        get => Zmm3.GetLower();
        set => Zmm3 = Zmm3.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM3 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM3 register.
    /// </remarks>
    public Vector128<float> Xmm3
    {
        get => Ymm3.GetLower();
        set => Ymm3 = Ymm3.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM4 vector register.
    /// </summary>
    public Vector512<float> Zmm4 { get; set; }
    /// <summary>
    /// Represents the YMM4 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM4 register.
    /// </remarks>
    public Vector256<float> Ymm4
    {
        get => Zmm4.GetLower();
        set => Zmm4 = Zmm4.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM4 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM4 register.
    /// </remarks>
    public Vector128<float> Xmm4
    {
        get => Ymm4.GetLower();
        set => Ymm4 = Ymm4.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM5 vector register.
    /// </summary>
    public Vector512<float> Zmm5 { get; set; }
    /// <summary>
    /// Represents the YMM5 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM5 register.
    /// </remarks>
    public Vector256<float> Ymm5
    {
        get => Zmm5.GetLower();
        set => Zmm5 = Zmm5.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM5 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM5 register.
    /// </remarks>
    public Vector128<float> Xmm5
    {
        get => Ymm5.GetLower();
        set => Ymm5 = Ymm5.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM6 vector register.
    /// </summary>
    public Vector512<float> Zmm6 { get; set; }
    /// <summary>
    /// Represents the YMM6 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM6 register.
    /// </remarks>
    public Vector256<float> Ymm6
    {
        get => Zmm6.GetLower();
        set => Zmm6 = Zmm6.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM6 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM6 register.
    /// </remarks>
    public Vector128<float> Xmm6
    {
        get => Ymm6.GetLower();
        set => Ymm6 = Ymm6.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM7 vector register.
    /// </summary>
    public Vector512<float> Zmm7 { get; set; }
    /// <summary>
    /// Represents the YMM7 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM7 register.
    /// </remarks>
    public Vector256<float> Ymm7
    {
        get => Zmm7.GetLower();
        set => Zmm7 = Zmm7.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM7 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM7 register.
    /// </remarks>
    public Vector128<float> Xmm7
    {
        get => Ymm7.GetLower();
        set => Ymm7 = Ymm7.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM8 vector register.
    /// </summary>
    public Vector512<float> Zmm8 { get; set; }
    /// <summary>
    /// Represents the YMM8 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM8 register.
    /// </remarks>
    public Vector256<float> Ymm8
    {
        get => Zmm8.GetLower();
        set => Zmm8 = Zmm8.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM8 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM8 register.
    /// </remarks>
    public Vector128<float> Xmm8
    {
        get => Ymm8.GetLower();
        set => Ymm8 = Ymm8.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM9 vector register.
    /// </summary>
    public Vector512<float> Zmm9 { get; set; }
    /// <summary>
    /// Represents the YMM9 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM9 register.
    /// </remarks>
    public Vector256<float> Ymm9
    {
        get => Zmm9.GetLower();
        set => Zmm9 = Zmm9.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM9 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM9 register.
    /// </remarks>
    public Vector128<float> Xmm9
    {
        get => Ymm9.GetLower();
        set => Ymm9 = Ymm9.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM10 vector register.
    /// </summary>
    public Vector512<float> Zmm10 { get; set; }
    /// <summary>
    /// Represents the YMM10 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM10 register.
    /// </remarks>
    public Vector256<float> Ymm10
    {
        get => Zmm10.GetLower();
        set => Zmm10 = Zmm10.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM10 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM10 register.
    /// </remarks>
    public Vector128<float> Xmm10
    {
        get => Ymm10.GetLower();
        set => Ymm10 = Ymm10.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM11 vector register.
    /// </summary>
    public Vector512<float> Zmm11 { get; set; }
    /// <summary>
    /// Represents the YMM11 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM11 register.
    /// </remarks>
    public Vector256<float> Ymm11
    {
        get => Zmm11.GetLower();
        set => Zmm11 = Zmm11.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM11 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM11 register.
    /// </remarks>
    public Vector128<float> Xmm11
    {
        get => Ymm11.GetLower();
        set => Ymm11 = Ymm11.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM12 vector register.
    /// </summary>
    public Vector512<float> Zmm12 { get; set; }
    /// <summary>
    /// Represents the YMM12 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM12 register.
    /// </remarks>
    public Vector256<float> Ymm12
    {
        get => Zmm12.GetLower();
        set => Zmm12 = Zmm12.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM12 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM12 register.
    /// </remarks>
    public Vector128<float> Xmm12
    {
        get => Ymm12.GetLower();
        set => Ymm12 = Ymm12.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM13 vector register.
    /// </summary>
    public Vector512<float> Zmm13 { get; set; }
    /// <summary>
    /// Represents the YMM13 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM13 register.
    /// </remarks>
    public Vector256<float> Ymm13
    {
        get => Zmm13.GetLower();
        set => Zmm13 = Zmm13.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM13 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM13 register.
    /// </remarks>
    public Vector128<float> Xmm13
    {
        get => Ymm13.GetLower();
        set => Ymm13 = Ymm13.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM14 vector register.
    /// </summary>
    public Vector512<float> Zmm14 { get; set; }
    /// <summary>
    /// Represents the YMM14 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM14 register.
    /// </remarks>
    public Vector256<float> Ymm14
    {
        get => Zmm14.GetLower();
        set => Zmm14 = Zmm14.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM14 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM14 register.
    /// </remarks>
    public Vector128<float> Xmm14
    {
        get => Ymm14.GetLower();
        set => Ymm14 = Ymm14.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM15 vector register.
    /// </summary>
    public Vector512<float> Zmm15 { get; set; }
    /// <summary>
    /// Represents the YMM15 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM15 register.
    /// </remarks>
    public Vector256<float> Ymm15
    {
        get => Zmm15.GetLower();
        set => Zmm15 = Zmm15.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM15 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM15 register.
    /// </remarks>
    public Vector128<float> Xmm15
    {
        get => Ymm15.GetLower();
        set => Ymm15 = Ymm15.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM16 vector register.
    /// </summary>
    public Vector512<float> Zmm16 { get; set; }
    /// <summary>
    /// Represents the YMM16 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM16 register.
    /// </remarks>
    public Vector256<float> Ymm16
    {
        get => Zmm16.GetLower();
        set => Zmm16 = Zmm16.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM16 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM16 register.
    /// </remarks>
    public Vector128<float> Xmm16
    {
        get => Ymm16.GetLower();
        set => Ymm16 = Ymm16.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM17 vector register.
    /// </summary>
    public Vector512<float> Zmm17 { get; set; }
    /// <summary>
    /// Represents the YMM17 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM17 register.
    /// </remarks>
    public Vector256<float> Ymm17
    {
        get => Zmm17.GetLower();
        set => Zmm17 = Zmm17.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM17 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM17 register.
    /// </remarks>
    public Vector128<float> Xmm17
    {
        get => Ymm17.GetLower();
        set => Ymm17 = Ymm17.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM18 vector register.
    /// </summary>
    public Vector512<float> Zmm18 { get; set; }
    /// <summary>
    /// Represents the YMM18 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM18 register.
    /// </remarks>
    public Vector256<float> Ymm18
    {
        get => Zmm18.GetLower();
        set => Zmm18 = Zmm18.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM18 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM18 register.
    /// </remarks>
    public Vector128<float> Xmm18
    {
        get => Ymm18.GetLower();
        set => Ymm18 = Ymm18.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM19 vector register.
    /// </summary>
    public Vector512<float> Zmm19 { get; set; }
    /// <summary>
    /// Represents the YMM19 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM19 register.
    /// </remarks>
    public Vector256<float> Ymm19
    {
        get => Zmm19.GetLower();
        set => Zmm19 = Zmm19.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM19 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM19 register.
    /// </remarks>
    public Vector128<float> Xmm19
    {
        get => Ymm19.GetLower();
        set => Ymm19 = Ymm19.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM20 vector register.
    /// </summary>
    public Vector512<float> Zmm20 { get; set; }
    /// <summary>
    /// Represents the YMM20 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM20 register.
    /// </remarks>
    public Vector256<float> Ymm20
    {
        get => Zmm20.GetLower();
        set => Zmm20 = Zmm20.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM20 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM20 register.
    /// </remarks>
    public Vector128<float> Xmm20
    {
        get => Ymm20.GetLower();
        set => Ymm20 = Ymm20.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM21 vector register.
    /// </summary>
    public Vector512<float> Zmm21 { get; set; }
    /// <summary>
    /// Represents the YMM21 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM21 register.
    /// </remarks>
    public Vector256<float> Ymm21
    {
        get => Zmm21.GetLower();
        set => Zmm21 = Zmm21.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM21 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM21 register.
    /// </remarks>
    public Vector128<float> Xmm21
    {
        get => Ymm21.GetLower();
        set => Ymm21 = Ymm21.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM22 vector register.
    /// </summary>
    public Vector512<float> Zmm22 { get; set; }
    /// <summary>
    /// Represents the YMM22 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM22 register.
    /// </remarks>
    public Vector256<float> Ymm22
    {
        get => Zmm22.GetLower();
        set => Zmm22 = Zmm22.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM22 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM22 register.
    /// </remarks>
    public Vector128<float> Xmm22
    {
        get => Ymm22.GetLower();
        set => Ymm22 = Ymm22.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM23 vector register.
    /// </summary>
    public Vector512<float> Zmm23 { get; set; }
    /// <summary>
    /// Represents the YMM23 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM23 register.
    /// </remarks>
    public Vector256<float> Ymm23
    {
        get => Zmm23.GetLower();
        set => Zmm23 = Zmm23.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM23 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM23 register.
    /// </remarks>
    public Vector128<float> Xmm23
    {
        get => Ymm23.GetLower();
        set => Ymm23 = Ymm23.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM24 vector register.
    /// </summary>
    public Vector512<float> Zmm24 { get; set; }
    /// <summary>
    /// Represents the YMM24 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM24 register.
    /// </remarks>
    public Vector256<float> Ymm24
    {
        get => Zmm24.GetLower();
        set => Zmm24 = Zmm24.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM24 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM24 register.
    /// </remarks>
    public Vector128<float> Xmm24
    {
        get => Ymm24.GetLower();
        set => Ymm24 = Ymm24.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM25 vector register.
    /// </summary>
    public Vector512<float> Zmm25 { get; set; }
    /// <summary>
    /// Represents the YMM25 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM25 register.
    /// </remarks>
    public Vector256<float> Ymm25
    {
        get => Zmm25.GetLower();
        set => Zmm25 = Zmm25.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM25 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM25 register.
    /// </remarks>
    public Vector128<float> Xmm25
    {
        get => Ymm25.GetLower();
        set => Ymm25 = Ymm25.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM26 vector register.
    /// </summary>
    public Vector512<float> Zmm26 { get; set; }
    /// <summary>
    /// Represents the YMM26 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM26 register.
    /// </remarks>
    public Vector256<float> Ymm26
    {
        get => Zmm26.GetLower();
        set => Zmm26 = Zmm26.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM26 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM26 register.
    /// </remarks>
    public Vector128<float> Xmm26
    {
        get => Ymm26.GetLower();
        set => Ymm26 = Ymm26.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM27 vector register.
    /// </summary>
    public Vector512<float> Zmm27 { get; set; }
    /// <summary>
    /// Represents the YMM27 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM27 register.
    /// </remarks>
    public Vector256<float> Ymm27
    {
        get => Zmm27.GetLower();
        set => Zmm27 = Zmm27.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM27 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM27 register.
    /// </remarks>
    public Vector128<float> Xmm27
    {
        get => Ymm27.GetLower();
        set => Ymm27 = Ymm27.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM28 vector register.
    /// </summary>
    public Vector512<float> Zmm28 { get; set; }
    /// <summary>
    /// Represents the YMM28 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM28 register.
    /// </remarks>
    public Vector256<float> Ymm28
    {
        get => Zmm28.GetLower();
        set => Zmm28 = Zmm28.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM28 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM28 register.
    /// </remarks>
    public Vector128<float> Xmm28
    {
        get => Ymm28.GetLower();
        set => Ymm28 = Ymm28.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM29 vector register.
    /// </summary>
    public Vector512<float> Zmm29 { get; set; }
    /// <summary>
    /// Represents the YMM29 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM29 register.
    /// </remarks>
    public Vector256<float> Ymm29
    {
        get => Zmm29.GetLower();
        set => Zmm29 = Zmm29.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM29 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM29 register.
    /// </remarks>
    public Vector128<float> Xmm29
    {
        get => Ymm29.GetLower();
        set => Ymm29 = Ymm29.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM30 vector register.
    /// </summary>
    public Vector512<float> Zmm30 { get; set; }
    /// <summary>
    /// Represents the YMM30 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM30 register.
    /// </remarks>
    public Vector256<float> Ymm30
    {
        get => Zmm30.GetLower();
        set => Zmm30 = Zmm30.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM30 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM30 register.
    /// </remarks>
    public Vector128<float> Xmm30
    {
        get => Ymm30.GetLower();
        set => Ymm30 = Ymm30.WithLower(value);
    }
    /// <summary>
    /// Represents the ZMM31 vector register.
    /// </summary>
    public Vector512<float> Zmm31 { get; set; }
    /// <summary>
    /// Represents the YMM31 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the ZMM31 register.
    /// </remarks>
    public Vector256<float> Ymm31
    {
        get => Zmm31.GetLower();
        set => Zmm31 = Zmm31.WithLower(value);
    }
    /// <summary>
    /// Represents the XMM31 vector register.
    /// </summary>
    /// <remarks>
    /// This register is part of the YMM31 register.
    /// </remarks>
    public Vector128<float> Xmm31
    {
        get => Ymm31.GetLower();
        set => Ymm31 = Ymm31.WithLower(value);
    }
    /// <summary>
    /// Represents the K0 register.
    /// </summary>
    public ulong K0 { get; set; }
    /// <summary>
    /// Represents the K1 register.
    /// </summary>
    public ulong K1 { get; set; }
    /// <summary>
    /// Represents the K2 register.
    /// </summary>
    public ulong K2 { get; set; }
    /// <summary>
    /// Represents the K3 register.
    /// </summary>
    public ulong K3 { get; set; }
    /// <summary>
    /// Represents the K4 register.
    /// </summary>
    public ulong K4 { get; set; }
    /// <summary>
    /// Represents the K5 register.
    /// </summary>
    public ulong K5 { get; set; }
    /// <summary>
    /// Represents the K6 register.
    /// </summary>
    public ulong K6 { get; set; }
    /// <summary>
    /// Represents the K7 register.
    /// </summary>
    public ulong K7 { get; set; }
    /// <summary>
    /// Represents the CR0 register.
    /// </summary>
    public ulong CR0 { get; set; }
    /// <summary>
    /// Represents the CR1 register.
    /// </summary>
    public ulong CR1 { get; set; }
    /// <summary>
    /// Represents the CR2 register.
    /// </summary>
    public ulong CR2 { get; set; }
    /// <summary>
    /// Represents the CR3 register.
    /// </summary>
    public ulong CR3 { get; set; }
    /// <summary>
    /// Represents the CR4 register.
    /// </summary>
    public ulong CR4 { get; set; }
    /// <summary>
    /// Represents the CR5 register.
    /// </summary>
    public ulong CR5 { get; set; }
    /// <summary>
    /// Represents the CR6 register.
    /// </summary>
    public ulong CR6 { get; set; }
    /// <summary>
    /// Represents the CR7 register.
    /// </summary>
    public ulong CR7 { get; set; }
    /// <summary>
    /// Represents the TR0 register.
    /// </summary>
    public ulong TR0 { get; set; }
    /// <summary>
    /// Represents the TR1 register.
    /// </summary>
    public ulong TR1 { get; set; }
    /// <summary>
    /// Represents the TR2 register.
    /// </summary>
    public ulong TR2 { get; set; }
    /// <summary>
    /// Represents the TR3 register.
    /// </summary>
    public ulong TR3 { get; set; }
    /// <summary>
    /// Represents the TR4 register.
    /// </summary>
    public ulong TR4 { get; set; }
    /// <summary>
    /// Represents the TR5 register.
    /// </summary>
    public ulong TR5 { get; set; }
    /// <summary>
    /// Represents the TR6 register.
    /// </summary>
    public ulong TR6 { get; set; }
    /// <summary>
    /// Represents the TR7 register.
    /// </summary>
    public ulong TR7 { get; set; }
    /// <summary>
    /// Represents the DR0 register.
    /// </summary>
    public ulong DR0 { get; set; }
    /// <summary>
    /// Represents the DR1 register.
    /// </summary>
    public ulong DR1 { get; set; }
    /// <summary>
    /// Represents the DR2 register.
    /// </summary>
    public ulong DR2 { get; set; }
    /// <summary>
    /// Represents the DR3 register.
    /// </summary>
    public ulong DR3 { get; set; }
    /// <summary>
    /// Represents the DR4 register.
    /// </summary>
    public ulong DR4 { get; set; }
    /// <summary>
    /// Represents the DR5 register.
    /// </summary>
    public ulong DR5 { get; set; }
    /// <summary>
    /// Represents the DR6 register.
    /// </summary>
    public ulong DR6 { get; set; }
    /// <summary>
    /// Represents the DR7 register.
    /// </summary>
    public ulong DR7 { get; set; }
    /// <summary>
    /// Represents the MM0 register.
    /// </summary>
    public ulong MM0 { get; set; }
    /// <summary>
    /// Represents the MM1 register.
    /// </summary>
    public ulong MM1 { get; set; }
    /// <summary>
    /// Represents the MM2 register.
    /// </summary>
    public ulong MM2 { get; set; }
    /// <summary>
    /// Represents the MM3 register.
    /// </summary>
    public ulong MM3 { get; set; }
    /// <summary>
    /// Represents the MM4 register.
    /// </summary>
    public ulong MM4 { get; set; }
    /// <summary>
    /// Represents the MM5 register.
    /// </summary>
    public ulong MM5 { get; set; }
    /// <summary>
    /// Represents the MM6 register.
    /// </summary>
    public ulong MM6 { get; set; }
    /// <summary>
    /// Represents the MM7 register.
    /// </summary>
    public ulong MM7 { get; set; }
    /// <summary>
    /// Represents the PKRU register.
    /// </summary>
    public ulong Pkru { get; set; }
    /// <summary>
    /// Represents the MSR register.
    /// </summary>
    public ulong Msr { get; set; }
    /// <summary>
    /// Gets/sets the <c>CF</c> (Carry Flag) flag.
    /// </summary>
    public bool RFlagsCF
    {
        get => (byte)(RFlags & 0x1) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 0;
            }
            else
            {
                RFlags &= ~(1UL << 0);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>PF</c> (Parity Flag) flag.
    /// </summary>
    public bool RFlagsPF
    {
        get => (byte)(RFlags & 0x4) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 2;
            }
            else
            {
                RFlags &= ~(1UL << 2);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>AF</c> (Auxiliary Flag) flag.
    /// </summary>
    public bool RFlagsAF
    {
        get => (byte)(RFlags & 0x10) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 4;
            }
            else
            {
                RFlags &= ~(1UL << 4);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>ZF</c> (Zero Flag) flag.
    /// </summary>
    public bool RFlagsZF
    {
        get => (byte)(RFlags & 0x40) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 6;
            }
            else
            {
                RFlags &= ~(1UL << 6);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>SF</c> (Sign Flag) flag.
    /// </summary>
    public bool RFlagsSF
    {
        get => (byte)(RFlags & 0x80) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 7;
            }
            else
            {
                RFlags &= ~(1UL << 7);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>TF</c> (Trap Flag) flag.
    /// </summary>
    public bool RFlagsTF
    {
        get => (byte)(RFlags & 0x100) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 8;
            }
            else
            {
                RFlags &= ~(1UL << 8);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>IF</c> (Interrupt Enable Flag) flag.
    /// </summary>
    public bool RFlagsIF
    {
        get => (byte)(RFlags & 0x200) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 9;
            }
            else
            {
                RFlags &= ~(1UL << 9);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>DF</c> (Direction Flag) flag.
    /// </summary>
    public bool RFlagsDF
    {
        get => (byte)(RFlags & 0x400) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 10;
            }
            else
            {
                RFlags &= ~(1UL << 10);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>OF</c> (Overflow Flag) flag.
    /// </summary>
    public bool RFlagsOF
    {
        get => (byte)(RFlags & 0x800) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 11;
            }
            else
            {
                RFlags &= ~(1UL << 11);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>IOPL</c> (I/O Privilege Level Flag) flag.
    /// </summary>
    public bool RFlagsIOPL
    {
        get => (byte)(RFlags & 0x1000) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 12;
            }
            else
            {
                RFlags &= ~(1UL << 12);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>IOPL2</c> (I/O Privilege Level Flag (2)) flag.
    /// </summary>
    public bool RFlagsIOPL2
    {
        get => (byte)(RFlags & 0x2000) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 13;
            }
            else
            {
                RFlags &= ~(1UL << 13);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>NT</c> (Nested Task Flag) flag.
    /// </summary>
    public bool RFlagsNT
    {
        get => (byte)(RFlags & 0x4000) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 14;
            }
            else
            {
                RFlags &= ~(1UL << 14);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>RF</c> (Resume Flag) flag.
    /// </summary>
    public bool RFlagsRF
    {
        get => (byte)(RFlags & 0x10000) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 16;
            }
            else
            {
                RFlags &= ~(1UL << 16);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>VM</c> (Virtual-8086 Mode Flag) flag.
    /// </summary>
    public bool RFlagsVM
    {
        get => (byte)(RFlags & 0x20000) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 17;
            }
            else
            {
                RFlags &= ~(1UL << 17);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>AC</c> (Alignment Check Flag) flag.
    /// </summary>
    public bool RFlagsAC
    {
        get => (byte)(RFlags & 0x40000) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 18;
            }
            else
            {
                RFlags &= ~(1UL << 18);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>VIF</c> (Virtual Interrupt Flag) flag.
    /// </summary>
    public bool RFlagsVIF
    {
        get => (byte)(RFlags & 0x80000) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 19;
            }
            else
            {
                RFlags &= ~(1UL << 19);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>VIP</c> (Virtual Interrupt Pending Flag) flag.
    /// </summary>
    public bool RFlagsVIP
    {
        get => (byte)(RFlags & 0x100000) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 20;
            }
            else
            {
                RFlags &= ~(1UL << 20);
            }
        }
    }
    /// <summary>
    /// Gets/sets the <c>ID</c> (ID Flag) flag.
    /// </summary>
    public bool RFlagsID
    {
        get => (byte)(RFlags & 0x200000) == 0;
        set
        {
            if (value)
            {
                RFlags |= 1UL << 21;
            }
            else
            {
                RFlags &= ~(1UL << 21);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>PE</c> (Protection Enable) flag.
    /// </summary>
    public bool CR0PE
    {
        get => (byte)(CR0 & 0x1) == 0;
        set
        {
            if (value)
            {
                CR0 |= 1UL << 0;
            }
            else
            {
                CR0 &= ~(1UL << 0);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>MP</c> (Monitor Coprocessor) flag.
    /// </summary>
    public bool CR0MP
    {
        get => (byte)(CR0 & 0x2) == 0;
        set
        {
            if (value)
            {
                CR0 |= 1UL << 1;
            }
            else
            {
                CR0 &= ~(1UL << 1);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>EM</c> (Emulation) flag.
    /// </summary>
    public bool CR0EM
    {
        get => (byte)(CR0 & 0x4) == 0;
        set
        {
            if (value)
            {
                CR0 |= 1UL << 2;
            }
            else
            {
                CR0 &= ~(1UL << 2);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>TS</c> (Task Switched) flag.
    /// </summary>
    public bool CR0TS
    {
        get => (byte)(CR0 & 0x8) == 0;
        set
        {
            if (value)
            {
                CR0 |= 1UL << 3;
            }
            else
            {
                CR0 &= ~(1UL << 3);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>ET</c> (Extension Type) flag.
    /// </summary>
    public bool CR0ET
    {
        get => (byte)(CR0 & 0x10) == 0;
        set
        {
            if (value)
            {
                CR0 |= 1UL << 4;
            }
            else
            {
                CR0 &= ~(1UL << 4);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>NE</c> (Numeric Error) flag.
    /// </summary>
    public bool CR0NE
    {
        get => (byte)(CR0 & 0x20) == 0;
        set
        {
            if (value)
            {
                CR0 |= 1UL << 5;
            }
            else
            {
                CR0 &= ~(1UL << 5);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>WP</c> (Write Protect) flag.
    /// </summary>
    public bool CR0WP
    {
        get => (byte)(CR0 & 0x10000) == 0;
        set
        {
            if (value)
            {
                CR0 |= 1UL << 16;
            }
            else
            {
                CR0 &= ~(1UL << 16);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>AM</c> (Alignment Mask) flag.
    /// </summary>
    public bool CR0AM
    {
        get => (byte)(CR0 & 0x40000) == 0;
        set
        {
            if (value)
            {
                CR0 |= 1UL << 18;
            }
            else
            {
                CR0 &= ~(1UL << 18);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>NW</c> (Not Write-through) flag.
    /// </summary>
    public bool CR0NW
    {
        get => (byte)(CR0 & 0x20000000) == 0;
        set
        {
            if (value)
            {
                CR0 |= 1UL << 29;
            }
            else
            {
                CR0 &= ~(1UL << 29);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>CD</c> (Cache Disable) flag.
    /// </summary>
    public bool CR0CD
    {
        get => (byte)(CR0 & 0x40000000) == 0;
        set
        {
            if (value)
            {
                CR0 |= 1UL << 30;
            }
            else
            {
                CR0 &= ~(1UL << 30);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR0" /> register, gets/sets the <c>PG</c> (Paging) flag.
    /// </summary>
    public bool CR0PG
    {
        get => (byte)(CR0 & 0x80000000) == 0;
        set
        {
            if (value)
            {
                CR0 |= 1UL << 31;
            }
            else
            {
                CR0 &= ~(1UL << 31);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>VME</c> (Virtual 8086 Mode Extensions) flag.
    /// </summary>
    public bool CR4VME
    {
        get => (byte)(CR4 & 0x1) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 0;
            }
            else
            {
                CR4 &= ~(1UL << 0);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PVI</c> (Protected-mode Virtual Interrupts) flag.
    /// </summary>
    public bool CR4PVI
    {
        get => (byte)(CR4 & 0x2) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 1;
            }
            else
            {
                CR4 &= ~(1UL << 1);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>TSD</c> (Time Stamp Disable) flag.
    /// </summary>
    public bool CR4TSD
    {
        get => (byte)(CR4 & 0x4) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 2;
            }
            else
            {
                CR4 &= ~(1UL << 2);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>DE</c> (Debugging Extensions) flag.
    /// </summary>
    public bool CR4DE
    {
        get => (byte)(CR4 & 0x8) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 3;
            }
            else
            {
                CR4 &= ~(1UL << 3);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PSE</c> (Page Size Extension) flag.
    /// </summary>
    public bool CR4PSE
    {
        get => (byte)(CR4 & 0x10) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 4;
            }
            else
            {
                CR4 &= ~(1UL << 4);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PAE</c> (Physical Address Extension) flag.
    /// </summary>
    public bool CR4PAE
    {
        get => (byte)(CR4 & 0x20) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 5;
            }
            else
            {
                CR4 &= ~(1UL << 5);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>MCE</c> (Machine Check Extension) flag.
    /// </summary>
    public bool CR4MCE
    {
        get => (byte)(CR4 & 0x40) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 6;
            }
            else
            {
                CR4 &= ~(1UL << 6);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PGE</c> (Page Global Enabled) flag.
    /// </summary>
    public bool CR4PGE
    {
        get => (byte)(CR4 & 0x80) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 7;
            }
            else
            {
                CR4 &= ~(1UL << 7);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PCE</c> (Performance-Monitoring Counter enable) flag.
    /// </summary>
    public bool CR4PCE
    {
        get => (byte)(CR4 & 0x100) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 8;
            }
            else
            {
                CR4 &= ~(1UL << 8);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>OSFXSR</c> (Operating system support for FXSAVE and FXRSTOR instructions) flag.
    /// </summary>
    public bool CR4OSFXSR
    {
        get => (byte)(CR4 & 0x200) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 9;
            }
            else
            {
                CR4 &= ~(1UL << 9);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>OSXMMEXCPT</c> (Operating System Support for Unmasked SIMD Floating-Point Exceptions) flag.
    /// </summary>
    public bool CR4OSXMMEXCPT
    {
        get => (byte)(CR4 & 0x400) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 10;
            }
            else
            {
                CR4 &= ~(1UL << 10);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>UMIP</c> (User-mode Instruction Prevention) flag.
    /// </summary>
    public bool CR4UMIP
    {
        get => (byte)(CR4 & 0x800) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 11;
            }
            else
            {
                CR4 &= ~(1UL << 11);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>LA57</c> (57-bit linear addresses) flag.
    /// </summary>
    public bool CR4LA57
    {
        get => (byte)(CR4 & 0x1000) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 12;
            }
            else
            {
                CR4 &= ~(1UL << 12);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>VMXE</c> (Virtual Machine Extensions Enable) flag.
    /// </summary>
    public bool CR4VMXE
    {
        get => (byte)(CR4 & 0x2000) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 13;
            }
            else
            {
                CR4 &= ~(1UL << 13);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>SMXE</c> (Safer Mode Extensions Enable) flag.
    /// </summary>
    public bool CR4SMXE
    {
        get => (byte)(CR4 & 0x4000) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 14;
            }
            else
            {
                CR4 &= ~(1UL << 14);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>FSGSBASE</c> (Enable RDFSBASE, RDGSBASE, WRFSBASE, and WRGSBASE instructions) flag.
    /// </summary>
    public bool CR4FSGSBASE
    {
        get => (byte)(CR4 & 0x10000) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 16;
            }
            else
            {
                CR4 &= ~(1UL << 16);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PCIDE</c> (Process-Context Identifiers Enable) flag.
    /// </summary>
    public bool CR4PCIDE
    {
        get => (byte)(CR4 & 0x20000) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 17;
            }
            else
            {
                CR4 &= ~(1UL << 17);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>OSXSAVE</c> (XSAVE and Processor Extended States Enable) flag.
    /// </summary>
    public bool CR4OSXSAVE
    {
        get => (byte)(CR4 & 0x40000) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 18;
            }
            else
            {
                CR4 &= ~(1UL << 18);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>SMEP</c> (Supervisor Mode Execution Protection) flag.
    /// </summary>
    public bool CR4SMEP
    {
        get => (byte)(CR4 & 0x100000) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 20;
            }
            else
            {
                CR4 &= ~(1UL << 20);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>SMAP</c> (Supervisor Mode Access Prevention) flag.
    /// </summary>
    public bool CR4SMAP
    {
        get => (byte)(CR4 & 0x200000) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 21;
            }
            else
            {
                CR4 &= ~(1UL << 21);
            }
        }
    }
    /// <summary>
    /// From the <see cref="CR4" /> register, gets/sets the <c>PKE</c> (Protection Key Enable) flag.
    /// </summary>
    public bool CR4PKE
    {
        get => (byte)(CR4 & 0x400000) == 0;
        set
        {
            if (value)
            {
                CR4 |= 1UL << 22;
            }
            else
            {
                CR4 &= ~(1UL << 22);
            }
        }
    }
    /// <summary>
    /// Represents the AH register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the AX register.
    /// </remarks>
    public byte Ah
    {
        get => (byte)(Ax >> 8);
        set => Ax = (ushort)((Ax & 0x00FF) | (byte)value << 8);
    }
    /// <summary>
    /// Represents the BH register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the BX register.
    /// </remarks>
    public byte Bh
    {
        get => (byte)(Bx >> 8);
        set => Bx = (ushort)((Bx & 0x00FF) | (byte)value << 8);
    }
    /// <summary>
    /// Represents the CH register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the CX register.
    /// </remarks>
    public byte Ch
    {
        get => (byte)(Cx >> 8);
        set => Cx = (ushort)((Cx & 0x00FF) | (byte)value << 8);
    }
    /// <summary>
    /// Represents the DH register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the DX register.
    /// </remarks>
    public byte Dh
    {
        get => (byte)(Dx >> 8);
        set => Dx = (ushort)((Dx & 0x00FF) | (byte)value << 8);
    }
    /// <summary>
    /// Represents the AL register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the AX register.
    /// </remarks>
    public byte Al
    {
        get => (byte)(Ax & 0x00FF);
        set => Ax = (byte)((Ax & 0xFF00) | value);
    }
    /// <summary>
    /// Represents the BL register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the BX register.
    /// </remarks>
    public byte Bl
    {
        get => (byte)(Bx & 0x00FF);
        set => Bx = (byte)((Bx & 0xFF00) | value);
    }
    /// <summary>
    /// Represents the CL register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the CX register.
    /// </remarks>
    public byte Cl
    {
        get => (byte)(Cx & 0x00FF);
        set => Cx = (byte)((Cx & 0xFF00) | value);
    }
    /// <summary>
    /// Represents the DL register.
    /// </summary>
    /// <remarks>
    /// This register is bound to the DX register.
    /// </remarks>
    public byte Dl
    {
        get => (byte)(Dx & 0x00FF);
        set => Dx = (byte)((Dx & 0xFF00) | value);
    }
}

}