# Contributing

## Quick Start

Don't reply on markdown editor. Start the application locally to make and verify your changes.

```bash
cd leetcode-the-hard-way
npm i 
npm run start
# By default, a browser window will open at http://localhost:3000/.
```

## Before Creating a PR 

See the [Checklist](https://github.com/wingkwong/leetcode-the-hard-way/blob/main/.github/pull_request_template.md#checklist).

## Tutorial Template

Tutorials markdown files are stored under `./tutorials`.

````md
---
title: '<TITLE>'
description: '<DESCRIPTION_OF_THE_TOPIC>'
hide_table_of_contents: true
---

<TutorialAuthors names="@<YOUR_ALIAS>"/>

## Overview

// TODO: Overview of the topic

// DO NOT COPY FROM OTHER EXTERNAL SITES
// DO NOT USE RANDOM EXAMPLES OR EXAMPLES FROM OTHER SITES

// TODO: Complexity Analysis
// TODO: Walk through the topic using 2 - 3 LC problems

### Example : [<PROBLEM_ID> - <PROBLEM_TITLE>](<LC_LINK>)

> <PROBLEM STATEMENT>

// TODO: Your explanation
// TODO: Your solution to the problem

// TODO: add Suggested Problems (See the examples below to learn how to render)
````

Examples: 

- [binary-exponentiation.md](https://raw.githubusercontent.com/wingkwong/leetcode-the-hard-way/main/tutorials/math/number-theory/binary-exponentiation.md)

- [prefix-sum.md](https://raw.githubusercontent.com/wingkwong/leetcode-the-hard-way/main/tutorials/basic-topics/prefix-sum.md)

## Solution Template

- Solution markdown files are stored under `./solutions`.
- File name format: `<PROBLEM_ID>-<PROBLEM_TITLE>-<DIFFICULTY>.md`, e.g. `0202-happy-number-easy.md`

````md
// The Meta and Problem Statement can be generated by using a Chrome extension under `converter` locally. 
// If you do not know how to do it, leave it blank and @wingkwong will help add them.

## Approach 1: <APPROACH_NAME>

// TODO: Detailed Explanations / Line by Line Explanations in code
// TODO: Complexity Analysis

<Tabs>
<TabItem value="cpp" label="C++">
<SolutionAuthor name="@YOUR_ALIAS"/>

```cpp
// Your code goes here
```

</TabItem>
<TabItem value="py" label="Python">
<SolutionAuthor name="@YOUR_ALIAS"/>

```py
# Your code goes here
```

</TabItem>
<TabItem value="go" label="Go">
<SolutionAuthor name="@YOUR_ALIAS"/>

```go
// Your code goes here
```

</TabItem>
</Tabs>

## Approach 2: <APPROACH_NAME> (ADD IT IF NECESSARY)

// TODO: Detailed Explanations / Line by Line Explanations in code
// TODO: Complexity Analysis

<Tabs>
<TabItem value="cpp" label="C++">
<SolutionAuthor name="@YOUR_ALIAS"/>

```cpp
// Your code goes here
```

</TabItem>
<TabItem value="py" label="Python">
<SolutionAuthor name="@YOUR_ALIAS"/>

```py
# Your code goes here
```

</TabItem>
<TabItem value="go" label="Go">
<SolutionAuthor name="@YOUR_ALIAS"/>

```go
// Your code goes here
```

</TabItem>
</Tabs>
````

Examples: 

- [0191-number-of-1-bits-easy.md](https://raw.githubusercontent.com/wingkwong/leetcode-the-hard-way/main/solutions/0100-0199/0191-number-of-1-bits-easy.md)

## Misc

- For images, please copy and paste to Github editor (the image will be uploaded to github content) to get the image link (e.g. https://user-images.githubusercontent.com/35857179/168304432-fa9ac8bb-0eb9-49d9-bdcf-5e3509c1f835.png). Do not upload any images to this repository.

- If your content includes variables or math equations, please highlight it with LaTex syntax. See [binary-exponentiation.md](https://raw.githubusercontent.com/wingkwong/leetcode-the-hard-way/main/tutorials/math/number-theory/binary-exponentiation.md) as an example.

- If you have used other resources from external sites, give references at the end.