## Change Summary

Provide summary of changes with issue number if any.

## Checklist

**If you haven't fulfilled the below requirements or even delete the entire checklist, your PR won't be reviewed and will be closed without notice. Regular contributors (with 10+ PRs) can skip this part.**

### General 

- [ ] This Pull Request is all my own work. (You'll be blacklisted if you are caught for plagiarism.)
- [ ] I've read [CONTRIBUTING.md](https://github.com/wingkwong/leetcode-the-hard-way/blob/main/CONTRIBUTING.md)
- [ ] I've applied LaTex for all variables, formulas and time / space complexity instead of using backticks
- [ ] I've started the app locally and verified all the content and all links (if applicable) are accessible correctly
- [ ] I've included Complexity Analysis (Time Complexity & Space Complexity).
- [ ] I've written my explanation well and it is easy to understand for beginners

### Tutorial

- [ ] I've read and followed the [Tutorial Template](https://github.com/wingkwong/leetcode-the-hard-way/blob/main/CONTRIBUTING.md#tutorial-template)
- [ ] I've explained my topic well with 2 - 3 LC problems and no external problems are used. 
- [ ] I've provided the full working solutions to the problems used in this tutorial.
- [ ] I've provided suggested problems at the end with the given format. See [here](https://raw.githubusercontent.com/wingkwong/leetcode-the-hard-way/main/tutorials/math/number-theory/binary-exponentiation.md) as an example. If the target solution is not available, leave `solutionLink` blank.
- [ ] I've given credits / references if I use external resources. (For an image, give credit under it. Otherwise, add a new section called References at the end (after Suggested Problems).)

### Solutions

- [ ] I've read and followed the [Solution Template](https://github.com/wingkwong/leetcode-the-hard-way/blob/main/CONTRIBUTING.md#solution-template)
- [ ] I've formatted my code well with [K&R Coding style](https://gist.github.com/jesseschalken/0f47a2b5a738ced9c845#why-kr)
- [ ] I've confirmed that comments are put above each line rather than writing on the same line.
- [ ] I've included a meaningful approach name for my solution. e.g. `## Approach 1: Two Pointers`.
