﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HRManagerSystem
{
    public partial class UpdateTrainForm : Form
    {
        public UpdateTrainForm()
        {
            InitializeComponent();
        }
        T_Trainings train1=new T_Trainings();
        T_StaffRecords staff1 = new T_StaffRecords();
        public UpdateTrainForm(T_Trainings traininfo, T_StaffRecords staffinfo)
        {
            InitializeComponent();
            this.train1 = traininfo;
            this.staff1 = staffinfo;
        }
        DataDataContext ddt = new DataDataContext();
        private void UpdateTrainForm_Load(object sender, EventArgs e)
        {
            combo_name.Text = staff1.Staff_Name;
            combo_name.Enabled = false;
            txt_content.Text = train1.Training_Content;
            txt_grade.Text = train1.Training_Grade.ToString();
            dtpicker_time1.Value = train1.Training_StartTime;
            dtpicker_time2.Value = train1.Training_EndTime;
            txt_address.Text = train1.Training_Address;
            //绑定数据源
            var result = ddt.T_Trainings.Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (train, staff) => new { train.Training_ID, staff.Staff_Name, train.Training_Content, train.Training_Grade, train.Training_Address, train.Training_StartTime, train.Training_EndTime });
            dataGridView1.DataSource = result;
            
        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            //重新修改数据
            if(DialogResult.OK==MessageBox.Show("修改成功","提示",MessageBoxButtons.OK))
            try
            {
                train1.Training_Address = txt_address.Text;
                train1.Training_Content = txt_content.Text;
                train1.Training_Grade =Convert.ToInt32(txt_grade.Text.ToString());
                train1.Training_StartTime = dtpicker_time1.Value;
                train1.Training_EndTime = dtpicker_time2.Value;
                
               
            }
            catch
            {
                MessageBox.Show("字符串转化不正确！");
            }

            //ddt.SubmitChanges();//修改数据
            //绑定数据源
            //var result = ddt.T_Trainings.Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (train, staff) => new { train.Training_ID, staff.Staff_Name, train.Training_Content, train.Training_Grade, train.Training_Address, train.Training_StartTime, train.Training_EndTime });
            //dataGridView1.DataSource = result;
        }

      
        /// <summary>
        /// 清空文本内容
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            txt_address.Clear();
            txt_content.Clear();
            txt_grade.Clear();
            
        }
        /// <summary>
        /// 退出操作
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
