﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using HRManagerSystem.Bll;
namespace HRManagerSystem
{
    public partial class StaffTrainForm : Form
    {
        public StaffTrainForm()
        {
            InitializeComponent();
        }
        DataDataContext ddt = new DataDataContext();
        Training tr = new Training();
        private void StaffTrainForm_Load(object sender, EventArgs e)
        {
            //绑定默认日期
            dtpicker_time1.Value = Convert.ToDateTime("2010-7-8");
            dtpicker_time2.Value = DateTime.Now;
            tr.Reflush(dataGridView1);
            //显示状态栏中记录总数
            toolStripStatusLabel2.Text = ddt.T_Trainings.Count().ToString();
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            
            AddTrainsForm trainform = new AddTrainsForm();
            trainform.ShowDialog();
            tr.Reflush(dataGridView1);
            //显示状态栏中记录总数
            toolStripStatusLabel2.Text = ddt.T_Trainings.Count().ToString();

        }
        T_Trainings traininfo = new T_Trainings();
        T_StaffRecords staff1 = new T_StaffRecords();
        bool mark = false;
        int trainid = 0;
        private void dataGridView1_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex > -1)
            {
                traininfo = ddt.T_Trainings.Single(oo => oo.Training_ID == Convert.ToInt32(dataGridView1.Rows[e.RowIndex].Cells[0].Value));
                staff1.Staff_Name= dataGridView1.Rows[e.RowIndex].Cells[1].Value.ToString();
                trainid = traininfo.Training_ID;

            }
            mark = true;
        }
        /// <summary>
        /// 删除操作
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            
            if (mark)
            {
                var traininfo = ddt.T_Trainings.Single(id=>id.Training_ID==trainid);
                if (DialogResult.Yes== MessageBox.Show("你确定要删除么？","提示",MessageBoxButtons.YesNo))
                {
                    ddt.T_Trainings.DeleteOnSubmit(traininfo);//单个删除
                    ddt.SubmitChanges();
                }
                //加载数据源
                tr.Reflush(dataGridView1);
                //显示状态栏中记录总数
                toolStripStatusLabel2.Text = ddt.T_Trainings.Count().ToString();
            }
            else
            {
                MessageBox.Show("请先选择一行数据再进行删除操作！", "提示", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            if (mark)
            {
                UpdateTrainForm train = new UpdateTrainForm(traininfo, staff1);
                train.ShowDialog();
               
                    ddt.SubmitChanges();
                

                
                //加载数据源
                    tr.Reflush(dataGridView1);
            }
            else
            {
                MessageBox.Show("在修改之前请选择一列数据！");
            }
           
        }
        /// <summary>
        /// 查找信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            TrainSearchForm search = new TrainSearchForm();
            search.ShowDialog();
        }
        /// <summary>
        /// 查找信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            TrainSearchForm search = new TrainSearchForm();
            search.ShowDialog();
        }

        private void toolStripButton7_Click(object sender, EventArgs e)
        {
            //加载数据源
            tr.Reflush(dataGridView1);
        }

        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            this.Close();
        }

      

       
    }
}
