﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using HRManagerSystem.Bll;
//www.51aspx.com
namespace HRManagerSystem
{
    public partial class AddTrainsForm : Form
    {
        public AddTrainsForm()
        {
            InitializeComponent();
        }
       
        DataDataContext ddt = new DataDataContext();
        Training tr = new Training();
        private void AddTrainsForm_Load(object sender, EventArgs e)
        {
            //加载时绑定数据源
            combo_name.DataSource = ddt.T_StaffRecords;
            combo_name.DisplayMember = "Staff_name";
            combo_name.ValueMember = "Staff_id";
            tr.Reflush(dataGridView1);
        }
        T_Trainings train = new T_Trainings();
        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            //异常处理         
             try 
               {
                    if (dtpicker_time1.Value >= dtpicker_time2.Value)
                    {
                        MessageBox.Show("请先选择合适的时间段！");
                        return;                        
                    }
                           train.Training_StartTime = dtpicker_time1.Value;
                           train.Training_EndTime = dtpicker_time2.Value;                    
                            train.Training_Address = txt_address.Text;
                            train.Training_Content = txt_content.Text;
                            train.Training_Grade = Convert.ToInt32(txt_grade.Text.ToString());
                            train.Staff_ID = Convert.ToInt32(combo_name.SelectedValue);
                            ddt.T_Trainings.InsertOnSubmit(train);//添加数据
                            ddt.SubmitChanges();
                            MessageBox.Show("添加成功！");                       
                         
                }
            catch
            {
                MessageBox.Show("请检查输入信息（必填的信息，输入字符串的格式）");
            }
             txt_address.Clear();
             txt_content.Clear();
             txt_grade.Clear();
             combo_name.SelectedIndex = 0;
             dtpicker_time1.Value = DateTime.Now;
             dtpicker_time2.Value = DateTime.Now;      
            //绑定数据源
            tr.Reflush(dataGridView1 );
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            txt_address.Clear();
            txt_content.Clear();
            txt_grade.Clear();
        }

        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            this.Close();
        }

       
    }
}
