﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HRManagerSystem
{
    public partial class TrainSearchForm : Form
    {
        public TrainSearchForm()
        {
            InitializeComponent();
        }
        DataDataContext ddt = new DataDataContext();
        private void 根据员工查找ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var result = ddt.T_Trainings.Where(ad=>ad.Staff_ID==(int?)combo_name.SelectedValue).Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (train, staff) => new { train.Training_ID, staff.Staff_Name, train.Training_Content, train.Training_Grade, train.Training_Address, train.Training_StartTime, train.Training_EndTime });
            dataGridView1.DataSource = result;
            if (result.Count() == 0)
            {
                MessageBox.Show("你查找的记录不存在！");
            }
        }

        private void 根据日期查找ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var result = ddt.T_Trainings.Where(time => time.Training_StartTime < dtpicker_time.Value && time.Training_EndTime > dtpicker_time.Value).Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (train, staff) => new { train.Training_ID, staff.Staff_Name, train.Training_Content, train.Training_Grade, train.Training_Address, train.Training_StartTime, train.Training_EndTime });
            dataGridView1.DataSource = result;
            if (result.Count() == 0)
            {
                MessageBox.Show("你查找的记录不存在！");
            }
        }

        private void TrainSearchForm_Load(object sender, EventArgs e)
        {
            //加载时绑定数据源
            combo_name.DataSource = ddt.T_StaffRecords;
            combo_name.DisplayMember = "Staff_name";
            combo_name.ValueMember = "Staff_id";
        }
    }
}
