﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HRManagerSystem
{
    public partial class StaffKPForm : Form
    {
        public StaffKPForm()
        {
            InitializeComponent();
        }
        DataDataContext ddc = new DataDataContext();

        #region 添加员工考评
        private void ADD_TSB_Click(object sender, EventArgs e)
        {
            Staff_ADDKP sa = new Staff_ADDKP();
            sa.ShowDialog();
            KP_DGV.DataSource = ddc.V_StaffKP.Select(a => a);
        }
        #endregion

        private void StaffKPForm_Load(object sender, EventArgs e)
        {
            KP_DGV.DataSource = ddc.V_StaffKP;
            toolStripStatusLabel2 .Text = ddc.T_KaoPing.Count().ToString ();//获得共有多少条记录
        }

        #region 修改员工考评
        private void UpDate_TSB_Click(object sender, EventArgs e)
        {
            if (mark1)
            {
                mark1 = !mark1;
                Staff_UpDateKP su = new Staff_UpDateKP();
                su.ShowDialog();               
                KP_DGV.DataSource = ddc.V_StaffKP.Select(v => v);
            }
            else
            {
                MessageBox.Show("请先选择一条记录再操作！");
            }
        }

        #endregion
        string delteid;
        bool mark1 = false;
        private void KP_DGV_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            mark1 = true;
            if (e.RowIndex > -1)
            {
                delteid = Convert.ToString(KP_DGV.Rows[e.RowIndex].Cells[0].Value);
                DateTime KPTime = Convert.ToDateTime(KP_DGV.Rows[e.RowIndex].Cells[7].Value);
            }
        }
        #region 删除员工考评
        private void De_TSB_Click(object sender, EventArgs e)
        {
            if (!mark1 )
            //if (delteid == "")
            {
                MessageBox.Show("请选择要删除的用户！");
            }
            else
            {
                try
                {
                    mark1 = !mark1;
                    if (DialogResult.OK == MessageBox.Show("确定要删除么！", "提示", MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation))
                    {
                        var deltekp = ddc.T_KaoPing.Single(staffid => staffid.KP_ID == Convert.ToInt32(delteid));//获得考评编号
                        ddc.T_KaoPing.DeleteOnSubmit(deltekp);//执行删除
                        ddc.SubmitChanges();
                        MessageBox.Show("删除成功！");
                        
                    }
                }
                catch
                { }

            }
            KP_DGV.DataSource = ddc.V_StaffKP.Select(v => v);
        }
        #endregion
        /// <summary>
        /// 刷新屏幕
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            KP_DGV.DataSource = ddc.V_StaffKP.Select(v => v);//重新更新数据
        }
        /// <summary>
        /// 退出
        /// </summary>
        public bool mark;
        private void Quit_TSB_Click(object sender, EventArgs e)
        {
            this.Close();
            //if (!mark)
            //{
            //    Environment.Exit();
            //}
        }
        /// <summary>
        /// 查询
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void SEl_TSB_Click(object sender, EventArgs e)
        {
            Staff_SelectKP sskp = new Staff_SelectKP();//new一个新的窗体
            sskp.ShowDialog();
        }
        /// <summary>
        /// 根据时间查询的最后时间点
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void EndDTP_ValueChanged(object sender, EventArgs e)
        {
            DateTime starttime = StartDTP.Value;
            DateTime endtime = EndDTP.Value;//获得最后时间点
            KP_DGV.DataSource = ddc.V_StaffKP.Where(sta => sta.考评时间 >= starttime && sta.考评时间 <= endtime);


        }
        /// <summary>
        /// 根据时间查询的开始时间点
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void StartDTP_ValueChanged(object sender, EventArgs e)
        {
            DateTime starttime = StartDTP.Value;//获得开始时间
            DateTime endtime = EndDTP.Value;
            KP_DGV.DataSource = ddc.V_StaffKP.Where(sta => sta.考评时间 >= starttime && sta.考评时间 <= endtime);//LINQ时间查询语句

        }
    }
}
