﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HRManagerSystem
{
    public partial class JC_UpdateStajc : Form
    {
        public JC_UpdateStajc()
        {
            InitializeComponent();
        }
        DataDataContext ddc = new DataDataContext();
        StaffPriseForm spf = new StaffPriseForm();
        string tjc;
        public JC_UpdateStajc(string jc)
        {
            InitializeComponent();
            this.tjc = jc;
        }
        /// <summary>
        /// 获得员工的原信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        #region 获得员工的原信息
        private void JC_UpdateStajc_Load(object sender, EventArgs e)
        {
            var de = ddc.V_StaffJC.Single(str => str.JC_ID == Convert.ToInt32(tjc));
            JC_upstano.Text = de.JC_ID.ToString();//获得员工编号
            JC_StaNameTB.Text = de.Staff_Name;//员工姓名
            JC_DepartTB.Text = de.Depart_Name;//部门
            JC_UpdateStaCM.Text = de.AwardORpunish == true ? "奖励 " : "惩罚";//是否奖罚
            JC_RseultTB.Text = de.JC_Cause;//奖罚原因
            JC_GradeTB.Text = de.JC_Money.ToString();//奖罚金额
            JC_time.Text = de.JC_Time.ToString();//受奖罚的时间
        } 
        #endregion
        /// <summary>
        /// 修改员工奖罚的信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        #region 修改员工奖罚信息
        private void UpDate_TSB_Click(object sender, EventArgs e)
        {
           
            int sa = Convert.ToInt32(JC_upstano.Text);
            T_JiangCheng jc = new T_JiangCheng();
            try
            {
                var va = ddc.T_JiangCheng.Single(vid => vid.JC_ID == sa);//判断是否与原员工ID相同
                va.JC_Money = Convert.ToDecimal(JC_GradeTB.Text);//修改受奖罚金额
                va.JC_Cause = JC_RseultTB.Text;//修改奖罚原因
                va.JC_Time = DateTime.Now;//受奖罚的时间
                //jc.Staff_ID = Convert.ToInt32(JC_staffCB.Text);
                if (JC_UpdateStaCM.Text != "")
                {
                    jc.AwardORpunish = JC_UpdateStaCM.Text == "奖励" ? true : false;//判断是否奖罚
                }
                if (sa == va.JC_ID)
                {
                    ddc.SubmitChanges();
                    MessageBox.Show("修改成功！");
                }
                else
                {
                    MessageBox.Show("修改失败！");
                }
                JC_GradeTB.Clear();
                JC_RseultTB.Clear();

            }
            //catch (Exception exc)
            //{
            //    MessageBox.Show(exc.Message);
            //}
            catch
            {
                MessageBox.Show("请先选择一条记录再修改！");
            }
            this.spf.SQLOPT();
        } 
        #endregion
        /// <summary>
        /// 退出窗体
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Quit_TSB_Click(object sender, EventArgs e)
        {
            this.Close();
            this.spf.SQLOPT();
        }
        /// <summary>
        /// 重新添加新的信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ADD_TSB_Click(object sender, EventArgs e)
        {
            JC_RseultTB.Text = "";
            JC_GradeTB.Text = "";
        }


        
    }
}
