﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using HRManagerSystem.Bll;
namespace HRManagerSystem
{
    public partial class AddFuLiForm : Form
    {
        public AddFuLiForm()
        {
            InitializeComponent();
        }
        DataDataContext ddt = new DataDataContext();
        private void AddFuLiForm_Load(object sender, EventArgs e)
        {
            //加载时绑定数据源
            combo_name.DataSource = ddt.T_StaffRecords;
            combo_name.DisplayMember = "Staff_name";
            combo_name.ValueMember = "Staff_id";
            var result = ddt.T_FuLi.Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (id1, staid1) => new { id1.FL_ID, id1.FL_Cause, id1.FL_Time, id1.FL_Money, staid1.Staff_Name });
            dataGridView1.DataSource = result;
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            //清空文本框中数据
            txt_money.Clear();
            txt_cause.Clear();
            combo_name.Focus();

        }
        
        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            T_FuLi fuli = new T_FuLi();
            try
            {
                fuli.FL_Cause = txt_cause.Text;
                fuli.FL_Money = Convert.ToDecimal(txt_money.Text);
                fuli.FL_Time = dtpicker_time.Value;
                fuli.Staff_ID = (int?)(combo_name.SelectedValue);
            }
            catch
            {
                MessageBox.Show("字符串转化不正确！");
            }
            ddt.T_FuLi.InsertOnSubmit(fuli);//添加数据
            
            ddt.SubmitChanges();
            //重新绑定数据源
            var result = ddt.T_FuLi.Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (id1, staid1) => new { id1.FL_ID, id1.FL_Cause, id1.FL_Time, id1.FL_Money, staid1.Staff_Name });
            dataGridView1.DataSource = result;
        }

        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            //退出
            this.Close();
        }

      
        
    }
}
