(function() {
    // Input 0
    var oa;
    // Input 1
    Resources = {
        regexCategories: {
            IsBasicLatin: [["0000", "007F"]],
            "IsLatin-1Supplement": [["0080", "00FF"]],
            "IsLatinExtended-A": [["0100", "017F"]],
            "IsLatinExtended-B": [["0180", "024F"]],
            IsIPAExtensions: [["0250", "02AF"]],
            IsSpacingModifierLetters: [["02B0", "02FF"]],
            IsCombiningDiacriticalMarks: [["0300", "036F"]],
            IsGreek: [["0370", "03FF"]],
            IsGreekandCoptic: [["0370", "03FF"]],
            IsCyrillic: [["0400", "04FF"]],
            IsCyrillicSupplementary: [["0500", "052F"]],
            IsCyrillicSupplement: [["0500", "052F"]],
            IsArmenian: [["0530", "058F"]],
            IsHebrew: [["0590", "05FF"]],
            IsArabic: [["0600", "06FF"]],
            IsSyriac: [["0700", "074F"]],
            IsArabicSupplement: [["0750", "077F"]],
            IsThaana: [["0780", "07BF"]],
            IsNKo: [["07C0", "07FF"]],
            IsSamaritan: [["0800", "083F"]],
            IsMandaic: [["0840", "085F"]],
            IsDevanagari: [["0900", "097F"]],
            IsBengali: [["0980", "09FF"]],
            IsGurmukhi: [["0A00", "0A7F"]],
            IsGujarati: [["0A80", "0AFF"]],
            IsOriya: [["0B00", "0B7F"]],
            IsTamil: [["0B80", "0BFF"]],
            IsTelugu: [["0C00", "0C7F"]],
            IsKannada: [["0C80", "0CFF"]],
            IsMalayalam: [["0D00", "0D7F"]],
            IsSinhala: [["0D80", "0DFF"]],
            IsThai: [["0E00", "0E7F"]],
            IsLao: [["0E80", "0EFF"]],
            IsTibetan: [["0F00", "0FFF"]],
            IsMyanmar: [["1000", "109F"]],
            IsGeorgian: [["10A0", "10FF"]],
            IsHangulJamo: [["1100", "11FF"]],
            IsEthiopic: [["1200", "137F"]],
            IsEthiopicSupplement: [["1380", "139F"]],
            IsCherokee: [["13A0", "13FF"]],
            IsUnifiedCanadianAboriginalSyllabics: [["1400", "167F"]],
            IsOgham: [["1680", "169F"]],
            IsRunic: [["16A0", "16FF"]],
            IsTagalog: [["1700", "171F"]],
            IsHanunoo: [["1720", "173F"]],
            IsBuhid: [["1740", "175F"]],
            IsTagbanwa: [["1760", "177F"]],
            IsKhmer: [["1780", "17FF"]],
            IsMongolian: [["1800", "18AF"]],
            IsUnifiedCanadianAboriginalSyllabicsExtended: [["18B0", "18FF"]],
            IsLimbu: [["1900", "194F"]],
            IsTaiLe: [["1950", "197F"]],
            IsNewTaiLue: [["1980", "19DF"]],
            IsKhmerSymbols: [["19E0", "19FF"]],
            IsBuginese: [["1A00", "1A1F"]],
            IsTaiTham: [["1A20", "1AAF"]],
            IsBalinese: [["1B00", "1B7F"]],
            IsSundanese: [["1B80", "1BBF"]],
            IsBatak: [["1BC0", "1BFF"]],
            IsLepcha: [["1C00", "1C4F"]],
            IsOlChiki: [["1C50", "1C7F"]],
            IsVedicExtensions: [["1CD0", "1CFF"]],
            IsPhoneticExtensions: [["1D00", "1D7F"]],
            IsPhoneticExtensionsSupplement: [["1D80", "1DBF"]],
            IsCombiningDiacriticalMarksSupplement: [["1DC0", "1DFF"]],
            IsLatinExtendedAdditional: [["1E00", "1EFF"]],
            IsGreekExtended: [["1F00", "1FFF"]],
            IsGeneralPunctuation: [["2000", "206F"]],
            IsSuperscriptsandSubscripts: [["2070", "209F"]],
            IsCurrencySymbols: [["20A0", "20CF"]],
            IsCombiningMarksforSymbols: [["20D0", "20FF"]],
            IsCombiningDiacriticalMarksforSymbols: [["20D0", "20FF"]],
            IsLetterlikeSymbols: [["2100", "214F"]],
            IsNumberForms: [["2150", "218F"]],
            IsArrows: [["2190", "21FF"]],
            IsMathematicalOperators: [["2200", "22FF"]],
            IsMiscellaneousTechnical: [["2300", "23FF"]],
            IsControlPictures: [["2400", "243F"]],
            IsOpticalCharacterRecognition: [["2440", "245F"]],
            IsEnclosedAlphanumerics: [["2460", "24FF"]],
            IsBoxDrawing: [["2500", "257F"]],
            IsBlockElements: [["2580", "259F"]],
            IsGeometricShapes: [["25A0", "25FF"]],
            IsMiscellaneousSymbols: [["2600", "26FF"]],
            IsDingbats: [["2700", "27BF"]],
            "IsMiscellaneousMathematicalSymbols-A": [["27C0", "27EF"]],
            "IsSupplementalArrows-A": [["27F0", "27FF"]],
            IsBraillePatterns: [["2800", "28FF"]],
            "IsSupplementalArrows-B": [["2900", "297F"]],
            "IsMiscellaneousMathematicalSymbols-B": [["2980", "29FF"]],
            IsSupplementalMathematicalOperators: [["2A00", "2AFF"]],
            IsMiscellaneousSymbolsandArrows: [["2B00", "2BFF"]],
            IsGlagolitic: [["2C00", "2C5F"]],
            "IsLatinExtended-C": [["2C60", "2C7F"]],
            IsCoptic: [["2C80", "2CFF"]],
            IsGeorgianSupplement: [["2D00", "2D2F"]],
            IsTifinagh: [["2D30", "2D7F"]],
            IsEthiopicExtended: [["2D80", "2DDF"]],
            "IsCyrillicExtended-A": [["2DE0", "2DFF"]],
            IsSupplementalPunctuation: [["2E00", "2E7F"]],
            IsCJKRadicalsSupplement: [["2E80", "2EFF"]],
            IsKangxiRadicals: [["2F00", "2FDF"]],
            IsIdeographicDescriptionCharacters: [["2FF0", "2FFF"]],
            IsCJKSymbolsandPunctuation: [["3000", "303F"]],
            IsHiragana: [["3040", "309F"]],
            IsKatakana: [["30A0", "30FF"]],
            IsBopomofo: [["3100", "312F"]],
            IsHangulCompatibilityJamo: [["3130", "318F"]],
            IsKanbun: [["3190", "319F"]],
            IsBopomofoExtended: [["31A0", "31BF"]],
            IsCJKStrokes: [["31C0", "31EF"]],
            IsKatakanaPhoneticExtensions: [["31F0", "31FF"]],
            IsEnclosedCJKLettersandMonths: [["3200", "32FF"]],
            IsCJKCompatibility: [["3300", "33FF"]],
            IsCJKUnifiedIdeographsExtensionA: [["3400", "4DBF"]],
            IsYijingHexagramSymbols: [["4DC0", "4DFF"]],
            IsCJKUnifiedIdeographs: [["4E00", "9FFF"]],
            IsYiSyllables: [["A000", "A48F"]],
            IsYiRadicals: [["A490", "A4CF"]],
            IsLisu: [["A4D0", "A4FF"]],
            IsVai: [["A500", "A63F"]],
            "IsCyrillicExtended-B": [["A640", "A69F"]],
            IsBamum: [["A6A0", "A6FF"]],
            IsModifierToneLetters: [["A700", "A71F"]],
            "IsLatinExtended-D": [["A720", "A7FF"]],
            IsSylotiNagri: [["A800", "A82F"]],
            IsCommonIndicNumberForms: [["A830", "A83F"]],
            "IsPhags-pa": [["A840", "A87F"]],
            IsSaurashtra: [["A880", "A8DF"]],
            IsDevanagariExtended: [["A8E0", "A8FF"]],
            IsKayahLi: [["A900", "A92F"]],
            IsRejang: [["A930", "A95F"]],
            "IsHangulJamoExtended-A": [["A960", "A97F"]],
            IsJavanese: [["A980", "A9DF"]],
            IsCham: [["AA00", "AA5F"]],
            "IsMyanmarExtended-A": [["AA60", "AA7F"]],
            IsTaiViet: [["AA80", "AADF"]],
            "IsEthiopicExtended-A": [["AB00", "AB2F"]],
            IsMeeteiMayek: [["ABC0", "ABFF"]],
            IsHangulSyllables: [["AC00", "D7AF"]],
            "IsHangulJamoExtended-B": [["D7B0", "D7FF"]],
            IsHighSurrogates: [["D800", "DB7F"]],
            IsHighPrivateUseSurrogates: [["DB80", "DBFF"]],
            IsLowSurrogates: [["DC00", "DFFF"]],
            IsPrivateUse: [["E000", "F8FF"], ["F0000", "FFFFD"], ["100000", "10FFFD"]],
            IsPrivateUseArea: [["E000", "F8FF"]],
            IsCJKCompatibilityIdeographs: [["F900", "FAFF"]],
            IsAlphabeticPresentationForms: [["FB00", "FB4F"]],
            "IsArabicPresentationForms-A": [["FB50", "FDFF"]],
            IsVariationSelectors: [["FE00", "FE0F"]],
            IsVerticalForms: [["FE10", "FE1F"]],
            IsCombiningHalfMarks: [["FE20", "FE2F"]],
            IsCJKCompatibilityForms: [["FE30", "FE4F"]],
            IsSmallFormVariants: [["FE50", "FE6F"]],
            "IsArabicPresentationForms-B": [["FE70", "FEFF"]],
            IsHalfwidthandFullwidthForms: [["FF00", "FFEF"]],
            IsSpecials: [["FEFF", "FEFF"], ["FFF0", "FFFF"]],
            IsLinearBSyllabary: [["10000", "1007F"]],
            IsLinearBIdeograms: [["10080", "100FF"]],
            IsAegeanNumbers: [["10100", "1013F"]],
            IsAncientGreekNumbers: [["10140", "1018F"]],
            IsAncientSymbols: [["10190", "101CF"]],
            IsPhaistosDisc: [["101D0", "101FF"]],
            IsLycian: [["10280", "1029F"]],
            IsCarian: [["102A0", "102DF"]],
            IsOldItalic: [["10300", "1032F"]],
            IsGothic: [["10330", "1034F"]],
            IsUgaritic: [["10380", "1039F"]],
            IsOldPersian: [["103A0", "103DF"]],
            IsDeseret: [["10400", "1044F"]],
            IsShavian: [["10450", "1047F"]],
            IsOsmanya: [["10480", "104AF"]],
            IsCypriotSyllabary: [["10800", "1083F"]],
            IsImperialAramaic: [["10840", "1085F"]],
            IsPhoenician: [["10900", "1091F"]],
            IsLydian: [["10920", "1093F"]],
            IsKharoshthi: [["10A00", "10A5F"]],
            IsOldSouthArabian: [["10A60", "10A7F"]],
            IsAvestan: [["10B00", "10B3F"]],
            IsInscriptionalParthian: [["10B40", "10B5F"]],
            IsInscriptionalPahlavi: [["10B60", "10B7F"]],
            IsOldTurkic: [["10C00", "10C4F"]],
            IsRumiNumeralSymbols: [["10E60", "10E7F"]],
            IsBrahmi: [["11000", "1107F"]],
            IsKaithi: [["11080", "110CF"]],
            IsCuneiform: [["12000", "123FF"]],
            IsCuneiformNumbersandPunctuation: [["12400", "1247F"]],
            IsEgyptianHieroglyphs: [["13000", "1342F"]],
            IsBamumSupplement: [["16800", "16A3F"]],
            IsKanaSupplement: [["1B000", "1B0FF"]],
            IsByzantineMusicalSymbols: [["1D000", "1D0FF"]],
            IsMusicalSymbols: [["1D100", "1D1FF"]],
            IsAncientGreekMusicalNotation: [["1D200", "1D24F"]],
            IsTaiXuanJingSymbols: [["1D300", "1D35F"]],
            IsCountingRodNumerals: [["1D360", "1D37F"]],
            IsMathematicalAlphanumericSymbols: [["1D400", "1D7FF"]],
            IsMahjongTiles: [["1F000", "1F02F"]],
            IsDominoTiles: [["1F030", "1F09F"]],
            IsPlayingCards: [["1F0A0", "1F0FF"]],
            IsEnclosedAlphanumericSupplement: [["1F100", "1F1FF"]],
            IsEnclosedIdeographicSupplement: [["1F200", "1F2FF"]],
            IsMiscellaneousSymbolsAndPictographs: [["1F300", "1F5FF"]],
            IsEmoticons: [["1F600", "1F64F"]],
            IsTransportAndMapSymbols: [["1F680", "1F6FF"]],
            IsAlchemicalSymbols: [["1F700", "1F77F"]],
            IsCJKUnifiedIdeographsExtensionB: [["20000", "2A6DF"]],
            IsCJKUnifiedIdeographsExtensionC: [["2A700", "2B73F"]],
            IsCJKUnifiedIdeographsExtensionD: [["2B740", "2B81F"]],
            IsCJKCompatibilityIdeographsSupplement: [["2F800", "2FA1F"]],
            IsTags: [["E0000", "E007F"]],
            IsVariationSelectorsSupplement: [["E0100", "E01EF"]],
            "IsSupplementaryPrivateUseArea-A": [["F0000", "FFFFF"]],
            "IsSupplementaryPrivateUseArea-B": [["100000", "10FFFF"]],
            C: "Cc|Cf|Cn|Co",
            Cc: [["0", "1F"], ["7F", "9F"]],
            Cf: [["AD", "AD"], ["600", "604"], ["6DD", "6DD"], ["70F", "70F"], ["200B", "200F"], ["202A", "202E"], ["2060", "2064"], ["206A", "206F"], ["FEFF", "FEFF"], ["FFF9", "FFFB"], ["110BD", "110BD"], ["1D173", "1D17A"], ["E0001", "E0001"], ["E0020", "E007F"]],
            Cn: [["378", "379"], ["37F", "383"], ["38B", "38B"], ["38D", "38D"], ["3A2", "3A2"], ["528", "52F"], ["530", "530"], ["557", "558"], ["560", "560"], ["588", "588"], ["58B", "58E"], ["590", "590"], ["5C8", "5CF"], ["5EB", "5EF"], ["5F5", "5FF"], ["605", "605"], ["61C", "61D"], ["70E", "70E"], ["74B", "74C"], ["7B2", "7BF"], ["7FB", "7FF"], ["82E", "82F"], ["83F", "83F"], ["85C", "85D"], ["85F", "85F"], ["860", "89F"], ["8A1", "8A1"], ["8AD", "8E3"], ["8FF", "8FF"], ["978", "978"], ["980", "980"], ["984", "984"], ["98D", "98E"], ["991", "992"], ["9A9", "9A9"], ["9B1", "9B1"], ["9B3", "9B5"], ["9BA", "9BB"], ["9C5", "9C6"], ["9C9", "9CA"], ["9CF", "9D6"], ["9D8", "9DB"], ["9DE", "9DE"], ["9E4", "9E5"], ["9FC", "9FF"], ["A00", "A00"], ["A04", "A04"], ["A0B", "A0E"], ["A11", "A12"], ["A29", "A29"], ["A31", "A31"], ["A34", "A34"], ["A37", "A37"], ["A3A", "A3B"], ["A3D", "A3D"], ["A43", "A46"], ["A49", "A4A"], ["A4E", "A50"], ["A52", "A58"], ["A5D", "A5D"], ["A5F", "A65"], ["A76", "A7F"], ["A80", "A80"], ["A84", "A84"], ["A8E", "A8E"], ["A92", "A92"], ["AA9", "AA9"], ["AB1", "AB1"], ["AB4", "AB4"], ["ABA", "ABB"], ["AC6", "AC6"], ["ACA", "ACA"], ["ACE", "ACF"], ["AD1", "ADF"], ["AE4", "AE5"], ["AF2", "AFF"], ["B00", "B00"], ["B04", "B04"], ["B0D", "B0E"], ["B11", "B12"], ["B29", "B29"], ["B31", "B31"], ["B34", "B34"], ["B3A", "B3B"], ["B45", "B46"], ["B49", "B4A"], ["B4E", "B55"], ["B58", "B5B"], ["B5E", "B5E"], ["B64", "B65"], ["B78", "B7F"], ["B80", "B81"], ["B84", "B84"], ["B8B", "B8D"], ["B91", "B91"], ["B96", "B98"], ["B9B", "B9B"], ["B9D", "B9D"], ["BA0", "BA2"], ["BA5", "BA7"], ["BAB", "BAD"], ["BBA", "BBD"], ["BC3", "BC5"], ["BC9", "BC9"], ["BCE", "BCF"], ["BD1", "BD6"], ["BD8", "BE5"], ["BFB", "BFF"], ["C00", "C00"], ["C04", "C04"], ["C0D", "C0D"], ["C11", "C11"], ["C29", "C29"], ["C34", "C34"], ["C3A", "C3C"], ["C45", "C45"], ["C49", "C49"], ["C4E", "C54"], ["C57", "C57"], ["C5A", "C5F"], ["C64", "C65"], ["C70", "C77"], ["C80", "C81"], ["C84", "C84"], ["C8D", "C8D"], ["C91", "C91"], ["CA9", "CA9"], ["CB4", "CB4"], ["CBA", "CBB"], ["CC5", "CC5"], ["CC9", "CC9"], ["CCE", "CD4"], ["CD7", "CDD"], ["CDF", "CDF"], ["CE4", "CE5"], ["CF0", "CF0"], ["CF3", "CFF"], ["D00", "D01"], ["D04", "D04"], ["D0D", "D0D"], ["D11", "D11"], ["D3B", "D3C"], ["D45", "D45"], ["D49", "D49"], ["D4F", "D56"], ["D58", "D5F"], ["D64", "D65"], ["D76", "D78"], ["D80", "D81"], ["D84", "D84"], ["D97", "D99"], ["DB2", "DB2"], ["DBC", "DBC"], ["DBE", "DBF"], ["DC7", "DC9"], ["DCB", "DCE"], ["DD5", "DD5"], ["DD7", "DD7"], ["DE0", "DF1"], ["DF5", "DFF"], ["E00", "E00"], ["E3B", "E3E"], ["E5C", "E7F"], ["E80", "E80"], ["E83", "E83"], ["E85", "E86"], ["E89", "E89"], ["E8B", "E8C"], ["E8E", "E93"], ["E98", "E98"], ["EA0", "EA0"], ["EA4", "EA4"], ["EA6", "EA6"], ["EA8", "EA9"], ["EAC", "EAC"], ["EBA", "EBA"], ["EBE", "EBF"], ["EC5", "EC5"], ["EC7", "EC7"], ["ECE", "ECF"], ["EDA", "EDB"], ["EE0", "EFF"], ["F48", "F48"], ["F6D", "F70"], ["F98", "F98"], ["FBD", "FBD"], ["FCD", "FCD"], ["FDB", "FFF"], ["10C6", "10C6"], ["10C8", "10CC"], ["10CE", "10CF"], ["1249", "1249"], ["124E", "124F"], ["1257", "1257"], ["1259", "1259"], ["125E", "125F"], ["1289", "1289"], ["128E", "128F"], ["12B1", "12B1"], ["12B6", "12B7"], ["12BF", "12BF"], ["12C1", "12C1"], ["12C6", "12C7"], ["12D7", "12D7"], ["1311", "1311"], ["1316", "1317"], ["135B", "135C"], ["137D", "137F"], ["139A", "139F"], ["13F5", "13FF"], ["169D", "169F"], ["16F1", "16FF"], ["170D", "170D"], ["1715", "171F"], ["1737", "173F"], ["1754", "175F"], ["176D", "176D"], ["1771", "1771"], ["1774", "177F"], ["17DE", "17DF"], ["17EA", "17EF"], ["17FA", "17FF"], ["180F", "180F"], ["181A", "181F"], ["1878", "187F"], ["18AB", "18AF"], ["18F6", "18FF"], ["191D", "191F"], ["192C", "192F"], ["193C", "193F"], ["1941", "1943"], ["196E", "196F"], ["1975", "197F"], ["19AC", "19AF"], ["19CA", "19CF"], ["19DB", "19DD"], ["1A1C", "1A1D"], ["1A5F", "1A5F"], ["1A7D", "1A7E"], ["1A8A", "1A8F"], ["1A9A", "1A9F"], ["1AAE", "1AAF"], ["1AB0", "1AFF"], ["1B4C", "1B4F"], ["1B7D", "1B7F"], ["1BF4", "1BFB"], ["1C38", "1C3A"], ["1C4A", "1C4C"], ["1C80", "1CBF"], ["1CC8", "1CCF"], ["1CF7", "1CFF"], ["1DE7", "1DFB"], ["1F16", "1F17"], ["1F1E", "1F1F"], ["1F46", "1F47"], ["1F4E", "1F4F"], ["1F58", "1F58"], ["1F5A", "1F5A"], ["1F5C", "1F5C"], ["1F5E", "1F5E"], ["1F7E", "1F7F"], ["1FB5", "1FB5"], ["1FC5", "1FC5"], ["1FD4", "1FD5"], ["1FDC", "1FDC"], ["1FF0", "1FF1"], ["1FF5", "1FF5"], ["1FFF", "1FFF"], ["2065", "2069"], ["2072", "2073"], ["208F", "208F"], ["209D", "209F"], ["20BB", "20CF"], ["20F1", "20FF"], ["218A", "218F"], ["23F4", "23FF"], ["2427", "243F"], ["244B", "245F"], ["2700", "2700"], ["2B4D", "2B4F"], ["2B5A", "2BFF"], ["2C2F", "2C2F"], ["2C5F", "2C5F"], ["2CF4", "2CF8"], ["2D26", "2D26"], ["2D28", "2D2C"], ["2D2E", "2D2F"], ["2D68", "2D6E"], ["2D71", "2D7E"], ["2D97", "2D9F"], ["2DA7", "2DA7"], ["2DAF", "2DAF"], ["2DB7", "2DB7"], ["2DBF", "2DBF"], ["2DC7", "2DC7"], ["2DCF", "2DCF"], ["2DD7", "2DD7"], ["2DDF", "2DDF"], ["2E3C", "2E7F"], ["2E9A", "2E9A"], ["2EF4", "2EFF"], ["2FD6", "2FDF"], ["2FE0", "2FEF"], ["2FFC", "2FFF"], ["3040", "3040"], ["3097", "3098"], ["3100", "3104"], ["312E", "312F"], ["3130", "3130"], ["318F", "318F"], ["31BB", "31BF"], ["31E4", "31EF"], ["321F", "321F"], ["32FF", "32FF"], ["4DB6", "4DBF"], ["9FCD", "9FFF"], ["A48D", "A48F"], ["A4C7", "A4CF"], ["A62C", "A63F"], ["A698", "A69E"], ["A6F8", "A6FF"], ["A78F", "A78F"], ["A794", "A79F"], ["A7AB", "A7F7"], ["A82C", "A82F"], ["A83A", "A83F"], ["A878", "A87F"], ["A8C5", "A8CD"], ["A8DA", "A8DF"], ["A8FC", "A8FF"], ["A954", "A95E"], ["A97D", "A97F"], ["A9CE", "A9CE"], ["A9DA", "A9DD"], ["A9E0", "A9FF"], ["AA37", "AA3F"], ["AA4E", "AA4F"], ["AA5A", "AA5B"], ["AA7C", "AA7F"], ["AAC3", "AADA"], ["AAF7", "AAFF"], ["AB00", "AB00"], ["AB07", "AB08"], ["AB0F", "AB10"], ["AB17", "AB1F"], ["AB27", "AB27"], ["AB2F", "AB2F"], ["AB30", "ABBF"], ["ABEE", "ABEF"], ["ABFA", "ABFF"], ["D7A4", "D7AF"], ["D7C7", "D7CA"], ["D7FC", "D7FF"], ["FA6E", "FA6F"], ["FADA", "FAFF"], ["FB07", "FB12"], ["FB18", "FB1C"], ["FB37", "FB37"], ["FB3D", "FB3D"], ["FB3F", "FB3F"], ["FB42", "FB42"], ["FB45", "FB45"], ["FBC2", "FBD2"], ["FD40", "FD4F"], ["FD90", "FD91"], ["FDC8", "FDCF"], ["FDD0", "FDEF"], ["FDFE", "FDFF"], ["FE1A", "FE1F"], ["FE27", "FE2F"], ["FE53", "FE53"], ["FE67", "FE67"], ["FE6C", "FE6F"], ["FE75", "FE75"], ["FEFD", "FEFE"], ["FF00", "FF00"], ["FFBF", "FFC1"], ["FFC8", "FFC9"], ["FFD0", "FFD1"], ["FFD8", "FFD9"], ["FFDD", "FFDF"], ["FFE7", "FFE7"], ["FFEF", "FFEF"], ["FFF0", "FFF8"], ["FFFE", "FFFF"], ["1000C", "1000C"], ["10027", "10027"], ["1003B", "1003B"], ["1003E", "1003E"], ["1004E", "1004F"], ["1005E", "1007F"], ["100FB", "100FF"], ["10103", "10106"], ["10134", "10136"], ["1018B", "1018F"], ["1019C", "101CF"], ["101FE", "101FF"], ["10200", "1027F"], ["1029D", "1029F"], ["102D1", "102DF"], ["102E0", "102FF"], ["1031F", "1031F"], ["10324", "1032F"], ["1034B", "1034F"], ["10350", "1037F"], ["1039E", "1039E"], ["103C4", "103C7"], ["103D6", "103DF"], ["103E0", "103FF"], ["1049E", "1049F"], ["104AA", "104AF"], ["104B0", "107FF"], ["10806", "10807"], ["10809", "10809"], ["10836", "10836"], ["10839", "1083B"], ["1083D", "1083E"], ["10856", "10856"], ["10860", "108FF"], ["1091C", "1091E"], ["1093A", "1093E"], ["10940", "1097F"], ["109B8", "109BD"], ["109C0", "109FF"], ["10A04", "10A04"], ["10A07", "10A0B"], ["10A14", "10A14"], ["10A18", "10A18"], ["10A34", "10A37"], ["10A3B", "10A3E"], ["10A48", "10A4F"], ["10A59", "10A5F"], ["10A80", "10AFF"], ["10B36", "10B38"], ["10B56", "10B57"], ["10B73", "10B77"], ["10B80", "10BFF"], ["10C49", "10C4F"], ["10C50", "10E5F"], ["10E7F", "10E7F"], ["10E80", "10FFF"], ["1104E", "11051"], ["11070", "1107F"], ["110C2", "110CF"], ["110E9", "110EF"], ["110FA", "110FF"], ["11135", "11135"], ["11144", "1114F"], ["11150", "1117F"], ["111C9", "111CF"], ["111DA", "111DF"], ["111E0", "1167F"], ["116B8", "116BF"], ["116CA", "116CF"], ["116D0", "11FFF"], ["1236F", "123FF"], ["12463", "1246F"], ["12474", "1247F"], ["12480", "12FFF"], ["1342F", "1342F"], ["13430", "167FF"], ["16A39", "16A3F"], ["16A40", "16EFF"], ["16F45", "16F4F"], ["16F7F", "16F8E"], ["16FA0", "1AFFF"], ["1B002", "1B0FF"], ["1B100", "1CFFF"], ["1D0F6", "1D0FF"], ["1D127", "1D128"], ["1D1DE", "1D1FF"], ["1D246", "1D24F"], ["1D250", "1D2FF"], ["1D357", "1D35F"], ["1D372", "1D37F"], ["1D380", "1D3FF"], ["1D455", "1D455"], ["1D49D", "1D49D"], ["1D4A0", "1D4A1"], ["1D4A3", "1D4A4"], ["1D4A7", "1D4A8"], ["1D4AD", "1D4AD"], ["1D4BA", "1D4BA"], ["1D4BC", "1D4BC"], ["1D4C4", "1D4C4"], ["1D506", "1D506"], ["1D50B", "1D50C"], ["1D515", "1D515"], ["1D51D", "1D51D"], ["1D53A", "1D53A"], ["1D53F", "1D53F"], ["1D545", "1D545"], ["1D547", "1D549"], ["1D551", "1D551"], ["1D6A6", "1D6A7"], ["1D7CC", "1D7CD"], ["1D800", "1E7FF"], ["1E800", "1EDFF"], ["1EE04", "1EE04"], ["1EE20", "1EE20"], ["1EE23", "1EE23"], ["1EE25", "1EE26"], ["1EE28", "1EE28"], ["1EE33", "1EE33"], ["1EE38", "1EE38"], ["1EE3A", "1EE3A"], ["1EE3C", "1EE41"], ["1EE43", "1EE46"], ["1EE48", "1EE48"], ["1EE4A", "1EE4A"], ["1EE4C", "1EE4C"], ["1EE50", "1EE50"], ["1EE53", "1EE53"], ["1EE55", "1EE56"], ["1EE58", "1EE58"], ["1EE5A", "1EE5A"], ["1EE5C", "1EE5C"], ["1EE5E", "1EE5E"], ["1EE60", "1EE60"], ["1EE63", "1EE63"], ["1EE65", "1EE66"], ["1EE6B", "1EE6B"], ["1EE73", "1EE73"], ["1EE78", "1EE78"], ["1EE7D", "1EE7D"], ["1EE7F", "1EE7F"], ["1EE8A", "1EE8A"], ["1EE9C", "1EEA0"], ["1EEA4", "1EEA4"], ["1EEAA", "1EEAA"], ["1EEBC", "1EEEF"], ["1EEF2", "1EEFF"], ["1EF00", "1EFFF"], ["1F02C", "1F02F"], ["1F094", "1F09F"], ["1F0AF", "1F0B0"], ["1F0BF", "1F0C0"], ["1F0D0", "1F0D0"], ["1F0E0", "1F0FF"], ["1F10B", "1F10F"], ["1F12F", "1F12F"], ["1F16C", "1F16F"], ["1F19B", "1F1E5"], ["1F203", "1F20F"], ["1F23B", "1F23F"], ["1F249", "1F24F"], ["1F252", "1F2FF"], ["1F321", "1F32F"], ["1F336", "1F336"], ["1F37D", "1F37F"], ["1F394", "1F39F"], ["1F3C5", "1F3C5"], ["1F3CB", "1F3DF"], ["1F3F1", "1F3FF"], ["1F43F", "1F43F"], ["1F441", "1F441"], ["1F4F8", "1F4F8"], ["1F4FD", "1F4FF"], ["1F53E", "1F53F"], ["1F544", "1F54F"], ["1F568", "1F5FA"], ["1F641", "1F644"], ["1F650", "1F67F"], ["1F6C6", "1F6FF"], ["1F774", "1F77F"], ["1F780", "1FFFD"], ["1FFFE", "1FFFF"], ["2A6D7", "2A6DF"], ["2A6E0", "2A6FF"], ["2B735", "2B73F"], ["2B81E", "2B81F"], ["2B820", "2F7FF"], ["2FA1E", "2FA1F"], ["2FA20", "2FFFD"], ["2FFFE", "2FFFF"], ["30000", "3FFFD"], ["3FFFE", "3FFFF"], ["40000", "4FFFD"], ["4FFFE", "4FFFF"], ["50000", "5FFFD"], ["5FFFE", "5FFFF"], ["60000", "6FFFD"], ["6FFFE", "6FFFF"], ["70000", "7FFFD"], ["7FFFE", "7FFFF"], ["80000", "8FFFD"], ["8FFFE", "8FFFF"], ["90000", "9FFFD"], ["9FFFE", "9FFFF"], ["A0000", "AFFFD"], ["AFFFE", "AFFFF"], ["B0000", "BFFFD"], ["BFFFE", "BFFFF"], ["C0000", "CFFFD"], ["CFFFE", "CFFFF"], ["D0000", "DFFFD"], ["DFFFE", "DFFFF"], ["E0000", "E0000"], ["E0002", "E001F"], ["E0080", "E00FF"], ["E01F0", "E0FFF"], ["E1000", "EFFFD"], ["EFFFE", "EFFFF"], ["FFFFE", "FFFFF"], ["10FFFE", "10FFFF"]],
            Co: [["E000", "F8FF"], ["F0000", "FFFFD"], ["100000", "10FFFD"]],
            L: "Ll|Lm|Lo|Lt|Lu",
            Ll: [["61", "7A"], ["B5", "B5"], ["DF", "F6"], ["F8", "FF"], ["101", "101"], ["103", "103"], ["105", "105"], ["107", "107"], ["109", "109"], ["10B", "10B"], ["10D", "10D"], ["10F", "10F"], ["111", "111"], ["113", "113"], ["115", "115"], ["117", "117"], ["119", "119"], ["11B", "11B"], ["11D", "11D"], ["11F", "11F"], ["121", "121"], ["123", "123"], ["125", "125"], ["127", "127"], ["129", "129"], ["12B", "12B"], ["12D", "12D"], ["12F", "12F"], ["131", "131"], ["133", "133"], ["135", "135"], ["137", "138"], ["13A", "13A"], ["13C", "13C"], ["13E", "13E"], ["140", "140"], ["142", "142"], ["144", "144"], ["146", "146"], ["148", "149"], ["14B", "14B"], ["14D", "14D"], ["14F", "14F"], ["151", "151"], ["153", "153"], ["155", "155"], ["157", "157"], ["159", "159"], ["15B", "15B"], ["15D", "15D"], ["15F", "15F"], ["161", "161"], ["163", "163"], ["165", "165"], ["167", "167"], ["169", "169"], ["16B", "16B"], ["16D", "16D"], ["16F", "16F"], ["171", "171"], ["173", "173"], ["175", "175"], ["177", "177"], ["17A", "17A"], ["17C", "17C"], ["17E", "180"], ["183", "183"], ["185", "185"], ["188", "188"], ["18C", "18D"], ["192", "192"], ["195", "195"], ["199", "19B"], ["19E", "19E"], ["1A1", "1A1"], ["1A3", "1A3"], ["1A5", "1A5"], ["1A8", "1A8"], ["1AA", "1AB"], ["1AD", "1AD"], ["1B0", "1B0"], ["1B4", "1B4"], ["1B6", "1B6"], ["1B9", "1BA"], ["1BD", "1BF"], ["1C6", "1C6"], ["1C9", "1C9"], ["1CC", "1CC"], ["1CE", "1CE"], ["1D0", "1D0"], ["1D2", "1D2"], ["1D4", "1D4"], ["1D6", "1D6"], ["1D8", "1D8"], ["1DA", "1DA"], ["1DC", "1DD"], ["1DF", "1DF"], ["1E1", "1E1"], ["1E3", "1E3"], ["1E5", "1E5"], ["1E7", "1E7"], ["1E9", "1E9"], ["1EB", "1EB"], ["1ED", "1ED"], ["1EF", "1F0"], ["1F3", "1F3"], ["1F5", "1F5"], ["1F9", "1F9"], ["1FB", "1FB"], ["1FD", "1FD"], ["1FF", "1FF"], ["201", "201"], ["203", "203"], ["205", "205"], ["207", "207"], ["209", "209"], ["20B", "20B"], ["20D", "20D"], ["20F", "20F"], ["211", "211"], ["213", "213"], ["215", "215"], ["217", "217"], ["219", "219"], ["21B", "21B"], ["21D", "21D"], ["21F", "21F"], ["221", "221"], ["223", "223"], ["225", "225"], ["227", "227"], ["229", "229"], ["22B", "22B"], ["22D", "22D"], ["22F", "22F"], ["231", "231"], ["233", "239"], ["23C", "23C"], ["23F", "240"], ["242", "242"], ["247", "247"], ["249", "249"], ["24B", "24B"], ["24D", "24D"], ["24F", "293"], ["295", "2AF"], ["371", "371"], ["373", "373"], ["377", "377"], ["37B", "37D"], ["390", "390"], ["3AC", "3CE"], ["3D0", "3D1"], ["3D5", "3D7"], ["3D9", "3D9"], ["3DB", "3DB"], ["3DD", "3DD"], ["3DF", "3DF"], ["3E1", "3E1"], ["3E3", "3E3"], ["3E5", "3E5"], ["3E7", "3E7"], ["3E9", "3E9"], ["3EB", "3EB"], ["3ED", "3ED"], ["3EF", "3F3"], ["3F5", "3F5"], ["3F8", "3F8"], ["3FB", "3FC"], ["430", "45F"], ["461", "461"], ["463", "463"], ["465", "465"], ["467", "467"], ["469", "469"], ["46B", "46B"], ["46D", "46D"], ["46F", "46F"], ["471", "471"], ["473", "473"], ["475", "475"], ["477", "477"], ["479", "479"], ["47B", "47B"], ["47D", "47D"], ["47F", "47F"], ["481", "481"], ["48B", "48B"], ["48D", "48D"], ["48F", "48F"], ["491", "491"], ["493", "493"], ["495", "495"], ["497", "497"], ["499", "499"], ["49B", "49B"], ["49D", "49D"], ["49F", "49F"], ["4A1", "4A1"], ["4A3", "4A3"], ["4A5", "4A5"], ["4A7", "4A7"], ["4A9", "4A9"], ["4AB", "4AB"], ["4AD", "4AD"], ["4AF", "4AF"], ["4B1", "4B1"], ["4B3", "4B3"], ["4B5", "4B5"], ["4B7", "4B7"], ["4B9", "4B9"], ["4BB", "4BB"], ["4BD", "4BD"], ["4BF", "4BF"], ["4C2", "4C2"], ["4C4", "4C4"], ["4C6", "4C6"], ["4C8", "4C8"], ["4CA", "4CA"], ["4CC", "4CC"], ["4CE", "4CF"], ["4D1", "4D1"], ["4D3", "4D3"], ["4D5", "4D5"], ["4D7", "4D7"], ["4D9", "4D9"], ["4DB", "4DB"], ["4DD", "4DD"], ["4DF", "4DF"], ["4E1", "4E1"], ["4E3", "4E3"], ["4E5", "4E5"], ["4E7", "4E7"], ["4E9", "4E9"], ["4EB", "4EB"], ["4ED", "4ED"], ["4EF", "4EF"], ["4F1", "4F1"], ["4F3", "4F3"], ["4F5", "4F5"], ["4F7", "4F7"], ["4F9", "4F9"], ["4FB", "4FB"], ["4FD", "4FD"], ["4FF", "4FF"], ["501", "501"], ["503", "503"], ["505", "505"], ["507", "507"], ["509", "509"], ["50B", "50B"], ["50D", "50D"], ["50F", "50F"], ["511", "511"], ["513", "513"], ["515", "515"], ["517", "517"], ["519", "519"], ["51B", "51B"], ["51D", "51D"], ["51F", "51F"], ["521", "521"], ["523", "523"], ["525", "525"], ["527", "527"], ["561", "587"], ["1D00", "1D2B"], ["1D6B", "1D77"], ["1D79", "1D9A"], ["1E01", "1E01"], ["1E03", "1E03"], ["1E05", "1E05"], ["1E07", "1E07"], ["1E09", "1E09"], ["1E0B", "1E0B"], ["1E0D", "1E0D"], ["1E0F", "1E0F"], ["1E11", "1E11"], ["1E13", "1E13"], ["1E15", "1E15"], ["1E17", "1E17"], ["1E19", "1E19"], ["1E1B", "1E1B"], ["1E1D", "1E1D"], ["1E1F", "1E1F"], ["1E21", "1E21"], ["1E23", "1E23"], ["1E25", "1E25"], ["1E27", "1E27"], ["1E29", "1E29"], ["1E2B", "1E2B"], ["1E2D", "1E2D"], ["1E2F", "1E2F"], ["1E31", "1E31"], ["1E33", "1E33"], ["1E35", "1E35"], ["1E37", "1E37"], ["1E39", "1E39"], ["1E3B", "1E3B"], ["1E3D", "1E3D"], ["1E3F", "1E3F"], ["1E41", "1E41"], ["1E43", "1E43"], ["1E45", "1E45"], ["1E47", "1E47"], ["1E49", "1E49"], ["1E4B", "1E4B"], ["1E4D", "1E4D"], ["1E4F", "1E4F"], ["1E51", "1E51"], ["1E53", "1E53"], ["1E55", "1E55"], ["1E57", "1E57"], ["1E59", "1E59"], ["1E5B", "1E5B"], ["1E5D", "1E5D"], ["1E5F", "1E5F"], ["1E61", "1E61"], ["1E63", "1E63"], ["1E65", "1E65"], ["1E67", "1E67"], ["1E69", "1E69"], ["1E6B", "1E6B"], ["1E6D", "1E6D"], ["1E6F", "1E6F"], ["1E71", "1E71"], ["1E73", "1E73"], ["1E75", "1E75"], ["1E77", "1E77"], ["1E79", "1E79"], ["1E7B", "1E7B"], ["1E7D", "1E7D"], ["1E7F", "1E7F"], ["1E81", "1E81"], ["1E83", "1E83"], ["1E85", "1E85"], ["1E87", "1E87"], ["1E89", "1E89"], ["1E8B", "1E8B"], ["1E8D", "1E8D"], ["1E8F", "1E8F"], ["1E91", "1E91"], ["1E93", "1E93"], ["1E95", "1E9D"], ["1E9F", "1E9F"], ["1EA1", "1EA1"], ["1EA3", "1EA3"], ["1EA5", "1EA5"], ["1EA7", "1EA7"], ["1EA9", "1EA9"], ["1EAB", "1EAB"], ["1EAD", "1EAD"], ["1EAF", "1EAF"], ["1EB1", "1EB1"], ["1EB3", "1EB3"], ["1EB5", "1EB5"], ["1EB7", "1EB7"], ["1EB9", "1EB9"], ["1EBB", "1EBB"], ["1EBD", "1EBD"], ["1EBF", "1EBF"], ["1EC1", "1EC1"], ["1EC3", "1EC3"], ["1EC5", "1EC5"], ["1EC7", "1EC7"], ["1EC9", "1EC9"], ["1ECB", "1ECB"], ["1ECD", "1ECD"], ["1ECF", "1ECF"], ["1ED1", "1ED1"], ["1ED3", "1ED3"], ["1ED5", "1ED5"], ["1ED7", "1ED7"], ["1ED9", "1ED9"], ["1EDB", "1EDB"], ["1EDD", "1EDD"], ["1EDF", "1EDF"], ["1EE1", "1EE1"], ["1EE3", "1EE3"], ["1EE5", "1EE5"], ["1EE7", "1EE7"], ["1EE9", "1EE9"], ["1EEB", "1EEB"], ["1EED", "1EED"], ["1EEF", "1EEF"], ["1EF1", "1EF1"], ["1EF3", "1EF3"], ["1EF5", "1EF5"], ["1EF7", "1EF7"], ["1EF9", "1EF9"], ["1EFB", "1EFB"], ["1EFD", "1EFD"], ["1EFF", "1F07"], ["1F10", "1F15"], ["1F20", "1F27"], ["1F30", "1F37"], ["1F40", "1F45"], ["1F50", "1F57"], ["1F60", "1F67"], ["1F70", "1F7D"], ["1F80", "1F87"], ["1F90", "1F97"], ["1FA0", "1FA7"], ["1FB0", "1FB4"], ["1FB6", "1FB7"], ["1FBE", "1FBE"], ["1FC2", "1FC4"], ["1FC6", "1FC7"], ["1FD0", "1FD3"], ["1FD6", "1FD7"], ["1FE0", "1FE7"], ["1FF2", "1FF4"], ["1FF6", "1FF7"], ["210A", "210A"], ["210E", "210F"], ["2113", "2113"], ["212F", "212F"], ["2134", "2134"], ["2139", "2139"], ["213C", "213D"], ["2146", "2149"], ["214E", "214E"], ["2184", "2184"], ["2C30", "2C5E"], ["2C61", "2C61"], ["2C65", "2C66"], ["2C68", "2C68"], ["2C6A", "2C6A"], ["2C6C", "2C6C"], ["2C71", "2C71"], ["2C73", "2C74"], ["2C76", "2C7B"], ["2C81", "2C81"], ["2C83", "2C83"], ["2C85", "2C85"], ["2C87", "2C87"], ["2C89", "2C89"], ["2C8B", "2C8B"], ["2C8D", "2C8D"], ["2C8F", "2C8F"], ["2C91", "2C91"], ["2C93", "2C93"], ["2C95", "2C95"], ["2C97", "2C97"], ["2C99", "2C99"], ["2C9B", "2C9B"], ["2C9D", "2C9D"], ["2C9F", "2C9F"], ["2CA1", "2CA1"], ["2CA3", "2CA3"], ["2CA5", "2CA5"], ["2CA7", "2CA7"], ["2CA9", "2CA9"], ["2CAB", "2CAB"], ["2CAD", "2CAD"], ["2CAF", "2CAF"], ["2CB1", "2CB1"], ["2CB3", "2CB3"], ["2CB5", "2CB5"], ["2CB7", "2CB7"], ["2CB9", "2CB9"], ["2CBB", "2CBB"], ["2CBD", "2CBD"], ["2CBF", "2CBF"], ["2CC1", "2CC1"], ["2CC3", "2CC3"], ["2CC5", "2CC5"], ["2CC7", "2CC7"], ["2CC9", "2CC9"], ["2CCB", "2CCB"], ["2CCD", "2CCD"], ["2CCF", "2CCF"], ["2CD1", "2CD1"], ["2CD3", "2CD3"], ["2CD5", "2CD5"], ["2CD7", "2CD7"], ["2CD9", "2CD9"], ["2CDB", "2CDB"], ["2CDD", "2CDD"], ["2CDF", "2CDF"], ["2CE1", "2CE1"], ["2CE3", "2CE4"], ["2CEC", "2CEC"], ["2CEE", "2CEE"], ["2CF3", "2CF3"], ["2D00", "2D25"], ["2D27", "2D27"], ["2D2D", "2D2D"], ["A641", "A641"], ["A643", "A643"], ["A645", "A645"], ["A647", "A647"], ["A649", "A649"], ["A64B", "A64B"], ["A64D", "A64D"], ["A64F", "A64F"], ["A651", "A651"], ["A653", "A653"], ["A655", "A655"], ["A657", "A657"], ["A659", "A659"], ["A65B", "A65B"], ["A65D", "A65D"], ["A65F", "A65F"], ["A661", "A661"], ["A663", "A663"], ["A665", "A665"], ["A667", "A667"], ["A669", "A669"], ["A66B", "A66B"], ["A66D", "A66D"], ["A681", "A681"], ["A683", "A683"], ["A685", "A685"], ["A687", "A687"], ["A689", "A689"], ["A68B", "A68B"], ["A68D", "A68D"], ["A68F", "A68F"], ["A691", "A691"], ["A693", "A693"], ["A695", "A695"], ["A697", "A697"], ["A723", "A723"], ["A725", "A725"], ["A727", "A727"], ["A729", "A729"], ["A72B", "A72B"], ["A72D", "A72D"], ["A72F", "A731"], ["A733", "A733"], ["A735", "A735"], ["A737", "A737"], ["A739", "A739"], ["A73B", "A73B"], ["A73D", "A73D"], ["A73F", "A73F"], ["A741", "A741"], ["A743", "A743"], ["A745", "A745"], ["A747", "A747"], ["A749", "A749"], ["A74B", "A74B"], ["A74D", "A74D"], ["A74F", "A74F"], ["A751", "A751"], ["A753", "A753"], ["A755", "A755"], ["A757", "A757"], ["A759", "A759"], ["A75B", "A75B"], ["A75D", "A75D"], ["A75F", "A75F"], ["A761", "A761"], ["A763", "A763"], ["A765", "A765"], ["A767", "A767"], ["A769", "A769"], ["A76B", "A76B"], ["A76D", "A76D"], ["A76F", "A76F"], ["A771", "A778"], ["A77A", "A77A"], ["A77C", "A77C"], ["A77F", "A77F"], ["A781", "A781"], ["A783", "A783"], ["A785", "A785"], ["A787", "A787"], ["A78C", "A78C"], ["A78E", "A78E"], ["A791", "A791"], ["A793", "A793"], ["A7A1", "A7A1"], ["A7A3", "A7A3"], ["A7A5", "A7A5"], ["A7A7", "A7A7"], ["A7A9", "A7A9"], ["A7FA", "A7FA"], ["FB00", "FB06"], ["FB13", "FB17"], ["FF41", "FF5A"], ["10428", "1044F"], ["1D41A", "1D433"], ["1D44E", "1D454"], ["1D456", "1D467"], ["1D482", "1D49B"], ["1D4B6", "1D4B9"], ["1D4BB", "1D4BB"], ["1D4BD", "1D4C3"], ["1D4C5", "1D4CF"], ["1D4EA", "1D503"], ["1D51E", "1D537"], ["1D552", "1D56B"], ["1D586", "1D59F"], ["1D5BA", "1D5D3"], ["1D5EE", "1D607"], ["1D622", "1D63B"], ["1D656", "1D66F"], ["1D68A", "1D6A5"], ["1D6C2", "1D6DA"], ["1D6DC", "1D6E1"], ["1D6FC", "1D714"], ["1D716", "1D71B"], ["1D736", "1D74E"], ["1D750", "1D755"], ["1D770", "1D788"], ["1D78A", "1D78F"], ["1D7AA", "1D7C2"], ["1D7C4", "1D7C9"], ["1D7CB", "1D7CB"]],
            Lm: [["2B0", "2C1"], ["2C6", "2D1"], ["2E0", "2E4"], ["2EC", "2EC"], ["2EE", "2EE"], ["374", "374"], ["37A", "37A"], ["559", "559"], ["640", "640"], ["6E5", "6E6"], ["7F4", "7F5"], ["7FA", "7FA"], ["81A", "81A"], ["824", "824"], ["828", "828"], ["971", "971"], ["E46", "E46"], ["EC6", "EC6"], ["10FC", "10FC"], ["17D7", "17D7"], ["1843", "1843"], ["1AA7", "1AA7"], ["1C78", "1C7D"], ["1D2C", "1D6A"], ["1D78", "1D78"], ["1D9B", "1DBF"], ["2071", "2071"], ["207F", "207F"], ["2090", "209C"], ["2C7C", "2C7D"], ["2D6F", "2D6F"], ["2E2F", "2E2F"], ["3005", "3005"], ["3031", "3035"], ["303B", "303B"], ["309D", "309E"], ["30FC", "30FE"], ["A015", "A015"], ["A4F8", "A4FD"], ["A60C", "A60C"], ["A67F", "A67F"], ["A717", "A71F"], ["A770", "A770"], ["A788", "A788"], ["A7F8", "A7F9"], ["A9CF", "A9CF"], ["AA70", "AA70"], ["AADD", "AADD"], ["AAF3", "AAF4"], ["FF70", "FF70"], ["FF9E", "FF9F"], ["16F93", "16F9F"]],
            Lo: [["AA", "AA"], ["BA", "BA"], ["1BB", "1BB"], ["1C0", "1C3"], ["294", "294"], ["5D0", "5EA"], ["5F0", "5F2"], ["620", "63F"], ["641", "64A"], ["66E", "66F"], ["671", "6D3"], ["6D5", "6D5"], ["6EE", "6EF"], ["6FA", "6FC"], ["6FF", "6FF"], ["710", "710"], ["712", "72F"], ["74D", "7A5"], ["7B1", "7B1"], ["7CA", "7EA"], ["800", "815"], ["840", "858"], ["8A0", "8A0"], ["8A2", "8AC"], ["904", "939"], ["93D", "93D"], ["950", "950"], ["958", "961"], ["972", "977"], ["979", "97F"], ["985", "98C"], ["98F", "990"], ["993", "9A8"], ["9AA", "9B0"], ["9B2", "9B2"], ["9B6", "9B9"], ["9BD", "9BD"], ["9CE", "9CE"], ["9DC", "9DD"], ["9DF", "9E1"], ["9F0", "9F1"], ["A05", "A0A"], ["A0F", "A10"], ["A13", "A28"], ["A2A", "A30"], ["A32", "A33"], ["A35", "A36"], ["A38", "A39"], ["A59", "A5C"], ["A5E", "A5E"], ["A72", "A74"], ["A85", "A8D"], ["A8F", "A91"], ["A93", "AA8"], ["AAA", "AB0"], ["AB2", "AB3"], ["AB5", "AB9"], ["ABD", "ABD"], ["AD0", "AD0"], ["AE0", "AE1"], ["B05", "B0C"], ["B0F", "B10"], ["B13", "B28"], ["B2A", "B30"], ["B32", "B33"], ["B35", "B39"], ["B3D", "B3D"], ["B5C", "B5D"], ["B5F", "B61"], ["B71", "B71"], ["B83", "B83"], ["B85", "B8A"], ["B8E", "B90"], ["B92", "B95"], ["B99", "B9A"], ["B9C", "B9C"], ["B9E", "B9F"], ["BA3", "BA4"], ["BA8", "BAA"], ["BAE", "BB9"], ["BD0", "BD0"], ["C05", "C0C"], ["C0E", "C10"], ["C12", "C28"], ["C2A", "C33"], ["C35", "C39"], ["C3D", "C3D"], ["C58", "C59"], ["C60", "C61"], ["C85", "C8C"], ["C8E", "C90"], ["C92", "CA8"], ["CAA", "CB3"], ["CB5", "CB9"], ["CBD", "CBD"], ["CDE", "CDE"], ["CE0", "CE1"], ["CF1", "CF2"], ["D05", "D0C"], ["D0E", "D10"], ["D12", "D3A"], ["D3D", "D3D"], ["D4E", "D4E"], ["D60", "D61"], ["D7A", "D7F"], ["D85", "D96"], ["D9A", "DB1"], ["DB3", "DBB"], ["DBD", "DBD"], ["DC0", "DC6"], ["E01", "E30"], ["E32", "E33"], ["E40", "E45"], ["E81", "E82"], ["E84", "E84"], ["E87", "E88"], ["E8A", "E8A"], ["E8D", "E8D"], ["E94", "E97"], ["E99", "E9F"], ["EA1", "EA3"], ["EA5", "EA5"], ["EA7", "EA7"], ["EAA", "EAB"], ["EAD", "EB0"], ["EB2", "EB3"], ["EBD", "EBD"], ["EC0", "EC4"], ["EDC", "EDF"], ["F00", "F00"], ["F40", "F47"], ["F49", "F6C"], ["F88", "F8C"], ["1000", "102A"], ["103F", "103F"], ["1050", "1055"], ["105A", "105D"], ["1061", "1061"], ["1065", "1066"], ["106E", "1070"], ["1075", "1081"], ["108E", "108E"], ["10D0", "10FA"], ["10FD", "1248"], ["124A", "124D"], ["1250", "1256"], ["1258", "1258"], ["125A", "125D"], ["1260", "1288"], ["128A", "128D"], ["1290", "12B0"], ["12B2", "12B5"], ["12B8", "12BE"], ["12C0", "12C0"], ["12C2", "12C5"], ["12C8", "12D6"], ["12D8", "1310"], ["1312", "1315"], ["1318", "135A"], ["1380", "138F"], ["13A0", "13F4"], ["1401", "166C"], ["166F", "167F"], ["1681", "169A"], ["16A0", "16EA"], ["1700", "170C"], ["170E", "1711"], ["1720", "1731"], ["1740", "1751"], ["1760", "176C"], ["176E", "1770"], ["1780", "17B3"], ["17DC", "17DC"], ["1820", "1842"], ["1844", "1877"], ["1880", "18A8"], ["18AA", "18AA"], ["18B0", "18F5"], ["1900", "191C"], ["1950", "196D"], ["1970", "1974"], ["1980", "19AB"], ["19C1", "19C7"], ["1A00", "1A16"], ["1A20", "1A54"], ["1B05", "1B33"], ["1B45", "1B4B"], ["1B83", "1BA0"], ["1BAE", "1BAF"], ["1BBA", "1BE5"], ["1C00", "1C23"], ["1C4D", "1C4F"], ["1C5A", "1C77"], ["1CE9", "1CEC"], ["1CEE", "1CF1"], ["1CF5", "1CF6"], ["2135", "2138"], ["2D30", "2D67"], ["2D80", "2D96"], ["2DA0", "2DA6"], ["2DA8", "2DAE"], ["2DB0", "2DB6"], ["2DB8", "2DBE"], ["2DC0", "2DC6"], ["2DC8", "2DCE"], ["2DD0", "2DD6"], ["2DD8", "2DDE"], ["3006", "3006"], ["303C", "303C"], ["3041", "3096"], ["309F", "309F"], ["30A1", "30FA"], ["30FF", "30FF"], ["3105", "312D"], ["3131", "318E"], ["31A0", "31BA"], ["31F0", "31FF"], ["3400", "4DB5"], ["4E00", "9FCC"], ["A000", "A014"], ["A016", "A48C"], ["A4D0", "A4F7"], ["A500", "A60B"], ["A610", "A61F"], ["A62A", "A62B"], ["A66E", "A66E"], ["A6A0", "A6E5"], ["A7FB", "A801"], ["A803", "A805"], ["A807", "A80A"], ["A80C", "A822"], ["A840", "A873"], ["A882", "A8B3"], ["A8F2", "A8F7"], ["A8FB", "A8FB"], ["A90A", "A925"], ["A930", "A946"], ["A960", "A97C"], ["A984", "A9B2"], ["AA00", "AA28"], ["AA40", "AA42"], ["AA44", "AA4B"], ["AA60", "AA6F"], ["AA71", "AA76"], ["AA7A", "AA7A"], ["AA80", "AAAF"], ["AAB1", "AAB1"], ["AAB5", "AAB6"], ["AAB9", "AABD"], ["AAC0", "AAC0"], ["AAC2", "AAC2"], ["AADB", "AADC"], ["AAE0", "AAEA"], ["AAF2", "AAF2"], ["AB01", "AB06"], ["AB09", "AB0E"], ["AB11", "AB16"], ["AB20", "AB26"], ["AB28", "AB2E"], ["ABC0", "ABE2"], ["AC00", "D7A3"], ["D7B0", "D7C6"], ["D7CB", "D7FB"], ["F900", "FA6D"], ["FA70", "FAD9"], ["FB1D", "FB1D"], ["FB1F", "FB28"], ["FB2A", "FB36"], ["FB38", "FB3C"], ["FB3E", "FB3E"], ["FB40", "FB41"], ["FB43", "FB44"], ["FB46", "FBB1"], ["FBD3", "FD3D"], ["FD50", "FD8F"], ["FD92", "FDC7"], ["FDF0", "FDFB"], ["FE70", "FE74"], ["FE76", "FEFC"], ["FF66", "FF6F"], ["FF71", "FF9D"], ["FFA0", "FFBE"], ["FFC2", "FFC7"], ["FFCA", "FFCF"], ["FFD2", "FFD7"], ["FFDA", "FFDC"], ["10000", "1000B"], ["1000D", "10026"], ["10028", "1003A"], ["1003C", "1003D"], ["1003F", "1004D"], ["10050", "1005D"], ["10080", "100FA"], ["10280", "1029C"], ["102A0", "102D0"], ["10300", "1031E"], ["10330", "10340"], ["10342", "10349"], ["10380", "1039D"], ["103A0", "103C3"], ["103C8", "103CF"], ["10450", "1049D"], ["10800", "10805"], ["10808", "10808"], ["1080A", "10835"], ["10837", "10838"], ["1083C", "1083C"], ["1083F", "10855"], ["10900", "10915"], ["10920", "10939"], ["10980", "109B7"], ["109BE", "109BF"], ["10A00", "10A00"], ["10A10", "10A13"], ["10A15", "10A17"], ["10A19", "10A33"], ["10A60", "10A7C"], ["10B00", "10B35"], ["10B40", "10B55"], ["10B60", "10B72"], ["10C00", "10C48"], ["11003", "11037"], ["11083", "110AF"], ["110D0", "110E8"], ["11103", "11126"], ["11183", "111B2"], ["111C1", "111C4"], ["11680", "116AA"], ["12000", "1236E"], ["13000", "1342E"], ["16800", "16A38"], ["16F00", "16F44"], ["16F50", "16F50"], ["1B000", "1B001"], ["1EE00", "1EE03"], ["1EE05", "1EE1F"], ["1EE21", "1EE22"], ["1EE24", "1EE24"], ["1EE27", "1EE27"], ["1EE29", "1EE32"], ["1EE34", "1EE37"], ["1EE39", "1EE39"], ["1EE3B", "1EE3B"], ["1EE42", "1EE42"], ["1EE47", "1EE47"], ["1EE49", "1EE49"], ["1EE4B", "1EE4B"], ["1EE4D", "1EE4F"], ["1EE51", "1EE52"], ["1EE54", "1EE54"], ["1EE57", "1EE57"], ["1EE59", "1EE59"], ["1EE5B", "1EE5B"], ["1EE5D", "1EE5D"], ["1EE5F", "1EE5F"], ["1EE61", "1EE62"], ["1EE64", "1EE64"], ["1EE67", "1EE6A"], ["1EE6C", "1EE72"], ["1EE74", "1EE77"], ["1EE79", "1EE7C"], ["1EE7E", "1EE7E"], ["1EE80", "1EE89"], ["1EE8B", "1EE9B"], ["1EEA1", "1EEA3"], ["1EEA5", "1EEA9"], ["1EEAB", "1EEBB"], ["20000", "2A6D6"], ["2A700", "2B734"], ["2B740", "2B81D"], ["2F800", "2FA1D"]],
            Lt: [["1C5", "1C5"], ["1C8", "1C8"], ["1CB", "1CB"], ["1F2", "1F2"], ["1F88", "1F8F"], ["1F98", "1F9F"], ["1FA8", "1FAF"], ["1FBC", "1FBC"], ["1FCC", "1FCC"], ["1FFC", "1FFC"]],
            Lu: [["41", "5A"], ["C0", "D6"], ["D8", "DE"], ["100", "100"], ["102", "102"], ["104", "104"], ["106", "106"], ["108", "108"], ["10A", "10A"], ["10C", "10C"], ["10E", "10E"], ["110", "110"], ["112", "112"], ["114", "114"], ["116", "116"], ["118", "118"], ["11A", "11A"], ["11C", "11C"], ["11E", "11E"], ["120", "120"], ["122", "122"], ["124", "124"], ["126", "126"], ["128", "128"], ["12A", "12A"], ["12C", "12C"], ["12E", "12E"], ["130", "130"], ["132", "132"], ["134", "134"], ["136", "136"], ["139", "139"], ["13B", "13B"], ["13D", "13D"], ["13F", "13F"], ["141", "141"], ["143", "143"], ["145", "145"], ["147", "147"], ["14A", "14A"], ["14C", "14C"], ["14E", "14E"], ["150", "150"], ["152", "152"], ["154", "154"], ["156", "156"], ["158", "158"], ["15A", "15A"], ["15C", "15C"], ["15E", "15E"], ["160", "160"], ["162", "162"], ["164", "164"], ["166", "166"], ["168", "168"], ["16A", "16A"], ["16C", "16C"], ["16E", "16E"], ["170", "170"], ["172", "172"], ["174", "174"], ["176", "176"], ["178", "179"], ["17B", "17B"], ["17D", "17D"], ["181", "182"], ["184", "184"], ["186", "187"], ["189", "18B"], ["18E", "191"], ["193", "194"], ["196", "198"], ["19C", "19D"], ["19F", "1A0"], ["1A2", "1A2"], ["1A4", "1A4"], ["1A6", "1A7"], ["1A9", "1A9"], ["1AC", "1AC"], ["1AE", "1AF"], ["1B1", "1B3"], ["1B5", "1B5"], ["1B7", "1B8"], ["1BC", "1BC"], ["1C4", "1C4"], ["1C7", "1C7"], ["1CA", "1CA"], ["1CD", "1CD"], ["1CF", "1CF"], ["1D1", "1D1"], ["1D3", "1D3"], ["1D5", "1D5"], ["1D7", "1D7"], ["1D9", "1D9"], ["1DB", "1DB"], ["1DE", "1DE"], ["1E0", "1E0"], ["1E2", "1E2"], ["1E4", "1E4"], ["1E6", "1E6"], ["1E8", "1E8"], ["1EA", "1EA"], ["1EC", "1EC"], ["1EE", "1EE"], ["1F1", "1F1"], ["1F4", "1F4"], ["1F6", "1F8"], ["1FA", "1FA"], ["1FC", "1FC"], ["1FE", "1FE"], ["200", "200"], ["202", "202"], ["204", "204"], ["206", "206"], ["208", "208"], ["20A", "20A"], ["20C", "20C"], ["20E", "20E"], ["210", "210"], ["212", "212"], ["214", "214"], ["216", "216"], ["218", "218"], ["21A", "21A"], ["21C", "21C"], ["21E", "21E"], ["220", "220"], ["222", "222"], ["224", "224"], ["226", "226"], ["228", "228"], ["22A", "22A"], ["22C", "22C"], ["22E", "22E"], ["230", "230"], ["232", "232"], ["23A", "23B"], ["23D", "23E"], ["241", "241"], ["243", "246"], ["248", "248"], ["24A", "24A"], ["24C", "24C"], ["24E", "24E"], ["370", "370"], ["372", "372"], ["376", "376"], ["386", "386"], ["388", "38A"], ["38C", "38C"], ["38E", "38F"], ["391", "3A1"], ["3A3", "3AB"], ["3CF", "3CF"], ["3D2", "3D4"], ["3D8", "3D8"], ["3DA", "3DA"], ["3DC", "3DC"], ["3DE", "3DE"], ["3E0", "3E0"], ["3E2", "3E2"], ["3E4", "3E4"], ["3E6", "3E6"], ["3E8", "3E8"], ["3EA", "3EA"], ["3EC", "3EC"], ["3EE", "3EE"], ["3F4", "3F4"], ["3F7", "3F7"], ["3F9", "3FA"], ["3FD", "42F"], ["460", "460"], ["462", "462"], ["464", "464"], ["466", "466"], ["468", "468"], ["46A", "46A"], ["46C", "46C"], ["46E", "46E"], ["470", "470"], ["472", "472"], ["474", "474"], ["476", "476"], ["478", "478"], ["47A", "47A"], ["47C", "47C"], ["47E", "47E"], ["480", "480"], ["48A", "48A"], ["48C", "48C"], ["48E", "48E"], ["490", "490"], ["492", "492"], ["494", "494"], ["496", "496"], ["498", "498"], ["49A", "49A"], ["49C", "49C"], ["49E", "49E"], ["4A0", "4A0"], ["4A2", "4A2"], ["4A4", "4A4"], ["4A6", "4A6"], ["4A8", "4A8"], ["4AA", "4AA"], ["4AC", "4AC"], ["4AE", "4AE"], ["4B0", "4B0"], ["4B2", "4B2"], ["4B4", "4B4"], ["4B6", "4B6"], ["4B8", "4B8"], ["4BA", "4BA"], ["4BC", "4BC"], ["4BE", "4BE"], ["4C0", "4C1"], ["4C3", "4C3"], ["4C5", "4C5"], ["4C7", "4C7"], ["4C9", "4C9"], ["4CB", "4CB"], ["4CD", "4CD"], ["4D0", "4D0"], ["4D2", "4D2"], ["4D4", "4D4"], ["4D6", "4D6"], ["4D8", "4D8"], ["4DA", "4DA"], ["4DC", "4DC"], ["4DE", "4DE"], ["4E0", "4E0"], ["4E2", "4E2"], ["4E4", "4E4"], ["4E6", "4E6"], ["4E8", "4E8"], ["4EA", "4EA"], ["4EC", "4EC"], ["4EE", "4EE"], ["4F0", "4F0"], ["4F2", "4F2"], ["4F4", "4F4"], ["4F6", "4F6"], ["4F8", "4F8"], ["4FA", "4FA"], ["4FC", "4FC"], ["4FE", "4FE"], ["500", "500"], ["502", "502"], ["504", "504"], ["506", "506"], ["508", "508"], ["50A", "50A"], ["50C", "50C"], ["50E", "50E"], ["510", "510"], ["512", "512"], ["514", "514"], ["516", "516"], ["518", "518"], ["51A", "51A"], ["51C", "51C"], ["51E", "51E"], ["520", "520"], ["522", "522"], ["524", "524"], ["526", "526"], ["531", "556"], ["10A0", "10C5"], ["10C7", "10C7"], ["10CD", "10CD"], ["1E00", "1E00"], ["1E02", "1E02"], ["1E04", "1E04"], ["1E06", "1E06"], ["1E08", "1E08"], ["1E0A", "1E0A"], ["1E0C", "1E0C"], ["1E0E", "1E0E"], ["1E10", "1E10"], ["1E12", "1E12"], ["1E14", "1E14"], ["1E16", "1E16"], ["1E18", "1E18"], ["1E1A", "1E1A"], ["1E1C", "1E1C"], ["1E1E", "1E1E"], ["1E20", "1E20"], ["1E22", "1E22"], ["1E24", "1E24"], ["1E26", "1E26"], ["1E28", "1E28"], ["1E2A", "1E2A"], ["1E2C", "1E2C"], ["1E2E", "1E2E"], ["1E30", "1E30"], ["1E32", "1E32"], ["1E34", "1E34"], ["1E36", "1E36"], ["1E38", "1E38"], ["1E3A", "1E3A"], ["1E3C", "1E3C"], ["1E3E", "1E3E"], ["1E40", "1E40"], ["1E42", "1E42"], ["1E44", "1E44"], ["1E46", "1E46"], ["1E48", "1E48"], ["1E4A", "1E4A"], ["1E4C", "1E4C"], ["1E4E", "1E4E"], ["1E50", "1E50"], ["1E52", "1E52"], ["1E54", "1E54"], ["1E56", "1E56"], ["1E58", "1E58"], ["1E5A", "1E5A"], ["1E5C", "1E5C"], ["1E5E", "1E5E"], ["1E60", "1E60"], ["1E62", "1E62"], ["1E64", "1E64"], ["1E66", "1E66"], ["1E68", "1E68"], ["1E6A", "1E6A"], ["1E6C", "1E6C"], ["1E6E", "1E6E"], ["1E70", "1E70"], ["1E72", "1E72"], ["1E74", "1E74"], ["1E76", "1E76"], ["1E78", "1E78"], ["1E7A", "1E7A"], ["1E7C", "1E7C"], ["1E7E", "1E7E"], ["1E80", "1E80"], ["1E82", "1E82"], ["1E84", "1E84"], ["1E86", "1E86"], ["1E88", "1E88"], ["1E8A", "1E8A"], ["1E8C", "1E8C"], ["1E8E", "1E8E"], ["1E90", "1E90"], ["1E92", "1E92"], ["1E94", "1E94"], ["1E9E", "1E9E"], ["1EA0", "1EA0"], ["1EA2", "1EA2"], ["1EA4", "1EA4"], ["1EA6", "1EA6"], ["1EA8", "1EA8"], ["1EAA", "1EAA"], ["1EAC", "1EAC"], ["1EAE", "1EAE"], ["1EB0", "1EB0"], ["1EB2", "1EB2"], ["1EB4", "1EB4"], ["1EB6", "1EB6"], ["1EB8", "1EB8"], ["1EBA", "1EBA"], ["1EBC", "1EBC"], ["1EBE", "1EBE"], ["1EC0", "1EC0"], ["1EC2", "1EC2"], ["1EC4", "1EC4"], ["1EC6", "1EC6"], ["1EC8", "1EC8"], ["1ECA", "1ECA"], ["1ECC", "1ECC"], ["1ECE", "1ECE"], ["1ED0", "1ED0"], ["1ED2", "1ED2"], ["1ED4", "1ED4"], ["1ED6", "1ED6"], ["1ED8", "1ED8"], ["1EDA", "1EDA"], ["1EDC", "1EDC"], ["1EDE", "1EDE"], ["1EE0", "1EE0"], ["1EE2", "1EE2"], ["1EE4", "1EE4"], ["1EE6", "1EE6"], ["1EE8", "1EE8"], ["1EEA", "1EEA"], ["1EEC", "1EEC"], ["1EEE", "1EEE"], ["1EF0", "1EF0"], ["1EF2", "1EF2"], ["1EF4", "1EF4"], ["1EF6", "1EF6"], ["1EF8", "1EF8"], ["1EFA", "1EFA"], ["1EFC", "1EFC"], ["1EFE", "1EFE"], ["1F08", "1F0F"], ["1F18", "1F1D"], ["1F28", "1F2F"], ["1F38", "1F3F"], ["1F48", "1F4D"], ["1F59", "1F59"], ["1F5B", "1F5B"], ["1F5D", "1F5D"], ["1F5F", "1F5F"], ["1F68", "1F6F"], ["1FB8", "1FBB"], ["1FC8", "1FCB"], ["1FD8", "1FDB"], ["1FE8", "1FEC"], ["1FF8", "1FFB"], ["2102", "2102"], ["2107", "2107"], ["210B", "210D"], ["2110", "2112"], ["2115", "2115"], ["2119", "211D"], ["2124", "2124"], ["2126", "2126"], ["2128", "2128"], ["212A", "212D"], ["2130", "2133"], ["213E", "213F"], ["2145", "2145"], ["2183", "2183"], ["2C00", "2C2E"], ["2C60", "2C60"], ["2C62", "2C64"], ["2C67", "2C67"], ["2C69", "2C69"], ["2C6B", "2C6B"], ["2C6D", "2C70"], ["2C72", "2C72"], ["2C75", "2C75"], ["2C7E", "2C80"], ["2C82", "2C82"], ["2C84", "2C84"], ["2C86", "2C86"], ["2C88", "2C88"], ["2C8A", "2C8A"], ["2C8C", "2C8C"], ["2C8E", "2C8E"], ["2C90", "2C90"], ["2C92", "2C92"], ["2C94", "2C94"], ["2C96", "2C96"], ["2C98", "2C98"], ["2C9A", "2C9A"], ["2C9C", "2C9C"], ["2C9E", "2C9E"], ["2CA0", "2CA0"], ["2CA2", "2CA2"], ["2CA4", "2CA4"], ["2CA6", "2CA6"], ["2CA8", "2CA8"], ["2CAA", "2CAA"], ["2CAC", "2CAC"], ["2CAE", "2CAE"], ["2CB0", "2CB0"], ["2CB2", "2CB2"], ["2CB4", "2CB4"], ["2CB6", "2CB6"], ["2CB8", "2CB8"], ["2CBA", "2CBA"], ["2CBC", "2CBC"], ["2CBE", "2CBE"], ["2CC0", "2CC0"], ["2CC2", "2CC2"], ["2CC4", "2CC4"], ["2CC6", "2CC6"], ["2CC8", "2CC8"], ["2CCA", "2CCA"], ["2CCC", "2CCC"], ["2CCE", "2CCE"], ["2CD0", "2CD0"], ["2CD2", "2CD2"], ["2CD4", "2CD4"], ["2CD6", "2CD6"], ["2CD8", "2CD8"], ["2CDA", "2CDA"], ["2CDC", "2CDC"], ["2CDE", "2CDE"], ["2CE0", "2CE0"], ["2CE2", "2CE2"], ["2CEB", "2CEB"], ["2CED", "2CED"], ["2CF2", "2CF2"], ["A640", "A640"], ["A642", "A642"], ["A644", "A644"], ["A646", "A646"], ["A648", "A648"], ["A64A", "A64A"], ["A64C", "A64C"], ["A64E", "A64E"], ["A650", "A650"], ["A652", "A652"], ["A654", "A654"], ["A656", "A656"], ["A658", "A658"], ["A65A", "A65A"], ["A65C", "A65C"], ["A65E", "A65E"], ["A660", "A660"], ["A662", "A662"], ["A664", "A664"], ["A666", "A666"], ["A668", "A668"], ["A66A", "A66A"], ["A66C", "A66C"], ["A680", "A680"], ["A682", "A682"], ["A684", "A684"], ["A686", "A686"], ["A688", "A688"], ["A68A", "A68A"], ["A68C", "A68C"], ["A68E", "A68E"], ["A690", "A690"], ["A692", "A692"], ["A694", "A694"], ["A696", "A696"], ["A722", "A722"], ["A724", "A724"], ["A726", "A726"], ["A728", "A728"], ["A72A", "A72A"], ["A72C", "A72C"], ["A72E", "A72E"], ["A732", "A732"], ["A734", "A734"], ["A736", "A736"], ["A738", "A738"], ["A73A", "A73A"], ["A73C", "A73C"], ["A73E", "A73E"], ["A740", "A740"], ["A742", "A742"], ["A744", "A744"], ["A746", "A746"], ["A748", "A748"], ["A74A", "A74A"], ["A74C", "A74C"], ["A74E", "A74E"], ["A750", "A750"], ["A752", "A752"], ["A754", "A754"], ["A756", "A756"], ["A758", "A758"], ["A75A", "A75A"], ["A75C", "A75C"], ["A75E", "A75E"], ["A760", "A760"], ["A762", "A762"], ["A764", "A764"], ["A766", "A766"], ["A768", "A768"], ["A76A", "A76A"], ["A76C", "A76C"], ["A76E", "A76E"], ["A779", "A779"], ["A77B", "A77B"], ["A77D", "A77E"], ["A780", "A780"], ["A782", "A782"], ["A784", "A784"], ["A786", "A786"], ["A78B", "A78B"], ["A78D", "A78D"], ["A790", "A790"], ["A792", "A792"], ["A7A0", "A7A0"], ["A7A2", "A7A2"], ["A7A4", "A7A4"], ["A7A6", "A7A6"], ["A7A8", "A7A8"], ["A7AA", "A7AA"], ["FF21", "FF3A"], ["10400", "10427"], ["1D400", "1D419"], ["1D434", "1D44D"], ["1D468", "1D481"], ["1D49C", "1D49C"], ["1D49E", "1D49F"], ["1D4A2", "1D4A2"], ["1D4A5", "1D4A6"], ["1D4A9", "1D4AC"], ["1D4AE", "1D4B5"], ["1D4D0", "1D4E9"], ["1D504", "1D505"], ["1D507", "1D50A"], ["1D50D", "1D514"], ["1D516", "1D51C"], ["1D538", "1D539"], ["1D53B", "1D53E"], ["1D540", "1D544"], ["1D546", "1D546"], ["1D54A", "1D550"], ["1D56C", "1D585"], ["1D5A0", "1D5B9"], ["1D5D4", "1D5ED"], ["1D608", "1D621"], ["1D63C", "1D655"], ["1D670", "1D689"], ["1D6A8", "1D6C0"], ["1D6E2", "1D6FA"], ["1D71C", "1D734"], ["1D756", "1D76E"], ["1D790", "1D7A8"], ["1D7CA", "1D7CA"]],
            M: "Mc|Me|Mn",
            Mc: [["903", "903"], ["93B", "93B"], ["93E", "940"], ["949", "94C"], ["94E", "94F"], ["982", "983"], ["9BE", "9C0"], ["9C7", "9C8"], ["9CB", "9CC"], ["9D7", "9D7"], ["A03", "A03"], ["A3E", "A40"], ["A83", "A83"], ["ABE", "AC0"], ["AC9", "AC9"], ["ACB", "ACC"], ["B02", "B03"], ["B3E", "B3E"], ["B40", "B40"], ["B47", "B48"], ["B4B", "B4C"], ["B57", "B57"], ["BBE", "BBF"], ["BC1", "BC2"], ["BC6", "BC8"], ["BCA", "BCC"], ["BD7", "BD7"], ["C01", "C03"], ["C41", "C44"], ["C82", "C83"], ["CBE", "CBE"], ["CC0", "CC4"], ["CC7", "CC8"], ["CCA", "CCB"], ["CD5", "CD6"], ["D02", "D03"], ["D3E", "D40"], ["D46", "D48"], ["D4A", "D4C"], ["D57", "D57"], ["D82", "D83"], ["DCF", "DD1"], ["DD8", "DDF"], ["DF2", "DF3"], ["F3E", "F3F"], ["F7F", "F7F"], ["102B", "102C"], ["1031", "1031"], ["1038", "1038"], ["103B", "103C"], ["1056", "1057"], ["1062", "1064"], ["1067", "106D"], ["1083", "1084"], ["1087", "108C"], ["108F", "108F"], ["109A", "109C"], ["17B6", "17B6"], ["17BE", "17C5"], ["17C7", "17C8"], ["1923", "1926"], ["1929", "192B"], ["1930", "1931"], ["1933", "1938"], ["19B0", "19C0"], ["19C8", "19C9"], ["1A19", "1A1B"], ["1A55", "1A55"], ["1A57", "1A57"], ["1A61", "1A61"], ["1A63", "1A64"], ["1A6D", "1A72"], ["1B04", "1B04"], ["1B35", "1B35"], ["1B3B", "1B3B"], ["1B3D", "1B41"], ["1B43", "1B44"], ["1B82", "1B82"], ["1BA1", "1BA1"], ["1BA6", "1BA7"], ["1BAA", "1BAA"], ["1BAC", "1BAD"], ["1BE7", "1BE7"], ["1BEA", "1BEC"], ["1BEE", "1BEE"], ["1BF2", "1BF3"], ["1C24", "1C2B"], ["1C34", "1C35"], ["1CE1", "1CE1"], ["1CF2", "1CF3"], ["302E", "302F"], ["A823", "A824"], ["A827", "A827"], ["A880", "A881"], ["A8B4", "A8C3"], ["A952", "A953"], ["A983", "A983"], ["A9B4", "A9B5"], ["A9BA", "A9BB"], ["A9BD", "A9C0"], ["AA2F", "AA30"], ["AA33", "AA34"], ["AA4D", "AA4D"], ["AA7B", "AA7B"], ["AAEB", "AAEB"], ["AAEE", "AAEF"], ["AAF5", "AAF5"], ["ABE3", "ABE4"], ["ABE6", "ABE7"], ["ABE9", "ABEA"], ["ABEC", "ABEC"], ["11000", "11000"], ["11002", "11002"], ["11082", "11082"], ["110B0", "110B2"], ["110B7", "110B8"], ["1112C", "1112C"], ["11182", "11182"], ["111B3", "111B5"], ["111BF", "111C0"], ["116AC", "116AC"], ["116AE", "116AF"], ["116B6", "116B6"], ["16F51", "16F7E"], ["1D165", "1D166"], ["1D16D", "1D172"]],
            Me: [["488", "489"], ["20DD", "20E0"], ["20E2", "20E4"], ["A670", "A672"]],
            Mn: [["300", "36F"], ["483", "487"], ["591", "5BD"], ["5BF", "5BF"], ["5C1", "5C2"], ["5C4", "5C5"], ["5C7", "5C7"], ["610", "61A"], ["64B", "65F"], ["670", "670"], ["6D6", "6DC"], ["6DF", "6E4"], ["6E7", "6E8"], ["6EA", "6ED"], ["711", "711"], ["730", "74A"], ["7A6", "7B0"], ["7EB", "7F3"], ["816", "819"], ["81B", "823"], ["825", "827"], ["829", "82D"], ["859", "85B"], ["8E4", "8FE"], ["900", "902"], ["93A", "93A"], ["93C", "93C"], ["941", "948"], ["94D", "94D"], ["951", "957"], ["962", "963"], ["981", "981"], ["9BC", "9BC"], ["9C1", "9C4"], ["9CD", "9CD"], ["9E2", "9E3"], ["A01", "A02"], ["A3C", "A3C"], ["A41", "A42"], ["A47", "A48"], ["A4B", "A4D"], ["A51", "A51"], ["A70", "A71"], ["A75", "A75"], ["A81", "A82"], ["ABC", "ABC"], ["AC1", "AC5"], ["AC7", "AC8"], ["ACD", "ACD"], ["AE2", "AE3"], ["B01", "B01"], ["B3C", "B3C"], ["B3F", "B3F"], ["B41", "B44"], ["B4D", "B4D"], ["B56", "B56"], ["B62", "B63"], ["B82", "B82"], ["BC0", "BC0"], ["BCD", "BCD"], ["C3E", "C40"], ["C46", "C48"], ["C4A", "C4D"], ["C55", "C56"], ["C62", "C63"], ["CBC", "CBC"], ["CBF", "CBF"], ["CC6", "CC6"], ["CCC", "CCD"], ["CE2", "CE3"], ["D41", "D44"], ["D4D", "D4D"], ["D62", "D63"], ["DCA", "DCA"], ["DD2", "DD4"], ["DD6", "DD6"], ["E31", "E31"], ["E34", "E3A"], ["E47", "E4E"], ["EB1", "EB1"], ["EB4", "EB9"], ["EBB", "EBC"], ["EC8", "ECD"], ["F18", "F19"], ["F35", "F35"], ["F37", "F37"], ["F39", "F39"], ["F71", "F7E"], ["F80", "F84"], ["F86", "F87"], ["F8D", "F97"], ["F99", "FBC"], ["FC6", "FC6"], ["102D", "1030"], ["1032", "1037"], ["1039", "103A"], ["103D", "103E"], ["1058", "1059"], ["105E", "1060"], ["1071", "1074"], ["1082", "1082"], ["1085", "1086"], ["108D", "108D"], ["109D", "109D"], ["135D", "135F"], ["1712", "1714"], ["1732", "1734"], ["1752", "1753"], ["1772", "1773"], ["17B4", "17B5"], ["17B7", "17BD"], ["17C6", "17C6"], ["17C9", "17D3"], ["17DD", "17DD"], ["180B", "180D"], ["18A9", "18A9"], ["1920", "1922"], ["1927", "1928"], ["1932", "1932"], ["1939", "193B"], ["1A17", "1A18"], ["1A56", "1A56"], ["1A58", "1A5E"], ["1A60", "1A60"], ["1A62", "1A62"], ["1A65", "1A6C"], ["1A73", "1A7C"], ["1A7F", "1A7F"], ["1B00", "1B03"], ["1B34", "1B34"], ["1B36", "1B3A"], ["1B3C", "1B3C"], ["1B42", "1B42"], ["1B6B", "1B73"], ["1B80", "1B81"], ["1BA2", "1BA5"], ["1BA8", "1BA9"], ["1BAB", "1BAB"], ["1BE6", "1BE6"], ["1BE8", "1BE9"], ["1BED", "1BED"], ["1BEF", "1BF1"], ["1C2C", "1C33"], ["1C36", "1C37"], ["1CD0", "1CD2"], ["1CD4", "1CE0"], ["1CE2", "1CE8"], ["1CED", "1CED"], ["1CF4", "1CF4"], ["1DC0", "1DE6"], ["1DFC", "1DFF"], ["20D0", "20DC"], ["20E1", "20E1"], ["20E5", "20F0"], ["2CEF", "2CF1"], ["2D7F", "2D7F"], ["2DE0", "2DFF"], ["302A", "302D"], ["3099", "309A"], ["A66F", "A66F"], ["A674", "A67D"], ["A69F", "A69F"], ["A6F0", "A6F1"], ["A802", "A802"], ["A806", "A806"], ["A80B", "A80B"], ["A825", "A826"], ["A8C4", "A8C4"], ["A8E0", "A8F1"], ["A926", "A92D"], ["A947", "A951"], ["A980", "A982"], ["A9B3", "A9B3"], ["A9B6", "A9B9"], ["A9BC", "A9BC"], ["AA29", "AA2E"], ["AA31", "AA32"], ["AA35", "AA36"], ["AA43", "AA43"], ["AA4C", "AA4C"], ["AAB0", "AAB0"], ["AAB2", "AAB4"], ["AAB7", "AAB8"], ["AABE", "AABF"], ["AAC1", "AAC1"], ["AAEC", "AAED"], ["AAF6", "AAF6"], ["ABE5", "ABE5"], ["ABE8", "ABE8"], ["ABED", "ABED"], ["FB1E", "FB1E"], ["FE00", "FE0F"], ["FE20", "FE26"], ["101FD", "101FD"], ["10A01", "10A03"], ["10A05", "10A06"], ["10A0C", "10A0F"], ["10A38", "10A3A"], ["10A3F", "10A3F"], ["11001", "11001"], ["11038", "11046"], ["11080", "11081"], ["110B3", "110B6"], ["110B9", "110BA"], ["11100", "11102"], ["11127", "1112B"], ["1112D", "11134"], ["11180", "11181"], ["111B6", "111BE"], ["116AB", "116AB"], ["116AD", "116AD"], ["116B0", "116B5"], ["116B7", "116B7"], ["16F8F", "16F92"], ["1D167", "1D169"], ["1D17B", "1D182"], ["1D185", "1D18B"], ["1D1AA", "1D1AD"], ["1D242", "1D244"], ["E0100", "E01EF"]],
            N: "Nd|Nl|No",
            Nd: [["30", "39"], ["660", "669"], ["6F0", "6F9"], ["7C0", "7C9"], ["966", "96F"], ["9E6", "9EF"], ["A66", "A6F"], ["AE6", "AEF"], ["B66", "B6F"], ["BE6", "BEF"], ["C66", "C6F"], ["CE6", "CEF"], ["D66", "D6F"], ["E50", "E59"], ["ED0", "ED9"], ["F20", "F29"], ["1040", "1049"], ["1090", "1099"], ["17E0", "17E9"], ["1810", "1819"], ["1946", "194F"], ["19D0", "19D9"], ["1A80", "1A89"], ["1A90", "1A99"], ["1B50", "1B59"], ["1BB0", "1BB9"], ["1C40", "1C49"], ["1C50", "1C59"], ["A620", "A629"], ["A8D0", "A8D9"], ["A900", "A909"], ["A9D0", "A9D9"], ["AA50", "AA59"], ["ABF0", "ABF9"], ["FF10", "FF19"], ["104A0", "104A9"], ["11066", "1106F"], ["110F0", "110F9"], ["11136", "1113F"], ["111D0", "111D9"], ["116C0", "116C9"], ["1D7CE", "1D7FF"]],
            Nl: [["16EE", "16F0"], ["2160", "2182"], ["2185", "2188"], ["3007", "3007"], ["3021", "3029"], ["3038", "303A"], ["A6E6", "A6EF"], ["10140", "10174"], ["10341", "10341"], ["1034A", "1034A"], ["103D1", "103D5"], ["12400", "12462"]],
            No: [["B2", "B3"], ["B9", "B9"], ["BC", "BE"], ["9F4", "9F9"], ["B72", "B77"], ["BF0", "BF2"], ["C78", "C7E"], ["D70", "D75"], ["F2A", "F33"], ["1369", "137C"], ["17F0", "17F9"], ["19DA", "19DA"], ["2070", "2070"], ["2074", "2079"], ["2080", "2089"], ["2150", "215F"], ["2189", "2189"], ["2460", "249B"], ["24EA", "24FF"], ["2776", "2793"], ["2CFD", "2CFD"], ["3192", "3195"], ["3220", "3229"], ["3248", "324F"], ["3251", "325F"], ["3280", "3289"], ["32B1", "32BF"], ["A830", "A835"], ["10107", "10133"], ["10175", "10178"], ["1018A", "1018A"], ["10320", "10323"], ["10858", "1085F"], ["10916", "1091B"], ["10A40", "10A47"], ["10A7D", "10A7E"], ["10B58", "10B5F"], ["10B78", "10B7F"], ["10E60", "10E7E"], ["11052", "11065"], ["1D360", "1D371"], ["1F100", "1F10A"]],
            P: "Pc|Pd|Pe|Pf|Pi|Po|Ps",
            Pc: [["5F", "5F"], ["203F", "2040"], ["2054", "2054"], ["FE33", "FE34"], ["FE4D", "FE4F"], ["FF3F", "FF3F"]],
            Pd: [["2D", "2D"], ["58A", "58A"], ["5BE", "5BE"], ["1400", "1400"], ["1806", "1806"], ["2010", "2015"], ["2E17", "2E17"], ["2E1A", "2E1A"], ["2E3A", "2E3B"], ["301C", "301C"], ["3030", "3030"], ["30A0", "30A0"], ["FE31", "FE32"], ["FE58", "FE58"], ["FE63", "FE63"], ["FF0D", "FF0D"]],
            Pe: [["29", "29"], ["5D", "5D"], ["7D", "7D"], ["F3B", "F3B"], ["F3D", "F3D"], ["169C", "169C"], ["2046", "2046"], ["207E", "207E"], ["208E", "208E"], ["232A", "232A"], ["2769", "2769"], ["276B", "276B"], ["276D", "276D"], ["276F", "276F"], ["2771", "2771"], ["2773", "2773"], ["2775", "2775"], ["27C6", "27C6"], ["27E7", "27E7"], ["27E9", "27E9"], ["27EB", "27EB"], ["27ED", "27ED"], ["27EF", "27EF"], ["2984", "2984"], ["2986", "2986"], ["2988", "2988"], ["298A", "298A"], ["298C", "298C"], ["298E", "298E"], ["2990", "2990"], ["2992", "2992"], ["2994", "2994"], ["2996", "2996"], ["2998", "2998"], ["29D9", "29D9"], ["29DB", "29DB"], ["29FD", "29FD"], ["2E23", "2E23"], ["2E25", "2E25"], ["2E27", "2E27"], ["2E29", "2E29"], ["3009", "3009"], ["300B", "300B"], ["300D", "300D"], ["300F", "300F"], ["3011", "3011"], ["3015", "3015"], ["3017", "3017"], ["3019", "3019"], ["301B", "301B"], ["301E", "301F"], ["FD3F", "FD3F"], ["FE18", "FE18"], ["FE36", "FE36"], ["FE38", "FE38"], ["FE3A", "FE3A"], ["FE3C", "FE3C"], ["FE3E", "FE3E"], ["FE40", "FE40"], ["FE42", "FE42"], ["FE44", "FE44"], ["FE48", "FE48"], ["FE5A", "FE5A"], ["FE5C", "FE5C"], ["FE5E", "FE5E"], ["FF09", "FF09"], ["FF3D", "FF3D"], ["FF5D", "FF5D"], ["FF60", "FF60"], ["FF63", "FF63"]],
            Pf: [["BB", "BB"], ["2019", "2019"], ["201D", "201D"], ["203A", "203A"], ["2E03", "2E03"], ["2E05", "2E05"], ["2E0A", "2E0A"], ["2E0D", "2E0D"], ["2E1D", "2E1D"], ["2E21", "2E21"]],
            Pi: [["AB", "AB"], ["2018", "2018"], ["201B", "201C"], ["201F", "201F"], ["2039", "2039"], ["2E02", "2E02"], ["2E04", "2E04"], ["2E09", "2E09"], ["2E0C", "2E0C"], ["2E1C", "2E1C"], ["2E20", "2E20"]],
            Po: [["21", "23"], ["25", "27"], ["2A", "2A"], ["2C", "2C"], ["2E", "2F"], ["3A", "3B"], ["3F", "40"], ["5C", "5C"], ["A1", "A1"], ["A7", "A7"], ["B6", "B7"], ["BF", "BF"], ["37E", "37E"], ["387", "387"], ["55A", "55F"], ["589", "589"], ["5C0", "5C0"], ["5C3", "5C3"], ["5C6", "5C6"], ["5F3", "5F4"], ["609", "60A"], ["60C", "60D"], ["61B", "61B"], ["61E", "61F"], ["66A", "66D"], ["6D4", "6D4"], ["700", "70D"], ["7F7", "7F9"], ["830", "83E"], ["85E", "85E"], ["964", "965"], ["970", "970"], ["AF0", "AF0"], ["DF4", "DF4"], ["E4F", "E4F"], ["E5A", "E5B"], ["F04", "F12"], ["F14", "F14"], ["F85", "F85"], ["FD0", "FD4"], ["FD9", "FDA"], ["104A", "104F"], ["10FB", "10FB"], ["1360", "1368"], ["166D", "166E"], ["16EB", "16ED"], ["1735", "1736"], ["17D4", "17D6"], ["17D8", "17DA"], ["1800", "1805"], ["1807", "180A"], ["1944", "1945"], ["1A1E", "1A1F"], ["1AA0", "1AA6"], ["1AA8", "1AAD"], ["1B5A", "1B60"], ["1BFC", "1BFF"], ["1C3B", "1C3F"], ["1C7E", "1C7F"], ["1CC0", "1CC7"], ["1CD3", "1CD3"], ["2016", "2017"], ["2020", "2027"], ["2030", "2038"], ["203B", "203E"], ["2041", "2043"], ["2047", "2051"], ["2053", "2053"], ["2055", "205E"], ["2CF9", "2CFC"], ["2CFE", "2CFF"], ["2D70", "2D70"], ["2E00", "2E01"], ["2E06", "2E08"], ["2E0B", "2E0B"], ["2E0E", "2E16"], ["2E18", "2E19"], ["2E1B", "2E1B"], ["2E1E", "2E1F"], ["2E2A", "2E2E"], ["2E30", "2E39"], ["3001", "3003"], ["303D", "303D"], ["30FB", "30FB"], ["A4FE", "A4FF"], ["A60D", "A60F"], ["A673", "A673"], ["A67E", "A67E"], ["A6F2", "A6F7"], ["A874", "A877"], ["A8CE", "A8CF"], ["A8F8", "A8FA"], ["A92E", "A92F"], ["A95F", "A95F"], ["A9C1", "A9CD"], ["A9DE", "A9DF"], ["AA5C", "AA5F"], ["AADE", "AADF"], ["AAF0", "AAF1"], ["ABEB", "ABEB"], ["FE10", "FE16"], ["FE19", "FE19"], ["FE30", "FE30"], ["FE45", "FE46"], ["FE49", "FE4C"], ["FE50", "FE52"], ["FE54", "FE57"], ["FE5F", "FE61"], ["FE68", "FE68"], ["FE6A", "FE6B"], ["FF01", "FF03"], ["FF05", "FF07"], ["FF0A", "FF0A"], ["FF0C", "FF0C"], ["FF0E", "FF0F"], ["FF1A", "FF1B"], ["FF1F", "FF20"], ["FF3C", "FF3C"], ["FF61", "FF61"], ["FF64", "FF65"], ["10100", "10102"], ["1039F", "1039F"], ["103D0", "103D0"], ["10857", "10857"], ["1091F", "1091F"], ["1093F", "1093F"], ["10A50", "10A58"], ["10A7F", "10A7F"], ["10B39", "10B3F"], ["11047", "1104D"], ["110BB", "110BC"], ["110BE", "110C1"], ["11140", "11143"], ["111C5", "111C8"], ["12470", "12473"]],
            Ps: [["28", "28"], ["5B", "5B"], ["7B", "7B"], ["F3A", "F3A"], ["F3C", "F3C"], ["169B", "169B"], ["201A", "201A"], ["201E", "201E"], ["2045", "2045"], ["207D", "207D"], ["208D", "208D"], ["2329", "2329"], ["2768", "2768"], ["276A", "276A"], ["276C", "276C"], ["276E", "276E"], ["2770", "2770"], ["2772", "2772"], ["2774", "2774"], ["27C5", "27C5"], ["27E6", "27E6"], ["27E8", "27E8"], ["27EA", "27EA"], ["27EC", "27EC"], ["27EE", "27EE"], ["2983", "2983"], ["2985", "2985"], ["2987", "2987"], ["2989", "2989"], ["298B", "298B"], ["298D", "298D"], ["298F", "298F"], ["2991", "2991"], ["2993", "2993"], ["2995", "2995"], ["2997", "2997"], ["29D8", "29D8"], ["29DA", "29DA"], ["29FC", "29FC"], ["2E22", "2E22"], ["2E24", "2E24"], ["2E26", "2E26"], ["2E28", "2E28"], ["3008", "3008"], ["300A", "300A"], ["300C", "300C"], ["300E", "300E"], ["3010", "3010"], ["3014", "3014"], ["3016", "3016"], ["3018", "3018"], ["301A", "301A"], ["301D", "301D"], ["FD3E", "FD3E"], ["FE17", "FE17"], ["FE35", "FE35"], ["FE37", "FE37"], ["FE39", "FE39"], ["FE3B", "FE3B"], ["FE3D", "FE3D"], ["FE3F", "FE3F"], ["FE41", "FE41"], ["FE43", "FE43"], ["FE47", "FE47"], ["FE59", "FE59"], ["FE5B", "FE5B"], ["FE5D", "FE5D"], ["FF08", "FF08"], ["FF3B", "FF3B"], ["FF5B", "FF5B"], ["FF5F", "FF5F"], ["FF62", "FF62"]],
            S: "Sc|Sk|Sm|So",
            Sc: [["24", "24"], ["A2", "A5"], ["58F", "58F"], ["60B", "60B"], ["9F2", "9F3"], ["9FB", "9FB"], ["AF1", "AF1"], ["BF9", "BF9"], ["E3F", "E3F"], ["17DB", "17DB"], ["20A0", "20BA"], ["A838", "A838"], ["FDFC", "FDFC"], ["FE69", "FE69"], ["FF04", "FF04"], ["FFE0", "FFE1"], ["FFE5", "FFE6"]],
            Sk: [["5E", "5E"], ["60", "60"], ["A8", "A8"], ["AF", "AF"], ["B4", "B4"], ["B8", "B8"], ["2C2", "2C5"], ["2D2", "2DF"], ["2E5", "2EB"], ["2ED", "2ED"], ["2EF", "2FF"], ["375", "375"], ["384", "385"], ["1FBD", "1FBD"], ["1FBF", "1FC1"], ["1FCD", "1FCF"], ["1FDD", "1FDF"], ["1FED", "1FEF"], ["1FFD", "1FFE"], ["309B", "309C"], ["A700", "A716"], ["A720", "A721"], ["A789", "A78A"], ["FBB2", "FBC1"], ["FF3E", "FF3E"], ["FF40", "FF40"], ["FFE3", "FFE3"]],
            Sm: [["2B", "2B"], ["3C", "3E"], ["7C", "7C"], ["7E", "7E"], ["AC", "AC"], ["B1", "B1"], ["D7", "D7"], ["F7", "F7"], ["3F6", "3F6"], ["606", "608"], ["2044", "2044"], ["2052", "2052"], ["207A", "207C"], ["208A", "208C"], ["2118", "2118"], ["2140", "2144"], ["214B", "214B"], ["2190", "2194"], ["219A", "219B"], ["21A0", "21A0"], ["21A3", "21A3"], ["21A6", "21A6"], ["21AE", "21AE"], ["21CE", "21CF"], ["21D2", "21D2"], ["21D4", "21D4"], ["21F4", "22FF"], ["2308", "230B"], ["2320", "2321"], ["237C", "237C"], ["239B", "23B3"], ["23DC", "23E1"], ["25B7", "25B7"], ["25C1", "25C1"], ["25F8", "25FF"], ["266F", "266F"], ["27C0", "27C4"], ["27C7", "27E5"], ["27F0", "27FF"], ["2900", "2982"], ["2999", "29D7"], ["29DC", "29FB"], ["29FE", "2AFF"], ["2B30", "2B44"], ["2B47", "2B4C"], ["FB29", "FB29"], ["FE62", "FE62"], ["FE64", "FE66"], ["FF0B", "FF0B"], ["FF1C", "FF1E"], ["FF5C", "FF5C"], ["FF5E", "FF5E"], ["FFE2", "FFE2"], ["FFE9", "FFEC"], ["1D6C1", "1D6C1"], ["1D6DB", "1D6DB"], ["1D6FB", "1D6FB"], ["1D715", "1D715"], ["1D735", "1D735"], ["1D74F", "1D74F"], ["1D76F", "1D76F"], ["1D789", "1D789"], ["1D7A9", "1D7A9"], ["1D7C3", "1D7C3"], ["1EEF0", "1EEF1"]],
            So: [["A6", "A6"], ["A9", "A9"], ["AE", "AE"], ["B0", "B0"], ["482", "482"], ["60E", "60F"], ["6DE", "6DE"], ["6E9", "6E9"], ["6FD", "6FE"], ["7F6", "7F6"], ["9FA", "9FA"], ["B70", "B70"], ["BF3", "BF8"], ["BFA", "BFA"], ["C7F", "C7F"], ["D79", "D79"], ["F01", "F03"], ["F13", "F13"], ["F15", "F17"], ["F1A", "F1F"], ["F34", "F34"], ["F36", "F36"], ["F38", "F38"], ["FBE", "FC5"], ["FC7", "FCC"], ["FCE", "FCF"], ["FD5", "FD8"], ["109E", "109F"], ["1390", "1399"], ["1940", "1940"], ["19DE", "19FF"], ["1B61", "1B6A"], ["1B74", "1B7C"], ["2100", "2101"], ["2103", "2106"], ["2108", "2109"], ["2114", "2114"], ["2116", "2117"], ["211E", "2123"], ["2125", "2125"], ["2127", "2127"], ["2129", "2129"], ["212E", "212E"], ["213A", "213B"], ["214A", "214A"], ["214C", "214D"], ["214F", "214F"], ["2195", "2199"], ["219C", "219F"], ["21A1", "21A2"], ["21A4", "21A5"], ["21A7", "21AD"], ["21AF", "21CD"], ["21D0", "21D1"], ["21D3", "21D3"], ["21D5", "21F3"], ["2300", "2307"], ["230C", "231F"], ["2322", "2328"], ["232B", "237B"], ["237D", "239A"], ["23B4", "23DB"], ["23E2", "23F3"], ["2400", "2426"], ["2440", "244A"], ["249C", "24E9"], ["2500", "25B6"], ["25B8", "25C0"], ["25C2", "25F7"], ["2600", "266E"], ["2670", "26FF"], ["2701", "2767"], ["2794", "27BF"], ["2800", "28FF"], ["2B00", "2B2F"], ["2B45", "2B46"], ["2B50", "2B59"], ["2CE5", "2CEA"], ["2E80", "2E99"], ["2E9B", "2EF3"], ["2F00", "2FD5"], ["2FF0", "2FFB"], ["3004", "3004"], ["3012", "3013"], ["3020", "3020"], ["3036", "3037"], ["303E", "303F"], ["3190", "3191"], ["3196", "319F"], ["31C0", "31E3"], ["3200", "321E"], ["322A", "3247"], ["3250", "3250"], ["3260", "327F"], ["328A", "32B0"], ["32C0", "32FE"], ["3300", "33FF"], ["4DC0", "4DFF"], ["A490", "A4C6"], ["A828", "A82B"], ["A836", "A837"], ["A839", "A839"], ["AA77", "AA79"], ["FDFD", "FDFD"], ["FFE4", "FFE4"], ["FFE8", "FFE8"], ["FFED", "FFEE"], ["FFFC", "FFFD"], ["10137", "1013F"], ["10179", "10189"], ["10190", "1019B"], ["101D0", "101FC"], ["1D000", "1D0F5"], ["1D100", "1D126"], ["1D129", "1D164"], ["1D16A", "1D16C"], ["1D183", "1D184"], ["1D18C", "1D1A9"], ["1D1AE", "1D1DD"], ["1D200", "1D241"], ["1D245", "1D245"], ["1D300", "1D356"], ["1F000", "1F02B"], ["1F030", "1F093"], ["1F0A0", "1F0AE"], ["1F0B1", "1F0BE"], ["1F0C1", "1F0CF"], ["1F0D1", "1F0DF"], ["1F110", "1F12E"], ["1F130", "1F16B"], ["1F170", "1F19A"], ["1F1E6", "1F202"], ["1F210", "1F23A"], ["1F240", "1F248"], ["1F250", "1F251"], ["1F300", "1F320"], ["1F330", "1F335"], ["1F337", "1F37C"], ["1F380", "1F393"], ["1F3A0", "1F3C4"], ["1F3C6", "1F3CA"], ["1F3E0", "1F3F0"], ["1F400", "1F43E"], ["1F440", "1F440"], ["1F442", "1F4F7"], ["1F4F9", "1F4FC"], ["1F500", "1F53D"], ["1F540", "1F543"], ["1F550", "1F567"], ["1F5FB", "1F640"], ["1F645", "1F64F"], ["1F680", "1F6C5"], ["1F700", "1F773"]],
            Z: "Zl|Zp|Zs",
            Zl: [["2028", "2028"]],
            Zp: [["2029", "2029"]],
            Zs: [["20", "20"], ["A0", "A0"], ["1680", "1680"], ["180E", "180E"], ["2000", "200A"], ["202F", "202F"], ["205F", "205F"], ["3000", "3000"]],
            "~i": [["3A", "3A"], ["41", "5A"], ["5F", "5F"], ["61", "7A"], ["C0", "D6"], ["D8", "F6"], ["F8", "2FF"], ["370", "37D"], ["37F", "1FFF"], ["200C", "200D"], ["2070", "218F"], ["2C00", "2FEF"], ["3001", "D7FF"], ["F900", "FDCF"], ["FDF0", "FFFD"], ["10000", "EFFFF"]],
            "~c": [["2D", "2E"], ["30", "3A"], ["41", "5A"], ["5F", "5F"], ["61", "7A"], ["B7", "B7"], ["C0", "D6"], ["D8", "F6"], ["F8", "37D"], ["37F", "1FFF"], ["200C", "200D"], ["203F", "2040"], ["2070", "218F"], ["2C00", "2FEF"], ["3001", "D7FF"], ["F900", "FDCF"], ["FDF0", "FFFD"], ["10000", "EFFFF"]],
            w: "Ll|Lm|Lo|Lt|Lu|Mc|Me|Mn|Nd|Nl|No|Sc|Sk|Sm|So"
        },
        functions: {
            "http://www.w3.org/2005/xpath-functions": {
                QName: [2],
                abs: [1],
                "accumulator-after": [1],
                "accumulator-before": [1],
                "adjust-date-to-timezone": [1, 2],
                "adjust-dateTime-to-timezone": [1, 2],
                "adjust-time-to-timezone": [1, 2],
                "analyze-string": [2, 3],
                apply: [2],
                "available-environment-variables": [0],
                "available-system-properties": [0],
                avg: [1],
                "base-uri": [0, 1],
                "boolean": [1],
                ceiling: [1],
                "codepoint-equal": [2],
                "codepoints-to-string": [1],
                "collation-key": [1, 2],
                collection: [0, 1],
                compare: [2, 3],
                concat: [3],
                contains: [2, 3],
                "contains-token": [2, 3],
                "copy-of": [0, 1],
                count: [1],
                current: [0],
                "current-date": [0],
                "current-dateTime": [0],
                "current-group": [0],
                "current-grouping-key": [0],
                "current-merge-group": [0, 1],
                "current-merge-key": [0],
                "current-output-uri": [0],
                "current-time": [0],
                data: [0, 1],
                dateTime: [2],
                "day-from-date": [1],
                "day-from-dateTime": [1],
                "days-from-duration": [1],
                "deep-equal": [2, 3],
                "default-collation": [0],
                "default-language": [0],
                "distinct-values": [1, 2],
                doc: [1],
                "doc-available": [1],
                document: [1, 2],
                "document-uri": [0, 1],
                "element-available": [1],
                "element-with-id": [1, 2],
                empty: [1],
                "encode-for-uri": [1],
                "ends-with": [2, 3],
                "environment-variable": [1],
                error: [0, 1, 2, 3],
                "escape-html-uri": [1],
                "exactly-one": [1],
                exists: [1],
                "false": [0],
                filter: [2],
                floor: [1],
                "fold-left": [3],
                "fold-right": [3],
                "for-each": [2],
                "for-each-pair": [3],
                "format-date": [2, 5],
                "format-dateTime": [2, 5],
                "format-integer": [2, 3],
                "format-number": [2, 3],
                "format-time": [2, 5],
                "function-arity": [1],
                "function-available": [1, 2],
                "function-lookup": [2],
                "function-name": [1],
                "generate-id": [0, 1],
                "has-children": [0, 1],
                head: [1],
                "hours-from-dateTime": [1],
                "hours-from-duration": [1],
                "hours-from-time": [1],
                id: [1, 2],
                idref: [1, 2],
                "implicit-timezone": [0],
                "in-scope-prefixes": [1],
                "index-of": [2, 3],
                innermost: [1],
                "insert-before": [3],
                "iri-to-uri": [1],
                "json-doc": [1, 2],
                "json-to-xml": [1, 2],
                key: [2, 3],
                lang: [1, 2],
                last: [0],
                "load-xquery-module": [1, 2],
                "local-name": [0, 1],
                "local-name-from-QName": [1],
                "lower-case": [1],
                matches: [2, 3],
                max: [1, 2],
                min: [1, 2],
                "minutes-from-dateTime": [1],
                "minutes-from-duration": [1],
                "minutes-from-time": [1],
                "month-from-date": [1],
                "month-from-dateTime": [1],
                "months-from-duration": [1],
                name: [0, 1],
                "namespace-uri": [0, 1],
                "namespace-uri-for-prefix": [2],
                "namespace-uri-from-QName": [1],
                nilled: [0, 1],
                "node-name": [0, 1],
                "normalize-space": [0, 1],
                "normalize-unicode": [1, 2],
                not: [1],
                number: [0, 1],
                "one-or-more": [1],
                outermost: [1],
                "parse-ietf-date": [1],
                "parse-json": [1, 2],
                "parse-xml": [1],
                "parse-xml-fragment": [1],
                path: [0, 1],
                position: [0],
                "prefix-from-QName": [1],
                put: [2],
                "random-number-generator": [0, 1],
                "regex-group": [1],
                remove: [2],
                replace: [3, 4],
                "resolve-QName": [2],
                "resolve-uri": [1, 2],
                reverse: [1],
                root: [0, 1],
                round: [1, 2],
                "round-half-to-even": [1, 2],
                "seconds-from-dateTime": [1],
                "seconds-from-duration": [1],
                "seconds-from-time": [1],
                serialize: [1, 2],
                "serialize-json": [1, 2],
                snapshot: [0, 1],
                sort: [1, 3],
                "starts-with": [2, 3],
                "static-base-uri": [0],
                "stream-available": [1],
                string: [0, 1],
                "string-join": [1, 2],
                "string-length": [0, 1],
                "string-to-codepoints": [1],
                subsequence: [2, 3],
                substring: [2, 3],
                "substring-after": [2, 3],
                "substring-before": [2, 3],
                sum: [1, 2],
                "system-property": [1],
                tail: [1],
                "timezone-from-date": [1],
                "timezone-from-dateTime": [1],
                "timezone-from-time": [1],
                tokenize: [1, 2, 3],
                trace: [1, 2],
                transform: [1],
                translate: [3],
                "true": [0],
                "type-available": [1],
                unordered: [1],
                "unparsed-entity-public-id": [1, 2],
                "unparsed-entity-uri": [1, 2],
                "unparsed-text": [1, 2],
                "unparsed-text-available": [1, 2],
                "unparsed-text-lines": [1, 2],
                "upper-case": [1],
                "uri-collection": [0, 1],
                "xml-to-json": [1, 2],
                "year-from-date": [1],
                "year-from-dateTime": [1],
                "years-from-duration": [1],
                "zero-or-one": [1]
            },
            "http://www.w3.org/2005/xpath-functions/array": {
                append: [2],
                filter: [2],
                flatten: [1],
                "fold-left": [3],
                "fold-right": [3],
                "for-each": [2],
                "for-each-pair": [3],
                get: [2],
                head: [1],
                "insert-before": [3],
                join: [1],
                remove: [2],
                reverse: [1],
                size: [1],
                sort: [1, 2],
                subarray: [2, 3],
                tail: [1]
            },
            "http://www.w3.org/2005/xpath-functions/map": {
                contains: [2],
                entry: [2],
                "for-each": [2],
                get: [2],
                keys: [1],
                merge: [1],
                put: [3],
                remove: [2],
                size: [1]
            },
            "http://www.w3.org/2005/xpath-functions/math": {
                acos: [1],
                asin: [1],
                atan: [1],
                atan2: [2],
                cos: [1],
                exp: [1],
                exp10: [1],
                log: [1],
                log10: [1],
                pi: [0],
                pow: [2],
                sin: [1],
                sqrt: [1],
                tan: [1]
            },
            "http://www.w3.org/2001/XMLSchema": {
                numeric: [1],
                string: [1],
                "boolean": [1],
                duration: [1],
                dateTime: [1],
                date: [1],
                time: [1],
                gYearMonth: [1],
                gMonth: [1],
                gMonthDay: [1],
                gYear: [1],
                gDay: [1],
                hexBinary: [1],
                base64Binary: [1],
                anyURI: [1],
                QName: [1],
                untypedAtomic: [1],
                decimal: [1],
                "float": [1],
                "double": [1],
                integer: [1],
                nonPositiveInteger: [1],
                negativeInteger: [1],
                "long": [1],
                "int": [1],
                "short": [1],
                "byte": [1],
                nonNegativeInteger: [1],
                positiveInteger: [1],
                unsignedLong: [1],
                unsignedInt: [1],
                unsignedShort: [1],
                unsignedByte: [1],
                yearMonthDuration: [1],
                dayTimeDuration: [1],
                dateTimeStamp: [1],
                normalizedString: [1],
                token: [1],
                language: [1],
                Name: [1],
                NMTOKEN: [1],
                NCName: [1],
                ID: [1],
                IDREF: [1],
                ENTITY: [1],
                NMTOKENS: [1],
                ENTITIES: [1],
                IDREFS: [1],
                error: [1]
            },
            "http://saxonica.com/ns/interactiveXSLT": {
                apply: [2],
                call: [3],
                contains: [2],
                eval: [1],
                event: [0],
                get: [2],
                location: [0],
                page: [0],
                "query-params": [0],
                source: [0],
                style: [1],
                window: [0]
            }
        },
        elements: {
            accept: {},
            accumulator: {},
            "accumulator-rule": {},
            "analyze-string": {},
            "apply-imports": {},
            "apply-templates": {},
            assert: {},
            attribute: {},
            "attribute-set": {},
            "break": {},
            "call-template": {},
            "catch": {},
            "character-map": {},
            choose: {},
            comment: {},
            "context-item": {},
            copy: {},
            "copy-of": {},
            "decimal-format": {},
            document: {},
            element: {},
            evaluate: {},
            expose: {},
            fallback: {},
            "for-each": {},
            "for-each-group": {},
            fork: {},
            "function": {},
            "global-context-item": {},
            "if": {},
            "import": {},
            include: {},
            iterate: {},
            key: {},
            map: {},
            "map-entry": {},
            "matching-substring": {},
            merge: {},
            "merge-action": {},
            "merge-key": {},
            "merge-source": {},
            message: {},
            mode: {},
            namespace: {},
            "namespace-alias": {},
            "next-iteration": {},
            "next-match": {},
            "non-matching-substring": {},
            number: {},
            "on-completion": {},
            "on-empty": {},
            "on-non-empty": {},
            otherwise: {},
            output: {},
            "output-character": {},
            override: {},
            "package": {},
            param: {},
            "perform-sort": {},
            "preserve-space": {},
            "processing-instruction": {},
            "result-document": {},
            sequence: {},
            sort: {},
            "source-document": {},
            "strip-space": {},
            stylesheet: {},
            template: {},
            text: {},
            transform: {},
            "try": {},
            "use-package": {},
            "value-of": {},
            variable: {},
            when: {},
            "where-populated": {},
            "with-param": {}
        },
        compiler: {}
    };
    // Input 2
    var pa = function() {
        var a;
        return {
            getPlatform: function() {
                return a
            },
            setPlatform: function(c) {
                a = c
            },
            hi: function(c, q, E, H, p) {
                return a.addMultipleDocs(c, q, E, H, p)
            },
            createDocument: function() {
                return a.createDocument()
            },
            oh: function() {
                return a.getDefaultDeliverMessage()
            },
            jd: function() {
                return a.inBrowser()
            },
            Zb: function(c) {
                return a.isHTMLElement(c)
            },
            $k: function(c, q) {
                return a.makeBuffer(c, q)
            },
            lj: function(c, q, E, H) {
                return a.makeHttpRequest(c, q, E, H)
            },
            parseXmlFromString: function(c, q, E) {
                return a.parseXmlFromString(c, q, E)
            },
            readFile: function(c, q) {
                return a.readFile(c, q)
            },
            rf: function(c) {
                return a.resource(c)
            },
            nl: function(c) {
                return a.resourcePromise(c)
            },
            Fb: function(c, q) {
                return a.resolveUri(c, q)
            },
            Ma: function(c) {
                return a.saxonPrint(c)
            },
            newURL: function(c, q) {
                return a.newURL(c, q)
            },
            fileURL: function(c) {
                return a.fileURL(c)
            },
            baseURL: function() {
                return a.baseURL()
            },
            tl: function() {
                return {
                    version: "3.0",
                    vendor: "Saxonica",
                    "vendor-url": "http://www.saxonica.com/",
                    "product-name": "SaxonJS",
                    "product-version": "2.6",
                    "is-schema-aware": "no",
                    "supports-serialization": "yes",
                    "supports-backwards-compatibility": "yes",
                    "supports-namespace-axis": "yes",
                    "supports-streaming": "no",
                    "supports-dynamic-evaluation": "yes",
                    "supports-higher-order-functions": "yes",
                    "xpath-version": "3.1",
                    "xsd-version": "1.1"
                }
            },
            Di: function() {
                return a.extraProperties
            },
            Uh: function(c) {
                return a.toUTF8(c)
            },
            Ok: function(c) {
                return a.fromUTF8(c)
            },
            Si: function() {
                return a.globalObject
            }
        }
    }();
    // Input 3
    function ra(a, c) {
        function q(E, H) {
            for (; E; ) {
                if (E[H])
                    return E[H];
                E = E.parentNode
            }
            return null
        }
        a.xsltLineNr = q(c, "line");
        a.xsltModule = q(c, "module")
    }
    class F extends Error {
        constructor(a="SaxonJS run-time error", c="FORG0001", q=null) {
            super();
            this.name = "XError";
            this.message = a;
            this.code = c;
            q && ra(this, q)
        }
        toString() {
            return this.name + ":" + this.message + "; code:" + this.code
        }
        getStackTrace() {
            return null.getStackTrace()
        }
        getMessage() {
            let a = "Error " + this.code;
            null != this.xsltLineNr && (a += " at " + this.xsltModule + "#" + this.xsltLineNr);
            return a += "\n  " + this.message
        }
        Id() {
            return this.code
        }
    }
    oa = F.prototype;
    oa.code = null;
    oa.errorObject = null;
    oa.xsltLineNr = null;
    oa.xsltModule = null;
    oa.Le = !1;
    // Input 4
    const sa = function() {
        function a(e) {
            H("Internal error: " + e + "\n" + Error().stack);
            throw new F("Internal error: " + e,"SXJS0004");
        }
        function c(e) {
            if (null === e)
                return "#null";
            if ("undefined" === typeof e)
                return "#undefined";
            let k;
            if (e.showValue)
                return e.showValue();
            if (e.N)
                return "expression " + e.N;
            if (p && p.X(e)) {
                if (p.re(e))
                    return "attribute @" + e.name + "='" + e.value + "'";
                if (p.Kd(e))
                    return "ns:" + e.prefix + "=" + e.uri;
                k = {
                    1: "element <" + e.tagName + ">",
                    2: "attribute @" + e.name,
                    3: "text:" + (e.nodeValue ? e.nodeValue.substring(0, 8) : "''"),
                    7: "pi: " + e.target + "(" + e.tagName + ")",
                    8: "comment (" + e.nodeValue + ")",
                    9: "document " + (e._saxonDocumentNumber ? "#" + e._saxonDocumentNumber : "(No nr / #0)"),
                    11: "docFrag"
                }[e.nodeType];
                if ("9" === e.nodeType || "11" === e.nodeType) {
                    var v;
                    for (v = 0; v < e.childNodes.length; v++)
                        k += "~>" + c(e.childNodes[v])
                }
                return k
            }
            if (e.code)
                return "atomic:" + e.code + "('" + e.toString() + "')";
            if ("object" === typeof e && "length"in e) {
                if (1 === e.length)
                    return c(e[0]);
                k = "(";
                for (v = 0; v < e.length && 3 > v; v++)
                    0 !== v && (k += ","),
                    k += c(e[v]);
                4 <= e.length && (k += ",...(" + e.length + ")");
                return k + ")"
            }
            return "function" === typeof e ? e.toString() : "(" + typeof e + ") " + e
        }
        function q(e) {
            return "{'N':'" + e.N + "','C':[" + (e.C || []).map(k=>q(k)).join(",") + "]}"
        }
        function E(e, k) {
            for (; e; ) {
                if (e[k])
                    return e[k];
                e = e.parentNode
            }
            return null
        }
        function H(e, k=1, v) {
            let t = g;
            v && (t = v);
            k <= t && pa.getPlatform().saxonPrint(e)
        }
        let p, g = 1;
        Error.stackTraceLimit = 100;
        return {
            assert: function(e, k="assertion failed") {
                e || a(k)
            },
            la: a,
            location: function(e) {
                return E(e, "module") + "#" + E(e, "line")
            },
            zj: function(e) {
                p = e
            },
            Ma: H,
            showValue: c,
            Nh: function(e) {
                return e.showValue ? e.showValue() : p && p.X(e) ? c(e) : e.code ? "atomic:" + e.code + "('" + e.toString() + "')" : e.Li ? e.toString() : "(" + typeof e + ") " + e
            },
            Ij: function(e) {
                if (!e)
                    return "null expr";
                let k = e.N || "?";
                for (let v in e)
                    e.hasOwnProperty(v) && !["C", "N", "parentNode", "ELAB", "PUSH"].includes(v) && (k += " " + v + "=" + e[v]);
                e.C && (k += " (" + e.C.map(v=>v.N).join(",") + ")");
                return k += " at " + this.location(e)
            },
            rl: q,
            getLogLevel: function() {
                return g
            },
            setLogLevel: function(e) {
                "number" == typeof e && (g = e)
            }
        }
    }();
    // Input 5
    var wa = function() {
        function a() {
            function g(e) {
                if (!(this instanceof g))
                    return void 0 === e ? a() : new g(e);
                if (e instanceof g)
                    this.ma = e.ma,
                    this.e = e.e,
                    this.c = e.c.slice();
                else {
                    var k, v, t;
                    0 === e && 0 > 1 / e ? e = "-0" : p.test(e = "" + e) || E(NaN);
                    this.ma = "-" == e.charAt(0) ? (e = e.slice(1),
                    -1) : 1;
                    -1 < (k = e.indexOf(".")) && (e = e.replace(".", ""));
                    0 < (v = e.search(/e/i)) ? (0 > k && (k = v),
                    k += +e.slice(v + 1),
                    e = e.substring(0, v)) : 0 > k && (k = e.length);
                    for (v = 0; "0" == e.charAt(v); v++)
                        ;
                    if (v == (t = e.length))
                        this.c = [this.e = 0];
                    else {
                        for (; "0" == e.charAt(--t); )
                            ;
                        this.e = k - v - 1;
                        this.c = [];
                        for (k = 0; v <= t; this.c[k++] = +e.charAt(v++))
                            ;
                    }
                }
                this.constructor = g
            }
            g.prototype = H;
            g.Zd = 20;
            g.Ne = 1;
            g.$d = -7;
            g.Je = 21;
            return g
        }
        function c(g, e, k) {
            var v = g.constructor
              , t = e - (g = new v(g)).e
              , C = g.c;
            C.length > ++e && q(g, t, v.Ne);
            C[0] ? k ? t = e : (C = g.c,
            t = g.e + t + 1) : ++t;
            for (; C.length < t; C.push(0))
                ;
            t = g.e;
            return 1 === k || k && (e <= t || t <= v.$d) ? (0 > g.ma && C[0] ? "-" : "") + (1 < C.length ? C[0] + "." + C.join("").slice(1) : C[0]) + (0 > t ? "e" : "e+") + t : g.toString()
        }
        function q(g, e, k, v=!1) {
            var t = g.c
              , C = g.e + e + 1;
            1 === k ? v = 5 <= t[C] : 2 === k ? v = 5 < t[C] || 5 == t[C] && (v || 0 > C || void 0 !== t[C + 1] || t[C - 1] & 1) : 3 === k ? v = v || void 0 !== t[C] || 0 > C : (v = !1,
            0 !== k && E("!Big.RM!"));
            if (1 > C || !t[0])
                v ? (g.e = -e,
                g.c = [1]) : g.c = [g.e = 0];
            else {
                t.length = C--;
                if (v)
                    for (; 9 < ++t[C]; )
                        t[C] = 0,
                        C-- || (++g.e,
                        t.unshift(1));
                for (C = t.length; !t[--C]; t.pop())
                    ;
            }
            return g
        }
        function E(g) {
            g = Error(g);
            g.name = "BigError";
            throw g;
        }
        var H = {}
          , p = /^-?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i;
        H.abs = function() {
            var g = new this.constructor(this);
            g.ma = 1;
            return g
        }
        ;
        H.cmp = function(g) {
            var e = this.c
              , k = (g = new this.constructor(g)).c
              , v = this.ma
              , t = g.ma
              , C = this.e
              , m = g.e;
            if (!e[0] || !k[0])
                return e[0] ? v : k[0] ? -t : 0;
            if (v != t)
                return v;
            g = 0 > v;
            if (C != m)
                return C > m ^ g ? 1 : -1;
            v = -1;
            for (t = (C = e.length) < (m = k.length) ? C : m; ++v < t; )
                if (e[v] != k[v])
                    return e[v] > k[v] ^ g ? 1 : -1;
            return C == m ? 0 : C > m ^ g ? 1 : -1
        }
        ;
        H.Vb = function(g, e, k) {
            var v = this.constructor
              , t = this.c
              , C = (g = new v(g)).c
              , m = this.ma === g.ma ? 1 : -1;
            e = "undefined" !== typeof e ? e : v.Zd;
            k = "undefined" !== typeof k ? k : v.Ne;
            (e !== ~~e || 0 > e || 1E6 < e) && E("!Big.DP!");
            if (!t[0] || !C[0])
                return t[0] == C[0] && E(NaN),
                C[0] || E(m / 0),
                new v(0 * m);
            var f, A = C.slice(), O = v = C.length, b = t.length, d = t.slice(0, v), l = d.length, r = g, n = r.c = [], B = 0, W = e + (r.e = this.e - g.e) + 1;
            r.ma = m;
            m = 0 > W ? 0 : W;
            for (A.unshift(0); l++ < v; d.push(0))
                ;
            do {
                for (f = 0; 10 > f; f++) {
                    if (v != (l = d.length))
                        var ma = v > l ? 1 : -1;
                    else {
                        var qa = -1;
                        for (ma = 0; ++qa < v; )
                            if (C[qa] != d[qa]) {
                                ma = C[qa] > d[qa] ? 1 : -1;
                                break
                            }
                    }
                    if (0 > ma) {
                        for (g = l == v ? C : A; l; ) {
                            if (d[--l] < g[l]) {
                                for (qa = l; qa && !d[--qa]; d[qa] = 9)
                                    ;
                                --d[qa];
                                d[l] += 10
                            }
                            d[l] -= g[l]
                        }
                        for (; !d[0]; d.shift())
                            ;
                    } else
                        break
                }
                n[B++] = ma ? f : ++f;
                d[0] && ma ? d[l] = t[O] || 0 : d = [t[O]]
            } while ((O++ < b || void 0 !== d[0]) && m--);
            n[0] || 1 == B || (n.shift(),
            r.e--);
            B > W && q(r, e, k, void 0 !== d[0]);
            return r
        }
        ;
        H.xi = function() {
            var g = wa(0);
            return !this.cmp(g)
        }
        ;
        H.j = function(g) {
            return 0 < this.cmp(g)
        }
        ;
        H.B = function(g) {
            return -1 < this.cmp(g)
        }
        ;
        H.ij = function() {
            var g = wa(2).pow(52);
            return 0 > this.cmp(g)
        }
        ;
        H.I = function(g) {
            return 1 > this.cmp(g)
        }
        ;
        H.sub = H.we = function(g) {
            var e = this.constructor;
            var k = this.ma
              , v = (g = new e(g)).ma;
            if (k != v)
                return g.ma = -v,
                this.Be(g);
            var t = this.c.slice();
            var C = this.e;
            var m = g.c
              , f = g.e;
            if (!t[0] || !m[0])
                return m[0] ? (g.ma = -v,
                g) : new e(t[0] ? this : 0);
            if (k = C - f) {
                (e = 0 > k) ? (k = -k,
                C = t) : (f = C,
                C = m);
                C.reverse();
                for (v = k; v--; C.push(0))
                    ;
                C.reverse()
            } else
                for (C = ((e = t.length < m.length) ? t : m).length,
                k = v = 0; v < C; v++)
                    if (t[v] != m[v]) {
                        e = t[v] < m[v];
                        break
                    }
            e && (C = t,
            t = m,
            m = C,
            g.ma = -g.ma);
            if (0 < (v = (C = m.length) - (e = t.length)))
                for (; v--; t[e++] = 0)
                    ;
            for (v = e; C > k; ) {
                if (t[--C] < m[C]) {
                    for (e = C; e && !t[--e]; t[e] = 9)
                        ;
                    --t[e];
                    t[C] += 10
                }
                t[C] -= m[C]
            }
            for (; 0 === t[--v]; t.pop())
                ;
            for (; 0 === t[0]; )
                t.shift(),
                --f;
            t[0] || (g.ma = 1,
            t = [f = 0]);
            g.c = t;
            g.e = f;
            return g
        }
        ;
        H.mf = function(g) {
            var e = this
              , k = e.constructor
              , v = e.ma
              , t = (g = new k(g)).ma;
            g.c[0] || E(NaN);
            e.ma = g.ma = 1;
            var C = 1 == g.cmp(e);
            e.ma = v;
            g.ma = t;
            if (C)
                return new k(e);
            e = e.Vb(g, 0, 0);
            return this.we(e.zc(g))
        }
        ;
        H.add = H.Be = function(g) {
            var e = this.constructor;
            var k = this.ma
              , v = (g = new e(g)).ma;
            if (k != v)
                return g.ma = -v,
                this.we(g);
            v = this.e;
            var t = this.c
              , C = g.e
              , m = g.c;
            if (!t[0] || !m[0])
                return m[0] ? g : new e(t[0] ? this : 0 * k);
            t = t.slice();
            if (k = v - C) {
                0 < k ? (C = v,
                e = m) : (k = -k,
                e = t);
                for (e.reverse(); k--; e.push(0))
                    ;
                e.reverse()
            }
            0 > t.length - m.length && (e = m,
            m = t,
            t = e);
            k = m.length;
            for (v = 0; k; )
                v = (t[--k] = t[k] + m[k] + v) / 10 | 0,
                t[k] %= 10;
            v && (t.unshift(v),
            ++C);
            for (k = t.length; 0 === t[--k]; t.pop())
                ;
            g.c = t;
            g.e = C;
            return g
        }
        ;
        H.pow = function(g) {
            var e = this
              , k = new e.constructor(1)
              , v = k
              , t = 0 > g;
            (g !== ~~g || -1E6 > g || 1E6 < g) && E("!pow!");
            for (g = t ? -g : g; ; ) {
                g & 1 && (v = v.zc(e));
                g >>= 1;
                if (!g)
                    break;
                e = e.zc(e)
            }
            return t ? k.Vb(v) : v
        }
        ;
        H.round = function(g, e) {
            var k = this
              , v = k.constructor;
            null == g ? g = 0 : (g !== ~~g || 0 > g || 1E6 < g) && E("!round!");
            q(k = new v(k), g, null == e ? v.Ne : e);
            return k
        }
        ;
        H.sqrt = function() {
            var g = this.constructor;
            var e = this.c;
            var k = this.ma;
            var v = this.e;
            var t = new g("0.5");
            if (!e[0])
                return new g(this);
            0 > k && E(NaN);
            k = Math.sqrt(this.toString());
            0 === k || k === 1 / 0 ? (k = e.join(""),
            k.length + v & 1 || (k += "0"),
            e = new g(Math.sqrt(k).toString()),
            e.e = ((v + 1) / 2 | 0) - (0 > v || v & 1)) : e = new g(k.toString());
            k = e.e + (g.Zd += 4);
            do
                v = e,
                e = t.zc(v.Be(this.Vb(v)));
            while (v.c.slice(0, k).join("") !== e.c.slice(0, k).join(""));
            q(e, g.Zd -= 4, g.Ne);
            return e
        }
        ;
        H.K = H.zc = function(g) {
            var e = this.constructor;
            var k = this.c
              , v = (g = new e(g)).c
              , t = k.length
              , C = v.length
              , m = this.e
              , f = g.e;
            g.ma = this.ma == g.ma ? 1 : -1;
            if (!k[0] || !v[0])
                return new e(0 * g.ma);
            g.e = m + f;
            t < C && (e = k,
            k = v,
            v = e,
            f = t,
            t = C,
            C = f);
            for (e = Array(f = t + C); f--; e[f] = 0)
                ;
            for (m = C; m--; ) {
                C = 0;
                for (f = t + m; f > m; )
                    C = e[f] + v[m] * k[f - m - 1] + C,
                    e[f--] = C % 10,
                    C = C / 10 | 0;
                e[f] = (e[f] + C) % 10
            }
            C && ++g.e;
            e[0] || e.shift();
            for (m = e.length; !e[--m]; e.pop())
                ;
            g.c = e;
            return g
        }
        ;
        H.toString = H.valueOf = H.toJSON = function() {
            var g = this.constructor
              , e = this.e
              , k = this.c.join("")
              , v = k.length;
            if (e <= g.$d || e >= g.Je)
                k = k.charAt(0) + (1 < v ? "." + k.slice(1) : "") + (0 > e ? "e" : "e+") + e;
            else if (0 > e) {
                for (; ++e; k = "0" + k)
                    ;
                k = "0." + k
            } else if (0 < e)
                if (++e > v)
                    for (e -= v; e--; k += "0")
                        ;
                else
                    e < v && (k = k.slice(0, e) + "." + k.slice(e));
            else
                1 < v && (k = k.charAt(0) + "." + k.slice(1));
            return 0 > this.ma && this.c[0] ? "-" + k : k
        }
        ;
        H.g = function(g) {
            null == g ? g = this.c.length - 1 : (g !== ~~g || 0 > g || 1E6 < g) && E("!toExp!");
            return c(this, g, 1)
        }
        ;
        H.toFixed = function(g) {
            var e = this.constructor
              , k = e.$d
              , v = e.Je;
            e.$d = -(e.Je = 1 / 0);
            if (null == g)
                var t = this.toString();
            else
                g === ~~g && 0 <= g && 1E6 >= g && (t = c(this, this.e + g),
                0 > this.ma && this.c[0] && 0 > t.indexOf("-") && (t = "-" + t));
            e.$d = k;
            e.Je = v;
            t || E("!toFix!");
            return t
        }
        ;
        H.toPrecision = function(g) {
            if (null == g)
                return this.toString();
            (g !== ~~g || 1 > g || 1E6 < g) && E("!toPre!");
            return c(this, g - 1, 2)
        }
        ;
        return a()
    }();
    // Input 6
    function xa(a) {
        return a.replace(/[ \n\r\t]+/g, " ").replace(/^[ ]|[ ]$/g, "")
    }
    function ya(a) {
        if (32 > a && ![9, 10, 13].includes(a) || 55295 < a && 57344 > a || 65533 < a && 65536 > a || 1114111 < a)
            throw new F("Invalid XML character 0x" + a.toString(16),"FOCH0001");
        return a
    }
    function za(a, c) {
        if (Aa(a) || Aa(c)) {
            a: {
                a = Da(a.toString());
                c = Da(c.toString());
                let q = 0;
                for (; ; ) {
                    if (q === a.length) {
                        a = q === c.length ? 0 : -1;
                        break a
                    }
                    if (q === c.length) {
                        a = 1;
                        break a
                    }
                    if (a[q] !== c[q]) {
                        a = a[q] - c[q];
                        break a
                    }
                    q++
                }
            }
            return 0 > a ? -1 : 0 === a ? 0 : 1
        }
        return a < c ? -1 : a === c ? 0 : 1
    }
    function Aa(a) {
        return Array.from(a).some(c=>65535 < c.codePointAt(0))
    }
    function Da(a) {
        return Array.from(a).map(c=>c.codePointAt(0))
    }
    function Ea(a) {
        return String.fromCodePoint(...a.map(ya))
    }
    class Ga {
    }
    ;// Input 7
    var Ha = function() {
        function a() {
            null === q && (q = pa.rf("regexCategories"));
            return q
        }
        function c(g, e, k=null, v=null) {
            function t(z, D) {
                function y(V) {
                    for (V = V.toString(16); 4 > V.length; )
                        V = "0" + V;
                    return "\\u" + (E && 4 < V.length ? "{" + V + "}" : V)
                }
                function I(V, la, x) {
                    if (x) {
                        x = V;
                        V = [];
                        0 !== x[0][0] && V.push([0, x[0][0] - 1]);
                        for (var K = 1; K < x.length; K++) {
                            const U = x[K - 1][1] + 1
                              , ha = x[K][0] - 1;
                            ha >= U && V.push([U, ha])
                        }
                        x = x[x.length - 1][1];
                        (E || 65535 > x) && V.push([x + 1, E ? 1114111 : 65535])
                    }
                    x = "";
                    for (K = 0; K < V.length; K++)
                        if (E || 65536 > V[K][1])
                            x += y(V[K][0]),
                            V[K][1] > V[K][0] && (x += "-" + y(V[K][1]));
                    V = x;
                    la || (V = "[" + V + "]");
                    return V
                }
                function R(V) {
                    return V.sort(function(la, x) {
                        return la[0] - x[0]
                    })
                }
                function M(V, la, x, K) {
                    var U = [];
                    Array.isArray(V) || m("Ranges must be array");
                    V.forEach(function(ha) {
                        U.push([parseInt(ha[0], 16), parseInt(ha[1], 16)])
                    });
                    x && K && R(U);
                    return I(U, la, x)
                }
                var ca = z.charAt(D + 1);
                0 > "nrt\\|.-^?*+{}()[]pPsSiIcCdDwW$".indexOf(ca) && (0 !== n || !/[0-9]/.test(ca)) && m("\\" + ca + " is not allowed in XPath regular expressions");
                switch (ca) {
                case "p":
                case "P":
                    var ea = z.indexOf("}", D);
                    z = z.substring(D + 3, ea);
                    C("x") && (z = z.replace(/[ \n\r\t]+/g, ""));
                    var ja = a();
                    (D = ja[z]) || m("Unknown category " + z);
                    if (1 === z.length) {
                        var Y = [];
                        D.split("|").forEach(function(x) {
                            Y = Y.concat(ja[x])
                        })
                    } else
                        Y = D;
                    A += M(Y, 0 < n, "P" === ca, 1 === z.length);
                    D = ea;
                    break;
                case "d":
                    A += M(a().Nd, 0 < n, !1, !1);
                    D++;
                    break;
                case "i":
                    A += I(O, 0 < n, !1);
                    D++;
                    break;
                case "c":
                    A += I(b, 0 < n, !1);
                    D++;
                    break;
                case "I":
                    A += I(O, 0 < n, !0);
                    D++;
                    break;
                case "C":
                    A += I(b, 0 < n, !0);
                    D++;
                    break;
                case "w":
                case "W":
                    const V = a();
                    let la = [];
                    V.w.split("|").forEach(function(x) {
                        la = la.concat(V[x])
                    });
                    A += M(la, 0 < n, "W" === ca, !0);
                    D++;
                    break;
                case "-":
                    0 < n && (A += "\\");
                    A += ca;
                    D++;
                    break;
                default:
                    /[0-9]/.test(ca) ? 0 < n ? m("Numeric escape within charclass") : (l[parseInt(ca, 10)] || m("No capturing expression #" + ca),
                    A += "\\" + ca,
                    9 >= r && /[0-9]/.test(z.charAt(D + 2)) && (A += "(?:)"),
                    D++) : (A += "\\" + ca,
                    D++)
                }
                return {
                    vj: A,
                    i: D
                }
            }
            function C(z) {
                return 0 <= e.indexOf(z)
            }
            function m(z) {
                throw new F("Invalid XPath regular expression: " + z,"FORX0002");
            }
            let f = 0;
            e = e ? e.toString() : "";
            if (!E && k && Aa(k))
                throw new F("Cannot handle non-BMP characters with regular expressions in this browser","SXJS0002");
            k = (C("i") ? "i" : "") + (C("m") ? "m" : "") + (C("g") ? "g" : "") + (E ? "u" : "");
            if (C("j"))
                return new RegExp(g,e.replace("j", ""));
            if (C("q"))
                return new RegExp(g.replace(/[\[\]\/\{\}\(\)\*\+\?\.\\^$|]/g, "\\$&"),k);
            let A = "";
            const O = [[58, 58], [65, 90], [95, 95], [97, 122], [192, 214], [216, 246], [248, 767], [880, 893], [895, 8191], [8204, 8205], [8304, 8591], [11264, 12271], [12289, 55295], [63744, 64975], [65008, 65533], [65536, 983039]]
              , b = [[45, 46], [48, 58], [65, 90], [95, 95], [97, 122], [183, 183], [192, 214], [216, 246], [248, 893], [895, 8191], [8204, 8205], [8255, 8256], [8304, 8591], [11264, 12271], [12289, 55295], [63744, 64975], [65008, 65533], [65536, 983039]]
              , d = []
              , l = [];
            let r = 1
              , n = 0
              , B = !1;
            var W = !1;
            for (var ma = 0; ma < g.length; ma++) {
                const z = g.charAt(ma);
                switch (z) {
                case "[":
                    0 < n && m("Nested square brackets");
                    var qa = !1
                      , L = !1;
                    for (var aa = ma + 2; aa < g.length - 3; aa++) {
                        if (!qa && "-[" === g.substring(aa, aa + 2)) {
                            qa = g.substring(ma + 1, aa);
                            let D;
                            for (L = aa + 2; L < g.length; L++)
                                if ("]" === g.charAt(L) && "\\" !== g.charAt(L - 1)) {
                                    D = g.substring(aa + 2, L + 1);
                                    break
                                }
                            "^" === qa && m("Invalid subtraction");
                            g = g.substring(0, ma) + "(?![" + D + ")[" + qa + "]" + g.substring(L + 2);
                            ma--;
                            L = !0;
                            break
                        } else if (!qa && "]" === g.charAt(aa))
                            break;
                        qa = "\\" === g.charAt(aa) && !qa
                    }
                    if (L) {
                        B = !0;
                        break
                    }
                    "]" === g.charAt(ma + 1) ? m("Character group is empty") : "[^]" === g.substring(ma, ma + 3) && m("Invalid character group [^]");
                    n++;
                    A += z;
                    break;
                case "]":
                    0 === n && m("Unmatched ']'");
                    n--;
                    A += z;
                    W = !0;
                    break;
                case "(":
                    0 === n && (aa = !0,
                    ma + 2 < g.length && "?" === g.charAt(ma + 1) && (":" === g.charAt(ma + 2) || B && "!" === g.charAt(ma + 2) ? aa = !1 : m("'(?' must be followed by ':'")),
                    d.push(aa ? r++ : -1),
                    W = !1,
                    aa && f++);
                    A += z;
                    break;
                case ")":
                    0 === n && (0 === d.length && m("Unmatched ')'"),
                    W = d.pop(),
                    0 < W && (l[W] = !0));
                    A += z;
                    W = !0;
                    break;
                case ".":
                    A = 0 === n && C("s") ? A + "[^]" : A + z;
                    break;
                case "{":
                    0 === n && (W || m("'{' not allowed here"),
                    W = g.indexOf("}", ma + 1),
                    (0 > W || !/^[0-9]+(,[0-9]*)?$/.test(g.substring(ma + 1, W))) && m("Invalid quantifier {" + g.substring(ma + 1, W + 1)),
                    W = !1);
                    A += z;
                    break;
                case " ":
                case "\n":
                case "\r":
                case "\t":
                    if (!C("x") || 0 < n)
                        A += z;
                    break;
                case "\\":
                    if (C("q"))
                        A += "\\\\";
                    else if (ma + 1 < g.length)
                        C("x") && /\s/.test(g.charAt(ma + 1)) && ma++,
                        ma = t(g, ma),
                        A = ma.vj,
                        ma = ma.i;
                    else
                        throw new F("No character for escape code in XPath regex","FORX0002");
                    W = !0;
                    break;
                default:
                    W = !0,
                    A += z
                }
            }
            0 < n && m("Unmatched '['");
            0 !== d.length && m("Unmatched '(");
            v && v(f);
            try {
                return new RegExp(A,k)
            } catch (z) {
                if (/^[imsxjqg]*$/.test(e))
                    throw new F("Invalid regular expression /" + g + "/: " + z.message.substring(/Invalid |Range out/.test(z.message) ? z.message.lastIndexOf(":") : 0),"FORX0002");
                throw new F("Invalid regex flags: " + e,"FORX0001");
            }
        }
        let q = null
          , E = !1;
        try {
            E = 1 === "\ud83d\ude80".match(new RegExp(/./,"gu")).length
        } catch (g) {
            E = !1
        }
        let H = null
          , p = null;
        return {
            Kf: function() {
                H = c("^\\i\\c*$", "");
                p = c("^\\c+$", "")
            },
            tj: a,
            Ce: c,
            si: function(g, e, k) {
                e = e.toString();
                if (/j/.test(e))
                    return g;
                if (/q/.test(e))
                    return g.replace(/\$/g, "$$$$");
                if (/(^|[^\\])\$([^0-9]|$)/.test(g) || /(^|[^\\])\\([^\\$]|$)/.test(g))
                    throw new F("Invalid replacement string: " + g,"FORX0004");
                var v = e = !1, t = "", C;
                for (C = 0; C < g.length; C++) {
                    var m = g.charAt(C);
                    switch (m) {
                    case "\\":
                        e && (t += m);
                        e = !e;
                        break;
                    case "$":
                        e ? (t += "$$",
                        e = !e) : v = !0;
                        break;
                    case "0":
                        v ? (t += "$&",
                        v = !1) : t += m;
                        break;
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                        v ? parseInt(m, 10) <= k && (t += "$" + m,
                        v = !1) : t += m;
                        break;
                    default:
                        t += m
                    }
                }
                return t
            },
            Lb: function(g) {
                return H.test(g) && !/:/.test(g)
            },
            dj: function(g) {
                return H.test(g)
            },
            cj: function(g) {
                return p.test(g)
            },
            uh: function(g) {
                return H.test(g) && /^[^:]+(:[^:]+)?$/.test(g)
            },
            trim: function(g) {
                return g.replace(/^[ \t\r\n]+|[ \t\r\n]+$/g, "")
            },
            collapse: function(g) {
                return this.trim(g).replace(/^[ \t\r\n]+/g, " ")
            },
            xg: function(g) {
                var e = g.indexOf(";");
                if (0 <= e) {
                    let k = g.substring(0, e);
                    e = g.substring(e + 1);
                    if (!k.match(/^[smixq]*$/))
                        throw new F("Illegal flags for regular expression: " + g,"FORX0001");
                    if (!e.match(/^[j]*$/))
                        throw new F("Illegal extension flags for regular expression: " + g,"FORX0001");
                    return k + e
                }
                if (!g.match(/^[smijxq]*$/))
                    throw new F("Illegal flags for regular expression: " + g,"FORX0001");
                return g
            }
        }
    }();
    // Input 8
    function Ia(a) {
        return /^A[SUZ]/.test(a.code)
    }
    class Ja {
        constructor(a) {
            sa.assert(this.g().test(a));
            this.code = a
        }
        g() {
            return /.*/
        }
        toString() {
            return ""
        }
        compareTo() {
            return null
        }
        equals() {
            return !0
        }
        hashCode() {
            return ""
        }
        matchKey() {
            return this.code + "_" + this.toString()
        }
        isNumeric() {
            return /^A[DFO]/.test(this.code)
        }
        showValue() {
            return La.pd(this.code) + "('" + this.toString() + "')"
        }
    }
    class Ma extends Ja {
        isNumeric() {
            return !0
        }
        toDouble() {
            return new Oa(this.toNumber())
        }
        toNumber() {
            return NaN
        }
        toBig() {
            return this.toDouble().toBig()
        }
    }
    class Ra extends Ja {
        constructor(a, c="AS") {
            super(c);
            this.value = a || "";
            "string" !== typeof a && sa.la("bad input to string constructor " + sa.showValue(a));
            this.j = 0
        }
        g() {
            return /^A(S|Z$|U$)/
        }
        toString() {
            return this.value
        }
        compareTo(a) {
            return a instanceof Ra ? za(this.value, a.value) : Sa(this.code, a.code)
        }
        equals(a) {
            return 0 === this.compareTo(a)
        }
        hashCode() {
            if (6 >= this.value.length)
                return this.value;
            let a = this.j;
            const c = this.value.length;
            if (0 === a && 0 < c) {
                for (let q = 0; q < c; q++)
                    a = 31 * a + this.value.charCodeAt(q++);
                this.j = a &= 16777215
            }
            return Ta(a)
        }
        matchKey() {
            return "s" + this.toString()
        }
    }
    function Va(a) {
        return a.reduce((c,q)=>c + q.toString(16).padStart(2, "0"), "").toUpperCase()
    }
    class Ya extends Ja {
        constructor(a, c="AX") {
            super(c);
            if (!(a instanceof Uint8Array))
                throw new F("Uint8Array expected");
            this.value = a
        }
        g() {
            return /^A[X2]$/
        }
        toString() {
            if ("AX" === this.code)
                var a = Va(this.value);
            else {
                {
                    a = this.value;
                    var c = 0;
                    let g = 0
                      , e = [];
                    if (0 === a.length)
                        a = "";
                    else {
                        do {
                            var q = a[c++];
                            var E = a[c++];
                            var H = a[c++];
                            var p = q << 16 | E << 8 | H;
                            q = p >> 18 & 63;
                            E = p >> 12 & 63;
                            H = p >> 6 & 63;
                            p &= 63;
                            e[g++] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(q) + "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(E) + "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(H) + "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(p)
                        } while (c < a.length);
                        c = e.join("");
                        a = a.length % 3;
                        a = (a ? c.slice(0, a - 3) : c) + "===".slice(a || 3)
                    }
                }
            }
            return a
        }
        compareTo(a) {
            return a instanceof Ya && this.code === a.code ? za(Va(this.value), Va(a.value)) : Sa(this.code, a.code)
        }
        equals(a) {
            if (a instanceof Ya && this.code === a.code) {
                const c = a.value;
                return this.value.length === c.length && this.value.every((q,E)=>q === c[E])
            }
            return Sa(this.code, a.code)
        }
        hashCode() {
            return (new Ra(Va(this.value.slice(0, 8)))).hashCode()
        }
        matchKey() {
            return ("AX" === this.code ? "h" : "i") + this.toString()
        }
    }
    class Oa extends Ma {
        constructor(a, c="AO") {
            super(c);
            this.value = a;
            "number" !== typeof a && sa.la("type of value supplied to XdmDouble is not number: " + typeof a)
        }
        g() {
            return /^A[OF]$/
        }
        toString() {
            if (0 === this.value)
                return 0 > 1 / this.value ? "-0" : "0";
            if (this.value === Number.POSITIVE_INFINITY)
                return "INF";
            if (this.value === Number.NEGATIVE_INFINITY)
                return "-INF";
            var a = this.value
              , c = Math.abs(a);
            if (1E6 <= c || 1E-6 > c) {
                c = a.toExponential();
                const q = c.indexOf("e");
                a = c.substring(0, q);
                c = c.substring(q + 1);
                "AF" === this.code && (a = parseFloat(a),
                a = (0 > a ? a - 5E-8 : a + 5E-8).toString(),
                a = a.substring(0, a.indexOf(".") + 8),
                a = a.replace(/\.?0+$/, ""));
                a.includes(".") || (a += ".0");
                return a + "E" + c.replace("+", "")
            }
            return "AF" === this.code && 0 !== a % 1 ? (c = (0 > a ? a - 5E-8 : a + 5E-8).toString(),
            c = c.substring(0, c.indexOf(".") + 6),
            c.replace(/0+$/, "")) : a.toString()
        }
        equals(a) {
            return 0 === this.compareTo(a)
        }
        compareTo(a) {
            return a.isNumeric() ? (a = a.toNumber(),
            "AF" === this.code && Math.fround && (a = Math.fround(a)),
            this.value < a ? -1 : this.value === a ? 0 : 1) : Sa(this.code, a.code)
        }
        qg(a) {
            return a instanceof Oa || a instanceof Za ? this.value === a.value || isNaN(this.value) && isNaN(a.value) : a instanceof $a ? La.XS.mb.R(this).equals(a) : !1
        }
        hashCode() {
            return isNaN(this.value) ? "NaN" : isFinite(this.value) ? Ta(this.value) : 0 > this.value ? "-INF" : "INF"
        }
        matchKey() {
            return "n" + this.hashCode()
        }
        toNumber() {
            return this.value
        }
        toDouble() {
            return this
        }
        abs() {
            return new Oa(Math.abs(this.value),this.code)
        }
        nf() {
            return new Oa(-this.value,this.code)
        }
        Rf() {
            return new Oa(Math.ceil(this.value),this.code)
        }
        floor() {
            return new Oa(Math.floor(this.value),this.code)
        }
        round(a) {
            0 === a ? a = Math.round(this.value) : (a = Math.pow(10, -a),
            a *= Math.round(this.value / a));
            return new Oa(a,this.code)
        }
        sf(a) {
            return isFinite(this.value) ? (a = (new $a(wa(this.value))).sf(a),
            0 === a.toNumber() && 0 > this.value && (a = La.XS.double.fromString("-0")),
            La.codes[this.code].R(a)) : this
        }
    }
    class Za extends Ma {
        constructor(a) {
            super("ADI");
            "number" !== typeof a && sa.la("type of value supplied to XdmInteger is not number: " + typeof a);
            this.value = a
        }
        g() {
            return /^ADI/
        }
        toString() {
            return this.value.toString()
        }
        equals(a) {
            return 0 === this.compareTo(a)
        }
        compareTo(a) {
            return a.isNumeric() ? this.value - a.toNumber() : Sa(this.code, a.code)
        }
        hashCode() {
            return Ta(this.value)
        }
        qg(a) {
            return a instanceof Oa || a instanceof Za ? this.value === a.value : a instanceof $a ? La.XS.mb.R(this).equals(a) : !1
        }
        matchKey() {
            return "n" + this.hashCode()
        }
        toDouble() {
            return new Oa(this.value)
        }
        toNumber() {
            return this.value
        }
        toBig() {
            return new wa(this.value)
        }
        abs() {
            return new Za(Math.abs(this.value))
        }
        nf() {
            return new Za(-this.value)
        }
        Rf() {
            return this
        }
        floor() {
            return this
        }
        round(a) {
            return 0 > a ? (a = Math.pow(10, -a),
            new Za(Math.round(this.value / a) * a)) : this
        }
        sf(a) {
            return 0 > a ? (a = Math.pow(10, -a),
            new Za(parseInt(wa(this.value).Vb(a, 100, 2).round(0, 2).zc(a), 10))) : this
        }
    }
    class $a extends Ma {
        constructor(a, c="AD") {
            super(c);
            this.value = new wa(a)
        }
        g() {
            return /^AD/
        }
        toString() {
            return this.value.toFixed()
        }
        equals(a) {
            return 0 === this.compareTo(a)
        }
        compareTo(a) {
            return a instanceof $a ? this.value.cmp(a.value) : /^AD/.test(a.code) ? this.value.cmp(a.toBig()) : a.isNumeric() ? this.value.cmp(new wa(a.toDouble())) : Sa(this.code, a.code)
        }
        hashCode() {
            const a = this.value;
            return a.mf(wa(1)).xi() && a.abs().ij() ? this.toNumber().toString(36) : this.toString().substring(0, 8)
        }
        qg(a) {
            return a instanceof Oa || a instanceof Za ? 0 === this.compareTo(La.XS.mb.R(a)) : a instanceof $a ? 0 === this.compareTo(a) : !1
        }
        matchKey() {
            return "n" + this.hashCode()
        }
        toBig() {
            return this.value
        }
        toDouble() {
            return new Oa(parseFloat(this.value.toFixed()))
        }
        toNumber() {
            return parseFloat(this.value.toFixed())
        }
        abs() {
            return new $a(this.value.abs(),this.code)
        }
        nf() {
            var a = wa(this.value);
            a.ma = -a.ma;
            return new $a(a,"AD" === this.code ? "AD" : "ADI")
        }
        Rf() {
            return new $a(this.value.round(0, 0 > this.value.ma ? 0 : 3),this.code)
        }
        floor() {
            return new $a(this.value.round(0, 0 > this.value.ma ? 3 : 0),this.code)
        }
        round(a) {
            function c(p, g) {
                p = new wa(p);
                p.e += g;
                return p
            }
            let q = this.value
              , E = 0;
            0 > a && (E = a,
            a = 0,
            q = c(q, E));
            const H = 0 < q.ma ? wa(0) : this.floor().abs();
            q = q.Be(H).round(a, 1).we(H);
            0 !== E && (q = c(q, -E));
            return new $a(q,"AD" === this.code ? "AD" : "ADI")
        }
        sf(a) {
            0 > a ? (a = wa(10).pow(-a),
            a = this.value.Vb(a, 100, 2).round(0, 2).zc(a)) : a = this.value.round(a, 2);
            return new $a(a,"AD" === this.code ? "AD" : "ADI")
        }
    }
    class ab extends Ja {
        constructor(a) {
            super("AB");
            "boolean" !== typeof a && sa.la("type of value supplied to XdmBoolean is not boolean: " + typeof a);
            this.value = a
        }
        g() {
            return /^AB$/
        }
        toString() {
            return this.value.toString()
        }
        toBoolean() {
            return this.value
        }
        compareTo(a) {
            return a instanceof ab ? (this.value ? 1 : 0) - (a.value ? 1 : 0) : Sa(this.code, a.code)
        }
        equals(a) {
            return 0 === this.compareTo(a)
        }
        hashCode() {
            return this.value.toString()
        }
        matchKey() {
            return "b" + this.toString()
        }
    }
    class bb extends Ja {
        constructor(a, c, q) {
            super("AQ");
            this.prefix = a = a ? a : "";
            this.uri = c ? c : "";
            this.local = q;
            if ("" !== a && !Ha.Lb(a))
                throw new F("Invalid prefix: '" + a + "'","FORG0001");
            if (!Ha.Lb(q))
                throw new F("Invalid local name: '" + q + "' (prefix='" + a + "', uri='" + c + "')","FORG0001");
        }
        g() {
            return /^AQ$/
        }
        toEQName() {
            return "Q{" + this.uri + "}" + this.local
        }
        toString() {
            return (0 < this.prefix.length ? this.prefix + ":" : "") + this.local
        }
        equals(a) {
            a instanceof bb || Sa(this.code, a.code);
            return a instanceof bb && this.local === a.local && this.uri === a.uri
        }
        compareTo() {
            throw new F("QNames are not ordered","FORG0006");
        }
        hashCode() {
            return this.uri.substring(this.uri.length - 3) + ":" + (new Ra(this.local)).hashCode()
        }
        matchKey() {
            return "q" + this.toEQName()
        }
        getURI() {
            return this.uri
        }
        hasURI(a) {
            return this.uri === a
        }
        withPrefix(a) {
            return new bb(a,this.uri,this.local)
        }
    }
    function cb(a, c) {
        c = c.substr(0, c.length - 1);
        if (0 === a.Na.getUTCMilliseconds())
            c = c.replace(".000", "");
        else
            for (; "0" === c.charAt(c.length - 1); )
                c = c.substr(0, c.length - 1);
        c = c.replace(/^-0?0?/, "-");
        return c = c.replace(/^\+0?0?/, "")
    }
    function db(a) {
        if (a = a.Fa) {
            const c = Math.abs(a);
            return (0 > a ? "-" : "+") + (100 + Math.floor(c / 60)).toString().substring(1) + ":" + (100 + c % 60).toString().substring(1)
        }
        return 0 === a ? "Z" : ""
    }
    function eb(a, c) {
        if (c instanceof fb && (c.code.startsWith(a.code) || a.code.startsWith(c.code)))
            return +a.Na.getTime() - c.Na.getTime();
        Sa(a.code, c.code)
    }
    function gb(a, c) {
        return La.XS.dateTime.fromDate(new Date(a.Na.getTime() + 6E4 * c), a.Fa)
    }
    function hb(a, c) {
        let q = a.toString()
          , E = parseInt(q.substring(5, 7), 10)
          , H = parseInt(q.substring(8, 10), 10)
          , p = parseInt(q.substring(0, 4), 10) + Math.floor((E + c - 1) / 12)
          , g = 0 > p;
        c = (E + c - 1) % 12 + 1;
        for (0 >= c && (c += 12); !La.gj([p, c, H, 0, 0, 0]); )
            --H;
        return La.codes[a.code].fromString((g ? "-" + (1E4 + -p).toString().substring(1) : (1E4 + p).toString().substring(1)) + "-" + (100 + c).toString().substring(1) + "-" + (100 + H).toString().substring(1) + q.substring(10))
    }
    class fb extends Ja {
        constructor(a, c, q="AM") {
            super(q);
            this.Na = a;
            this.Fa = c;
            a instanceof Date || sa.la("type of UTCdate supplied to XdmDateTime is not Date");
            c && "number" !== typeof c && sa.la("type of value for timezone offset supplied to XdmDateTime is not number: " + typeof c)
        }
        g() {
            return /^A([AGHIJKMT]|MP)$/
        }
        proxy() {
            var a = new Date;
            return new Date(this.Na.getTime() + 6E4 * (this.Fa || 0 === this.Fa ? this.Fa : -a.getTimezoneOffset()))
        }
        toString() {
            const a = cb(this, this.proxy().toISOString())
              , c = "-" === a.charAt(0) ? 1 : 0;
            return function(q) {
                switch (q) {
                case "AM":
                case "AMP":
                    return a;
                case "AA":
                    return a.substring(0, 10 + c);
                case "AT":
                    return a.substring(11 + c);
                case "AH":
                    return a.substring(0, 7 + c);
                case "AG":
                    return a.substring(0, 4 + c);
                case "AJ":
                    return "-" + a.substring(4 + c, 10 + c);
                case "AI":
                    return "-" + a.substring(4 + c, 7 + c);
                case "AK":
                    return "--" + a.substring(7 + c, 10 + c);
                default:
                    throw "type not recognised " + q;
                }
            }(this.code) + db(this)
        }
        compareTo(a) {
            (/^A[GHIJK]/.test(this.code) || /^A[GHIJK]/.test(a.code)) && Sa(this.code, a.code);
            return eb(this, a)
        }
        equals(a) {
            return 0 === eb(this, a)
        }
        hashCode() {
            return Ta(this.Na.getTime() - 1454346732296)
        }
        matchKey() {
            return "t" + this.hashCode()
        }
    }
    function jb(a) {
        function c(E, H) {
            H.forEach(function(p) {
                1E3 !== p ? (q.push(Math.floor(E / p)),
                E %= p) : q.push(E / p)
            })
        }
        let q = [];
        c(Math.abs(a.Ua), [12, 1]);
        c(Math.abs(a.Qa), [864E5, 36E5, 6E4, 1E3]);
        return q
    }
    function kb(a) {
        a = a.Ua + a.Qa;
        return 0 > a ? -1 : 0 < a ? 1 : 0
    }
    class lb extends Ja {
        constructor(a, c, q="AR") {
            super(q);
            this.Ua = a;
            this.Qa = c;
            "number" === typeof a && "number" === typeof c || sa.la("type of value supplied to XdmDuration is not number: " + typeof a + ", " + typeof c);
            if (0 < a && 0 > c || 0 > a && 0 < c)
                throw new F("Months/seconds must both be negative or both positive","FORG0001");
        }
        g() {
            return /^AR[DY]?$/
        }
        toString() {
            let a, c = kb(this);
            0 === c ? a = "ARY" === this.code ? "P0M" : "PT0S" : (a = 0 > c ? "-P" : "P",
            jb(this).forEach(function(q, E) {
                3 === E && (a += "T");
                0 !== q && (6 === E ? a += q / 1E3 + "S" : a += q + "YMDHMS".split("")[E])
            }),
            a = a.replace(/T$/, ""));
            return a
        }
        compareTo(a) {
            if (a instanceof lb) {
                if (La.XS.yearMonthDuration.matches(this) && La.XS.yearMonthDuration.matches(a))
                    return this.Ua - a.Ua;
                if (La.XS.dayTimeDuration.matches(this) && La.XS.dayTimeDuration.matches(a))
                    return this.Qa - a.Qa;
                throw new F("Cannot compare durations that mix months and seconds","XPTY0004");
            }
            return Sa(this.code, a.code)
        }
        equals(a) {
            a instanceof lb || Sa(this.code, a.code);
            return a instanceof lb && this.Ua === a.Ua && this.Qa === a.Qa
        }
        hashCode() {
            return this.Ua.toString() + ":" + this.Qa.toString()
        }
        matchKey() {
            return "d" + this.hashCode()
        }
    }
    function Ta(a) {
        return Number.isInteger(a) && Math.abs(a) < Math.pow(2, 52) ? a.toString(36) : La.XS.mb.fromNumber(a).toString().substring(0, 8)
    }
    function Sa(a, c) {
        throw new F(`Cannot compare ${La.pd(a)} with ${La.pd(c)}`,"XPTY0004");
    }
    ;// Input 9
    var La = function() {
        function a() {
            function w(va, h, G, Q) {
                const u = la[G]
                  , N = V[va] = la[h] = {
                    name: va,
                    code: h,
                    lb: u,
                    matches: P=>P instanceof Ja && P.code.startsWith(h),
                    pc: function(P) {
                        Q(P) || g(P.toString(), h);
                        P.code = h;
                        return P
                    },
                    fromString: function(P) {
                        return N.pc(u.fromString(P))
                    },
                    R: function(P) {
                        return N.pc(u.R(P))
                    }
                }
            }
            function Z(va, h, G) {
                const Q = h.replace(/.$/, "");
                w(va, h, Q, G);
                const u = V[va]
                  , N = la[Q];
                u.fromString = function(P) {
                    /INF|NaN/.test(P) && g(P, h, null, "FOCA0002");
                    return u.pc(N.fromString(P))
                }
                ;
                u.fromNumber = function(P) {
                    P = N.fromNumber(P);
                    const ia = P.toNumber();
                    isFinite(ia) || g(P.toString(), h, null, "FOCA0002");
                    G(P) || g(P.toString(), h);
                    P.code = h;
                    return P
                }
            }
            function S(va, h, G, Q) {
                const u = h.replace(/.$/, "");
                w(va, h, u, G);
                const N = la[h]
                  , P = la[u];
                N.pc = function(ia) {
                    ia = Q(ia.toString());
                    G(ia) || g(ia, h);
                    return new Ra(ia,h)
                }
                ;
                N.fromString = function(ia) {
                    return N.pc(P.fromString(Q(ia)))
                }
            }
            function da(va, h, G) {
                w(va, h, "AR", G);
                const Q = V[va];
                Q.pc = function(u) {
                    if (u instanceof lb)
                        return new lb("ARY" === h ? u.Ua : 0,"ARD" === h ? u.Qa : 0,h);
                    G(u) || g(u.toString(), h);
                    u.code = h;
                    return u
                }
                ;
                Q.Wb = function(u, N) {
                    return Q.pc(ea.Wb(u, N))
                }
                ;
                Q.R = function(u) {
                    return ea.matches(u) ? Q.pc(u) : T.string.matches(u) || T.untypedAtomic.matches(u) ? b(u.toString(), h) : Q.pc(ea.R(u))
                }
            }
            function fa(va, h) {
                return function(G) {
                    G = G.toNumber();
                    return G >= va && G <= h
                }
            }
            for (var na in V) {
                const va = V[na];
                la[va.code] = va
            }
            t("gYear", "AG");
            t("gYearMonth", "AH");
            t("gMonth", "AI");
            t("gMonthDay", "AJ");
            t("gDay", "AK");
            Z("nonPositiveInteger", "ADIN", va=>0 >= va.toNumber());
            Z("negativeInteger", "ADINN", va=>0 > va.toNumber());
            Z("long", "ADIL", function(va) {
                va = va.toBig();
                return 0 <= va.cmp(wa("-9223372036854775808")) && 0 >= va.cmp(wa("9223372036854775807"))
            });
            Z("int", "ADILI", fa(-2147483648, 2147483647));
            Z("short", "ADILIS", fa(-32768, 32767));
            Z("byte", "ADILISB", fa(-128, 127));
            Z("nonNegativeInteger", "ADIP", va=>0 <= va.toNumber());
            Z("positiveInteger", "ADIPP", va=>0 < va.toNumber());
            Z("unsignedLong", "ADIPL", function(va) {
                return 0 <= va.toNumber() && 0 >= va.toBig().cmp(wa("18446744073709551615"))
            });
            Z("unsignedInt", "ADIPLI", function(va) {
                return 0 <= va.toNumber() && 0 >= va.toBig().cmp(wa("4294967295"))
            });
            Z("unsignedShort", "ADIPLIS", fa(0, 65535));
            Z("unsignedByte", "ADIPLISB", fa(0, 255));
            na = ()=>!0;
            S("normalizedString", "ASN", na, va=>va.replace(/[ \r\t\n]/g, " "));
            S("token", "ASNT", na, xa);
            S("language", "ASNTL", va=>/^[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*$/.test(va), xa);
            S("NMTOKEN", "ASNTK", Ha.cj, xa);
            S("Name", "ASNTN", Ha.dj, xa);
            S("NCName", "ASNTNC", Ha.Lb, xa);
            S("ID", "ASNTNCI", Ha.Lb, xa);
            S("IDREF", "ASNTNCR", Ha.Lb, xa);
            S("ENTITY", "ASNTNCE", Ha.Lb, xa);
            da("yearMonthDuration", "ARY", va=>0 === va.Qa);
            da("dayTimeDuration", "ARD", va=>0 === va.Ua);
            V.dayTimeDuration.hh = function(va) {
                return new lb(0,6E4 * va,"ARD")
            }
            ;
            T.language = V.language;
            T.Ag = V.NCName;
            T.dayTimeDuration = V.dayTimeDuration;
            T.yearMonthDuration = V.yearMonthDuration;
            T.nh = V.gYearMonth;
            T.mh = V.gYear;
            T.lh = V.gMonthDay;
            T.kh = V.gMonth;
            T.jh = V.gDay;
            a = function() {}
        }
        function c(w, Z) {
            return Z ? -w : w
        }
        function q(w, Z) {
            return Z * (void 0 === w ? 0 : Math.round(1E3 * parseFloat(w)))
        }
        function E(w, Z) {
            return Z * (void 0 === w ? 0 : parseInt(w, 10))
        }
        function H(w) {
            return w.lb && !["ADI", "ARY", "ARD"].includes(w.code) ? H(w.lb) : w
        }
        function p(w, Z) {
            throw new F(`Casting from ${d(w.code)} to ${d(Z)} is not allowed`,"XPTY0004");
        }
        function g(w, Z, S=null, da="FORG0001") {
            throw new F(`Supplied value "${w}" is not a valid ${d(Z)}${S ? ` (${S})` : ""}`,da);
        }
        function e(w, Z) {
            w = Ha.trim(w);
            /.\.$/.test(w) && (w += "0");
            if (/^[-+]?([0-9]+(\.[0-9]*)?|\.[0-9]+)([Ee][-+]?[0-9]+)?$/.test(w))
                return parseFloat(w);
            if (/^NaN$/.test(w))
                return NaN;
            if (/^-INF$/.test(w))
                return -Infinity;
            if (/^(\+)?INF$/.test(w))
                return Infinity;
            Z && g(w, "AO");
            return NaN
        }
        function k(w) {
            w = w.replace(/\s/g, "");
            /^(....)*$/.test(w) || g(w, "A2", "length must be a multiple of 4");
            /^[A-Za-z0-9+/]*=?=?$/.test(w) || g(w, "A2", "only [A-Za-z0-9+/] allowed, or '=' at the end");
            /^([^=]*|.*[AQgw]==|.*[AEIMQUYcgkosw048]=)$/.test(w) || g(w, "A2", "invalid characters before '='");
            let Z, S, da = 0, fa = [];
            if (0 === w.length)
                return new Uint8Array(0);
            do {
                var na = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(w.charAt(da++));
                var va = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(w.charAt(da++));
                Z = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(w.charAt(da++));
                S = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(w.charAt(da++));
                var h = na << 18 | va << 12 | Z << 6 | S;
                na = h >> 16 & 255;
                va = h >> 8 & 255;
                h &= 255;
                64 === Z ? fa.push(na) : 64 === S ? fa.push(na, va) : fa.push(na, va, h)
            } while (da < w.length);
            return new Uint8Array(fa)
        }
        function v(w) {
            w = Ha.trim(w);
            /^([a-fA-F0-9][a-fA-F0-9])*$/.test(w) || g(w, "AX");
            return (w = w.match(/../g)) ? new Uint8Array(w.map(Z=>parseInt(Z, 16))) : new Uint8Array(0)
        }
        function t(w, Z) {
            V[w] = la[Z] = {
                name: w,
                code: Z,
                matches: S=>S instanceof fb && S.code.startsWith(Z),
                fromString: S=>A(S, Z),
                fromDate: (S,da)=>new fb(S,da,Z),
                R: S=>{
                    if (S instanceof fb && S.code.startsWith(Z))
                        return S;
                    if (T.dateTime.matches(S) || T.cd.matches(S)) {
                        const da = la[Z];
                        return da.fromString(da.fromDate(S.Na, S.Fa).toString())
                    }
                    if (/^A[SZ]/.test(S.code))
                        return A(S.value, Z);
                    p(S, Z)
                }
            }
        }
        function C(w) {
            if (-1 !== w.indexOf(".", w.length - 4)) {
                w = w.split(".");
                let Z = w[1];
                for (; 3 > Z.length; )
                    Z += "0";
                w = w[0] + "." + Z
            }
            return w
        }
        function m(w) {
            const Z = w[0]
              , S = w[1]
              , da = w[2]
              , fa = w[3]
              , na = w[4];
            w = w[5];
            return !(1 > S || 12 < S || 1 > da || da > [31, 0 !== Z % 4 || 0 === Z % 100 && 0 !== Z % 400 ? 28 : 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][S - 1] || 24 <= fa || 60 <= na || 60 <= w)
        }
        function f(w, Z) {
            w = w.split(/[\-T:]/).map(function(da) {
                return parseFloat(da)
            });
            const S = w[0];
            if (-9999 > S || 9999 < S)
                throw new F("Year " + S + " is out of range","FODT0001");
            m(w) || g(Z, "AM")
        }
        function A(w, Z) {
            const S = w.match(x[Z]);
            null === S && g(w, Z);
            const da = S[2] ? S[2] : "";
            var fa = K[Z](S[1]) + da;
            /24:00:00(\.0+)?([Z+\-]|$)/.test(fa) && (fa = "AT" === Z ? fa.substring(0, 10) + "T00:00:00" : gb(A(fa.substring(0, 10), "AA"), 1440) + "T00:00:00");
            var na = "-" === fa.charAt(0);
            f(na ? fa.substring(1, 20) : fa.substring(0, 19), w);
            w = (na ? fa.substr(1) : fa).split(/[\-T:]/).map(function(va) {
                return parseFloat(va)
            });
            fa = w[5];
            na = na ? -w[0] : w[0];
            fa = new Date(Date.UTC(na, w[1] - 1, w[2], w[3], w[4], fa, Math.round(1E3 * (fa - Math.floor(fa)))));
            100 > w[0] && fa.setUTCFullYear(na);
            fa = "" === da ? new Date(fa.getTime() + 6E4 * (new Date).getTimezoneOffset()) : new Date(fa.getTime() - 6E4 * O(da));
            return new fb(fa,O(S[2] ? S[2] : ""),Z)
        }
        function O(w) {
            if ("" === w)
                return null;
            if ("Z" === w)
                return 0;
            var Z = w.split(":");
            const S = /^-.*/.test(Z[0])
              , da = Math.abs(parseInt(Z[0], 10));
            Z = parseInt(Z[1], 10);
            if (14 < da || 59 < Z)
                throw new F("Invalid timezone " + w,"FORG0001");
            return (S ? -1 : 1) * (60 * da + Z)
        }
        function b(w, Z) {
            const S = w.match(x[Z]);
            null !== S && /\d/.test(w) && !/T$/.test(w) || g(w, Z);
            return new lb(U[ha[Z][0]](S, w),U[ha[Z][1]](S, w),Z)
        }
        function d(w) {
            const Z = la[w];
            return Z ? "xs:" + Z.name : w
        }
        const l = {
            name: "anyAtomicType",
            code: "A",
            matches: function(w) {
                return w instanceof Ja
            }
        }
          , r = {
            name: "untypedAtomic",
            code: "AZ",
            fromString: function(w) {
                return new Ra(w,"AZ")
            },
            matches: function(w) {
                return "AZ" === w.code
            },
            R: function(w) {
                return new Ra(w.toString(),"AZ")
            }
        }
          , n = {
            name: "string",
            code: "AS",
            fromString: function(w) {
                return new Ra(w,"AS")
            },
            matches: function(w) {
                return /^AS/.test(w.code)
            },
            R: function(w) {
                return new Ra(w.toString(),"AS")
            }
        }
          , B = {
            name: "anyURI",
            code: "AU",
            fromString: function(w) {
                w = w.replace(/[ \r\t\n]+/g, " ").replace(/^[ ]|[ ]$/g, "");
                return new Ra(w,"AU")
            },
            matches: function(w) {
                return "AU" === w.code
            },
            R: function(w) {
                if (w instanceof Ra)
                    return T.anyURI.fromString(w.toString());
                p(w, "AU")
            }
        }
          , W = {
            name: "double",
            code: "AO",
            fromString: function(w) {
                return new Oa(e(w, !0))
            },
            cf: function(w) {
                return new Oa(e(w, !1))
            },
            fromNumber: function(w) {
                return new Oa(w)
            },
            matches: function(w) {
                return "AO" === w.code
            },
            R: function(w) {
                if (null === w || "undefined" == typeof w)
                    return T.double.fromNumber(NaN);
                if (T.string.matches(w) || T.untypedAtomic.matches(w))
                    return T.double.fromString(w.toString());
                if (w.isNumeric())
                    return T.double.fromNumber(w.toNumber());
                if (T.boolean.matches(w))
                    return T.double.fromNumber(w.toBoolean() ? 1 : 0);
                p(w, "AO")
            },
            NaN: null
        };
        W.NaN = W.fromNumber(NaN);
        const ma = {
            name: "decimal",
            code: "AD",
            fromString: function(w) {
                w = Ha.trim(w).replace(/^\+/, "");
                if (/^[-+]?([0-9]+(\.[0-9]*)?|\.[0-9]+)$/.test(w))
                    return new $a(new wa(w));
                g(w, "AD")
            },
            nb: function(w) {
                return new $a(w)
            },
            fromNumber: function(w) {
                isFinite(w) || g(w, "AD", null, "FOCA0002");
                return new $a(new wa(w))
            },
            matches: function(w) {
                return w instanceof $a || w instanceof Za
            },
            R: function(w) {
                switch (w.code.substring(0, 2)) {
                case "AD":
                    return new $a(w.value,"AD");
                case "AS":
                case "AZ":
                    return T.mb.fromString(w.toString());
                case "AO":
                case "AF":
                    return T.mb.fromNumber(w.toNumber());
                case "AB":
                    return T.mb.fromString(w.toBoolean() ? "1" : "0");
                default:
                    p(w, "AD")
                }
            }
        }
          , qa = {
            name: "float",
            code: "AF",
            fromString: function(w) {
                return T.float.fromNumber(e(w, !0))
            },
            fromNumber: function(w) {
                Math.fround && (w = Math.fround(w));
                return new Oa(w,"AF")
            },
            matches: function(w) {
                return "AF" === w.code
            },
            R: function(w) {
                return T.float.fromNumber(T.double.R(w).toNumber())
            }
        }
          , L = {
            name: "boolean",
            code: "AB",
            Xc: new ab(!0),
            ae: new ab(!1),
            fromString: function(w) {
                switch (Ha.trim(w)) {
                case "true":
                case "1":
                    return this.Xc;
                case "false":
                case "0":
                    return this.ae;
                default:
                    g(w, "AB")
                }
            },
            fromBoolean: function(w) {
                return w ? this.Xc : this.ae
            },
            matches: function(w) {
                return w instanceof ab
            },
            R: function(w) {
                switch (w.code.substring(0, 2)) {
                case "AS":
                case "AZ":
                    return T.boolean.fromString(w.toString());
                case "AD":
                case "AF":
                case "AO":
                    return w = w.toNumber(),
                    T.boolean.fromBoolean(0 !== w && !isNaN(w));
                case "AB":
                    return w;
                default:
                    p(w, "AB")
                }
            }
        }
          , aa = {
            name: "integer",
            code: "ADI",
            lb: "decimal",
            matches: function(w) {
                return /^ADI/.test(w.code)
            },
            fromString: function(w) {
                if (/^\s*[-+]?[0-9]+\s*$/.test(w))
                    return 9 < w.length ? new $a(w,"ADI") : new Za(parseInt(w, 10));
                g(w, "ADI")
            },
            fromNumber: function(w) {
                isFinite(w) || g(w, "ADI", null, "FOCA0002");
                w = Math.trunc(w);
                return Math.abs(w) > Number.MAX_SAFE_INTEGER ? new $a(new wa(w),"ADI") : new Za(w)
            },
            nb: function(w) {
                return new $a(w,"ADI")
            },
            valid: function(w) {
                return 0 === w.value.mf(1)
            },
            R: function(w) {
                switch (w.code.substring(0, 2)) {
                case "AS":
                case "AZ":
                    return T.integer.fromString(w.toString());
                case "AF":
                case "AO":
                    return T.integer.fromNumber(w.toNumber());
                case "AD":
                    return T.integer.nb(w.toBig().round(0, 0));
                case "AB":
                    return T.integer.fromNumber(w.toBoolean() ? 1 : 0);
                default:
                    p(w, "AB")
                }
            },
            Kk: function(w) {
                return "number" === typeof w ? T.integer.fromNumber(w) : "boolean" === typeof w ? T.integer.fromNumber(w ? 1 : 0) : "string" === typeof w ? T.integer.fromString(w) : T.integer.fromString(w.toString())
            }
        }
          , z = {
            name: "numeric",
            code: "Anumeric",
            cl: ["double", "decimal", "float"],
            matches: function(w) {
                return w instanceof Oa || w instanceof Za || w instanceof $a
            },
            R: function(w) {
                if (T.string.matches(w) || T.untypedAtomic.matches(w))
                    return T.double.fromString(w.toString());
                if (T.numeric.matches(w))
                    return w;
                if (T.boolean.matches(w))
                    return T.double.fromNumber(w.toBoolean() ? 1 : 0);
                p(w, "Anumeric")
            },
            xe: function(w) {
                const Z = T.double;
                if (null === w)
                    return Z.fromNumber(Number.NaN);
                if (T.boolean.matches(w))
                    return Z.fromNumber(w.toBoolean() ? 1 : 0);
                if (T.numeric.matches(w))
                    return Z.R(w);
                if (T.string.matches(w) || T.untypedAtomic.matches(w))
                    try {
                        return Z.fromString(w.toString())
                    } catch (S) {
                        return Z.fromNumber(Number.NaN)
                    }
                else
                    return Z.fromNumber(Number.NaN)
            }
        }
          , D = {
            name: "QName",
            code: "AQ",
            matches: function(w) {
                return w instanceof bb
            },
            fromParts: function(w, Z, S) {
                return new bb(w,Z,S)
            },
            fromString: function(w, Z) {
                w = Ha.trim(w);
                if ("Q{" === w.substring(0, 2))
                    return T.QName.fromEQName(w);
                Ha.uh(w) || g(w, "AQ");
                w = w.split(":");
                if (1 === w.length)
                    return T.QName.fromParts("", Z(""), w[0]);
                Z = Z(w[0]);
                if (null === Z)
                    throw new F("Undeclared prefix: " + w[0],"FONS0004");
                return T.QName.fromParts(w[0], Z, w[1])
            },
            fromEQName: function(w) {
                var Z = w.indexOf("{");
                const S = w.indexOf("}");
                if (!(-1 === Z && -1 === S || -1 < Z && -1 < S))
                    throw new F("Invalid EQName: " + w,"FORG0001");
                Z = xa(w.substring(Z + 1, S));
                if ("http://www.w3.org/2000/xmlns/" === Z)
                    throw new F("Use of reserved namespace: " + Z,"XQST0070");
                if (/{/.test(Z))
                    throw new F("Invalid URI: " + Z,"FORG0001");
                return T.QName.fromParts("", Z, w.substring(S + 1))
            },
            R: function(w, Z) {
                if (T.string.matches(w) || T.untypedAtomic.matches(w)) {
                    if (Z)
                        return T.QName.fromString(w.toString(), Z);
                    throw new F("Casting to QName requires a namespace resolver","XPTY0117");
                }
                if (T.QName.matches(w))
                    return w;
                p(w, "AQ")
            }
        }
          , y = {
            name: "notation",
            code: "AN",
            fromString: function(w) {
                return this.R(w)
            },
            matches: function() {
                return !1
            },
            R: function() {
                throw new F("Casting to xs:NOTATION is not possible","XPST0080");
            }
        }
          , I = {
            name: "dateTime",
            code: "AM",
            matches: function(w) {
                return /^AM/.test(w.code)
            },
            fromString: function(w) {
                return A(w, "AM")
            },
            fromDate: function(w, Z=null) {
                return new fb(w,Z,"AM")
            },
            R: function(w) {
                switch (w.code.substring(0, 2)) {
                case "AM":
                    return w;
                case "AA":
                    return T.dateTime.fromDate(w.Na, w.Fa);
                case "AS":
                case "AZ":
                    return T.dateTime.fromString(w.toString());
                default:
                    p(w, "AM")
                }
            }
        }
          , R = {
            name: "date",
            code: "AA",
            matches: function(w) {
                return "AA" === w.code
            },
            fromString: function(w) {
                return A(w, "AA")
            },
            fromDate: function(w, Z) {
                w = (new fb(w,Z,"AA")).toString();
                const S = "-" === w.charAt(0) ? 11 : 10;
                w = T.dateTime.fromString(w.substring(0, S) + "T00:00:00" + w.substring(S));
                return new fb(w.Na,Z,"AA")
            },
            R: function(w) {
                switch (w.code.substring(0, 2)) {
                case "AM":
                    return T.cd.fromDate(w.Na, w.Fa);
                case "AA":
                    return w;
                case "AS":
                case "AZ":
                    return T.cd.fromString(w.toString());
                default:
                    p(w, "AA")
                }
            }
        }
          , M = {
            name: "time",
            code: "AT",
            matches: function(w) {
                return "AT" === w.code
            },
            fromString: function(w) {
                return A(w, "AT")
            },
            fromDate: function(w, Z) {
                w = new fb(w,Z,"AT");
                w = T.dateTime.fromString("1972-01-01T" + w.toString());
                return new fb(w.Na,Z,"AT")
            },
            R: function(w) {
                switch (w.code.substring(0, 2)) {
                case "AM":
                    return T.time.fromDate(w.Na, w.Fa);
                case "AT":
                    return w;
                case "AS":
                case "AZ":
                    return T.time.fromString(w.toString());
                default:
                    p(w, "AT")
                }
            }
        }
          , ca = {
            name: "dateTimeStamp",
            code: "AMP",
            matches: function(w) {
                return "AMP" === w.code
            },
            fromString: function(w) {
                return A(w, "AMP")
            },
            fromDate: function(w, Z) {
                return new fb(w,Z,"AMP")
            },
            R: function(w) {
                switch (w.code.substring(0, 2)) {
                case "AM":
                    return "AMP" === w.code ? w : T.Ed.fromDate(w.Na, w.Fa);
                case "AA":
                    return T.Ed.fromDate(w.Na, w.Fa);
                case "AS":
                case "AZ":
                    return T.Ed.fromString(w.toString());
                default:
                    p(w, "AM")
                }
            }
        }
          , ea = {
            name: "duration",
            code: "AR",
            matches: function(w) {
                return /^AR/.test(w.code)
            },
            fromString: function(w) {
                return b(w, "AR")
            },
            Wb: function(w, Z) {
                return new lb(w,Z,"AR")
            },
            R: function(w) {
                if (T.duration.matches(w))
                    return w;
                if (T.string.matches(w) || T.untypedAtomic.matches(w))
                    return T.duration.fromString(w.toString());
                p(w, "AR")
            }
        }
          , ja = {
            name: "hexBinary",
            code: "AX",
            matches: function(w) {
                return "AX" === w.code
            },
            fromString: function(w) {
                return new Ya(v(w),"AX")
            },
            fromUint8Array: function(w) {
                return new Ya(w,"AX")
            },
            fromUtf8EncodedString: function(w) {
                return new Ya(pa.Uh(w),"AX")
            },
            R: function(w) {
                if (w instanceof Ya)
                    return new Ya(w.value,"AX");
                if (T.string.matches(w) || T.untypedAtomic.matches(w))
                    return new Ya(v(w.toString()),"AX");
                p(w, "AX")
            }
        }
          , Y = {
            name: "base64Binary",
            code: "A2",
            matches: function(w) {
                return "A2" === w.code
            },
            fromString: function(w) {
                return new Ya(k(w),"A2")
            },
            fromUint8Array: function(w) {
                return new Ya(w,"A2")
            },
            R: function(w) {
                if (w instanceof Ya)
                    return new Ya(w.value,"A2");
                if (T.string.matches(w) || T.untypedAtomic.matches(w))
                    return new Ya(k(w.toString()),"A2");
                p(w, "A2")
            },
            fromUtf8EncodedString: function(w) {
                return new Ya(pa.Uh(w),"A2")
            }
        }
          , V = {
            anyAtomicType: l,
            untypedAtomic: r,
            string: n,
            anyURI: B,
            "double": W,
            decimal: ma,
            "float": qa,
            "boolean": L,
            integer: aa,
            NOTATION: y,
            numeric: z,
            QName: D,
            dateTime: I,
            date: R,
            time: M,
            dateTimeStamp: ca,
            duration: ea,
            hexBinary: ja,
            base64Binary: Y
        }
          , la = {}
          , x = {
            AM: /^\s*(-?(?:[1-9][0-9]{4,}|[0-9]{4})-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(?:\.[0-9]+)?)(Z|([+\-])[0-9]{2}:[0-9]{2})?\s*$/,
            AA: /^\s*(-?(?:[1-9][0-9]{4,}|[0-9]{4})-[0-9]{2}-[0-9]{2})(Z|([+\-])[0-9]{2}:[0-9]{2})?\s*$/,
            AT: /^\s*([0-9]{2}:[0-9]{2}:[0-9]{2}(?:\.[0-9]+)?)(Z|([+\-])[0-9]{2}:[0-9]{2})?\s*$/,
            AMP: /^\s*(-?[0-9]+-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(?:\.[0-9]+)?)(Z|([+\-])[0-9]{2}:[0-9]{2})\s*$/,
            AH: /^\s*(-?(?:[1-9][0-9]{4,}|[0-9]{4})-[0-9]{2})(Z|([+\-])[0-9]{2}:[0-9]{2})?\s*$/,
            AG: /^\s*(-?[1-9][0-9]{4,}|-?[0-9]{4})(Z|([+\-])[0-9]{2}:[0-9]{2})?\s*$/,
            AJ: /^\s*--([0-9]{2}-[0-9]{2})(Z|([+\-])[0-9]{2}:[0-9]{2})?\s*$/,
            AI: /^\s*--([0-9]{2})(Z|([+\-])[0-9]{2}:[0-9]{2})?\s*$/,
            AK: /^\s*---([0-9]{2})(Z|([+\-])[0-9]{2}:[0-9]{2})?\s*$/,
            AR: /^\s*-?P(?:([0-9]+)Y)?(?:([0-9]+)M)?(?:([0-9]+)D)?(?:T(?:([0-9]+)H)?(?:([0-9]+)M)?(?:([0-9]+(?:\.[0-9]*)?)S)?)?\s*$/,
            ARD: /^\s*-?P(?:([0-9]+)D)?(?:T(?:([0-9]+)H)?(?:([0-9]+)M)?(?:([0-9]+(?:\.[0-9]*)?)S)?)?\s*$/,
            ARY: /^\s*-?P(?:([0-9]+)Y)?(?:([0-9]+)M)?\s*$/
        }
          , K = {
            AM: function(w) {
                return C(w)
            },
            AA: function(w) {
                return w + "T00:00:00"
            },
            AT: function(w) {
                return "1972-01-01T" + C(w)
            },
            AMP: function(w) {
                return C(w)
            },
            AH: function(w) {
                return w + "-01T00:00:00"
            },
            AG: function(w) {
                return w + "-01-01T00:00:00"
            },
            AJ: function(w) {
                return "1972-" + w + "T00:00:00"
            },
            AI: function(w) {
                return "1972-" + w + "-01T00:00:00"
            },
            AK: function(w) {
                return "1972-01-" + w + "T00:00:00"
            }
        }
          , U = [function(w, Z) {
            return c(E(w[1], 12) + E(w[2], 1), Z.match(/^\s*-.*/))
        }
        , function(w, Z) {
            return c(E(w[3], 864E5) + E(w[4], 36E5) + E(w[5], 6E4) + q(w[6], 1), Z.match(/^\s*-.*/))
        }
        , function(w, Z) {
            return c(E(w[1], 864E5) + E(w[2], 36E5) + E(w[3], 6E4) + q(w[4], 1), Z.match(/^\s*-.*/))
        }
        , function() {
            return 0
        }
        ]
          , ha = {
            AR: [0, 1],
            ARD: [3, 2],
            ARY: [0, 3]
        };
        let T = {
            Qf: l,
            anyURI: B,
            base64Binary: Y,
            boolean: L,
            cd: R,
            dateTime: I,
            Ed: ca,
            dayTimeDuration: null,
            mb: ma,
            double: W,
            duration: ea,
            float: qa,
            jh: null,
            kh: null,
            lh: null,
            mh: null,
            nh: null,
            hexBinary: ja,
            integer: aa,
            language: null,
            Ag: null,
            lk: y,
            numeric: z,
            QName: D,
            string: n,
            time: M,
            untypedAtomic: r,
            yearMonthDuration: null
        };
        return {
            Kf: a,
            pa: function(w) {
                return l.matches(w)
            },
            gj: m,
            yj: H,
            kg: function(w, Z, S, da) {
                if (w instanceof $a || Z instanceof $a)
                    return aa.nb(da(w.toBig(), Z.toBig()));
                S = S(w.toNumber(), Z.toNumber());
                return Math.abs(S) < Math.pow(2, 52) ? aa.fromNumber(S) : aa.nb(da(w.toBig(), Z.toBig()))
            },
            pd: d,
            pg: function(w, Z) {
                const S = La.codes[Z];
                if (S.matches(w))
                    return w;
                if (T.mb.matches(w) ? /^A[OFD]$/.test(Z) : T.float.matches(w) && /^A[OF]$/.test(Z))
                    return S.R(w);
                throw new F(`Incompatible operands: ${d(w.code)} (${w.toString()}) and ${d(Z)}`,"XPTY0004");
            },
            type: V,
            codes: la,
            XS: T
        }
    }();
    // Input 10
    const mb = function() {
        function a(m) {
            return Math.abs(m) < Math.pow(2, 52)
        }
        function c(m, f) {
            return v.matches(m) && v.matches(f) ? v : k
        }
        function q(m="FOAR0001") {
            throw new F("Division by zero",m);
        }
        function E(m="FOAR0002") {
            throw new F("Numeric overflow/underflow",m);
        }
        function H(m, f, A) {
            throw new F(`Arithmetic operation ${A} not available for` + ` operands ${La.pd(m.code)} and ${La.pd(f.code)}`,"XPTY0004");
        }
        function p(m, f, A) {
            function O(W) {
                return /^A[AMT]/.test(W.code)
            }
            let b, d, l;
            const r = g.untypedAtomic
              , n = g.dayTimeDuration
              , B = g.yearMonthDuration;
            if (r.matches(m))
                return m = g.double.fromString(m.value),
                p(m, f, A);
            if (r.matches(f))
                return f = g.double.fromString(f.value),
                p(m, f, A);
            (n.matches(m) || B.matches(m)) && g.numeric.matches(f) ? (l = "u" + A + "n",
            b = m.code,
            d = f.code) : (n.matches(f) || B.matches(f)) && g.numeric.matches(m) ? (l = "n" + A + "u",
            b = m.code,
            d = f.code) : v.matches(m) && v.matches(f) ? (l = "i" + A + "i",
            b = d = "ADI") : e.matches(m) || e.matches(f) ? (l = "d" + A + "d",
            b = d = "AO") : t.matches(m) || t.matches(f) ? (l = "f" + A + "f",
            b = d = "AF") : k.matches(m) || k.matches(f) ? (l = "c" + A + "c",
            b = d = "AD") : O(m) && O(f) ? (l = "t" + A + "t",
            b = m.code,
            d = f.code) : O(m) && (n.matches(f) || B.matches(f)) ? (l = "t" + A + "u",
            b = m.code,
            d = f.code) : (n.matches(m) || B.matches(m)) && O(f) ? (l = "u" + A + "t",
            b = m.code,
            d = f.code) : n.matches(m) && n.matches(f) || B.matches(m) && B.matches(f) ? (l = "u" + A + "u",
            b = d = m.code) : H(A, m, f);
            C[l] || H(A, m, f);
            return C[l](La.pg(m, b), La.pg(f, d))
        }
        const g = La.XS
          , e = g.double
          , k = g.mb
          , v = g.integer
          , t = g.float
          , C = {
            "d+d": function(m, f) {
                m = m.toNumber();
                f = f.toNumber();
                return e.fromNumber(m + f)
            },
            "d-d": function(m, f) {
                m = m.toNumber();
                f = f.toNumber();
                return e.fromNumber(m - f)
            },
            "d*d": function(m, f) {
                m = m.toNumber();
                f = f.toNumber();
                return e.fromNumber(m * f)
            },
            "d/d": function(m, f) {
                m = m.toNumber();
                f = f.toNumber();
                return e.fromNumber(m / f)
            },
            "d%d": function(m, f) {
                const A = m.toNumber();
                f = f.toNumber();
                return !isFinite(A) || isNaN(f) || 0 === f ? e.fromNumber(NaN) : isFinite(f) && 0 !== A ? e.fromNumber(A % f) : m
            },
            "d~d": function(m, f) {
                m = m.toNumber();
                f = f.toNumber();
                0 === f && q();
                (!isFinite(m) && isFinite(f) || isNaN(m) || isNaN(f)) && E();
                f = Math.trunc(m / f);
                isFinite(f) || E();
                return a(f) ? v.fromNumber(f) : e.fromNumber(f)
            },
            "f+f": function(m, f) {
                m = m.toNumber();
                f = f.toNumber();
                return t.fromNumber(m + f)
            },
            "f-f": function(m, f) {
                m = m.toNumber();
                f = f.toNumber();
                return t.fromNumber(m - f)
            },
            "f*f": function(m, f) {
                m = m.toNumber();
                f = f.toNumber();
                return t.fromNumber(m * f)
            },
            "f/f": function(m, f) {
                m = m.toNumber();
                f = f.toNumber();
                return t.fromNumber(m / f)
            },
            "f%f": function(m, f) {
                const A = m.toNumber();
                f = f.toNumber();
                if (!isFinite(A) || isNaN(f) || 0 === f)
                    return t.fromNumber(NaN);
                if (!isFinite(f) || 0 === A)
                    return m;
                m = A % f;
                isFinite(m) || q();
                return t.fromNumber(m)
            },
            "f~f": function(m, f) {
                m = m.toNumber();
                f = f.toNumber();
                0 === f && q();
                (!isFinite(m) && isFinite(f) || isNaN(m) || isNaN(f)) && E();
                f = Math.trunc(m / f);
                isFinite(f) || E();
                return a(f) ? v.fromNumber(f) : t.fromNumber(f)
            },
            "i+i": function(m, f) {
                return La.kg(m, f, (A,O)=>A + O, (A,O)=>A.Be(O))
            },
            "i-i": function(m, f) {
                return La.kg(m, f, (A,O)=>A - O, (A,O)=>A.we(O))
            },
            "i*i": function(m, f) {
                return La.kg(m, f, (A,O)=>A * O, (A,O)=>A.zc(O))
            },
            "i/i": function(m, f) {
                f.equals(La.XS.integer.fromNumber(0)) && q();
                m = m.toBig();
                f = f.toBig();
                return k.nb(m.Vb(f))
            },
            "i%i": function(m, f) {
                var A = m.toNumber();
                const O = f.toNumber();
                if (!isFinite(A) || isNaN(O) || 0 === O)
                    return 0 === O && q(),
                    v.fromNumber(NaN);
                if (!isFinite(O) || 0 === A)
                    return m;
                A = m.toNumber() % f.toNumber();
                isFinite(A) || q();
                return a(A) ? v.fromNumber(A) : v.nb(wa(m.toBig().mf(f.toBig())))
            },
            "i~i": function(m, f) {
                const A = m.toNumber() / f.toNumber();
                isFinite(A) || q();
                return a(A) ? v.fromNumber(Math.trunc(A)) : v.nb(wa(m.toBig().Vb(f.toBig())).round(0, 0))
            },
            "c+c": function(m, f) {
                const A = m.toBig()
                  , O = f.toBig();
                return c(m, f).nb(A.Be(O))
            },
            "c-c": function(m, f) {
                const A = m.toBig()
                  , O = f.toBig();
                return c(m, f).nb(A.we(O))
            },
            "c*c": function(m, f) {
                const A = m.toBig()
                  , O = f.toBig();
                return c(m, f).nb(A.zc(O))
            },
            "c/c": function(m, f) {
                try {
                    const A = m.toBig()
                      , O = f.toBig();
                    return k.nb(A.Vb(O))
                } catch (A) {
                    q()
                }
            },
            "c%c": function(m, f) {
                try {
                    const A = m.toBig()
                      , O = f.toBig();
                    return k.nb(A.mf(O))
                } catch (A) {
                    q()
                }
            },
            "c~c": function(m, f) {
                try {
                    const A = m.toBig()
                      , O = f.toBig()
                      , b = A.Vb(O).round(0, 0);
                    return v.nb(b)
                } catch (A) {
                    q()
                }
            },
            "a+a": function(m, f) {
                return p(m, f, "+")
            },
            "a-a": function(m, f) {
                return p(m, f, "-")
            },
            "a*a": function(m, f) {
                return p(m, f, "*")
            },
            "a/a": function(m, f) {
                return p(m, f, "/")
            },
            "a%a": function(m, f) {
                return p(m, f, "%")
            },
            "a~a": function(m, f) {
                return p(m, f, "~")
            },
            "u+u": function(m, f) {
                const A = g.dayTimeDuration
                  , O = g.yearMonthDuration;
                A.matches(m) && A.matches(f) || O.matches(m) && O.matches(f) || H(m, f, "+");
                return O.matches(m) ? O.Wb(m.Ua + f.Ua, 0) : A.Wb(0, m.Qa + f.Qa)
            },
            "u-u": function(m, f) {
                const A = g.dayTimeDuration
                  , O = g.yearMonthDuration;
                A.matches(m) && A.matches(f) || O.matches(m) && O.matches(f) || H(m, f, "-");
                return O.matches(m) ? O.Wb(m.Ua - f.Ua, 0) : A.Wb(0, m.Qa - f.Qa)
            },
            "u*n": function(m, f) {
                const A = g.dayTimeDuration
                  , O = g.yearMonthDuration;
                A.matches(m) || O.matches(m) || H(m, f, "*");
                f = f.toNumber();
                if (!isFinite(f))
                    throw new F("Cannot multiply duration by " + isNaN(f) ? "NaN" : "+/-INF",isNaN(f) ? "FOCA0005" : "FODT0002");
                return O.matches(m) ? O.Wb(Math.round(m.Ua * f), 0) : A.Wb(0, Math.round(m.Qa * f))
            },
            "n*u": function(m, f) {
                return mb["u*n"](f, m)
            },
            "u/n": function(m, f) {
                const A = g.dayTimeDuration
                  , O = g.yearMonthDuration;
                A.matches(m) || O.matches(m) || H(m, f, "/");
                f = f.toNumber();
                0 === f && q("FODT0002");
                if (isNaN(f))
                    throw new F("Cannot divide duration by NaN","FOCA0005");
                f = O.matches(m) ? m.Ua / f : m.Qa / f;
                isFinite(f) || E("FODT0002");
                return O.matches(m) ? O.Wb(Math.round(f), 0) : A.Wb(0, Math.round(f))
            },
            "u/u": function(m, f) {
                var A = g.dayTimeDuration;
                const O = g.yearMonthDuration;
                A.matches(m) && A.matches(f) || O.matches(m) && O.matches(f) || H(m, f, "/");
                A = new wa(0);
                m = new wa(O.matches(m) ? m.Ua : m.Qa);
                f = new wa(O.matches(f) ? f.Ua : f.Qa);
                0 === f.cmp(A) && q();
                try {
                    return k.nb(m.Vb(f))
                } catch (b) {
                    E()
                }
            },
            "t+u": function(m, f) {
                const A = g.dayTimeDuration
                  , O = g.yearMonthDuration;
                A.matches(f) || O.matches(f) || H(m, f, "+");
                return A.matches(f) ? La.codes[m.code].fromDate(new Date(m.Na.getTime() + f.Qa), m.Fa) : hb(m, f.Ua)
            },
            "u+t": function(m, f) {
                return mb["t+u"](f, m)
            },
            "t-u": function(m, f) {
                const A = g.dayTimeDuration
                  , O = g.yearMonthDuration;
                A.matches(f) || O.matches(f) || H(m, f, "-");
                return A.matches(f) ? La.codes[m.code].fromDate(new Date(m.Na.getTime() - f.Qa), m.Fa) : hb(m, -f.Ua)
            },
            "t-t": function(m, f) {
                return g.dayTimeDuration.Wb(0, m.Na.getTime() - f.Na.getTime())
            }
        };
        return C
    }();
    // Input 11
    function nb(a) {
        function c() {
            function p(C) {
                throw new F("In alphaCode '" + a + "' @ " + E + ": " + C);
            }
            function g(C) {
                const m = E >= a.length ? -1 : a.charAt(E++);
                m !== C && p("Expected '" + C + "', found '" + m + "'")
            }
            function e() {
                let C = 0
                  , m = E;
                for (; E < a.length; )
                    switch (a.charAt(E++)) {
                    case "{":
                        C++;
                        break;
                    case "}":
                        C--;
                        break;
                    case "]":
                    case ",":
                        if (0 === C)
                            return a.substring(m, --E);
                        break;
                    case " ":
                        if (0 === C)
                            return a.substring(m, E - 1)
                    }
                return a.substring(m, E)
            }
            "string" !== typeof a && sa.la("No input to alphaParser");
            const k = {};
            H.push(E);
            var v = a.charAt(E);
            /[01+?*]/.test(v) ? (E++,
            q.Td(k, "o", v)) : q.Td(k, "o", "1");
            if ((v = e()) && !/^[ANFE]/.test(v))
                throw sa.la("Invalid alphaCode '" + a + "'");
            for (q.Td(k, "p", v); E < a.length; )
                switch (v = a.charAt(E),
                v) {
                case "]":
                case ",":
                    return v = a.substring(H.pop(), E),
                    q.Td(k, "code", v),
                    k;
                case " ":
                    E++;
                    break;
                case "n":
                case "c":
                    E++;
                    var t = e();
                    /^~/.test(t) && (t = "Q{http://www.w3.org/2001/XMLSchema}" + t.substring(1));
                    q.Td(k, v, t);
                    break;
                case "k":
                case "r":
                case "v":
                case "e":
                    E++;
                    g("[");
                    t = c();
                    g("]");
                    q.Hj(k, v, t);
                    break;
                case "a":
                case "m":
                case "u":
                case "i":
                case "d":
                    E++;
                    g("[");
                    t = [];
                    if ("]" === a.charAt(E))
                        E++,
                        q.Mh(k, v, t);
                    else
                        for (; ; ) {
                            const C = c();
                            t.push(C);
                            if ("," === a.charAt(E))
                                E++;
                            else {
                                g("]");
                                q.Mh(k, v, t);
                                break
                            }
                        }
                    break;
                case "t":
                    p("Tuple types not yet implemented");
                    break;
                default:
                    p("Expected one of n|c|t|k|r|v|a|u, found '" + v + "'")
                }
            v = a.substring(H.pop(), E);
            q.Td(k, "code", v);
            H.pop();
            return k
        }
        var q = qb;
        let E = 0;
        const H = [];
        this.g = c
    }
    const qb = {
        al: function() {
            return {}
        },
        Td: function(a, c, q) {
            a[c] = q
        },
        Hj: function(a, c, q) {
            a[c] = q
        },
        Mh: function(a, c, q) {
            a[c] = q
        }
    };
    function rb(a) {
        return (new nb(a)).g()
    }
    function sb(a) {
        let c = (a.o || "1") + a.p;
        a.n && (c += " n" + a.n);
        a.c && (c += " c" + a.c);
        a.k && (c += " k[" + sb(a.k) + "]");
        a.v && (c += " v[" + sb(a.v) + "]");
        a.r && (c += " r[" + sb(a.r) + "]");
        if (a.a) {
            c += " a";
            for (var q = 0; q < a.a.length; q++)
                c += (0 === q ? "[" : ",") + sb(a.a[q]);
            c += "]"
        }
        if (a.m) {
            c += " m";
            for (q = 0; q < a.m.length; q++)
                c += (0 === q ? "[" : ",") + sb(a.m[q]);
            c += "]"
        }
        return c
    }
    function tb(a, c) {
        if (a.startsWith(c))
            return c;
        if (c.startsWith(a))
            return a;
        let q = Math.min(a.length, c.length);
        for (; 0 < q; ) {
            if (a.substring(0, q) === c.substring(0, q))
                return a.substring(0, q);
            q--
        }
        return ""
    }
    ;// Input 12
    const ub = La.XS;
    class vb {
        filter(a) {
            return new wb(this,a)
        }
        next() {
            sa.la("next()");
            return null
        }
        kf(a) {
            let c = 1, q;
            for (; null !== (q = this.next()); )
                if (c++ === a)
                    return q;
            return null
        }
        mapOneToOne(a) {
            return new xb(this,a)
        }
        mapOneToMany(a) {
            return new yb(this,a)
        }
        forEachItem(a) {
            let c;
            for (; null !== (c = this.next()); )
                a(c)
        }
        some(a) {
            let c;
            for (; null !== (c = this.next()); )
                if (a(c))
                    return !0;
            return !1
        }
        every(a) {
            let c;
            for (; null !== (c = this.next()); )
                if (!a(c))
                    return !1;
            return !0
        }
        count() {
            let a = 0;
            this.forEachItem(function() {
                a++
            });
            return a
        }
        expand() {
            const a = [];
            this.forEachItem(function(c) {
                a.push(c)
            });
            return a
        }
        showValue() {
            return "Iterator"
        }
    }
    class zb extends vb {
        constructor(a) {
            super();
            this.g = a
        }
        next() {
            const a = this.g;
            this.g = null;
            return a
        }
        kf(a) {
            return 1 === a ? this.g : null
        }
        ua() {
            return this.g
        }
        expand() {
            return null === this.g ? [] : [this.g]
        }
        showValue() {
            return "Singleton of " + sa.showValue(this.g)
        }
    }
    class Ab extends vb {
        next() {
            return null
        }
        ua() {
            return null
        }
        expand() {
            return []
        }
        count() {
            return 0
        }
        filter() {
            return this
        }
        kf() {
            return null
        }
        mapOneToOne() {
            return this
        }
        mapOneToMany() {
            return this
        }
        forEachItem() {}
        some() {
            return !1
        }
        every() {
            return !0
        }
        showValue() {
            return "EmptyIter"
        }
    }
    class Bb extends vb {
        constructor(a) {
            super();
            Array.isArray(a) || sa.la("ForArray expects array. Supplied value: " + sa.showValue(a));
            this.g = a;
            this.j = 0
        }
        next() {
            return this.j < this.g.length ? this.g[this.j++] : null
        }
        ua() {
            return this.j < this.g.length ? this.g[this.j] : null
        }
        expand() {
            return this.g
        }
        count() {
            return this.g.length
        }
        kf(a) {
            return this.g[a - 1]
        }
        showValue() {
            return "ForArray " + this.g
        }
    }
    class wb extends vb {
        constructor(a, c) {
            super();
            this.g = a;
            (this.j = c) || sa.la("Filter iterator undefined predicate")
        }
        next() {
            for (; ; ) {
                const a = this.g.next();
                if (!a)
                    return null;
                const c = this.j(a);
                if ("done" === c)
                    return null;
                if (c)
                    return a
            }
        }
    }
    class yb extends vb {
        constructor(a, c) {
            super();
            this.B = a;
            this.j = c;
            this.g = null
        }
        next() {
            for (; ; ) {
                if (null !== this.g) {
                    var a = this.g.next();
                    if (a)
                        return a
                }
                a = this.B.next();
                if (null === a)
                    return null;
                (this.g = this.j(a)) && !this.g.next && sa.la("Result of mapper is not an iterator, mapper = " + this.j)
            }
        }
    }
    class xb extends vb {
        constructor(a, c) {
            super();
            this.g = a;
            this.B = 0;
            "object" === typeof a && "next"in a || sa.la("Base not an iterator");
            this.j = c
        }
        next() {
            for (; ; ) {
                var a = this.g.next();
                if (null === a)
                    return null;
                if (a = this.j(a, this.B++))
                    return a
            }
        }
    }
    class Cb extends vb {
        constructor(a, c) {
            super();
            this.g = a;
            this.j = c
        }
        next() {
            const a = this.g;
            return a ? (this.g = this.j(a),
            a) : null
        }
        ua() {
            return this.g
        }
    }
    class Db extends vb {
        constructor(a) {
            super();
            Array.isArray(a) || sa.la("Join iterator expects array");
            this.g = a
        }
        next() {
            for (; ; ) {
                if (0 === this.g.length)
                    return null;
                const a = this.g[0].next();
                if (null === a)
                    this.g.shift();
                else
                    return a
            }
        }
    }
    class Eb extends vb {
        constructor(a, c, q) {
            super();
            this.g = Fb(a);
            this.j = Fb(c);
            this.B = q;
            this.current = null
        }
        next() {
            var a = this.g.ua();
            const c = this.j.ua();
            return a && c ? (a = this.B(a, c),
            0 > a ? this.current = this.g.next() : 0 < a ? this.current = this.j.next() : (this.current = this.g.next(),
            this.j.next()),
            this.current) : a ? this.current = this.g.next() : c ? this.current = this.j.next() : this.current = null
        }
    }
    class Gb extends vb {
        constructor(a, c, q) {
            super();
            this.g = Fb(a);
            this.j = Fb(c);
            this.B = q;
            this.current = null
        }
        next() {
            let a = this.g.ua()
              , c = this.j.ua();
            for (; a && c; ) {
                const q = this.B(a, c);
                if (0 > q)
                    this.g.next(),
                    a = this.g.ua();
                else if (0 < q)
                    this.j.next(),
                    c = this.j.ua();
                else
                    return this.current = this.g.next(),
                    this.j.next(),
                    this.current
            }
            return this.current = null
        }
    }
    class Hb extends vb {
        constructor(a, c, q) {
            super();
            this.g = Fb(a);
            this.j = Fb(c);
            this.B = q;
            this.current = null
        }
        next() {
            let a = this.g.ua();
            for (var c = this.j.ua(); a && c; ) {
                c = this.B(a, c);
                if (0 > c)
                    return this.current = this.g.next();
                0 < c ? this.j.next() : (this.g.next(),
                this.j.next(),
                a = this.g.ua());
                c = this.j.ua()
            }
            return a && !c ? this.current = this.g.next() : this.current = null
        }
    }
    function Fb(a) {
        return "peek"in a ? a : new Ib(a)
    }
    class Ib extends vb {
        constructor(a) {
            super();
            this.j = a;
            this.g = a.next()
        }
        next() {
            const a = this.g;
            a && (this.g = this.j.next());
            return a
        }
        ua() {
            return this.g
        }
        showValue() {
            return "LookAhead of " + this.j.showValue()
        }
    }
    class Jb extends vb {
        constructor(a) {
            super();
            this.g = a;
            this.j = -1;
            this.position = 0;
            this.current = null
        }
        next() {
            this.position++;
            this.current = this.g.next();
            null === this.current && (this.position = -1);
            return this.current
        }
        last() {
            if (0 > this.j)
                if (this.g instanceof Kb)
                    this.j = this.g.expand().length;
                else {
                    const a = [];
                    let c;
                    for (; null !== (c = this.g.next()); )
                        a.push(c);
                    this.j = this.position + a.length;
                    this.g = Kb(a)
                }
            return this.j
        }
        showValue() {
            return "Tracker of " + this.g.showValue()
        }
    }
    class Lb extends vb {
        constructor(a) {
            super();
            this.current = a;
            this.position = 1
        }
        next() {
            return null
        }
        last() {
            return 1
        }
    }
    class Mb extends vb {
        constructor(a) {
            super();
            this.g = a
        }
        next() {
            const a = this.g.next();
            return a.done ? null : a.value
        }
    }
    class Nb extends vb {
        constructor(a, c, q) {
            super();
            this.g = a;
            this.j = q;
            for (this.B = 1; !(this.B++ >= c); )
                if (null == this.g.next()) {
                    this.j = Number.NEGATIVE_INFINITY;
                    break
                }
        }
        next() {
            return this.B++ <= this.j ? this.g.next() : null
        }
    }
    const Ob = new Ab;
    function Pb(a) {
        return new zb(a)
    }
    function Qb(a) {
        return new Db(a)
    }
    function Rb(a) {
        return new Lb(a)
    }
    function Sb(a) {
        return new Jb(a)
    }
    function Kb(a) {
        return new Bb(a)
    }
    function Tb(a) {
        return new zb(ub.string.fromString(a))
    }
    function Ub(a) {
        return new zb(ub.integer.fromNumber(a))
    }
    function Vb(a) {
        return new zb(ub.double.fromNumber(a))
    }
    function Wb(a) {
        return new zb(ub.mb.nb(a))
    }
    function Xb(a) {
        return new zb(ub.boolean.fromBoolean(a))
    }
    var Yb = {};
    Yb.Sj = vb;
    Yb.Yj = Hb;
    Yb.Zj = Ob;
    Yb.$j = Ab;
    Yb.bk = wb;
    Yb.ck = Kb;
    Yb.dk = Bb;
    Yb.ek = Mb;
    Yb.hk = Gb;
    Yb.ik = Qb;
    Yb.jk = Db;
    Yb.kk = Ib;
    Yb.pk = yb;
    Yb.qk = xb;
    Yb.tk = Pb;
    Yb.uk = zb;
    Yb.vk = Rb;
    Yb.wk = Lb;
    Yb.xk = Cb;
    Yb.yk = Nb;
    Yb.Bk = Sb;
    Yb.Ck = Jb;
    Yb.Fk = Eb;
    Yb.hl = Xb;
    Yb.il = Wb;
    Yb.jl = Vb;
    Yb.kl = function(a) {
        return new zb(ub.float.fromNumber(a))
    }
    ;
    Yb.ll = Ub;
    Yb.ml = Tb;
    // Input 13
    // Input 14
    var Zb = {
        Wc: "http://www.w3.org/1999/XSL/Transform",
        Oa: "http://www.w3.org/2005/xpath-functions",
        yh: "http://www.w3.org/2005/xpath-functions/math",
        map: "http://www.w3.org/2005/xpath-functions/map",
        Ue: "http://www.w3.org/2005/xpath-functions/array",
        xml: "http://www.w3.org/XML/1998/namespace",
        lc: "http://www.w3.org/2001/XMLSchema",
        vl: "http://www.w3.org/2001/XMLSchema-instance",
        zi: "http://www.w3.org/2005/xqt-errors",
        nd: "http://saxonica.com/ns/interactiveXSLT",
        xh: "http://saxonica.com/ns/globalJS",
        wb: "http://saxon.sf.net/",
        Ci: "http://ns.saxonica.com/xslt/export",
        withPrefix: {
            xsl: "http://www.w3.org/1999/XSL/Transform",
            fn: "http://www.w3.org/2005/xpath-functions",
            math: "http://www.w3.org/2005/xpath-functions/math",
            map: "http://www.w3.org/2005/xpath-functions/map",
            array: "http://www.w3.org/2005/xpath-functions/array",
            xml: "http://www.w3.org/XML/1998/namespace",
            xs: "http://www.w3.org/2001/XMLSchema",
            xsi: "http://www.w3.org/2001/XMLSchema-instance",
            err: "http://www.w3.org/2005/xqt-errors",
            ixsl: "http://saxonica.com/ns/interactiveXSLT",
            js: "http://saxonica.com/ns/globalJS",
            saxon: "http://saxon.sf.net/",
            ex: "http://ns.saxonica.com/xslt/export"
        },
        yg: "http://ns.saxonica.com/anonymous-type"
    };
    // Input 15
    var ac = function() {
        function a(p) {
            return p ? 9 === p.nodeType ? p : a(p.ownerDocument) : null
        }
        const c = La.XS;
        let q = 1;
        const E = {
            Zc: function(p) {
                switch (p.nodeType) {
                case 9:
                case 11:
                    return Ob;
                case 2:
                    return p.parent ? new Cb(p.parent,g=>g.parentNode) : Ob;
                default:
                    return (p = p.parentNode) ? new Cb(p,g=>g.parentNode) : Ob
                }
            },
            Ya: function(p) {
                return Qb([Pb(p), E.Zc(p)])
            },
            Ha: function(p) {
                if (1 === p.nodeType) {
                    const g = p.attributes
                      , e = p.ownerDocument.documentElement && pa.Zb(p.ownerDocument.documentElement)
                      , k = [];
                    for (let v = 0; v < g.length; v++) {
                        const t = g[v].name;
                        if ("xmlns" !== t.substring(0, 5) || 5 !== t.length && ":" !== t.charAt(5))
                            e && "xml:" === g[v].localName.substring(0, 4) ? k.push(new $b(c.QName.fromParts("xml", Zb.xml, g[v].localName.substring(4)),g[v].value,p)) : k.push(new $b(c.QName.fromParts(g[v].prefix, g[v].namespaceURI, g[v].localName),g[v].value,p))
                    }
                    return Kb(k)
                }
                return Ob
            },
            Ka: function(p) {
                function g(e) {
                    return new Cb(e.firstChild,k=>k.nextSibling)
                }
                if (null === p)
                    return Ob;
                switch (p.nodeType) {
                case 9:
                    return g(p).filter(function(e) {
                        return !(7 === e.nodeType && "xml" === e.target || 3 === e.nodeType || 4 === e.nodeType)
                    });
                case 11:
                case 1:
                    return g(p);
                default:
                    return Ob
                }
            },
            me: function(p) {
                return E.Ka(p).mapOneToMany(function(g) {
                    return E.oe(g)
                })
            },
            oe: function(p) {
                return Qb([Pb(p), E.me(p)])
            },
            eh: function(p) {
                switch (p.nodeType) {
                case 9:
                case 11:
                    return Ob;
                case 2:
                case 13:
                    return p = ac.Xa(p),
                    null === p ? Ob : Qb([E.me(p), E.eh(p)]);
                default:
                    return E.Ya(p).mapOneToMany(function(g) {
                        return E.fh(g).mapOneToMany(E.oe)
                    })
                }
            },
            fh: function(p) {
                switch (p.nodeType) {
                case 9:
                case 11:
                case 2:
                case 13:
                    return Ob;
                default:
                    return new Cb(p.nextSibling,g=>g.nextSibling)
                }
            },
            ob: function(p) {
                return 1 === p.nodeType ? Kb(ac.Ic(p).map(function(g) {
                    return new bc(g.prefix,g.uri,p)
                })) : Ob
            },
            parent: function(p) {
                return Pb(ac.Xa(p))
            },
            og: function(p) {
                return E.Ya(p).mapOneToMany(function(g) {
                    return E.Oc(g).mapOneToMany(function(e) {
                        return Kb(E.oe(e).expand().reverse())
                    })
                })
            },
            Oc: function(p) {
                switch (p.nodeType) {
                case 9:
                case 11:
                case 2:
                case 13:
                    return Ob;
                default:
                    return new Cb(p.previousSibling,g=>g.previousSibling)
                }
            },
            self: function(p) {
                return Pb(p)
            }
        }
          , H = {
            Ja: E,
            Ng: {
                ancestor: E.Zc,
                "ancestor-or-self": E.Ya,
                attribute: E.Ha,
                child: E.Ka,
                descendant: E.me,
                "descendant-or-self": E.oe,
                following: E.eh,
                "following-sibling": E.fh,
                namespace: E.ob,
                parent: E.parent,
                preceding: E.og,
                "preceding-sibling": E.Oc,
                self: E.self
            },
            Gc: a,
            rc: function(p) {
                return E.Ya(p).expand().pop()
            },
            wc: function(p) {
                p._saxonDocumentNumber || (p._saxonDocumentNumber = q++);
                return p
            },
            ui: function(p) {
                return ac.wc(p)._saxonDocumentNumber
            },
            ca: function(p) {
                if (!p || !p.nodeType)
                    return null;
                switch (p.nodeType) {
                case 1:
                    return c.QName.fromParts(p.prefix, p.namespaceURI, p.localName);
                case 2:
                    if ("xml" === p.prefix)
                        return c.QName.fromParts(p.prefix, Zb.xml, p.localName);
                    if (!p.yc)
                        throw new F("ATTRIBUTE_NODE not local","SXJS0004");
                    return p.yc;
                case 7:
                    return c.QName.fromParts("", "", p.target);
                case 13:
                    return p.prefix ? c.QName.fromParts("", "", p.prefix) : null;
                default:
                    return null
                }
            },
            Tk: function(p, g) {
                if (!p || !p.nodeType)
                    return !1;
                switch (p.nodeType) {
                case 1:
                case 2:
                    return p.localName === g;
                case 7:
                    return p.target === g;
                case 13:
                    return p.prefix === g;
                default:
                    return !1
                }
            },
            hasURI: function(p, g) {
                if (!p || !p.nodeType)
                    return !1;
                switch (p.nodeType) {
                case 1:
                    return (p.namespaceURI || "") === g;
                case 2:
                    return "xml" === p.prefix ? Zb.xml === g : p.namespaceURI === g;
                default:
                    return "" === g
                }
            },
            Ec: function(p, g) {
                let e = [];
                for (p = p.firstChild; null !== p; )
                    1 !== p.nodeType || g && g !== p.tagName || e.push(p),
                    p = p.nextSibling;
                return e
            },
            firstElementChild: function(p, g) {
                for (p = p.firstChild; null !== p; ) {
                    if (1 === p.nodeType && (!g || g === p.tagName))
                        return p;
                    p = p.nextSibling
                }
                return null
            },
            kd: function(p) {
                const g = p.expand();
                if (1 < g.length) {
                    let e = !0
                      , k = !0
                      , v = !0;
                    g.forEach(t=>{
                        ac.X(t) ? (v = !1,
                        ac.Xa(t) ? e = !1 : t._saxonDocumentNumber ? e = !1 : ac.wc(t)) : k = !1
                    }
                    );
                    if (!k && !v)
                        throw new F("Cannot sort a sequence including both nodes and non-nodes","XPTY0018");
                    e || v || g.sort(ac.rb);
                    return Kb(g).mapOneToOne(function(t, C) {
                        return 0 < C && ac.isSameNode(t, g[C - 1]) ? null : t
                    })
                }
                return Kb(g)
            },
            rb: function(p, g) {
                if (ac.isSameNode(p, g))
                    return 0;
                var e = ac.Xa(p)
                  , k = ac.Xa(g);
                if (null === e)
                    return null === k ? (e = ac.wc,
                    e(p)._saxonDocumentNumber - e(g)._saxonDocumentNumber) : p === k ? -1 : ac.rb(p, k);
                if (null === k)
                    return g === e ? 1 : ac.rb(e, g);
                if (e === k) {
                    k = p.nodeType;
                    var v = g.nodeType;
                    if (2 === k) {
                        if (2 === v) {
                            e = e.attributes;
                            for (k = 0; k < e.length; k++) {
                                v = c.QName.fromParts(e[k].prefix, e[k].namespaceURI, e[k].localName);
                                if (v.equals(ac.ca(p)))
                                    return -1;
                                if (v.equals(ac.ca(g)))
                                    return 1
                            }
                            throw new F("Att not found in parent","SXJS0004");
                        }
                        return 13 === v ? 1 : -1
                    }
                    if (13 === k)
                        return 13 === v ? p.prefix < g.prefix ? -1 : 1 : -1;
                    if (2 === v || 13 === v)
                        return 1;
                    e = p;
                    for (k = g; ; ) {
                        e = e.previousSibling;
                        if (!e)
                            return -1;
                        if (e === g)
                            return 1;
                        k = k.previousSibling;
                        if (!k)
                            return 1;
                        if (k === p)
                            return -1
                    }
                } else {
                    if (p === k)
                        return -1;
                    if (g === e)
                        return 1;
                    v = E.Zc(e).count();
                    const t = E.Zc(k).count();
                    return v === t ? ac.rb(e, k) : v > t ? ac.rb(e, g) : ac.rb(p, k)
                }
            },
            Xa: function(p) {
                return ac.re(p) ? p.parent : p.parentNode
            },
            bf: function(p, g, e) {
                p.setAttributeNS("http://www.w3.org/2000/xmlns/", "" === g ? "xmlns" : "xmlns:" + g, e)
            },
            Ic: function(p, g=E.Ya) {
                let e = [{
                    prefix: "xml",
                    uri: Zb.xml
                }]
                  , k = {
                    xml: !0
                };
                for (p = g(p); null !== (g = p.next()); )
                    if (1 === g.nodeType) {
                        var v = ac.ca(g);
                        "" === v.prefix && "" === v.uri && (k[""] = !0);
                        g = g.attributes;
                        for (v = 0; v < g.length; v++) {
                            var t = g[v].name;
                            "xmlns" === t.substring(0, 5) && (5 !== t.length || k[""] ? ":" === t.charAt(5) && (t = t.substring(6),
                            k[t] || (k[t] = !0,
                            e.push({
                                prefix: t,
                                uri: g[v].value
                            }))) : (k[""] = !0,
                            "" !== g[v].value && e.push({
                                prefix: "",
                                uri: g[v].value
                            })))
                        }
                    } else
                        break;
                return e
            },
            Ti: function(p) {
                if (p.di) {
                    a: {
                        p = p.di;
                        for (g in p)
                            if (p.hasOwnProperty(g)) {
                                var g = !1;
                                break a
                            }
                        g = !0
                    }
                    return !g
                }
                g = p.attributes;
                for (p = 0; p < g.length; p++) {
                    let e = g[p].name;
                    if ("xmlns" === e.substring(0, 5) && (5 === e.length || ":" === e.charAt(5)))
                        return !0
                }
                return !1
            },
            rh: function(p) {
                for (p = p.firstChild; null !== p; ) {
                    if (1 === p.nodeType && ac.Ti(p) || !ac.rh(p))
                        return !1;
                    p = p.nextSibling
                }
                return !0
            },
            Uk: function(p) {
                return (p = p.attributes.getNamedItem("xmlns")) && "" === p.value
            },
            Oi: function(p, g) {
                for (; p && 1 === p.nodeType; ) {
                    if (p.hasAttribute(g))
                        return p.getAttribute(g);
                    p = p.parentNode
                }
                return null
            },
            Qi: function(p, g, e) {
                for (; p && 1 === p.nodeType; ) {
                    if (p.hasAttributeNS(g, e))
                        return p.getAttributeNS(g, e);
                    p = p.parentNode
                }
                return null
            },
            getAttribute: function(p, g, e) {
                return p.hasAttribute(g) ? p.getAttribute(g) : 2 < arguments.length ? e : null
            },
            Pk: function(p, g) {
                return parseInt(p.getAttribute(g), 10)
            },
            Cj: function(p, g, e) {
                const k = c.QName;
                if (/:/.test(g))
                    return k.fromString(g, function(v) {
                        return "xml" === v ? Zb.xml : p.lookupNamespaceURI(v)
                    });
                e = e ? p.lookupNamespaceURI(null) || "" : "";
                return k.fromParts("", e, g)
            },
            re: function(p) {
                return p instanceof $b
            },
            Kd: function(p) {
                return p instanceof bc
            },
            jf: function(p) {
                return p instanceof abstractNode && (9 === p.nodeType || 11 === p.nodeType)
            },
            sh: function(p) {
                return p instanceof abstractNode && 1 === p.nodeType
            },
            X: function(p) {
                return p instanceof abstractNode && !(7 === p.nodeType && "xml" === p.target) || ac.re(p) || ac.Kd(p)
            },
            Xk: function(p) {
                return p instanceof abstractNode && 7 === p.nodeType
            },
            isSameNode: function(p, g) {
                return p === g || ac.Kd(p) && ac.Kd(g) && p.parentNode && g.parentNode && p.parentNode === g.parentNode && p.prefix === g.prefix || ac.re(p) && ac.re(g) && p.parent && g.parent && p.parent === g.parent && ac.ca(p).equals(ac.ca(g))
            },
            ej: function(p, g) {
                return p === g || 9 === p && 11 === g || 9 === g && 11 === p
            },
            Yk: function(p) {
                return p instanceof abstractNode && (3 === p.nodeType || 4 === p.nodeType)
            },
            ld: function(p) {
                return p.startsWith("blob:") || p.startsWith("data:") || /^(?:[A-Za-z][A-Za-z0-9+.-]+:)?\/\//i.test(p)
            },
            baseURI: function(p) {
                function g(e) {
                    const k = ac.Xa(e);
                    e = k ? ac.baseURI(k) : e._saxonBaseUri ? e._saxonBaseUri : null;
                    null != e && 0 <= e.indexOf("\\") && (e = e.replaceAll("\\", "/"),
                    1 < e.length && ":" === e[1] && (e = "file:///" + e));
                    return e
                }
                if (null === p || ac.Kd(p))
                    return null;
                if (1 === p.nodeType && p.hasAttribute("xml:base")) {
                    const e = p.getAttribute("xml:base");
                    return ac.ld(e) ? e : g(p) ? pa.Fb(e.toString(), g(p)).toString() : null
                }
                return g(p)
            }
        };
        sa.zj(H);
        return H
    }();
    // Input 16
    const cc = function() {
        function a(k, v) {
            if ("" === v)
                return k.jb;
            const t = v.charAt(0);
            return k.Ba.hasOwnProperty(t) ? a(k.Ba[t], v.substring(1)) : []
        }
        function c(k, v) {
            const t = a(k, k.options.hash(v));
            for (let C = 0; C < t.length; C++)
                if (k.options.Rc(t[C].k, v))
                    return t[C];
            return null
        }
        function q(k, v, t, C) {
            if ("" === C) {
                for (C = 0; C < k.jb.length; C++)
                    if (k.options.Rc(k.jb[C].k, v)) {
                        k.jb[C] = {
                            k: v,
                            v: t
                        };
                        return
                    }
                k.jb.push({
                    k: v,
                    v: t
                })
            } else {
                const m = C.charAt(0);
                let f;
                k.Ba.hasOwnProperty(m) ? f = k.Ba[m] : (f = new p(k.options),
                f.id = g++,
                k.Ba[m] = f);
                q(f, v, t, C.substring(1))
            }
        }
        function E(k, v, t, C) {
            const m = new p(k.options);
            let f = !1;
            if ("" === C)
                m.jb = k.jb.map(function(O) {
                    return k.options.Rc(O.k, v) ? (f = !0,
                    {
                        k: v,
                        v: t
                    }) : O
                }),
                f || m.jb.push({
                    k: v,
                    v: t
                }),
                m.Ba = k.Ba;
            else {
                const O = C.charAt(0);
                for (var A in k.Ba)
                    k.Ba.hasOwnProperty(A) && (A === O ? (m.Ba[A] = E(k.Ba[A], v, t, C.substring(1)),
                    f = !0) : m.Ba[A] = k.Ba[A]);
                f || (A = new p(k.options),
                A = E(A, v, t, C.substring(1)),
                m.Ba[O] = A);
                m.jb = k.jb
            }
            return m
        }
        function H(k, v, t) {
            const C = new p(k.options);
            if ("" === t)
                C.jb = k.jb.filter(function(m) {
                    return !k.options.Rc(m.k, v)
                }),
                C.Ba = k.Ba;
            else {
                const m = t.charAt(0);
                for (const f in k.Ba)
                    k.Ba.hasOwnProperty(f) && (C.Ba[f] = f === m ? H(k.Ba[f], v, t.substring(1)) : k.Ba[f]);
                C.jb = k.jb
            }
            return C
        }
        function p(k) {
            this.jb = [];
            this.Ba = {};
            this.options = k || {
                hash: e.hash,
                Rc: e.Rc
            }
        }
        let g = 0
          , e = {
            hash: function(k) {
                return k.hashCode()
            },
            Rc: function(k, v) {
                try {
                    return k.isNumeric() ? k.qg(v) : k.equals(v) && (void 0 !== k.Fa && null !== k.Fa) === (void 0 !== v.Fa && null !== v.Fa)
                } catch (t) {
                    return !1
                }
            }
        };
        p.prototype = {
            jb: [],
            Ba: {},
            options: e,
            containsKey: function(k) {
                return null !== c(this, k)
            },
            get: function(k) {
                k = c(this, k);
                return null === k ? [] : k.v
            },
            evaluate: function(k) {
                k = c(this, k[0][0]);
                return null === k ? Ob : Kb(k.v)
            },
            inSituPut: function(k, v) {
                q(this, k, v, this.options.hash(k))
            },
            put: function(k, v) {
                return E(this, k, v, this.options.hash(k))
            },
            remove: function(k) {
                return H(this, k, this.options.hash(k))
            },
            forAllPairs: function(k) {
                this.jb.forEach(k);
                for (let v in this.Ba)
                    this.Ba.hasOwnProperty(v) && this.Ba[v].forAllPairs(k)
            },
            keys: function() {
                const k = [];
                this.forAllPairs(function(v) {
                    k.push(v.k)
                });
                return k
            },
            conforms: function(k, v, t) {
                const C = this;
                return Kb(C.keys()).every(function(m) {
                    let f = C.get(m);
                    return k(m) && t(f.length) && Kb(f).every(v)
                })
            },
            showValue: function() {
                let k = "HashTrie map{"
                  , v = "";
                this.forAllPairs(function(t) {
                    k += v;
                    v = ", ";
                    k += sa.showValue(t.k);
                    k += ": ";
                    k += sa.showValue(t.v)
                });
                return k += "}"
            }
        };
        return p
    }();
    // Input 17
    const dc = {
        Aa: null,
        mc: null,
        Hf: null,
        Oe: null,
        dc: null,
        Ad: null,
        ec: null,
        Ig: null,
        If: null,
        Jg: null,
        Dg: null,
        cb: null,
        bi: null,
        Bd: null,
        Fg: null,
        Gf: null,
        de: null,
        Cg: null,
        Gg: null,
        Bg: null,
        Hg: null,
        ce: null,
        be: null,
        Ke: null,
        Qe: null,
        Jf: null,
        Df: null,
        Ie: null
    };
    function ec(a) {
        if (/^[01?+*]/.test(a)) {
            var c = a.charAt(0);
            var q = a.substring(1)
        } else
            c = "1",
            q = a;
        q = fc(q);
        c = new gc(q,hc(c));
        c.g = a;
        return c
    }
    function ic(a) {
        const c = jc(a);
        return new gc(c,hc(a.o))
    }
    function kc(a) {
        sa.assert(a instanceof lc);
        return new gc(a,2)
    }
    function mc() {
        function a(q, E) {
            return new gc(q,E)
        }
        function c(q, E) {
            return a(new nc(La.codes[q]), hc(E))
        }
        oc = new pc;
        qc = new rc;
        sc = new tc;
        uc = new vc;
        wc = new xc;
        yc = new zc;
        Ac = new Bc;
        Cc = new Dc;
        Ec = new Fc(9);
        Gc = new Fc(1);
        Hc = new Fc(2);
        Ic = new Fc(3);
        Jc = new Fc(8);
        Kc = new Fc(7);
        Lc = new Fc(13);
        Mc = new nc(La.XS.double);
        Nc = new nc(La.XS.float);
        Oc = new nc(La.XS.string);
        Pc = new nc(La.XS.mb);
        Qc = new nc(La.XS.integer);
        Rc = new nc(La.XS.dayTimeDuration);
        Sc = new nc(La.XS.Qf);
        Tc.NMTOKENS = La.type.NMTOKEN;
        Tc.IDREFS = La.type.IDREF;
        Tc.ENTITIES = La.type.ENTITY;
        Object.assign(dc, {
            Aa: a(Uc, 7),
            mc: a(Uc, 2),
            Hf: a(Uc, 3),
            Oe: c("A", "1"),
            dc: c("A", "?"),
            Ad: c("A", "*"),
            ec: c("AS", "1"),
            Ig: c("AZ", "1"),
            If: c("AZ", "?"),
            Jg: c("AZ", "*"),
            Dg: c("AS", "?"),
            cb: c("AB", "1"),
            bi: c("AB", "?"),
            Bd: c("ADI", "1"),
            Fg: c("AD", "1"),
            Gf: c("ADI", "?"),
            de: c("AO", "1"),
            Cg: c("AO", "?"),
            Gg: c("AF", "1"),
            Bg: c("AU", "?"),
            Hg: c("AQ", "1"),
            ce: a(qc, 3),
            be: a(qc, 7),
            Ke: c("ADI", "*"),
            Qe: a(wc, 2),
            Jf: a(yc, 2),
            Df: a(wc, 7),
            Ie: a(Cc, 1)
        })
    }
    function Vc(a, c) {
        return new gc(a.U,c)
    }
    function Wc(a, c) {
        var q = a.fa;
        return new gc(a.U,1 === q || 1 === c ? 1 : 2 === c ? q : 2 === q ? c : Xc(q) || Xc(c) ? 7 : 6 === q && 6 === c ? 6 : 7)
    }
    class gc {
        constructor(a, c) {
            this.U = a;
            this.fa = c;
            this.j = this.g = null
        }
        $() {
            if (!this.j)
                if (this.g)
                    this.j = rb(this.g);
                else {
                    const a = Object.assign(this.U.$() || {});
                    a.o = Yc(this.fa);
                    this.j = a
                }
            return this.j
        }
        ha() {
            this.g || (this.g = this.j ? sb(this.j) : (Yc(this.fa) || "1") + this.U.ha());
            return this.g
        }
        matches(a) {
            let c;
            switch (a.length) {
            case 0:
                c = Xc(this.fa);
                break;
            case 1:
                c = 1 !== this.fa;
                break;
            default:
                c = Zc(this.fa)
            }
            if (!c)
                return !1;
            const q = this.U.ia();
            return a.every(E=>q(E))
        }
        toString() {
            return this.U instanceof Dc && 1 === this.fa ? "empty-sequence()" : this.U.toString() + Yc(this.fa)
        }
        equals(a) {
            return this.ha() === a.ha()
        }
    }
    ;// Input 18
    class $c {
        constructor(a) {
            Array.isArray(a) || sa.la("XdmArray value must be an array. Supplied:" + a);
            this.value = a
        }
        get(a) {
            if ("number" != typeof a)
                throw new F("Array subscript is not numeric","XPTY0004");
            if (1 > a || a > this.value.length)
                throw new F("Array index (" + a + ") out of bounds (1 to " + this.value.length + ")","FOAY0001");
            return this.value[a - 1]
        }
        evaluate(a) {
            return Kb(this.value[a[0][0] - 1])
        }
        size() {
            return this.value.length
        }
        showValue() {
            let a = "[";
            for (let c = 0; c < this.value.length && 3 > c; c++)
                0 !== c && (a += ","),
                a += sa.showValue(this.value[c]);
            4 <= this.value.length && (a += ",...(" + this.value.length + ")");
            return a + "]"
        }
        flatten(a) {
            for (let c = 0; c < this.value.length; c++) {
                const q = this.value[c];
                for (let E = 0; E < q.length; E++)
                    a(q[E])
            }
        }
        conforms(a, c, q) {
            var E = La.XS.integer.fromNumber(this.value.length);
            if (!a(E))
                return !1;
            for (a = 0; a < this.value.length; a++)
                if (E = this.value[a],
                !q(E.length) || !Kb(E).every(c))
                    return !1;
            return !0
        }
    }
    ;// Input 19
    var bd = function() {
        function a(p, g, e) {
            function k(m, f) {
                function A(O) {
                    return O instanceof bc ? "a namespace" : "an attribute"
                }
                if (f)
                    throw new F("Cannot create " + A(m) + " node on element '" + E.ca(p) + "' after creating children","XTDE0410");
                if (11 === p.nodeType || 9 === p.nodeType)
                    throw new F("Cannot add " + A(m) + " to a document node","XTDE0420");
            }
            function v(m, f) {
                var A = f._saxonIsLocal ? f._saxonIsLocal : !1;
                if (f instanceof $c)
                    f.value.forEach(function(l) {
                        l.forEach(function(r) {
                            v(m, r)
                        })
                    });
                else {
                    if (f instanceof cc)
                        throw new F("A map can't be a child of an XML node","XSLT" === e.fixed.options.language ? "XTDE0450" : "XPTY0004");
                    if (f instanceof ad.XdmFunction)
                        throw new F("A function can't be a child of an XML node","XSLT" === e.fixed.options.language ? "XTDE0450" : "XPTY0004");
                    E.X(f) ? C = !1 : (f = E.Gc(e.ja).createTextNode((C ? " " : "") + f.toString()),
                    C = !0);
                    if (1 === m.nodeType || 11 === m.nodeType) {
                        if (10 !== f.nodeType)
                            if (E.Kd(f))
                                if (pa.Zb(m))
                                    m.appendChild(m.ownerDocument.importNode(f, !0));
                                else if (k(f, t),
                                "" === f.prefix) {
                                    if ("" === m.namespaceURI)
                                        throw new F("Cannot add a default namespace to a no-namespace element","XTDE0440");
                                    if (m.hasAttributeNS("", "xmlns")) {
                                        if (m.getAttributeNS("", "xmlns") !== f.uri)
                                            throw new F("Cannot have two different default namespaces","XTDE0430");
                                    } else
                                        pa.Zb(m) || m.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", f.uri)
                                } else {
                                    A = "xmlns:" + f.prefix;
                                    var O = f.uri;
                                    "~" === f.uri && null !== Zb.withPrefix[f.prefix] && (O = Zb.withPrefix[f.prefix]);
                                    if (m.hasAttributeNS("http://www.w3.org/2000/xmlns/", f.prefix) && m.getAttributeNS("http://www.w3.org/2000/xmlns/", f.prefix) !== O)
                                        throw new F("Cannot have two namespaces with the same prefix '" + f.prefix + "'","XTDE0430");
                                    m.setAttributeNS("http://www.w3.org/2000/xmlns/", A, O)
                                }
                            else if (2 === f.nodeType) {
                                k(f, t);
                                if ("" !== f.namespaceURI && (A = f.name.split(":"),
                                2 !== A.length || m.lookupNamespaceURI(A[0]) !== f.namespaceURI))
                                    if (2 === A.length && null === m.lookupNamespaceURI(A[0]))
                                        m.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + A[0], f.namespaceURI);
                                    else
                                        for (O = 2 === A.length ? A[0] : "ns"; ; )
                                            if (null === m.lookupNamespaceURI(O)) {
                                                m.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + O, f.namespaceURI);
                                                f.name = O + ":" + A[A.length - 1];
                                                break
                                            } else
                                                O += "_1";
                                m.setAttributeNS("" === f.namespaceURI ? null : f.namespaceURI, f.name, f.value)
                            } else if (3 === f.nodeType || 4 === f.nodeType)
                                f.nodeValue && "" !== f.nodeValue && (A = m.lastChild,
                                !A || 3 !== A.nodeType && 4 !== A.nodeType ? m.appendChild(q(f, e, "")) : A.nodeValue += f.nodeValue),
                                t = !0;
                            else if (9 === f.nodeType || 11 === f.nodeType)
                                H.Ka(f).forEachItem(function(l) {
                                    v(m, l)
                                });
                            else {
                                t = !0;
                                if (!(pa.jd() && e.ja === window.document || 1 !== f.nodeType || pa.Zb(f))) {
                                    O = f.prefix || "";
                                    var b = f.lookupNamespaceURI(O) || ""
                                      , d = f.namespaceURI || "";
                                    b !== d && E.bf(f, O, d);
                                    !f.lookupNamespaceURI(null) && m.lookupNamespaceURI(null) && E.bf(f, "", "")
                                }
                                A && pa.Zb(m) === pa.Zb(f) || (f = q(f, e, "c"));
                                m.appendChild(f);
                                f._saxonIsLocal = !1
                            }
                    } else if (9 === m.nodeType)
                        null !== f && (m.documentElement = f);
                    else
                        throw new F("Unknown parent node type " + m.nodeType,"SXJS0003");
                }
            }
            e || sa.la("No context in makeComplexContent for " + sa.showValue(p));
            var t = !1
              , C = !1;
            g.forEachItem(function(m) {
                v(p, m)
            })
        }
        function c(p, g) {
            g && 0 <= g.indexOf("l") && (p._saxonIsLocal = !0);
            return p
        }
        function q(p, g, e) {
            var k = e && 0 <= e.indexOf("c");
            if (E.X(p)) {
                var v = function(m, f) {
                    e && 0 <= e.indexOf("m") && (f._saxonOriginal = m)
                };
                switch (p.nodeType) {
                case 9:
                case 11:
                    return k = E.wc(g.ja.createDocumentFragment()),
                    k._saxonBaseUri = p._saxonBaseUri,
                    k._saxonDocUri = p._saxonDocUri,
                    a(k, H.Ka(p).mapOneToOne(function(m) {
                        return q(m, g, e)
                    }), g),
                    v(p, k),
                    c(k, e);
                case 13:
                    return new bc(p.prefix,p.uri);
                case 1:
                    var t = E.ca(p);
                    var C = g.createElement(t.uri, t.toString());
                    !k || pa.jd() && pa.Zb(C) && g.ja === window.document || E.Ic(p).forEach(function(m) {
                        E.bf(C, m.prefix, m.uri)
                    });
                    H.Ha(p).forEachItem(function(m) {
                        C.setAttributeNS("" === m.namespaceURI ? null : m.namespaceURI, m.name, m.value)
                    });
                    H.Ka(p).forEachItem(function(m) {
                        m = q(m, g, e);
                        1 === m.nodeType && "" === E.ca(m).uri && "" !== t.uri && E.bf(m, "", "");
                        C.appendChild(m)
                    });
                    C._saxonBaseUri = E.baseURI(p);
                    v(p, C);
                    return c(C, e);
                case 10:
                    return null;
                case 2:
                    return new $b(E.ca(p),p.value,null);
                default:
                    return C = pa.jd() ? window.document.importNode(p, !0) : p.cloneNode(g.ja, p, !0),
                    v(p, C),
                    c(C, e)
                }
            } else
                return p
        }
        const E = ac
          , H = E.Ja;
        return {
            Lk: q,
            kj: a
        }
    }();
    // Input 20
    var ad = function() {
        class a {
            constructor(k, v) {
                this.xb = k;
                this.B = k.alphaTree;
                this.arity = v;
                this.resultType = this.B.r ? ic(this.B.r) : ec("*");
                this.j = [];
                if (k.variadic) {
                    k = ic(this.B.a[0]);
                    for (let t = 0; t < v; t++)
                        this.j.push(k)
                } else
                    for (k = 0; k < v; k++)
                        this.j[k] = ic(this.B.a[k])
            }
            Li() {
                return this.arity
            }
            ic() {
                return null
            }
            evaluate() {
                sa.la("Not implemented");
                return Ob
            }
            sc() {
                return this.ic() ? this.ic().toEQName() + "#" + this.arity : "anonymous function (arity " + this.arity + ")"
            }
            showValue() {
                return this.sc()
            }
            g(k, v) {
                v = v && "apply" === v.name;
                if (k.length !== this.arity)
                    throw new F("Too " + (k.length < this.arity ? "few" : "many") + " arguments in call to " + this.sc() + ": required " + this.arity + ", supplied " + k.length,v ? "FOAP0001" : "XPTY0004");
                v = [];
                for (let t = 0; t < k.length; t++)
                    v[t] = cd.Uf(k[t], this.j[t], ()=>"dynamic call of " + this.sc());
                return v
            }
            convertResult(k) {
                return Kb(cd.Uf(k, this.resultType, ()=>"result of dynamic call of " + this.sc()))
            }
            gg() {
                return new dd(this.j,this.resultType)
            }
        }
        class c extends a {
            constructor(k, v, t, C, m) {
                super(k, t);
                this.name = v;
                this.ka = [Zb.yh, Zb.map, Zb.Ue, Zb.wb, Zb.nd].includes(v.uri) ? cd.Bi : cd.Ai;
                this.K = C;
                if (k.defaultToDot && 0 === t || ["accumulator-after", "accumulator-before", "lang"].includes(v.local))
                    this.I = ed(m)
            }
            ic() {
                return this.name
            }
            evaluate(k, v, t) {
                var C = this.ic().local;
                if ("current" === C)
                    throw new F("current() function cannot be evaluated dynamically","XTDE1360");
                if ("current-output-uri" === C)
                    return Ob;
                if ("regex-group" === C)
                    return Tb("");
                let m = v;
                this.I && (m = v.ba(),
                m.focus = Rb(this.I));
                v = ["string-length", "normalize-space"].includes(C);
                const f = this.xb.defaultToDot;
                C = "number" === C;
                if ((v || f || C) && 0 === k.length) {
                    fd(m, "XPDY0002", ". (dot)");
                    t = ed(m);
                    if (v || C)
                        t = cd.Sb(t).next();
                    v && (t = La.XS.string.R(t));
                    k.push([t])
                } else
                    k = this.g(k, t);
                return this.ka(this.ic(), k, m, this.K)
            }
        }
        const q = {
            NMTOKENS: "NMTOKEN",
            IDREFS: "IDREF",
            ENTITIES: "ENTITY"
        };
        class E extends a {
            constructor(k, v, t) {
                super(k, 1);
                this.name = v;
                if (k = q[v.local]) {
                    const C = La.type[k].fromString;
                    sa.assert(C);
                    this.evaluate = m=>{
                        m = this.g(m, t)[0][0].toString();
                        m = xa(m).split(" ");
                        return Kb(m.map(C))
                    }
                } else if ("QName" === v.local) {
                    const C = cd.Wd(t, !0);
                    this.evaluate = m=>{
                        m = this.g(m, t)[0][0].toString();
                        return Pb(La.XS.QName.fromString(m, C))
                    }
                } else {
                    const C = La.type[v.local].R;
                    sa.assert(C);
                    this.evaluate = m=>Pb(C(this.g(m, t)[0][0]))
                }
            }
            ic() {
                return this.name
            }
        }
        class H extends a {
            constructor(k, v) {
                super(k, k.alphaTree.a.length);
                this.K = k.componentBinding;
                this.I = v.fixed.La[this.K];
                this.body = cd.da(this.I.actor, "body");
                this.name = La.XS.QName.fromEQName(this.I.actor.name)
            }
            ic() {
                return this.name
            }
            evaluate(k, v, t) {
                k = this.g(k, t);
                v = v.ba(!0);
                gd(v);
                v.qa = "function";
                v.gb = {};
                v.ab = null;
                v.focus = null;
                v.sa = this.I;
                for (t = 0; t < k.length; t++)
                    v.oa[t] = k[t];
                return cd.evaluate(this.body, v)
            }
        }
        class p extends a {
            constructor(k, v, t) {
                super(k, k.alphaTree.a.length);
                this.body = cd.da(v, "body");
                this.K = v.C;
                this.I = t
            }
            evaluate(k, v, t) {
                k = this.g(k, t);
                v = v.ba(!0);
                gd(v);
                v.qa = "function";
                v.gb = {};
                v.ab = null;
                v.focus = null;
                v.oa = this.I.oa.slice();
                v.sa = this.I.sa;
                t = this.K;
                for (let C = 0; C < k.length; C++)
                    v.oa[parseInt(t[C].slot, 10)] = k[C];
                return cd.evaluate(this.body, v)
            }
        }
        class g extends a {
            constructor(k, v, t) {
                super(k, k.alphaTree.a.length);
                this.I = v;
                this.K = t
            }
            sc() {
                return "partially-applied " + this.I.sc()
            }
            evaluate(k, v, t) {
                const C = [];
                for (let m = 0; m < this.I.arity; m++)
                    if (C[m] = this.K[m] || k.shift(),
                    !C[m])
                        throw new F("Too few arguments in call of " + this.sc(),"XPTY0004");
                return this.I.evaluate(C, v, t)
            }
        }
        class e extends a {
            constructor(k, v) {
                super(k, "F" === k.alphaTree.p ? k.alphaTree.a.length : 1);
                this.I = v
            }
            sc() {
                return "coerced " + this.I.sc()
            }
            evaluate(k, v, t) {
                k = this.g(k, t);
                return this.convertResult(this.I.evaluate(k, v, t).expand())
            }
        }
        return {
            XdmFunction: a,
            He: c,
            Bf: E,
            Ff: H,
            ai: p,
            $h: g,
            zg: e
        }
    }();
    // Input 21
    function hd(a, c) {
        a.g = c
    }
    function id(a, c) {
        a.K = c.replace(/^[01?*+]/, "")
    }
    function jd(a) {
        return /^N/.test(a.$().p)
    }
    function kd(a) {
        return a instanceof vc
    }
    class lc {
        constructor() {
            this.g = this.K = null
        }
        ia() {
            return ()=>!0
        }
        $() {
            if (!this.g)
                if (this.K)
                    this.g = rb(this.K);
                else
                    return null;
            return this.g
        }
        ha() {
            if (!this.K)
                if (this.g)
                    id(this, sb(this.g));
                else
                    return null;
            return this.K
        }
        pa(a="A") {
            return this.$().p.startsWith(a)
        }
        isNumeric() {
            return kd(this) || /^A[ODF]/.test(this.$().p.substring(0))
        }
        Jd() {
            return /^F/.test(this.$().p)
        }
        $i() {
            return !0
        }
        B() {
            return null
        }
        I() {
            return null
        }
        aa() {
            return null
        }
        toString() {
            return this.ha()
        }
        equals(a) {
            return this.ha() === a.ha()
        }
    }
    class pc extends lc {
        constructor() {
            super();
            id(this, "");
            this.g = {
                p: ""
            }
        }
        ia() {
            return ()=>!0
        }
        toString() {
            return "item()"
        }
    }
    var oc;
    const Uc = new pc;
    class rc extends lc {
        constructor() {
            super();
            id(this, "N");
            this.g = {
                p: "N"
            }
        }
        ia() {
            return a=>ac.X(a)
        }
        toString() {
            return "node()"
        }
    }
    var qc;
    class tc extends lc {
        constructor() {
            super();
            id(this, "N u[NT,NP,NC,NE]");
            this.g = {
                p: "N",
                u: [{
                    p: "NT"
                }, {
                    p: "NP"
                }, {
                    p: "NC"
                }, {
                    p: "NE"
                }]
            }
        }
        ia() {
            return a=>ac.X(a) && [1, 3, 4, 8, 7].includes(a.nodeType)
        }
        toString() {
            return "node()"
        }
    }
    var sc;
    function ld(a) {
        switch (a) {
        case 9:
            return Ec;
        case 1:
            return Gc;
        case 2:
            return Hc;
        case 8:
            return Jc;
        case 3:
        case 4:
            return Ic;
        case 7:
            return Kc;
        case 13:
            return Lc;
        default:
            throw new F("Unknown node kind " + a);
        }
    }
    function md(a) {
        switch (a) {
        case 1:
            return "NE";
        case 3:
            return "NT";
        case 2:
            return "NA";
        case 9:
            return "ND";
        case 8:
            return "NC";
        case 4:
            return "NT";
        case 7:
            return "NP";
        case 13:
            return "NN";
        case 0:
            return "N";
        default:
            throw new F("Unknown node kind " + a + " in NodeKindTest");
        }
    }
    class Fc extends lc {
        constructor(a) {
            super();
            this.kind = a;
            a = md(a);
            id(this, a);
            this.g = {
                p: a
            }
        }
        ia() {
            switch (this.kind) {
            case 9:
                return a=>ac.X(a) && (9 === a.nodeType || 11 === a.nodeType);
            case 3:
            case 4:
                return a=>ac.X(a) && (3 === a.nodeType || 4 === a.nodeType);
            default:
                return a=>ac.X(a) && a.nodeType === this.kind
            }
        }
        toString() {
            switch (this.kind) {
            case 9:
                return "document-node()";
            case 1:
                return "element(*)";
            case 2:
                return "attribute(*)";
            case 8:
                return "comment()";
            case 3:
            case 4:
                return "text()";
            case 7:
                return "processing-instruction()";
            case 13:
                return "namespace-node()";
            case 0:
                return "node()";
            default:
                throw new F("Unknown node kind " + this.kind + " in NodeKindTest");
            }
        }
    }
    var Ec, Gc, Hc, Jc, Ic, Kc, Lc;
    class nd extends Fc {
        constructor(a, c) {
            super(a);
            this.name = c;
            a = md(a);
            id(this, a + " n" + c.toEQName());
            this.g = {
                p: a,
                n: c.toEQName()
            }
        }
        ia() {
            const a = this.name;
            return c=>{
                var q;
                if (q = ac.X(c) && c.nodeType === this.kind)
                    q = (c = ac.ca(c)) && a.equals(c);
                return q
            }
        }
        toString() {
            return super.toString().replace(/\(\*?\)/, "(" + this.$().n + ")")
        }
    }
    class od extends Fc {
        constructor(a, c) {
            super(a);
            this.localName = c;
            a = md(a);
            id(this, a + " n*:" + c);
            this.g = {
                p: a,
                n: "*:" + c
            }
        }
        ia() {
            return a=>ac.X(a) && a.nodeType === this.kind && ac.ca(a).local === this.localName
        }
        toString() {
            return super.toString().replace(/\(\*?\)/, "(*:" + this.localName + ")")
        }
    }
    class pd extends Fc {
        constructor(a, c) {
            super(a);
            this.uri = c;
            a = md(a);
            id(this, a + " nQ{" + c + "}*");
            this.g = {
                p: a,
                n: "Q{" + c + "}*"
            }
        }
        ia() {
            return a=>ac.X(a) && a.nodeType === this.kind && ac.ca(a).uri === this.uri
        }
        toString() {
            return super.toString().replace(/\(\*?\)/, "Q{" + this.uri + "}*)")
        }
    }
    class qd extends Fc {
        constructor(a) {
            super(9);
            this.j = a;
            id(this, "ND e[" + a.ha() + "]");
            this.g = {
                p: "ND",
                e: a.$()
            }
        }
        ia() {
            return a=>ac.X(a) && (9 === a.nodeType || 11 === a.nodeType) && this.j.ia()(a.firstChild)
        }
        toString() {
            return "document-node(" + this.j.toString() + ")"
        }
    }
    class nc extends lc {
        constructor(a) {
            super();
            this.Vc = a;
            id(this, a.code);
            this.g = {
                p: a.code
            }
        }
        ia() {
            return a=>this.Vc.matches(a)
        }
        toString() {
            return "xs:" + this.Vc.name
        }
    }
    class vc extends lc {
        constructor() {
            super();
            id(this, "A m[AO,AD,AF]");
            this.g = {
                p: "A",
                m: [{
                    p: "AO"
                }, {
                    p: "AD"
                }, {
                    p: "AF"
                }]
            }
        }
        ia() {
            return a=>/^A[ODF]/.test(a.code)
        }
        toString() {
            return "xs:numeric"
        }
    }
    var uc;
    class Dc extends lc {
        ha() {
            return "E"
        }
        $() {
            return {
                p: "E"
            }
        }
        ia() {
            return ()=>!1
        }
        toString() {
            return "xs:error"
        }
    }
    var Cc;
    class rd extends lc {
        constructor() {
            super();
            this.j = [];
            this.resultType = null
        }
        Nb(a) {
            if (!(a instanceof rd))
                return sd.cc;
            if (a instanceof zc || a instanceof Bc)
                return sd.Rb;
            if (!(a instanceof dd || a instanceof td || a instanceof ud))
                return sd.nc;
            if (this.j.length !== a.j.length)
                return sd.cc;
            const c = function(E, H, p) {
                return E.map((g,e)=>p(g, H[e]))
            }(this.j, a.j, sd.Lh)
              , q = sd.Lh(this.resultType, a.resultType);
            return c.every(E=>E === sd.yb) && q === sd.yb ? sd.yb : c.every(E=>[sd.yb, sd.nc].includes(E) && [sd.yb, sd.Rb].includes(q)) ? sd.Rb : c.every(E=>[sd.yb, sd.Rb].includes(E) && [sd.yb, sd.nc].includes(q)) ? sd.nc : sd.Eg
        }
        ff() {
            return dc.Aa
        }
    }
    class xc extends rd {
        constructor() {
            super();
            id(this, "F");
            this.g = {
                p: "F"
            }
        }
        ia() {
            return a=>a instanceof ad.XdmFunction || a instanceof $c || a instanceof cc || a instanceof cd.Ef
        }
        Nb(a) {
            return a instanceof xc ? sd.yb : /^F/.test(a.$().p) ? sd.Rb : sd.cc
        }
        toString() {
            return "function(*)"
        }
    }
    var wc;
    function vd(a, c) {
        let q = [];
        c.forEach(E=>{
            q.push(a.j[E])
        }
        );
        return new dd(q,a.resultType)
    }
    class dd extends rd {
        constructor(a, c) {
            super();
            sa.assert(c instanceof gc);
            sa.assert(a.every(q=>q instanceof gc));
            this.j = a;
            this.resultType = c;
            id(this, "F a[" + a.map(q=>q.ha()).join(",") + "] r[" + c.ha() + "]");
            hd(this, {
                p: "F",
                a: a.map(q=>q.$()),
                r: c.$()
            })
        }
        ia() {
            const a = this;
            return function(c) {
                return c instanceof $c ? 1 === a.j.length && 2 === a.j[0].fa && c.conforms(a.j[0].U.ia(), a.resultType.U.ia(), wd(a.resultType.fa)) : c instanceof cc ? 1 === a.j.length && 2 === a.j[0].fa && a.j[0].U instanceof nc && c.conforms(()=>!0, a.resultType.U.ia(), wd(a.resultType.fa)) : c instanceof ad.XdmFunction ? (c = a.Nb(c.gg()),
                [sd.yb, sd.Rb].includes(c)) : !1
            }
        }
        ff() {
            return this.resultType
        }
        toString() {
            return "(function(" + this.j.map(a=>a.toString()).join(",") + ") as " + this.resultType.toString() + ")"
        }
    }
    class zc extends rd {
        constructor() {
            super();
            id(this, "FM");
            this.g = {
                p: "FM"
            }
        }
        I() {
            return Sc
        }
        aa() {
            return dc.Aa
        }
        ia() {
            return a=>a instanceof cc || a instanceof cd.Ef
        }
        toString() {
            return "map(*)"
        }
    }
    var yc;
    class td extends rd {
        constructor(a, c) {
            super();
            sa.assert(a instanceof lc);
            sa.assert(c instanceof gc);
            this.V = a;
            this.valueType = c;
            id(this, "FM k[" + a.ha() + "] v[" + c.ha() + "]");
            this.g = {
                p: "FM",
                k: a.$(),
                v: c.$()
            }
        }
        ia() {
            return a=>a instanceof cc && a.conforms(this.V.ia(), this.valueType.U.ia(), wd(this.valueType.fa))
        }
        toString() {
            return "map(" + this.V.toString() + "," + this.valueType.toString() + ")"
        }
        I() {
            return this.V
        }
        aa() {
            return this.valueType
        }
        ff() {
            return this.valueType
        }
    }
    class Bc extends rd {
        constructor() {
            super();
            id(this, "FA");
            this.g = {
                p: "FA"
            }
        }
        ia() {
            return a=>a instanceof $c
        }
        toString() {
            return "array(*)"
        }
        B() {
            return dc.Aa
        }
    }
    var Ac;
    class ud extends rd {
        constructor(a) {
            super();
            sa.assert(a instanceof gc);
            this.V = a;
            id(this, "FA v[" + a.ha() + "]");
            this.g = {
                p: "FA",
                v: a.$()
            }
        }
        ia() {
            return a=>a instanceof $c && a.value.every(c=>this.V.matches(c))
        }
        toString() {
            return "array(" + this.V.toString() + ")"
        }
        B() {
            return this.V
        }
        ff() {
            return this.V
        }
    }
    class xd extends lc {
        constructor(a, c) {
            super();
            this.j = a;
            this.V = c;
            var q = a.$();
            const E = c.$();
            q = tb(q.p, E.p);
            id(this, q + " u[" + a.ha() + "," + c.ha() + "]");
            this.g = {
                p: q,
                u: [a.$(), c.$()]
            }
        }
        ia() {
            const a = this.j.ia()
              , c = this.V.ia();
            return q=>a(q) || c(q)
        }
        I() {
            const a = this.j.I()
              , c = this.V.I();
            return new xd(a,c)
        }
        B() {
            const a = this.j.B()
              , c = this.V.B()
              , q = a.fa;
            return q === c.fa ? new gc(new xd(a.U,c.U),q) : dc.Aa
        }
    }
    class yd extends lc {
        constructor(a, c) {
            super();
            this.j = a;
            this.V = c;
            var q = a.$();
            const E = c.$();
            q = q.p.startsWith(E.p) ? q.p : E.p.startsWith(q.p) ? E.p : q.p.charAt(0) === E.p.charAt(0) ? q.p.charAt(0) : "";
            id(this, q + " i[" + a.ha() + "," + c.ha() + "]");
            this.g = {
                p: q,
                i: [a.$(), c.$()]
            }
        }
        ia() {
            const a = this.j.ia()
              , c = this.V.ia();
            return q=>a(q) && c(q)
        }
    }
    class zd extends lc {
        constructor(a, c) {
            super();
            this.j = a;
            this.V = c;
            var q = a.$();
            const E = c.$();
            q = q.p.startsWith(E.p) ? q.p : E.p.startsWith(q.p) ? E.p : q.p.charAt(0) === E.p.charAt(0) ? q.p.charAt(0) : "";
            id(this, q + " d[" + a.ha() + "," + c.ha() + "]");
            this.g = {
                p: q,
                d: [a.$(), c.$()]
            }
        }
        ia() {
            const a = this.j.ia()
              , c = this.V.ia();
            return q=>a(q) && !c(q)
        }
    }
    const Ad = {};
    function fc(a) {
        var c = Ad[a];
        if (c)
            return c;
        c = rb(a);
        c = jc(c);
        return Ad[a] = c
    }
    function jc(a) {
        var c = a.p;
        if ("" === c)
            return oc;
        if (a.u)
            return c = jc(a.u[0]),
            a.u.slice(1).reduce((q,E)=>new xd(q,jc(E)), c);
        if (a.i)
            return c = jc(a.i[0]),
            a.i.slice(1).reduce((q,E)=>new yd(q,jc(E)), c);
        if (a.d)
            return new zd(jc(a.d[0]),jc(a.d[1]));
        switch (c.charAt(0)) {
        case "A":
            if ("Q{http://www.w3.org/2001/XMLSchema}numeric" === a.n)
                return uc;
            if (a.m) {
                a = a.m;
                if (3 === a.length && a.some(q=>"AO" === q.p) && a.some(q=>"AD" === q.p) && a.some(q=>"AF" === q.p))
                    return uc;
                sa.la("Unhandled atomic union type")
            } else
                return new nc(La.codes[c]);
            break;
        case "F":
            switch (c) {
            case "FA":
                return a.v ? new ud(ic(a.v)) : Ac;
            case "FM":
                return a.k && a.v ? new td(jc(a.k),ic(a.v)) : yc;
            default:
                return a.a ? (c = a.a.map(ic),
                a = a.r ? ic(a.r) : dc.Aa,
                new dd(c,a)) : wc
            }
        case "N":
            if ("N" === c)
                return qc;
            c = {
                ND: 9,
                NE: 1,
                NA: 2,
                NT: 3,
                NC: 8,
                NP: 7,
                NN: 13
            }[c];
            return a.n ? (a = a.n,
            /\}\*$/.test(a) ? new pd(c,a.substring(2, a.length - 2)) : /^\*:/.test(a) ? new od(c,a.substring(2)) : new nd(c,La.XS.QName.fromEQName(a))) : a.e ? (a = jc(a.e),
            new qd(a)) : new Fc(c);
        case "E":
            return Cc
        }
    }
    const Bd = {
        IDREFS: "ASNTNCR",
        ENTITIES: "ASNTNCE",
        NMTOKENS: "ASNTK"
    }
      , Tc = {};
    var Sc, Mc, Nc, Oc, Pc, Qc, Rc;
    // Input 22
    var sd = function() {
        function a(e, k) {
            sa.assert(e instanceof lc);
            sa.assert(k instanceof lc);
            const v = e.ha() + "<>" + k.ha()
              , t = g[v];
            if (t)
                return t;
            e = H(e, k);
            return g[v] = e
        }
        function c(e, k) {
            sa.assert(e instanceof lc);
            sa.assert(k instanceof lc);
            switch (a(e, k)) {
            case 0:
            case 1:
                return e;
            case 2:
                return k;
            case 3:
            case 4:
                return e = e.$(),
                k = k.$(),
                jc({
                    p: tb(e.p, k.p),
                    u: [e, k]
                })
            }
        }
        function q(e, k) {
            sa.assert(e instanceof lc);
            sa.assert(k instanceof lc);
            switch (a(e, k)) {
            case 0:
            case 1:
                return k;
            case 2:
                return e;
            case 3:
                return e = e.$(),
                k = k.$(),
                jc({
                    p: e.p.startsWith(k.p) ? e.p : k.p.startsWith(e.p) ? k.p : e.p.charAt(0) === k.p.charAt(0) ? e.p.charAt(0) : "",
                    i: [e, k]
                });
            case 4:
                return Cc
            }
        }
        function E(e, k) {
            return 0 === e && 0 === k ? 0 : 0 !== e && 1 !== e || 0 !== k && 1 !== k ? 0 !== e && 2 !== e || 0 !== k && 2 !== k ? 4 === e || 4 === k ? 4 : 3 : 2 : 1
        }
        function H(e, k) {
            function v(b, d) {
                return (b || "") === (d || "") ? 0 : b && !d ? 2 : d && !b ? 1 : 4
            }
            function t(b) {
                return 1 === b ? 2 : 2 === b ? 1 : b
            }
            function C(b) {
                return b.n || b.e || b.u || b.i || b.d
            }
            var m = e.$();
            const f = k.$()
              , A = e.ha()
              , O = k.ha();
            if ("F" === m.p) {
                if (!(e instanceof rd && k instanceof rd))
                    return 3;
                sa.assert(e.Nb);
                return e.Nb(k)
            }
            if (A === O)
                return 0;
            if (e instanceof Dc)
                return 2;
            if (k instanceof Dc)
                return 1;
            if (kd(e))
                return kd(k) ? 0 : /^A[ODF]/.test(f.p) ? 1 : "A" === f.p || "" === f.p ? 2 : 4;
            if (kd(k))
                return t(H(k, e));
            if (m.p === f.p) {
                if (jd(e))
                    return m.u && f.u ? 3 : m.e && f.e ? v(m.e, f.e) : m.n && f.n ? v(m.n, f.n) : C(m) && C(f) ? 4 : C(m) && !C(f) ? 2 : C(f) && !C(m) ? 1 : 0;
                if (e.pa())
                    return 0;
                if ("FA" === m.p)
                    return e = e.B ? e.B() : dc.Aa,
                    k = k.B ? k.B() : dc.Aa,
                    p(e, k);
                if ("FM" === m.p)
                    return m = a(e.I(), k.I()),
                    k = p(e.aa(), k.aa()),
                    E(m, k);
                if (!(e instanceof rd && k instanceof rd))
                    return 3;
                sa.assert(e.Nb);
                return e.Nb(k)
            }
            return m.p.startsWith(f.p) ? m.u ? 3 : 2 : f.p.startsWith(m.p) ? m.u ? 3 : 1 : 4
        }
        function p(e, k) {
            sa.assert(e instanceof gc);
            sa.assert(k instanceof gc);
            var v = e.fa;
            var t = k.fa;
            v = v === t ? sd.yb : (v | t) === v ? sd.Rb : (v | t) === t ? sd.nc : 0 === (v | t) ? sd.cc : sd.Eg;
            e = a(e.U, k.U);
            return E(v, e)
        }
        const g = {};
        return {
            yb: 0,
            Rb: 1,
            nc: 2,
            Eg: 3,
            cc: 4,
            Nb: a,
            fj: function(e, k) {
                sa.assert(e instanceof lc);
                sa.assert(k instanceof lc);
                e = a(e, k);
                return 0 === e || 2 === e
            },
            Xj: c,
            Md: function(e) {
                sa.assert(0 < e.length);
                return e.slice(1).reduce((k,v)=>c(k, v), e[0])
            },
            Ui: function(e) {
                sa.assert(0 < e.length);
                return e.slice(1).reduce((k,v)=>q(k, v), e[0])
            },
            Lh: p
        }
    }();
    // Input 23
    function Zc(a) {
        return 0 !== (a & 4)
    }
    function Xc(a) {
        return 0 !== (a & 1)
    }
    function Cd(a) {
        let c = 0;
        a.forEach(q=>c |= q);
        5 === c && (c = 7);
        return c
    }
    function hc(a) {
        return {
            0: 1,
            1: 2,
            "?": 3,
            "+": 6,
            "*": 7
        }[a]
    }
    function Dd(a, c) {
        return (Xc(a) && Xc(c) ? 1 : 0) + (1 !== a || 1 !== c ? 2 : 0) + (1 === a && !Zc(c) || 1 === c && !Zc(a) ? 0 : 4)
    }
    function Ed(a) {
        switch (a) {
        case "1":
            return c=>1 === c;
        case "0":
            return c=>0 === c;
        case "?":
            return c=>2 > c;
        case "+":
            return c=>0 < c;
        case "*":
            return ()=>!0
        }
    }
    function wd(a) {
        switch (a) {
        case 1:
            return c=>0 === c;
        case 2:
            return c=>1 === c;
        case 4:
            return c=>1 < c;
        case 3:
            return c=>2 > c;
        case 6:
            return c=>0 < c;
        default:
            return ()=>!0
        }
    }
    function Yc(a) {
        switch (a) {
        case 3:
            return "?";
        case 2:
            return "";
        case 7:
            return "*";
        case 6:
            return "+";
        case 4:
            return "+";
        case 1:
            return "0";
        default:
            return "*"
        }
    }
    ;// Input 24
    function Fd(a, c, q) {
        a = a.expand();
        c = c.expand();
        a = Kb(a);
        c = Kb(c);
        let E, H;
        for (; ; ) {
            E = a.next();
            H = c.next();
            if (null === E)
                return null === H;
            if (null === H || !Gd(E, H, q))
                return !1
        }
    }
    function Gd(a, c, q) {
        var E = ac.Ja;
        if (a === c)
            return !0;
        if (ac.X(a)) {
            if (!ac.X(c) || !ac.ej(a.nodeType, c.nodeType))
                return !1;
            switch (a.nodeType) {
            case 9:
            case 11:
                return Fd(E.Ka(a), E.Ka(c));
            case 1:
                if (!ac.ca(a).equals(ac.ca(c)))
                    return !1;
                const H = E.Ha(a).expand();
                if (H.length !== E.Ha(c).count())
                    return !1;
                for (let p = 0; p < H.length; p++) {
                    const g = H[p]
                      , e = ac.ca(g)
                      , k = e.uri ? e.uri : null;
                    if (!c.hasAttributeNS(k, e.local) || c.getAttributeNS(k, e.local) !== g.value)
                        return !1
                }
                return Fd(E.Ka(a), E.Ka(c), q);
            case 2:
                return ac.ca(a).equals(ac.ca(c)) && a.value === c.value;
            case 13:
                return a.prefix === c.prefix && a.uri === c.uri;
            case 7:
                return a.target === c.target && (q ? q(a.textContent, c.textContent) : a.textContent === c.textContent);
            case 3:
            case 4:
            case 8:
                return q ? q(a.textContent, c.textContent) : a.textContent === c.textContent;
            default:
                throw new F("Unknown node type " + a.nodeType,"SXJS0003");
            }
        } else {
            if (a instanceof $c) {
                if (!(c instanceof $c && c.value.length === a.value.length))
                    return !1;
                for (E = 0; E < a.value.length; E++)
                    if (!Fd(Kb(a.value[E]), Kb(c.value[E]), q))
                        return !1;
                return !0
            }
            if (a instanceof cc) {
                if (!(c instanceof cc))
                    return !1;
                q = a.keys();
                E = c.keys();
                return q.length !== E.length ? !1 : Kb(q).every(function(H) {
                    return c.containsKey(H) && Fd(Kb(a.get(H)), Kb(c.get(H)))
                })
            }
            if (a instanceof ad.XdmFunction || c instanceof ad.XdmFunction)
                throw new F("Function types, other than map(*) or array(*) cannot be tested for equality","FOTY0015");
            if (Hd.tc(a) && Hd.tc(c))
                return !0;
            if (q && Ia(a) && Ia(c))
                return q(a.value, c.value);
            try {
                return a.equals(c)
            } catch (H) {
                return !1
            }
        }
    }
    function Id(a, c, q) {
        let E = a.next()
          , H = c.next();
        for (; ; ) {
            if (null === E)
                return null === H ? 0 : -1;
            if (null === H)
                return 1;
            if (q)
                if (Gd(E, H, q.equals))
                    E = a.next(),
                    H = c.next();
                else
                    return Hd.tc(E) ? -1 : /^AS/.test(E.code) && /^AS/.test(H.code) ? q.compare(E.value, H.value) : E.compareTo(H);
            else if (Gd(E, H))
                E = a.next(),
                H = c.next();
            else
                return Hd.tc(E) ? -1 : E.compareTo(H)
        }
    }
    ;// Input 25
    const Hd = function() {
        function a(D, y) {
            return D.equals(y)
        }
        function c(D, y) {
            return D.compareTo(y)
        }
        function q(D) {
            return null === D
        }
        function E(D) {
            return (z.double.matches(D) || z.float.matches(D)) && isNaN(D.toNumber())
        }
        function H(D, y) {
            return function(I, R) {
                return y(I) || y(R) ? y(I) ? y(R) : !1 : D(I, R)
            }
        }
        function p(D, y) {
            return function(I, R) {
                return y(I) || y(R) ? y(I) ? y(R) ? 0 : -1 : 1 : D(I, R)
            }
        }
        function g(D, y) {
            return null === D ? NaN : z.numeric.matches(D) ? D.toNumber() : y ? z.double.fromString(D.toString()).toNumber() : z.double.cf(D.toString()).toNumber()
        }
        function e(D) {
            return function(y, I) {
                y = g(y, D);
                I = g(I, D);
                return isNaN(y) ? isNaN(I) ? 0 : -1 : isNaN(I) ? 1 : y - I
            }
        }
        function k(D) {
            return function(y, I) {
                y = g(y, D);
                I = g(I, D);
                return isNaN(y) ? isNaN(I) : isNaN(I) ? !1 : 0 === y - I
            }
        }
        function v(D, y) {
            return function(I, R) {
                I = I.toString();
                R = R.toString();
                var M = D(I.toLowerCase(), R.toLowerCase());
                if (0 === M) {
                    for (M = 0; M < I.length; M++)
                        if (I.charAt(M) !== R.charAt(M))
                            return y === (I.charAt(M) === I.charAt(M).toLowerCase()) ? -1 : 1;
                    return 0
                }
                return M
            }
        }
        function t(D) {
            return function(y, I) {
                return Ia(y) && Ia(I) ? D(y.value, I.value) : y.equals(I)
            }
        }
        function C(D) {
            return function(y, I) {
                return Ia(y) && Ia(I) ? D(y.value, I.value) : y.compareTo(I)
            }
        }
        function m(D, y) {
            const I = D.split("|");
            if ("DESC" === I[0]) {
                const ca = m(D.slice(5), y);
                return {
                    equals: ca.equals,
                    compare: function(ea, ja) {
                        return ca.compare(ja, ea)
                    }
                }
            }
            const R = {
                equals: null,
                compare: null
            };
            let M;
            switch (I[0]) {
            case "NC":
                return R.equals = k(!1),
                R.compare = e(!1),
                R;
            case "QUNC":
                return R.equals = k(!0),
                R.compare = e(!0),
                R;
            case "DblSC":
                return R.equals = H(a, E),
                R.compare = p(p(c, E), q),
                R;
            case "CCC":
                return R.equals = t(qa().equals),
                R.compare = p(C(qa().compare), q),
                R;
            case "TEXT":
                return D = I[1] || "http://www.w3.org/2005/xpath-functions/collation/codepoint",
                M = B(D, y),
                ma(M, D),
                R.equals = H(function(ca, ea) {
                    return M.equals(ca.toString(), ea.toString())
                }, q),
                R.compare = p(function(ca, ea) {
                    return C(M.compare)(z.string.R(ca), z.string.R(ea))
                }, q),
                R;
            case "CAVC":
            case "DecSC":
            case "GAC":
            case "AtSC":
            case "CalVC":
                return {
                    equals: H(a, q),
                    compare: p(p(c, E), q)
                };
            case "EQC":
                return R.equals = H(a, q),
                R.compare = function(ca, ea) {
                    return R.equals(ca, ea) ? 0 : 1
                }
                ,
                R;
            case "CAC":
                return D = I[1] || "http://www.w3.org/2005/xpath-functions/collation/codepoint",
                M = B(D, y),
                ma(M, D),
                R.equals = function(ca, ea) {
                    return M.equals(ca.toString(), ea.toString())
                }
                ,
                R.compare = function(ca, ea) {
                    return M.compare(ca.toString(), ea.toString())
                }
                ,
                R;
            default:
                throw new F("Unknown comparer " + D,"SXJS0003");
            }
        }
        function f(D, y) {
            const I = y.fixed.ka;
            let R = null;
            D.comp && (R = D.comp,
            R = R.replace(/^DESC\|/, ""));
            let M = I.qc(I.da(D, "collation"), y).next()
              , ca = I.qc(I.da(D, "order"), y).next()
              , ea = I.qc(I.da(D, "lang"), y).next()
              , ja = I.qc(I.da(D, "caseOrder"), y).next();
            D = I.qc(I.da(D, "dataType"), y).next();
            ja = null === M && null !== ja ? ja.toString() : "#default";
            try {
                ea = null === M && null !== ea && "" !== ea.toString() ? z.language.fromString(ea.toString()) : null
            } catch (Y) {
                throw new F("@lang: " + Y.message,"XTDE0030");
            }
            "CalVC" === R && (D = null);
            ca = null === ca ? "ascending" : ca.toString();
            D = null === D ? null : D.toString();
            M = null === M ? null === ea ? "http://www.w3.org/2005/xpath-functions/collation/codepoint" : "http://www.w3.org/2013/collation/UCA?lang=" + ea.toString() : M.toString();
            return {
                Dd: R,
                collation: M,
                order: ca,
                lang: ea,
                Ye: ja,
                dataType: D
            }
        }
        function A(D, y) {
            return O(f(D, y), y)
        }
        function O(D, y) {
            function I(M) {
                return "descending" === D.order ? function(ca, ea) {
                    return M(ea, ca)
                }
                : M
            }
            y = B(D.collation, y);
            ma(y, D.collation);
            y = y.compare;
            const R = "#default" !== D.Ye ? v(y, "lower-first" === D.Ye) : C(y);
            if ("number" === D.dataType)
                return I(e(!1));
            if ("text" === D.dataType)
                return I(p(function(M, ca) {
                    return R(z.string.R(M), z.string.R(ca))
                }, q));
            if (D.Dd) {
                y = D.Dd;
                if ("DblSC" === y)
                    return I(p(p(c, E), q));
                if ("CalVC" === y || "DecSC" === y)
                    return I(p(c, q));
                if ("CCC" === y)
                    return I(p(R, q))
            }
            return I(R)
        }
        function b(D, y) {
            switch (D) {
            case "=":
            case "eq":
                return 0 === y;
            case "<":
            case "lt":
                return 0 > y;
            case ">":
            case "gt":
                return 0 < y;
            case ">=":
            case "ge":
                return 0 <= y;
            case "<=":
            case "le":
                return 0 >= y;
            case "!=":
            case "ne":
                return 0 !== y;
            default:
                throw new F("Unknown operator " + D,"SXJS0003");
            }
        }
        function d(D, y) {
            return D.map(function(I) {
                var R = y.fixed.ka;
                I = R.da(I, "dataType");
                R = null === I ? null : R.evaluate(I, y).next();
                return "number" === R ? function(M) {
                    return null === M ? null : z.double.cf(M.toString())
                }
                : "text" === R ? function(M) {
                    return null === M ? null : z.string.R(M)
                }
                : function(M) {
                    return M
                }
            })
        }
        function l(D, y) {
            return D.substring(0, y.length) === y
        }
        function r(D, y) {
            return D.substring(D.length - y.length) === y
        }
        function n(D, y) {
            return y && (y = y.next()) ? y.toString() : D.collation || cd.hg(D, "defaultCollation")
        }
        function B(D, y) {
            y = D ? l(D, "http://www.w3.org/2013/collation/UCA") && 36 < D.length ? W(D, D.substring(37), y) : l(D, "http://saxon.sf.net/collation") && 29 < D.length ? W(D, D.substring(30), y) : y.fixed.options.Ac[D] : qa();
            if (!y)
                throw new F("Unrecognized collation " + D,"FOCH0002");
            return y
        }
        function W(D, y) {
            if ("" === y)
                y = qa();
            else if ("strength=secondary" === y || "strength=2" === y)
                y = L();
            else {
                const I = {};
                y.split(";").forEach(function(M) {
                    M = M.split("=");
                    I[M[0]] = M[1]
                });
                y = {};
                if ("no" === I.fallback)
                    throw new F("Unsupported collation " + D,"FOCH0002");
                if (I.strength)
                    if ("primary" === I.strength || "1" === I.strength)
                        y.sensitivity = "base";
                    else if ("secondary" === I.strength || "2" === I.strength)
                        y.sensitivity = "accent";
                    else if ("tertiary" === I.strength || "3" === I.strength)
                        y.sensitivity = "variant";
                    else if ("quaternary" === I.strength || "4" === I.strength || "identical" === I.strength || "5" === I.strength)
                        y.sensitivity = "variant",
                        y.ignorePunctuation = !1;
                if (I.caseFirst) {
                    let M = I.caseFirst;
                    ["upper", "lower", "false"].includes(M) || (M = "false");
                    y.caseFirst = M
                }
                "yes" === I.numeric && (y.numeric = !0);
                "blanked" === I.alternate && (y.ignorePunctuation = !0);
                const R = new Intl.Collator(I.lang,y);
                y = {
                    equals: function(M, ca) {
                        return 0 === R.compare(M, ca)
                    },
                    compare: function(M, ca) {
                        return R.compare(M, ca)
                    },
                    startsWith: function(M, ca) {
                        return M.length < ca.length ? !1 : 0 === R.compare(M.substring(0, ca.length), ca)
                    },
                    endsWith: function(M, ca) {
                        return M.length < ca.length ? !1 : 0 === R.compare(M.substring(M.length - ca.length), ca)
                    },
                    indexOf: function(M, ca) {
                        if (M.length < ca.length)
                            return -1;
                        for (let ea = 0; ea <= M.length - ca.length; ea++)
                            if (0 === R.compare(M.substring(ea, ea + ca.length), ca))
                                return ea;
                        return -1
                    },
                    contains: function(M, ca) {
                        if (M.length < ca.length)
                            return !1;
                        for (let ea = 0; ea <= M.length - ca.length; ea++)
                            if (0 === R.compare(M.substring(ea, ea + ca.length), ca))
                                return !0;
                        return !1
                    },
                    collationKey: function(M) {
                        return M
                    }
                }
            }
            if (!y)
                throw new F("Unrecognized collation " + D,"FOCH0002");
            return y
        }
        function ma(D, y) {
            if (!D.hasOwnProperty("compare") || !D.hasOwnProperty("equals"))
                throw new F("Collation " + y + " cannot be used for sorting","XTDE1035");
        }
        function qa() {
            return {
                equals: function(D, y) {
                    return D === y
                },
                compare: function(D, y) {
                    return za(D, y)
                },
                contains: function(D, y) {
                    return -1 !== D.indexOf(y)
                },
                startsWith: function(D, y) {
                    return l(D, y)
                },
                endsWith: function(D, y) {
                    return r(D, y)
                },
                indexOf: function(D, y) {
                    return D.indexOf(y)
                },
                collationKey: function(D) {
                    return D
                }
            }
        }
        function L() {
            function D(y) {
                return y ? (y + "").toUpperCase() : ""
            }
            return {
                equals: function(y, I) {
                    return D(y) === D(I)
                },
                compare: function(y, I) {
                    return za(D(y), D(I))
                },
                contains: function(y, I) {
                    return -1 !== D(y).indexOf(D(I))
                },
                startsWith: function(y, I) {
                    return l(D(y), D(I))
                },
                endsWith: function(y, I) {
                    return r(D(y), D(I))
                },
                indexOf: function(y, I) {
                    return D(y).indexOf(D(I))
                },
                collationKey: function(y) {
                    return D(y)
                }
            }
        }
        function aa(D) {
            return {
                equals: function(y, I) {
                    return D(y) === D(I)
                },
                compare: function(y, I) {
                    return za(D(y), D(I))
                },
                contains: function(y, I) {
                    return -1 != D(y).indexOf(D(I))
                },
                startsWith: function(y, I) {
                    return l(D(y), D(I))
                },
                endsWith: function(y, I) {
                    return r(D(y), D(I))
                },
                indexOf: function(y, I) {
                    return D(y).indexOf(D(I))
                },
                collationKey: function(y) {
                    return D(y)
                }
            }
        }
        const z = La.XS;
        return {
            fe: m,
            ii: A,
            Mg: function() {
                function D(y) {
                    return y.toUpperCase()
                }
                return aa(function(y) {
                    return y ? (y + "").replace(/[a-z]/g, D) : ""
                })
            },
            Ze: L,
            oi: C,
            Sg: qa,
            $c: "http://www.w3.org/2005/xpath-functions/collation/codepoint",
            ri: O,
            yi: t,
            gh: "http://www.w3.org/2010/09/qt-fots-catalog/collation/caseblind",
            gc: function(D, y, I, R, M) {
                sa.assert(R.equals && R.compare);
                const ca = z.numeric.matches
                  , ea = z.untypedAtomic.matches
                  , ja = (x,K)=>ea(x) ? ea(K) ? z.string.R(x) : ca(K) ? z.double.R(x) : "AQ" === K.code ? La.XS.QName.R(x, cd.Wd(M, !1)) : La.codes[K.code].R(x) : x
                  , Y = "=" === I ? R.equals : "!=" === I ? (x,K)=>!R.equals(x, K) : (x,K)=>b(I, R.compare(x, K));
                let V;
                for (var la; null !== (V = D.next()); ) {
                    const x = Kb(y);
                    for (; null !== (la = x.next()); ) {
                        const K = ja(V, la);
                        la = ja(la, V);
                        if (!(ca(K) && isNaN(K.value) || ca(la) && isNaN(la.value)) && Y(K, la))
                            return Xb(!0)
                    }
                }
                return Xb(!1)
            },
            Ki: function(D) {
                return {
                    equals: function(y, I) {
                        const R = z.numeric.matches;
                        return R(y) || R(I) ? z.numeric.xe(y).toNumber() === z.numeric.xe(I).toNumber() : D.equals(y, I)
                    },
                    compare: D.compare
                }
            },
            df: function(D, y, I) {
                return B(n(D, y), I)
            },
            eg: B,
            Xb: function(D, y, I, R) {
                y = n(D, y);
                R = B(y, R)[I];
                if (!R)
                    throw new F("Collation " + y + " has no " + I + " method","FOCH0002",D);
                return R
            },
            Mi: d,
            jg: "http://www.w3.org/2005/xpath-functions/collation/html-ascii-case-insensitive",
            tc: E,
            Jj: f,
            Kj: function(D) {
                const y = cd.Sa(D)
                  , I = cd.qb(D, "sortKey");
                return R=>{
                    const M = Sb(y(R))
                      , ca = []
                      , ea = I.map(x=>A(x, R))
                      , ja = I.map(cd.Sa)
                      , Y = d(I, R)
                      , V = R.ba(!1);
                    V.qa = "sort key";
                    V.focus = M;
                    let la = 0;
                    M.forEachItem(function(x) {
                        const K = I.map(function(U, ha) {
                            return Y[ha](ja[ha](V).next())
                        });
                        ca.push({
                            item: x,
                            keys: K,
                            Od: la++
                        })
                    });
                    ca.sort(function(x, K) {
                        for (let ha = 0; ha < ea.length; ha++) {
                            var U = x.keys[ha];
                            const T = K.keys[ha];
                            if (null !== U || null !== T) {
                                if (null === U || null === T)
                                    return null === U ? -1 : 1;
                                U = ea[ha](U, T);
                                if (0 !== U)
                                    return U
                            }
                        }
                        return x.Od > K.Od ? 1 : x.Od === K.Od ? 0 : -1
                    });
                    return Kb(ca.map(x=>x.item))
                }
            },
            wf: b,
            Th: function(D, y) {
                switch (D) {
                case "=":
                case "eq":
                    return y;
                case "!=":
                case "ne":
                    return !y;
                case "<":
                case "lt":
                case ">":
                case "gt":
                case ">=":
                case "ge":
                case "<=":
                case "le":
                    throw new F("Operator " + D + " not allowed for unordered types","SXJS0003");
                default:
                    throw new F("Unknown operator " + D,"SXJS0003");
                }
            },
            xf: function(D, y) {
                function I(ja) {
                    return Ia(ja) ? M(ja.matchKey()) : ja.matchKey()
                }
                const R = new cc
                  , M = D.collationKey;
                if (!M)
                    throw new F("Collation is unsuitable for keys and grouping","XTDE1110");
                const ca = {
                    Rc: function(ja, Y) {
                        return Fd(Kb(ja), Kb(Y), D.equals)
                    },
                    hash: function(ja) {
                        return ja.map(I).join()
                    }
                }
                  , ea = {
                    Rc: function(ja, Y) {
                        return I(ja) === I(Y)
                    },
                    hash: function(ja) {
                        return I(ja)
                    }
                };
                R.options = y ? ca : ea;
                return R
            },
            Mj: "http://www.w3.org/2013/collation/UCA",
            Zh: "http://www.w3.org/xslts/collation/caseblind"
        }
    }();
    // Input 26
    var Jd = function() {
        var a = {};
        return {
            register: function(c, q) {
                a[c] = q
            },
            find: function(c) {
                return a[c]
            },
            dl: a
        }
    }();
    // Input 27
    var Kd = function() {
        function a(c) {
            const q = ac.Ja
              , E = {
                "p.any": function() {
                    return function() {
                        return !0
                    }
                },
                "p.never": function() {
                    return function() {
                        return !1
                    }
                },
                "p.booleanExp": function(H) {
                    const p = cd.Sa(H);
                    return function(g, e) {
                        e = e.ba();
                        e.focus = Rb(g);
                        return cd.Fd(p(e))
                    }
                },
                "p.genNode": function(H) {
                    const p = cd.Sa(H);
                    let g;
                    if ("slash" === H.C[0].N) {
                        H = cd.ti(H.C[0]);
                        let e = H.C[0];
                        for (; ["filter", "subscript"].includes(e.N); )
                            e = e.C[0];
                        "axis" === e.N && "child" === e.name && (e.name = "self",
                        g = cd.ib(H))
                    }
                    return function(e, k) {
                        if (!ac.X(e))
                            return !1;
                        const v = ac.Ja.Ya(e);
                        let t;
                        for (var C; ; ) {
                            t = v.next();
                            if (null == t)
                                return !ac.jf(C) && g ? (k = k.ba(!1),
                                k.focus = Rb(C),
                                k.Mb = [],
                                g(k).some(m=>ac.isSameNode(m, e))) : !1;
                            C = k.ba(!1);
                            C.focus = Rb(t);
                            C.Mb = [];
                            if (p(C).some(m=>ac.isSameNode(m, e)))
                                return !0;
                            C = t
                        }
                    }
                },
                "p.genPos": function(H) {
                    const p = fc(H.test).ia()
                      , g = cd.Sa(H);
                    return function(e, k) {
                        if (!p(e))
                            return !1;
                        const v = k.fixed.ka;
                        k = k.ba(!1);
                        var t = q.Ka(ac.Xa(e)).filter(p);
                        k.focus = Sb(t);
                        for (k.Mb = []; null != (t = k.focus.next()); )
                            if (t === e && v.Fd(g(k)))
                                return !0;
                        return !1
                    }
                },
                "p.nodeSet": function(H) {
                    const p = cd.Sa(H);
                    return function(g, e) {
                        return p(e).some(k=>k === g)
                    }
                },
                "p.nodeTest": function(H) {
                    return fc(H.test).ia()
                },
                "p.simPos": function(H) {
                    const p = fc(H.test).ia()
                      , g = parseInt(H.pos, 10);
                    return function(e) {
                        return p(e) && q.Oc(e).filter(p).count() === g - 1
                    }
                },
                "p.venn": function(H) {
                    var p = H.C
                      , g = a(p[0])
                      , e = a(p[1]);
                    H = H.op;
                    switch (H) {
                    case "union":
                        return function(k, v) {
                            return g(k, v) || e(k, v)
                        }
                        ;
                    case "intersect":
                        return function(k, v) {
                            return g(k, v) && e(k, v)
                        }
                        ;
                    case "except":
                        return function(k, v) {
                            return g(k, v) && !e(k, v)
                        }
                        ;
                    default:
                        throw new F("unknown op " + H,"SXJS0003");
                    }
                },
                "p.withCurrent": function(H) {
                    const p = a(H.C[0]);
                    return function(g, e) {
                        e = e.ba(!0);
                        e.oa[0] = [g];
                        return p(g, e)
                    }
                },
                "p.withPredicate": function(H) {
                    H = H.C;
                    const p = a(H[0])
                      , g = cd.ib(H[1]);
                    return function(e, k) {
                        if (!p(e, k))
                            return !1;
                        k = k.ba(!1);
                        k.focus = Rb(e);
                        k.Mb = [];
                        return cd.Fd(g(k))
                    }
                },
                "p.withUpper": function(H) {
                    const p = H.C
                      , g = a(p[0])
                      , e = a(p[1])
                      , k = H.axis;
                    return "parent" === k ? "true" === H.upFirst ? function(v, t) {
                        const C = ac.Xa(v);
                        return C && e(C, t) && g(v, t)
                    }
                    : function(v, t) {
                        const C = ac.Xa(v);
                        return C && g(v, t) && e(C, t)
                    }
                    : function(v, t) {
                        if (!g(v, t))
                            return !1;
                        v = ac.Ng[k](v);
                        let C;
                        for (; null !== (C = v.next()); )
                            if (e(C, t))
                                return !0;
                        return !1
                    }
                }
            }[c.N];
            if (E)
                return E(c);
            throw new F("Unimplemented pattern " + c.N,"SXJS0002");
        }
        return {
            od: a,
            matches: function(c, q, E) {
                E.ub.push(null);
                c = c(q, E);
                E.ub.pop();
                return c
            }
        }
    }();
    // Input 28
    var Ld = function() {
        function a(E, H, p, g) {
            function e(r) {
                for (var n = [], B = r.length - 1; 0 <= B; B--)
                    n.push({
                        Qd: r[B],
                        action: r[B].C[1],
                        pattern: Kd.od(r[B].C[0])
                    });
                return n
            }
            function k(r) {
                r._saxonAccumulators || (r._saxonAccumulators = {});
                r._saxonAccumulators[p] = {};
                var n = v(O, r);
                n && (l = C(n, r));
                r._saxonAccumulators[p].pre = l;
                q.Ka(r).forEachItem(k);
                (n = v(b, r)) && (l = C(n, r));
                r._saxonAccumulators[p].post = l
            }
            function v(r, n) {
                for (var B = 0, W = r.length; B < W; B++)
                    if (Kd.matches(r[B].pattern, n, d))
                        return r[B];
                return null
            }
            function t(r) {
                return {
                    visibility: "PRIVATE",
                    Za: r,
                    actor: r,
                    We: r.binds.split(" ").map(function(n) {
                        return parseInt(n, 10)
                    })
                }
            }
            function C(r, n) {
                var B = g.ba(!0);
                B.focus = Rb(n);
                B.oa = [l];
                B.sa = t(H);
                B.qa = "accumulator";
                return m.evaluate(r.action, B).expand()
            }
            var m = g.fixed.ka
              , f = m.qb(H, "pre")[0]
              , A = m.qb(H, "post")[0]
              , O = e(m.qb(f, "accRule"))
              , b = e(m.qb(A, "accRule"))
              , d = g.ba(!0);
            d.focus = Rb(E);
            d.oa = [];
            d.sa = t(H);
            var l = m.evaluate(m.da(H, "init"), d).expand();
            k(E)
        }
        function c(E, H, p, g, e) {
            var k = g.fixed.ka.ke(E, g).Gb[H];
            if (!k)
                throw new F("Unknown accumulator " + H,"XTDE3340");
            if (g.Ge && !g.Ge.some(function(t) {
                return t === H
            }))
                throw new F("Inapplicable accumulator " + H,"XTDE3362");
            if (!ac.X(p))
                throw new F("Cannot evaluate accumulator: context item is not a node","XTTE3360");
            if (2 === p.nodeType || 13 === p.nodeType)
                throw new F("Accumulators are not available on attribute or namespace nodes","XTTE3360");
            if (p._saxonOriginal)
                return c(E, H, p._saxonOriginal, g, e);
            E = k.vg;
            if (!p._saxonAccumulators || !p._saxonAccumulators.hasOwnProperty(E)) {
                var v = ac.rc(p);
                v._saxonAccumulators || (v._saxonAccumulators = {});
                v._saxonAccumulators[E] || (v._saxonAccumulators[E] = {});
                if (v._saxonAccumulators[E]["under construction"])
                    throw new F("Circular definition of accumulator " + E,"XTDE3400");
                v._saxonAccumulators[E]["under construction"] = 1;
                a(v, k.gi, E, g);
                delete v._saxonAccumulators[E]["under construction"]
            }
            return p._saxonAccumulators[E][e]
        }
        var q = ac.Ja;
        return {
            fi: function(E, H, p, g) {
                return c(E, H, p, g, "pre")
            },
            ei: function(E, H, p, g) {
                return c(E, H, p, g, "post")
            }
        }
    }();
    // Input 29
    var Md = function() {
        function a(t, C, m, f, A=null) {
            const O = k.string.fromString(C);
            if (t && t.containsKey(O)) {
                t = t.get(O);
                if ("function" === m) {
                    C = new dd([dc.ec],dc.ec);
                    if (1 === t.length && C.ia()(t[0]))
                        return t[0];
                    throw new F("Option " + O + " must be a function(xs:string) as xs:string","XPTY0004");
                }
                if (1 === t.length && La.type[m].matches(t[0])) {
                    if (A && 0 > A.indexOf(t[0].value))
                        throw new F("Invalid value " + O + "=" + t[0],"FOJS0005");
                    return t[0].value
                }
                throw new F("Invalid option: " + C + ": must be " + m,"XPTY0004");
            }
            return f
        }
        function c(t, C) {
            function m(B) {
                throw new F(B,"FOJS0001");
            }
            function f() {
                return n = A()
            }
            function A() {
                for (n = ""; ; ) {
                    if (r >= t.length)
                        return ["eof"];
                    var B = t.charAt(r++);
                    if (!/[ \n\r\t]/.test(B))
                        break
                }
                switch (B) {
                case "[":
                case "{":
                case "]":
                case "}":
                case ":":
                case ",":
                    return [B];
                case '"':
                    for (B = !1; ; ) {
                        const W = t.charAt(r++);
                        if ('"' !== W || B)
                            n += W,
                            B = "\\" === W && !B;
                        else
                            return ["string", n];
                        r >= t.length && m("Unclosed quotes in string literal")
                    }
                case "-":
                case "0":
                case "1":
                case "2":
                case "3":
                case "4":
                case "5":
                case "6":
                case "7":
                case "8":
                case "9":
                    for (n += B; r < t.length; )
                        if (B = t.charAt(r++),
                        /[0-9\-+.eE]/.test(B))
                            n += B;
                        else {
                            r--;
                            break
                        }
                    return ["number", /^-?(0|[1-9][0-9]*)(\.[0-9]+)?([eE][+-]?[0-9]+)?$/.test(n) ? n : m("Invalid JSON number " + n)];
                case "t":
                case "f":
                case "n":
                    for (n += B; ; )
                        if (B = t.charAt(r),
                        "a" <= B && "z" >= B) {
                            if (n += B,
                            ++r >= t.length)
                                break
                        } else
                            break;
                    if (["true", "false", "null"].includes(n))
                        return [n];
                    m("Unknown constant " + n);
                    break;
                default:
                    return m("Unexpected character '" + B + "' (" + Da(B) + ") at position " + r),
                    -1
                }
            }
            function O(B) {
                n[0] !== B && m("Expected " + B + ", found " + n[0])
            }
            function b(B) {
                return n[0] === B ? (f(),
                !0) : !1
            }
            function d(B) {
                if (n[0] === B)
                    return f(),
                    !0;
                if ("," === n[0])
                    return f(),
                    !1;
                m("Expected ',' or '" + B + "', found '" + n[0] + "'")
            }
            function l() {
                switch (n[0]) {
                case "[":
                    f();
                    C.Qh();
                    if (!b("]")) {
                        do
                            l();
                        while (!d("]"))
                    }
                    C.ah();
                    break;
                case "{":
                    f();
                    C.Rh();
                    if (!b("}")) {
                        do
                            O("string"),
                            C.Xg(n[1]),
                            f(),
                            O(":"),
                            f(),
                            l();
                        while (!d("}"))
                    }
                    C.bh();
                    break;
                case "string":
                    C.$g(n[1]);
                    f();
                    break;
                case "number":
                    C.Zg(n[1]);
                    f();
                    break;
                case "true":
                case "false":
                    C.Wg(n[0]);
                    f();
                    break;
                case "null":
                    C.Yg();
                    f();
                    break;
                default:
                    m("Unexpected token " + n[0])
                }
            }
            t = t.replace(/^[\uFEFF]/, "");
            let r = 0
              , n = null;
            n = f();
            l();
            O("eof");
            return C.result()
        }
        function q(t) {
            try {
                return JSON.parse('"' + t + '"')
            } catch (C) {
                throw new F(C.toString(),"FOJS0001");
            }
        }
        function E(t, C) {
            const m = C.Ab
              , f = C.Cd;
            let A;
            A = f ? O=>f.evaluate([[La.XS.string.fromString(H(O))]], m).next().toString() : ()=>"\ufffd";
            t = t.replace(/[\x00-\x08\x0B\x0C\x0E-\x0F\x80-\x9F\uFFFF]/g, A);
            return t = t.replace(/[\uD800-\uDFFF]+/g, O=>{
                let b = "";
                for (let d = 0; d < O.length; d++) {
                    const l = O.charAt(d);
                    b += 1 === d % 2 === "\udc00" > l || d === O.length - 1 && "\udc00" > l ? A(l) : l
                }
                return b
            }
            )
        }
        function H(t) {
            for (t = t.charCodeAt(0).toString(16); 4 > t.length; )
                t = "0" + t;
            return "\\u" + t.toUpperCase()
        }
        function p(t, C) {
            this.g = [];
            this.I = [];
            this.Ab = C;
            a(t, "liberal", "boolean", !1);
            this.Cd = a(t, "fallback", "function", null);
            this.B = a(t, "escape", "boolean", !1);
            this.K = a(t, "duplicates", "string", "use-first", ["reject", "use-first", "use-last"]);
            if (this.B && this.Cd)
                throw new F("parse-json: cannot use fallback with escape:true()","FOJS0005");
        }
        function g(t, C) {
            this.g = [];
            this.K = [];
            this.I = [];
            this.Ab = C;
            a(t, "liberal", "boolean", !1);
            if (a(t, "validate", "boolean", !1))
                throw new F("json-to-xml: validate option not supported in a non-schema-aware processor","FOJS0004");
            this.Cd = a(t, "fallback", "function", null);
            this.B = a(t, "escape", "boolean", !1);
            this.aa = a(t, "duplicates", "string", "use-first", ["reject", "use-first", "retain"]);
            if (this.B && this.Cd)
                throw new F("json-to-xml: cannot use fallback with escape:true()","FOJS0005");
        }
        const e = Zb.Oa
          , k = La.XS
          , v = ac.Ja;
        p.prototype = {
            g: [],
            I: [],
            Ab: null,
            B: !1,
            Cd: null,
            K: "use-first",
            aa: function(t) {
                return this.B ? JSON.stringify(t).replace(/^"|"$/g, "").replace(/\\"/g, '"').replace(/[\uD800-\uDFFF]/g, H) : E(t, this)
            },
            ua: function() {
                return this.g[this.g.length - 1]
            },
            j: function(t) {
                if (0 === this.g.length)
                    this.g.push(t);
                else if (this.ua()instanceof $c)
                    this.ua().value.push(t);
                else {
                    const C = this.ua()
                      , m = k.string.fromString(this.I.pop());
                    if (C.containsKey(m))
                        switch (this.K) {
                        case "reject":
                            throw new F("json-to-xml: duplicate key '" + m.toString() + "'","FOJS0003");
                        case "use-first":
                            return
                        }
                    C.inSituPut(m, t)
                }
            },
            Yg: function() {
                this.j([])
            },
            Wg: function(t) {
                this.j([k.boolean.fromString(t)])
            },
            Zg: function(t) {
                this.j([k.double.fromNumber(parseFloat(t))])
            },
            $g: function(t) {
                this.j([k.string.fromString(this.aa(q(t)))])
            },
            Xg: function(t) {
                this.I.push(this.aa(q(t)))
            },
            Qh: function() {
                this.g.push(new $c([]))
            },
            ah: function() {
                this.j([this.g.pop()])
            },
            Rh: function() {
                this.g.push(new cc)
            },
            bh: function() {
                this.j([this.g.pop()])
            },
            result: function() {
                return void 0 !== this.ua()[0] ? this.ua()[0] : null
            }
        };
        g.prototype = {
            g: [],
            K: [{}],
            I: [],
            Ab: null,
            Cd: null,
            B: !1,
            aa: "use-first",
            V: function(t) {
                return this.B ? JSON.stringify(t).replace(/^"|"$/g, "").replace(/\\"/g, '"').replace(/[\uD800-\uDFFF]/g, H) : E(t, this)
            },
            ua: function() {
                return this.g[this.g.length - 1]
            },
            j: function(t) {
                if (0 === this.g.length)
                    t.setAttribute("xmlns", e),
                    this.g.push(t);
                else {
                    const C = this.ua();
                    if ("map" === C.tagName) {
                        const m = this.K.pop()
                          , f = this.I[this.I.length - 1];
                        if (m in f)
                            switch (this.aa) {
                            case "reject":
                                throw new F("parse-json: duplicate key '" + m.toString() + "'","FOJS0003");
                            case "use-first":
                                return
                            }
                        f[m] = t;
                        t.setAttribute("key", m);
                        this.B && /\\/.test(m.toString()) && t.setAttribute("escaped-key", "true")
                    }
                    C.appendChild(t)
                }
            },
            Yg: function() {
                const t = this.Ab.ja.createElementNS(e, "null");
                this.j(t)
            },
            Wg: function(t) {
                const C = this.Ab.ja.createElementNS(e, "boolean");
                C.appendChild(this.Ab.ja.createTextNode(t.toString()));
                this.j(C)
            },
            Zg: function(t) {
                const C = this.Ab.ja.createElementNS(e, "number");
                C.appendChild(this.Ab.ja.createTextNode(t.toString()));
                this.j(C)
            },
            $g: function(t) {
                const C = this.Ab.ja.createElementNS(e, "string");
                if ("" !== t) {
                    t = this.V(q(t));
                    const m = this.Ab.ja.createTextNode(t);
                    this.B && /\\/.test(t) && C.setAttribute("escaped", "true");
                    C.appendChild(m)
                }
                this.j(C)
            },
            Xg: function(t) {
                this.K.push(this.V(q(t)))
            },
            Qh: function() {
                const t = this.Ab.ja.createElementNS(e, "array");
                this.g.push(t)
            },
            ah: function() {
                this.j(this.g.pop())
            },
            Rh: function() {
                const t = this.Ab.ja.createElementNS(e, "map");
                this.g.push(t);
                this.I.push({})
            },
            bh: function() {
                this.I.pop();
                this.j(this.g.pop())
            },
            result: function() {
                return this.ua()
            }
        };
        return {
            ze: function(t, C, m) {
                return c(t, new p(C,m))
            },
            wj: function(t, C, m) {
                return c(t, new g(C,m))
            },
            Pj: function(t, C) {
                function m(r) {
                    throw new F("Invalid input to xml-to-json(): " + r,"FOJS0006");
                }
                function f(r) {
                    0 !== l.Ec(r).length && m("node " + r.tagName + " must have no element children")
                }
                function A(r) {
                    v.Ka(r).filter(function(n) {
                        return (3 === n.nodeType || 4 == n.nodeType) && n.nodeValue && "" !== Ha.trim(n.nodeValue)
                    }).next() && m("node " + r.tagName + " must have no text content")
                }
                function O(r) {
                    try {
                        return k.boolean.fromString(r).toBoolean()
                    } catch (n) {
                        m("invalid boolean: '" + r + "'")
                    }
                }
                function b(r) {
                    try {
                        JSON.parse('"' + r + '"')
                    } catch (n) {
                        throw new F("invalid escape sequence: " + n.toString(),"FOJS0007");
                    }
                }
                function d(r, n=!0) {
                    if (9 === r.nodeType || 11 === r.nodeType) {
                        var B = l.Ec(r);
                        1 !== B.length && m("document node has " + B.length + " element children");
                        return d(B[0])
                    }
                    if (1 === r.nodeType) {
                        let ma = !1;
                        if (r.namespaceURI === e)
                            switch (v.Ha(r).forEachItem(function(qa) {
                                if (0 > qa.name.indexOf(":") || qa.namespaceURI === e)
                                    "key" === qa.name || "escaped-key" === qa.name ? "escaped-key" === qa.name ? (n || "map" === l.Xa(r).localName || m("@escaped-key is allowed only on children of map"),
                                    O(qa.value) && b(r.getAttribute("key"))) : n || "map" === l.Xa(r).localName || m("@key is allowed only on children of map") : "escaped" === qa.name ? ("string" !== r.localName && m("@escaped is allowed only on string"),
                                    ma = O(qa.value)) : m("invalid attribute " + qa.name)
                            }),
                            r.hasAttribute("escaped-key") && !n && "map" !== l.Xa(r).localName && m("escaped-key is allowed only on children of map"),
                            r.localName) {
                            case "null":
                                return v.Ka(r).filter(function(D) {
                                    return 8 !== D.nodeType && 7 !== D.nodeType
                                }).next() && m("null element must have no content"),
                                "null";
                            case "string":
                                f(r);
                                B = r.textContent;
                                if (ma)
                                    B = B.replace(/^"/g, '\\"').replace(/^[\b]/g, "\\b").replace(/^\f/g, "\\f").replace(/^\n/g, "\\n").replace(/^\r/g, "\\r").replace(/^\t/g, "\\t").replace(/^\//g, "\\/").replace(/([^\\])"/g, '$1\\"').replace(/([^\\])[\b]/g, "$1\\b").replace(/([^\\])\f/g, "$1\\f").replace(/([^\\])\n/g, "$1\\n").replace(/([^\\])\r/g, "$1\\r").replace(/([^\\])\t/g, "$1\\t").replace(/([^\\])\//g, "$1\\/").replace(/[\u0001-\u001F\u007F-\u009F]/g, H),
                                    b(B);
                                else
                                    return JSON.stringify(B).replace(/\//g, "\\/");
                                return '"' + B + '"';
                            case "number":
                                f(r);
                                try {
                                    B = k.double.fromString(r.textContent)
                                } catch (D) {
                                    m("invalid number")
                                }
                                isFinite(B.toNumber()) || m("NaN and INF not allowed");
                                return B.toString();
                            case "boolean":
                                return f(r),
                                O(r.textContent),
                                k.boolean.fromString(r.textContent).toString();
                            case "array":
                                A(r);
                                let qa = "["
                                  , L = "";
                                l.Ec(r).forEach(function(D) {
                                    qa += L + d(D, !1);
                                    L = ","
                                });
                                return qa + "]";
                            case "map":
                                A(r);
                                let aa = "{"
                                  , z = "";
                                var W = {};
                                l.Ec(r).forEach(function(D) {
                                    D.hasAttribute("key") || m("child element of map must have a key");
                                    const y = l.getAttribute(D, "key");
                                    let I = y;
                                    const R = l.getAttribute(D, "escaped-key");
                                    let M = !1;
                                    R && O(R) && (M = !0,
                                    I = q(y));
                                    W[I] && m("duplicate key '" + y + "'");
                                    W[I] = !0;
                                    aa += z + (M ? '"' + y + '"' : JSON.stringify(y).replace(/\//g, "\\/")) + ":" + d(D, !1);
                                    z = ","
                                });
                                return aa + "}";
                            default:
                                m("unknown local name " + r.localName)
                            }
                        else
                            m("wrong namespace " + r.namespaceURI)
                    } else
                        l.X(r) || m("not a node"),
                        Error.g && Error.g(),
                        m("wrong node kind " + r.nodeType)
                }
                const l = ac;
                a(C, "indent", "boolean", !1);
                return d(t)
            }
        }
    }();
    // Input 30
    const Nd = function() {
        function a(p, g, e, k, v) {
            e = "xml" === e ? g.fixed.tb : g.fixed.kc;
            g = g.fixed.vd;
            var t = e[p];
            if (!t || t instanceof F) {
                t = g[p];
                if (!t) {
                    try {
                        t = k()
                    } catch (C) {
                        t = C
                    }
                    g[p] = t
                }
                t = v(t);
                e[p] = t
            }
            if (t instanceof F)
                throw t;
            return t
        }
        function c(p, g) {
            g ||= "utf-8";
            p = void 0 === p.responseText ? p : p.responseText;
            if (g.startsWith("utf") && 0 <= p.indexOf("\ufffd"))
                throw new F("External file contains non-Unicode characters","FOUT1190");
            return p
        }
        function q(p) {
            if (0 <= p.indexOf("\x00"))
                throw new F("External file contains non-XML characters","FOUT1190");
            return p
        }
        function E(p) {
            "\ufeff" === p.charAt(0) && (p = p.substring(1));
            return p
        }
        function H(p, g, e) {
            if ((p = p[0].next()) && ac.ld(p.toString()))
                return p.toString();
            g = g.fixed.ka.Ia(e, g);
            if (null === g || "#UNDEFINED" === g)
                throw new F("No base URI for relative resolution","FODC0002",e);
            return null === p ? null : pa.Fb(p.toString(), g)
        }
        return {
            Lg: H,
            Te: function(p, g, e) {
                try {
                    return H(p, g, e)
                } catch (k) {
                    if (k instanceof F && "XPTY0004" === k.code)
                        throw k;
                    throw new F(k.message,"FOUT1170",e);
                }
            },
            Sf: function(p) {
                if ("" === p)
                    return null;
                if (!["utf-8", "utf-16", "utf-16be", "iso-8859-1"].includes(p.toLowerCase()))
                    throw new F("Unrecognized encoding " + p,"FOUT1190");
                return p
            },
            Qg: q,
            Rg: E,
            Dc: function(p, g) {
                if (0 <= p.indexOf("#"))
                    throw new F("Fragments not supported in external document URIs","FODC0002");
                return a(p, g, "xml", function() {
                    let e;
                    try {
                        e = pa.readFile(p, !0)
                    } catch (k) {
                        if (k instanceof F && "FOUT1190" === k.code)
                            throw new F(k.message,"FODC0002");
                        throw k;
                    }
                    return e
                }, function(e) {
                    if (e instanceof F)
                        return e;
                    e = void 0 === e.responseText ? e : e.responseText;
                    e = E(q(e));
                    e = ac.wc(pa.parseXmlFromString(e));
                    e._saxonBaseUri = p;
                    e._saxonDocUri = p;
                    return e
                })
            },
            Fi: function(p, g) {
                if (0 <= p.indexOf("#"))
                    throw new F("Fragments not supported in text document URIs","FOUT1170");
                return a(p, g, "text", function() {
                    let e;
                    try {
                        e = pa.readFile(p, !0)
                    } catch (k) {
                        if (k instanceof F)
                            throw new F(k.message,"FOUT1170");
                        throw k;
                    }
                    return e
                }, function(e) {
                    if (e instanceof F)
                        return e;
                    let k = void 0 === e.responseText ? e : e.responseText;
                    k = E(k);
                    e.responseText ? e.responseText = k : e = k;
                    return c(e, "utf-8")
                })
            },
            $f: function(p, g, e, k) {
                if (0 <= p.indexOf("#"))
                    throw new F("Fragments not supported in text document URIs","FOUT1170");
                return a(p, g, "text", function() {
                    let v;
                    try {
                        v = pa.readFile(p, !0)
                    } catch (t) {
                        if (t instanceof F && "FOUT1190" === t.code)
                            throw t;
                        throw new F("Cannot retrieve unparsed-text " + p.toString() + " " + t.toString(),"FOUT1170",e);
                    }
                    return v
                }, function(v) {
                    if (v instanceof F)
                        return v;
                    let t = void 0 === v.responseText ? v : v.responseText;
                    t = E(q(t));
                    v.responseText ? v.responseText = t : v = t;
                    return c(v, k)
                })
            },
            Ih: function(p) {
                try {
                    return p(),
                    Xb(!0)
                } catch (g) {
                    if (g instanceof F && "XPTY0004" === g.code)
                        throw g;
                    return Xb(!1)
                }
            }
        }
    }();
    // Input 31
    class Od {
        Ea() {}
        za() {}
        na() {}
        endElement() {}
        text() {}
        wa() {}
        va() {}
        append() {}
        close() {}
    }
    function Pd(a, c) {
        a.g = c;
        return a
    }
    class Qd extends Od {
        constructor() {
            super();
            this.g = null
        }
        Ea(a={}) {
            this.g.Ea(a)
        }
        za() {
            this.g.za()
        }
        na(a, c, q, E={}) {
            this.g.na(a, c, q, E)
        }
        endElement() {
            this.g.endElement()
        }
        text(a, c={}) {
            this.g.text(a, c)
        }
        wa(a, c={}) {
            this.g.wa(a, c)
        }
        va(a, c, q={}) {
            this.g.va(a, c, q)
        }
        append(a, c={}) {
            this.g.append(a, c)
        }
        close() {
            this.g.close()
        }
    }
    function Rd(a, c) {
        0 === a.j ? a.Ob.push(c) : a.oc.appendChild(c)
    }
    class Sd extends Od {
        constructor(a) {
            super();
            this.fd = (this.ra = a) ? ac.Gc(a.ja) : pa.getPlatform().createDocument();
            this.Ob = [];
            this.oc = null;
            this.j = 0;
            this.B = null
        }
        Ea(a={}) {
            if (0 === this.j++) {
                const c = this.oc = this.fd.createDocumentFragment();
                a.BASE_URI && (c._saxonBaseUri = a.BASE_URI);
                this.Ob.push(c)
            } else
                throw new F("Builder.startDoc() not at top level");
        }
        za() {
            0 === --this.j && (this.oc = null)
        }
        na(a, c, q, E={}) {
            var H = this.fd.createElementNS(a.uri, a.toString());
            E.BASE_URI && (H._saxonBaseUri = E.BASE_URI);
            E.ORIGINAL_NODE && (H._saxonOriginal = E.ORIGINAL_NODE);
            E.CALLBACK && E.CALLBACK(H);
            Rd(this, H);
            this.oc = H;
            this.j++;
            this.B = null;
            c.forEach((p,g)=>{
                H.setAttributeNS(g.uri, g.toString(), p.value)
            }
            );
            for (let p in q)
                q.hasOwnProperty(p) && (a = q[p],
                "" === p ? H.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", a) : H.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + p, a))
        }
        endElement() {
            0 === --this.j ? this.oc = null : this.oc = this.oc.parentNode;
            this.B = null
        }
        text(a) {
            this.B ? this.B.appendData(a) : (a = this.fd.createTextNode(a),
            Rd(this, a),
            0 < this.j && (this.B = a))
        }
        wa(a) {
            Rd(this, this.fd.createComment(a));
            this.B = null
        }
        va(a, c) {
            Rd(this, this.fd.createProcessingInstruction(a, c));
            this.B = null
        }
        append(a) {
            if (0 !== this.j)
                throw new F("Builder.append() not at top level");
            this.Ob.push(a)
        }
        result() {
            return this.Ob
        }
        close() {
            super.close()
        }
    }
    function Td(a) {
        if (a.done)
            throw new F("Cannot write to the principal output destination as it has already been closed","XTDE1490");
        if (a.wg)
            throw new F("Cannot write to the principal output destination as it has already been used by xsl:result-document","XTDE1490");
        a.Yh = !0
    }
    class Ud extends Qd {
        constructor(a) {
            super();
            this.done = this.wg = this.Yh = !1;
            this.g = a
        }
        Ea(a={}) {
            super.Ea(a)
        }
        za() {
            super.za()
        }
        na(a, c, q, E={}) {
            Td(this);
            super.na(a, c, q, E)
        }
        endElement() {
            super.endElement()
        }
        text(a, c={}) {
            Td(this);
            super.text(a, c)
        }
        wa(a, c={}) {
            Td(this);
            super.wa(a, c)
        }
        va(a, c, q={}) {
            Td(this);
            super.va(a, c, q)
        }
        append(a, c={}) {
            Td(this);
            super.append(a, c)
        }
        close() {
            this.done = !0;
            this.g && super.close()
        }
    }
    function Vd(a) {
        return new Sd(a)
    }
    class Wd {
        constructor(a) {
            this.lb = a
        }
        createDocumentFragment() {
            return this.lb.createDocumentFragment()
        }
        createElementNS(a, c) {
            const q = this.lb.documentElement;
            "" === a && q && pa.Zb(q) ? c = this.lb.createElement(c) : "http://www.w3.org/1999/xhtml" === a && q && pa.Zb(q) ? (a = c.indexOf(":"),
            c = this.lb.createElement(-1 === a ? c : c.substring(a + 1))) : c = this.lb.createElementNS(a, c);
            return c
        }
        createTextNode(a) {
            return this.lb.createTextNode(a)
        }
        createComment(a) {
            return this.lb.createComment(a)
        }
        createProcessingInstruction(a, c) {
            return this.lb.createProcessingInstruction(a, c)
        }
    }
    function Xd(a, c={}) {
        a.I || (a.j = !1,
        a.g.Ea(c),
        a.I = !0,
        a.B = !0)
    }
    function Yd(a, c) {
        if (null != c)
            if (La.pa(c))
                a.j && a.text(" ", {}),
                a.text(c.toString(), {}),
                a.j = !0;
            else if (c instanceof $c)
                c.flatten(q=>Yd(a, q));
            else {
                if (c instanceof ad.XdmFunction)
                    throw new F("Cannot add a function item to an XDM node tree","SENR0001");
                if (c instanceof cc)
                    throw new F("Cannot add a map to an XDM node tree","SENR0001");
                Zd.Gh(c, a);
                a.j = !1
            }
    }
    class $d extends Qd {
        constructor(a) {
            super();
            this.g = a;
            this.j = this.I = this.B = !1
        }
        Ea(a={}) {
            Xd(this, a);
            this.B = !1
        }
        za() {
            this.j = !1;
            this.g.za()
        }
        na(a, c, q, E={}) {
            Xd(this, E);
            this.g.na(a, c, q, E)
        }
        endElement() {
            this.g.endElement();
            this.j = !1
        }
        text(a, c={}) {
            Xd(this, c);
            super.text(a, c);
            this.j = !1
        }
        wa(a, c={}) {
            Xd(this, c);
            super.wa(a, c);
            this.j = !1
        }
        va(a, c, q={}) {
            Xd(this, q);
            super.va(a, c, q);
            this.j = !1
        }
        append(a, c={}) {
            Xd(this, c);
            Yd(this, a)
        }
        close() {
            this.B && this.za();
            super.close()
        }
    }
    function ae(a, c={}) {
        a.I || (a.g.Ea(c),
        a.I = !0,
        a.j = !0);
        a.B || a.g.append(a.K, {});
        a.B = !1
    }
    class be extends Qd {
        constructor(a, c) {
            super();
            this.g = a;
            this.I = this.j = !1;
            this.B = !0;
            this.K = La.XS.string.fromString(c)
        }
        Ea(a={}) {
            ae(this, a);
            this.j = !1
        }
        za() {
            this.g.za()
        }
        na(a, c, q, E={}) {
            ae(this, E);
            this.g.na(a, c, q, E)
        }
        endElement() {
            this.g.endElement()
        }
        text(a, c={}) {
            ae(this, c);
            super.text(a, c)
        }
        wa(a, c={}) {
            ae(this, c);
            super.wa(a, c)
        }
        va(a, c, q={}) {
            ae(this, q);
            super.va(a, c, q)
        }
        append(a, c={}) {
            if (cd.isArray(a))
                a.flatten(q=>this.append(q, c));
            else {
                if (a instanceof ad.XdmFunction)
                    throw new F("Cannot add a function item to an XDM node tree","SENR0001");
                if (a instanceof cc)
                    throw new F("Cannot add a map to an XDM node tree","SENR0001");
                La.pa(a) ? (ae(this, c),
                this.g.append(a, c)) : (ae(this, c),
                Zd.Gh(a, this))
            }
        }
        close() {
            this.j && this.za();
            super.close()
        }
    }
    function ce(a, c) {
        return a.g.findIndex(q=>q.equals(c))
    }
    class de {
        constructor() {
            this.g = [];
            this.j = []
        }
        get(a) {
            a = ce(this, a);
            return 0 > a ? void 0 : this.j[a]
        }
        set(a, c) {
            const q = ce(this, a);
            0 <= q ? this.j[q] = c : (this.g.push(a),
            this.j.push(c))
        }
        forEach(a) {
            for (let c = 0; c < this.g.length; c++)
                a(this.j[c], this.g[c])
        }
    }
    ;// Input 32
    var Zd = function() {
        function a(f) {
            if (f) {
                var A = f.PUSH;
                if (!A)
                    if (A = m[f.N])
                        f.PUSH = A = A(f);
                    else {
                        const O = cd.ib(f);
                        f.PUSH = A = function(b, d) {
                            O(b).forEachItem(l=>d.append(l))
                        }
                    }
                return A
            }
        }
        function c(f) {
            let A = f.N;
            f.parentNode && (A = c(f.parentNode) + "/" + A);
            return A
        }
        function q(f) {
            if (f.C) {
                const A = f.C.map(a);
                return function(O, b) {
                    A.forEach(d=>d(O, b))
                }
            }
            return ()=>{}
        }
        function E(f, A, O, b, d, l) {
            if (ac.X(f))
                switch (f.nodeType) {
                case 9:
                case 11:
                    O.pb = ac.baseURI(f);
                    p(f, O, d, l);
                    break;
                case 1:
                    if (f.hasAttribute("xml:base")) {
                        const r = f.getAttribute("xml:base");
                        O.pb = ac.ld(r) ? r : pa.Fb(r.toString(), cd.Ia(b, A)).toString()
                    } else
                        O.pb = ac.baseURI(f);
                    p(f, O, d, l);
                    break;
                case 3:
                case 4:
                    O.text(f.nodeValue);
                    break;
                case 7:
                    O.va(f.target, f.data);
                    break;
                case 8:
                    O.wa(f.textContent);
                    break;
                default:
                    O.append(f)
                }
            else
                O.append(f)
        }
        function H(f, A, O) {
            switch (f.nodeType) {
            case 9:
            case 11:
                A.Ea(O ? {
                    BASE_URI: O
                } : {});
                f = f.childNodes;
                for (O = 0; O < f.length; ++O)
                    H(f[O], A, null);
                A.za();
                break;
            case 1:
                let b = {};
                ac.Ja.ob(f).forEachItem(function(l) {
                    "xml" !== l.prefix && (b[l.prefix] = l.uri)
                });
                let d = new de;
                ac.Ja.Ha(f).forEachItem(function(l) {
                    d.set(l.yc, {
                        value: l.value,
                        kb: 0
                    })
                });
                A.na(ac.ca(f), d, b, {});
                f = f.childNodes;
                for (O = 0; O < f.length; ++O)
                    H(f[O], A, null);
                A.endElement();
                break;
            case 3:
            case 4:
                A.text(f.nodeValue, 0);
                break;
            case 7:
                A.va(f.target, f.data, 0);
                break;
            case 8:
                A.wa(f.textContent, 0)
            }
        }
        function p(f, A, O, b=!1) {
            switch (f.nodeType) {
            case 9:
            case 11:
                b && (A.Nc = f);
                A.Ea();
                f = f.childNodes;
                for (var d = 0; d < f.length; ++d)
                    p(f[d], A, O, b);
                A.za();
                break;
            case 1:
                b && (A.Nc = f);
                A.na(ac.ca(f));
                ac.Ja.Ha(f).forEachItem(function(l) {
                    ac.ca(l);
                    A.Ha(ac.ca(l), l.value)
                });
                O && ac.Ja.ob(f).forEachItem(function(l) {
                    A.ob(l.prefix, l.uri)
                });
                f = f.childNodes;
                for (d = 0; d < f.length; ++d)
                    p(f[d], A, O, b);
                A.endElement();
                break;
            case 3:
            case 4:
                b && (A.Nc = f);
                A.text(f.nodeValue);
                break;
            case 7:
                b && (A.Nc = f);
                A.va(f.target, f.data);
                break;
            case 8:
                b && (A.Nc = f),
                A.wa(f.textContent)
            }
        }
        function g(f) {
            return (f = f.next()) ? f.toString() : ""
        }
        function e(f, A, O, b, d) {
            A = O && 0 <= O.indexOf("c");
            if (ac.X(f))
                switch (f.nodeType) {
                case 9:
                case 11:
                    d.pb = ac.baseURI(f);
                    d.Ea();
                    b();
                    d.za();
                    break;
                case 1:
                    O = ac.ca(f);
                    d.pb = ac.baseURI(f);
                    d.na(O);
                    A && ac.Ic(f).forEach(function(l) {
                        d.ob(l.prefix, l.uri)
                    });
                    b();
                    d.Nc = null;
                    d.endElement();
                    break;
                case 2:
                    ac.ca(f);
                    d.Ha(ac.ca(f), f.value);
                    break;
                case 3:
                case 4:
                    d.text(f.textContent);
                    break;
                case 8:
                    d.wa(f.textContent);
                    break;
                case 7:
                    d.va(f.target, f.data);
                    break;
                case 13:
                    d.ob(f.prefix, f.uri);
                    break;
                default:
                    throw new F("Unknown node kind " + f.nodeType,"SXJS0003");
                }
            else
                d.append(f)
        }
        function k(f, A, O, b, d) {
            const l = La.XS.string.fromString;
            O = Ha.xg(O);
            A = Ha.Ce(A, O + "g", f);
            if (!b && A.test(""))
                throw new F("Regular expression matches zero-length string","FORX0003");
            b = [];
            let r = 0
              , n = 0;
            for (; null !== (O = A.exec(f)); )
                if ((O.index > r || O.index === r && d) && b.push({
                    Lc: !1,
                    string: l(f.substring(r, O.index))
                }),
                b.push({
                    Lc: !0,
                    groups: O,
                    string: l(O[0])
                }),
                r = A.lastIndex,
                0 === O[0].length && A.lastIndex++,
                n++ > 10 * f.length)
                    throw new F("analyze-string looping???","SXJS0004");
            f.length > r && b.push({
                Lc: !1,
                string: l(f.substring(r, f.length))
            });
            return b
        }
        function v(f) {
            const A = "compAtt" === f.N
              , O = cd.ib(cd.da(f, "name"))
              , b = cd.ib(cd.da(f, "namespace"));
            return d=>{
                function l() {
                    throw new F((A ? "Attribute" : "Element") + " name '" + r + "' is not a lexical QName",A ? "XTDE0850" : "XTDE0820",f);
                }
                let r = Ha.trim(O(d).next().toString());
                if (b) {
                    d = (d = b(d).next()) ? d.value : "";
                    if (!cd.Oj(d))
                        throw new F((A ? "Attribute" : "Element") + " namespace '" + d + "' is invalid",A ? "XTDE0865" : "XTDE0835",f);
                    var n = La.XS.QName;
                    if ("" === d && r.includes(":"))
                        n = n.fromParts("", "", r.replace(/^.*:/, ""));
                    else if (r.includes(":")) {
                        const B = r.split(":");
                        "" !== B[0] && "" !== B[1] || l();
                        n = n.fromParts(B[0], d, B[1])
                    } else
                        n = "" === d ? n.fromParts("", "", r) : n.fromParts(A ? "ns0" : "", d, r)
                } else {
                    if (A && "xmlns" === r)
                        throw new F("Attribute must not be named xmlns","XTDE0855",f);
                    try {
                        n = cd.sg(f, r, !A)
                    } catch (B) {
                        if (B instanceof F) {
                            if ("XTDE0290" === B.code)
                                throw new F((A ? "Attribute" : "Element") + " name '" + r + "' has an unbound prefix",A ? "XTDE0860" : "XTDE0830",f);
                            "FORG0001" === B.code && l()
                        }
                        throw B;
                    }
                }
                if ("http://www.w3.org/2000/xmlns/" === n.uri)
                    throw new F("Disallowed namespace " + n.uri,A ? "XTDE0865" : "XTDE0835",f);
                return n
            }
        }
        class t {
            constructor() {}
            Ea() {}
            za() {}
            na() {}
            Ha() {}
            ob() {}
            endElement() {}
            text() {}
            wa() {}
            va() {}
            append() {}
            close() {}
        }
        class C extends t {
            constructor(f) {
                super();
                this.j = f;
                this.V = [];
                this.zb = [];
                this.pb = null;
                this.g = 0;
                this.eb = this.I = null;
                this.K = {};
                this.Ca = null;
                this.B = this.ra = !1;
                this.xa = {};
                this.Nc = null
            }
            ta(f, A, O) {
                var b = this.K[f];
                if (b && b !== A)
                    if ("ns" === O) {
                        if (this.xa[f])
                            throw new F("Two conflicting bindings for prefix '" + f + "'","XTDE0430");
                        if (this.I.prefix === f) {
                            for (b = f + "_9"; this.K[b]; )
                                b += "9";
                            this.I = La.XS.QName.fromParts(b, this.I.uri, this.I.local);
                            this.K[b] = this.I.uri
                        }
                        this.K[f] = A
                    } else
                        return "" === f && (f = "NULL"),
                        this.ta(f + "0", A, O);
                "ns" === O && (this.xa[f] = A);
                if ("elem" === O && "" === A)
                    for (b = this.V.length - 1; 0 <= b; b--)
                        if ("" === this.V[b][0]) {
                            this.K[""] = "";
                            break
                        }
                if ("" !== f || "" !== A) {
                    b = !1;
                    for (let d = this.V.length - 1; 0 <= d; d--) {
                        const l = this.V[d];
                        if (l[0] === f) {
                            l[1] === A && (b = !0);
                            break
                        }
                    }
                    if (!b) {
                        if (this.xa[f] && this.xa[f] !== A)
                            return this.ta(f + "0", A, O);
                        this.K[f] = A
                    }
                }
                return f
            }
            Ea() {
                0 === this.g && (this.j.Ea({
                    BASE_URI: this.pb,
                    ORIGINAL_NODE: this.Nc
                }),
                this.V = []);
                this.aa();
                this.g++;
                this.B = this.ra = !1
            }
            za() {
                this.g--;
                0 === this.g && this.j.za();
                this.B = !1
            }
            na(f) {
                this.aa();
                this.g++;
                this.ra = !0;
                this.I = f;
                this.eb = new de;
                this.K = {};
                this.xa = {};
                this.ta(f.prefix, f.uri, "elem");
                this.Ca = this.Nc;
                this.B = !1
            }
            Ha(f, A) {
                if (0 === this.g)
                    this.j.append(new $b(f,A,null));
                else {
                    if (!this.ra) {
                        if (this.I)
                            throw new F("Cannot write attribute (" + f.toEQName() + "=" + A + ") after writing child nodes (level=" + this.g + ", start tag = " + this.I + ")","XTDE0410");
                        throw new F("Cannot attach an attribute (" + f.toEQName() + "=" + A + ") to a document node","XTDE0420");
                    }
                    if ("" !== f.uri) {
                        ["", "xmlns"].includes(f.prefix) && (f = f.withPrefix("ns_"));
                        const O = this.ta(f.prefix, f.uri, "att");
                        O !== f.prefix && (f = f.withPrefix(O))
                    }
                    this.eb.set(f, {
                        value: A,
                        kb: 0
                    })
                }
            }
            ob(f, A) {
                if (0 === this.g)
                    this.j.append(new bc(f,A));
                else {
                    if (!this.ra)
                        throw new F("Cannot write namespace after writing child nodes","XTDE0410");
                    if ("" === f && "" === this.I.uri)
                        throw new F("Cannot add default namespace declaration to a no-namespace element","XTDE0440");
                    this.ta(f, A, "ns")
                }
            }
            endElement() {
                this.aa();
                this.j.endElement();
                this.g--;
                let f = this.zb.pop();
                for (; 0 < f--; )
                    this.V.pop();
                this.B = !1
            }
            text(f, A) {
                if (0 < f.length || 0 === this.g)
                    this.aa(),
                    this.j.text(f, A || {});
                this.B = !1
            }
            wa(f) {
                this.aa();
                this.j.wa(f);
                this.B = !1
            }
            va(f, A) {
                this.aa();
                this.j.va(f, A);
                this.B = !1
            }
            append(f) {
                if (ac.X(f)) {
                    if (0 === this.g)
                        this.j.append(f, {});
                    else
                        switch (f.nodeType) {
                        case 2:
                            this.Ha(ac.ca(f), f.value);
                            break;
                        case 13:
                            this.ob(f.prefix, f.uri);
                            break;
                        case 9:
                        case 11:
                            0 === this.g ? H(f, this.j, this.pb) : ac.Ja.Ka(f).forEachItem(A=>this.append(A));
                            break;
                        default:
                            this.aa(),
                            p(f, this, !0, !1)
                        }
                    this.B = !1
                } else if (0 === this.g)
                    this.j.append(f, {}),
                    this.B = !1;
                else if (La.pa(f))
                    this.aa(),
                    this.text((this.B ? " " : "") + f.toString(), {}),
                    this.B = !0;
                else if (cd.isArray(f)) {
                    f = f.value;
                    for (let A = 0; A < f.length; A++) {
                        const O = f[A];
                        for (let b = 0; b < O.length; b++)
                            this.append(O[b])
                    }
                } else {
                    if (cd.Jd(f))
                        throw new F("Cannot attach a " + (cd.isMap(f) ? "map" : "function") + " to an XDM tree","XTDE0450");
                    sa.la("Cannot add item to tree " + sa.showValue(f))
                }
            }
            close() {
                this.j.close()
            }
            aa() {
                if (this.ra) {
                    var f = {};
                    this.pb && (f.BASE_URI = this.pb);
                    this.Ca && (f.ORIGINAL_NODE = this.Ca,
                    this.Ca = null);
                    this.j.na(this.I, this.eb, this.K, f);
                    this.ra = !1;
                    f = 0;
                    for (let[A,O] of Object.entries(this.K))
                        this.V.push([A, O]),
                        f++;
                    this.zb.push(f)
                }
            }
        }
        const m = {
            analyzeString: function(f) {
                const A = cd.ib(cd.da(f, "select"))
                  , O = cd.ib(cd.da(f, "regex"))
                  , b = cd.ib(cd.da(f, "flags"))
                  , d = a(cd.da(f, "matching"))
                  , l = a(cd.da(f, "nonMatching"));
                return (r,n)=>{
                    try {
                        let B = A(r).next();
                        if (null === B)
                            return Ob;
                        B = B.toString();
                        const W = O(r).next().toString()
                          , ma = b(r).next().toString()
                          , qa = k(B, W, ma, !0, !1)
                          , L = r.ba(!1)
                          , aa = qa.map(z=>z.string);
                        L.focus = Sb(Kb(aa));
                        L.focus.forEachItem(()=>{
                            const z = qa[L.focus.position - 1];
                            z.Lc ? d && (L.Mb = z.groups,
                            d(L, n)) : l && (L.Mb = [],
                            l(L, n))
                        }
                        )
                    } catch (B) {
                        if (B instanceof F && "FORX0002" === B.code)
                            throw new F(B.message,"XTDE1140");
                        if (B instanceof F && "FORX0001" === B.code)
                            throw new F(B.message,"XTDE1145");
                        throw B;
                    }
                }
            },
            applyImports: function(f) {
                return function(A, O) {
                    const b = A.gb.mode;
                    if (!b)
                        throw new F("applyImports: no current mode","XTDE0560",f);
                    fd(A, "XTDE0560", "xsl:apply-imports", f);
                    const d = A.ba(!0);
                    d.sa = A.gb;
                    cd.Ve(f, A, d);
                    d.focus = A.focus;
                    return b.ki(d, O)
                }
            },
            applyT: function(f) {
                const A = cd.Sa(f)
                  , O = cd.ib(cd.da(f, "separator"));
                return function(b, d) {
                    let l;
                    const r = b.ba(!0);
                    if (cd.Db(f, "c"))
                        l = b.gb.mode,
                        ["function", "globalVariable", "globalParam"].includes(b.sa.actor.N) && (l = cd.ke(f, b).Wh),
                        r.sa = b.gb;
                    else {
                        var n = cd.ig(f, b, "mode");
                        l = n.mode;
                        if (l.Bh)
                            throw new F("Mode " + l.Re.name + " only handles typed nodes","XTTE3100",f);
                        r.sa = n
                    }
                    cd.Ve(f, b, r);
                    n = O ? O(b).next() : null;
                    r.focus = Sb(A(b));
                    r.focus.Mb = b.focus ? b.focus.Mb : null;
                    l.Hb(r, d, n)
                }
            },
            att: function(f) {
                const A = f.name
                  , O = A.split(":");
                let b;
                b = f.nsuri ? 2 === O.length ? La.XS.QName.fromParts(O[0], f.nsuri, O[1]) : La.XS.QName.fromParts("", f.nsuri, A) : La.XS.QName.fromString(A, cd.Wd(f, !1));
                const d = cd.Sa(f);
                return function(l, r) {
                    l = g(d(l));
                    r.Ha(b, l)
                }
            },
            "break": function(f) {
                const A = q(f);
                return function(O, b) {
                    A(O, b);
                    O.focus.position = -999
                }
            },
            callT: function(f) {
                return function(A, O) {
                    const b = cd.ig(f, A, "template")
                      , d = A.ba(!0);
                    d.Bb = null;
                    d.sa = b;
                    cd.Tf(b.actor, d);
                    cd.Ve(f, A, d);
                    A = b.actor;
                    A.C && q(A)(d, O)
                }
            },
            choose: function(f) {
                f = f.C;
                const A = []
                  , O = [];
                for (let b = 0; b < f.length; b += 2)
                    A.push(cd.ib(f[b])),
                    O.push(a(f[b + 1]));
                return function(b, d) {
                    for (let l = 0; l < A.length; l++)
                        if (cd.Fd(A[l](b))) {
                            O[l](b, d);
                            break
                        }
                }
            },
            comment: function(f) {
                const A = cd.Sa(f);
                return function(O, b) {
                    O = g(A(O)).replace(/--/g, "- -").replace(/-$/, "- ");
                    b.wa(O)
                }
            },
            compAtt: function(f) {
                const A = cd.ib(cd.da(f, "select"))
                  , O = v(f);
                return function(b, d) {
                    const l = O(b);
                    b = g(A(b));
                    d.Ha(l, b)
                }
            },
            compElem: function(f) {
                const A = a(cd.da(f, "content"))
                  , O = v(f);
                return function(b, d) {
                    f.baseUri && (d.pb = f.baseUri);
                    const l = O(b);
                    d.na(l);
                    A(b, d);
                    d.endElement()
                }
            },
            copy: function(f) {
                const A = q(f);
                return function(O, b) {
                    fd(O, "XTTE0945", "xsl:copy", f);
                    e(ed(O), O, f.flags, ()=>A(O, b), b)
                }
            },
            copyOf: function(f) {
                const A = cd.Db(f, "c")
                  , O = cd.Db(f, "m")
                  , b = cd.Sa(f);
                q(f);
                return function(d, l) {
                    b(d).forEachItem(r=>E(r, d, l, f, A, O))
                }
            },
            doc: function(f) {
                const A = q(f);
                return function(O, b) {
                    b.pb = cd.Ia(f, O);
                    b.Ea();
                    A(O, b);
                    b.za()
                }
            },
            elem: function(f) {
                const A = f.name
                  , O = A.split(":")
                  , b = q(f);
                let d;
                d = "undefined" !== typeof f.nsuri ? 2 === O.length ? La.XS.QName.fromParts(O[0], f.nsuri, O[1]) : La.XS.QName.fromParts("", f.nsuri, A) : La.XS.QName.fromString(A, cd.Wd(f, !0));
                return function(l, r) {
                    f.baseUri && (r.pb = f.baseUri);
                    r.na(d);
                    if (f.namespaces) {
                        const B = f.namespaces.toString().split(" ");
                        for (let W = 0; W < B.length; W++) {
                            var n = B[W];
                            const ma = n.indexOf("=");
                            let qa = -1 === ma ? n : n.substring(0, ma);
                            n = -1 === ma ? "" : n.substring(ma + 1);
                            "#" === qa && (qa = "");
                            "xml" !== qa && (n = "" !== n ? n : cd.Wd(f, !0)(qa),
                            r.ob(qa, n))
                        }
                    }
                    b(l, r);
                    r.endElement()
                }
            },
            empty: function() {
                return function() {}
            },
            forEach: function(f) {
                const A = cd.Sa(f)
                  , O = a(f.C[1])
                  , b = cd.ib(cd.da(f, "separator"));
                return function(d, l) {
                    const r = d.ba(!1);
                    r.focus = Sb(A(d));
                    r.ab = null;
                    if (b) {
                        let n = !0;
                        const B = b(d).next();
                        r.focus.forEachItem(()=>{
                            n ? n = !1 : l.text(B.value, {});
                            O(r, l)
                        }
                        )
                    } else
                        r.focus.forEachItem(()=>O(r, l))
                }
            },
            forEachGroup: function(f) {
                const A = cd.ib(cd.da(f, "select"))
                  , O = Zd.wi(cd.da(f, "content"));
                return (b,d)=>{
                    function l(L) {
                        const aa = [];
                        r.forEachItem(function(z) {
                            L(aa, z)
                        });
                        return aa
                    }
                    const r = Sb(A(b))
                      , n = b.ba(!1);
                    n.focus = r;
                    var B = {
                        starting: function() {
                            const L = Kd.od(cd.da(f, "match"));
                            return l(function(aa, z) {
                                1 === r.position || Kd.matches(L, z, n) ? aa.push({
                                    group: [z]
                                }) : aa[aa.length - 1].group.push(z)
                            })
                        },
                        ending: function() {
                            const L = Kd.od(cd.da(f, "match"));
                            let aa = !1;
                            return l(function(z, D) {
                                1 === r.position || aa ? z.push({
                                    group: [D]
                                }) : z[z.length - 1].group.push(D);
                                aa = Kd.matches(L, D, n)
                            })
                        },
                        adjacent: function() {
                            var L = cd.da(f, "collation");
                            L = L ? cd.evaluate(L, b).next().toString() : Hd.$c;
                            const aa = Hd.eg(L, b)
                              , z = cd.da(f, "key");
                            let D = null;
                            return l(function(y, I) {
                                var R = cd.evaluate(z, n).expand();
                                1 !== r.position && Fd(Kb(R), Kb(D), aa.equals) ? y[y.length - 1].group.push(I) : (y.push({
                                    group: [I],
                                    key: R
                                }),
                                D = R)
                            })
                        },
                        by: function() {
                            var L = cd.da(f, "collation");
                            L = L ? cd.evaluate(L, b).next().toString() : Hd.$c;
                            L = Hd.eg(L, b);
                            const aa = Hd.xf(L, !1)
                              , z = cd.da(f, "key");
                            return l(function(D, y) {
                                let I, R = [];
                                cd.evaluate(z, n).forEachItem(function(M) {
                                    aa.containsKey(M) ? (I = aa.get(M),
                                    0 > R.findIndex(function(ca) {
                                        return ca === I
                                    }) && (D[I].group.push(y),
                                    R.push(I))) : (I = D.length,
                                    D.push({
                                        group: [y],
                                        key: [M]
                                    }),
                                    aa.inSituPut(M, I),
                                    R.push(I))
                                })
                            })
                        },
                        by_c: function() {
                            var L = cd.da(f, "collation");
                            L = L ? cd.evaluate(L, b).next().toString() : Hd.$c;
                            L = Hd.eg(L, b);
                            const aa = cd.da(f, "key")
                              , z = Hd.xf(L, !0);
                            return l(function(D, y) {
                                let I, R = cd.evaluate(aa, n).expand();
                                z.containsKey(R) ? (I = z.get(R),
                                D[I].group.push(y)) : (I = D.length,
                                D.push({
                                    group: [y],
                                    key: R
                                }),
                                z.inSituPut(R, I))
                            })
                        }
                    };
                    B.adjacent_c = B.adjacent;
                    var W = f.algorithm + (cd.Db(f, "c") ? "_c" : "");
                    let ma;
                    try {
                        ma = B[W]()
                    } catch (L) {
                        if (L instanceof F && "FOCH0002" === L.code)
                            throw new F("Unknown collation:" + L.message,"XTDE1110");
                        throw L;
                    }
                    const qa = cd.qb(f, "sortKey");
                    if (0 < qa.length) {
                        B = Sb(Kb(ma));
                        const L = b.ba(!1);
                        L.focus = B;
                        const aa = qa.map(function(z) {
                            return Hd.ii(z, b)
                        });
                        B.forEachItem(function(z, D) {
                            z.Oh = qa.map(function(y) {
                                var I = L.focus;
                                I.current = z.group[0];
                                I.position = D + 1;
                                L.ad = z.group;
                                L.bd = z.key;
                                return cd.Sa(y)(L).next()
                            })
                        });
                        ma.sort(function(z, D) {
                            for (var y = 0; y < aa.length; y++) {
                                var I = aa[y](z.Oh[y], D.Oh[y]);
                                if (0 > I)
                                    return -1;
                                if (0 < I)
                                    return 1
                            }
                            return 0
                        })
                    }
                    B = b.ba(!1);
                    B.focus = Sb(Kb(ma));
                    for (W = 0; null !== B.focus.next(); ) {
                        const L = ma[W++]
                          , aa = B.focus;
                        aa.current = L.group[0];
                        aa.position = W;
                        B.ad = L.group;
                        B.bd = L.key;
                        O(B, d)
                    }
                }
            },
            iterate: function(f) {
                const A = (f.C[1].C || []).map(cd.ib)
                  , O = cd.Sa(f)
                  , b = a(cd.da(f, "action"))
                  , d = a(cd.da(f, "on-completion"));
                return function(l, r) {
                    A.map(W=>W(l));
                    var n = l.ba(!1);
                    n.focus = Sb(O(l));
                    n.ab = null;
                    let B = !1;
                    for (; null !== n.focus.next(); )
                        if (b(n, r),
                        -999 === n.focus.position) {
                            B = !0;
                            break
                        }
                    !B && d && (n = l.ba(!1),
                    n.focus = null,
                    d(n, r))
                }
            },
            let: function(f) {
                const A = cd.Sa(f)
                  , O = a(f.C[1])
                  , b = parseInt(f.slot, 10);
                return function(d, l) {
                    const r = d.qa;
                    d.qa = "variable";
                    const n = A(d).expand();
                    d.qa = r;
                    d.oa[b] = n;
                    O(d, l)
                }
            },
            nextIteration: function(f) {
                const A = cd.qb(f, "withParam").map(O=>({
                    select: cd.Sa(O),
                    slot: parseInt(O.slot, 10)
                }));
                return function(O) {
                    A.forEach(b=>b.value = b.select(O).expand());
                    A.forEach(b=>O.oa[b.slot] = b.value)
                }
            },
            nextMatch: function(f) {
                return function(A, O) {
                    const b = A.gb.mode;
                    if (!b)
                        throw new F("next-match: no current mode","XTDE0560",f);
                    if (!A.ab)
                        throw new F("next-match: no current template","XTDE0560",f);
                    if (ee(A))
                        throw new F("next-match: no context item","XTDE0560",f);
                    const d = A.ba(!0);
                    d.sa = A.gb;
                    cd.Ve(f, A, d);
                    return b.qj(d, O)
                }
            },
            procInst: function(f) {
                const A = cd.Sa(f)
                  , O = cd.Vg(f);
                return function(b, d) {
                    const l = A(b).next().toString();
                    if (!Ha.Lb(l))
                        throw new F("The name of a processing-instruction must be a valid NCName; supplied value: " + l.toString(),"XTDE0890",f);
                    if (/^[Xx][Mm][Ll]$/.test(l))
                        throw new F("The name of a processing-instruction must not be 'xml'","XTDE0890",f);
                    b = O(b);
                    b = g(b).replace(/\?>/g, "? >").replace(/^\s+/, "");
                    d.va(l, b)
                }
            },
            sequence: q,
            sourceDoc: function(f) {
                const A = cd.ib(cd.da(f, "href"))
                  , O = a(f.C[1]);
                return function(b, d) {
                    const l = b.ba(!1);
                    var r = null === A ? "" : A(b).next().toString();
                    r = pa.Fb(r, cd.Ia(f, b));
                    r = Nd.Dc(r, b);
                    b = b.fixed.Ee;
                    null !== b && (r = b(r));
                    l.focus = Rb(r);
                    l.ab = null;
                    O(l, d)
                }
            },
            useAS: function(f) {
                return function(A, O) {
                    var b = cd.ig(f, A, "attributeSet");
                    A = A.ba(!0);
                    A.qa = "attribute set";
                    A.sa = b;
                    b = b.actor;
                    b.C && q(b)(A, O)
                }
            },
            valueOf: function(f) {
                const A = cd.Sa(f);
                let O = {};
                cd.Db(f, "d") && (O.DISABLE_ESCAPING = !0);
                return function(b, d) {
                    b = g(A(b));
                    d.text(b, O)
                }
            }
        };
        return {
            Of: k,
            wi: a,
            Fc: function(f) {
                return new C(f)
            },
            push: function(f, A, O) {
                if ("undefined" === typeof O)
                    throw sa.Ma(Error().stack, 1, A.fixed.Ta),
                    new F("No output for " + c(f));
                if (m[f.N]) {
                    var b = a(f);
                    try {
                        b(A, O)
                    } catch (d) {
                        throw d instanceof F && !d.xsltLineNr && ra(d, f),
                        d;
                    }
                } else {
                    b = cd.ib(f);
                    try {
                        const d = b(A);
                        let l;
                        for (; null != (l = d.next()); )
                            O.append(l)
                    } catch (d) {
                        throw d instanceof F && !d.xsltLineNr && ra(d, f),
                        d;
                    }
                }
            },
            Gh: H,
            qf: E,
            rg: e
        }
    }();
    // Input 33
    const fe = function() {
        function a(L, aa, z, D, y) {
            function I(V) {
                return null === r.Xa(V)
            }
            function R(V) {
                return V.nodeType === M.nodeType && (null === ea ? !0 : r.ca(V).equals(ea))
            }
            let M;
            const ca = y.fixed.ka;
            if (aa) {
                if (M = ca.evaluate(aa, y).next(),
                !M || !r.X(M))
                    throw new F("xsl:number/@select must yield a single node","XTTE1000");
            } else
                fd(y, "XTTE0990", "xsl:number"),
                M = ed(y);
            const ea = r.ca(M);
            let ja = R;
            if (null !== z) {
                const V = Kd.od(z);
                ja = function(la) {
                    return Kd.matches(V, la, y)
                }
            }
            if (null === D)
                aa = I;
            else {
                const V = Kd.od(D);
                aa = function(la) {
                    return I(la) || Kd.matches(V, la, y)
                }
            }
            let Y;
            switch (L) {
            case "simple":
                return L = n.Oc(M).filter(R),
                Ub(L.count() + 1);
            case "single":
                L = n.Ya(M).filter(ja).next();
                Y = n.Ya(M).filter(aa).next();
                L = null === L ? null : null !== n.Ya(L).filter(function(la) {
                    return r.isSameNode(la, Y)
                }).next() ? L : null;
                if (null === L)
                    return Ob;
                L = n.Oc(L).filter(ja);
                return Ub(L.count() + 1);
            case "multi":
                L = Kb(n.Ya(M).filter(ja).expand().reverse());
                Y = n.Ya(M).filter(aa).next();
                L = L.filter(function(la) {
                    return null !== n.Ya(la).filter(function(x) {
                        return r.isSameNode(x, Y)
                    }).next()
                });
                const V = B.integer.fromNumber;
                return L.mapOneToOne(la=>V(n.Oc(la).filter(ja).count() + 1));
            case "any":
                return z = function(la, x) {
                    return r.rb(x, la)
                }
                ,
                L = new Eb(n.og(M).filter(ja),n.Ya(M).filter(ja),z),
                Y = (new Eb(n.og(M).filter(aa),n.Ya(M).filter(aa),z)).next(),
                null === Y && sa.la("from pattern selected empty"),
                L = L.filter(function(la) {
                    return 0 <= r.rb(la, Y)
                }),
                L = L.count(),
                0 === L ? Ob : Ub(L);
            default:
                return sa.la("unknown xsl:number/@level " + L),
                Ob
            }
        }
        function c(L, aa, z, D, y, I, R) {
            function M(ea) {
                let ja;
                "" === ea && (ea = "1");
                if (/^[\x01-\x7f]*$/.test(ea))
                    ea = ea.split(/\b/),
                    ja = function(la) {
                        return /\w+/.test(la)
                    }
                    ;
                else {
                    if (ea.length !== Da(ea).length)
                        throw new F("Cannot handle non-BMP characters in format-number picture","SXJS0002");
                    const la = Zd.Of(ea, "[\\p{Nd}\\p{Nl}\\p{No}\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}]+", "", !0, !1);
                    ja = function(x, K) {
                        return la[K].Lc
                    }
                    ;
                    ea = la.map(function(x) {
                        return x.string.toString()
                    })
                }
                const Y = {
                    prefix: "",
                    ed: [],
                    Xd: ""
                };
                let V = ".";
                for (let la = 0; la < ea.length; la++) {
                    const x = ea[la];
                    ja(x, la) ? (Y.ed.push({
                        Pg: x,
                        Kh: V
                    }),
                    V = ".") : (0 === la && (Y.prefix = x),
                    la === ea.length - 1 ? Y.Xd = x : 0 !== la && (V = x))
                }
                0 === Y.ed.length && (Y.ed.push({
                    Pg: "1",
                    Kh: "."
                }),
                Y.Xd = Y.prefix);
                return Y
            }
            const ca = R.fixed.ka;
            if (null !== I)
                try {
                    B.language.R(I)
                } catch (ea) {
                    throw new F("@lang=" + I + ": invalid language code","XTDE0030");
                }
            return function(ea) {
                const ja = null === aa ? "1" : ca.evaluate(aa, R).next().toString()
                  , Y = M(ja);
                let V = Y.prefix;
                ea.forEach(function(la, x) {
                    const K = x >= Y.ed.length ? Y.ed[Y.ed.length - 1] : Y.ed[x];
                    0 !== x && (V += K.Kh);
                    x = K.Pg;
                    y && (x += ";o");
                    la = fe.bg(la.toNumber(), x);
                    null !== z && null !== D && (la = fe.Mf(la, z, D));
                    V += la
                });
                V += Y.Xd;
                return Tb(V)
            }(L.expand())
        }
        function q(L, aa, z, D, y) {
            const I = y.fixed.ka;
            let R = [1];
            null !== z && (R = I.evaluate(z, y).next().toString().split(/\s+/).map(function(M) {
                if (!/^-?[0-9]+$/.test(M))
                    throw new F("xsl:number/@start-at must be a sequence of integers. Offending value: " + M,"XTSE0020");
                return parseInt(M, 10)
            }));
            if (aa && D) {
                L = L.next();
                if (null === L)
                    return null;
                try {
                    L = B.integer.R(L.round(0))
                } catch (M) {
                    return null
                }
                L = Kb([L])
            }
            return L.mapOneToOne(function(M, ca) {
                M = M.isNumeric() ? M.toDouble() : B.double.cf(M.toString());
                if (0 > M.toNumber())
                    throw new F(`xsl:number/@value is less than zero (${M.toString()})`,"XTDE0980");
                try {
                    M = B.integer.R(M.round(0))
                } catch (ea) {
                    throw ea.code = "XTDE0980",
                    ea;
                }
                ca = ca >= R.length ? R[R.length - 1] : R[ca];
                1 !== ca && (M = B.integer.fromNumber(M.toNumber() + (ca - 1)));
                return M
            })
        }
        function E(L) {
            if (1 > L || 4999 < L)
                return L.toString();
            let aa = "";
            const z = "m cm d cd c xc l xl x ix v iv i".split(" ")
              , D = [1E3, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1];
            for (let y = 0; y < z.length; y++)
                for (; L >= D[y]; )
                    aa += z[y],
                    L -= D[y];
            return aa
        }
        function H(L, aa) {
            function z(y) {
                return (y > D ? z(Math.floor((y - 1) / D)) : "") + aa.charAt((y - 1) % D)
            }
            if (1 > L)
                return L.toString();
            const D = aa.length;
            return z(L)
        }
        function p(L, aa) {
            return L < aa.length ? aa[L] : L.toString()
        }
        function g(L, aa) {
            var z = Math.abs(L);
            for (z = 999999 > z ? z.toString() : wa(z).toFixed(); z.length < aa; )
                z = "0" + z;
            0 > L && (z = "-" + z);
            return z
        }
        function e(L, aa="FODF1310") {
            const z = Da(L)
              , D = {};
            let y = !0;
            var I = 0;
            let R;
            const M = Ha.Ce("\\p{Nd}", null);
            var ca = L.search(M);
            if (0 > ca)
                y = !1;
            else {
                I = Ha.tj().Nd;
                for (let ja = 0; ja < I.length && !(R = parseInt(I[ja][0], 16),
                R <= z[ca] && z[ca] <= R + 10); ja++)
                    ;
                for (ca = 0; ca < z.length; ca++)
                    if (128 <= z[ca])
                        if (I = String.fromCharCode(z[ca]),
                        M.test(I)) {
                            if (R > z[ca] || z[ca] > R + 10)
                                throw new F("Picture string mixes digits from different digit families: " + L,aa);
                        } else if (Ha.Ce("\\p{N}\\p{L}", null).test(I))
                            throw new F("Picture string is invalid: " + L,aa);
                const ea = [];
                I = R - 48;
                z.forEach(function(ja) {
                    R <= ja && ja <= R + 10 ? ea.push(48) : ea.push(ja)
                });
                L = Ea(ea)
            }
            D.aj = y;
            D.format = L;
            D.Yf = I;
            D.Af = R;
            return D
        }
        function k(L, aa) {
            const z = [];
            Da(L).forEach(function(D) {
                48 <= D && 57 >= D ? z.push(D + aa) : z.push(D)
            });
            return Ea(z)
        }
        function v(L, aa, z, D="", y=!1) {
            let I = 0;
            for (let R = 0; R < L.length; R++)
                if (R === aa[I]) {
                    const M = y ? R + 1 : L.length - R;
                    0 < M && (L = L.substring(0, M) + (z ? z[y ? I : z.length - I - 1] : D) + L.substring(M));
                    I++
                }
            return L
        }
        function t(L, aa, z="FODF1310") {
            let D = !0;
            var y = 0;
            if (Da(aa).length !== aa.length)
                throw new F("Cannot handle non-BMP characters in format-integer picture","SXJS0002");
            /^[\x01-\x7f]*$/.test(aa) || (D = !1);
            if (D)
                var I = /[0-9]/.test(aa);
            else
                y = e(aa, z),
                aa = y.format,
                I = y.aj,
                y = y.Yf;
            I || (aa = "1");
            var R = aa;
            if (!/^(([0-9]|#|[^A-Za-z0-9])+?)$/.test(R))
                throw new F("The decimal digit pattern in the picture string is invalid: " + R,z);
            I = R;
            aa = !0;
            if (/[^0-9A-Za-z#]/.test(I)) {
                var M = I.match(/[^0-9A-Za-z#]/g);
                if (1 < M.length)
                    for (let ca = 1; ca < M.length; ca++)
                        if (M[0] !== M[ca]) {
                            aa = !1;
                            break
                        }
                I = I.replace(/[^0-9A-Za-z#]/g, ",")
            }
            if (/^,|,,|,$/.test(I))
                throw new F("Grouping in picture string is invalid: " + R,z);
            if (/[0-9].*#/.test(I))
                throw new F("Picture string is invalid: " + R,z);
            z = I.replace(/[#,]/g, "").length;
            L = g(L, z);
            if (M) {
                I = Da(I).reverse();
                z = [];
                for (R = 0; R < I.length; R++)
                    44 === I[R] && z.push(R);
                R = !0;
                I.length - z[z.length - 1] - 1 > z[0] && (R = !1);
                if (R)
                    for (I = 1; I < z.length; I++)
                        if (0 !== (z[I] + 1) % (z[0] + 1)) {
                            R = !1;
                            break
                        }
                L = R && aa ? fe.Mf(L, M[0], z[0]) : v(L, z, M)
            }
            M = L;
            D || (M = k(M, y));
            return M
        }
        function C(L) {
            const aa = "Zero One Two Three Four Five Six Seven Eight Nine Ten Eleven Twelve Thirteen Fourteen Fifteen Sixteen Seventeen Eighteen Nineteen".split(" ")
              , z = "  Twenty Thirty Forty Fifty Sixty Seventy Eighty Ninety".split(" ");
            return 20 > L ? aa[L] : 100 > L ? z[Math.floor(L / 10)] + (0 === L % 10 ? "" : " " + aa[L % 10]) : 1E3 > L ? C(Math.floor(L / 100)) + " Hundred" + (0 === L % 100 ? "" : " and " + C(L % 100)) : 1E6 > L ? C(Math.floor(L / 1E3)) + " Thousand" + (0 === L % 1E3 ? "" : (100 > L % 1E3 ? " and " : " ") + C(L % 1E3)) : 1E9 > L ? C(Math.floor(L / 1E6)) + " Million" + (0 === L % 1E3 ? "" : (100 > L % 1E3 ? " and " : " ") + C(L % 1E6)) : L.toString()
        }
        function m(L) {
            const aa = "Zeroth First Second Third Fourth Fifth Sixth Seventh Eighth Ninth Tenth Eleventh Twelfth Thirteenth Fourteenth Fifteenth Sixteenth Seventeenth Eighteenth Nineteenth".split(" ")
              , z = "  Twent Thirt Fort Fift Sixt Sevent Eight Ninet".split(" ");
            return 20 > L ? aa[L] : 100 > L ? z[Math.floor(L / 10)] + (0 === L % 10 ? "ieth" : "y " + aa[L % 10]) : 1E3 > L ? C(Math.floor(L / 100)) + " Hundred" + (0 === L % 100 ? "th" : " and " + m(L % 100)) : 1E6 > L ? C(Math.floor(L / 1E3)) + " Thousand" + (0 === L % 1E3 ? "th" : (100 > L % 1E3 ? " and " : " ") + m(L % 1E3)) : 1E9 > L ? C(Math.floor(L / 1E6)) + " Million" + (0 === L % 1E3 ? "th" : (100 > L % 1E3 ? " and " : " ") + m(L % 1E6)) : L.toString()
        }
        function f(L) {
            return 1 === L % 10 && 11 !== L % 100 ? "st" : 2 === L % 10 && 12 !== L % 100 ? "nd" : 3 === L % 10 && 13 !== L % 100 ? "rd" : "th"
        }
        function A(L, aa, z="FODF1310") {
            function D(R, M) {
                let ca = "";
                for (let ea = R.charCodeAt(0), ja = 0; ja < M; ea++,
                ja++)
                    ca += String.fromCharCode(ea);
                return ca
            }
            var y;
            let I = null;
            if (-1 !== (y = aa.lastIndexOf(";"))) {
                I = aa.substring(y + 1);
                if (!/^([co](\(.+\))?)?[at]?$/.test(I))
                    throw new F("Invalid format modifier in picture string: " + I,z);
                I = I.charAt(0);
                aa = aa.substring(0, y)
            }
            if ("" === aa)
                throw new F("In the picture string, the picture cannot be empty",z);
            y = 0 > L ? "-" : "";
            if ("o" === I)
                switch (aa.toString()) {
                case "a":
                case "A":
                case "i":
                case "I":
                    break;
                case "Ww":
                    return y + m(Math.abs(L));
                case "W":
                    return y + m(Math.abs(L)).toUpperCase();
                case "w":
                    return y + m(Math.abs(L)).toLowerCase();
                default:
                    return t(L, aa, z) + f(Math.abs(L))
                }
            switch (aa.toString()) {
            case "a":
                return H(L, D("a", 26));
            case "A":
                return H(L, D("A", 26));
            case "\u03b1":
                return H(L, D("\u03b1", 25));
            case "\u0391":
                return H(L, D("\u0391", 25));
            case "i":
                return E(L);
            case "I":
                return E(L).toUpperCase();
            case "Ww":
                return y + C(Math.abs(L));
            case "W":
                return y + C(Math.abs(L)).toUpperCase();
            case "w":
                return y + C(Math.abs(L)).toLowerCase();
            case "\u2460":
                return p(L, "\u24ea" + D("\u2460", 20) + D("\u3251", 15) + D("\u32b1", 15));
            case "\u2474":
                return p(L, "0" + D("\u2474", 20));
            case "\u2488":
                return 0 === L ? "\ud83c\udd00" : p(L, "0" + D("\u2488", 20));
            case "\u2776":
                return p(L, "\u24ff" + D("\u2776", 10) + D("\u24eb", 10));
            case "\u2780":
                return 0 === L ? "\ud83c\udd0b" : p(L, "0" + D("\u2780", 10));
            case "\u278a":
                return 0 === L ? "\ud83c\udd0c" : p(L, "0" + D("\u278a", 10));
            case "\u24f5":
                return p(L, "0" + D("\u24f5", 10));
            case "\u3220":
                return p(L, "0" + D("\u3220", 10));
            case "\u3280":
                return p(L, "0" + D("\u3280", 10));
            default:
                return t(L, aa, z)
            }
        }
        function O(L, aa) {
            return String.fromCharCode(parseInt(L[aa] ? L[aa] : W[aa], 10))
        }
        function b(L, aa) {
            function z(S) {
                [["$gs", "grouping separator"], ["$es", "exponent separator"], ["$ds", "decimal separator"], ["$pc", "non-prefix passive character"], ["$pp", "percent|permille"], ["$od", "optional digit"], ["$md", "mandatory digit"], ["$ip", "integer part"], ["$fp", "fractional part"]].forEach(function(da) {
                    S = S.replace(da[0], da[1])
                });
                throw new F("Invalid picture: " + S,"FODF1310");
            }
            const D = {};
            var y = L.indexOf(aa.af)
              , I = 0 <= y;
            const R = aa.Af.charCodeAt(0);
            let M = 0
              , ca = 0
              , ea = [];
            const ja = []
              , Y = [];
            let V = -1
              , la = -1
              , x = !1
              , K = !1;
            var U = -1;
            let ha = 0;
            var T = I ? y : L.length;
            for (var w = 0; w < T; w++) {
                var Z = L.charCodeAt(w);
                Z >= R && Z < R + 10 ? (0 < la && z("digit follows $pc"),
                x ? ha++ : (1 > M && 0 > V && (V = w),
                M++,
                ca++)) : Z === aa.Ug.charCodeAt(0) ? (0 < la && z("digit follows $pc"),
                x && z("$od follows $es"),
                0 < M && z("$od follows $md in $ip"),
                0 > V && (V = w,
                K = !0),
                ca++) : Z === aa.pe.charCodeAt(0) ? (0 < Y.length && z("$gs follows $pc"),
                x && z("$gs follows $es"),
                ea.push(w)) : Z === aa.sd.charCodeAt(0) || Z === aa.Ae.charCodeAt(0) ? I ? z("$pp before $ds") : (0 > V && z("$pp before any digit"),
                0 < la && z("$pp follows $pc"),
                x && z("$pp follows $es"),
                Y.push(Z),
                0 > la && (la = w),
                Z === aa.sd.charCodeAt(0) ? D.sd = !0 : D.Ae = !0) : !I && 0 <= V && Z === aa.Bc.charCodeAt(0) && 0 > la ? x ? (Y.push(Z),
                0 < ha ? 0 > la && (la = w) : (Y.push(Z),
                x = !1,
                U = -1,
                0 > la && (la = w - 1))) : (x = !0,
                U = w) : 0 <= V && I ? z("$pc before $ds") : x && 0 === ha ? (x = !1,
                U = -1,
                Y.push(aa.Bc.charCodeAt(0)),
                Y.push(Z),
                0 > la && (la = w - 1)) : 0 <= V ? (Y.push(Z),
                0 > la && (la = w)) : ja.push(Z)
            }
            if (0 < ea.length) {
                const S = I ? y : x ? U : 0 < la ? la : L.length;
                ea = ea.map(function(da) {
                    return S - da - 1
                }).reverse()
            }
            if (0 !== ea.length)
                for (0 === ea[0] && z("$gs at end of $ip"),
                U = 0; U < ea.length - 1; U++)
                    ea[U] + 1 === ea[U + 1] && z("consecutive $gs in $ip");
            w = T = 0;
            Z = [];
            if (I) {
                I = -1;
                L = L.substring(y + 1);
                for (let S = 0; S < L.length; S++) {
                    const da = L.charCodeAt(S);
                    da >= R && da < R + 10 ? x && 0 > la ? ha++ : 0 <= I || 0 <= la ? z("$md follows $od or $pc in $fp") : (T++,
                    w++) : da === aa.Ug.charCodeAt(0) ? ((0 <= la || x) && z("$od follows $pc or $es"),
                    0 > I && (I = S),
                    w++) : da === aa.pe.charCodeAt(0) ? ((0 <= la || x) && z("$gs follows $pc or $es"),
                    Z.push(S - y + 1)) : da === aa.af.charCodeAt(0) ? z("more than one $ds") : da === aa.sd.charCodeAt(0) || da === aa.Ae.charCodeAt(0) ? ((0 <= la || x) && z("$pp follows $pc or $es"),
                    Y.push(da),
                    la = S,
                    da === aa.sd.charCodeAt(0) ? D.sd = !0 : D.Ae = !0) : da === aa.Bc.charCodeAt(0) && 0 > la ? x ? (Y.push(da),
                    0 < ha ? 0 > la && (la = S) : (Y.push(da),
                    x = !1,
                    U = -1,
                    0 > la && (la = S - 1))) : (x = !0,
                    U = S) : x && 0 === ha ? (x = !1,
                    U = -1,
                    Y.push(aa.Bc.charCodeAt(0)),
                    Y.push(da),
                    0 > la && (la = S - 1)) : (Y.push(da),
                    0 > la && (la = S))
                }
            }
            0 > V && 0 === w && z("mantissa contains no digits");
            if (0 !== Z.length)
                for (0 === Z[0] && z("$gs at beginning of $fp"),
                y = 0; y < Z.length - 1; y++)
                    Z[y] + 1 === Z[y + 1] && z("consecutive $gs in $fp");
            0 === M && 0 === w && (x ? w = T = 1 : M = 1);
            x && 0 === M && K && (M = 1);
            0 === M && 0 === T && (T = 1);
            D.lf = M;
            D.prefix = ja;
            D.Yb = ea;
            D.Fh = K;
            D.xj = ca;
            D.ve = T;
            D.ue = w;
            D.cg = Z;
            D.dh = ha;
            D.Bc = aa.Bc ? aa.Bc : "e";
            D.Xd = Y;
            return D
        }
        function d(L) {
            return Math.floor((L.getTime() - (new Date(Date.UTC(L.getUTCFullYear(), 0, 1))).getTime()) / 864E5) + 1
        }
        function l(L, aa) {
            const z = aa ? d(L) : L.getUTCDate();
            L = new Date(Date.UTC(L.getUTCFullYear(), aa ? 0 : L.getUTCMonth(), 1));
            let D = L.getUTCDay();
            0 === D && (D = 7);
            return 4 < D && 8 >= D + z ? l(new Date(L.getTime() - 864E5), aa) : Math.floor((z + D - 2) / 7) + (5 > D ? 1 : 0)
        }
        const r = ac
          , n = r.Ja
          , B = La.XS
          , W = {
            "decimal-separator": "46",
            "grouping-separator": "44",
            digit: "35",
            "minus-sign": "45",
            percent: "37",
            "per-mille": "8240",
            "zero-digit": "48",
            "exponent-separator": "101",
            "pattern-separator": "59",
            infinity: "Infinity",
            NaN: "NaN"
        }
          , ma = {
            Y: "getUTCFullYear",
            M: "getUTCMonth",
            D: "getUTCDate",
            F: "getUTCDay",
            H: "getUTCHours",
            m: "getUTCMinutes",
            s: "getUTCSeconds",
            f: "getUTCMilliseconds"
        }
          , qa = {
            d,
            W: function(L) {
                return l(L, !0)
            },
            w: function(L) {
                return l(L, !1)
            },
            h: function(L) {
                return 13 > L.getUTCHours() ? 0 === L.getUTCHours() ? 12 : L.getUTCHours() : L.getUTCHours() - 12
            },
            P: function(L) {
                return 12 > L.getUTCHours() ? "Am" : "Pm"
            },
            E: function(L) {
                return 0 > L.getUTCFullYear() ? "BC" : "AD"
            }
        };
        return {
            rj: function(L, aa) {
                const z = aa.fixed.ka
                  , D = L.level
                  , y = z.da(L, "select")
                  , I = z.da(L, "count");
                L = z.da(L, "from");
                return a(D, y, I, L, aa)
            },
            sj: function(L, aa) {
                var z = aa.fixed.ka;
                const D = z.da(L, "value")
                  , y = z.da(L, "format")
                  , I = z.qc(z.da(L, "gpSep"), aa).next()
                  , R = z.qc(z.da(L, "gpSize"), aa).next();
                var M = z.qc(z.da(L, "ordinal"), aa).next();
                const ca = z.qc(z.da(L, "lang"), aa).next();
                var ea = L.flags || "";
                L = z.da(L, "startAt");
                ea = /1/.test(ea);
                z = z.evaluate(D, aa);
                z = q(z, ea, L, !0, aa);
                M = M ? cd.hj(M.toString()) : !1;
                return null === z ? Tb("NaN") : c(z, y, I, R, M, ca, aa)
            },
            bg: A,
            Mf: function(L, aa, z) {
                let D = "";
                for (let y = 0; y < L.length; y++)
                    D += L.charAt(y),
                    (1 === z || 1 === (L.length - y) % z) && y < L.length - 1 && (D += aa);
                return D
            },
            Hi: function(L, aa, z) {
                const D = 0 > L ? !0 : 0 === L ? 0 > 1 / L : !1;
                z = {
                    af: O(z, "decimal-separator"),
                    pe: O(z, "grouping-separator"),
                    Ug: O(z, "digit"),
                    oj: O(z, "minus-sign"),
                    sd: O(z, "percent"),
                    Ae: O(z, "per-mille"),
                    Af: O(z, "zero-digit"),
                    Bc: O(z, "exponent-separator"),
                    Eh: O(z, "pattern-separator"),
                    Vi: z.infinity || W.infinity,
                    pj: z.NaN || W.NaN
                };
                if (isNaN(L))
                    return z.pj;
                aa = aa.includes(z.Eh) ? aa.split(z.Eh) : [aa];
                if (2 < aa.length)
                    throw new F("Invalid picture: multiple pattern separators","FODF1310");
                const y = b(1 < aa.length && 0 > L ? aa[1] : aa[0], z);
                if (isFinite(L)) {
                    if (0 < y.dh) {
                        var I = y.lf;
                        var R = y.ve;
                        var M = y.ue;
                        var ca = y.Bc
                          , ea = 1 === I && y.Fh;
                        ea && (I = 0,
                        0 === R && (R = 1,
                        0 === M && (M = 1)));
                        var ja = y.dh;
                        L = wa(L);
                        let la = L.c;
                        var Y = 0 !== I ? I + M : M
                          , V = L.e;
                        la.length > Y && (L = wa(L.toPrecision(Y)));
                        (Y = V !== L.e) && (I += 1);
                        1 < I ? L = L.Vb(wa(10).pow(I - 1)) : 0 === I && (L = L.zc(wa(10)));
                        R = 0 !== I ? I + R : R;
                        for (la = L.c; la.length < R; )
                            la.push(0);
                        R = "";
                        if (0 < la.length) {
                            if (0 === I && y.Fh)
                                R += "0";
                            else
                                for (V = 0; V < I; V++)
                                    R += la[V];
                            !(0 < M && la.length > I) || ea && Y || (R += "." + la.join("").slice(I))
                        } else
                            throw new F("Empty mantissa","SXJS0004");
                        I = R + ca + g(L.e, ja)
                    } else {
                        M = Math.abs(L);
                        y.sd && (M = Math.abs(100 * L));
                        y.Ae && (M = Math.abs(1E3 * L));
                        "Infinity" === M + "" ? I = M + "" : I = 999999 > M ? M.toString() : wa(M).toFixed();
                        M = I.indexOf(".");
                        0 > M && (M = I.length,
                        0 < y.ve && (I += "."));
                        0 <= y.ue && "." !== I.substring(M) && M != I.length && (0 < y.ue ? (I = wa(I).round(y.ue, 1).toString(),
                        0 > I.indexOf(".") && (I += ".0")) : I = wa(I).round(0, 1).toString());
                        ca = I.length - 1 - M;
                        if (0 < y.ve)
                            for (; ca < y.ve; )
                                I += "0",
                                ca++;
                        for (; M < y.lf; )
                            I = "0" + I,
                            M++;
                        0 < ca && 0 === y.lf && "0" === I.substring(0, M) && (I = I.substring(M));
                        "0" === I && 0 === y.lf && 0 === y.ve && 0 < y.ue && (I = ".0")
                    }
                    M = "";
                    for (ca = 0; 10 > ca; ca++)
                        M += String.fromCharCode(z.Af.charCodeAt(0) + ca);
                    M += z.af;
                    ca = "";
                    for (ea = 0; ea < I.length; ea++)
                        ja = I.charAt(ea),
                        L = "0123456789.".indexOf(ja),
                        0 > L ? ca += ja : L < M.length && (ca += M.charAt(L));
                    M = ca;
                    if (0 < y.Yb.length || 0 < y.cg.length) {
                        ca = M.indexOf(z.af);
                        0 > ca && (ca = M.length);
                        I = M.substring(0, ca);
                        M = M.substring(ca);
                        if (0 < y.Yb.length) {
                            ca = !0;
                            for (ea = 1; ea < y.Yb.length; ea++)
                                if (0 !== (y.Yb[ea] + 1) % (y.Yb[0] + 1)) {
                                    ca = !1;
                                    break
                                }
                            ca && y.xj + y.Yb.length - y.Yb[y.Yb.length - 1] - 1 > y.Yb[0] && (ca = !1);
                            I = ca ? fe.Mf(I, z.pe, y.Yb[0]) : v(I, y.Yb, null, z.pe)
                        }
                        0 < y.cg.length && (M = v(M, y.cg, null, z.pe, !0));
                        M = I + M
                    }
                } else
                    M = z.Vi;
                0 < y.prefix.length && (M = Ea(y.prefix) + M);
                0 < y.Xd.length && (M += Ea(y.Xd));
                D && 1 === aa.length && (M = z.oj + M);
                return M
            },
            Hd: function(L, aa, z, D, y) {
                if (/\[/g.test(z) && !/\[(\[|[^\]]*\])|\]\]/g.test(z))
                    throw new F("Date format picture '" + z + "' doesn't match required syntax","FOFD1340");
                let I = "";
                "undefined" !== typeof D && null !== D && "en" !== D.toString() && (I += "[Language: en]");
                "undefined" === typeof y || null === y || "AD" === y.toString() || /(Q\{\})?ISO/.test(y.toString()) || (I += "[Calendar: AD]");
                return I + z.replace(/\[(\[|[^\]]*\])|\]\]/g, function(R) {
                    if ("[[" === R)
                        R = "[";
                    else if ("]]" === R)
                        R = "]";
                    else {
                        var M = R.substring(1, R.length - 1).replace(/\s+/g, "")
                          , ca = M.match(/^([YMDdWwFHhmsfZzPCE])(.*)$/);
                        if (null === ca)
                            throw new F("Date/time component [" + M + "] not recognised","FOFD1340");
                        R = ca[1];
                        ca = ca[2] || "";
                        if ("date" === L && /[HhPmsf]/.test(R) || "time" === L && /[YMDdFWwCE]/.test(R))
                            throw new F("Date/time component [" + M + "] not available in " + L,"FOFD1350");
                        if (-1 !== (M = ca.lastIndexOf(","))) {
                            var ea = ca.substring(M + 1).split("-");
                            ca = ca.substring(0, M);
                            var ja = ea[0];
                            ea = ea[1] || "*";
                            if ("*" !== ja && 1 > ja || "*" !== ea && 1 > ea || "*" !== ja && "*" !== ea && ja > ea)
                                throw new F("Invalid width modifier in date/time formatting picture","FOFD1340");
                        }
                        var Y = null;
                        1 < ca.length && /[atco]/.test(ca.charAt(ca.length - 1)) ? (M = ca.substring(0, ca.length - 1),
                        Y = ca.charAt(ca.length - 1)) : M = ca;
                        ca = !0;
                        if (!/^[\x01-\x7f]*$/.test(M)) {
                            if (M.length !== Da(M).length)
                                throw new F("Cannot handle non-BMP characters in date/time formatting picture","SXJS0002");
                            ca = !1
                        }
                        if (/[Zz]/.test(R))
                            if (ja = "Z" === db(aa) ? "+00:00" : db(aa),
                            ea = ca,
                            "" === ja)
                                R = "Z" === M ? "J" : "";
                            else if (R = "z" === R ? "GMT" : "",
                            "t" === Y && "+00:00" === ja && "Z" !== M && "N" !== M)
                                R = "Z";
                            else if ("" === M)
                                R += ja;
                            else {
                                ca = ja.match(/^([+\-])([0-9])([0-9]):([0-9]{2})$/);
                                if ("Z" === M || "N" === M)
                                    if ("Z" === M) {
                                        ea = parseInt(ca[1] + ca[2] + ca[3], 10);
                                        var V = -12 > ea || 12 < ea || "00" !== ca[4] ? ja : "YXWVUTSRQPONZABCDEFGHIKLM".charAt(ea + 12)
                                    } else {
                                        if ("N" === M)
                                            throw new F("Timezone names not implemented","SXJS0002");
                                    }
                                else
                                    ea && !/[0-9]+/.test(M) && (M = "00:00"),
                                    ja = 0,
                                    ea || (V = e(M, "FOFD1340"),
                                    M = V.format,
                                    ja = V.Yf),
                                    /[^0-9A-Za-z]/.test(M) ? (V = M.match(/^([0-9]+)([^0-9A-Za-z])([0-9]+)$/),
                                    V = ca[1] + ("0" === ca[2] && 1 === V[1].length ? ca[3] : ca[2] + ca[3]) + V[2] + ca[4]) : (V = M.match(/^[0-9]+$/),
                                    V = V[0],
                                    V = ca[1] + (("0" !== ca[2] || 1 !== V.length && 3 !== V.length ? ca[2] + ca[3] : ca[3]) + (2 < V.length ? ca[4] : "00" !== ca[4] ? ":" + ca[4] : ""))),
                                    ea || (V = k(V, ja));
                                R += V
                            }
                        else {
                            V = aa.proxy();
                            var la = ma[R] ? V[ma[R]]() : qa[R] ? qa[R](V) : null;
                            if (null === la)
                                throw new F("Component specifier not implemented: [" + R + "]","SXJS0002");
                            "M" === R ? la++ : "F" === R && 0 === la && (la = 7);
                            "" === M && (M = /[FPCE]/.test(R) ? "n" : /[ms]/.test(R) ? "01" : "1");
                            if ("f" === R) {
                                Y = la;
                                V = M;
                                R = ja;
                                M = ea;
                                ea = ca;
                                ja = 0;
                                ea || (ja = e(V, "FOFD1340"),
                                V = ja.format,
                                ja = ja.Yf);
                                for (ca = Y.toString(); 3 > ca.length; )
                                    ca = "0" + ca;
                                Y = Da(ca);
                                ca = parseInt(Ea(Y.reverse()), 10);
                                if (!R && !M && /^[0-9]$/.test(V))
                                    for (; Y.length > V.length; )
                                        V += "#";
                                if (R && "*" !== R) {
                                    la = /^([0-9]*)(#*)$/.exec(V);
                                    V = la[1] ? la[1] : "";
                                    for (la = la[2] ? la[2] : ""; R > V.length; )
                                        V += "0",
                                        la = la.slice(0, -1);
                                    V += la
                                }
                                if (M)
                                    for ("*" === M && (M = Y.length); V.length < M; )
                                        V += "#";
                                M = Ea(Da(V).reverse());
                                ca = A(ca, M, "FOFD1340");
                                for (ca = Ea(Da(ca).reverse()); ca.length > V.length; )
                                    ca = ca.slice(0, -1);
                                R && "*" !== R || 0 !== parseInt(ca, 10) || (ca = "0");
                                ea || (ca = k(ca, ja));
                                R = ca
                            } else {
                                if (/[nN]/.test(M))
                                    V = "January February March April May June July August September October November December".split(" "),
                                    ja = "Monday Tuesday Wednesday Thursday Friday Saturday Sunday".split(" "),
                                    Y = "M" === R ? V[la - 1] : "F" === R ? ja[la - 1] : la,
                                    "F" === R && ea && "*" !== ea && 6 > ea && (Y = Y.replace(/(ur)?day$/, ""),
                                    Y = Y.replace(/nes$/, "s")),
                                    "n" === M ? Y = Y.toLowerCase() : "N" === M && (Y = Y.toUpperCase()),
                                    ea && "*" !== ea && (Y = Y.substring(0, ea));
                                else {
                                    V = /;/.test(M) ? M + ";" : M;
                                    Y && (V += (";" === V.charAt(V.length - 1) ? "" : ";") + Y);
                                    Y = A(la, V, "FOFD1340");
                                    "Y" === R && "-" === Y.charAt(0) && (Y = Y.substring(1));
                                    if ("Y" === R && /[^iIwWnN]/.test(M.charAt(M.length - 1)) && (!ja && 2 === M.length || 2 == ea))
                                        for (; 2 < Y.length; )
                                            Y = Y.substring(1);
                                    if (ja && (ea = "*" === ja ? 0 : parseInt(ja, 10),
                                    0 < ea && Y.length < ea))
                                        if (/[YMDdWwHhms]/.test(R) && /[^iIwWnN]/.test(M.charAt(M.length - 1)))
                                            for (R = "0",
                                            ca || (R = String.fromCharCode(e(V, "FOFD1340").Af)); Y.length < ea; )
                                                Y = R + Y;
                                        else if ("Y" === R && /[iIwWnN]/.test(M.charAt(M.length - 1)))
                                            for (; Y.length < ea; )
                                                Y += " ";
                                        else
                                            throw new F("Not implemented min width modification with specifier " + R + " and format " + M,"SXJS0002");
                                }
                                R = Y
                            }
                        }
                    }
                    return R
                })
            }
        }
    }();
    // Input 34
    var ge = function() {
        function a(x, K, U) {
            function ha(T, w) {
                function Z(fa) {
                    return na=>fa[na]
                }
                const S = {
                    "<": "&lt;",
                    ">": "&gt;",
                    "&": "&amp;",
                    '"': "&#34;",
                    "\n": "&#10;",
                    "\r": "&#13;",
                    "\t": "&#9;"
                }
                  , da = {
                    "<": "&lt;",
                    ">": "&gt;",
                    "&": "&amp;"
                };
                return w ? T.replace(/&|<|>|"|\n|\r|\t/g, Z(S)) : T.replace(/&|<|>/g, Z(da))
            }
            if (U) {
                U = "";
                x = x.split("\x00");
                for (let T = 0; T < x.length; T++)
                    U += 1 === T % 2 ? x[T] : ha(x[T], K);
                return U
            }
            return ha(x, K)
        }
        function c(x, K) {
            return "ISO-8859-1" === K.toUpperCase() ? 255 >= x : "US-ASCII" === K.toUpperCase() ? 127 >= x : !0
        }
        function q(x, K) {
            return function(U) {
                var ha = !0;
                for (var T = 0; T < U.length; T++) {
                    var w = U.charCodeAt(T);
                    if (w >= x.min && w <= x.max) {
                        ha = !1;
                        break
                    }
                }
                if (ha)
                    return U;
                ha = "";
                T = !1;
                for (w = 0; w < U.length; w++) {
                    let Z = U.charAt(w)
                      , S = U.charCodeAt(w)
                      , da = 55296 <= S && 56320 >= S;
                    da && (S = U.codePointAt(w));
                    x.ya[S] ? (K && !T && (ha += "\x00",
                    T = !0),
                    ha += x.ya[S],
                    da && w++) : (K && T && (ha += "\x00",
                    T = !1),
                    ha += Z)
                }
                return ha
            }
        }
        function E(x) {
            return "" === x.uri || "http://www.w3.org/1999/xhtml" === x.uri
        }
        function H(x) {
            return ["http://www.w3.org/1999/xhtml", "http://www.w3.org/2000/svg", "http://www.w3.org/1998/Math/MathML"].includes(x)
        }
        function p(x, K) {
            return (K = {
                action: ["form"],
                archive: ["object"],
                background: ["body"],
                cite: ["blockquote", "del", "ins", "q"],
                classid: ["object"],
                codebase: ["applet", "object"],
                data: ["object"],
                datasrc: "button div input object select span table textarea".split(" "),
                "for": ["script"],
                formaction: ["button", "input"],
                href: ["a", "area", "base", "link"],
                icon: ["command"],
                longdesc: ["frame", "iframe", "img"],
                manifest: ["html"],
                name: ["a"],
                poster: ["video"],
                profile: ["head"],
                src: "audio embed frame iframe img input script source track video".split(" "),
                usemap: ["img", "input", "object"]
            }[K.local]) && K.includes(x.local)
        }
        function g(x, K, U=null) {
            switch (x.method) {
            case "xml":
                K = new W(x,K);
                if (x.version && "1.0" !== x.version)
                    throw new F("Serializer does not support the requested XML version: " + x.version,"SESU0013");
                d(x);
                if (x["undeclare-prefixes"])
                    throw new F("Cannot undeclare prefixes with XML 1.0 serializer","SEPM0010");
                x.indent && (K = m(x, K));
                K = f(x, K);
                K = A(x, K);
                K = O(x, K);
                return C(x, K);
            case "html":
                return l(x, K);
            case "text":
                return d(x),
                K = new V(x,K),
                K = f(x, K),
                K = A(x, K),
                C(x, K);
            case "xhtml":
                return l(x, K);
            case "json":
                return d(x),
                x.indent ? new ea(x,K,U) : new ca(x,K,U);
            case "adaptive":
                return new ja(x,K,U);
            default:
                return new Y(x,K)
            }
        }
        function e(x, K, U) {
            function ha(fa, na) {
                na = na.trim();
                if (["yes", "true", "1"].includes(na))
                    return !0;
                if (["no", "false", "0"].includes(na))
                    return !1;
                throw new F("Value of " + fa + " must be yes(=true, 1) or no(=false, 0)","SEPM0016");
            }
            function T(fa) {
                return function(na, va) {
                    va = va.trim();
                    return va.split(/\s+/).map(function(h) {
                        /^Q\{/.test(h) || /:/.test(h) || (h = "Q{}" + h);
                        return /^Q\{/.test(h) ? h : n.QName.fromString(h, fa).toEQName()
                    })
                }
            }
            function w(fa) {
                return function(na, va) {
                    va = va.trim();
                    if (fa.includes(va))
                        return va;
                    throw new F("Value of " + na + "(" + va + "): must be one of " + fa.join("|"),"SEPM0016");
                }
            }
            function Z(fa) {
                return function(na, va) {
                    if (fa.test(va))
                        return va;
                    throw new F("Invalid value for " + na + ": must match the pattern " + fa,"SEPM0016");
                }
            }
            function S(fa, na) {
                return na
            }
            function da(fa, na) {
                na = na.trim();
                if (/[0-9]+/.test(na))
                    return 1 * na;
                throw new F("Value of " + fa + " must be an integer (Actual value is " + sa.showValue(na) + ")","SEPM0016");
            }
            U = {
                "allow-duplicate-names": ha,
                "build-tree": ha,
                "byte-order-mark": ha,
                "cdata-section-elements": T(U),
                "doctype-public": Z(/[\sa-zA-Z0-9\-'()+,.:=?;!*#@$_%\/]*/),
                "doctype-system": Z(/[^']*|[^"]*/),
                encoding: Z(/[\x21-\x7e]+/),
                "escape-uri-attributes": ha,
                "html-version": function(fa, na) {
                    if (/[0-9]+(\.[0-9]+)?/.test(na))
                        return 1 * na;
                    throw new F("Value of " + fa + " must be a decimal number","SEPM0016");
                },
                "include-content-type": ha,
                indent: ha,
                "item-separator": S,
                "json-node-output-method": w(["xml", "xhtml", "html", "text"]),
                "media-type": S,
                method: function(fa, na) {
                    return function(va, h) {
                        h = h.trim();
                        !/^Q\{/.test(h) && /:/.test(h) && (h = n.QName.fromString(h, na).toEQName());
                        if (fa.includes(h))
                            return h;
                        throw new F("Value of " + va + "(" + h + "): must be one of " + fa.join("|"),"SEPM0016");
                    }
                }("xml xhtml html text json adaptive Q{http://saxonica.com/ns/interactiveXSLT}append-content Q{http://saxonica.com/ns/interactiveXSLT}replace-content".split(" "), U),
                "normalization-form": w("NFC NFD NFKC NFKD fully-normalized none".split(" ")),
                "omit-xml-declaration": ha,
                standalone: function(fa, na) {
                    return "omit" === na.trim() ? null : ha(fa, na)
                },
                "suppress-indentation": T(U),
                "undeclare-prefixes": ha,
                "use-character-maps": T(U),
                version: S,
                "Q{http://saxon.sf.net/}indent-spaces": da,
                "Q{http://saxon.sf.net/}line-length": da,
                "Q{http://saxon.sf.net/}stylesheet-version": da
            };
            /^\{/.test(x) && (x = "Q" + x);
            if ("string" !== typeof K)
                throw new F("Value of " + x + " must be supplied as a string","SEPM0016");
            if (U[x])
                return U[x](x, K);
            if (!/^Q\{/.test(x))
                throw new F("Unknown serialization parameter " + x,"SEPM0017");
        }
        function k(x, K, U) {
            function ha(S, da, fa) {
                if (!Array.isArray(da))
                    throw new F("Value of " + S + " must be an array","SEPM0016");
                return (fa || []).concat(da)
            }
            function T(S, da) {
                if ("boolean" !== typeof da)
                    throw new F("Value of " + S + " must be boolean","SEPM0016");
                return da
            }
            function w(S, da) {
                if ("number" !== typeof da)
                    throw new F("Value of " + S + " must be an integer (actual value is " + sa.showValue(da) + ")","SEPM0016");
                return da
            }
            const Z = {
                "allow-duplicate-names": T,
                "build-tree": T,
                "byte-order-mark": T,
                "cdata-section-elements": ha,
                "escape-uri-attributes": T,
                "html-version": function(S, da) {
                    if ("number" !== typeof da)
                        throw new F("Value of " + S + " must be a decimal number","SEPM0016");
                    return da
                },
                "include-content-type": T,
                indent: T,
                "omit-xml-declaration": T,
                standalone: function(S, da) {
                    return null === da ? null : T(S, da)
                },
                "suppress-indentation": ha,
                "undeclare-prefixes": T,
                "use-character-maps": function(S, da, fa) {
                    fa && Array.isArray(fa) && sa.la("Problem with existing character map supplied to overrideParam");
                    if ("object" !== typeof da)
                        throw new F("Value of " + S + " must be an object","SEPM0016");
                    if (void 0 === da.ya)
                        throw new F("Value of " + S + " must be a character map object","SEPM0016");
                    (S = fa) ? v(S, da) : S = da;
                    return S
                },
                "Q{http://saxon.sf.net/}indent-spaces": w,
                "Q{http://saxon.sf.net/}line-length": w,
                "Q{http://saxon.sf.net/}stylesheet-version": w
            };
            /^{/.test(x) && (x = "Q" + x);
            return Z[x] ? Z[x](x, K, U) : e(x, K.toString())
        }
        function v(x, K) {
            K.min < x.min && (x.min = K.min);
            K.max > x.max && (x.max = K.max);
            for (let U in K.ya)
                K.ya.hasOwnProperty(U) && (x.ya[U] = K.ya[U])
        }
        function t(x, K) {
            let U = {};
            x.forEach(function(ha, T) {
                let w = K.Og[ha];
                if (!w)
                    throw new F("Unknown character map " + ha,"SEPM0016");
                0 === T ? U = w : v(U, w)
            });
            return U
        }
        function C(x, K) {
            return x["item-separator"] && "#absent" !== x["item-separator"] ? new be(K,x["item-separator"]) : new $d(K)
        }
        function m(x, K) {
            const U = x["Q{http://saxon.sf.net/}indent-spaces"]
              , ha = x["suppress-indentation"];
            return Pd("xml" === x.method ? new ma(U,ha) : new D(U,ha), K)
        }
        function f(x, K) {
            x["normalization-form"] && "none" !== x["normalization-form"] && (K = Pd(new qa(x["normalization-form"]), K));
            return K
        }
        function A(x, K) {
            x["use-character-maps"] && (K = Pd(new L(x["use-character-maps"]), K));
            return K
        }
        function O(x, K) {
            x["cdata-section-elements"] && (K = Pd(new aa(x["cdata-section-elements"],x.encoding || "UTF-8",x["normalization-form"] && "none" !== x["normalization-form"] ? x["normalization-form"] : null), K));
            return K
        }
        function b(x, K) {
            return void 0 === x[K] || x[K]
        }
        function d(x) {
            if (x.encoding && !["UTF-8", "UTF-16", "ISO-646", "ISO-8859-1", "US-ASCII"].includes(x.encoding.toUpperCase()))
                throw new F("Serializer does not support the requested encoding: " + x.encoding,"SESU0007");
        }
        function l(x, K) {
            var U = "xhtml" === x.method;
            K = U ? new I(x,K) : new z(x,K);
            if (U && x.version && "1.0" !== x.version)
                throw new F("Serializer does not support the requested XML version: " + x.version,"SESU0013");
            if ((U = U ? x["html-version"] : x["html-version"] || x.version) && 5 !== 1 * U)
                throw new F("Serializer does not support the requested HTML version: " + U,"SESU0013");
            d(x);
            b(x, "indent") && (K = m(x, K));
            K = f(x, K);
            K = A(x, K);
            K = O(x, K);
            K = Pd(new y, K);
            b(x, "escape-uri-attributes") && (K = Pd(new R, K));
            b(x, "include-content-type") && (K = Pd(new M(x), K));
            return C(x, K)
        }
        function r(x, K, U, ha=null) {
            function T(da, fa) {
                switch (da.nodeType) {
                case 9:
                case 11:
                    fa.Ea(S);
                    da = da.childNodes;
                    for (var na = 0; na < da.length; ++na)
                        T(da[na], fa);
                    fa.za();
                    break;
                case 1:
                    let va = {};
                    ac.Ja.ob(da).forEachItem(function(G) {
                        va[G.prefix] = G.uri
                    });
                    let h = new de;
                    ac.Ja.Ha(da).forEachItem(function(G) {
                        h.set(G.yc, {
                            value: G.value,
                            kb: {}
                        })
                    });
                    fa.na(ac.ca(da), h, va, S);
                    da = da.childNodes;
                    for (na = 0; na < da.length; ++na)
                        T(da[na], fa);
                    fa.endElement();
                    break;
                case 2:
                    if (fa instanceof ja)
                        fa.text(ac.ca(da) + '="' + da.value + '"', S);
                    else
                        throw new F("Cannot serialize free-standing attribute node","SENR0001");
                    break;
                case 13:
                    if (fa instanceof ja)
                        na = da.prefix,
                        fa.text(na ? "xmlns:" + na : 'xmlns="' + da.uri + '"', S);
                    else
                        throw new F("Cannot serialize free-standing namespace node","SENR0001");
                    break;
                case 3:
                case 4:
                    fa.text(da.nodeValue, S);
                    break;
                case 7:
                    fa.va(da.target, da.nodeValue, S);
                    break;
                case 8:
                    fa.wa(da.nodeValue, S)
                }
            }
            function w(da, fa) {
                Array.isArray(da) ? da.forEach(na=>{
                    w(na, fa)
                }
                ) : ac.X(da) ? T(da, fa) : fa.append(da, S)
            }
            let Z;
            U || (Z = "",
            U = {
                write: function(da) {
                    Z += da
                }
            });
            U.write || sa.la("writer supplied to Serialize.serialize() is not a writeable stream");
            K ||= {};
            K = g(K, U, ha);
            let S = {};
            x && w(x, K);
            K.close();
            return Z
        }
        const n = La.XS;
        class B extends Od {
            constructor(x, K) {
                super();
                this.g = K || null;
                this.Pa = x
            }
            close() {
                this.g.end && !this.g.isTTY && this.g.end()
            }
        }
        class W extends B {
            constructor(x, K) {
                super(x, K);
                this.B = this.I = this.xa = this.ra = this.zb = !1;
                this.eb = [];
                this.K = [];
                this.Yd = 0;
                this.encoding = x.encoding || "UTF-8"
            }
            Ea() {}
            za() {}
            close() {
                this.I || this.aa();
                super.close()
            }
            na(x, K, U) {
                function ha(w) {
                    throw new F("When " + w + " is specified, there must only be one top-level element node","SEPM0004");
                }
                this.I || (this.aa(),
                this.Ca(x),
                this.ra && !this.xa && !0 === this.Pa.indent && this.g.write("\n"),
                this.I = !0);
                0 === this.K.length && (0 < this.Yd++ && void 0 !== this.Pa.standalone && null !== this.Pa.standalone && ha("standalone"),
                1 < this.Yd && this.Pa["doctype-system"] && ha("doctype-system"));
                const T = 0 === this.K.length ? {} : this.K[this.K.length - 1];
                this.eb.push(x);
                this.K.push(U);
                this.B && this.V();
                this.g.write("<" + this.j(x.toString(), !1));
                this.Ei(U, T);
                this.he(x, K);
                this.B = !0
            }
            endElement() {
                const x = this.eb.pop();
                this.K.pop();
                this.B ? (this.g.write("/>"),
                this.B = !1) : this.g.write("</" + x.toString() + ">")
            }
            text(x, K={}) {
                this.I || this.aa();
                this.B && this.V();
                this.g.write(K.DISABLE_ESCAPING ? this.j(x, !1) : this.j(a(x, !1, !1), !0))
            }
            wa(x) {
                this.I || this.aa();
                this.B && this.V();
                this.g.write("\x3c!--" + this.j(x, !1) + "--\x3e")
            }
            va(x, K) {
                this.I || this.aa();
                this.B && this.V();
                this.g.write("<?" + this.j(x, !1) + (0 < K.length ? " " + this.j(K, !1) : "") + "?>")
            }
            append(x, K={}) {
                this.text(x.toString(), K)
            }
            aa() {
                this.zb || this.vi()
            }
            V() {
                this.g.write(">");
                this.B = !1
            }
            Ei(x, K) {
                let U = [];
                for (let ha in x)
                    if (K[ha] !== x[ha]) {
                        let T = "";
                        "xml" !== ha && (T = "" === ha ? ' xmlns="' + a(x[ha], !0, !1) + '"' : " xmlns:" + ha + '="' + a(x[ha], !0, !1) + '"');
                        "" !== T && U.push(T)
                    }
                U.sort();
                U.forEach(ha=>this.g.write(ha))
            }
            he(x, K) {
                if (K) {
                    const U = this;
                    K.forEach((ha,T)=>{
                        U.ee(T, ha)
                    }
                    )
                }
            }
            ee(x, K) {
                const U = !0 === K.kb.USE_NULL_MARKERS;
                K = K.kb.DISABLE_ESCAPING ? this.j(K.value, !1) : this.j(a(K.value, !0, U), !0);
                this.g.write(" " + this.j(x.toString(), !1) + '="' + K + '"')
            }
            vi() {
                var x = this.encoding.toUpperCase();
                this.Pa["byte-order-mark"] && "UTF-8" === x && this.g.write("\ufeff");
                this.zb = !0;
                x = !0 === this.Pa["omit-xml-declaration"] && "UTF-8" === x;
                this.ra = !x;
                let K = this.Pa.standalone;
                if (x && void 0 !== K && null !== K)
                    throw new F("Serializer values of 'standalone' and 'omit-xml-declaration' conflict","SEPM0009");
                x || this.g.write('<?xml version="1.0" encoding="' + this.encoding + '"' + (void 0 !== K && null !== K ? ' standalone="' + (K ? "yes" : "no") + '"' : "") + "?>")
            }
            Ca(x) {
                let K = this.Pa["doctype-system"] || null
                  , U = this.Pa["doctype-public"] || null;
                null !== K && (this.ra && this.g.write("\n"),
                this.g.write("<!DOCTYPE " + this.j(x.toString(), !1) + "\n"),
                x = K.includes('"') ? "'" + K + "'" : '"' + K + '"',
                null === U ? this.g.write(" SYSTEM " + this.j(x, !1) + ">\n") : this.g.write(' PUBLIC "' + this.j(U, !1) + '" ' + this.j(x, !1) + ">\n"),
                this.xa = !0)
            }
            j(x, K) {
                function U(T) {
                    if (K)
                        return "&#" + T + ";";
                    throw new F("Character " + String.fromCodePoint(T) + " (decimal " + T + ") is not available in the chosen encoding","SERE0008");
                }
                const ha = this.encoding;
                return function(T) {
                    let w = "";
                    var Z = 0;
                    const S = T.length;
                    if (0 === S)
                        return "";
                    for (; Z < S; ) {
                        let fa = Z;
                        for (; fa < S; ) {
                            var da = T.charCodeAt(fa);
                            if (9 === da || 10 === da)
                                fa++;
                            else if (32 > da)
                                break;
                            else if (127 > da)
                                fa++;
                            else if (160 > da || 8232 === da || 55296 <= da && 56320 >= da || !c(da, ha))
                                break;
                            else
                                fa++
                        }
                        if (fa >= S)
                            return 0 === Z ? T : w + T.substring(Z, fa);
                        fa > Z && (w += T.substring(Z, fa));
                        da = T.charCodeAt(fa);
                        Z = T.charAt(fa);
                        if (0 === da)
                            throw new F("Null marker","ZZZZ9999");
                        160 > da || 8232 === da ? w += K ? U(da) : Z : 55296 <= da && 56320 >= da ? (da = T.codePointAt(fa++),
                        w += c(da, ha) ? Z + T.charAt(fa) : U(da)) : c(da, ha) || (w += U(da));
                        Z = ++fa;
                        if (Z >= S)
                            return w
                    }
                }(x)
            }
        }
        class ma extends Qd {
            constructor(x, K) {
                super();
                this.I = 0;
                this.ee = x || 3;
                this.Ca = "\n               ";
                this.B = this.K = this.V = !1;
                this.eb = K || null;
                this.j = -1;
                this.xa = null;
                this.zb = {}
            }
            na(x, K, U, ha={}) {
                this.K || this.B ? this.ra() : this.aa();
                if (0 > this.j) {
                    let T = K.get(n.QName.fromParts("", "http://www.w3.org/XML/1998/namespace", "space"));
                    T && "preserve" === T.value && (this.j = this.I)
                }
                this.I++;
                this.eb && -1 === this.j && 0 <= this.eb.indexOf(x.toEQName()) && (this.j = this.I);
                this.g.na(x, K, U, ha);
                this.K = this.V = !0;
                this.B = !1
            }
            endElement() {
                this.I--;
                this.B && !this.V ? this.ra() : this.K && !this.B ? this.xa = null : this.aa();
                this.g.endElement();
                this.V = !1;
                this.B = !0;
                this.K = !1;
                this.I === this.j - 1 && (this.j = -1)
            }
            text(x, K={}) {
                const U = !this.V || 0 <= x.indexOf("\n");
                0 > this.j && "" === Ha.trim(x) && U ? (this.xa = x,
                this.zb = K) : (this.aa(),
                0 <= x.indexOf("\n") && (this.V = !1),
                this.g.text(x, K),
                this.B = this.K = !1)
            }
            wa(x, K={}) {
                this.B ? this.ra() : this.aa();
                this.g.wa(x, K);
                this.B = this.K = !1
            }
            va(x, K, U={}) {
                this.B ? this.ra() : this.aa();
                this.g.va(x, K, U);
                this.B = this.K = !1
            }
            ra() {
                0 <= this.j ? this.aa() : this.Xe()
            }
            Xe() {
                this.xa = null;
                let x = this.I * this.ee;
                if (x + 1 > this.Ca.length) {
                    let K = 5 * this.ee;
                    x + 1 > this.Ca.length + K && (K += x + 1);
                    for (let U = 0; U < K; U++)
                        this.Ca += " "
                }
                this.g.text(this.Ca.substring(0, x + 1), {
                    DISABLE_ESCAPING: !0
                });
                this.V = !1
            }
            aa() {
                this.xa && (this.g.text(this.xa, this.zb),
                this.xa = null,
                this.zb = {})
            }
        }
        class qa extends Qd {
            constructor(x) {
                super();
                this.j = x;
                if (!String.prototype.normalize)
                    throw new F("normalization-form: not supported on this JavaScript platform","SESU0011");
                if ("fully-normalized" === x)
                    throw new F("Serializer does not support the requested normalization-form: fully-normalized","SESU0011");
            }
            na(x, K, U, ha={}) {
                let T = new de
                  , w = this.j;
                K.forEach(function(Z, S) {
                    let da = "";
                    if (Z.kb.USE_NULL_MARKERS) {
                        const fa = Z.value.split("\x00");
                        for (let na = 0; na < fa.length; na++)
                            da += 1 === na % 2 ? fa[na] : fa[na].normalize(w),
                            da += "\x00"
                    } else
                        da = Z.kb.NO_NORMALIZATION ? Z.value : Z.value.normalize(w);
                    T.set(S, {
                        value: da,
                        kb: Z.kb
                    })
                });
                this.g.na(x, T, U, ha)
            }
            text(x, K={}) {
                this.g.text(K.NO_NORMALIZATION ? x : x.normalize(this.j), K)
            }
        }
        class L extends Qd {
            constructor(x) {
                super();
                this.ya = x || null
            }
            na(x, K, U, ha={}) {
                let T = q(this.ya, !0)
                  , w = new de;
                K.forEach(function(Z, S) {
                    var da = w.set;
                    {
                        var fa = Z.value;
                        let na = Z.kb;
                        na.DISABLE_ESCAPING || na.NO_CHARACTER_MAP ? Z = {
                            value: fa,
                            kb: na
                        } : (Z = T(fa),
                        Z !== fa ? (fa = Object.assign({}, na),
                        fa.USE_NULL_MARKERS = !0,
                        Z = {
                            value: Z,
                            kb: fa
                        }) : Z = {
                            value: Z,
                            kb: na
                        })
                    }
                    da.call(w, S, Z)
                });
                this.g.na(x, w, U, ha)
            }
            text(x, K={}) {
                if (K.DISABLE_ESCAPING || K.NO_CHARACTER_MAP)
                    this.g.text(x, K);
                else {
                    const Z = this.ya;
                    let S = "";
                    var U = !1
                      , ha = !0;
                    for (var T = 0; T < x.length; T++) {
                        var w = x.charCodeAt(T);
                        if (w >= Z.min && w <= Z.max) {
                            ha = !1;
                            break
                        }
                    }
                    if (ha)
                        S = x;
                    else
                        for (ha = 0; ha < x.length; ha++) {
                            T = x.charAt(ha);
                            w = x.charCodeAt(ha);
                            const da = 55296 <= w && 56320 >= w;
                            da && (w = x.codePointAt(ha));
                            Z.ya[w] ? (U || ("" !== S && (this.g.text(S, K),
                            S = ""),
                            U = !0),
                            S += Z.ya[w],
                            da && ha++) : (U && (U = Object.assign({}, K),
                            U.DISABLE_ESCAPING = !0,
                            U.NO_NORMALIZATION = !0,
                            this.g.text(S, U),
                            S = "",
                            U = !1),
                            S += T)
                        }
                    U ? (x = Object.assign({}, K),
                    x.DISABLE_ESCAPING = !0,
                    x.NO_NORMALIZATION = !0,
                    this.g.text(S, x)) : this.g.text(S, K)
                }
            }
        }
        class aa extends Qd {
            constructor(x, K, U) {
                super();
                this.V = x || null;
                this.encoding = K;
                this.K = U;
                this.B = [];
                this.j = "";
                this.I = {};
                if ("fully-normalized" === U)
                    throw new F("Serializer does not support the requested normalization-form: fully-normalized","SESU0011");
            }
            na(x, K, U, ha={}) {
                this.flush();
                this.B.push(x.toEQName());
                this.g.na(x, K, U, ha)
            }
            endElement() {
                this.flush();
                this.B.pop();
                this.g.endElement()
            }
            text(x, K={}) {
                0 <= this.V.indexOf(0 === this.B.length ? null : this.B[this.B.length - 1]) ? K.DISABLE_ESCAPING ? (this.flush(),
                this.g.text(x, K)) : (this.j += x,
                this.I = K) : this.g.text(x, K)
            }
            wa(x, K={}) {
                this.flush();
                this.g.wa(x, K)
            }
            va(x, K, U={}) {
                this.flush();
                this.g.va(x, K, U)
            }
            flush() {
                if ("" !== this.j) {
                    const K = this.K ? this.j.normalize(this.K) : this.j
                      , U = K.length;
                    for (var x = 0; x < U; ) {
                        let ha = x;
                        for (; ha < U; )
                            if (c(K.charCodeAt(ha), this.encoding))
                                ha++;
                            else
                                break;
                        ha > x && this.aa(K.substring(x, ha));
                        ha < U && (x = Object.assign({}, this.I),
                        x.DISABLE_ESCAPING = !1,
                        x.NO_CHARACTER_MAP = !0,
                        x.NO_NORMALIZATION = !0,
                        this.g.text(K.charAt(ha), x));
                        x = ++ha
                    }
                    this.j = "";
                    this.I = {}
                }
            }
            aa(x) {
                let K = Object.assign({}, this.I);
                K.DISABLE_ESCAPING = !0;
                K.NO_CHARACTER_MAP = !0;
                K.NO_NORMALIZATION = !0;
                this.g.text("<![CDATA[", K);
                let U = 0
                  , ha = x.length;
                for (; U < ha; ) {
                    let T = x.substring(U, ha).indexOf("]]\x3e");
                    0 <= T ? (this.g.text(x.substring(U, T + 2) + "]]\x3e<![CDATA[", K),
                    U = T + 2) : (this.g.text(x.substring(U, ha) + "]]\x3e", K),
                    U = ha)
                }
            }
        }
        class z extends W {
            constructor(x, K) {
                super(x, K);
                this.ta = -1E6;
                this.Xe = "area base br col embed hr img input link meta param source track wbr".split(" ");
                this.Yc = {
                    "*": ["hidden", "autofocus", "itemscope"],
                    audio: ["autoplay", "controls", "loop", "muted"],
                    button: ["disabled", "formnovalidate"],
                    details: ["open"],
                    dialog: ["open"],
                    fieldset: ["disabled"],
                    form: ["novalidate"],
                    img: ["ismap"],
                    input: "checked disabled multiple readonly required formnovalidate".split(" "),
                    iframe: ["allowfullscreen", "allowpaymentrequest"],
                    ol: ["reversed"],
                    optgroup: ["disabled"],
                    option: ["selected", "disabled"],
                    script: ["defer", "async", "nomodule"],
                    select: ["multiple", "disabled", "required"],
                    textarea: ["disabled", "readonly", "required"],
                    track: ["default"],
                    video: ["autoplay", "controls", "loop", "muted", "playsinline"]
                }
            }
            na(x, K, U, ha={}) {
                super.na(x, K, U, ha);
                x.hasURI("") && ["script", "style"].includes(x.local.toLowerCase()) && (this.ta = 0);
                this.ta++
            }
            endElement() {
                let x = this.eb.pop();
                this.ta--;
                0 === this.ta && (this.ta = -1E6);
                this.K.pop();
                this.B && (this.g.write(">"),
                this.B = !1);
                this.Xe.includes(x.local.toLowerCase()) && E(x) || this.g.write("</" + x.toString() + ">")
            }
            text(x, K={}) {
                0 < this.ta && !K.DISABLE_ESCAPING ? (K = Object.assign({}, K),
                K.DISABLE_ESCAPING = !0,
                super.text(x, K)) : super.text(x, K)
            }
            va(x, K) {
                this.I || this.aa();
                this.B && this.V();
                if (0 <= K.indexOf(">"))
                    throw new F("A processing instruction in HTML must not contain a > character","SERE0015");
                this.g.write("<?" + this.j(x, !1) + " " + this.j(K, !1) + ">")
            }
            aa() {
                this.zb || (this.Pa["byte-order-mark"] && "UTF-8" === this.Pa.encoding && this.g.write("\ufeff"),
                this.zb = !0)
            }
            he(x, K) {
                if (K) {
                    const U = this;
                    K.forEach((ha,T)=>{
                        x.hasURI("") && this.Wf(x, T, ha.value) ? U.g.write(" " + T.toString()) : U.ee(T, ha)
                    }
                    )
                }
            }
            Ca(x) {
                let K = this.Pa["doctype-system"] || null
                  , U = this.Pa["doctype-public"] || null;
                null === K && null === U ? E(x) && "html" === x.local.toLowerCase() && (this.ra && this.g.write("\n"),
                this.g.write("<!DOCTYPE " + x.toString() + ">\n"),
                this.xa = !0) : null === K ? (x = E(x) && "html" === x.local.toLowerCase() ? x.toString() : "html",
                this.ra && this.g.write("\n"),
                this.g.write("<!DOCTYPE " + x + "\n"),
                this.g.write('  PUBLIC "' + U + '">\n'),
                this.xa = !0) : super.Ca("html" === x.local.toLowerCase() ? x : n.QName.fromParts("", "", "html"))
            }
            Wf(x, K, U) {
                K = K.local.toLowerCase();
                x = x.local.toLowerCase();
                return K === U.toLowerCase() && (this.Yc[x] && this.Yc[x].includes(K) || this.Yc["*"].includes(K))
            }
        }
        class D extends ma {
            constructor(x, K) {
                super(x, K);
                this.Wf = "pre script style textarea title xmp".split(" ");
                this.he = "a abbr acronym applet area audio b basefont bdi bdo big br button canvas cite code data datalist del dfn em embed font i iframe img input ins kbd label map mark math meter noscript object output picture progress q ruby s samp script select small span strike strong sub sup svg template textarea time tt u var video wbr".split(" ");
                this.ta = this.Yc = !1;
                this.Yd = []
            }
            na(x, K, U, ha={}) {
                this.Yc = this.he.includes(x.local.toLowerCase()) && E(x);
                this.K || this.B ? this.ra() : this.aa();
                this.I++;
                0 > this.j && this.Wf.includes(x.local.toLowerCase()) && E(x) && (this.j = this.I);
                this.eb && -1 === this.j && 0 <= this.eb.indexOf(x.toEQName()) && (this.j = this.I);
                this.g.na(x, K, U, ha);
                this.K = this.V = !0;
                this.Yc = this.ta = this.B = !1;
                this.Yd.push(x)
            }
            endElement() {
                let x = this.Yd.pop();
                this.I--;
                this.B && !this.V ? this.ra() : this.aa();
                this.g.endElement();
                this.V = !1;
                this.B = !0;
                this.K = !1;
                this.ta = this.he.includes(x.local.toLowerCase()) && E(x);
                this.I === this.j - 1 && (this.j = -1)
            }
            text(x, K={}) {
                super.text(x, K);
                0 > this.j && "" === Ha.trim(x) || (this.ta = !1)
            }
            wa(x, K={}) {
                super.wa(x, K);
                this.ta = !1
            }
            va(x, K, U={}) {
                super.va(x, K, U);
                this.ta = !1
            }
            ra() {
                0 <= this.j || this.Yc || this.ta ? this.aa() : this.Xe()
            }
        }
        class y extends Qd {
            na(x, K, U, ha={}) {
                for (let T in U)
                    H(U[T]) && delete U[T];
                H(x.uri) && ("" !== x.prefix && (x = n.QName.fromParts("", x.uri, x.local)),
                U[""] = x.uri);
                K.forEach((T,w)=>{
                    H(w.uri) && (U[w.prefix] = w.uri)
                }
                );
                super.na(x, K, U, ha)
            }
        }
        class I extends W {
            constructor(x, K) {
                super(x, K);
                this.ta = "area base br col embed hr img input link meta param source track wbr".split(" ")
            }
            endElement() {
                this.K.pop();
                let x = this.eb.pop();
                this.B && this.ta.includes(x.local) && E(x) ? (this.g.write(" />"),
                this.B = !1) : (this.B && super.V(),
                this.g.write("</" + x.toString() + ">"))
            }
            text(x, K={}) {
                (this.I || "" !== Ha.trim(x)) && super.text(x, K)
            }
            Ca(x) {
                let K = this.Pa["doctype-system"] || null;
                null === K && E(x) && "html" === x.local.toLowerCase() ? (this.ra && this.g.write("\n"),
                this.g.write("<!DOCTYPE " + x.toString() + ">\n"),
                this.xa = !0) : null !== K && super.Ca(x)
            }
        }
        class R extends Qd {
            na(x, K, U, ha) {
                let T = !1;
                K.forEach((w,Z)=>T = T || p(x, Z));
                if (T) {
                    const w = new de;
                    K.forEach((Z,S)=>{
                        if (p(x, S)) {
                            const da = cd.escape(Z.value.normalize("NFC"), fa=>32 > fa || 126 < fa);
                            Z = Object.assign({}, Z.kb);
                            Z.DISABLE_ESCAPING = !1;
                            Z.NO_CHARACTER_MAP = !0;
                            Z.NO_NORMALIZATION = !0;
                            w.set(S, {
                                value: da,
                                kb: Z
                            })
                        } else
                            w.set(S, Z)
                    }
                    );
                    super.na(x, w, U, ha)
                } else
                    super.na(x, K, U, ha)
            }
        }
        class M extends Qd {
            constructor(x) {
                super();
                this.B = x;
                this.j = !1
            }
            na(x, K, U, ha={}) {
                if ("meta" === x.local.toLowerCase() && E(x)) {
                    let T = this.j;
                    K.forEach(function(w, Z) {
                        "http-equiv" === Z.toString().toLowerCase() && "content-type" === w.value.trim().toLowerCase() && (T = !0)
                    });
                    this.j = T
                }
                this.j || (super.na(x, K, U, ha),
                "head" === x.local.toLowerCase() && E(x) && (K = new de,
                K.set(n.QName.fromParts("", "", "http-equiv"), {
                    value: "Content-Type",
                    kb: {}
                }),
                K.set(n.QName.fromParts("", "", "content"), {
                    value: (this.B["media-type"] || "text/html") + "; charset=" + (this.B.encoding || "UTF-8"),
                    kb: {}
                }),
                this.g.na(n.QName.fromParts("", x.uri, "meta"), K, {}, {}),
                this.g.endElement()))
            }
            endElement() {
                this.j ? this.j = !1 : this.g.endElement()
            }
        }
        class ca extends Sd {
            constructor(x, K, U) {
                super(U);
                this.I = x;
                this.g = K;
                this.ya = x["use-character-maps"] || null
            }
            close() {
                this.zb(this.result());
                this.g.end && this.g.end();
                super.close()
            }
            Ca(x) {
                this.I["normalization-form"] && "none" !== this.I["normalization-form"] && (x = x.normalize(this.I["normalization-form"]));
                const K = this.I.encoding || "UTF-8";
                let U = "";
                for (let ha = 0; ha < x.length; ha++) {
                    let T = x.charCodeAt(ha)
                      , w = x.charAt(ha);
                    switch (w) {
                    case '"':
                        U += '\\"';
                        break;
                    case "\b":
                        U += "\\b";
                        break;
                    case "\f":
                        U += "\\f";
                        break;
                    case "\n":
                        U += "\\n";
                        break;
                    case "\r":
                        U += "\\r";
                        break;
                    case "\t":
                        U += "\\t";
                        break;
                    case "\\":
                        U += "\\\\";
                        break;
                    case "/":
                        U += "\\/";
                        break;
                    default:
                        U = 31 >= T || 127 <= T && 159 >= T || !c(T, K) ? U + ("\\u" + ("0000" + T.toString(16).toUpperCase()).slice(-4)) : U + w
                    }
                }
                return U
            }
            ta(x) {
                let K = '"';
                if (this.ya) {
                    const w = this.ya;
                    let Z = ""
                      , S = !1;
                    var U = !0;
                    for (var ha = 0; ha < x.length; ha++) {
                        var T = x.charCodeAt(ha);
                        if (T >= w.min && T <= w.max) {
                            U = !1;
                            break
                        }
                    }
                    if (U)
                        Z = x;
                    else
                        for (U = 0; U < x.length; U++) {
                            ha = x.charAt(U);
                            T = x.charCodeAt(U);
                            const da = 55296 <= T && 56320 >= T;
                            da && (T = x.codePointAt(U));
                            w.ya[T] ? (S || ("" !== Z && (K += this.Ca(Z),
                            Z = ""),
                            S = !0),
                            Z += w.ya[T],
                            da && U++) : (S && (K += Z,
                            Z = "",
                            S = !1),
                            Z += ha)
                        }
                    K = S ? K + Z : K + this.Ca(Z)
                } else
                    K += this.Ca(x);
                return K + '"'
            }
            zb(x) {
                function K(T) {
                    switch (T.length) {
                    case 0:
                        ha.g.write("null");
                        break;
                    case 1:
                        U(T[0]);
                        break;
                    default:
                        throw new F("Cannot output a sequence of length " + T.length + " as JSON","SERE0023");
                    }
                }
                function U(T) {
                    var w = La.XS;
                    if (La.pa(T))
                        if (w.boolean.matches(T))
                            ha.g.write(T.toString());
                        else if (w.numeric.matches(T)) {
                            T = T.toString();
                            if (["NaN", "INF", "-INF"].includes(T))
                                throw new F("Cannot output INF or NaN as JSON","SERE0020");
                            ha.g.write(T)
                        } else
                            ha.g.write(ha.ta(T.toString()));
                    else if (ac.X(T)) {
                        w = Object.assign({}, ha.I);
                        w.method = w["json-node-output-method"] || "xml";
                        w["item-separator"] = null;
                        w["omit-xml-declaration"] = !0;
                        w.encoding = "UTF-8";
                        const Z = new la;
                        r(T, w, Z, ha.ra);
                        ha.g.write(ha.ta(Z.toString()))
                    } else if (cd.isArray(T))
                        if (T = T.value,
                        0 === T.length)
                            ha.g.write("[]");
                        else {
                            ha.V("[");
                            K(T[0]);
                            for (w = 1; w < T.length; w++)
                                ha.aa(),
                                K(T[w]);
                            ha.K("]")
                        }
                    else if (T instanceof cc) {
                        let Z = !0;
                        ha.V("{");
                        const S = {};
                        T.forAllPairs(da=>{
                            Z ? Z = !1 : ha.aa();
                            const fa = ha.ta(da.k.toString());
                            if (!ha.I["allow-duplicate-names"]) {
                                if (S[fa])
                                    throw new F("Duplicate key '" + fa + "' in serialized JSON map","SERE0022");
                                S[fa] = !0
                            }
                            ha.g.write(fa);
                            ha.eb();
                            K(da.v)
                        }
                        );
                        ha.K("}")
                    } else
                        throw new F("Cannot output " + sa.showValue(T) + " as JSON","SERE0021");
                }
                const ha = this;
                K(x)
            }
            V(x) {
                this.g.write(x)
            }
            K(x) {
                this.g.write(x)
            }
            aa() {
                this.g.write(",")
            }
            eb() {
                this.g.write(":")
            }
        }
        class ea extends ca {
            constructor(x, K, U) {
                super(x, K, U);
                this.j = 0;
                this.xa = x["Q{http://saxon.sf.net/}indent-spaces"] || 3
            }
            V(x) {
                super.V(x);
                this.j++;
                this.g.write("\n".padEnd(this.j * this.xa + 1, " "))
            }
            K(x) {
                this.j--;
                this.g.write("\n".padEnd(this.j * this.xa + 1, " "));
                super.K(x)
            }
            aa() {
                super.aa();
                this.g.write("\n".padEnd(this.j * this.xa + 1, " "))
            }
            eb() {
                this.g.write(": ")
            }
        }
        class ja extends Sd {
            constructor(x, K, U) {
                super(U);
                this.I = x;
                this.g = K;
                this.ra = U;
                this.ya = x["use-character-maps"] || null
            }
            close() {
                function x(S, da) {
                    for (let fa in ["fn", "math", "map", "array", "xs"])
                        if (Zb.withPrefix[fa] === S)
                            return fa + ":" + da;
                    return "Q{" + S + "}" + da
                }
                function K(S) {
                    return T.ya ? q(T.ya, !1)(S) : S
                }
                function U(S, da) {
                    if (1 === S.length)
                        ha(S[0], da);
                    else {
                        da.write("(");
                        let fa = !0;
                        for (let na = 0; na < S.length; na++)
                            fa ? fa = !1 : da.write(","),
                            ha(S[na], da);
                        da.write(")")
                    }
                }
                function ha(S, da) {
                    if (ac.X(S))
                        switch (S.nodeType) {
                        case 9:
                        case 11:
                        case 1:
                        case 7:
                        case 8:
                        case 3:
                        case 4:
                            var fa = Object.assign({}, T.I);
                            fa.method = "xml";
                            fa["item-separator"] = null;
                            fa.encoding = "UTF-8";
                            var na = new la;
                            g(fa, na, T.ra).append(S);
                            da.write(na.toString());
                            break;
                        case 2:
                            da.write(ac.ca(S) + '="' + S.value + '"', {});
                            break;
                        case 13:
                            da.write("*** Namespace Node ****", {})
                        }
                    else if (La.pa(S))
                        fa = S.code,
                        "AB" === fa ? da.write(S.toBoolean() ? "true()" : "false()") : Ia(S) ? (fa = S.toString(),
                        /"/.test(fa) ? da.write("'" + K(fa.replace(/'/g, "''")) + "'") : da.write('"' + K(S.toString().replace(/"/g, '""')) + '"')) : /^AD/.test(fa) ? da.write(S.toString()) : /^A[OF]/.test(fa) ? da.write(S.toString()) : da.write(`${La.pd(fa)} ("${S.toString()}")`);
                    else if (S instanceof $c) {
                        S = S.value;
                        da.write("[");
                        fa = !0;
                        for (na = 0; na < S.length; na++)
                            fa ? fa = !1 : da.write(","),
                            U(S[na], da);
                        da.write("]")
                    } else if (S instanceof cc) {
                        da.write("map{");
                        let va = !0;
                        S.forAllPairs(h=>{
                            va ? va = !1 : da.write(",");
                            ha(h.k, da);
                            da.write(":");
                            U(h.v, da)
                        }
                        );
                        da.write("}")
                    } else
                        S instanceof ad.XdmFunction ? S.local ? da.write(x(S.uri, S.local) + "#" + S.arity) : da.write("(anonymous function)#" + S.arity) : da.write("JS: " + sa.showValue(S))
                }
                const T = this;
                let w = this.result()
                  , Z = !0;
                for (let S = 0; S < w.length; S++) {
                    const da = w[S];
                    Z ? Z = !1 : this.g.write(this.I["item-separator"] || " ");
                    ha(da, this.g)
                }
                this.g.end && this.g.end();
                super.close()
            }
        }
        class Y extends Qd {
            constructor(x, K) {
                super();
                this.j = x;
                this.I = K;
                this.pending = [];
                this.B = !1
            }
            Ea(x={}) {
                this.pending.push(function(K) {
                    K.Ea(x)
                })
            }
            na(x, K, U, ha={}) {
                if (!this.B) {
                    const T = this.j["Q{http://saxon.sf.net/}stylesheet-version"];
                    let w = "xml";
                    "html" === x.local && "http://www.w3.org/1999/xhtml" === x.uri ? w = 10 === T ? "xml" : "xhtml" : "html" === x.local.toLowerCase() && "" === x.uri && (w = "html");
                    this.j = Object.assign({}, this.j);
                    this.j.method = w;
                    this.g = g(this.j, this.I);
                    this.g instanceof Y && sa.la("cannot create committed serializer: " + JSON.stringify(this.j));
                    this.pending.forEach(Z=>Z(this.g));
                    this.B = !0;
                    this.pending = []
                }
                super.na(x, K, U, ha)
            }
            text(x, K={}) {
                this.B ? super.text(x, K) : this.pending.push(function(U) {
                    U.text(x, K)
                })
            }
            wa(x, K={}) {
                this.B ? super.wa(x, K) : this.pending.push(function(U) {
                    U.wa(x, K)
                })
            }
            va(x, K, U={}) {
                this.B ? super.va(x, K, U) : this.pending.push(function(ha) {
                    ha.va(x, K, U)
                })
            }
            append(x, K={}) {
                this.B ? super.append(x, K) : this.pending.push(function(U) {
                    U.append(x, K)
                })
            }
            za() {
                this.B ? super.za() : this.pending.push(function(x) {
                    x.za()
                })
            }
            close() {
                this.B || (this.j.method = "xml",
                this.g = g(this.j, this.I),
                this.pending.forEach(x=>x(this.g)));
                super.close()
            }
        }
        class V extends B {
            constructor(x, K) {
                super(x, K);
                this.j = !1
            }
            text(x) {
                this.j || this.B();
                this.g.write(x)
            }
            append(x) {
                this.j || this.B();
                this.g.write(x.toString())
            }
            B() {
                this.Pa["byte-order-mark"] && "UTF-8" === this.Pa.encoding && this.g.write("\ufeff");
                this.j = !0
            }
        }
        class la {
            constructor() {
                this.ma = ""
            }
            write(x) {
                this.ma += x
            }
            toString() {
                return this.ma
            }
        }
        return {
            serialize: r,
            qh: g,
            StringWriter: la,
            parseParamDoc: function(x, K, U=null) {
                function ha(S, da="SEPM0017") {
                    throw new F("Serialization params: " + S,da);
                }
                function T(S, da=[]) {
                    const fa = ac.ca(S);
                    ac.Ja.Ha(S).forEachItem(function(na) {
                        na = ac.ca(na);
                        "" !== na.uri || da.includes(na.local) || ha("attribute @" + na.local + " must not appear on element " + fa.toString())
                    })
                }
                function w(S, da) {
                    let fa = ac.getAttribute(S, da, null);
                    null === fa && ha("attribute @" + da + " is missing on element " + ac.ca(S).toString());
                    return fa
                }
                "serialization-parameters" !== ac.ca(x).local && ha("root element name must be 'serialization-parameters'", U || "SEPM0017");
                "http://www.w3.org/2010/xslt-xquery-serialization" !== ac.ca(x).uri && ha("root element namespace must be http://www.w3.org/2010/xslt-xquery-serialization", U || "SEPM0017");
                T(x);
                let Z = [];
                ac.Ec(x).forEach(function(S) {
                    if (ac.hasURI(S, "http://www.w3.org/2010/xslt-xquery-serialization")) {
                        var da = ac.ca(S).local;
                        let fa;
                        Z.includes(da) && ha("duplicated parameter " + da, "SEPM0019");
                        Z.push(da);
                        "use-character-maps" === da ? (T(S),
                        fa = {
                            min: 0,
                            max: 0,
                            ya: {}
                        },
                        ac.Ec(S).forEach(function(na) {
                            if (ac.hasURI(na, "http://www.w3.org/2010/xslt-xquery-serialization") && "character-map" === ac.ca(na).local) {
                                T(na, ["character", "map-string"]);
                                const va = w(na, "character");
                                1 < va.length && ha("keys in a character map must all be one-character strings. Found " + va);
                                const h = va.codePointAt(0);
                                na = w(na, "map-string");
                                void 0 !== fa.ya[h] ? ha("character map contains two entries for the character " + va, "SEPM0019") : (fa.ya[h] = na,
                                0 === fa.min ? fa.min = h : h < fa.min && (fa.min = h),
                                h > fa.max && (fa.max = h))
                            } else
                                ha("invalid child of use-character-maps: " + ac.ca(na).toString())
                        }),
                        55296 < fa.min && (fa.min = 55296)) : (T(S, ["value"]),
                        fa = w(S, "value"),
                        fa = e(da, fa, function(na) {
                            return S.lookupNamespaceURI(na)
                        }));
                        "undefined" !== typeof fa && (K[da] = k(da, fa, K[da]))
                    } else
                        ac.hasURI(S, "") && ha("element in no namespace: " + ac.ca(S).local),
                        da = ac.ca(S).toEQName(),
                        Z.includes(da) && ha("duplicated parameter " + da, "SEPM0019"),
                        Z.push(da)
                })
            },
            pf: k,
            zf: e,
            yf: function(x, K, U) {
                x = e(x, K);
                return t(x, U)
            },
            uj: t,
            jj: function(x) {
                function K(w, Z="SEPM0017") {
                    throw new F("Serialization params: " + w,Z);
                }
                let U = 0
                  , ha = 0
                  , T = {};
                for (let[w,Z] of Object.entries(x)) {
                    x = w;
                    1 < x.length && K("keys in a character map must all be one-character strings. Found " + x);
                    const S = x.codePointAt(0);
                    void 0 !== T[S] && K("character map contains two entries for the character " + x, "SEPM0019");
                    T[S] = Z;
                    0 === U ? U = S : S < U && (U = S);
                    S > ha && (ha = S);
                    55296 < U && (U = 55296)
                }
                return {
                    min: U,
                    max: ha,
                    ya: T
                }
            }
        }
    }();
    // Input 35
    class he {
        constructor(a, c, q, E) {
            this.principalResult = a;
            this.resultDocuments = c;
            this.stylesheetInternal = q;
            this.masterDocument = E
        }
    }
    class ie {
        constructor(a, c) {
            this.destination = a;
            this.save = c
        }
    }
    class je extends ie {
        constructor(a, c) {
            super(a, function(q, E) {
                c[q.toString()] = E
            })
        }
    }
    ;// Input 36
    const ke = function() {
        function a(b, d, l, r, n=null) {
            d = d.fixed.ka;
            if (b = b.next()) {
                b = Ha.trim(b.toString());
                if (n && Ha.Lb(b))
                    return "##local" === n && (n = d.Ic(l)[""] || ""),
                    "Q{" + n + "}" + b;
                try {
                    const B = A.QName.fromString(b, d.Wd(l, !1));
                    if (null === B)
                        throw new F("Invalid QName " + b,r,l);
                    return "Q{" + B.uri + "}" + B.local
                } catch (B) {
                    if (B instanceof F && ["FORG0001", "XTDE0290"].includes(B.code))
                        throw new F(B.message,r);
                    throw B;
                }
            } else
                return null
        }
        function c(b) {
            return (b = b.next()) ? b.value : ""
        }
        function q(b) {
            function d(n) {
                return n.replace(/[^A-Za-z]/g, B=>"0" + B.codePointAt(0))
            }
            const l = ac.Ja;
            b = l.Ya(b).expand().reverse();
            let r = "";
            for (let n = 0; n < b.length; n++)
                if (b[n]instanceof bc)
                    r += "N" + d(b[n].prefix);
                else if (2 === b[n].nodeType)
                    r += "A" + d(ac.ca(b[n]).toEQName());
                else {
                    const B = l.Oc(b[n]).count() + 1;
                    r += fe.bg(B, 0 === n % 2 ? "a" : "A")
                }
            return "d" + ac.ui(b[0]) + r
        }
        function E(b, d, l) {
            let r = "";
            b[0].forEachItem(function(ma) {
                r += ma.value.trim() + " "
            });
            d = b[1] ? b[1].next() : f.rc(ed(d));
            if (!f.X(d))
                throw new F("Context item is not a node for fn:" + l + "()","XPTY0004");
            9 !== d.nodeType && (d = f.rc(d));
            let n;
            l = [];
            b = r.trim().split(/\s+/);
            if (9 === d.nodeType) {
                for (var B of b)
                    (n = d.getElementById(B)) && l.push(n);
                if (pa.jd())
                    for (B = O.me(d); null !== (n = B.next()); )
                        if (1 === n.nodeType) {
                            d = n.getAttributeNS(Zb.xml, "id");
                            var W = n.getAttribute("id");
                            (null != d && b.includes(d.trim()) || null != W && b.includes(W.trim())) && l.push(n)
                        }
                return f.kd(Kb(l))
            }
            if (11 === d.nodeType) {
                for (B = O.me(d); null !== (n = B.next()); )
                    1 === n.nodeType && (d = n.getAttributeNS(Zb.xml, "id"),
                    W = n.getAttribute("id"),
                    (null != d && b.includes(d.trim()) || null != W && b.includes(W.trim())) && l.push(n));
                return f.kd(Kb(l))
            }
            return Ob
        }
        function H(b, d, l) {
            let r = d;
            b.forEachItem(function(n) {
                r = l(n, r)
            });
            return r
        }
        function p(b) {
            function d(r) {
                throw new F(r,"FORG0006");
            }
            const l = "max" === b ? function(r) {
                return 0 < r
            }
            : function(r) {
                return 0 > r
            }
            ;
            return function(r, n, B) {
                let W = r[0];
                n.fixed.ka.Db(B, "i") && (W = W.filter(function(ja) {
                    return !Hd.tc(ja)
                }));
                r = Hd.Xb(B, r[1], "compare", n);
                const ma = Hd.oi(r)
                  , qa = A.untypedAtomic.matches
                  , L = A.numeric.matches
                  , aa = A.double.matches
                  , z = A.float.matches
                  , D = A.anyURI.matches
                  , y = A.string.matches;
                r = A.duration.matches;
                const I = A.yearMonthDuration.matches
                  , R = A.dayTimeDuration.matches;
                n = A.QName.matches;
                const M = A.double.R
                  , ca = A.float.R
                  , ea = A.string.R;
                W = W.mapOneToOne(function(ja) {
                    return qa(ja) ? M(ja) : ja
                });
                B = W.next();
                if (null === B)
                    return Ob;
                n(B) && d(b + "() not defined over QName");
                !r(B) || I(B) || R(B) || d(b + "() not defined over mixed durations");
                return Pb(H(W, B, function(ja, Y) {
                    (y(ja) && L(Y) || y(Y) && L(ja)) && d("Cannot compare string with numeric");
                    (I(ja) && !I(Y) || R(ja) && !R(Y)) && d("Cannot compare mixed durations");
                    if (Hd.tc(Y))
                        return aa(ja) ? M(Y) : Y;
                    if (Hd.tc(ja))
                        return aa(Y) ? M(ja) : ja;
                    aa(Y) && !y(ja) ? ja = M(ja) : aa(ja) && !y(Y) ? Y = M(Y) : z(Y) && !y(ja) ? ja = ca(ja) : z(ja) && !y(Y) && (Y = ca(Y));
                    D(Y) && y(ja) ? Y = ea(Y) : D(ja) && y(Y) && (ja = ea(ja));
                    try {
                        return l(ma(ja, Y)) ? ja : Y
                    } catch (V) {
                        throw V instanceof F && "XPTY0004" === V.code && (V.code = "FORG0006"),
                        V;
                    }
                }))
            }
        }
        function g(b, d) {
            if (2 !== d.length && 5 !== d.length)
                throw new F("Wrong number of arguments (" + d.length + ") for  " + b,"XPST0017");
        }
        function e(b, d) {
            b = b[0].next();
            if (null === b)
                return Ob;
            if ("timezone" === d)
                return null === b.Fa ? Ob : Pb(A.dayTimeDuration.hh(b.Fa));
            if ("seconds" === d)
                return d = b.proxy(),
                Wb(d.getUTCSeconds() + d.getUTCMilliseconds() / 1E3);
            b = b.proxy()[d]();
            "getUTCMonth" === d && b++;
            return Ub(b)
        }
        function k(b, d) {
            b = b[0].next();
            return null === b ? Ob : 5 !== d ? Ub(jb(b)[d] * kb(b)) : Wb(jb(b)[d] * kb(b))
        }
        function v(b, d, l) {
            function r(W, ma) {
                return Pb(La.codes[d].fromDate(W, ma))
            }
            const n = b[0].next();
            if (!n)
                return Ob;
            l = l.fixed.Jb.getTimezoneOffset();
            if (b[1]) {
                var B = b[1].next();
                b = null !== B ? B.Qa / 6E4 : null;
                if (null !== b && (-840 > b || 840 < b))
                    throw new F("timezone out of bounds " + B,"FODT0003");
            } else
                b = -l;
            B = n.Fa;
            if (null === B && null === b)
                return Pb(n);
            if (null === B && null !== b)
                return r(gb(n, -l - b).Na, b);
            if (null !== B && null === b)
                return r(gb(n, l + B).Na, null);
            if (null !== B && null !== b)
                return r(n.Na, b)
        }
        function t(b, d, l, r) {
            let n = b[1].expand();
            const B = b[2].expand()[0];
            B instanceof ad.XdmFunction || sa.la("fold-" + (r ? "left" : "right") + "() function argument not instance of XdmFunction");
            b = b[0].expand();
            r || (b = b.reverse());
            b.forEach(W=>{
                n = B.evaluate(r ? [n, [W]] : [[W], n], d, l).expand()
            }
            );
            return Kb(n)
        }
        let C = null
          , m = null;
        const f = ac
          , A = La.XS
          , O = f.Ja;
        return {
            abs: function(b) {
                b = b[0].next();
                return null === b ? Ob : Pb(b.abs())
            },
            "accumulator-after": function(b, d, l) {
                b = a(b[0], d, l, "XTDE3340");
                return Kb(Ld.ei(l, b, ed(d), d))
            },
            "accumulator-before": function(b, d, l) {
                b = a(b[0], d, l, "XTDE3340");
                return Kb(Ld.fi(l, b, ed(d), d))
            },
            "adjust-date-to-timezone": function(b, d) {
                return v(b, "AA", d)
            },
            "adjust-dateTime-to-timezone": function(b, d) {
                return v(b, "AM", d)
            },
            "adjust-time-to-timezone": function(b, d) {
                return v(b, "AT", d)
            },
            "analyze-string": function(b, d) {
                const l = c(b[0]);
                var r = d.ja.createDocumentFragment();
                const n = Zb.Oa
                  , B = d.ja.createElementNS(n, "analyze-string-result");
                r.appendChild(B);
                if ("" === l)
                    return Pb(B);
                r = b[1].next().toString();
                b = b[2] ? b[2].next().toString() : "";
                Zd.Of(l, r, b, !1, !1).forEach(function(W) {
                    let ma;
                    if (W.Lc) {
                        let L;
                        W = W.groups;
                        ma = d.ja.createElementNS(n, "match");
                        var qa = 0;
                        for (let aa = 1; aa < W.length; aa++)
                            W[aa] && (L = W[0].indexOf(W[aa], qa),
                            L > qa && (qa = d.ja.createTextNode(W[0].substring(qa, L)),
                            ma.appendChild(qa)),
                            qa = d.ja.createElementNS(n, "group"),
                            qa.setAttribute("nr", aa),
                            qa.appendChild(d.ja.createTextNode(W[aa])),
                            ma.appendChild(qa),
                            qa = L + W[aa].length);
                        qa < W[0].length && (qa = d.ja.createTextNode(W[0].substring(qa, L)),
                        ma.appendChild(qa))
                    } else
                        ma = d.ja.createElementNS(n, "non-match"),
                        qa = d.ja.createTextNode(W.string),
                        ma.appendChild(qa);
                    B.appendChild(ma)
                });
                return Pb(B)
            },
            apply: function(b, d, l) {
                const r = d.fixed.ka
                  , n = b[0].next();
                b = b[1].next();
                const B = b.value;
                if (n instanceof ad.XdmFunction)
                    return n.evaluate(B, d, l);
                d = r.Sb(b.value[0][0]).next();
                if (n instanceof $c)
                    return d = A.numeric.matches(d) ? d.toNumber() : A.double.R(d).toNumber(),
                    Kb(n.get(d));
                if (n instanceof cc)
                    return Kb(n.get(d));
                sa.la("Target of apply() is neither map(*) nor array(*) nor function(*): actual value " + sa.showValue(n))
            },
            "available-environment-variables": function() {
                return Ob
            },
            "available-system-properties": function() {
                const b = []
                  , d = {
                    version: "3.0",
                    vendor: "Saxonica",
                    "vendor-url": "http://www.saxonica.com/",
                    "product-name": "SaxonJS",
                    "product-version": "2.6",
                    "is-schema-aware": "no",
                    "supports-serialization": "yes",
                    "supports-backwards-compatibility": "yes",
                    "supports-namespace-axis": "yes",
                    "supports-streaming": "no",
                    "supports-dynamic-evaluation": "yes",
                    "supports-higher-order-functions": "yes",
                    "xpath-version": "3.1",
                    "xsd-version": "1.1"
                };
                for (let l in d)
                    d.hasOwnProperty(l) && b.push(A.QName.fromParts("xsl", Zb.Wc, l));
                return Kb(b)
            },
            avg: function(b, d) {
                b = b[0].mapOneToOne(d.fixed.ka.Xh);
                d = b.next();
                if (null === d)
                    return Ob;
                d = {
                    ug: d,
                    count: 1
                };
                const l = mb["a+a"];
                try {
                    const r = H(b, d, function(n, B) {
                        return {
                            ug: l(B.ug, n),
                            count: B.count + 1
                        }
                    });
                    return Pb(mb["a/a"](r.ug, A.integer.fromNumber(r.count)))
                } catch (r) {
                    throw new F("Input to avg() contains a mix of numeric and non-numeric values ","FORG0006");
                }
            },
            "base-uri": function(b) {
                return b[0].mapOneToOne(function(d) {
                    if (d = f.baseURI(d)) {
                        const l = d.indexOf("#");
                        0 <= l && (d = d.substring(0, l))
                    }
                    return null === d ? null : A.anyURI.fromString(d)
                })
            },
            "boolean": function(b, d) {
                return Xb(d.fixed.ka.Fd(b[0]))
            },
            ceiling: function(b) {
                b = b[0].next();
                return Pb(null === b ? null : b.Rf())
            },
            "codepoint-equal": function(b) {
                const d = b[0].next();
                b = b[1].next();
                return null === d || null === b ? Ob : Xb(d.toString() === b.toString())
            },
            "codepoints-to-string": function(b) {
                return Tb(Ea(b[0].expand().map(function(d) {
                    return d.toNumber()
                })))
            },
            "collation-key": function(b, d, l) {
                const r = b[0].next();
                b = Hd.Xb(l, b[1], "collationKey", d);
                return Pb(A.base64Binary.fromUtf8EncodedString(b(r.value)))
            },
            collection: function(b, d, l) {
                const r = d.fixed.ka;
                var n = d.fixed.options.Tg;
                if (n && "function" === typeof n) {
                    let B = null;
                    b[0] && (b = b[0].next(),
                    null !== b && (B = pa.Fb(b.toString(), r.Ia(l, d))));
                    n = B ? n(B) : n();
                    if ("undefined" === typeof n)
                        throw new F("No available collection for supplied URI: " + B,"FODC0002",l);
                    n = r.Ra(n);
                    d = d.fixed.Ee;
                    if (null !== d)
                        for (l = 0; l < n.length; l++)
                            n[l] = d(n[l]);
                    return Array.isArray(n) ? Kb(n) : Pb(n)
                }
                if (b[0])
                    throw new F("Unknown collection (no collectionFinder supplied)","FODC0002",l);
                return Ob
            },
            compare: function(b, d, l) {
                const r = b[0].next()
                  , n = b[1].next();
                if (null === r || null === n)
                    return Ob;
                b = Hd.Xb(l, b[2], "compare", d);
                return Ub(b(r.value, n.value))
            },
            concat: function(b) {
                return Tb(b.map(function(d) {
                    d = d.next();
                    return null === d ? "" : A.string.R(d)
                }).join(""))
            },
            contains: function(b, d, l) {
                const r = c(b[0])
                  , n = c(b[1]);
                b = Hd.Xb(l, b[2], "contains", d);
                return Xb(b(r, n))
            },
            "contains-token": function(b, d, l) {
                function r(W) {
                    return B(W, n)
                }
                let n = c(b[1]);
                n = Ha.trim(n);
                if ("" === n)
                    return Xb(!1);
                const B = Hd.Xb(l, b[2], "equals", d);
                for (; null !== (d = b[0].next()); )
                    if (0 <= d.toString().split(/[ \n\r\t]+/).findIndex(r))
                        return Xb(!0);
                return Xb(!1)
            },
            "copy-of": function(b, d, l) {
                const r = Vd(d)
                  , n = Zd.Fc(r);
                b[0].forEachItem(B=>Zd.qf(B, d, n, l, !0, !0));
                n.close();
                return Kb(r.Ob)
            },
            count: function(b) {
                return Ub(b[0].count())
            },
            "current-date": function(b, d) {
                return Pb(A.cd.fromDate(d.fixed.Jb, -d.fixed.Jb.getTimezoneOffset()))
            },
            "current-dateTime": function(b, d) {
                return Pb(A.Ed.fromDate(d.fixed.Jb, -d.fixed.Jb.getTimezoneOffset()))
            },
            "current-group": function() {
                throw new F("The current-group() function cannot be invoked dynamicaly","XTDE1061");
            },
            "current-grouping-key": function() {
                throw new F("The current-grouping-key() function cannot be invoked dynamicaly","XTDE1071");
            },
            "current-merge-group": function(b, d) {
                if (null === d.Bb)
                    throw new F("There is no current merge group","XTDE3480");
                if (b[0]) {
                    b = b[0].next().value;
                    if (d = d.Bb.groups[b])
                        return Kb(d);
                    throw new F("Unknown merge source " + b,"XTDE3490");
                }
                return Kb(d.Bb.items)
            },
            "current-merge-key": function(b, d) {
                if (null === d.Bb)
                    throw new F("There is no current merge group","XTDE3510");
                return Kb(d.Bb.keys)
            },
            "current-output-uri": function(b, d) {
                b = 0 === d.ub.length ? null : d.ub[d.ub.length - 1];
                return null == b || "function" === d.qa ? Ob : Pb(b)
            },
            "current-time": function(b, d) {
                return Pb(A.time.fromDate(d.fixed.Jb, -d.fixed.Jb.getTimezoneOffset()))
            },
            data: function(b, d) {
                return b[0].mapOneToMany(d.fixed.ka.Sb)
            },
            dateTime: function(b) {
                const d = b[0].next();
                b = b[1].next();
                if (null === d || null === b)
                    return Ob;
                let l = "";
                if (null !== d.Fa)
                    if (null === b.Fa)
                        l = db(d);
                    else if (d.Fa !== b.Fa)
                        throw new F("timezones are incompatible ","FORG0008");
                return Pb(A.dateTime.fromString(d.toString().substring(0, 10) + "T" + b.toString() + l))
            },
            "day-from-date": function(b) {
                return e(b, "getUTCDate")
            },
            "day-from-dateTime": function(b) {
                return e(b, "getUTCDate")
            },
            "days-from-duration": function(b) {
                return k(b, 2)
            },
            "deep-equal": function(b, d, l) {
                d = Hd.Xb(l, b[2], "equals", d);
                return Xb(Fd(b[0], b[1], d))
            },
            "default-collation": function() {
                return Tb(Hd.$c)
            },
            "default-language": function() {
                return Pb(A.language.fromString("en"))
            },
            "distinct-values": function(b, d, l) {
                d = Hd.df(l, b[1], d);
                const r = Hd.xf(d);
                return b[0].filter(function(n) {
                    if (r.containsKey(n))
                        return !1;
                    r.inSituPut(n, !0);
                    return !0
                })
            },
            doc: function(b, d, l) {
                b = Nd.Lg(b, d, l);
                if (null === b)
                    return Pb(null);
                try {
                    let r = Nd.Dc(b, d);
                    const n = d.fixed.Ee;
                    n && (r = n(r));
                    return Pb(r)
                } catch (r) {
                    throw r;
                }
            },
            "doc-available": function(b, d, l) {
                const r = Nd.Lg(b, d, l);
                return null === r ? Xb(!1) : Nd.Ih(function() {
                    Nd.Dc(r, d)
                })
            },
            document: function(b, d, l) {
                const r = d.fixed.ka;
                let n, B;
                if (b[1] && (n = f.baseURI(b[1].next()),
                !n))
                    throw new F("No base URI available for second argument of document()","XTDE1162");
                n || (B = r.Ia(l, d));
                const W = d.fixed.Ee;
                return f.kd(b[0].mapOneToMany(function(ma) {
                    const qa = n ? n : f.X(ma) ? f.baseURI(ma) : B;
                    return r.Sb(ma).mapOneToOne(function(L) {
                        if (null === qa)
                            throw new F("No base URI for document('" + L + "')","XTDE1162");
                        L = Nd.Dc(pa.Fb(L.toString(), qa), d);
                        null !== W && (L = W(L));
                        return L
                    })
                }))
            },
            "document-uri": function(b) {
                b = b[0].next();
                return null !== b && 9 === b.nodeType && b._saxonDocUri ? Pb(A.anyURI.fromString(b._saxonDocUri)) : Ob
            },
            "element-available": function(b, d, l) {
                b = a(b[0], d, l, "XTDE1440", "##local").split("}");
                if (d = "http://www.w3.org/1999/XSL/Transform" === b[0].substring(2))
                    null == m && (m = pa.rf("elements")),
                    m[b[1]] || (d = !1);
                return Xb(d)
            },
            "element-with-id": function(b, d) {
                return E(b, d, "element-with-id")
            },
            empty: function(b) {
                return Xb(null === b[0].next())
            },
            "encode-for-uri": function(b) {
                b = encodeURIComponent(c(b[0])).replace(/[!'()*]/g, function(d) {
                    return "%" + d.charCodeAt(0).toString(16).toUpperCase()
                });
                return Tb(b)
            },
            "ends-with": function(b, d, l) {
                const r = c(b[0])
                  , n = c(b[1]);
                b = Hd.Xb(l, b[2], "endsWith", d);
                return Xb(b(r, n))
            },
            "environment-variable": function() {
                return Ob
            },
            error: function(b) {
                if (void 0 === b[0])
                    throw new F("fn:error() invoked","FOER0000");
                var d = b[0].next();
                d = d ? d.toEQName() : "FOER0000";
                const l = b[1] ? c(b[1]) : "";
                d = new F(l,d);
                b[2] && (d.errorObject = b[2].next());
                throw d;
            },
            "escape-html-uri": function(b) {
                return Tb(cd.escape(c(b[0]), function(d) {
                    return 32 > d || 126 < d
                }))
            },
            "exactly-one": function(b) {
                b = b[0].expand();
                if (1 !== b.length)
                    throw new F("Required length 1, actual length " + b.length,"FORG0005");
                return Pb(b[0])
            },
            exists: function(b) {
                return Xb(null !== b[0].next())
            },
            "false": function() {
                return Xb(!1)
            },
            filter: function(b, d, l) {
                const r = b[1].expand()[0];
                r.evaluate || sa.la("filter() argument is not a function");
                return b[0].mapOneToOne(function(n) {
                    const B = r.evaluate([[n]], d, l).expand();
                    if (Array.isArray(B) && 1 !== B.length || !A.boolean.matches(B[0]))
                        throw new F("Wrong type for function result in filter(). Expecting xs:boolean, supplied value is " + sa.showValue(B),"XPTY0004",l);
                    if (B[0].toBoolean())
                        return n
                })
            },
            floor: function(b) {
                return b[0].mapOneToOne(function(d) {
                    return d.floor()
                })
            },
            "fold-left": function(b, d, l) {
                return t(b, d, l, !0)
            },
            "fold-right": function(b, d, l) {
                return t(b, d, l, !1)
            },
            "format-date": function(b) {
                g("format-date", b);
                let d = b[0].next();
                return null === d ? Ob : b[2] ? Tb(fe.Hd("date", d, b[1].next().toString(), b[2].next(), b[3].next(), b[4].next())) : Tb(fe.Hd("date", d, b[1].next().toString()))
            },
            "format-dateTime": function(b) {
                g("format-dateTime", b);
                let d = b[0].next();
                return null === d ? Ob : b[2] ? Tb(fe.Hd("dateTime", d, b[1].next().toString(), b[2].next(), b[3].next(), b[4].next())) : Tb(fe.Hd("dateTime", d, b[1].next().toString()))
            },
            "format-integer": function(b) {
                const d = b[0].next();
                return null === d ? Tb("") : Tb(fe.bg(d, b[1].next().toString()))
            },
            "format-number": function(b, d, l) {
                const r = d.fixed.ka;
                var n = b[2] ? a(b[2], d, l, "FODF1280") : "Q{}";
                l = r.ke(l, d).hb[null !== n ? n : "Q{}"];
                if (!l)
                    throw new F("Unknown decimal format " + n,"FODF1280");
                n = b[0].next();
                null === n ? n = Number.NaN : n = n.toDouble().value;
                return Tb(fe.Hi(n, b[1].next().toString(), l, d))
            },
            "format-time": function(b) {
                g("format-time", b);
                let d = b[0].next();
                return null === d ? Ob : b[2] ? Tb(fe.Hd("time", d, b[1].next().toString(), b[2].next(), b[3].next(), b[4].next())) : Tb(fe.Hd("time", d, b[1].next().toString()))
            },
            "for-each": function(b, d, l) {
                const r = d.fixed.ka
                  , n = b[1].expand()[0];
                if (n instanceof ad.XdmFunction)
                    return b[0].mapOneToMany(function(B) {
                        return n.evaluate([[B]], d, l)
                    });
                if (n instanceof cc)
                    return b[0].mapOneToMany(B=>Kb(n.get(r.Sb(B).next())));
                if (n instanceof $c)
                    return b[0].mapOneToMany(function(B) {
                        B = r.Sb(B).next();
                        B = A.numeric.matches(B) ? B.toNumber() : A.double.R(B).toNumber();
                        return Kb(n.get(B))
                    });
                sa.la("for-each() function object not instance of XdmFunction | XdmArray | XdmMap")
            },
            "for-each-pair": function(b, d, l) {
                let r = b[2].expand();
                if (1 !== r.length)
                    throw new F("for-each-pair() must have exactly one function item as the third argument. Supplied length " + r.length,"XPTY0004",l);
                r = r[0];
                r instanceof ad.XdmFunction || sa.la("Function object not instance of XdmFunction");
                let n = [];
                const B = b[0];
                b = b[1];
                let W = B.next()
                  , ma = b.next();
                for (; W && ma; )
                    n = n.concat(r.evaluate([[W], [ma]], d, l).expand()),
                    W = B.next(),
                    ma = b.next();
                return Kb(n)
            },
            "function-arity": function(b) {
                b = b[0].next();
                return Pb(A.integer.fromNumber(b instanceof cc || b instanceof $c ? 1 : b.arity))
            },
            "function-available": function(b, d, l) {
                let r = !1;
                const n = a(b[0], d, l, "XTDE1400", Zb.Oa)
                  , B = b[1] ? b[1].next().toNumber() : -1
                  , W = d.fixed.La;
                Object.keys(W).forEach(function(ma) {
                    ma = W[ma];
                    ma.name === n && ma.actor && "function" === ma.actor.N && (0 > B ? r = !0 : (ma = cd.qb(ma.actor, "arg").length,
                    B === ma && (r = !0)))
                });
                r || (b = A.QName.fromEQName(n),
                null == C && (C = pa.rf("functions")),
                r = (d = C[b.uri]) && d[b.local] ? "concat" === b.local && b.uri === Zb.Oa && (-1 === B || 2 <= B) ? !0 : 0 <= B ? 0 <= d[b.local].indexOf(B) : !0 : !1);
                return Xb(r)
            },
            "function-lookup": function(b, d, l) {
                const r = b[0].next();
                b = b[1].next().toNumber();
                var n = Jd.find("SaxonJS").XPath;
                const B = d.ba(!0);
                B.bb = !0;
                n = n.getFnSignature(r, b, B);
                if (!n)
                    return Ob;
                d = n.isUserFunction ? new ad.Ff(n,d) : r.uri === Zb.lc ? new ad.Bf(n,r,l) : new ad.He(n,r,b,l,d);
                return Pb(d)
            },
            "function-name": function(b) {
                b = b[0].next();
                if (!(b instanceof ad.XdmFunction))
                    throw new F("Input to function-name() is not an XdmFunction ","XXXX9999");
                return b.ic() && b.ic().uri !== Zb.yg ? Pb(b.ic()) : Ob
            },
            "generate-id": function(b) {
                b = b[0].next();
                return Tb(b ? q(b) : "")
            },
            "has-children": function(b) {
                return Xb(null !== O.Ka(b[0].next()).next())
            },
            head: function(b) {
                return Pb(b[0].next())
            },
            "hours-from-dateTime": function(b) {
                return e(b, "getUTCHours")
            },
            "hours-from-duration": function(b) {
                return k(b, 3)
            },
            "hours-from-time": function(b) {
                return e(b, "getUTCHours")
            },
            id: function(b, d) {
                return E(b, d, "id")
            },
            idref: function() {
                return Ob
            },
            "implicit-timezone": function(b, d) {
                return Pb(A.dayTimeDuration.hh(-d.fixed.Jb.getTimezoneOffset()))
            },
            "index-of": function(b, d, l) {
                const r = Sb(b[0])
                  , n = b[1].next();
                b = Hd.Xb(l, b[2], "equals", d);
                const B = Hd.yi(b);
                return r.mapOneToOne(function(W) {
                    try {
                        return B(W, n) ? A.integer.fromNumber(r.position) : null
                    } catch (ma) {
                        return null
                    }
                })
            },
            innermost: function(b, d, l) {
                const r = d.fixed.ka.Db(l, "p") ? b[0] : f.kd(b[0]);
                return new Mb(function*() {
                    let n = null, B;
                    for (; null != (B = r.next()); )
                        if (n)
                            if (O.Zc(B).some(W=>W === n))
                                n = B;
                            else {
                                const W = n;
                                n = B;
                                yield W
                            }
                        else
                            n = B;
                    n && (yield n)
                }())
            },
            "in-scope-prefixes": function(b) {
                b = b[0].next();
                return Kb(f.Ic(b).map(function(d) {
                    return A.string.fromString(d.prefix)
                }))
            },
            "insert-before": function(b) {
                const d = b[1].next().value
                  , l = b[2]
                  , r = Sb(b[0]);
                return 1 > d ? Qb([l, r]) : d > r.last() ? Qb([r, l]) : r.mapOneToMany(function(n) {
                    return r.position === d ? Qb([b[2], Pb(n)]) : Pb(n)
                })
            },
            "iri-to-uri": function(b) {
                return Tb(cd.escape(c(b[0]), function(d, l) {
                    return 32 >= d || 126 < d || /[<>"{}|\\^`]/.test(l)
                }))
            },
            "json-doc": function(b, d, l) {
                l = Nd.Te(b, d, l);
                if (!l)
                    return Ob;
                l = Nd.Fi(l, d);
                b = b[1] ? b[1].next() : null;
                return Pb(Md.ze(l, b, d))
            },
            "json-to-xml": function(b, d, l) {
                const r = d.fixed.ka;
                var n = b[0].next();
                if (null === n)
                    return Ob;
                b = b[1] ? b[1].next() : null;
                n = Md.wj(n.toString(), b, d);
                b = d.ja.createDocumentFragment();
                b.appendChild(n);
                b._saxonBaseUri = r.Ia(l, d);
                return Pb(b)
            },
            key: function(b, d, l) {
                function r(Y) {
                    Y = R ? A.string.R(Y) : Y;
                    return I.containsKey(Y) ? (Y = Kb(I.get(Y)),
                    D === z ? Y : Y.filter(function(V) {
                        return null !== O.Ya(V).filter(function(la) {
                            return la === z
                        }).next()
                    })) : Ob
                }
                function n(Y) {
                    return {
                        visibility: "PRIVATE",
                        Za: Y,
                        Dh: ma,
                        actor: Y,
                        We: Y.binds.split(" ").map(function(V) {
                            return parseInt(V, 10)
                        })
                    }
                }
                const B = d.fixed.ka;
                var W = a(b[0], d, l, "XTDE1260");
                const ma = B.ke(l, d)
                  , qa = ma.keys[W];
                if (!qa)
                    throw new F("Unknown key " + W,"XTDE1260");
                const L = qa.vg
                  , aa = B.Db(qa.Ld[0], "c");
                let z, D;
                if (b[2])
                    z = b[2].next(),
                    f.X(z) && (D = f.rc(z));
                else {
                    var y = ed(d);
                    f.X(y) && (D = z = f.rc(y))
                }
                if (!D || 9 !== D.nodeType && 11 !== D.nodeType)
                    throw new F("No containing document for key()","XTDE1270",l);
                "_saxonIndexes"in D || (D._saxonIndexes = {},
                D._saxonIndexesBC = {});
                l = D._saxonIndexes;
                let I = l[L];
                if ("under construction" === I)
                    throw new F("Definition of key " + W + " is circular","XTDE0640");
                let R = !1;
                if (I)
                    R = D._saxonIndexesBC[L];
                else {
                    W = Hd.df(qa.Ld[0], null, d);
                    I = Hd.xf(W, aa);
                    l[L] = "under construction";
                    W = function(V) {
                        return Qb([O.self(V), O.ob(V), O.Ha(V)])
                    }
                    ;
                    y = function(V) {
                        return Qb([O.self(V), O.Ha(V)])
                    }
                    ;
                    const Y = function(V) {
                        return Qb([O.self(V), O.ob(V)])
                    };
                    for (let V = 0; V < qa.Ld.length; V++) {
                        var M = qa.Ld[V];
                        const la = /b/.test(M.flags);
                        R = R || la;
                        var ca = void 0;
                        ca = M.C[0];
                        const x = d.ba(!0);
                        x.sa = n(M);
                        x.focus = Rb(D);
                        if ("p.nodeSet" === ca.N)
                            ca = B.evaluate(ca.C[0], x);
                        else {
                            const K = Kd.od(ca);
                            ca = O.oe(D);
                            var ea = B.Db(M, "a")
                              , ja = B.Db(M, "n");
                            if (ea || ja)
                                ca = ca.mapOneToMany(ea && ja ? W : ea ? y : Y);
                            ca = ca.filter(function(U) {
                                x.focus = Rb(D);
                                return K(U, x)
                            })
                        }
                        ea = M.C[1];
                        ja = d.ba(!0);
                        ja.sa = n(M);
                        for (ja.qa = "key"; null !== (M = ca.next()); ) {
                            ja.focus = Rb(M);
                            const K = B.evaluate(ea, ja)
                              , U = function(ha, T) {
                                I.containsKey(ha) ? 0 > I.get(ha).indexOf(T) && (I.get(ha).push(T),
                                1 < qa.Ld.length && I.get(ha).sort(f.rb)) : I.inSituPut(ha, [T])
                            };
                            if (aa)
                                U(K.expand(), M);
                            else {
                                let ha;
                                for (; null !== (ha = K.next()); )
                                    Hd.tc(ha) || (la && (ha = A.string.R(ha)),
                                    U(ha, M))
                            }
                        }
                    }
                    l[L] = I;
                    D._saxonIndexesBC[L] = R
                }
                b = b[1];
                return aa ? r(b.expand()) : b.mapOneToMany(r)
            },
            lang: function(b, d) {
                d = b[1] ? b[1].next() : ed(d);
                if (!d)
                    throw new F("No context item for lang()","XPDY0002");
                if (!f.X(d))
                    throw new F("Context item is not a node in lang()","XPTY0004");
                b = c(b[0]).toLowerCase();
                d = O.Ya(d).filter(function(l) {
                    return 1 === l.nodeType && l.hasAttribute("xml:lang")
                }).next();
                if (!d)
                    return Xb(!1);
                d = d.getAttribute("xml:lang").toLowerCase();
                return Xb(b === d || d.length > b.length + 1 && d.substring(0, b.length) === b && "-" === d.charAt(b.length))
            },
            last: function(b, d) {
                fd(d, "XPDY0002", "last()");
                return Ub(d.focus.last())
            },
            "load-xquery-module": function() {
                throw new F("No XQuery processor available","FOQM0006");
            },
            "local-name": function(b) {
                b = f.ca(b[0].next());
                return Tb(b ? b.local : "")
            },
            "local-name-from-QName": function(b) {
                b = b[0].next();
                return null === b ? Ob : Pb(La.type.NCName.fromString(b.local))
            },
            "lower-case": function(b) {
                return Tb(c(b[0]).toLowerCase())
            },
            matches: function(b) {
                const d = c(b[0]);
                var l = b[1].next().toString();
                b = Ha.xg(b[2] ? b[2].next().toString() : "");
                l = Ha.Ce(l, b, d);
                return Xb(0 <= d.search(l))
            },
            max: p("max"),
            min: p("min"),
            "minutes-from-dateTime": function(b) {
                return e(b, "getUTCMinutes")
            },
            "minutes-from-duration": function(b) {
                return k(b, 4)
            },
            "minutes-from-time": function(b) {
                return e(b, "getUTCMinutes")
            },
            "month-from-date": function(b) {
                return e(b, "getUTCMonth")
            },
            "month-from-dateTime": function(b) {
                return e(b, "getUTCMonth")
            },
            "months-from-duration": function(b) {
                return k(b, 1)
            },
            name: function(b) {
                b = f.ca(b[0].next());
                return Tb(b ? b.toString() : "")
            },
            "namespace-uri": function(b) {
                b = f.ca(b[0].next());
                return Pb(A.anyURI.fromString(b ? b.uri : ""))
            },
            "namespace-uri-for-prefix": function(b) {
                var d = c(b[0]);
                b = b[1].next();
                d = "xml" === d ? Zb.xml : b.lookupNamespaceURI("" === d ? null : d);
                return null !== d ? Pb(A.anyURI.fromString(d)) : Ob
            },
            "namespace-uri-from-QName": function(b) {
                b = b[0].next();
                return null === b ? Ob : Pb(A.anyURI.fromString(b.uri))
            },
            nilled: function(b) {
                return (b = b[0].next()) && 1 === b.nodeType ? Xb(!1) : Ob
            },
            "node-name": function(b) {
                return Pb(f.ca(b[0].next()))
            },
            "normalize-space": function(b) {
                b = c(b[0]);
                return Tb(xa(b))
            },
            "normalize-unicode": function(b) {
                if (String.prototype.normalize) {
                    const d = c(b[0]);
                    b = b[1] ? b[1].next().toString().toUpperCase().trim() : "NFC";
                    if (["NFC", "NFD", "NFKC", "NFKD"].includes(b))
                        return Tb(d.normalize(b));
                    if ("" === b)
                        return Tb(d)
                }
                throw new F("normalize-unicode(): not supported on this Javascript platform","FOCH0003");
            },
            not: function(b, d) {
                return Xb(!d.fixed.ka.Fd(b[0]))
            },
            number: function(b) {
                return Pb(La.XS.numeric.xe(b[0].next()))
            },
            "one-or-more": function(b) {
                b = Fb(b[0]);
                if (null === b.ua())
                    throw new F("Required length >= 1, actual length zero","FORG0004");
                return b
            },
            outermost: function(b, d, l) {
                d = d.fixed.ka.Db(l, "p");
                b = b[0];
                d || (b = f.kd(b));
                let r = null;
                return b.filter(function(n) {
                    if (null === r)
                        return r = n,
                        !0;
                    if (O.Zc(n).some(B=>B === r))
                        return !1;
                    r = n;
                    return !0
                })
            },
            "parse-ietf-date": function(b) {
                return b[0].mapOneToOne(function(d) {
                    function l(z) {
                        return 1 === z.length ? "0" + z : z
                    }
                    function r() {
                        throw new F("Invalid IETF date/time " + d.toString(),"FORG0010");
                    }
                    var n = d.toString().trim().toLowerCase();
                    n = n.replace(/^(monday|tuesday|wednesday|thursday|friday|saturday|sunday|mon|tue|wed|thu|fri|sat|sun),?\s+/, "");
                    let B;
                    let W, ma;
                    if (/^[a-z]/.test(n))
                        if (B = /^([a-z]{3})(?:\s*-\s*|\s+)(\d\d\d?\d?)\s+([\d:.]+)\s*([a-z]+|[+\-]\d\d?:?(?:\d\d)?(?:\s*\(\s*[a-z]+\s*\))?)?\s+(\d+)$/,
                        n = B.exec(n),
                        null !== n) {
                            var qa = n[1];
                            var L = n[2];
                            ma = n[3];
                            var aa = n[4];
                            W = n[5]
                        } else
                            r();
                    else
                        B = /^(\d+)(?:\s*-\s*|\s+)([a-z]{3})(?:\s*-\s*|\s+)(\d\d\d?\d?)\s+([\d:.]+)\s*([a-z]+|[+\-]\d\d?:?(?:\d\d)?(?:\s*\(\s*[a-z]+\s*\))?)?$/,
                        n = B.exec(n),
                        null !== n ? (L = n[1],
                        qa = n[2],
                        W = n[3],
                        ma = n[4],
                        aa = n[5]) : r();
                    2 === W.length && (W = "19" + W);
                    qa = "jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec".indexOf(qa || "*");
                    0 > qa && r();
                    n = {
                        ut: "Z",
                        utc: "Z",
                        gmt: "Z",
                        est: "-05:00",
                        edt: "-04:00",
                        cst: "-06:00",
                        cdt: "-05:00",
                        mst: "-07:00",
                        mdt: "-06:00",
                        pst: "-08:00",
                        pdt: "-07:00"
                    };
                    /^[0-9]:/.test(ma) && (ma = "0" + ma);
                    5 === ma.length && (ma += ":00");
                    aa && (aa = /([a-z]+)|([+\-]\d\d?:?(?:\d\d)?)(?:\s*\(\s*([a-z]+)\s*\))?$/.exec(aa),
                    (!aa[3] || aa[3]in n) && (!aa[1] || aa[1]in n) || r(),
                    aa = aa[1] ? aa[1] : aa[2],
                    /^[+\-][0-9]((:|$)|[0-9]{2}$)/.test(aa) && (aa = aa.charAt(0) + "0" + aa.substring(1)),
                    aa in n ? aa = n[aa] : 3 === aa.length ? aa += ":00" : 4 === aa.length ? aa += "00" : 5 === aa.length && (aa = aa.substring(0, 3) + ":" + aa.substring(3)));
                    L = W + "-" + l((qa / 4 + 1).toString()) + "-" + l(L) + "T" + ma + (aa || "Z");
                    try {
                        return A.dateTime.fromString(L)
                    } catch (z) {
                        throw new F("''" + d.toString() + "'' is not a valid IETF date","FORG0010");
                    }
                })
            },
            "parse-json": function(b, d) {
                const l = b[0].next();
                if (null === l)
                    return Ob;
                b = b[1] ? b[1].next() : null;
                return Pb(Md.ze(l.toString(), b, d))
            },
            "parse-xml": function(b, d, l) {
                b = b[0].next();
                if (null === b)
                    return Ob;
                const r = d.fixed.ka;
                try {
                    const n = pa.parseXmlFromString(b.toString());
                    n._saxonBaseUri = r.Ia(l, d);
                    return Pb(n)
                } catch (n) {
                    throw new F(n.message,"FODC0006");
                }
            },
            "parse-xml-fragment": function(b, d, l) {
                const r = d.fixed.ka;
                return b[0].mapOneToOne(function(n) {
                    const B = /^<\?xml(?:\s+version\s*=\s*(['"])1.[0-9]+['"])?\s+encoding\s*=\s*(['"][A-Za-z](?:[A-Za-z0-9._\-])*)['"]\s*\?>/;
                    n = n.toString();
                    if (/^<\?xml/.test(n) && !B.test(n))
                        throw new F("Invalid XML header for a text declaration","FODC0006");
                    n = n.replace(B, "");
                    let W;
                    try {
                        W = pa.parseXmlFromString("<z>" + n + "</z>")
                    } catch (qa) {
                        throw new F(qa.message,"FODC0006");
                    }
                    const ma = d.ja.createDocumentFragment();
                    O.Ka(W.documentElement).forEachItem(function(qa) {
                        ma.appendChild(qa)
                    });
                    ma._saxonBaseUri = r.Ia(l, d);
                    return ma
                })
            },
            path: function(b) {
                return b[0].mapOneToOne(function(d) {
                    function l(r) {
                        return O.Oc(r).filter(function(n) {
                            return r.nodeType === n.nodeType
                        })
                    }
                    return A.string.fromString(function(r) {
                        if ([9, 11].includes(r.nodeType))
                            return "/";
                        let n = ""
                          , B = r;
                        for (; B; ) {
                            r = f.Xa(B);
                            if (!r)
                                return [9, 11].includes(B.nodeType) ? n : "Q{http://www.w3.org/2005/xpath-functions}root()" + n;
                            switch (B.nodeType) {
                            case 9:
                            case 11:
                                return n;
                            case 1:
                                const W = f.ca(B);
                                n = `/${W.toEQName()}[${1 + l(B).filter(ma=>f.ca(ma).equals(W)).count()}]${n}`;
                                break;
                            case 3:
                            case 4:
                                n = `/text()[${1 + l(B).count()}]`;
                                break;
                            case 8:
                                n = `/comment()[${1 + l(B).count()}]`;
                                break;
                            case 7:
                                n = `/processing-instruction(${B.target})[${1 + l(B).filter(ma=>B.target === ma.target).count()}]`;
                                break;
                            case 2:
                                n = `/@${0 > B.name.indexOf(":") ? B.name : f.ca(B).toEQName()}`;
                                break;
                            default:
                                n = `/namespace::${"" !== B.prefix ? B.prefix : "*[Q{" + Zb.Oa + '}local-name()=""]'}`
                            }
                            B = r
                        }
                    }(d))
                })
            },
            "prefix-from-QName": function(b) {
                return b[0].mapOneToOne(function(d) {
                    return "" === d.prefix ? null : A.Ag.fromString(d.prefix)
                })
            },
            position: function(b, d) {
                fd(d, "XPDY0002", "position()");
                return Ub(d.focus.position)
            },
            QName: function(b) {
                var d = b[1].next().value;
                const l = d.split(":")
                  , r = 2 === l.length ? l[0] : "";
                b = c(b[0]);
                if ("" !== r && "" === b)
                    throw new F("Prefix but no URI for QName()","FOCA0002");
                if (2 === l.length && "" === r || "" !== r && !Ha.Lb(r))
                    throw new F(d + " not valid for QName()","FOCA0002");
                d = 2 === l.length ? l[1] : l[0];
                if (!Ha.Lb(d))
                    throw new F(d + " not valid local name for QName()","FOCA0002");
                return Pb(A.QName.fromParts(r, b, d))
            },
            "random-number-generator": function(b, d) {
                b = new cc;
                b.inSituPut(A.string.fromString("number"), [A.double.fromNumber(Math.random())]);
                var l = A.QName.fromParts("fn", Zb.Oa, "random-number-generator")
                  , r = Jd.find("SaxonJS").XPath
                  , n = r.getFnSignature(l, 0, d);
                l = new ad.He(n,l,0,{},d);
                b.inSituPut(A.string.fromString("next"), [l]);
                l = A.QName.fromParts("saxon", Zb.wb, "permute");
                n = d.ba();
                n.bb = !0;
                r = r.getFnSignature(l, 1, n);
                d = new ad.He(r,l,1,{},d);
                b.inSituPut(A.string.fromString("permute"), [d]);
                return Pb(b)
            },
            "regex-group": function(b, d) {
                b = b[0].next().toNumber();
                try {
                    return Tb(d.Mb[b] || "")
                } catch (l) {
                    return Tb("")
                }
            },
            remove: function(b) {
                const d = b[1].next().toNumber()
                  , l = Sb(b[0]);
                return l.filter(function() {
                    return l.position !== d
                })
            },
            replace: function(b) {
                const d = c(b[0])
                  , l = Ha.xg(b[3] ? b[3].next().toString() : "");
                let r = 0;
                const n = Ha.Ce(b[1].next().toString(), l + "g", null, B=>{
                    r = B
                }
                );
                if (n.test(""))
                    throw new F("Regular expression matches zero-length string","FORX0003");
                b = Ha.si(b[2].next().toString(), l, r);
                return Tb(d.replace(n, b))
            },
            "resolve-QName": function(b) {
                const d = b[1].next();
                return b[0].mapOneToOne(function(l) {
                    try {
                        return f.Cj(d, l.toString(), !0)
                    } catch (r) {
                        throw r instanceof F && "FORG0001" === r.code && (r.code = Ha.uh(l) ? "FONS0004" : "FOCA0002"),
                        r;
                    }
                })
            },
            "resolve-uri": function(b, d, l) {
                const r = d.fixed.ka;
                if (b[1]) {
                    let n = b[1].next();
                    d = n ? n.toString() : r.Ia(l, d)
                } else
                    d = r.Ia(l, d);
                b = b[0].next();
                if (null === b)
                    return Ob;
                b = b.toString();
                l = f.ld(b);
                if (null !== d && (d = d.replace(/^file:\/(?!\/)/, "file:///"),
                /#/.test(d)))
                    throw new F("Base URI " + d + " contains a fragment identifier","FORG0002");
                if (!l && null !== d && !f.ld(d))
                    throw new F("resolve-uri: invalid URI (base=" + d + ", relative=" + b + ")","FORG0002");
                b = l ? b : pa.Fb(b, d).toString();
                return Pb(A.anyURI.fromString(b))
            },
            reverse: function(b) {
                return Kb(b[0].expand().slice().reverse())
            },
            root: function(b) {
                return b[0].mapOneToMany(d=>O.Ya(d)).filter(d=>!f.Xa(d))
            },
            round: function(b) {
                return b[0].mapOneToOne(d=>d.round(b[1] ? Math.min(b[1].next().value, 1E4) : 0))
            },
            "round-half-to-even": function(b) {
                return b[0].mapOneToOne(d=>d.sf(b[1] ? Math.min(b[1].next().value, 1E4) : 0))
            },
            "seconds-from-dateTime": function(b) {
                return e(b, "seconds")
            },
            "seconds-from-duration": function(b) {
                return k(b, 5)
            },
            "seconds-from-time": function(b) {
                return e(b, "seconds")
            },
            serialize: function(b, d) {
                function l(B) {
                    B.method = "xml";
                    B.indent = !1;
                    B["omit-xml-declaration"] = !0
                }
                const r = new ge.StringWriter
                  , n = {};
                if (b[1]) {
                    const B = b[1].next();
                    if (null === B)
                        l(n);
                    else if (ac.X(B)) {
                        if (!ac.sh(B))
                            throw new F("Second argument supplied to serialize() is wrong kind of node","XPTY0004");
                        ge.parseParamDoc(B, n, "XPTY0004")
                    } else {
                        if (!(B instanceof cc))
                            throw new F("Second argument supplied to serialize() does not match required type","XPTY0004");
                        const W = function(ma, qa, L, aa, z=!1) {
                            const D = La.XS.string.fromString(ma);
                            if (B.containsKey(D)) {
                                let y = B.get(D);
                                if (0 < y.length && cd.isArray(y[0]))
                                    if (L) {
                                        let I = [];
                                        y[0].flatten(R=>I.push(R));
                                        y = I
                                    } else
                                        throw new F("fn:serialize(): supplied value of " + D + " is invalid","XPTY0004");
                                if (1 !== y.length && !L && !z || !y.every(I=>"AZ" === I.code || qa.matches(I)))
                                    throw new F("fn:serialize(): supplied value of " + D + " is invalid","XPTY0004");
                                n[ma] = z && 0 === y.length ? null : aa(L ? y : "AZ" === y[0].code ? qa.R(y[0]) : y[0])
                            }
                        };
                        "doctype-public doctype-system encoding item-separator json-node-output-method media-type method normalization-form version".split(" ").forEach(ma=>W(ma, La.XS.string, !1, qa=>qa.toString()));
                        "allow-duplicate-names byte-order-mark escape-uri-attributes include-content-type indent omit-xml-declaration undeclare-prefixes".split(" ").forEach(ma=>W(ma, La.XS.boolean, !1, qa=>qa.toBoolean()));
                        W("standalone", La.XS.boolean, !1, ma=>ma.toBoolean(), !0);
                        W("html-version", La.XS.mb, !1, ma=>ma.toNumber());
                        ["cdata-section-elements", "suppress-indentation"].forEach(ma=>W(ma, La.XS.QName, !0, qa=>{
                            let L = "";
                            for (let aa = 0; aa < qa.length; aa++)
                                L += qa[aa].toEQName() + " ";
                            return L
                        }
                        ));
                        void 0 === n["omit-xml-declaration"] && (n["omit-xml-declaration"] = !0);
                        (function(ma) {
                            var qa = La.XS.string.fromString(ma);
                            if (B.containsKey(qa)) {
                                var L = B.get(qa);
                                if (1 !== L.length || !L.every(z=>z instanceof cc))
                                    throw new F("fn:serialize(): supplied value of " + qa + " is invalid","XPTY0004");
                                L = L[0];
                                var aa = function(z) {
                                    return A.string.matches(z)
                                };
                                if (!L.conforms(aa, aa, function(z) {
                                    return 1 === z
                                }))
                                    throw new F("fn:serialize(): supplied value of " + qa + " is invalid","XPTY0004");
                                qa = cd.sb(L, !0);
                                L = {
                                    min: 0,
                                    max: 0,
                                    ya: {}
                                };
                                for (let z in qa)
                                    if (qa.hasOwnProperty(z)) {
                                        if (1 < z.length)
                                            throw new F("fn:serialize(): Keys in a character map must all be one-character strings. Found " + z,"SEPM0016");
                                        aa = z.codePointAt(0);
                                        0 === L.min ? L.min = aa : aa < L.min && (L.min = aa);
                                        aa > L.max && (L.max = aa);
                                        L.ya[aa] = qa[z]
                                    }
                                n[ma] = L
                            }
                        }
                        )("use-character-maps")
                    }
                } else
                    l(n);
                ge.serialize(b[0].expand(), n, r, d);
                return Tb(r.toString())
            },
            snapshot: function(b, d, l) {
                return b[0].mapOneToOne(function(r) {
                    function n(y) {
                        if (0 < y.length) {
                            const I = y.pop();
                            Zd.rg(I, d, "cm", function() {
                                O.Ha(I).forEachItem(R=>W.append(R));
                                0 < y.length ? n(y) : (aa ? Zd.rg(L, d, "", function() {
                                    O.Ha(L).forEachItem(R=>W.append(R));
                                    O.ob(L).forEachItem(R=>W.append(R))
                                }, W) : Zd.qf(r, d, W, l, !0, !0),
                                z = B.oc.lastChild)
                            }, W)
                        }
                    }
                    const B = Vd(d)
                      , W = Zd.Fc(B);
                    if (!f.Xa(r))
                        return Zd.qf(r, d, W, l, !0, !0),
                        W.close(),
                        Kb(B.Ob).next();
                    const ma = r.nodeType
                      , qa = f.ca(r);
                    var L = r
                      , aa = [2, 13].includes(ma);
                    aa && (L = f.Xa(L));
                    W.Ea();
                    let z;
                    const D = O.Zc(L).expand();
                    0 < D.length ? n(D) : (Zd.qf(r, d, W, l, !0, !0),
                    z = B.oc.lastChild);
                    W.za();
                    z || sa.la("snapshot: failed to find marked node");
                    switch (ma) {
                    case 2:
                        return f.Ja.Ha(z).filter(y=>f.ca(y).equals(qa)).next();
                    case 13:
                        return f.Ja.ob(z).filter(y=>f.ca(y).equals(qa)).next();
                    default:
                        return z
                    }
                })
            },
            sort: function(b, d, l) {
                const r = Hd.df(l, b[1], d);
                let n = cd.Sb;
                if (b[2]) {
                    const B = b[2].next();
                    n = function(W) {
                        return B.evaluate([[W]], d, l)
                    }
                }
                return Kb(b[0].expand().slice().sort(function(B, W) {
                    return b[1] ? Id(n(B), n(W), r) : Id(n(B), n(W))
                }))
            },
            "starts-with": function(b, d, l) {
                const r = c(b[0])
                  , n = c(b[1]);
                b = Hd.Xb(l, b[2], "startsWith", d);
                return Xb(b(r, n))
            },
            "static-base-uri": function(b, d, l) {
                return (b = d.fixed.ka.Ia(l, d)) ? Pb(A.anyURI.fromString(b)) : Ob
            },
            "stream-available": function() {
                return Xb(!1)
            },
            string: function(b, d) {
                d = d.fixed.ka;
                b = b[0].next();
                if (!b)
                    return Tb("");
                if (d.isArray(b) || d.isMap(b) || d.Jd(b))
                    throw new F("Input to string() is a function item ","FOTY0014");
                return d.Sb(b).mapOneToOne(function(l) {
                    return A.string.R(l)
                })
            },
            "string-join": function(b) {
                let d = "";
                const l = b[1] ? b[1].next().value : "";
                let r, n = !0;
                for (; null !== (r = b[0].next()); )
                    n || (d += l),
                    d += r.toString(),
                    n = !1;
                return Tb(d)
            },
            "string-length": function(b) {
                return Ub(Da(c(b[0])).length)
            },
            "string-to-codepoints": function(b) {
                return Kb(Da(c(b[0])).map(A.integer.fromNumber))
            },
            subsequence: function(b) {
                const d = Math.round(b[1].next().toNumber())
                  , l = b[2] ? d + Math.round(b[2].next().toNumber()) : Number.POSITIVE_INFINITY;
                return new Nb(b[0],d,l)
            },
            substring: function(b) {
                var d = Math.round(b[1].next().toNumber());
                const l = b[2] ? d + Math.round(b[2].next().toNumber()) : Number.POSITIVE_INFINITY;
                b = new Mb(c(b[0])[Symbol.iterator]());
                d = new Nb(b,d,l);
                return Tb(d.expand().join(""))
            },
            "substring-after": function(b, d, l) {
                let r = "";
                const n = c(b[0])
                  , B = c(b[1]);
                let W;
                -1 !== (W = Hd.Xb(l, b[2], "indexOf", d)(n, B)) && (r = n.substring(W + B.length));
                return Tb(r)
            },
            "substring-before": function(b, d, l) {
                let r = "";
                const n = c(b[0])
                  , B = c(b[1]);
                let W;
                -1 !== (W = Hd.Xb(l, b[2], "indexOf", d)(n, B)) && (r = n.substring(0, W));
                return Tb(r)
            },
            sum: function(b, d) {
                d = b[0].mapOneToOne(d.fixed.ka.Xh);
                const l = d.next();
                if (null === l)
                    return 1 === b.length ? Ub(0) : b[1];
                try {
                    return mb["a+a"](l, l),
                    Pb(H(d, l, mb["a+a"]))
                } catch (r) {
                    throw r instanceof F && "XPTY0004" === r.code && (r.code = "FORG0006"),
                    r;
                }
            },
            "system-property": function(b, d, l) {
                b = A.QName.fromEQName(a(b[0], d, l, "XTDE1390"));
                d = "";
                b.uri === Zb.Wc && (d = {
                    version: "3.0",
                    vendor: "Saxonica",
                    "vendor-url": "http://www.saxonica.com/",
                    "product-name": "SaxonJS",
                    "product-version": "2.6",
                    "is-schema-aware": "no",
                    "supports-serialization": "yes",
                    "supports-backwards-compatibility": "yes",
                    "supports-namespace-axis": "yes",
                    "supports-streaming": "no",
                    "supports-dynamic-evaluation": "yes",
                    "supports-higher-order-functions": "yes",
                    "xpath-version": "3.1",
                    "xsd-version": "1.1"
                }[b.local]);
                b.uri === Zb.wb && (d = pa.Di()[b.local]);
                d ||= "";
                return Tb(d)
            },
            tail: function(b) {
                const d = Sb(b[0]);
                return d.filter(function() {
                    return 1 !== d.position
                })
            },
            "timezone-from-date": function(b) {
                return e(b, "timezone")
            },
            "timezone-from-dateTime": function(b) {
                return e(b, "timezone")
            },
            "timezone-from-time": function(b) {
                return e(b, "timezone")
            },
            tokenize: function(b) {
                var d = c(b[0]);
                b[1] || (d = xa(d));
                if ("" === d)
                    return Ob;
                var l = b[1] ? b[1].next().toString() : "[ \\n\\r\\t]+";
                l = Zd.Of(d, l, b[2] ? b[2].next().toString() : "", !1, !0);
                d = b[1] && l[0].Lc;
                const r = l[l.length - 1];
                b = b[1] && r.Lc;
                l = l.filter(function(n) {
                    return !n.Lc
                }).map(function(n) {
                    return n.string
                });
                d && l.unshift(A.string.fromString(""));
                b && l.push(A.string.fromString(""));
                return Kb(l)
            },
            trace: function(b, d) {
                const l = b[0].expand();
                sa.Ma("fn:trace: " + (2 === b.length ? b[1].next().toString() + ": " : "") + sa.showValue(l), 1, d.fixed.Ta);
                return Kb(l)
            },
            transform: function(b, d, l) {
                function r(na) {
                    na = A.string.fromString(na);
                    return ca.get(na)
                }
                function n(na, va="FOXT0002") {
                    throw new F(na,va);
                }
                function B(na, va, h=null) {
                    if ("matches"in va && "name"in va) {
                        if (va.matches(na))
                            return na;
                        throw new F(null !== h ? `The required item type of ${h} is ${va.name}` : `The required item type is ${va.name}`,"XPTY0004");
                    }
                    return na
                }
                function W(na, va) {
                    if (Ia(na))
                        return na;
                    throw new F(`The required item type of ${va} is string|unTypedAtomic|anyURI`,"XPTY0004");
                }
                function ma(na, va, h=G=>G) {
                    (na = r(na)) && (na = Kb(na).ua()) && (ea[va] = h(na))
                }
                function qa(na) {
                    return function(va) {
                        va instanceof cc || n("The value of the option " + na + " in fn:transform() must be of type map(xs:QName,item()*)", "XPTY0004");
                        if (va.conforms(h=>{
                            A.QName.matches(h) || n("The keys of the " + na + " option in fn:transform() must be of type xs:QName. Supplied value:" + h.toString());
                            return !0
                        }
                        , ()=>!0, ()=>!0))
                            return va
                    }
                }
                function L(na, va) {
                    ma(na, va, qa(na))
                }
                function aa(na) {
                    na.C && na.C.forEach(function(va) {
                        va.parentNode = na;
                        aa(va)
                    })
                }
                function z(na, va, h) {
                    if (!R.N)
                        throw new F("No XSLT processor is available to support fn:transform(). If using SaxonJS2.rt.js, it does not contain an XSLT compiler ","FOXT0001",l);
                    let G = {
                        stylesheetParams: new cc,
                        tunnelParams: {},
                        functionParams: {},
                        isDynamicStylesheet: !0,
                        destination: "application",
                        initialMode: "compile-complete",
                        templateParams: {
                            "Q{}options": {
                                noXPath: !1
                            }
                        }
                    };
                    for (let Q in va)
                        "compiler.options" === Q ? G.tunnelParams["Q{}compiler.options"] = va[Q] : G.templateParams["Q{}options"][Q] = va[Q];
                    G.stylesheetParams.inSituPut(La.XS.QName.fromParts("", "", "staticParameters"), [h]);
                    G.stylesheetInternal = R;
                    G.outputProperties = {};
                    aa(R);
                    "true" === R.relocatable && (G.isRelocatableStylesheet = !0);
                    va = y.checkOptions(G);
                    y.internalTransform(R, na, va);
                    return va.principalResult
                }
                function D(na) {
                    na = I.Sb(na).expand();
                    if (1 < na.length)
                        throw new F("Supplied value when atomized is not a single string","FOXT0002");
                    return na[0]
                }
                const y = Jd.find("SaxonJS")
                  , I = d.fixed.ka
                  , R = pa.rf("compiler");
                let M = !1;
                const ca = b[0].next()
                  , ea = {
                    stylesheetParams: new cc,
                    templateParams: new cc,
                    tunnelParams: new cc,
                    functionParams: {},
                    outputProperties: {},
                    isDynamicStylesheet: !0,
                    language: "XSLT",
                    messages: [],
                    resultDocuments: {},
                    resultForm: "xdm"
                };
                if ((b = r("requested-properties")) && b[0]) {
                    !(1 < b.length) && b[0]instanceof cc || n("The value of the 'requested-properties' option for fn:transform() must be of type map(*)");
                    b = b[0];
                    function na(va, h) {
                        n("No processor with property " + va.toEQName() + "=" + h + "() available for fn:transform()", "FOXT0001")
                    }
                    b.forAllPairs(function(va) {
                        let h = va.v[0];
                        switch (va.k.local) {
                        case "supports-streaming":
                            (h = h.toBoolean()) && na(va.k, h);
                            break;
                        case "supports-namespace-axis":
                            h = h.toBoolean();
                            na(va.k, h);
                            break;
                        case "supports-backwards-compatibility":
                            (h = h.toBoolean()) || na(va.k, h);
                            break;
                        case "product-name":
                            h = h.toString();
                            "SaxonJS" !== h && na(va.k, h);
                            break;
                        case "vendor":
                            h = h.toString(),
                            "Saxonica" !== h && na(va.k, h)
                        }
                    })
                }
                var ja = r("vendor-options");
                ja && ja[0] ? (!(1 < ja.length) && ja[0]instanceof cc || n("The value of the 'vendor-options' option for fn:transform() must be of type map(*)"),
                ja = ja[0]) : ja = null;
                var Y = r("xslt-version")[0];
                Y && B(Y, A.mb, "xslt-version");
                ma("stylesheet-location", "stylesheetLocation", na=>W(D(na), "stylesheet-location").toString());
                ma("stylesheet-node", "stylesheetNode");
                ma("stylesheet-text", "stylesheetText");
                ma("package-location", "packageLocation", na=>W(D(na), "package-location").toString());
                ma("package-node", "packageNode");
                ma("package-text", "packageText");
                let V = 0;
                "stylesheetLocation stylesheetNode stylesheetText packageLocation packageNode packageText".split(" ").forEach(na=>{
                    ea[na] && V++
                }
                );
                1 !== V && n("A stylesheet must be supplied as an option to fn:transform(), by exactly one of 'stylesheet-location', 'stylesheet-node', 'stylesheet-text', 'package-location', 'package-node' or 'package-text'");
                ma("source-node", "sourceNode");
                ma("global-context-item", "globalContextItem");
                (b = r("source-node")[0]) && !r("global-context-item")[0] && f.Xa(b) && (ea.globalContextItem = b.ownerDocument);
                (b = r("initial-match-selection")) && 0 < b.length && (ea.initialSelection = b);
                ma("initial-template", "initialTemplate", na=>B(na, A.QName, "initial-template").toEQName());
                ma("initial-mode", "initialMode", function(na) {
                    return ["#unnamed", "#default"].includes(na.toString()) ? na.toString() : B(na, A.QName, "initial-mode").toEQName()
                });
                ma("initial-function", "initialFunction", na=>B(na, A.QName, "initial-function").toEQName());
                ma("static-params", "staticParams");
                ma("base-output-uri", "baseOutputURI");
                ma("stylesheet-base-uri", "stylesheetBaseURI", na=>na.toString());
                ma("delivery-format", "destination", na=>na.toString());
                let la = ea.destination;
                la && !["raw", "document", "serialized"].includes(la) && n("The value of the delivery-format option to fn:transform() must be one of 'raw', 'document' or 'serialized'. Supplied value is " + la);
                la ||= "document";
                b = (b = r("enable-messages")) && 1 === b.length ? b[0].toBoolean() : !1;
                let x = r("enable-assertions");
                x = x && 1 === x.length ? x[0].toBoolean() : !1;
                var K = null
                  , U = null;
                if (ea.stylesheetNode) {
                    var ha = ea.stylesheetNode._saxonBaseUri || "NoStylesheetBaseURI";
                    if (9 == ea.stylesheetNode.nodeType)
                        U = ea.stylesheetNode.cloneNode(!0);
                    else if (11 == ea.stylesheetNode.nodeType) {
                        U = pa.createDocument();
                        var T = ea.stylesheetNode.childNodes;
                        for (var w = 0; w < T.length; w++)
                            U.appendChild(T[w].cloneNode(!0))
                    } else
                        U = f.rc(ea.stylesheetNode),
                        "NoStylesheetBaseURI" === ha && U._saxonBaseUri && (ha = U._saxonBaseUri),
                        U = pa.createDocument(),
                        U.appendChild(ea.stylesheetNode.cloneNode(!0));
                    U._saxonBaseUri = ha;
                    U._saxonDocUri = ha
                }
                if (ea.stylesheetLocation) {
                    ha = I.Ia(l, d);
                    ha = pa.Fb(ea.stylesheetLocation, ha);
                    ea.stylesheetLocation = ha;
                    try {
                        U = Nd.Dc(ha, d)
                    } catch (na) {
                        n("Error fetching stylesheet in fn:transform():" + na.code + " " + na.message)
                    }
                    U._saxonBaseUri = ha;
                    U._saxonDocUri = ha
                }
                ea.stylesheetText && (U = pa.parseXmlFromString(ea.stylesheetText.toString(), !0),
                U._saxonBaseUri = "NoStylesheetBaseURI",
                U._saxonDocUri = "NoStylesheetBaseURI");
                U && ea.stylesheetBaseURI && (ha = I.Ia(l, d),
                ha = pa.Fb(ea.stylesheetBaseURI, ha),
                U._saxonBaseUri = ha,
                U._saxonDocUri = ha);
                ea.packageNode && (ha = ea.packageNode,
                f.jf(ha) ? K = y.XPath.sefToJSON(ha.firstChild) : n("The value of the 'package-node' option of fn:transform() must be a single document or element node"));
                ea.packageText && (K = JSON.parse(ea.packageText.toString()));
                U && (K = ea.staticParams ? ea.staticParams : new cc,
                ha = new cc,
                T = !1,
                w = A.QName.fromParts("saxon", Zb.wb, "compiler.options"),
                ja && ja.containsKey(w) && (ha = ja.get(w)[0]),
                w = A.QName.fromParts("saxon", Zb.wb, "allowSyntaxExtensions"),
                ja && ja.containsKey(w) && (T = ja.get(w)[0]),
                K = z(U, {
                    "enable-assertions": x,
                    "compiler.options": ha,
                    allowSyntaxExtensions: T,
                    relocatable: !1
                }, K),
                K = y.XPath.sefToJSON(K.firstChild));
                K || n("Internal error in fn:transform(): no SEF", "FOXT0003");
                ja = K.version;
                Y = Y ? 10 * Y.toNumber() : parseFloat(ja);
                ja = y.getProcessorInfo().version;
                Y > 10 * ja && n("No suitable XSLT processor is available; requested XSLT version in fn:transform() is: " + (Y / 10).toString());
                ea.sourceNode && ea.initialSelection && n("Only one of 'source-node' or 'initial-match-selection' must be supplied to fn:transform() for apply-templates invocation");
                ea.initialTemplate && ea.initialMode && n("Only one of 'initial-template' or 'initial-mode' should be supplied to fn:transform()");
                if (ea.sourceNode) {
                    Y = ea.sourceNode;
                    var Z = Y.cloneNode(!0);
                    Z._saxonBaseUri = Y._saxonBaseUri;
                    Z._saxonDocUri = Y._saxonDocUri
                }
                ea.baseOutputURI || (ea.baseOutputURI = "",
                M = !0);
                L("stylesheet-params", "stylesheetParams");
                L("template-params", "templateParams");
                L("tunnel-params", "tunnelParams");
                ma("function-params", "functionParams", function(na) {
                    sa.assert(na instanceof $c);
                    return na.value
                });
                "serialized" === la && ma("serialization-params", "outputProperties", na=>I.sb(na, !0));
                ea.deliverResultDocument = function() {
                    let na = this;
                    return new ie(la,function(va, h) {
                        na.resultDocuments[va.toString()] = "serialized" === la ? [La.XS.string.fromString(h)] : ac.X(h) ? [h] : null === h ? [] : h
                    }
                    )
                }
                ;
                ea.deliverMessage = function(na) {
                    pa.oh()(na);
                    this.zh.push([na])
                }
                ;
                let S = {};
                Y = Kb(r("collections")).ua();
                null !== Y && (S = I.sb(Y, !0));
                ea.collectionFinder = function(na) {
                    return "undefined" === typeof na ? null : S[na]
                }
                ;
                Y = !["raw", "serialized"].includes(la);
                let da, fa;
                try {
                    aa(K);
                    "true" === K.relocatable && (ea.isRelocatableStylesheet = !0);
                    if (ea.stylesheetNode || ea.packageText || ea.packageNode)
                        ea.stylesheetInternal = K;
                    fa = y.checkOptions(ea);
                    y.internalTransform(K, Z, fa);
                    da = fa.principalResult
                } catch (na) {
                    if (na instanceof F && na.Le)
                        throw new F(na.message,na.code.toString());
                    throw na;
                }
                if (da && Y) {
                    sa.assert(Array.isArray(da));
                    Z = Vd(d);
                    const na = Zd.Fc(Z);
                    na.Ea();
                    da.forEach(va=>na.append(va));
                    na.za();
                    na.close();
                    da = Z.Ob
                }
                Array.isArray(da) && 1 === da.length && Array.isArray(da[0]) && (da = da[0]);
                Z = fa.resultDocuments[""];
                if (void 0 !== Z) {
                    if (Array.isArray(da) ? 0 < da.length : null != da)
                        throw new F("A result document on the base output URI has already been created","XTDE1490");
                    da = Z
                }
                Z = new cc;
                da && Z.inSituPut(M ? A.string.fromString("output") : fa.Ib, Array.isArray(da) ? da : [da]);
                b && Z.inSituPut(A.string.fromString("messages"), [new $c(fa.zh)]);
                for (const na in fa.resultDocuments)
                    "" !== na && (sa.Ma("xsl:result-document href=" + na, 2, d.fixed.Ta),
                    Z.inSituPut(A.anyURI.fromString(na), fa.resultDocuments[na]));
                return Pb(Z)
            },
            translate: function(b) {
                const d = Da(c(b[0]))
                  , l = Da(c(b[1]))
                  , r = Da(c(b[2]))
                  , n = [];
                d.forEach(function(B) {
                    let W;
                    -1 !== (W = l.indexOf(B)) ? W < r.length && n.push(r[W]) : n.push(B)
                });
                return Tb(Ea(n))
            },
            "true": function() {
                return Xb(!0)
            },
            "type-available": function(b, d, l) {
                b = a(b[0], d, l, "XTDE1428").split("}");
                return Xb("Q{http://www.w3.org/2001/XMLSchema" === b[0] && (b[1]in La.type || ["untyped", "anyType", "anySimpleType"].includes(b[1])))
            },
            unordered: function(b) {
                return b[0]
            },
            "unparsed-entity-public-id": function() {
                return Ob
            },
            "unparsed-entity-uri": function() {
                return Ob
            },
            "unparsed-text": function(b, d, l) {
                const r = Nd.Te(b, d, l);
                if (!r)
                    return Ob;
                b = Nd.Sf(b[1] ? c(b[1]) : "");
                return Tb(Nd.$f(r, d, l, b))
            },
            "unparsed-text-available": function(b, d, l) {
                return Nd.Ih(function() {
                    const r = Nd.Te(b, d, l);
                    let n = Nd.Sf(b[1] ? c(b[1]) : "");
                    Nd.$f(r, d, l, n)
                })
            },
            "unparsed-text-lines": function(b, d, l) {
                const r = Nd.Te(b, d, l);
                if (!r)
                    return Ob;
                b = Nd.Sf(b[1] ? c(b[1]) : "");
                d = Nd.$f(r, d, l, b).split(/\r?\n|\r/);
                0 < d.length && "" === d[d.length - 1] && --d.length;
                return Kb(d).mapOneToOne(A.string.fromString)
            },
            "upper-case": function(b) {
                return Tb(c(b[0]).toUpperCase())
            },
            "uri-collection": function() {
                return Ob
            },
            "xml-to-json": function(b) {
                const d = b[1] ? b[1].next() : new cc;
                return b[0].mapOneToOne(function(l) {
                    return A.string.fromString(Md.Pj(l, d))
                })
            },
            "year-from-date": function(b) {
                return e(b, "getUTCFullYear")
            },
            "year-from-dateTime": function(b) {
                return e(b, "getUTCFullYear")
            },
            "years-from-duration": function(b) {
                return k(b, 0)
            },
            "zero-or-one": function(b) {
                b = b[0].expand();
                if (1 < b.length)
                    throw new F("Required length 0-1, actual length " + b.length,"FORG0003");
                return Pb(b[0] ? b[0] : null)
            }
        }
    }();
    // Input 37
    const le = function() {
        function a(p, g, e) {
            var k = e.fixed.ka;
            const v = g.name || "#unnamed";
            g = k.qb(g, "sortKey");
            k = g.map(k.Sa);
            const t = Hd.Mi(g, e);
            g = [];
            const C = e.ba(!1);
            for (C.focus = Sb(p); null !== (p = C.focus.next()); )
                e = k.map(function(m, f) {
                    var A = C.ba(!1);
                    A.focus = Rb(C.focus.current);
                    m = m(A);
                    if ((A = m.next()) && m.next())
                        throw new F("Multiple values in merge key","XTTE1020");
                    return t[f](A)
                }),
                g.push({
                    item: p,
                    keys: e,
                    Ah: v
                });
            return g
        }
        function c(p, g, e) {
            function k(m) {
                const f = v[v.length - 1];
                if (f && 0 < e(f, m))
                    throw new F("Input to xsl:merge is not correctly sorted","XTDE2220");
                v.push(m)
            }
            const v = [];
            let t = 0
              , C = 0;
            for (; ; )
                if (t >= p.length) {
                    for (; C < g.length; )
                        k(g[C++]);
                    break
                } else if (C >= g.length) {
                    for (; t < p.length; )
                        k(p[t++]);
                    break
                } else
                    0 >= e(p[t], g[C]) ? k(p[t++]) : k(g[C++]);
            return v
        }
        function q(p, g) {
            return g.fixed.ka.qb(p, "sortKey").map(function(e) {
                return Hd.Jj(e, g)
            })
        }
        function E(p) {
            return function(g, e) {
                for (let k = 0; k < p.length; k++) {
                    const v = p[k](g.keys[k], e.keys[k]);
                    if (0 !== v)
                        return v
                }
                return 0
            }
        }
        function H(p, g, e) {
            var k = null;
            const v = [];
            let t = {};
            for (let C = 0; C < g.length; C++) {
                const m = g[C];
                k = null === k ? -1 : e(k, m);
                if (0 > k) {
                    t = {
                        items: [m.item],
                        keys: m.keys,
                        groups: {}
                    };
                    for (k = 0; k < p.length; k++)
                        t.groups[p[k].name || "#unnamed"] = [];
                    t.groups[m.Ah] = [m.item];
                    v.push(t)
                } else if (0 === k)
                    t.items.push(m.item),
                    t.groups[m.Ah].push(m.item);
                else
                    throw new F("Group Input to xsl:merge is not correctly sorted","XTDE2220");
                k = m
            }
            return v
        }
        return {
            mj: function(p, g) {
                const e = g.fixed.ka;
                var k = e.qb(p, "mergeSrc");
                const v = g.ba();
                v.qa = "merge-key";
                var t = k.map(function(n) {
                    return q(n, v)
                })
                  , C = t[0];
                for (var m = 1; m < t.length; m++)
                    for (var f = 0; f < C.length; f++) {
                        var A = C[f]
                          , O = t[m][f];
                        const n = A.lang === O.lang || null !== A.lang && A.lang.equals(O.lang);
                        if (A.order !== O.order || !n || A.Ye !== O.Ye || A.dataType !== O.dataType)
                            throw new F("All merge sources must have compatible merge keys","XTDE2210",p);
                    }
                t = C.map(function(n) {
                    return Hd.ri(n, v)
                });
                t = E(t);
                C = null;
                for (m = 0; m < k.length; m++) {
                    f = k[m];
                    A = e.da(f, "forEachItem");
                    O = e.da(f, "selectRows");
                    try {
                        if (A) {
                            var b = g.ba(!1);
                            for (b.focus = Sb(e.evaluate(A, g)); null !== b.focus.next(); ) {
                                var d = e.evaluate(O, b)
                                  , l = a(d, f, b);
                                C = null === C ? l : c(C, l, t)
                            }
                        } else {
                            var r = e.evaluate(O, g);
                            const n = a(r, f, g);
                            C = null === C ? n : c(C, n, t)
                        }
                    } catch (n) {
                        if (n instanceof F && "XPTY0004" === n.code)
                            throw new F(n.message,"XTTE2230",p);
                        throw n;
                    }
                }
                if (null === C)
                    return Ob;
                k = H(k, C, t);
                p = e.da(p, "action");
                b = k.map(function(n) {
                    return n.items[0]
                });
                g = g.ba(!1);
                g.focus = Sb(Kb(b));
                b = [];
                for (d = 0; d < k.length; d++)
                    for (g.focus.next(),
                    g.Bb = k[d],
                    l = e.evaluate(p, g); null !== (r = l.next()); )
                        b.push(r);
                return Kb(b)
            }
        }
    }();
    // Input 38
    var me = function() {
        function a(q, E) {
            for (let H in q)
                if (H == E)
                    return {
                        k: E,
                        v: q[E]
                    };
            return null
        }
        function c() {}
        c.prototype = {
            containsKey: function(q) {
                return null !== a(this, q)
            },
            forAllPairs: function(q) {
                for (let E in this)
                    this.__proto__.hasOwnProperty(E) || q({
                        k: E,
                        v: this[E]
                    })
            },
            get: function(q) {
                var E = a(this, q);
                if (null === E)
                    throw new F("'" + q + "' is not a permitted key for the given tuple type","XTTE9999");
                return E.v
            },
            keys: function() {
                var q = [];
                this.forAllPairs(function(E) {
                    q.push(La.XS.string.fromString(E.k))
                });
                return q
            },
            put: function(q, E) {
                var H = new c
                  , p = !1;
                for (let g in this)
                    H[g] = this[g],
                    g == q && (p = !0,
                    H[q] = E);
                if (!p)
                    throw new F("'" + q + "' is not a permitted key for the given tuple type","XTTE9999");
                return H
            },
            size: function(q) {
                var E = 0;
                q[0].next().forAllPairs(function() {
                    E++
                });
                return Ub(E)
            }
        };
        return c
    }();
    // Input 39
    const cd = function() {
        function a() {}
        function c(h) {
            const G = (h.C || []).map(n);
            return Q=>new Mb(function*() {
                for (const u of G) {
                    const N = u(Q);
                    let P;
                    for (; null !== (P = N.next()); )
                        yield P
                }
            }())
        }
        function q(h) {
            function G(ia) {
                switch (ia) {
                case 1:
                    return "first";
                case 2:
                    return "second";
                case 3:
                    return "third";
                default:
                    return ia + "th"
                }
            }
            h = h.split("|");
            const Q = h[0]
              , u = h[1]
              , N = "" === h[2] ? "XPTY0004" : h[2]
              , P = h[3];
            return {
                required: function() {
                    switch (parseInt(Q, 10)) {
                    case 0:
                        return G(+u + 1) + " argument of " + ("" === P ? "anonymous function" : P + "()");
                    case 1:
                        return G(+u + 1) + " operand of '" + P + "'";
                    case 9:
                        return "operand of '-'";
                    case 2:
                        return "value in '" + P + "' expression";
                    case 3:
                        return "saxon:context-item" === P ? "context item" : "value of variable $" + P;
                    case 4:
                        const ia = P.split("/");
                        return "@" + ia[1] + " attribute of " + ("LRE" === ia[0] ? "a literal result element" : ia[0]);
                    case 5:
                        return "result of call to " + ("" === P ? "anonymous function" : "function " + P);
                    case 7:
                        return "result of template " + P;
                    case 6:
                        return G(+u + 1) + " sort key";
                    case 8:
                        return "value of parameter $" + P;
                    case 11:
                        return "value of the grouping key";
                    case 12:
                        return "result of xsl:evaluate";
                    case 13:
                        return "the context item";
                    case 14:
                        return "the context item for the " + "ancestor ancestor-or-self attribute child descendant descendant-or-self following following-sibling namespace parent preceding preceding-sibling self preceding-or-ancestor".split(" ")[u] + " axis";
                    case 15:
                        return "the value of the " + P + " option";
                    case 17:
                        return "document-order sorter";
                    default:
                        return ""
                    }
                }(),
                code: N
            }
        }
        function E(h) {
            h = h.trim();
            if (["true", "yes", "1"].includes(h))
                return !0;
            if (["false", "no", "0"].includes(h))
                return !1;
            throw new F("Value must be yes|true|1 or no|false|0","XTDE0030");
        }
        function H(h) {
            if (S.X(h))
                return Pb(p(h));
            if (ja(h))
                return Qb(h.value.map(G=>Kb(G))).mapOneToMany(H);
            if (V(h))
                throw new F("Cannot atomize a " + (Y(h) ? "map" : "function"),"FOTY0013");
            return Pb(h)
        }
        function p(h) {
            const G = fa.string.fromString
              , Q = fa.untypedAtomic.fromString;
            switch (h.nodeType) {
            case 9:
                return Q(h.documentElement.textContent);
            case 11:
            case 1:
            case 3:
            case 4:
                return Q(h.textContent || "");
            case 2:
                return Q(h.value);
            case 8:
                return G(h.textContent);
            case 7:
                return G(h.textContent);
            case 13:
                return G(h.uri);
            default:
                throw new F("Unknown node type " + h.nodeType,"SXJS0003");
            }
        }
        function g(h) {
            return Kb(h).mapOneToMany(H).expand()
        }
        function e(h) {
            function G(N) {
                throw new F("Effective boolean value is not defined for " + N,"FORG0006");
            }
            function Q() {
                if (null !== h.next())
                    G("an atomic sequence of length > 1");
                else
                    return !0
            }
            var u = h.next();
            if (null === u)
                return !1;
            if (S.X(u))
                return !0;
            if (La.pa(u)) {
                if ("AB" === u.code)
                    return Q() && u.toBoolean();
                if (u.isNumeric())
                    return u = u.toNumber(),
                    Q() && !isNaN(u) && 0 !== u;
                if (Ia(u))
                    return Q() && 0 !== u.toString().length;
                G("type " + La.pd(u.code))
            } else
                Y(u) ? G("maps") : ja(u) ? G("arrays") : V(u) ? G("functions") : G("value " + sa.showValue(u))
        }
        function k(h, G) {
            const Q = mb["i+i"]
              , u = fa.integer.fromNumber(1);
            return new Cb(h,N=>{
                N = Q(N, u);
                return 0 < N.compareTo(G) ? null : N
            }
            )
        }
        function v(h, G) {
            return h.C ? h.C.filter(Q=>Q.N === G) : []
        }
        function t(h, G, Q) {
            h = v(h, "withParam");
            const u = [new cc, new cc];
            G.Qb.forAllPairs(P=>u[1].inSituPut(P.k, P.v));
            const N = G.qa;
            G.qa = "template parameter";
            h.forEach(function(P) {
                const ia = P.name
                  , ua = W(P, "t") ? 1 : 0;
                u[ua].inSituPut(La.XS.QName.fromEQName(ia), l(P)(G).expand())
            });
            G.qa = N;
            Q.Kc = u[0];
            Q.Qb = u[1]
        }
        function C(h) {
            return !/[ \t\r\n]/.test(h)
        }
        function m(h, G, Q) {
            if (h) {
                h = h.split(/\r?\n/);
                for (let N = 0; N < h.length; N++)
                    if (h[N]) {
                        var u = h[N].split("=");
                        let P = u[0];
                        u = u[1];
                        "item-separator" === P && (u = u.replace(/%n/g, "\n").replace(/%%/g, "%"));
                        u = "parameter-document" === P ? void 0 : "use-character-maps" === P ? ge.yf(P, u, Q) : ge.zf(P, u);
                        "undefined" !== typeof u && (G[P] = ge.pf(P, u, G[P]))
                    }
            }
        }
        function f(h, G) {
            const Q = l(h)
              , u = r(h);
            return N=>{
                try {
                    const P = Q(N).next()
                      , ia = u(N).next();
                    return null === P || null === ia ? null : G(P, ia)
                } catch (P) {
                    ca(P, h)
                }
            }
        }
        function A(h, G) {
            if (G.fixed.staticBaseURI)
                return G.fixed.staticBaseURI;
            if (G.fixed.md)
                return null;
            for (; ; ) {
                if (h.baseUri)
                    return h.baseUri;
                h = h.parentNode;
                if (!h)
                    return null
            }
        }
        function O(h, G, Q=!1) {
            var u = S.Gc(G.ja).createDocumentFragment();
            u = S.wc(u);
            u._saxonBaseUri = A(h, G);
            const N = G.ba(!1);
            Q && (N.ja = G.masterDocument);
            bd.kj(u, n(h)(N), N);
            return u
        }
        function b(h) {
            const G = l(h)
              , Q = r(h)
              , u = h.op;
            return N=>{
                const P = G(N)
                  , ia = Q(N).expand();
                N = Hd.fe(h.comp, N);
                return Hd.gc(P, ia, u, N, h)
            }
        }
        function d(h, G) {
            throw new F("The " + h + " construct is not implemented in SaxonJS","SXJS0002",G);
        }
        function l(h) {
            return n(h.C[0])
        }
        function r(h) {
            return n(h.C[1])
        }
        function n(h) {
            if (h) {
                var G = h.ELAB;
                G || ((G = va[h.N]) || sa.la("Unknown expr: " + h.N + " parent=" + h.p),
                G = h.ELAB = G(h));
                return G
            }
        }
        function B(h, G) {
            h = h.C || [];
            for (let Q = 0; Q < h.length; Q++) {
                const u = h[Q];
                if (u.role === G)
                    return u
            }
            return null
        }
        function W(h, G) {
            return (h = h.flags) ? 0 <= h.indexOf(G) : !1
        }
        function ma(h) {
            const G = {};
            h = qa(h, "ns");
            if (null !== h) {
                h = h.split(" ");
                for (let Q = 0; Q < h.length; Q++) {
                    const u = h[Q].split("=");
                    G[u[0]] = "~" === u[1] ? Zb.withPrefix[u[0]] : u[1]
                }
            }
            return G
        }
        function qa(h, G) {
            for (; h; ) {
                if (h[G])
                    return h[G];
                h = h.parentNode
            }
            return null
        }
        function L(h, G) {
            const Q = ma(h);
            return function(u) {
                if ("" === u && !G)
                    return "";
                const N = Q[u];
                if (N)
                    return N;
                if ("" === u)
                    return "";
                throw new F("Undeclared prefix: " + u,"XTDE0290",h);
            }
        }
        function aa(h, G, Q) {
            return fa.QName.fromString(G, L(h, Q))
        }
        function z(h, G, Q) {
            if (null !== h && 0 < Q) {
                const u = S.getAttribute(h, G);
                return null !== u && "" !== u ? u : z(h.parentNode, G, Q - 1)
            }
        }
        function D(h, G, Q) {
            let u, N = h.bSlot;
            N ? (N = parseInt(N, 10),
            h = G.sa.We[N],
            u = G.fixed.La[h]) : (h = h.coId) ? u = G.fixed.La[parseInt(h, 10)] : sa.la("No binding slot or component Id for component");
            u || sa.la("Target component not found (slot=" + N + " id=" + h + ")");
            if ("ABSTRACT" === u.visibility)
                throw new F("Abstract " + u.actor.N + " " + u.actor.name + " has no implementation","XTDE3052");
            Q && u.actor.N !== Q && sa.la("Expected " + Q + ", found " + u.actor.N);
            return u
        }
        function y(h, G, Q, u) {
            h = B(G.actor, "body");
            h = n(h);
            u = u.ba(!0);
            u.sa = G;
            gd(u);
            u.qa = "function";
            u.gb = {};
            u.ab = null;
            u.focus = null;
            u.Mb = [];
            u.oa = Q;
            return h(u)
        }
        function I(h, G) {
            for (h = h.parentNode; "package" !== h.N; )
                h = h.parentNode;
            return G.fixed.rd[h.name]
        }
        function R(h, G) {
            return n(h)(G)
        }
        function M(h) {
            return G=>{
                const Q = Vd(G)
                  , u = Zd.Fc(Q);
                Zd.push(h, G, u);
                u.close();
                return Kb(Q.Ob)
            }
        }
        function ca(h, G) {
            h instanceof F && !h.xsltLineNr && ra(h, G);
            throw h;
        }
        function ea(h, G) {
            function Q(N) {
                return "Context item for template " + h.name + " must be " + N
            }
            if (ee(G) && -1 === h.flags.indexOf("o"))
                throw new F(Q("supplied"),"XTTE3090",h);
            ee(G) || -1 !== h.flags.indexOf("s") || (G.focus = {});
            let u = h.cxt;
            if (u && !ee(G) && !fc(u).ia()(ed(G)))
                throw new F(Q("instance of " + fc(u).toString()),"XTTE0590",h);
        }
        function ja(h) {
            return h instanceof $c
        }
        function Y(h) {
            return h instanceof cc || h instanceof K
        }
        function V(h) {
            return h instanceof ad.XdmFunction || ja(h) || Y(h)
        }
        function la(h) {
            var G = Object.assign(h);
            G.ELAB = void 0;
            h.C && (G.C = h.C.map(Q=>la(Q)));
            return G
        }
        function x(h, G, Q) {
            sa.assert(Array.isArray(h));
            sa.assert(G instanceof gc);
            const u = G.$();
            let N = u.p;
            if (u.o && !Ed(u.o)(h.length))
                throw new F("Supplied value " + sa.showValue(h) + " does not match required cardinality " + u.o + (Q ? " in " + Q() : ""),"XPTY0004");
            if (0 < h.length) {
                if (G.U.pa()) {
                    h = cd.li(h);
                    const P = La.XS.untypedAtomic;
                    if (kd(G.U))
                        h = h.map(ia=>ia.isNumeric() ? ia : P.matches(ia) ? La.XS.double.R(ia) : ia instanceof K ? La.XS.double.fromString(ia.value.toString()) : ia);
                    else {
                        const ia = La.codes[N]
                          , ua = ia.R;
                        "A" !== N && (h = h.map(Ba=>P.matches(Ba) ? ua(Ba) : Ba instanceof K ? ia.fromString(Ba.value.toString()) : Ba));
                        ["AO", "AF"].includes(N) && (h = h.map(Ba=>Ba.isNumeric() ? ia.R(Ba) : Ba));
                        "AS" === N && (h = h.map(Ba=>La.XS.anyURI.matches(Ba) ? ia.R(Ba) : Ba))
                    }
                } else if (G.U.Jd())
                    if (["FM", "FA"].includes(N))
                        h = T(h);
                    else if (G.U instanceof dd) {
                        const P = G.U.ia();
                        h.every(ia=>P(ia)) || (h = h.map(ia=>{
                            if (P(ia))
                                return ia;
                            if (ia instanceof ad.XdmFunction) {
                                var ua = G.U;
                                const Ba = ua.j.length;
                                ua = {
                                    minArgs: Ba,
                                    maxArgs: Ba,
                                    sig: ua.ha(),
                                    alphaTree: ua.$()
                                };
                                return new ad.zg(ua,ia)
                            }
                            return ia
                        }
                        ))
                    }
                if (!G.matches(h))
                    throw new F("Supplied value " + sa.showValue(h) + " does not match required type " + G.toString() + (Q ? " in " + Q() : ""),"XPTY0004");
            }
            return h
        }
        function K(h) {
            this.value = h
        }
        function U(h) {
            this.value = h
        }
        function ha(h) {
            function G(u) {
                switch (typeof u) {
                case "undefined":
                    return [];
                case "string":
                    return fa.untypedAtomic.fromString(u);
                case "number":
                    return fa.double.fromNumber(u);
                case "boolean":
                    return fa.boolean.fromBoolean(u);
                case "function":
                    return new K(u);
                case "object":
                    if (fa.Qf.matches(u) || S.X(u))
                        return u;
                    if (u instanceof $c)
                        return u;
                    if (u instanceof ad.XdmFunction || u instanceof cc)
                        return u;
                    if (u instanceof K)
                        return u;
                    if (u instanceof Date)
                        return fa.dateTime.fromString(u.toISOString());
                    if (Array.isArray(u)) {
                        const N = [];
                        u.forEach(function(P) {
                            N.push(ha(P))
                        });
                        return new $c(N)
                    }
                    return null === u ? [] : u instanceof U ? u.value : new K(u);
                default:
                    return new K(u)
                }
            }
            function Q(u) {
                const N = [];
                u.forEach(function(P) {
                    P = G(P);
                    Array.isArray(P) && 0 === P.length || N.push(P)
                });
                return N
            }
            if (Array.isArray(h))
                return Q(h);
            h = G(h);
            return Array.isArray(h) && 0 === h.length ? [] : [h]
        }
        function T(h) {
            function G(u) {
                if (u instanceof $c) {
                    const N = [];
                    u.value.forEach(P=>N.push(Q(P)));
                    return new $c(N)
                }
                if (u instanceof K) {
                    const N = u.value;
                    if ("object" === typeof N) {
                        u = new cc;
                        for (const P in N)
                            if (N.hasOwnProperty(P)) {
                                const ia = ha(P)[0]
                                  , ua = ha(N[P]);
                                u.inSituPut(ia, T(ua))
                            }
                        return u
                    }
                }
                return u
            }
            function Q(u) {
                const N = [];
                u.forEach(function(P) {
                    P = G(P);
                    Array.isArray(P) && 0 === P.length || N.push(P)
                });
                return N
            }
            sa.assert(Array.isArray(h));
            return Q(h)
        }
        function w(h, G=!1) {
            function Q(N) {
                if (Array.isArray(N))
                    throw new F("convertItem() called for an array","SXJS0004");
                if (null === N)
                    return null;
                if (fa.string.matches(N) || fa.anyURI.matches(N) || fa.duration.matches(N) || fa.hexBinary.matches(N) || fa.base64Binary.matches(N) || fa.untypedAtomic.matches(N))
                    return N.toString();
                if (fa.numeric.matches(N))
                    return N.toNumber();
                if (fa.boolean.matches(N))
                    return N.toBoolean();
                if (fa.dateTime.matches(N) || fa.cd.matches(N) || fa.Ed.matches(N) || fa.time.matches(N) || fa.nh.matches(N) || fa.mh.matches(N) || fa.lh.matches(N) || fa.kh.matches(N) || fa.jh.matches(N))
                    return N.toString();
                if (fa.QName.matches(N))
                    return N.toEQName();
                if (S.X(N))
                    return N;
                if (N instanceof $c) {
                    const P = [];
                    0 !== N.value.length && N.value.forEach(function(ia) {
                        P.push(w(ia, G))
                    });
                    return P
                }
                if (N instanceof cc) {
                    if (G) {
                        const P = {};
                        N.forAllPairs(function(ia) {
                            P[ia.k.toString()] = w(ia.v, G)
                        });
                        return P
                    }
                    return new U(N)
                }
                return N instanceof U ? N : N instanceof K ? N.value : new U(N)
            }
            function u(N) {
                const P = [];
                if (0 === N.length)
                    return null;
                if (1 === N.length)
                    return Q(N[0]);
                N.forEach(function(ia) {
                    P.push(Q(ia))
                });
                return P
            }
            return Array.isArray(h) ? u(h) : Q(h)
        }
        function Z(h) {
            return h.mapOneToMany(function(G) {
                return ja(G) ? Qb(G.value.map(function(Q) {
                    return Z(Kb(Q))
                })) : Pb(G)
            })
        }
        const S = ac
          , da = S.Ja
          , fa = La.XS;
        let na;
        const va = {
            acFnRef: function(h) {
                const G = fa.QName.fromEQName(h.name)
                  , Q = Jd.find("SaxonJS").XPath;
                return u=>{
                    u = u.ba(!0);
                    u.bb = !0;
                    if (u = Q.getFnSignature(G, 1, u))
                        return u = new ad.Bf(u,G,h),
                        Pb(u);
                    throw new F("Reference to an unknown constructor function " + G + "#1","XPST0017",h);
                }
            },
            among: function(h) {
                const G = l(h)
                  , Q = r(h);
                return u=>{
                    const N = G(u).next();
                    return Q(u).filter(P=>S.isSameNode(P, N))
                }
            },
            analyzeString: M,
            and: function(h) {
                const G = l(h)
                  , Q = r(h);
                return u=>Xb(e(G(u)) && e(Q(u)))
            },
            applyImports: M,
            applyT: M,
            arith: function(h) {
                const G = mb[h.calc];
                G || d("arithmetic (" + h.calc + ")", h);
                const Q = f(h, G);
                return u=>Pb(Q(u))
            },
            arith10: function(h) {
                function G(P) {
                    P = P.next();
                    return null === P ? fa.double.fromNumber(NaN) : Ia(P) ? fa.double.cf(P.toString()) : fa.double.R(P)
                }
                const Q = l(h)
                  , u = r(h)
                  , N = mb[h.calc];
                return P=>Pb(N(G(Q(P)), G(u(P))))
            },
            array: function(h) {
                const G = (h.C || []).map(n);
                return Q=>{
                    const u = G.map(N=>N(Q).expand());
                    return Pb(new $c(u))
                }
            },
            arrayBlock: function(h) {
                const G = (h.C || []).map(n);
                return Q=>{
                    const u = G.map(N=>N(Q).expand());
                    return Pb(new $c(u))
                }
            },
            atomic: function(h) {
                const G = La.codes[h.type].fromString(h.val);
                return ()=>Pb(G)
            },
            atomSing: function(h) {
                const G = l(h);
                return h.card ? Q=>G(Q).mapOneToMany(H) : Q=>{
                    Q = G(Q).mapOneToMany(H);
                    Q = Fb(Q);
                    if (null === Q.ua())
                        throw Q = q(h.diag),
                        new F("The " + Q.required + " is empty",Q.code,h);
                    return Q
                }
            },
            att: M,
            attVal: function(h) {
                const G = fa.QName.fromEQName(h.name);
                return Q=>{
                    fd(Q, "XPDY0002", "@" + G, h);
                    Q = ed(Q);
                    if (!S.X(Q))
                        throw new F("Context item for 'attVal' must be a node","XPTY0020",h);
                    if (1 !== Q.nodeType)
                        return Ob;
                    Q = "" === G.uri ? Q.hasAttribute(G.local) ? Q.getAttribute(G.local) : null : G.uri === Zb.xml ? Q.hasAttribute("xml:" + G.local) ? Q.getAttribute("xml:" + G.local) : null : Q.hasAttributeNS(G.uri, G.local) ? Q.getAttributeNS(G.uri, G.local) : null;
                    return null === Q ? Ob : Pb(fa.untypedAtomic.fromString(Q))
                }
            },
            axis: function(h) {
                const G = fc(h.nodeTest || "").ia()
                  , Q = h.name;
                return u=>{
                    fd(u, "XPDY0002", Q + " axis", h);
                    u = ed(u);
                    if (!S.X(u))
                        throw new F("Context item for " + Q + " axis is not a node - supplied:" + sa.showValue(u),"XPTY0020",h);
                    return S.Ng[Q](u).filter(G)
                }
            },
            "break": M,
            callT: function(h) {
                return G=>{
                    const Q = D(h, G, "template")
                      , u = G.ba(!0);
                    u.Bb = null;
                    u.sa = Q;
                    ea(Q.actor, u);
                    t(h, G, u);
                    return l(Q.actor)(u)
                }
            },
            cast: function(h) {
                const G = l(h)
                  , Q = W(h, "e")
                  , u = N=>{
                    N = G(N).next();
                    if (null === N) {
                        if (Q)
                            return null;
                        throw new F("Empty sequence casting to " + fc(h.as).toString(),"XPTY0004",h);
                    }
                    return N
                }
                ;
                if (W(h, "a")) {
                    const N = rb(h.as)
                      , P = "AQ" === N.p ? L(h, !0) : null
                      , ia = La.codes[N.p].R;
                    return ua=>{
                        ua = u(ua);
                        if (null === ua)
                            return Ob;
                        try {
                            var Ba = ia(ua, P);
                            return Pb(Ba)
                        } catch (Fa) {
                            if ("FORG0001" === Fa.code && h.diag)
                                throw Ba = q(h.diag),
                                new F("Required item type of " + Ba.required + " is " + fc(h.as).toString() + "; supplied value is " + sa.Nh(ua),Ba.code,h);
                            if (null !== Fa.code)
                                throw Fa;
                            throw new F("Failed to cast " + sa.Nh(ua) + " to type " + fc(h.as).toString(),"XPTY0004",h);
                        }
                    }
                }
                if (W(h, "l")) {
                    const N = La.XS.QName.fromEQName(h.as)
                      , P = Tc[N.local].fromString;
                    sa.assert(N.uri === Zb.lc);
                    sa.assert(P);
                    return ia=>{
                        ia = u(ia);
                        if (null === ia)
                            return Ob;
                        ia = Ha.collapse(ia.toString()).split(" ").map(P);
                        if (0 === ia.length)
                            throw new F("xs:" + N.local + " value must contain at least one token","FORG0001");
                        return Kb(ia)
                    }
                }
                if (W(h, "u"))
                    return N=>{
                        N = u(N);
                        return null === N ? Ob : La.XS.double.matches(N) || La.XS.mb.matches(N) || La.XS.float.matches(N) ? Pb(N) : Pb(La.XS.double.R(N))
                    }
                    ;
                throw new F("Unknown cast variety " + h.flags);
            },
            castable: function(h) {
                const G = l(h)
                  , Q = W(h, "e");
                let u;
                if (W(h, "a")) {
                    const N = rb(h.as)
                      , P = "AQ" === N.p ? L(h, !0) : null
                      , ia = La.codes[N.p].R;
                    u = ua=>{
                        ia(ua, P);
                        return !0
                    }
                } else if (W(h, "l")) {
                    h = La.XS.QName.fromEQName(h.as);
                    const N = Tc[h.local].fromString;
                    u = P=>0 < Ha.collapse(P.toString()).split(" ").map(N).length
                } else if (W(h, "u"))
                    u = N=>{
                        La.XS.double.R(N);
                        return !0
                    }
                    ;
                else
                    throw new F("Unknown castable variety " + h.flags);
                return N=>{
                    N = G(N);
                    const P = N.next();
                    if (null === P)
                        return Xb(Q);
                    if (null !== N.next())
                        return Xb(!1);
                    N = H(P).next();
                    try {
                        return Xb(u(N))
                    } catch (ia) {
                        return Xb(!1)
                    }
                }
            },
            cfn: function(h) {
                const G = h.name
                  , Q = l(h);
                let u;
                if ("_format-number_1" === G)
                    return u = ke["format-number"],
                    N=>{
                        const P = [Q(N), Tb(h.pic)];
                        h.hasAttribute("format") && P.push(Tb(h.format));
                        return u(P, N, h)
                    }
                    ;
                if ("_translate_1" === G)
                    return u = ke.translate,
                    N=>{
                        const P = [Q(N), Tb(h.a1), Tb(h.a2)];
                        return u(P, N)
                    }
                    ;
                sa.la("Unimplemented: cfn " + G, h)
            },
            check: function(h) {
                function G(P) {
                    const ia = q(h.diag);
                    throw new F("Required cardinality of " + ia.required + " is " + u[Q] + "; supplied value " + P,ia.code,h);
                }
                const Q = h.card
                  , u = {
                    "*": "zero or more",
                    "+": "one or more",
                    "?": "zero or one",
                    0: "zero",
                    1: "exactly one"
                }
                  , N = l(h);
                return P=>{
                    P = N(P);
                    if ("*" === Q)
                        return P;
                    var ia = Fb(P);
                    P = ia.ua();
                    if (null === P) {
                        if ("?" === Q || "0" === Q)
                            return Ob;
                        G("is empty")
                    } else
                        "0" === Q && G("is not empty (first item " + sa.showValue(P) + ")");
                    if ("+" === Q)
                        return ia;
                    ia.next();
                    const ua = ia.next();
                    null !== ua && (ia = ia.count() + 2,
                    G("contains " + ia + " items (" + sa.showValue(P) + ", " + sa.showValue(ua) + (2 < ia ? ",... )" : ")")));
                    return Pb(P)
                }
            },
            choose: function(h) {
                const G = h.C.map(n);
                return Q=>{
                    for (let u = 0; u < G.length; u += 2)
                        if (e(G[u](Q)))
                            return G[u + 1](Q);
                    return Ob
                }
            },
            coercedFn: function(h) {
                const G = l(h);
                return Q=>G(Q)
            },
            comment: M,
            compareToInt: function(h) {
                const G = h.op
                  , Q = fa.integer.fromString(h.val)
                  , u = l(h);
                return N=>{
                    N = u(N);
                    const P = N.next();
                    if (null === P)
                        return Ob;
                    if (Hd.tc(P))
                        return Xb("ne" === G);
                    if (null !== N.next())
                        throw new F("Value comparison only applicable to single values","XPTY0004",h);
                    return Xb(Hd.wf(G, P.compareTo(Q)))
                }
            },
            compareToString: function(h) {
                const G = h.op
                  , Q = l(h)
                  , u = fa.string.fromString(h.val);
                return N=>{
                    const P = Q(N)
                      , ia = P.next();
                    if (null === ia)
                        return Ob;
                    if (null !== P.next())
                        throw new F("Value comparison only applicable to single values","XPTY0004",h);
                    return h.comp ? (N = Hd.fe(h.comp, N),
                    ["=", "eq", "!=", "ne"].includes(G) ? Xb(Hd.Th(G, N.equals(ia, u))) : Xb(Hd.wf(G, N.compare(ia, u)))) : Xb(Hd.wf(G, ia.compareTo(u)))
                }
            },
            compAtt: M,
            compElem: M,
            condCont: function(h) {
                const G = l(h);
                return Q=>{
                    function u(N) {
                        if (S.X(N))
                            switch (N.nodeType) {
                            case 9:
                            case 11:
                            case 1:
                                return N.hasChildNodes();
                            default:
                                return "" !== p(N).toString()
                            }
                        else
                            return Y(N) ? 0 < N.keys().length : ja(N) ? 0 < N.value.filter(function(P) {
                                return 0 < P.filter(ia=>u(ia)).length
                            }).length : "" !== fa.string.R(N).toString()
                    }
                    return G(Q).filter(u)
                }
            },
            condSeq: function(h) {
                function G(u) {
                    if (S.X(u)) {
                        if ([9, 11].includes(u.nodeType))
                            return !u.hasChildNodes();
                        if (3 === u.nodeType || 4 == u.nodeType)
                            return "" === u.nodeValue
                    } else {
                        if (La.pa(u))
                            return "" === fa.string.R(u).toString();
                        if (ja(u))
                            return !Z(Pb(u)).some(function(N) {
                                return !G(N)
                            })
                    }
                    return !1
                }
                const Q = h.C.map(u=>({
                    name: u.N,
                    eval: n(u)
                }));
                return u=>{
                    let N = [];
                    const P = [];
                    let ia = !0;
                    Q.map(function(ua) {
                        if ("onEmpty" === ua.name)
                            ia && (N = ua.eval(u).expand());
                        else if ("onNonEmpty" === ua.name) {
                            const Ba = N.length;
                            P.unshift(function() {
                                N.splice.apply(N, [Ba, 0].concat(ua.eval(u).expand()))
                            })
                        } else
                            ua.eval(u).forEachItem(function(Ba) {
                                G(Ba) || (ia = !1);
                                N.push(Ba)
                            })
                    });
                    ia || P.forEach(function(ua) {
                        ua()
                    });
                    return Kb(N)
                }
            },
            conditionalSort: function(h) {
                const G = l(h)
                  , Q = r(h)
                  , u = l(h.C[1]);
                return N=>e(G(N)) ? Q(N) : u(N)
            },
            consume: function(h) {
                throw new F("Stylesheet uses 'consume' which requires streaming","SXJS0002",h);
            },
            convert: function(h) {
                const G = h.to
                  , Q = La.codes[G];
                Q || sa.la("Unknown to-type " + h.to);
                const u = l(h);
                return W(h, "p") ? N=>u(N).mapOneToOne(P=>La.pg(P, G)) : N=>u(N).mapOneToOne(Q.R)
            },
            copy: M,
            copyOf: M,
            currentGroup: function(h) {
                return G=>{
                    if (G && G.ad)
                        return Kb(G.ad);
                    throw new F("There is no current group","XTDE1061",h);
                }
            },
            currentGroupingKey: function(h) {
                return G=>{
                    if (G && G.bd)
                        return Kb(G.bd);
                    throw new F("There is no current grouping key","XTDE1071",h);
                }
            },
            cvUntyped: function(h) {
                const G = l(h)
                  , Q = La.codes[h.to]
                  , u = Q.R
                  , N = "string" === Q.name;
                return P=>G(P).mapOneToOne(function(ia) {
                    if (fa.double.matches(ia) && "float" === Q.name)
                        throw new F("xs:double may not be promoted to xs:float","XTTE0570",h);
                    if (fa.untypedAtomic.matches(ia) || N && fa.anyURI.matches(ia))
                        try {
                            return u(ia)
                        } catch (ua) {
                            if ("FODT0001" === ua.code || !h.diag)
                                throw ua;
                            ia = q(h.diag);
                            throw new F(ua.message,ia.code,h);
                        }
                    else
                        return ia
                })
            },
            data: function(h) {
                const G = l(h);
                return Q=>G(Q).mapOneToMany(H)
            },
            dbl: function(h) {
                const G = fa.double.fromString(h.val);
                return ()=>Pb(G)
            },
            dec: function(h) {
                const G = wa(h.val);
                return ()=>Wb(G)
            },
            doc: M,
            docOrder: function(h) {
                const G = l(h);
                return Q=>S.kd(G(Q))
            },
            dot: function(h) {
                return G=>{
                    fd(G, "XPDY0002", ". (dot)", h);
                    return Pb(ed(G))
                }
            },
            elem: M,
            empty: function() {
                return ()=>Ob
            },
            emptyTextNodeRemover: function(h) {
                const G = l(h);
                return Q=>G(Q).filter(u=>!(S.X(u) && (3 === u.nodeType || 4 === u.nodeType) && "" === u.textContent))
            },
            error: function(h) {
                return ()=>{
                    throw new F(h.message,h.code,h);
                }
            },
            evaluate: function(h) {
                const G = {
                    language: "XSLT",
                    contextType: {
                        o: "1",
                        p: "",
                        code: "1"
                    }
                }
                  , Q = n(B(h, "xpath"))
                  , u = n(B(h, "cxt"))
                  , N = n(B(h, "sa"))
                  , P = n(B(h, "nsCxt"))
                  , ia = v(h, "withParam").map(Ba=>({
                    name: fa.string.fromString(Ba.name),
                    eval: l(Ba)
                }))
                  , ua = n(B(h, "wp"));
                return Ba=>{
                    const Fa = Q(Ba).next().toString();
                    B(h, "cxt");
                    const Pa = u ? u(Ba) : Ob;
                    let Ua = new cc;
                    ia.forEach(function(ta) {
                        Ua.inSituPut(ta.name, ta.eval(Ba).expand())
                    });
                    ua && ua(Ba).next().forAllPairs(function(ta) {
                        if (!fa.QName.matches(ta.k))
                            throw new F("Parameter names in xsl:evaluate/@with-params map must be QNames:" + ta.k.toString(),"XTTE3165",h);
                        Ua.inSituPut(ta.k, ta.v)
                    });
                    Ua = Pb(Ua);
                    if (N) {
                        var Na = N(Ba).next().toString();
                        if (E(Na))
                            throw new F("SaxonJS does not support schema-aware evaluation","XTDE1665",h);
                    }
                    (Na = h.as) && (G.requiredType = Na.toString());
                    (Na = h.dxns) && "http://www.w3.org/1999/xhtml" !== Na.toString() && (G.xpathDefaultNamespace = Na.toString());
                    let Wa = {};
                    if (P) {
                        Na = P(Ba);
                        var J = Na.next();
                        if (null === J || null !== Na.next() || !S.X(J))
                            throw new F("xsl:evaluate/@namespace-context must evaluate to a single node","XTTE3170",h);
                        Wa[""] = "";
                        ac.Ic(J).forEach(ta=>Wa[ta.prefix] = ta.uri);
                        G.xpathDefaultNamespace = Wa[""]
                    } else
                        Wa = ma(h);
                    const X = {};
                    J = Na = !1;
                    const ka = {};
                    var ba = B(h, "options");
                    if (ba) {
                        ba = R(ba, Ba).next();
                        let ta = fa.string.fromString("var-slots");
                        ba.containsKey(ta) && ba.get(ta)[0].forAllPairs(function(Ca) {
                            X[Ca.k.toEQName()] = w(Ca.v)
                        });
                        ta = fa.string.fromString("allow-empty");
                        ba.containsKey(ta) && (Na = ba.get(ta)[0].toBoolean());
                        ta = fa.string.fromString("isStatic");
                        ba.containsKey(ta) && (J = ba.get(ta)[0].toBoolean());
                        ta = fa.string.fromString("staticContext");
                        ba.containsKey(ta) && ba.get(ta)[0].forAllPairs(function(Ca) {
                            ka[Ca.k.toString()] = w(Ca.v, !0)
                        })
                    }
                    G.params = Ua;
                    G.namespaces = Wa;
                    G.slotMap = X;
                    G.allowEmpty = Na;
                    G.staticTyping = !0;
                    G.isStatic = J;
                    G.staticContext = ka;
                    G.dynamicEval = !0;
                    (Na = B(h, "baseUri")) && (G.staticBaseURI = R(Na, Ba).next().toString());
                    (Na = qa(h, "defaultCollation")) && (G.defaultCollation = Na);
                    return Jd.find("SaxonJS").XPath.evaluateXDM(Fa, Pa, Ba, G)
                }
            },
            every: function(h) {
                const G = parseInt(h.slot, 10)
                  , Q = l(h)
                  , u = r(h);
                return N=>{
                    const P = Q(N);
                    return Xb(!P.some(function(ia) {
                        N.oa[G] = [ia];
                        return !e(u(N))
                    }))
                }
            },
            except: function(h) {
                const G = l(h)
                  , Q = r(h);
                return u=>new Hb(G(u),Q(u),S.rb)
            },
            "false": function() {
                return ()=>Xb(!1)
            },
            filter: function(h) {
                const G = l(h)
                  , Q = r(h);
                return W(h, "i") ? u=>{
                    const N = G(u);
                    u = Q(u).expand();
                    if (1 === u.length && fa.numeric.matches(u[0])) {
                        const P = u[0].toNumber();
                        if (N instanceof Kb)
                            return Pb(N.expand()[P - 1] || null);
                        const ia = Sb(N);
                        return ia.filter(function() {
                            return ia.position === P
                        })
                    }
                    return e(Kb(u)) ? N : Ob
                }
                : u=>{
                    const N = G(u)
                      , P = u.ba(!1);
                    P.focus = Sb(N);
                    u = W(h, "p") ? function() {
                        const ia = Q(P).expand();
                        return 1 === ia.length && fa.numeric.matches(ia[0]) ? P.focus.position === ia[0].toNumber() : e(Kb(ia))
                    }
                    : function() {
                        return e(Q(P))
                    }
                    ;
                    return P.focus.filter(u)
                }
            },
            first: function(h) {
                const G = l(h);
                return Q=>Pb(G(Q).next())
            },
            flt: function(h) {
                const G = fa.float.fromString(h.val);
                return ()=>Pb(G)
            },
            fn: function(h) {
                const G = ke[h.name];
                G || d(h.name + "()", h);
                const Q = (h.C || []).map(n);
                return u=>{
                    const N = Q.map(P=>P(u));
                    return G(N, u, h)
                }
            },
            fnCoercer: function(h) {
                const G = l(h)
                  , Q = ec(h.to)
                  , u = Q.U
                  , N = {
                    alphaTree: Q.$()
                };
                return P=>G(P).mapOneToOne(function(ia) {
                    if (!(ia instanceof ad.XdmFunction || ia instanceof $c || ia instanceof cc)) {
                        var ua = q(h.diag);
                        throw new F("Required item type of " + ua.required + " is " + Q.toString() + "; supplied value is " + sa.showValue(ia),ua.code,h);
                    }
                    if ((u instanceof dd ? u.j : []).length !== (ia instanceof ad.XdmFunction ? ia.arity : 1))
                        throw ua = q(h.diag),
                        new F("Required item type of " + ua.required + " is " + Q.toString() + "; supplied value is " + sa.showValue(ia),ua.code,h);
                    return new ad.zg(N,ia)
                })
            },
            fnRef: function(h) {
                let G = h.name;
                G = /^Q{/.test(G) ? fa.QName.fromEQName(G) : fa.QName.fromParts("", Zb.Oa, G);
                const Q = parseInt(h.arity, 10)
                  , u = Jd.find("SaxonJS").XPath;
                return N=>{
                    var P = N.ba(!0);
                    P.bb = !0;
                    if (P = u.getFnSignature(G, Q, P))
                        return N = P.isUserFunction ? new ad.Ff(P,N) : G.uri === Zb.lc ? new ad.Bf(P,G,h) : new ad.He(P,G,Q,h,N),
                        Pb(N);
                    throw new F("Reference to an unknown function and/or arity " + G.toEQName() + "#" + Q,"XPST0017",h);
                }
            },
            follows: function(h) {
                const G = f(h, function(Q, u) {
                    return fa.boolean.fromBoolean(0 < S.rb(Q, u))
                });
                return Q=>Pb(G(Q))
            },
            "for": function(h) {
                const G = parseInt(h.slot, 10)
                  , Q = l(h)
                  , u = r(h);
                return N=>Q(N).mapOneToMany(function(P) {
                    N.oa[G] = [P];
                    return u(N)
                })
            },
            forEach: function(h) {
                const G = l(h)
                  , Q = r(h);
                return B(h, "separator") ? M(h) : u=>{
                    const N = u.ba(!1);
                    N.focus = Sb(G(u));
                    N.ab = null;
                    return N.focus.mapOneToMany(function() {
                        return Q(N)
                    })
                }
            },
            forEachGroup: M,
            fork: c,
            functionCall: function(h) {
                d(h.name + "()", h)
            },
            gc: b,
            gc10: function(h) {
                let G = l(h)
                  , Q = r(h);
                return u=>{
                    let N = G(u).expand()
                      , P = Q(u).expand();
                    1 === N.length && fa.boolean.matches(N[0]) ? P = [fa.boolean.fromBoolean(e(Kb(P)))] : 1 === P.length && fa.boolean.matches(P[0]) ? N = [fa.boolean.fromBoolean(e(Kb(N)))] : (N = g(N),
                    P = g(P));
                    u = Hd.fe(h.comp, u);
                    const ia = h.op;
                    "=" !== ia && "!=" !== ia ? (N = Kb(N).mapOneToOne(La.XS.numeric.xe).expand(),
                    P = Kb(P).mapOneToOne(La.XS.numeric.xe).expand()) : u = Hd.Ki(u);
                    return Hd.gc(Kb(N), P, ia, u, h)
                }
            },
            gcEE: b,
            gVarRef: function(h) {
                return G=>{
                    const Q = D(h, G)
                      , u = Q.actor
                      , N = u.name;
                    if (Q.value === a)
                        throw G = new F("Circularity in global variable " + N,"XTDE0640"),
                        G.Le = !0,
                        G;
                    if (null === Q.value || "undefined" === typeof Q.value) {
                        if ("globalParam" === u.N) {
                            var P = G.fixed.options.Sh
                              , ia = La.XS.QName.fromEQName(N);
                            if (P.containsKey(ia))
                                P = P.get(ia),
                                sa.assert(Array.isArray(P)),
                                ia = ec(u.as || "*"),
                                P = x(P, ia, ()=>"stylesheet parameter " + N),
                                sa.assert(Array.isArray(P)),
                                Q.value = P;
                            else {
                                if (W(u, "r"))
                                    throw new F("Parameter " + N + " is required","XTDE0050",u);
                                if (W(u, "i"))
                                    throw new F("Parameter " + N + " cannot be empty","XTDE0700",u);
                                u.C || (Q.value = [])
                            }
                        }
                        if (null === Q.value || "undefined" === typeof Q.value) {
                            P = !u.parentNode.parentNode.parentNode;
                            ia = G.ba(!0);
                            ia.qa = "variable";
                            ia.ub.push(null);
                            ia.gb = {};
                            ia.ab = null;
                            ia.sa = Q;
                            ia.focus = P ? Rb(G.fixed.hd) : null;
                            try {
                                const ua = l(u);
                                Q.value = a;
                                Q.value = ua(ia).expand()
                            } catch (ua) {
                                throw ua instanceof F && (Q.value = [],
                                fa.QName.fromEQName(N).uri !== Zb.wb + "generated-variable" && (ua.Le = !0)),
                                ua;
                            }
                            ia.ub.pop()
                        }
                    }
                    return Kb(Q.value)
                }
            },
            homCheck: function(h) {
                const G = l(h);
                return Q=>{
                    Q = Fb(G(Q));
                    const u = Q.ua();
                    if (null === u)
                        return Ob;
                    const N = S.X(u);
                    Q = Q.filter(function(P) {
                        if (S.X(P) !== N)
                            throw new F("Cannot mix nodes and atomic values in the result of a path expression","XPTY0018",h);
                        return !0
                    });
                    return N ? S.kd(Q) : Q
                }
            },
            ifCall: function(h) {
                const G = fa.QName.fromEQName(h.name);
                if ("schedule-action" === G.local) {
                    const u = l(h)
                      , N = r(h)
                      , P = n(h.C[3]);
                    return ia=>{
                        var ua = 4 === h.C.length;
                        if (4 < h.C.length)
                            throw new F("Only attributes @wait, @document and @http-request are available on ixsl:schedule-action in this version of SaxonJS","SXJS0002",h);
                        var Ba = u(ia).next().toNumber()
                          , Fa = N(ia).next()
                          , Pa = ua ? P(ia).next() : null;
                        ua = null;
                        const Ua = ia.ba(!0);
                        gd(Ua);
                        let Na, Wa, J;
                        3 > h.C.length || "empty" === h.C[2].N ? Na = Wa = J = null : (Na = h.C[2],
                        "bSlot"in Na ? (Wa = D(Na, ia, "template"),
                        J = Wa.actor) : Wa = J = null);
                        ee(ia) || (Ua.focus = Sb(Pb(ed(ia))),
                        Ua.focus.next());
                        Ua.Bb = null;
                        Ua.sa = Wa;
                        Ua.qa = !1;
                        null === Pa && null !== J && ea(J, Ua);
                        null != Na && t(Na, ia, Ua);
                        let X, ka;
                        null === J ? (X = null,
                        ka = function() {}
                        ) : (X = l(J),
                        ka = function() {
                            X(Ua).expand()
                        }
                        );
                        if (null !== Pa)
                            ua = pa.lj(Pa, function(ba) {
                                Ua.focus = Sb(Pb(ba[0]));
                                Ua.focus.next();
                                null !== J && (ea(J, Ua),
                                ka())
                            }, Ba, ia.fixed.Ta);
                        else if (null !== Fa)
                            Fa = Fa.toString().split(" "),
                            Pa = Fa.map(function(ba) {
                                return pa.Fb(ba, cd.Ia(h, ia))
                            }),
                            pa.jd() ? (ua = pa.hi(Pa, ia.fixed.vd, ka, Ba, ia.fixed.Ta),
                            ua = 1 === Fa.length ? ua[Pa[0]] : ua) : (Ba = Pa.map(ba=>Jd.find("SaxonJS").getResource({
                                location: ba,
                                type: "text"
                            }).then(ta=>{
                                try {
                                    return ia.fixed.vd[ba] = ta,
                                    ka(),
                                    Promise.resolve(null)
                                } catch (Ca) {
                                    return ta = Promise.reject(Ca),
                                    ia.fixed.Bj.push(ta),
                                    ta
                                }
                            }
                            )),
                            Ba = Promise.all(Ba),
                            ia.fixed.zd.push(Ba));
                        else if (0 !== Ba)
                            if (pa.jd())
                                setTimeout(ka, Ba);
                            else
                                throw new F("ixsl:schedule-action/@wait is not supported on Node.js","SXJS0002");
                        return ua ? Pb(ua) : Ob
                    }
                }
                const Q = (h.C || []).map(n);
                return u=>{
                    const N = Q.map(P=>P(u));
                    return na(G.uri, G.local, N, u, h)
                }
            },
            indexedFilter2: function(h) {
                const G = n(B(h, "base"))
                  , Q = n(B(h, "use"))
                  , u = n(B(h, "search"));
                return N=>{
                    const P = Hd.fe(h.comp, N)
                      , ia = N.ba(!1);
                    ia.focus = Sb(G(N));
                    const ua = u(N).expand();
                    return ia.focus.filter(function() {
                        const Ba = Q(ia);
                        return Hd.gc(Ba, ua, "=", P, h).next().toBoolean()
                    })
                }
            },
            inlineFn: function(h) {
                const G = {
                    sig: h.sType,
                    alphaTree: rb(h.sType)
                };
                return Q=>Pb(new ad.ai(G,h,Q))
            },
            instance: function(h) {
                const G = l(h)
                  , Q = ec(h.of);
                return u=>{
                    u = G(u).expand();
                    return Xb(Q.matches(u))
                }
            },
            "int": function(h) {
                const G = fa.integer.fromString(h.val);
                return ()=>Pb(G)
            },
            intersect: function(h) {
                const G = l(h)
                  , Q = r(h);
                return u=>new Gb(G(u),Q(u),S.rb)
            },
            intRangeTest: function(h) {
                const G = l(h);
                h = h.C;
                const Q = n(h[1])
                  , u = n(h[2]);
                return N=>{
                    const P = Q(N).next()
                      , ia = u(N).next();
                    if (!P || !ia)
                        return Xb(!1);
                    const ua = P.toNumber()
                      , Ba = ia.toNumber();
                    N = G(N).some(function(Fa) {
                        Fa = Fa.value;
                        return Fa >= ua && Fa <= Ba
                    });
                    return Xb(N)
                }
            },
            is: function(h) {
                const G = f(h, function(Q, u) {
                    return fa.boolean.fromBoolean(S.isSameNode(Q, u))
                });
                return Q=>Pb(G(Q))
            },
            isLast: function(h) {
                const G = "1" === h.test;
                return Q=>Xb(Q.focus.position === Q.focus.last() === G)
            },
            iterate: M,
            javaCall: function(h) {
                const G = fa.QName.fromEQName(h.name)
                  , Q = (h.C || []).map(n);
                return u=>{
                    const N = Q.map(P=>P(u));
                    return na(G.uri, G.local, N, u, h)
                }
            },
            lastOf: function(h) {
                const G = l(h);
                return Q=>{
                    const u = Fb(G(Q));
                    return u.filter(function() {
                        return null === u.ua()
                    })
                }
            },
            let: function(h) {
                const G = l(h)
                  , Q = r(h)
                  , u = parseInt(h.slot, 10);
                return N=>{
                    const P = N.qa;
                    N.qa = "variable";
                    const ia = G(N).expand();
                    N.qa = P;
                    N.oa[u] = ia;
                    return Q(N)
                }
            },
            literal: c,
            lookup: function(h) {
                const G = l(h)
                  , Q = r(h);
                return u=>{
                    function N(Na) {
                        Ba = Ba.concat(Fa[Na.toString()])
                    }
                    function P(Na) {
                        Ba = Ba.concat(Fa.get(Na))
                    }
                    function ia(Na) {
                        return function(Wa) {
                            if (!fa.integer.matches(Wa))
                                throw new F("Array lookup key must be of type xs:integer; supplied value is " + sa.showValue(Wa),"XPTY0004",h);
                            Wa = Wa.toNumber();
                            if (1 > Wa || Wa > Na.length)
                                throw new F("Array index (" + Wa + ") out of bounds (1 to " + Na.length + ")","FOAY0001",h);
                            Ba = Ba.concat(Na[Wa - 1])
                        }
                    }
                    const ua = G(u);
                    let Ba = [], Fa;
                    u = Q(u).expand();
                    const Pa = h.tuple;
                    if (null != Pa) {
                        const Na = Pa.split(/\s+/);
                        for (var Ua of u)
                            if (-1 === Na.indexOf(Ua.toString()))
                                throw new F("Tuple lookup key must be one of  " + Pa + ". Supplied key is " + Ua.toString(),"XPTY0004",h);
                    }
                    for (; null !== (Fa = ua.next()); )
                        if (cd.isArray(Fa))
                            Ua = ia(Fa.value),
                            u.forEach(Ua);
                        else if (cd.isMap(Fa))
                            u.forEach(P);
                        else if (null != Pa && cd.vh(Fa))
                            u.forEach(N);
                        else
                            throw new F("The source for a lookup operator (?) must be of type array() or map(); supplied value is " + sa.showValue(Fa),"XPTY0004",h);
                    return Kb(Ba)
                }
            },
            lookupAll: function(h) {
                const G = l(h);
                return Q=>{
                    function u(ua) {
                        P = P.concat(ua)
                    }
                    function N(ua) {
                        P = P.concat(ia.get(ua))
                    }
                    Q = G(Q);
                    let P = [], ia;
                    for (; null !== (ia = Q.next()); )
                        if (cd.isArray(ia))
                            ia.value.forEach(u);
                        else if (cd.isMap(ia))
                            ia.keys().forEach(N);
                        else
                            throw new F("The source for a lookup operator ('?') must be of type array() or map(); supplied value is " + sa.showValue(ia),"XPTY0004",h);
                    return Kb(P)
                }
            },
            lookupTuple: function(h) {
                const G = l(h)
                  , Q = h.key;
                return u=>{
                    u = G(u);
                    let N = [], P;
                    for (; null !== (P = u.next()); )
                        if (null != Q && cd.vh(P))
                            N = N.concat(P[Q]);
                        else
                            throw new F("The source for a lookupTuple operator (?) must be of type tuple(); supplied value is " + sa.showValue(P),"XPTY0004",h);
                    return Kb(N)
                }
            },
            map: function(h) {
                const G = (h.C || []).map(n);
                return Q=>{
                    const u = new cc;
                    let N = null;
                    G.forEach(function(P) {
                        if (null === N)
                            N = P(Q).next();
                        else {
                            if (u.containsKey(N))
                                throw new F("Duplicate map constructor entries for key:" + sa.showValue(N),"XQDY0137",h);
                            P = P(Q).expand();
                            u.inSituPut(N, P);
                            N = null
                        }
                    });
                    return Pb(u)
                }
            },
            merge: function(h) {
                return G=>le.mj(h, G)
            },
            mergeAdj: function(h) {
                const G = l(h);
                return Q=>{
                    const u = []
                      , N = G(Q);
                    let P = !1, ia;
                    for (; null !== (ia = N.next()); ) {
                        var ua = S.X(ia) && (3 === ia.nodeType || 4 === ia.nodeType);
                        ua && "" === ia.nodeValue || (P && ua ? (ua = S.Gc(Q.ja),
                        u.push(ua.createTextNode(u.pop().nodeValue + ia.nodeValue))) : (P = ua,
                        u.push(ia)))
                    }
                    return Kb(u)
                }
            },
            message: function(h) {
                const G = n(B(h, "terminate"))
                  , Q = n(B(h, "error"));
                return u=>{
                    const N = u.qa;
                    u.qa = "variable";
                    var P = G(u).next();
                    let ia = Q(u).next().toString();
                    try {
                        ia = aa(h, ia, !0).toEQName()
                    } catch (Pa) {
                        ia = "Q{http://www.w3.org/2005/xqt-errors}XTMM9000"
                    }
                    let ua;
                    try {
                        ua = E(P.toString())
                    } catch (Pa) {
                        throw new F("The terminate attribute of xsl:message must be yes|no|true|false|1|0","XTDE0030",h);
                    }
                    P = Vd(u);
                    const Ba = new $d(P);
                    try {
                        var Fa = Zd.Fc(Ba);
                        Fa.Ea();
                        Zd.push(h.C[0], u, Fa);
                        Fa.za()
                    } catch (Pa) {
                        Ba.append(La.XS.string.fromString("xsl:message evaluation at " + sa.location(h) + " failed: " + Pa))
                    }
                    Fa = Kb(P.Ob).next();
                    u.fixed.options.Xf || (u.fixed.options.Xf = pa.oh());
                    try {
                        P = ia,
                        u.uc[P] || (u.uc[P] = 0),
                        u.uc[P]++,
                        u.fixed.options.Xf(Fa, ia)
                    } catch (Pa) {}
                    if (ua)
                        throw sa.Ma(u.getStackTrace(), 1, u.fixed.Ta),
                        u = new F("Terminated with " + Fa,ia,h),
                        u.errorObject = Fa,
                        u;
                    u.qa = N;
                    return Ob
                }
            },
            minus: function(h) {
                const G = l(h);
                return Q=>G(Q).mapOneToOne(u=>u.nf())
            },
            namespace: function(h) {
                const G = l(h)
                  , Q = r(h);
                return u=>{
                    const N = G(u).next().toString();
                    u = Q(u).next().toString();
                    if ("" !== N && !Ha.Lb(N))
                        throw new F("Prefix " + N + " is not an NCName","XTDE0920",h);
                    if ("" === u)
                        throw new F("Namespace is zero-length","XTDE0930",h);
                    if ("xmlns" === N)
                        throw new F("Disallowed prefix xmlns","XTDE0920",h);
                    if ("http://www.w3.org/2000/xmlns/" === u)
                        throw new F("Disallowed namespace " + u,"XTDE0905",h);
                    if (!C(u))
                        throw new F("Invalid namespace " + u,"XTDE0905",h);
                    if ("xml" === N !== (u === Zb.xml))
                        throw new F("The xml namespace prefix and uri can only be used together","XTDE0925",h);
                    return Pb(new bc(N,u))
                }
            },
            nextIteration: M,
            nextMatch: M,
            nodeNum: function(h) {
                return G=>fe.rj(h, G)
            },
            "null": function(h) {
                return ()=>Pb(h)
            },
            numSeqFmt: function(h) {
                return G=>fe.sj(h, G)
            },
            onEmpty: c,
            onNonEmpty: c,
            or: function(h) {
                const G = l(h)
                  , Q = r(h);
                return u=>Xb(e(G(u)) || e(Q(u)))
            },
            origFC: function(h) {
                h.C || (h.C = []);
                const G = h.C.map(n);
                return Q=>{
                    if (!h._target) {
                        const P = h.pack
                          , ia = aa(h, h.name, !1).toEQName()
                          , ua = h.C.length
                          , Ba = Q.fixed.La;
                        Object.keys(Ba).forEach(function(Fa) {
                            Fa = Ba[Fa];
                            Fa.Dh.name === P && Fa.name === ia && Fa.actor && "function" === Fa.actor.N && v(Fa.actor, "arg").length === ua && (h._target = Fa.id)
                        })
                    }
                    const u = Q.fixed.La[h._target]
                      , N = G.map(P=>P(Q).expand());
                    return y(h, u, N, Q)
                }
            },
            param: function(h) {
                const G = h.name
                  , Q = parseInt(h.slot, 10)
                  , u = W(h, "t")
                  , N = n(B(h, "select"))
                  , P = n(B(h, "conversion"));
                return ia=>{
                    var ua = u ? ia.Qb : ia.Kc
                      , Ba = La.XS.QName.fromEQName(G);
                    if (ua.containsKey(Ba))
                        ua = ua.get(Ba),
                        "" !== ec(h.as || "*").$().p && (ua = T(ua));
                    else if (N && !W(h, "r"))
                        Ba = ia.qa,
                        ia.qa = "xsl:param",
                        ua = N(ia).expand(),
                        ia.qa = Ba;
                    else
                        throw new F("Required parameter $" + G + " not supplied","XTDE0700",h);
                    sa.assert(Array.isArray(ua));
                    ia.oa[Q] = ua;
                    if (P)
                        try {
                            ia.oa[Q] = P(ia).expand()
                        } catch (Fa) {
                            throw new F("Supplied value for parameter $" + G + " could not be converted to required type","XTTE0590",h);
                        }
                    return Ob
                }
            },
            partialApply: function(h) {
                const G = l(h)
                  , Q = []
                  , u = [];
                let N = 0;
                const P = h.C.length - 1;
                for (let ia = 1; ia < h.C.length; ia++) {
                    const ua = h.C[ia];
                    "null" === ua.N ? (N++,
                    Q.push(rb(ua.sT || "*"))) : u[ia - 1] = n(ua)
                }
                return ia=>{
                    const ua = G(ia).next()
                      , Ba = [];
                    for (let Fa = 0; Fa < P; Fa++)
                        u[Fa] && (Ba[Fa] = u[Fa](ia).expand());
                    ia = {
                        o: "1",
                        p: "F",
                        r: ua.xb.alphaTree.r,
                        a: Q
                    };
                    return Pb(new ad.$h({
                        minArgs: N,
                        maxArgs: N,
                        sig: sb(ia),
                        alphaTree: ia
                    },ua,Ba))
                }
            },
            precedes: function(h) {
                const G = f(h, function(Q, u) {
                    return fa.boolean.fromBoolean(0 > S.rb(Q, u))
                });
                return Q=>Pb(G(Q))
            },
            procInst: M,
            qName: function(h) {
                const G = fa.QName.fromParts(h.pre, h.uri, h.loc);
                return ()=>Pb(G)
            },
            range: function(h) {
                const G = fa.integer.fromString(h.from)
                  , Q = fa.integer.fromString(h.to);
                return ()=>k(G, Q)
            },
            resultDoc: function(h) {
                return G=>{
                    try {
                        if (G.qa)
                            throw new F("Cannot call xsl:result-document while evaluating " + G.qa,"XTDE1480",h);
                        var Q = I(h, G);
                        const u = {};
                        let N = function() {};
                        const P = B(h, "format");
                        if (P) {
                            let ka = R(P, G).next().toString();
                            ka = aa(h, ka, !0).toEQName();
                            const ba = Q.mg[ka];
                            if (!ba)
                                throw new F("Unknown xsl:output format " + ka,"XTDE1460");
                            let ta, Ca;
                            for (const Ka of ba.C) {
                                let Qa = Ka.name;
                                "parameter-document" === Qa ? ta = Ka.value : "Q{http://saxon.sf.net/}parameter-document-base-uri" === Qa ? Ca = Ka.value : u[Qa] = "use-character-maps" === Qa ? ge.yf(Qa, Ka.value, Q) : ge.zf(Qa, Ka.value)
                            }
                            if (ta) {
                                const Ka = pa.Fb(ta, Ca);
                                let Qa = Nd.Dc(Ka, G);
                                ge.parseParamDoc(Qa.documentElement, u)
                            }
                        }
                        m(h.global, u, Q);
                        m(h.local, u, Q);
                        for (const ka of h.C) {
                            let ba = ka.role.replace(/^Q{\}/, "");
                            if (!["href", "format", "content", "parameter-document"].includes(ba)) {
                                "output-version" === ba && (ba = "version");
                                let ta = R(ka, G).next().toString();
                                ta = "use-character-maps" === ba ? ge.yf(ba, ta, Q) : ge.zf(ba, ta, L(h, !0));
                                "undefined" !== typeof ta && (u[ba] = ge.pf(ba, ta, u[ba]))
                            }
                        }
                        const ia = B(h, "Q{}parameter-document");
                        if (null !== ia) {
                            const ka = R(ia, G).next().toString()
                              , ba = pa.Fb(ka, cd.Ia(h, G));
                            let ta = Nd.Dc(ba, G);
                            ge.parseParamDoc(ta.documentElement, u)
                        }
                        const ua = G.fixed.Ib
                          , Ba = B(h, "href")
                          , Fa = null === Ba ? "" : R(Ba, G).next().toString();
                        let Pa;
                        Pa = ua ? pa.newURL(Fa, ua) : S.ld(Fa) ? pa.newURL(Fa) : Fa;
                        const Ua = Pa.toString();
                        if (G.fixed.Ib && Ua === G.fixed.Ib.toString() && 1 < G.ub.length)
                            throw new F("Cannot revert to the original output destination while writing a secondary result","XTDE1490");
                        let Na, Wa, J, X;
                        J = !pa.jd() && !G.masterDocument || G.fixed.se ? "file" : "html-page";
                        if ("html-page" !== J) {
                            if (G.fixed.options.dd) {
                                Na = G.fixed.options.dd(Pa);
                                if (!Na)
                                    throw new F("deliverResultDocument() result has no destination");
                                J = Na.destination
                            } else
                                throw new F("No deliverResultDocument function supplied");
                            if ("undefined" !== typeof G.fixed.tb[Ua])
                                throw new F("A result document with URI " + Ua + " is attempting to write to a document already read","XTDE1500",h);
                            if (G.fixed.Jh[Ua])
                                throw new F("A result document with URI " + Ua + " has already been created","XTDE1490",h);
                            G.fixed.Jh[Ua] = !0
                        }
                        if (["file", "serialized"].includes(J))
                            X = new ge.StringWriter,
                            Wa = ge.qh(u, X, G),
                            N = function() {
                                const ka = X.toString()
                                  , ba = u.encoding || "utf-8";
                                if (!Na.save)
                                    throw new F("deliverResultDocument() result has no save method","SXJS0004",h);
                                Na.save(Pa, ka, ba)
                            }
                            ;
                        else if (["document", "raw"].includes(J)) {
                            const ka = Vd(G);
                            Wa = "document" === J ? new $d(ka) : ka;
                            N = function() {
                                const ba = Kb(ka.Ob).next();
                                ba && (ba._saxonBaseUri = Pa.toString());
                                if (!Na.save)
                                    throw new F("deliverResultDocument() result has no save method","SXJS0004",h);
                                Na.save(Pa, ba)
                            }
                        } else if ("html-page" === J) {
                            Q = !1;
                            let ka = u.method || "appendContent";
                            "Q{http://saxonica.com/ns/interactiveXSLT}replace-content" === ka && (ka = "replaceContent",
                            Q = !0);
                            let ba;
                            const ta = "#" === Fa.charAt(0) || "?" === Fa.charAt(0)
                              , Ca = Vd(G);
                            Wa = new $d(Ca);
                            G.ub.push(Fa);
                            const Ka = O(B(h, "content"), G, ta)
                              , Qa = function(ib, Xa) {
                                da.Ka(ib).forEachItem(function(ob) {
                                    Xa.appendChild(ob)
                                })
                            };
                            if (ta) {
                                if (!G.masterDocument)
                                    return sa.Ma("Result document href=" + Fa + ": no master document available", 1, G.fixed.Ta),
                                    Ob;
                                if ("?." === Fa)
                                    ba = ed(G);
                                else if ("?" === Fa.charAt(0)) {
                                    const ib = ed(G)
                                      , Xa = Fa.substring(1)
                                      , ob = {
                                        language: "XSLT",
                                        contextType: {
                                            o: "1",
                                            p: "",
                                            code: "1"
                                        },
                                        namespaces: ma(h),
                                        dynamicEval: !0
                                    };
                                    try {
                                        ba = Jd.find("SaxonJS").XPath.evaluateXDM(Xa, Pb(ib), G, ob)
                                    } catch (pb) {
                                        throw new F("Error in xsl:result-document/@href ?xpath:" + pb.message,"SXJS0099",h);
                                    }
                                    ba = ba.expand();
                                    if (1 < ba.length)
                                        throw new F("xsl:result-document/@href ?xpath yields more than one node","SXJS0099",h);
                                    ba = ba[0]
                                } else
                                    ba = G.masterDocument.getElementById(Fa.substring(1));
                                if (!ba)
                                    return sa.Ma("Result document href=" + Fa + ": no such node", 1, G.fixed.Ta),
                                    Ob;
                                if ("?." === Fa && ba !== G.masterDocument && ba.ownerDocument !== S.Gc(G.masterDocument))
                                    return sa.Ma("Result document href=" + Fa + ": current node is not in master document", 1, G.fixed.Ta),
                                    Ob;
                                if (Q)
                                    for (; ba.firstChild; )
                                        ba.removeChild(ba.firstChild);
                                N = function() {
                                    Qa(Ka, ba);
                                    !Jd.find("SaxonJS").getConfigurationProperty("autoResetIndexes") && "_saxonIndexes"in G.masterDocument || (G.masterDocument._saxonIndexes = {},
                                    G.masterDocument._saxonIndexesBC = {})
                                }
                            } else
                                throw new F("xsl:result-document/@href value in browser must be '?.' or '#frag'");
                        } else
                            throw new F("Unsupported result-document destination " + J,"SXJS0002");
                        if ("html-page" !== J && ("" === Fa || Pa.toString() === ua)) {
                            const ka = G.fixed.Ji;
                            if (ka) {
                                if (ka.Yh)
                                    throw new F("Cannot use xsl:result-document to write to a destination already used for the principal output","XTDE1490");
                                if (ka.wg)
                                    throw new F("Cannot write more than one xsl:result-document to the principal output destination","XTDE1490");
                                ka.wg = !0
                            }
                        }
                        if ("html-page" !== J) {
                            G.ub.push(Pa.toString());
                            const ka = B(h, "content")
                              , ba = Zd.Fc(Wa);
                            Zd.push(ka, G, ba);
                            ba.close()
                        }
                        N();
                        G.ub.pop();
                        return Ob
                    } catch (u) {
                        ca(u, h)
                    }
                }
            },
            root: function(h) {
                return G=>{
                    fd(G, "XPDY0002", "/", h);
                    G = ed(G);
                    if (!S.X(G))
                        throw new F("Context item for '/' must be a node","XPTY0020",h);
                    const Q = S.rc(G);
                    if (9 !== Q.nodeType && 11 !== Q.nodeType)
                        throw new F("Root node for '/' must be a document node","XPDY0050",h);
                    return Pb(S.rc(G))
                }
            },
            sequence: c,
            slash: function(h) {
                const G = l(h)
                  , Q = r(h);
                return u=>{
                    const N = u.ba(!1);
                    N.focus = Sb(G(u));
                    return N.focus.mapOneToMany(()=>Q(N))
                }
            },
            some: function(h) {
                const G = parseInt(h.slot, 10)
                  , Q = l(h)
                  , u = r(h);
                return N=>{
                    const P = Q(N);
                    return Xb(P.some(function(ia) {
                        N.oa[G] = [ia];
                        return e(u(N))
                    }))
                }
            },
            sort: function(h) {
                const G = Hd.Kj(h);
                return Q=>{
                    try {
                        return G(Q)
                    } catch (u) {
                        if (u instanceof F && "FOCH0002" === u.code)
                            throw new F(u.message,"XTDE1035",h);
                        if (u instanceof F && "XPTY0004" === u.code)
                            throw new F(u.message,"XTDE1030",h);
                        throw u;
                    }
                }
            },
            sourceDoc: M,
            str: function(h) {
                const G = h.val;
                return ()=>Tb(G)
            },
            subscript: function(h) {
                const G = l(h)
                  , Q = r(h);
                return u=>{
                    var N = G(u);
                    u = Q(u).next();
                    if ("ADI" === u.code)
                        u = u.value;
                    else if (u.equals(u.round(0)))
                        u = La.XS.integer.R(u).value;
                    else
                        return Ob;
                    return (N = N.kf(u)) ? Pb(N) : Ob
                }
            },
            supplied: function(h) {
                const G = parseInt(h.slot, 10);
                return Q=>Kb(Q.oa[G])
            },
            tail: function(h) {
                const G = parseInt(h.start, 10) - 1;
                let Q = l(h);
                return u=>{
                    let N = G;
                    return Q(u).filter(function() {
                        return 0 >= N--
                    })
                }
            },
            tailCallLoop: c,
            to: function(h) {
                const G = l(h)
                  , Q = r(h);
                return u=>{
                    const N = G(u).next();
                    u = Q(u).next();
                    return null === N || null === u || 0 < N.compareTo(u) ? Ob : k(N, u)
                }
            },
            treat: function(h) {
                const G = fc(h.as)
                  , Q = G.ia()
                  , u = l(h);
                return N=>u(N).mapOneToOne(function(P) {
                    if (Q(P))
                        return P;
                    const ia = q(h.diag);
                    throw new F("Required item type of " + ia.required + " is " + G.toString() + "; supplied value is " + sa.showValue(P),ia.code,h);
                })
            },
            "true": function() {
                return ()=>Xb(!0)
            },
            "try": function(h) {
                const G = l(h)
                  , Q = v(h, "catch");
                Q.forEach(u=>{
                    const N = u.errors.split(" ").map(P=>{
                        if ("*" === P)
                            return ()=>!0;
                        if (/^\*:/.test(P)) {
                            const ua = P.substring(2);
                            return Ba=>Ba.local === ua
                        }
                        if (/}\*$/.test(P)) {
                            const ua = P.substring(2, P.length - 2);
                            return Ba=>Ba.uri === ua
                        }
                        const ia = fa.QName.fromEQName(P);
                        return ua=>ua.equals(ia)
                    }
                    );
                    u.test = 1 === N.length ? N[0] : P=>N.some(ia=>ia(P))
                }
                );
                return u=>{
                    try {
                        return Kb(G(u).expand())
                    } catch (N) {
                        if (N instanceof F && !N.Le) {
                            u.$e = N;
                            N.xsltLineNr || ra(N, h.C[0]);
                            let P;
                            P = N.code.match("^Q{") ? fa.QName.fromEQName(N.code) : fa.QName.fromParts("", "http://www.w3.org/2005/xqt-errors", N.code);
                            for (let ia = 0; ia < Q.length; ia++) {
                                const ua = Q[ia];
                                if (ua.test(P))
                                    return l(ua)(u)
                            }
                            throw N;
                        }
                        if (N instanceof F)
                            throw N;
                        Error.g && Error.g();
                        throw N;
                    }
                }
            },
            ufCall: function(h) {
                const G = (h.C || []).map(n);
                return Q=>{
                    const u = D(h, Q, "function")
                      , N = G.map(P=>P(Q).expand());
                    return y(h, u, N, Q)
                }
            },
            ufRef: function(h) {
                let G = h.name;
                G = /^[a-z]+:/.test(G) ? aa(h, G, !0) : /^Q\{/.test(G) ? fa.QName.fromEQName(G) : fa.QName.fromParts("", Zb.Oa, G);
                const Q = parseInt(h.arity, 10)
                  , u = Jd.find("SaxonJS").XPath;
                return N=>{
                    const P = u.getFnSignature(G, Q, N);
                    if (P && P.isUserFunction)
                        return N = new ad.Ff(P,N),
                        Pb(N);
                    sa.la("Named user function " + G + "#" + Q + " not found")
                }
            },
            union: function(h) {
                const G = l(h)
                  , Q = r(h);
                return u=>new Eb(G(u),Q(u),S.rb)
            },
            useAS: M,
            valueOf: M,
            varRef: function(h) {
                const G = parseInt(h.slot, 10);
                return Q=>Kb(Q.oa[G])
            },
            vc: function(h) {
                function G(ia) {
                    return null === ia ? null : fa.untypedAtomic.matches(ia) ? fa.string.R(ia) : ia
                }
                const Q = h.op
                  , u = h.onEmpty
                  , N = l(h)
                  , P = r(h);
                return ia=>{
                    const ua = N(ia)
                      , Ba = P(ia)
                      , Fa = G(ua.next())
                      , Pa = G(Ba.next());
                    if (null === Fa || null === Pa)
                        return u ? Xb("1" === u) : Ob;
                    if (null !== ua.next() || null !== Ba.next())
                        throw new F("Value comparison only applicable to single values","XPTY0004",h);
                    if (Fa.isNumeric() && isNaN(Fa.value) || Pa.isNumeric() && isNaN(Pa.value))
                        return Xb("ne" === Q);
                    ia = Hd.fe(h.comp, ia);
                    return ["=", "eq", "!=", "ne"].includes(Q) ? Xb(Hd.Th(Q, ia.equals(Fa, Pa))) : Xb(Hd.wf(Q, ia.compare(Fa, Pa)))
                }
            }
        };
        K.prototype = {
            value: null,
            containsKey: function(h) {
                return "undefined" !== typeof this.value[h]
            },
            get: function(h) {
                return ha(this.value[h])
            },
            inSituPut: function() {
                throw new F("inSituPut() not allowed for JSValue","SXJS0005");
            },
            put: function() {
                throw new F("put() not allowed for JSValue","SXJS0005");
            },
            remove: function() {
                throw new F("remove() not allowed for JSValue","SXJS0005");
            },
            keys: function() {
                throw new F("keys() not allowed for JSValue","SXJS0005");
            },
            forAllPairs: function() {
                throw new F("forEach() not allowed for JSValue","SXJS0005");
            },
            conforms: function() {
                throw new F("conforms() not allowed for JSValue","SXJS0005");
            },
            showValue: function() {
                return "JSValue " + sa.showValue(this.value)
            }
        };
        U.prototype = {
            value: null,
            showValue: function() {
                return "XDMValue " + sa.showValue(this.value)
            }
        };
        return {
            da: B,
            Ve: t,
            Sb: H,
            li: g,
            Ik: function() {
                return "ancestor ancestor-or-self attribute child descendant descendant-or-self following following-sibling namespace parent preceding preceding-sibling self preceding-or-ancestor".split(" ")
            },
            Tf: ea,
            qb: v,
            ti: la,
            Uf: x,
            sb: w,
            ke: I,
            ig: D,
            Fd: e,
            Sa: l,
            Vg: r,
            ib: n,
            escape: function(h, G) {
                let Q = "";
                Da(h).forEach(function(u) {
                    const N = Ea([u]);
                    Q += G(u, N) ? encodeURIComponent(N) : N
                });
                return Q
            },
            evaluate: R,
            qc: function(h, G) {
                return null === h ? Ob : R(h, G)
            },
            Ai: function(h, G, Q, u) {
                const N = ke[h.local];
                N || d(h.toString() + "()", u);
                return N(G.map(P=>Kb(P)), Q, u)
            },
            Bi: function(h, G, Q, u) {
                return na(h.uri, h.local, G.map(N=>Kb(N)), Q, u)
            },
            flatten: Z,
            hg: qa,
            Rk: function(h) {
                if ("undefined" !== typeof h)
                    return z(h, "module", 20) + "#" + z(h, "line", 10)
            },
            Db: W,
            Ic: ma,
            isArray: ja,
            isMap: Y,
            Jd: V,
            vh: function(h) {
                return h instanceof me
            },
            hj: E,
            Ef: K,
            fl: d,
            Ej: q,
            Aj: function(h) {
                na = h
            },
            pl: ca,
            Ia: A,
            xd: T,
            sg: aa,
            Wd: L,
            Xh: function(h) {
                return "AZ" === h.code ? fa.double.R(h) : h
            },
            Oj: C,
            Ra: ha,
            Hk: U
        }
    }();
    // Input 40
    abstractNode = Node;
    HostPlatform = function() {
        function a() {
            Math.trunc = Math.trunc || function(H) {
                return 0 > H ? Math.ceil(H) : Math.floor(H)
            }
            ;
            Array.prototype.findIndex || Object.defineProperty(Array.prototype, "findIndex", {
                value: function(H, p) {
                    if (null === this || "undefined" == typeof this)
                        throw new TypeError("Array.prototype.findIndex called on null or undefined");
                    if ("function" !== typeof H)
                        throw new TypeError("predicate must be a function");
                    let g = Object(this), e = g.length >>> 0, k;
                    for (let v = 0; v < e; v++)
                        if (k = g[v],
                        H.call(p, k, v, g))
                            return v;
                    return -1
                },
                enumerable: !1,
                configurable: !1,
                writable: !1
            });
            Array.prototype.includes || Object.defineProperty(Array.prototype, "includes", {
                value: function(H) {
                    if (null === this || "undefined" == typeof this)
                        throw new TypeError("Array.prototype.includes called on null or undefined");
                    return this.findIndex(p=>p === H)
                }
            });
            String.prototype.includes || (String.prototype.includes = function(H, p) {
                "number" !== typeof p && (p = 0);
                return p + H.length > this.length ? !1 : -1 !== this.indexOf(H, p)
            }
            )
        }
        let c = Resources, q;
        const E = {
            name: "Browser",
            init: function() {
                a()
            },
            inBrowser: function() {
                return !0
            },
            expose: function(H, p) {
                window[p] = H;
                try {
                    module.exports = H
                } catch (g) {}
            },
            getPromise: function(H, p, g, e) {
                return new Promise(function(k, v) {
                    let t = new XMLHttpRequest;
                    if (g || e)
                        g ? ("text" === g ? g = "text/plain" : "json" === g ? g = "application/json" : "xml" === g && (g = "application/xml"),
                        e && (g = g + ";charset=" + e),
                        t.overrideMimeType(g)) : console.log("Error: cannot specify encoding without a resource type");
                    t.open("GET", H);
                    for (let C in p)
                        p.hasOwnProperty(C) && t.setRequestHeader(C, p[C]);
                    t.onload = function() {
                        200 <= this.status && 300 > this.status ? k({
                            responseText: t.responseText,
                            contentType: t.getResponseHeader("Content-Type")
                        }) : v(new F(t.statusText + ": " + H,"SXJS0006"))
                    }
                    ;
                    t.onerror = function() {
                        v(new F("Document fetch failed: " + H,"SXJS0006"))
                    }
                    ;
                    t.send(null)
                }
                )
            },
            asyncGet: function(H, p, g) {
                let e = new XMLHttpRequest;
                e.open("GET", H, !0);
                e.setRequestHeader("Accept", "application/xml, text/xml;q=0.9, application/xhtml+xml;q=0.8, */*;q=0.7");
                0 !== g && (e.timeout = g);
                e.onload = function() {
                    4 === e.readyState && (200 === e.status ? p({
                        responseText: e.responseText,
                        contentType: e.getResponseHeader("Content-Type")
                    }) : p(new F(e.statusText + ": " + H,"SXJS0006")))
                }
                ;
                e.ontimeout = function() {
                    p(new F("Document fetch timeout: " + H,"SXJS0008"))
                }
                ;
                e.onabort = function() {
                    p(new F("Document fetch aborted: " + H,"SXJS0008"))
                }
                ;
                e.onerror = function() {
                    p(new F("Document fetch failed: " + H,"SXJS0006"))
                }
                ;
                e.send(null);
                return e
            },
            addDoc: function(H, p, g, e, k) {
                function v(t) {
                    sa.Ma("Add to response pool " + H, 2, k);
                    g[H] = t;
                    p(g)
                }
                if (!g[H] || g[H]instanceof F)
                    return E.asyncGet(H, v, e);
                sa.Ma("Doc already in pool " + H, 2, k);
                p(g);
                return null
            },
            addMultipleDocs: function(H, p, g, e, k) {
                function v(m) {
                    0 >= --t && g(m)
                }
                let t = H.length
                  , C = {};
                for (let m = 0; m < H.length; m++)
                    H[m] ? C[H[m]] = E.addDoc(H[m], v, p, e, k) : t--;
                return C
            },
            makeHttpRequest: function(H, p, g, e) {
                function k(f) {
                    if (f instanceof DocumentFragment) {
                        let A = document.implementation.createDocument("", "", null);
                        f = A.importNode(f, !0);
                        A.appendChild(f);
                        f = A
                    }
                    return f
                }
                function v(f, A) {
                    return function(O) {
                        m.status = 0;
                        m.message = f + ": " + t.href;
                        m.error = A;
                        m.type = O.type;
                        p(cd.xd(cd.Ra(m)))
                    }
                }
                let t = cd.sb(H, !0);
                (function(f) {
                    function A(b) {
                        throw new F(b + " in HTTP request to: " + f.href,"SXJS0006");
                    }
                    if (!f.href)
                        throw new F("'href' must be specified in HTTP request","SXJS0006");
                    f.method || A("'method' must be specified");
                    f.method = f.method.toUpperCase();
                    "status-only"in f && "boolean" !== typeof f["status-only"] && A("'status-only' parameter must be of type xs:boolean");
                    f.ji = "GET" != f.method && "HEAD" != f.method;
                    f.gf = "body"in f || "multipart-bodies"in f;
                    ("multipart-bodies"in f || "multipart-headers"in f) && A("Multipart requests not yet implemented");
                    !f.ji && f.gf && A("Body and multipart body content must be null for " + f.method + " request");
                    "headers"in f || (f.headers = {});
                    const O = f["media-type"] || f.headers["content-type"] || "";
                    f.gf && "" === O && A("No content type specified");
                    f.gf && "media-type"in f && (f.headers["content-type"] = O);
                    "multipart-bodies"in f && !/$multipart\//.test(O) && A("Content type must be multipart media type for multipart request");
                    ("username"in f && !("password"in f) || !("username"in f) && "password"in f) && A("Must set both (or neither) username and password");
                    f.body instanceof DocumentFragment && (f.body = k(f.body, O));
                    !f.gf || "text/xml" != O && "application/xml" != O && "text/xml-external-parsed-entity" != O && "application/xml-external-parsed-entity" != O && !/\+xml$/.test(O) && "text/html" != O || f.body instanceof Document || A("HTTP request body must be a document node, supplied item is: " + sa.showValue(f.body));
                    sa.Ma("HTTP request prepared", 2, e);
                    return f
                }
                )(t);
                "undefined" == typeof XMLHttpRequest && (XMLHttpRequest = function() {
                    return new ActiveXObject("Msxml2.XMLHTTP.6.0")
                }
                );
                let C = new XMLHttpRequest;
                "override-media-type"in t && C.overrideMimeType(t["override-media-type"]);
                "username"in t ? C.open(t.method, t.href, !0, t.username, t.password) : C.open(t.method, t.href, !0);
                "timeout"in t && 0 === g && (g = t.timeout);
                0 !== g && (C.timeout = g);
                for (let f in t.headers)
                    t.headers.hasOwnProperty(f) && C.setRequestHeader(f, t.headers[f]);
                t.body && 9 === t.body.nodeType && (t.body = ge.serialize(t.body));
                let m = {};
                C.ontimeout = v("HTTP request timeout", "SXJS0008");
                C.onabort = v("HTTP request aborted", "SXJS0008");
                C.onerror = v("HTTP request failed", "SXJS0009");
                C.onload = function(f) {
                    sa.Ma("SaxonJS processing httpRequest response", 2, e);
                    m.headers = {};
                    m.status = C.status;
                    m.message = C.statusText;
                    m.type = f.type;
                    if (!t["status-only"] && "HEAD" !== t.method) {
                        f = (C.getResponseHeader("Content-Type") || "").split(/;/)[0];
                        f = t["override-media-type"] || f;
                        m["media-type"] = f;
                        const A = E.parseXmlFromString;
                        switch (f) {
                        case "text/xml":
                        case "application/xml":
                        case "text/xml-external-parsed-entity":
                        case "application/xml-external-parsed-entity":
                            m.body = C.responseXML || A(C.responseText);
                            m.body._saxonBaseUri = t.href;
                            m.body._saxonDocUri = t.href;
                            break;
                        case "text/html":
                            m.body = C.responseXML || A(C.responseText, !1, f);
                            m.body._saxonBaseUri = t.href;
                            m.body._saxonDocUri = t.href;
                            break;
                        default:
                            /\+xml$/.test(f) ? (m.body = C.responseXML || A(C.responseText),
                            m.body._saxonBaseUri = t.href,
                            m.body._saxonDocUri = t.href) : m.body = C.responseText
                        }
                    }
                    (function(A, O) {
                        O = O.getAllResponseHeaders();
                        "" !== O && O.split(/\r\n/).forEach(function(b) {
                            if ("" !== b.trim()) {
                                const d = b.indexOf(":");
                                0 <= d ? A.headers[b.substring(0, d).toLowerCase()] = b.substring(d + 1).trim() : sa.Ma("No ':' separator found in HTTP response header " + b, 2, e)
                            }
                        })
                    }
                    )(m, C);
                    p(cd.xd(cd.Ra(m)))
                }
                ;
                C.send(t.body);
                return C
            },
            parseXmlFromString: function(H, p, g) {
                H = H.replace(/\r\n|\r(?!\n)/g, "\n");
                g ||= "application/xml";
                try {
                    const k = (new DOMParser).parseFromString(H, g);
                    if (0 === k.getElementsByTagName("parsererror").length)
                        var e = !1;
                    else {
                        if (!q)
                            try {
                                q = (new DOMParser).parseFromString("<", "text/xml").getElementsByTagName("parsererror")[0].namespaceURI
                            } catch (v) {}
                        e = 0 < k.getElementsByTagNameNS(q, "parsererror").length
                    }
                    if (e)
                        throw Error(k.getElementsByTagNameNS(q, "parsererror")[0].textContent);
                    return k
                } catch (k) {
                    throw new F("Misplaced or malformed markup" + (k.message ? ": " + k.message : ""),"FODC0002");
                }
            },
            resource: function(H) {
                return c[H]
            },
            readFile: function(H, p=!1) {
                let g = new XMLHttpRequest, e;
                try {
                    g.open("GET", H, !1),
                    g.setRequestHeader("Accept", "application/xml, text/xml;q=0.9, application/xhtml+xml;q=0.8, */*;q=0.7"),
                    g.send(null)
                } catch (k) {
                    throw new F("Get failure " + H,"FODC0002");
                }
                if (200 === g.status)
                    p ? e = {
                        responseText: g.responseText,
                        contentType: g.getResponseHeader("Content-Type")
                    } : e = g.responseText;
                else
                    throw new F("Failed to read file at " + H,"FODC0002");
                return e
            },
            resourcePromise: function(H) {
                let p, g = "file";
                if (H.file)
                    p = Promise.reject(new F("File access not supported in browser (" + H.file + ")","SXJS0006"));
                else if (H.location) {
                    let e = H.location
                      , k = H.headers
                      , v = e;
                    e instanceof URL ? e = e.toString() : v = new URL(e);
                    g = e;
                    "file:" === v.protocol ? p = Promise.reject(new F("File access not supported in browser (" + v + ")","SXJS0006")) : p = E.getPromise(e, k, H.type, H.encoding).then(t=>t.responseText)
                }
                return p.catch(e=>Promise.reject(new F("Failed to read " + g + "(" + e.message + ")","SXJS0006"))).then(e=>{
                    65279 === e.codePointAt(0) && (e = e.substring(1));
                    return Promise.resolve(e)
                }
                )
            },
            resolveUri: function(H, p) {
                try {
                    return (p && null !== p && "" !== p ? H && "" !== H ? new URL(H,p) : new URL(p) : new URL(H)).toString()
                } catch (g) {
                    throw new F("Failed URI resolution: href=" + H + " base=" + p + " -- " + g,"FODC0005");
                }
            },
            baseURL: function() {
                return window.document.baseURI
            },
            getDefaultDeliverMessage: function() {
                return function(H) {
                    let p = "";
                    cd.Sb(H).expand().forEach(function(g) {
                        p += ("" === p ? "" : " ") + g.toString()
                    });
                    console.log("xsl:message: " + p)
                }
            },
            isHTMLElement: function(H) {
                return "http://www.w3.org/1999/xhtml" === H.namespaceURI
            },
            saxonPrint: function(H) {
                console.log(H)
            },
            createDocument: function() {
                return document.implementation.createDocument("", "", null)
            },
            setDocURI: function(H, p) {
                H._saxonBaseUri = p;
                return H
            },
            newURL: function(H, p=null) {
                return null !== p ? new URL(H,p) : new URL(H)
            },
            extraProperties: {
                platform: "Browser"
            },
            toUTF8: function(H) {
                return (new TextEncoder).encode(H)
            },
            fromUTF8: function(H) {
                return (new TextDecoder).decode(H)
            },
            globalObject: window
        };
        return E
    }();
    // Input 41
    // Input 42
    // Input 43
    function ed(a) {
        return ee(a) ? null : a.focus.current
    }
    function fd(a, c, q, E=null) {
        if (ee(a))
            throw new F("Focus for " + q + " is absent",c,E);
    }
    function gd(a) {
        a.ad = null;
        a.bd = null;
        a.Bb = null
    }
    function ee(a) {
        return !a.focus || !a.focus.current
    }
    class ne {
        constructor() {
            this.depth = 0;
            this.masterDocument = this.j = this.ja = this.sa = this.focus = null;
            this.qa = !1;
            this.ub = [];
            this.fixed = {
                yd: null,
                zd: [],
                Ta: null
            };
            this.Kc = new cc;
            this.Qb = new cc;
            this.ab = null;
            this.gb = {};
            this.Bb = this.bd = this.ad = this.ie = this.$e = null;
            this.Mb = [];
            this.Ge = null;
            this.oa = [];
            this.uc = {};
            this.g = null
        }
        toString() {
            let a = "{";
            this.Kc.forAllPairs(c=>a += c.k + ":(" + c.v + "),");
            a += "}";
            return "context: " + ed(this) + " localParams: " + a
        }
        ba(a) {
            const c = new ne;
            c.depth = this.depth + 1;
            c.focus = this.focus;
            c.sa = this.sa;
            c.ja = this.ja;
            c.masterDocument = this.masterDocument;
            c.gb = this.gb;
            c.ab = this.ab;
            c.$e = this.$e;
            c.ad = this.ad;
            c.Mb = this.Mb;
            c.bd = this.bd;
            c.fixed = this.fixed;
            c.qa = this.qa;
            c.ub = this.ub;
            c.ie = this.ie;
            c.Ge = this.Ge;
            c.uc = this.uc;
            c.g = this;
            a ? (c.Kc = new cc,
            c.Qb = new cc,
            c.oa = [],
            c.Bb = null) : (c.Kc = this.Kc,
            c.Qb = this.Qb,
            c.oa = this.oa,
            c.Bb = this.Bb);
            return c
        }
        createElement(a, c) {
            const q = ac.Gc(this.ja)
              , E = q.documentElement;
            "" === a && E && pa.Zb(E) ? c = q.createElement(c) : "http://www.w3.org/1999/xhtml" === a && E && pa.Zb(E) ? (a = c.indexOf(":"),
            c = q.createElement(-1 === a ? c : c.substring(a + 1))) : c = q.createElementNS(a, c);
            return c
        }
        getStackTrace() {
            let a = "";
            ee(this) || (a = "    Processing " + sa.showValue(this.focus.current) + "\n");
            try {
                let c = this.sa.actor, q;
                "mode" === c.N ? (q = "template rule",
                c = this.ab.action) : q = c.N + " " + c.name;
                a += "    at " + q + " in " + cd.hg(c, "module") + "#" + cd.hg(c, "line")
            } catch (c) {
                a = ""
            }
            this.g && (a += "\n" + this.g.getStackTrace());
            return a
        }
    }
    ;// Input 44
    var oe = {}
      , pe = {};
    oe[0] = "<eof>";
    oe[1] = "|";
    oe[2] = "/";
    oe[3] = "@";
    oe[48] = "~";
    oe[4] = "[";
    oe[5] = "(";
    oe[6] = "=";
    oe[7] = ",";
    oe[8] = "//";
    oe[9] = "or";
    oe[10] = "and";
    oe[11] = ">";
    oe[12] = "<";
    oe[13] = ">=";
    oe[14] = "<=";
    oe[15] = "+";
    oe[16] = "-";
    oe[299] = "-";
    oe[17] = "*";
    oe[18] = "div";
    oe[19] = "mod";
    oe[20] = "is";
    oe[21] = "$";
    oe[22] = "!=";
    oe[40] = "!";
    oe[30] = "||";
    oe[23] = "intersect";
    oe[24] = "except";
    oe[25] = "return";
    oe[26] = "then";
    oe[27] = "else";
    oe[29] = "to";
    oe[31] = "in";
    oe[32] = "some";
    oe[33] = "every";
    oe[34] = "satisfies";
    oe[35] = "<function>(";
    oe[36] = "<axis>";
    oe[37] = "if(";
    oe[38] = "<<";
    oe[39] = ">>";
    oe[41] = "::";
    oe[42] = ":*";
    oe[44] = "#";
    oe[45] = "instance of";
    oe[46] = "cast as";
    oe[47] = "treat as";
    oe[50] = "eq";
    oe[51] = "ne";
    oe[52] = "gt";
    oe[54] = "ge";
    oe[53] = "lt";
    oe[55] = "le";
    oe[56] = "idiv";
    oe[57] = "castable as";
    oe[58] = ":=";
    oe[71] = "as";
    oe[75] = ":";
    oe[76] = "=>";
    oe[79] = "otherwise";
    oe[80] = "andAlso";
    oe[81] = "orElse";
    oe[201] = "<name>";
    oe[202] = "<string-literal>";
    oe[203] = "]";
    oe[204] = ")";
    oe[205] = ".";
    oe[206] = "..";
    oe[207] = "*";
    oe[208] = "<prefix:*>";
    oe[209] = "<numeric-literal>";
    oe[69] = "<node-type>()";
    oe[211] = "for";
    oe[70] = "<*:local-name>";
    oe[213] = "?";
    oe[59] = "{";
    oe[60] = "<keyword> {";
    oe[215] = "}";
    oe[216] = "let";
    oe[299] = "-";
    function qe(a, c) {
        pe[a] = c;
        oe[c] = a
    }
    qe("instance of", 45);
    qe("cast as", 46);
    qe("treat as", 47);
    qe("castable as", 57);
    // Input 45
    var re = {
        Nk: function() {
            return null
        }
    };
    for (const a in Zb)
        re[a.toUpperCase()] = Zb[a];
    re.sk = Zb.lc;
    re.ci = Zb.Wc;
    function se(a) {
        a = a.charCodeAt(0);
        return 65 <= a && 90 >= a || 97 <= a && 122 >= a
    }
    var te = Ha.Lb;
    function ue(a) {
        const c = a.charCodeAt(0);
        return se(a) || 48 <= c && 57 >= c
    }
    function ve(a, c="XPST0003") {
        return new F(a,c)
    }
    function we(a="Illegal Argument") {
        return new F(a,"XPST0003")
    }
    ;// Input 46
    function xe(a, c) {
        a.xa = c;
        0 === c ? (a.V = -1,
        a.ta = "",
        a.J = -1) : c === ye && (a.V = 204,
        a.ta = ")",
        a.J = 204)
    }
    function ze(a) {
        a.V = a.j;
        a.ta = a.K;
        a.K = null;
        for (a.aa = a.g; ; ) {
            if (a.g >= a.I) {
                a.j = 0;
                break
            }
            var c = a.B.charAt(a.g++);
            switch (c) {
            case "/":
                if (a.g < a.I && "/" === a.B.charAt(a.g)) {
                    a.g++;
                    a.j = 8;
                    return
                }
                a.j = 2;
                return;
            case ":":
                if (a.g < a.I) {
                    ":" === a.B.charAt(a.g) ? (a.g++,
                    a.j = 41) : "=" === a.B.charAt(a.g) ? (a.j = 58,
                    a.g++) : a.j = 75;
                    return
                }
                throw new ve("Unexpected colon at start of token");
            case "@":
                a.j = 3;
                return;
            case "~":
                a.j = 48;
                return;
            case "?":
                a.j = 213;
                return;
            case "[":
                a.j = 4;
                return;
            case "]":
                a.j = 203;
                return;
            case "{":
                a.j = 59;
                return;
            case "}":
                a.j = 215;
                return;
            case "(":
                if (a.g < a.I && ":" === a.B.charAt(a.g)) {
                    a.g++;
                    for (c = 1; 0 < c && a.g < a.I - 1; )
                        "\n" === a.B.charAt(a.g) ? Ae(a) : ":" === a.B.charAt(a.g) && ")" === a.B.charAt(a.g + 1) ? (c--,
                        a.g++) : "(" === a.B.charAt(a.g) && ":" === a.B.charAt(a.g + 1) && (c++,
                        a.g++),
                        a.g++;
                    if (0 < c)
                        throw new ve("Unclosed XPath comment");
                    ze(a)
                } else
                    a.j = 5;
                return;
            case ")":
                a.j = 204;
                return;
            case "+":
                a.j = 15;
                return;
            case "-":
                a.j = 16;
                return;
            case "=":
                if (a.g < a.I && ">" === a.B.charAt(a.g)) {
                    a.g++;
                    a.j = 76;
                    return
                }
                a.j = 6;
                return;
            case "!":
                if (a.g < a.I && "=" === a.B.charAt(a.g)) {
                    a.g++;
                    a.j = 22;
                    return
                }
                a.j = 40;
                return;
            case "*":
                (c = a.g < a.I && ":" === a.B.charAt(a.g) && a.g + 1 < a.I) && !(c = 127 < a.B.charAt(a.g + 1)) && (c = a.B.charAt(a.g + 1),
                c = se(c) || "_" === c);
                if (c) {
                    a.g++;
                    a.j = 70;
                    return
                }
                a.j = 207;
                return;
            case ",":
                a.j = 7;
                return;
            case "$":
                a.j = 21;
                return;
            case "|":
                if (a.g < a.I && "|" === a.B.charAt(a.g)) {
                    a.g++;
                    a.j = 30;
                    return
                }
                a.j = 1;
                return;
            case "#":
                a.j = 44;
                return;
            case "<":
                if (a.g < a.I && "=" === a.B.charAt(a.g)) {
                    a.g++;
                    a.j = 14;
                    return
                }
                if (a.g < a.I && "<" === a.B.charAt(a.g)) {
                    a.g++;
                    a.j = 38;
                    return
                }
                a.j = 12;
                return;
            case ">":
                if (a.g < a.I && "=" === a.B.charAt(a.g)) {
                    a.g++;
                    a.j = 13;
                    return
                }
                if (a.g < a.I && ">" === a.B.charAt(a.g)) {
                    a.g++;
                    a.j = 39;
                    return
                }
                a.j = 11;
                return;
            case ".":
                if (a.g < a.I) {
                    var q = a.B.charAt(a.g);
                    if ("." === q) {
                        a.g++;
                        a.j = 206;
                        return
                    }
                    if ("{" === q) {
                        a.g++;
                        a.K = ".";
                        a.j = 60;
                        return
                    }
                }
                if (a.g === a.I || "0" > a.B.charAt(a.g) || "9" < a.B.charAt(a.g)) {
                    a.j = 205;
                    return
                }
            case "0":
            case "1":
            case "2":
            case "3":
            case "4":
            case "5":
            case "6":
            case "7":
            case "8":
            case "9":
                q = !0;
                var E = !1
                  , H = !0;
                a: for (; ; ) {
                    switch (c) {
                    case "0":
                    case "1":
                    case "2":
                    case "3":
                    case "4":
                    case "5":
                    case "6":
                    case "7":
                    case "8":
                    case "9":
                        E = !1;
                        break;
                    case ".":
                        if (H)
                            E = H = !1;
                        else {
                            a.g--;
                            break a
                        }
                        break;
                    case "E":
                    case "e":
                        if (q)
                            E = !0,
                            q = !1;
                        else {
                            a.g--;
                            break a
                        }
                        break;
                    case "+":
                    case "-":
                        if (E)
                            E = !1;
                        else {
                            a.g--;
                            break a
                        }
                        break;
                    default:
                        if ("a" <= c && "z" >= c || 127 < c)
                            throw new ve("Separator needed after numeric literal" + Be(a, a.g));
                        a.g--;
                        break a
                    }
                    if (a.g >= a.I)
                        break;
                    c = a.B.charAt(a.g++)
                }
                a.K = a.B.substring(a.aa, a.g);
                a.j = 209;
                return;
            case '"':
            case "'":
                for (a.K = ""; ; ) {
                    a.g = a.B.indexOf(c, a.g);
                    if (0 > a.g)
                        throw a.g = a.aa + 1,
                        new ve("Unmatched quote in expression");
                    a.K += a.B.substring(a.aa + 1, a.g++);
                    if (a.g < a.I)
                        if (a.B.charAt(a.g) === c)
                            a.K += c,
                            a.aa = a.g,
                            a.g++;
                        else
                            break;
                    else
                        break
                }
                if (0 <= a.K.indexOf("\n"))
                    for (c = 0; c < a.K.length; c++)
                        "\n" === a.K.charAt(c) && Ae(a, a.aa + c + 1);
                a.j = 202;
                return;
            case "\n":
                Ae(a, a.g);
            case " ":
            case "\t":
            case "\r":
                a.aa = a.g;
                break;
            case "\u00b6":
            case "Q":
                if (a.g < a.I && "{" === a.B.charAt(a.g)) {
                    q = a.B.indexOf("}", a.g++);
                    if (q < a.g)
                        throw new ve("Missing closing brace in EQName");
                    c = a.B.substring(a.g, q);
                    c = Ha.collapse(c);
                    if (c.includes("{"))
                        throw new ve("EQName must not contain opening brace");
                    a.g = q + 1;
                    q = a.g;
                    for (E = !1; a.g < a.I; )
                        if (H = a.B.charAt(a.g),
                        128 < H || ue(H) || "_" === H || "." === H || "-" === H)
                            a.g++;
                        else {
                            "*" === H && q === a.g && (a.g++,
                            E = !0);
                            break
                        }
                    a.K = "Q{" + c + "}" + a.B.substring(q, a.g);
                    a.j = E ? 208 : 201;
                    return
                }
            default:
                if (128 > c.charCodeAt(0) && !se(c))
                    throw new ve("Invalid character '" + c + "' in expression");
            case "_":
                q = !1;
                a: for (; a.g < a.I; a.g++)
                    switch (c = a.B.charAt(a.g),
                    c) {
                    case ":":
                        if (q)
                            break a;
                        else {
                            if (213 === a.V || 70 === a.V) {
                                a.K = a.B.substring(a.aa, a.g);
                                a.j = 201;
                                return
                            }
                            if (a.g + 1 < a.I) {
                                c = a.B.charAt(a.g + 1);
                                if (":" === c) {
                                    a.K = a.B.substring(a.aa, a.g);
                                    a.j = 36;
                                    a.g += 2;
                                    return
                                }
                                if ("*" === c) {
                                    a.K = a.B.substring(a.aa, a.g);
                                    a.j = 208;
                                    a.g += 2;
                                    return
                                }
                                if (!("_" === c || 127 < c || se(c))) {
                                    a.K = a.B.substring(a.aa, a.g);
                                    a.j = 201;
                                    return
                                }
                            }
                            q = !0
                        }
                        break;
                    case ".":
                    case "-":
                        if (150 < a.V && 213 !== a.V && 70 !== a.V && -1 !== Ce(a.B.substring(a.aa, a.g)) && (201 !== a.V || -1 === Ce(a.ta))) {
                            a.j = Ce(a.B.substring(a.aa, a.g));
                            return
                        }
                    case "_":
                        break;
                    default:
                        if (128 > c.charCodeAt(0) && !ue(c))
                            break a
                    }
                a.K = a.B.substring(a.aa, a.g);
                a.j = 201;
                return
            }
        }
    }
    function De(a, c) {
        a.xa = 0;
        a.j = 0;
        a.K = null;
        a.aa = 0;
        a.g = 0;
        a.B = c;
        a.lineNumber = 0;
        a.Ca = 0;
        a.I = c.length;
        ze(a);
        a.next()
    }
    function Ce(a) {
        a = {
            or: 9,
            is: 20,
            to: 29,
            "in": 31,
            eq: 50,
            ne: 51,
            le: 55,
            lt: 53,
            gt: 52,
            ge: 54,
            as: 71,
            and: 10,
            div: 18,
            mod: 19,
            idiv: 56,
            then: 26,
            "else": 27,
            "case": 67,
            where: 28,
            union: 1,
            except: 24,
            "return": 25,
            otherwise: 79,
            orElse: 81,
            "default": 212,
            andAlso: 80,
            intersect: 23,
            satisfies: 34
        }[a];
        return [81, 80].includes(a) ? -1 : a || -1
    }
    function Ae(a, c=-1) {
        a.lineNumber++;
        a.Ca++;
        null === a.ra && (a.ra = []);
        a.ra.push(-1 === c ? a.g - 1 : c)
    }
    function Be(a, c=null) {
        var q = c ? c : a.g;
        return " at line:" + Ee(a, c) + " col:" + Fe(a, c) + " near '" + a.B.slice(5 > q ? 0 : q - 5, q + 5) + "'"
    }
    function Ge(a) {
        a.g > a.I && (a.g = a.I);
        return 34 > a.g ? a.B.substring(0, a.g) : Ha.collapse("..." + a.B.substring(a.g - 30, a.g)).toString()
    }
    function He(a, c) {
        if (null === a.ra)
            return c;
        for (var q = a.ra.length - 1; 0 <= q; q--) {
            var E = a.ra[q];
            if (c > E)
                return q + 1 << 16 | c - E
        }
        return c
    }
    function Ee(a, c=null) {
        return c ? He(a, c) >> 16 : a.lineNumber
    }
    function Fe(a, c=null) {
        return He(a, c ? c : a.je) & 32767
    }
    class Ie {
        constructor() {
            this.J = this.xa = 0;
            this.T = null;
            this.j = this.je = 0;
            this.K = null;
            this.aa = 0;
            this.B = null;
            this.I = this.g = 0;
            this.Ca = this.lineNumber = 1;
            this.ra = null;
            this.V = -1;
            this.ta = ""
        }
        next() {
            this.V = this.J;
            this.ta = this.T;
            this.J = this.j;
            this.T = this.K;
            null === this.T && (this.T = "");
            this.je = this.aa;
            this.lineNumber = this.Ca;
            switch (this.J) {
            case 201:
                var a = Ce(this.T);
                -1 === a || 150 >= this.V || 213 === this.V || (this.J = a);
                break;
            case 207:
                150 >= this.V || 213 === this.V || (this.J = 17)
            }
            if (215 !== this.J && (a = this.V,
            ze(this),
            201 === this.J && this.xa !== Je && 21 !== a))
                switch (this.j) {
                case 5:
                    var c = Ce(this.T);
                    -1 === c || 150 >= a ? (this.J = this.gg(this.T),
                    ze(this)) : this.J = c;
                    break;
                case 59:
                    this.xa !== Ke && (this.J = 60,
                    ze(this));
                    break;
                case 41:
                    ze(this);
                    this.J = 36;
                    break;
                case 44:
                    ze(this);
                    this.J = 43;
                    break;
                case 42:
                    ze(this);
                    this.J = 208;
                    break;
                case 21:
                    "for" === this.T ? this.J = 211 : "some" === this.T ? this.J = 32 : "every" === this.T ? this.J = 33 : "let" === this.T && (this.J = 216);
                    break;
                case 201:
                    a = this.T + " " + this.K,
                    c = pe[a],
                    null != c && (this.J = c,
                    this.T = a,
                    ze(this))
                }
        }
        gg(a) {
            const c = {
                "if": 37,
                array: 69,
                attribute: 69,
                comment: 69,
                "document-node": 69,
                element: 69,
                "empty-sequence": 69,
                "function": 69,
                map: 69,
                item: 69,
                "namespace-node": 69,
                node: 69,
                "processing-instruction": 69,
                "schema-attribute": 69,
                "schema-element": 69,
                "switch": 69,
                otherwise: 79,
                text: 69,
                tuple: 69,
                typeswitch: 69,
                union: 69
            }[a];
            return c ? ["tuple", "union"].includes(a) ? 35 : c : 35
        }
    }
    var Je = 1
      , Ke = 2
      , ye = 3;
    // Input 47
    var Le = [!1, !1, !0, !0, !0, !0, !0, !0, !0, !0, !1, !1, !0, !1];
    function Me(a) {
        return "ancestor ancestor-or-self attribute child descendant descendant-or-self following following-sibling namespace parent preceding preceding-sibling self preceding-or-ancestor".split(" ")[a]
    }
    var Ne = [1, 1, 2, 1, 1, 1, 1, 1, 13, 1, 1, 1, 1, 1]
      , Oe = [4, 5, 9, 9, 0, 1, 10, 11, 9, 3, 6, 7, 12];
    function Pe(a) {
        switch (a) {
        case "self":
            return 12;
        case "child":
            return 3;
        case "parent":
            return 9;
        case "ancestor":
            return 0;
        case "attribute":
            return 2;
        case "following":
            return 6;
        case "namespace":
            return 8;
        case "preceding":
            return 10;
        case "descendant":
            return 4;
        case "ancestor-or-self":
            return 1;
        case "following-sibling":
            return 7;
        case "preceding-sibling":
            return 11;
        case "descendant-or-self":
            return 5
        }
        throw new ve("Unknown axis name: " + a);
    }
    ;// Input 48
    function Qe(a, c, q, E="XPTY0004") {
        this.kind = a;
        this.j = c;
        this.g = q;
        this.errorCode = E
    }
    Qe.prototype = {
        Id: function() {
            return this.errorCode
        },
        save: function() {
            let a = this.kind + "|" + this.g + "|";
            a += ("XPTY0004" === this.errorCode ? "" : this.errorCode) + "|";
            return a += this.j
        }
    };
    // Input 49
    function Re(a, c, q={}) {
        a.start(c, q);
        c.end()
    }
    class Se {
        constructor() {
            this.l = dc.Aa
        }
        start(a, c={}) {
            a.start(this.O, c);
            this.role && a.ud("role", this.role);
            this.ag && a.ud("sType", this.l.ha())
        }
        $b() {
            return !Zc(this.l.fa)
        }
        G(a) {
            Re(this, a)
        }
    }
    oa = Se.prototype;
    oa.O = "Expression";
    oa.kind = null;
    oa.role = null;
    oa.ag = null;
    oa.Da = function(a, c="XPTY0004") {
        return new Qe(this.kind,this.O,a,c)
    }
    ;
    oa.Ga = function() {
        throw new ve(sa.Ij(this) + " is not a valid pattern","XTSE0340");
    }
    ;
    oa.Gd = function() {
        return this
    }
    ;
    class Te extends Se {
        constructor(a, c, q) {
            super();
            this.Va = c;
            this.ea = a;
            this.ga = q;
            if (this.ea.Wa || this.ga.Wa)
                this.Wa = !0;
            this.ea.Kb && this.ga.Kb && (this.Kb = !0)
        }
        G(a) {
            super.start(a, this.Va ? {
                op: oe[this.Va]
            } : {});
            this.ea.G(a);
            this.ga.G(a);
            a.end()
        }
    }
    Te.prototype.kind = 1;
    class Ue extends Se {
        constructor(a) {
            super();
            this.g = a;
            this.g.Wa && (this.Wa = !0);
            this.g.Kb && (this.Kb = !0)
        }
        G(a) {
            super.start(a);
            this.g.G(a);
            a.end()
        }
    }
    Ue.prototype.kind = 9;
    // Input 50
    class Ve extends Se {
        constructor() {
            super();
            this.l = dc.mc
        }
        Ga() {
            return this
        }
        G(a) {
            Re(this, a)
        }
    }
    class We extends Ve {
    }
    We.prototype.O = "p.any";
    class Xe extends Ve {
        constructor(a) {
            super();
            this.message = a;
            this.role = "match";
            this.l = dc.mc
        }
        G(a) {
            Re(this, a, {
                message: this.message
            })
        }
    }
    Xe.prototype.O = "p.warning";
    class Ye extends Ve {
        constructor(a) {
            super();
            this.g = a;
            this.l = dc.mc
        }
        G(a) {
            super.start(a);
            this.g.G(a);
            a.end()
        }
    }
    Ye.prototype.O = "p.booleanExp";
    class Ze extends Ve {
        constructor(a) {
            super();
            sa.assert(a instanceof lc);
            this.test = a;
            this.l = new gc(a,2)
        }
        G(a) {
            Re(this, a, {
                test: this.test.ha()
            })
        }
    }
    Ze.prototype.O = "p.nodeTest";
    class $e extends Ve {
        constructor(a, c) {
            super();
            this.pattern = a;
            this.g = c;
            this.l = a.l;
            a.code && (this.code = a.code)
        }
        G(a) {
            super.start(a);
            this.code && a.ud("code", this.code);
            this.pattern.G(a);
            this.g.G(a);
            a.end()
        }
    }
    $e.prototype.O = "p.withPredicate";
    class af extends Ve {
        constructor(a) {
            super();
            this.g = a;
            this.l = Vc(a.l, 2)
        }
        G(a) {
            super.start(a);
            this.g.G(a);
            a.end()
        }
    }
    af.prototype.O = "p.nodeSet";
    class bf extends Ve {
        constructor(a) {
            super();
            this.g = a;
            this.l = Vc(a.l, 2)
        }
        G(a) {
            super.start(a);
            this.g.G(a);
            a.end()
        }
    }
    bf.prototype.O = "p.genNode";
    class cf extends Ve {
        constructor(a, c) {
            super();
            this.g = c;
            this.code = a.l.ha();
            this.l = Vc(a.l, 2)
        }
        G(a) {
            super.start(a, {
                test: this.code
            });
            this.g.G(a);
            a.end()
        }
    }
    cf.prototype.O = "p.genPos";
    class df extends Ve {
        constructor(a, c) {
            super();
            this.code = a.ha();
            this.Od = c;
            this.l = Vc(a, 2)
        }
        G(a) {
            Re(this, a, {
                test: this.code,
                pos: this.Od
            })
        }
    }
    df.prototype.O = "p.simPos";
    class ef extends Ve {
        constructor(a, c, q) {
            super();
            this.axis = Oe[a];
            this.lb = c;
            this.g = q;
            this.l = c.l
        }
        G(a) {
            super.start(a, {
                axis: Me(this.axis)
            });
            this.lb.G(a);
            this.g.G(a);
            a.end()
        }
    }
    ef.prototype.O = "p.withUpper";
    class ff extends Ve {
        constructor(a, c, q, E) {
            super();
            this.Va = c;
            this.ea = a;
            this.ga = q;
            this.l = Vc(E, 2)
        }
        G(a) {
            super.start(a, {
                op: 1 === this.Va ? "union" : oe[this.Va]
            });
            this.ea.G(a);
            this.ga.G(a);
            a.end()
        }
    }
    ff.prototype.O = "p.venn";
    function gf(a) {
        var c = [];
        a.ea instanceof hf ? c = gf(a.ea) : c.push(a.ea);
        a.ga instanceof hf ? c = c.concat(gf(a.ga)) : c.push(a.ga);
        return c
    }
    class hf extends ff {
        constructor(a, c, q) {
            super(a, 1, c, q)
        }
    }
    class jf extends Ve {
        constructor(a) {
            super();
            this.g = a;
            for (var c of this.g)
                c.ag = !0
        }
        G(a) {
            super.start(a);
            for (var c of this.g)
                c.G(a);
            a.end()
        }
    }
    jf.prototype.O = "UnionExprP";
    // Input 51
    function kf(a) {
        return a instanceof lf && 1 === a.value.length && uc.ia()(a.value[0])
    }
    function mf(a, c) {
        return new lf(a,c)
    }
    function nf() {
        return new lf([],dc.Ie)
    }
    class lf extends Se {
        constructor(a, c) {
            super();
            Array.isArray(a) || sa.la("Literal value must be array");
            c instanceof gc && c.U.ha || sa.la("Literal type must be a SequenceType");
            a && (this.value = a,
            c && (this.l = c));
            this.role = null
        }
        toString() {
            return this.value.toString()
        }
        G(a) {
            function c(q, E) {
                const H = q.code
                  , p = {};
                switch (H) {
                case "AB":
                    break;
                case "AQ":
                    p.pre = q.prefix;
                    p.uri = q.uri;
                    p.loc = q.local;
                    break;
                default:
                    p.val = q.toString()
                }
                E && (p.role = E);
                switch (H) {
                case "AS":
                    a.start("str", p);
                    break;
                case "AO":
                    a.start("dbl", p);
                    break;
                case "AB":
                    a.start(q.value ? "true" : "false", p);
                    break;
                case "AD":
                    a.start("dec", p);
                    break;
                case "ADI":
                    a.start("int", p);
                    break;
                case "AQ":
                    a.start("qName", p);
                    break;
                default:
                    p.type = H,
                    a.start("atomic", p)
                }
                a.end()
            }
            if (0 === this.value.length)
                a.start("empty", this.role ? {
                    role: this.role
                } : {}),
                a.end();
            else if (1 === this.value.length)
                c(this.value[0], this.role);
            else {
                let q = {
                    count: this.value.length
                };
                this.role && (q.role = this.role);
                a.start("atomic", q);
                for (const E of this.value)
                    c(E);
                a.end()
            }
        }
    }
    lf.prototype.O = "literal";
    lf.prototype.Kb = !0;
    class of extends lf {
        constructor(a) {
            super([La.XS.string.fromString(a)], dc.ec);
            this.l = dc.ec
        }
    }
    ;// Input 52
    function pf(a, c, q, E, H) {
        var p = qf(a, dc.dc, a.Da(0, "XPTY0004"));
        p = new rf(p);
        if (/[lu]/.test(c))
            p.td = {
                flags: c + (H ? "e" : ""),
                as: q.toEQName()
            };
        else {
            sa.assert("a" === c);
            try {
                if (a instanceof lf && 1 === a.value.length && La.pa(a.value[0]) && "AQ" !== E.$().p) {
                    const g = E.Vc.R(a.value[0]);
                    return new lf([g],new gc(E,2))
                }
            } catch (g) {}
            p.td = {
                flags: H ? "ae" : "a",
                as: E.ha()
            }
        }
        return p
    }
    class rf extends Ue {
        constructor(a) {
            super(a);
            this.O = "cast";
            this.kind = 2;
            this.td = {}
        }
        G(a) {
            super.start(a, this.td);
            this.g.G(a);
            a.end()
        }
    }
    function sf(a, c, q, E, H) {
        var p = new tf(a);
        p = qf(p, dc.dc, p.Da(0, "XPTY0004"));
        if (/[lu]/.test(c))
            p.td = {
                flags: c + (H ? "e" : ""),
                as: q.toEQName()
            };
        else {
            sa.assert("a" === c);
            if (a instanceof lf && 1 === a.value.length && La.pa(a.value[0]) && "AQ" !== E.$().p)
                try {
                    return E.Vc.R(a.value[0]),
                    new lf([La.XS.boolean.Xc],dc.cb)
                } catch (g) {
                    return new lf([La.XS.boolean.ae],dc.cb)
                }
            p.td = {
                flags: H ? "ae" : "a",
                as: E.ha()
            }
        }
        return p
    }
    class tf extends Ue {
        constructor(a) {
            super(a);
            this.l = dc.cb;
            this.O = "castable";
            this.kind = 2;
            this.td = {}
        }
        G(a) {
            super.start(a, this.td);
            this.g.G(a);
            a.end()
        }
    }
    class uf extends Ue {
        constructor(a, c) {
            super(a);
            this.j = c;
            this.l = jd(a.l.U) ? dc.Jg : dc.Ad
        }
        G(a) {
            super.start(a, {
                diag: this.j
            });
            this.g.G(a);
            a.end()
        }
    }
    uf.prototype.O = "data";
    class vf extends uf {
        constructor(a, c, q) {
            super(a, c);
            this.B = q;
            jd(a.l.U) ? this.l = q ? dc.If : dc.Ig : this.l = q ? dc.dc : dc.Oe
        }
        G(a) {
            super.start(a, {
                diag: this.j
            });
            this.B && a.ud("card", "?");
            this.g.G(a);
            a.end()
        }
    }
    vf.prototype.O = "atomSing";
    class wf extends Se {
        constructor(a) {
            super();
            this.name = a.U.name.toEQName();
            this.l = dc.If
        }
        G(a) {
            Re(this, a, {
                name: this.name
            })
        }
    }
    wf.prototype.O = "attVal";
    class xf extends Ue {
        constructor(a, c, q) {
            super(a);
            this.code = c;
            this.j = q;
            this.l = dc.Ad
        }
        G(a) {
            super.start(a, {
                to: this.code,
                diag: this.j
            });
            this.g.G(a);
            a.end()
        }
    }
    xf.prototype.O = "cvUntyped";
    class yf extends Ue {
        constructor(a, c) {
            super(a);
            this.type = c;
            this.flags = "";
            this.l = new gc(c.U,a.l.fa)
        }
        G(a) {
            super.start(a, {
                to: this.type.ha().replace(/^[01?*+]/, ""),
                flags: this.flags
            });
            this.g.G(a);
            a.end()
        }
    }
    yf.prototype.O = "convert";
    class zf extends Ue {
        constructor(a, c, q) {
            super(a);
            this.type = c;
            this.resultType = a.resultType;
            this.j = q;
            this.l = c
        }
        G(a) {
            super.start(a, {
                to: this.type.ha().replace(/^[01?*+]/, ""),
                diag: this.j
            });
            this.g.G(a);
            a.end()
        }
    }
    zf.prototype.O = "fnCoercer";
    // Input 53
    const Af = "array attribute comment document-node element empty-sequence function if item map namespace-node node processing-instruction schema-attribute schema-element switch text typeswitch".split(" ");
    class Bf {
        constructor(a, c) {
            if ("" === a.prefix && Af.includes(a.local))
                throw new ve("The unprefixed function name '" + a.local + "' is reserved","XPST0003");
            this.name = a;
            this.arity = c
        }
        toEQName() {
            return this.name.toEQName()
        }
        toString() {
            return this.name.toEQName() + "#" + this.arity
        }
    }
    ;// Input 54
    class Cf extends Se {
        constructor(a, c, q) {
            super();
            const E = a.name.local;
            if (a.name.uri === Zb.lc) {
                if ("NOTATION" === E)
                    throw new F("No constructor function exists for xs:NOTATION","XPST0017");
                const p = c[0].l;
                if (2 === p.fa && p.U.pa() && p.U.Vc && E === p.U.Vc.name)
                    a = c[0];
                else if (["NMTOKENS", "ENTITIES", "IDREFS"].includes(E))
                    a = pf(c[0], "l", a.name, null, !0);
                else {
                    var H;
                    "numeric" === E ? H = pf(c[0], "u", a.name, null, !0) : H = pf(c[0], "a", null, q.U, !0);
                    a = H
                }
                return a
            }
            this.name = a;
            this.g = c;
            this.l = q;
            switch (E) {
            case "exactly-one":
                this.l = Vc(c[0].l, 2);
                break;
            case "head":
                this.l = Vc(c[0].l, Xc(c[0].l.fa) ? 3 : 2);
                break;
            case "tail":
            case "subsequence":
                this.l = Vc(c[0].l, 7);
                break;
            case "ceiling":
            case "floor":
            case "reverse":
            case "snapshot":
                this.l = c[0].l;
                break;
            case "last":
            case "position":
                this.Wa = !0;
                break;
            case "string-length":
            case "normalize-space":
                0 === c.length && this.g.push(Df("string", new Ef));
                break;
            case "fold-left":
            case "fold-right":
                this.l = c[2].resultType;
                break;
            case "for-each":
                this.l = Vc(c[1].l.U.ff(), 7);
                break;
            case "filter":
                this.l = Vc(c[0].l, 7);
                break;
            case "current":
                this.Kb = !0;
                break;
            case "boolean":
                if (c[0].l.equals(dc.cb))
                    return c[0]
            }
        }
        Ga() {
            return new af(this)
        }
        $b() {
            if (this.name.uri === Zb.Oa)
                return "doc document element-with-id id innermost key outermost".split(" ").includes(this.name.local) ? !0 : "filter one-or-more subsequence remove tail trace unordered zero-or-more".split(" ").includes(this.name.local) ? this.g[0].$b() : !1
        }
        G(a) {
            super.start(a, {
                name: this.name.name.local
            });
            for (const c of this.g)
                c.G(a);
            a.end()
        }
    }
    Cf.prototype.O = "fn";
    class Ff extends Se {
        constructor(a, c, q) {
            super();
            this.name = a;
            this.g = c;
            this.l = q
        }
        G(a) {
            super.start(a, {
                name: this.name.toEQName()
            });
            for (const c of this.g)
                c.G(a);
            a.end()
        }
    }
    Ff.prototype.O = "ifCall";
    class Gf extends Se {
        constructor(a, c, q) {
            super();
            this.name = a;
            this.g = c;
            this.l = q;
            if (a = "merge" === a.name.local)
                a = c[0],
                a = !(a instanceof lf && 0 === a.value.length);
            a && (this.l = Vc(c[0].l, 2))
        }
        G(a) {
            super.start(a, {
                name: this.name.toEQName()
            });
            for (const c of this.g)
                c.G(a);
            a.end()
        }
    }
    Gf.prototype.O = "ifCall";
    class Hf extends Se {
        constructor(a, c, q) {
            super();
            this.name = a;
            this.g = c;
            this.l = q
        }
        G(a) {
            super.start(a, {
                name: this.name.toEQName()
            });
            for (const c of this.g)
                c.G(a);
            a.end()
        }
    }
    Hf.prototype.O = "ifCall";
    class If extends Ff {
    }
    class Jf extends Se {
        constructor(a, c, q) {
            super();
            this.name = a;
            this.g = c;
            this.l = q
        }
        G(a) {
            super.start(a, {
                name: this.name.toEQName()
            });
            for (const c of this.g)
                c.G(a);
            a.end()
        }
    }
    Jf.prototype.O = "ifCall";
    class Kf extends Se {
        constructor(a, c, q) {
            super();
            this.name = a;
            this.g = c;
            this.l = q
        }
        G(a) {
            super.start(a, {
                name: this.name.toEQName()
            });
            for (const c of this.g)
                c.G(a);
            a.end()
        }
    }
    Kf.prototype.O = "ifCall";
    class Lf extends Kf {
        constructor(a, c, q) {
            super(a, c, q);
            const E = new Bf(La.XS.QName.fromParts("ixsl", Zb.nd, "call"),3)
              , H = new Bf(La.XS.QName.fromParts("ixsl", Zb.nd, "window"),0);
            this.name = E;
            this.g = [new Kf(H,[],dc.mc), new of(a.name.local), new Mf(c)];
            this.l = q
        }
    }
    class Nf extends Se {
        constructor(a, c, q, E) {
            super();
            this.name = a;
            this.g = c;
            this.l = q;
            this.j = E
        }
        G(a) {
            super.start(a, {
                name: this.name.toEQName(),
                coId: this.j
            });
            for (const c of this.g)
                c.G(a);
            a.end()
        }
    }
    Nf.prototype.O = "ufCall";
    class Of extends Se {
        constructor(a) {
            super();
            this.name = a.name.name;
            this.xb = a.xb;
            this.arity = a.name.arity;
            this.l = a.l;
            this.resultType = a.resultType
        }
        G(a) {
            Re(this, a, {
                name: this.name.toEQName(),
                arity: this.arity,
                resultType: this.resultType.ha()
            })
        }
    }
    Of.prototype.O = "fnRef";
    class Pf extends Of {
        constructor(a) {
            super(a);
            this.g = 0
        }
        G(a) {
            Re(this, a, {
                name: this.name.toEQName(),
                arity: this.arity,
                resultType: this.resultType.ha(),
                bSlot: this.g
            })
        }
    }
    Pf.prototype.O = "ufRef";
    class Qf extends Se {
        constructor() {
            super();
            this.l = dc.Aa
        }
        G(a) {
            Re(this, a, {
                asCode: "*"
            })
        }
    }
    Qf.prototype.O = "null";
    class Rf extends Se {
    }
    Rf.prototype.g = {};
    Rf.prototype.B = {};
    Rf.prototype.j = {};
    class Sf extends Se {
        constructor() {
            super();
            this.l = dc.Aa;
            this.slot = this.$a = this.name = this.bc = null
        }
        gd() {
            return this.name
        }
        toString() {
            return "$" + this.name + " as " + this.l.toString()
        }
        G(a) {
            Re(this, a, {
                name: this.name,
                asCode: this.l.ha(),
                slot: this.slot
            })
        }
    }
    Sf.prototype.O = "arg";
    class Tf extends Se {
        constructor(a, c, q) {
            super();
            this.params = a;
            this.resultType = c;
            const E = [];
            a.forEach(H=>{
                E.push(H.l)
            }
            );
            q = qf(q, c, this.Da("body"));
            this.l = kc(new dd(E,c));
            this.arity = a.length;
            this.body = q;
            q.role = "body"
        }
        G(a) {
            super.start(a, {
                arity: this.arity,
                name: this.name,
                as: this.resultType.ha()
            });
            for (const c of this.params)
                c.G(a);
            this.body.G(a);
            a.end()
        }
    }
    oa = Tf.prototype;
    oa.O = "inlineFn";
    oa.kind = 5;
    oa.Da = function(a, c="XPTY0004") {
        return new Qe(this.kind,"(" + this.params.map(q=>q.toString()).join(",") + ")" + (this.resultType ? " as " + this.resultType.toString() : ""),a,c)
    }
    ;
    oa.name = "inline";
    oa.ag = !0;
    class Uf extends Se {
        constructor(a, c, q) {
            super();
            if (a.l && a.l.U instanceof dd && a.l.$().a.length !== c.length)
                throw new F("Partially-applied function requires " + a.arity + " arguments, but " + (c.length < a.arity ? "only " : "") + c.length + " were supplied","XPTY0004");
            this.Oa = a;
            let E;
            a instanceof Vf ? (E = a.resultType,
            a.xb.wh ? this.j = new Pf({
                name: {
                    name: a.name,
                    arity: a.arity
                },
                xb: a.xb,
                l: a.l,
                resultType: E
            }) : this.j = new Of({
                name: {
                    name: a.name,
                    arity: a.arity
                },
                xb: a.xb,
                l: a.l,
                resultType: E
            })) : this.j = a;
            this.g = [];
            let H = 0, p;
            if (a.xb) {
                const g = a.xb.alphaTree
                  , e = a.xb.variadic;
                c.forEach(k=>{
                    var v = g.a[H];
                    v = p ? p : ic(v);
                    k instanceof Qf ? k.l = v : k = qf(k, v, this.Da(H));
                    this.g.push(k);
                    e && (p = v);
                    H++
                }
                )
            } else
                c.forEach(g=>{
                    this.g.push(g)
                }
                );
            a.l.U instanceof dd && (this.l = kc(vd(a.l.U, q)))
        }
        G(a) {
            super.start(a);
            this.j.G(a);
            this.g.forEach(c=>{
                c.G(a)
            }
            );
            a.end()
        }
    }
    Uf.prototype.O = "partialApply";
    Uf.prototype.kind = 5;
    class Wf extends Se {
        constructor(a, c) {
            super();
            this.key = a;
            this.value = c;
            this.l = ec("1FM")
        }
        toString() {
            return "map{" + this.key.toString + " : " + this.value.toString() + "}"
        }
        G(a) {
            super.start(a);
            this.key.G(a);
            this.value.G(a);
            a.end()
        }
    }
    Wf.prototype.O = "map";
    class Xf extends Se {
        constructor(a) {
            super();
            this.entries = a;
            const c = sd.Md(a.map(H=>H[0].l.U))
              , q = sd.Md(a.map(H=>H[1].l.U));
            a = a.map(H=>H[1].l.fa);
            let E = 2;
            a.some(H=>Xc(H)) && (E += 1);
            a.some(H=>Zc(H)) && (E += 4);
            this.l = kc(new td(c,new gc(q,E)))
        }
        toString() {
            let a = "map{";
            this.entries.forEach(c=>{
                a += c[0].toString + " : " + c[1].toString()
            }
            );
            return a + "}"
        }
        G(a) {
            super.start(a);
            this.entries.forEach(c=>{
                c[0].G(a);
                c[1].G(a)
            }
            );
            a.end()
        }
    }
    Xf.prototype.O = "map";
    // Input 55
    class Yf extends Se {
        constructor(a, c) {
            super();
            sa.assert(!c || c instanceof lc);
            this.axis = a;
            this.O = "axis";
            c = c || qc;
            2 === a && c instanceof rc ? c = Hc : 3 === a && c instanceof rc && (c = sc);
            this.g = c;
            9 === a && c instanceof rc ? this.l = dc.ce : c ? this.l = new gc(c,7) : this.l = dc.be
        }
        Cb() {
            return this.axis
        }
        $b() {
            return [2, 3, 4, 5, 6, 7, 9, 12].includes(this.axis)
        }
        Ga() {
            return new Ze(this.g)
        }
        G(a) {
            Re(this, a, {
                name: Me(this.axis),
                nodeTest: this.l.ha()
            })
        }
    }
    class Zf extends Te {
        constructor(a, c) {
            super(a, 2, c);
            this.ea = a = qf(a, dc.be, this.Da(0, "XPTY0019"));
            this.l = Wc(c.l, a.l.fa)
        }
        $b() {
            return !0
        }
        Ga() {
            if (this.ga instanceof Cf || this.ga instanceof lf)
                throw new ve("Not an axis step for a pattern","XTSE0340");
            return this.Wa || !this.ga.Cb || this.ga instanceof $f ? new bf(this) : new ef(this.ga.Cb(),this.ga.Ga(),this.ea.Ga())
        }
        G(a) {
            super.start(a, this.Va ? {
                op: oe[this.Va]
            } : {});
            this.ea.G(a);
            this.ga.G(a);
            a.end()
        }
    }
    Zf.prototype.O = "slash";
    class ag extends Se {
        constructor() {
            super();
            this.l = dc.ce
        }
        Ga() {
            return new Ze(Ec)
        }
    }
    ag.prototype.O = "root";
    // Input 56
    const bg = {
        ADI: "i",
        ADIL: "c",
        ADILI: "i",
        ADILIS: "i",
        ADILISB: "i",
        ADIN: "c",
        ADINN: "c",
        ADIP: "c",
        ADIPP: "c",
        ADIPL: "c",
        ADIPLI: "i",
        ADIPLIS: "i",
        ADIPLISB: "i",
        AD: "c",
        AO: "d",
        AF: "f",
        A: "a",
        AZ: "a",
        AT: "t",
        AA: "t",
        AM: "t",
        AMP: "t",
        AH: "t",
        AI: "t",
        AJ: "t",
        AG: "t",
        AK: "t",
        ARD: "u",
        ARY: "u",
        E: "a"
    };
    var cg = {
        19: "%",
        18: "/",
        56: "~",
        15: "+",
        16: "-",
        299: "-",
        17: "*"
    };
    function dg(a, c) {
        c = new xf(a,"AO",c.save());
        c.l = 2 === a.l.fa ? dc.de : dc.Cg;
        return c
    }
    class eg extends Te {
        constructor(a, c, q, E) {
            function H(d) {
                return d instanceof nc && d.Vc.lb ? new nc(La.yj(d.Vc)) : d
            }
            function p() {
                throw new ve("Cannot evaluate " + k.toString() + " " + oe[c] + " " + v.toString(),"XPTY0004");
            }
            super(a, c, q);
            const g = E.te()
              , e = a.Wa || q.Wa;
            g && (a = fg(a),
            q = fg(q));
            a = qf(a, dc.dc, this.Da(0));
            q = qf(q, dc.dc, this.Da(1));
            let k = H(a.l.U)
              , v = H(q.l.U);
            var t = k.$().p
              , C = v.$().p;
            g || !/^AS/.test(t) && !/^AS/.test(C) || p();
            "AZ" !== t || g || (a = dg(a, this.Da(0, "FORG0001")),
            k = Mc,
            t = "AO");
            "AZ" !== C || g || (q = dg(q, this.Da(1, "FORG0001")),
            v = Mc,
            C = "AO");
            var m = bg[t];
            let f = bg[C];
            const A = k.isNumeric()
              , O = v.isNumeric();
            C = Sc;
            t = Xc(a.l.fa) || Xc(a.l.fa);
            m ||= "a";
            f ||= "a";
            var b;
            g ? (m = f = "d",
            C = Mc) : A && O && ("d" === m || "d" === f ? (m = f = "d",
            C = b = Mc) : "f" === m || "f" === f ? (m = f = "f",
            C = b = Nc) : "c" === m || "c" === f ? (m = f = "c",
            C = b = Pc) : "i" === m && "i" === f && 18 === c ? (m = f = "c",
            C = Pc) : "i" !== m || "i" !== f || 15 !== c && 16 !== c && 17 !== c && 19 !== c ? "i" === m && "i" === f && 18 === c && (C = Pc) : C = Qc);
            56 === c && (C = Qc);
            C.isNumeric() && b && (b = new gc(b,3),
            a = qf(a instanceof gg ? a.g : a, b, this.Da(0)),
            q = qf(q instanceof gg ? q.g : q, b, this.Da(1)));
            [m, f].includes("a") && (m = f = "a");
            (k.pa("ARY") && v.pa("AT") || v.pa("ARY") && k.pa("AT")) && p();
            "t" === m && "t" === f && (16 === c ? C = Rc : p());
            "u" === m && "t" === f && (15 === c ? C = v : p());
            "u" === m && "u" === f && (17 === c && p(),
            18 === c ? C = Pc : C = k);
            A && "u" === f && 18 === c && p();
            "t" !== m || "u" !== f || 16 !== c && 15 !== c ? "i" === m && "u" === f && 17 === c ? (m = "n",
            C = v) : "u" !== m || "d" !== f && "i" !== f && "c" !== f ? "u" !== f || "d" !== m && "i" !== m && "c" !== m || (m = "n",
            C = v) : (C = k,
            f = "n") : C = k;
            m = m + cg[c] + f;
            if (!E.te() && "AF" !== C.$().p && !E.Jc && (E.ni ? 0 === E.ni : 1) && kf(a) && kf(q) && (E = a.value[0],
            b = q.value[0],
            18 !== c || 0 !== b.toNumber()))
                return a = mb[m](E, b),
                mf([a], new gc(new nc(La.codes[a.code]),2));
            this.ea = a;
            this.ga = q;
            a.l.equals(q.l) && (this.l = a.l);
            C && (this.l = new gc(C,t ? 3 : 2));
            this.g = m;
            e && (this.Wa = !0);
            g && (this.O = "arith10");
            this.l || (this.l = dc.Oe)
        }
        Ga() {
            throw new ve("The arithmetic expression  " + oe[this.Va] + " is not a patternXTSE0340");
        }
        G(a) {
            super.start(a, this.Va ? {
                op: oe[this.Va],
                calc: this.g
            } : {});
            this.ea.G(a);
            this.ga.G(a);
            a.end()
        }
    }
    eg.prototype.O = "arith";
    // Input 57
    const hg = {
        6: 50,
        22: 51,
        11: 52,
        12: 53,
        13: 54,
        14: 55
    };
    function ig(a, c) {
        a = a.$().p;
        c.$();
        if ("AZ" === a && c.isNumeric())
            return !1;
        if ("A" === a && c.pa())
            return !0;
        "" === a && c.pa();
        return !0
    }
    function jg(a) {
        return /^A[BAMT2XQ]/.test(a)
    }
    class kg extends Te {
        constructor(a, c, q, E) {
            super(a, c, q);
            a = E.Ni();
            c = "GAC";
            switch (a) {
            case Hd.jg:
                c = "CAC"
            }
            a.startsWith(Hd.Mj) && (c = "CAC");
            q.l === dc.Hg && (c = "EQC");
            this.Dd = c + "|" + a;
            this.l = dc.cb
        }
        G(a) {
            super.start(a, {
                op: oe[this.Va],
                comp: this.Dd
            });
            this.ea.G(a);
            this.ga.G(a);
            a.end()
        }
    }
    class lg extends kg {
        G(a) {
            super.start(a, {
                op: oe[this.Va],
                comp: this.Dd,
                card: "1:1"
            });
            this.ea.G(a);
            this.ga.G(a);
            a.end()
        }
    }
    class mg extends lg {
        constructor(a, c, q, E) {
            super(a, c, q, E);
            a = qf(a, dc.Ad, this.Da(0));
            q = qf(q, dc.Ad, this.Da(1));
            c = a.l.$();
            E = q.l.$();
            var H = c.p;
            var p = E.p;
            H === p || [H, p].includes("AZ") || [H, p].includes("A") ? H = !0 : (/^A[ODF]/.test(H) && (H = "AO"),
            /^A[ODF]/.test(p) && (p = "AO"),
            /^A[SU]/.test(H) && (H = "AS"),
            /^A[SU]/.test(p) && (p = "AS"),
            H = "E" === H || "E" === p ? !0 : H === p);
            if (!H)
                if (H = "Cannot compare items of types " + a.l.U.toString() + " and " + q.l.U.toString(),
                /[*?]/.test(c.o) || /[*?]/.test(E.o))
                    sa.Ma(H + ": the comparison can succeed only if one of the values is an empty sequence", 1, null);
                else
                    throw new ve(H,"XPTY0004");
            this.ea = a;
            this.ga = q
        }
    }
    mg.prototype.O = "gc";
    class ng extends lg {
    }
    ng.prototype.O = "gc10";
    class og extends kg {
        constructor(a, c, q, E, H=!0) {
            super(a, c, q, E);
            var p = a.l.U
              , g = q.l.U;
            const e = p.$().p
              , k = g.$().p;
            if (!("A" === e && g.pa() || "A" === k && p.pa() || "" === e || "" === k || p.$().p.startsWith("AM") && g.$().p.startsWith("AM") || (jg(e) || jg(k) ? e === k : ig(p, g) || ig(g, p))))
                throw new ve("Cannot compare " + a.l.toString() + " " + oe[c] + " " + q.l.toString(),"XPTY0004");
            a = qf(a, dc.dc, this.Da(0));
            q = qf(q, dc.dc, this.Da(1));
            if (51 !== c && 50 !== c && /^A[QGHIJK]/.test(a.l.U.$().p))
                throw new ve("Cannot order-compare " + a.l.toString() + " " + oe[c] + " " + q.l.toString(),"XPTY0004");
            if (H) {
                if (kf(q) && La.XS.integer.matches(q.value[0]) && "ADI" === a.l.$().p)
                    return new pg(a,c,q,E);
                if (q instanceof of)
                    return new qg(a,c,q,E)
            }
            this.ea = a;
            this.ga = q
        }
    }
    og.prototype.O = "vc";
    class rg extends og {
        constructor(a, c, q, E) {
            super(a, c, q, E, !1)
        }
        G(a) {
            super.start(a, {
                op: oe[this.Va],
                val: this.ga.value[0]
            });
            this.ea.G(a);
            a.end()
        }
    }
    class pg extends rg {
    }
    pg.prototype.O = "compareToInt";
    class qg extends rg {
        G(a) {
            super.start(a, {
                op: oe[this.Va],
                val: this.ga.value[0].toString(),
                comp: this.Dd
            });
            this.ea.G(a);
            a.end()
        }
    }
    qg.prototype.O = "compareToString";
    class sg extends kg {
        constructor(a, c, q, E) {
            super(a, c, q, E);
            a = qf(a, dc.ce, this.Da(0));
            q = qf(q, dc.ce, this.Da(0));
            this.ea = a;
            this.ga = q;
            this.O = 38 === c ? "precedes" : 39 === c ? "follows" : "is"
        }
        G(a) {
            super.start(a);
            this.ea.G(a);
            this.ga.G(a);
            a.end()
        }
    }
    ;// Input 58
    function tg(a, c) {
        return a instanceof Cf && a.name.name.uri === Zb.Oa && a.name.name.local === c
    }
    function ug(a, c) {
        return a instanceof og && a.Va === c && tg(a.ea, "position") && tg(a.ga, "last")
    }
    class vg extends Se {
        constructor(a, c) {
            super();
            if (c) {
                let E = tg(c, "last") || ug(c, 50);
                if (E)
                    return new wg(a);
                E = E || ug(c, 53);
                var q = c.Wa || c instanceof eg;
                const H = c.Kb;
                if (!q && H && c.l.equals(dc.Bd))
                    return new xg(a,c);
                q || (q = c.l.U.$().p,
                q = "AB" === q || q.startsWith("N") ? !1 : "A" === q || /^A[ODF]/.test(q));
                this.g = a;
                this.l = a.l;
                c instanceof yg ? this.l = Vc(c.type, this.l.fa) : c instanceof lf && 1 === c.value.length && uc.ia()(c.value[0]) && (this.l = Vc(this.l, 3));
                q && (this.Wa = !0);
                H && (this.Kb = !0);
                this.j = E ? new zg(50 === c.Va ? "1" : "0") : c
            }
        }
        Cb() {
            return this.g.Cb()
        }
        $b() {
            return super.$b() || this.g.$b()
        }
        Ga() {
            if (!jd(this.l.U)) {
                const a = Df("exists", this);
                return new Ye(a)
            }
            return this.Wa && this.g instanceof Yf && !(this.j instanceof zg) ? new cf(this.g,this.j) : this.Wa ? new bf(this.Gd()) : new $e(this.g.Ga(),this.j)
        }
        Gd() {
            if (this.g instanceof Ef)
                return this.j;
            this.g = this.g instanceof Yf ? Ag(new Ef, this.g) : this.g.Gd();
            return this
        }
        G(a) {
            super.start(a);
            let c = "";
            this.Kb && (c += "i");
            this.Wa && (c += "p");
            "" !== c && a.ud("flags", c);
            this.g.G(a);
            this.j.G(a);
            a.end()
        }
    }
    vg.prototype.O = "filter";
    class xg extends vg {
        constructor(a, c) {
            super(a, null);
            if (kf(c) && La.XS.integer.matches(c.value[0]) && 1 === c.value[0].value)
                return new Bg(a);
            this.g = a;
            this.l = Vc(a.l, 3);
            this.j = c;
            this.Wa = !0
        }
        Ga() {
            return this.g instanceof Ef ? new Xe("Numeric predicates other than 1 in PredicatePatterns never match. Value provided:" + this.j.value.value) : this.g instanceof Yf ? new df(this.g.l,this.j.value[0].value) : new bf(this.Gd())
        }
    }
    xg.prototype.O = "subscript";
    class Bg extends xg {
        constructor(a) {
            super(a, null);
            this.g = a;
            this.Wa = !0;
            this.l = Vc(a.l, 3)
        }
        Ga() {
            return jd(this.l.U) ? this.g instanceof Yf ? new bf(new Bg(Ag(new Ef, this.g))) : new bf(this.Gd()) : new Ye(this)
        }
        G(a) {
            super.start(a);
            this.g.G(a);
            a.end()
        }
    }
    Bg.prototype.O = "first";
    class wg extends xg {
        constructor(a) {
            super(a, null);
            this.g = a;
            this.Wa = !0;
            this.l = Vc(a.l, 3)
        }
        Ga() {
            if (!(this.g instanceof Yf))
                return new bf(this.Gd());
            if (3 === this.g.axis) {
                var a = new Yf(7,this.g.g);
                return new $e(this.g.Ga(),Df("empty", [a]))
            }
            return new df(this.g.l,1)
        }
        G(a) {
            super.start(a);
            this.g.G(a);
            a.end()
        }
    }
    wg.prototype.O = "lastOf";
    class zg extends Se {
        constructor(a="1") {
            super();
            this.test = a;
            this.l = dc.cb
        }
        G(a) {
            Re(this, a, {
                test: this.test
            })
        }
    }
    zg.prototype.O = "isLast";
    // Input 59
    function Cg(a, c) {
        if (a instanceof ag && c instanceof Yf && 9 === c.Cb())
            return nf();
        if (a instanceof Zf && a.ea instanceof ag && 5 === a.ga.axis && c instanceof Yf && 3 === c.axis)
            return Cg(a.ea, new Yf(4,c.g));
        if (c instanceof Zf || c instanceof Dg && c.g instanceof Zf) {
            const q = Eg(c);
            Fg(q.ea)instanceof Yf && Fg(q.ga)instanceof Yf && (a = Ag(a, q.ea),
            c = q.ga)
        }
        a = new Zf(a,c);
        return Gg(a) ? a : jd(a.ga.l.U) ? (a.ea = Hg(a.ea),
        a.ga = Hg(a.ga),
        new Dg(a)) : a
    }
    function Gg(a) {
        if (!Zc(a.ea.l.fa))
            return a.ga.$b();
        const c = Fg(a.ea);
        return c instanceof Yf && 3 === c.axis && (a = Fg(a.ga),
        a instanceof Dg && (a = a.g),
        a instanceof Yf && [3, 2, 4, 5, 8].includes(a.axis) || a instanceof Zf && Gg(a)) ? !0 : !1
    }
    function Eg(a) {
        return a instanceof Dg ? a.g : a
    }
    function Fg(a) {
        return a instanceof vg ? Fg(a.g) : a instanceof Dg ? Fg(a.g) : a
    }
    var Ag = Cg;
    function Ig(a) {
        return a.$b() ? a : new Dg(a)
    }
    var Hg = Eg;
    // Input 60
    function Jg(a, c, q, E, H={}) {
        sa.assert(c);
        sa.assert(c instanceof gc);
        sa.assert(a.l);
        sa.assert(a.l instanceof gc);
        var p = c.$(), g = a, e;
        const k = c.U
          , v = c.fa
          , t = Zc(v);
        var C = null
          , m = -1;
        let f = 7 === v;
        f || (m = a.l.fa,
        f = (v | m) === v);
        p = "" === p.p;
        1 === v && (p = !0);
        p || (C = a.l.U,
        m = a.l.fa,
        p = sd.Nb(k, C),
        p === sd.cc && (p = C === oc ? sd.nc : k === oc ? sd.Rb : p),
        p = p === sd.yb || p === sd.Rb);
        if (p && f)
            return g;
        if (H.Tb && !t && (Zc(m) && (g = e = new Bg(g),
        m = 3,
        f = (v | m) === v),
        !p)) {
            if (k.pa("AS")) {
                try {
                    e = Jg(g, dc.Hf, q, E)
                } catch (A) {
                    throw A;
                }
                g = Df("string", e);
                C = Oc;
                m = 2;
                g.l = dc.ec;
                f = (v | m) === v;
                p = !0
            }
            if (kd(k) || k.pa("AO")) {
                try {
                    e = Jg(g, dc.Hf, q, E)
                } catch (A) {
                    throw A;
                }
                g = Df("number", e);
                C = Mc;
                m = 2;
                g.l = dc.de;
                f = (v | m) === v;
                p = !0
            }
        }
        if (!p)
            if (k.pa()) {
                if (!C.pa() && 1 !== m) {
                    if (!C.$i)
                        throw c = new F("An atomic value is required for the " + q.getMessage() + ", but the supplied value (type " + C.toString() + ") cannot be atomized","error()" === C.name ? "FOER0000" : "FOTY0013",a),
                        c;
                    C = !Zc(m);
                    m = !Zc(v);
                    C ? (e = Xc(v),
                    g = g instanceof Yf && 2 === g.axis && g.l.U instanceof nd ? new wf(g.l) : new vf(g,E,e)) : g = g instanceof Yf && 2 === g.axis && g.l.U instanceof nd ? new wf(g.l) : new uf(g,E);
                    e = g;
                    m && !C && (e = Kg(e, v, E));
                    g = e;
                    C = g.l.U;
                    m = g.l.fa;
                    f = (v | m) === v
                }
                C.pa("AZ") && (kd(k) || !k.pa("AZ") && "A" !== k.$().p) && (g = e = Lg(g, k, E),
                p = !0,
                C = k);
                "A" !== C.ha() || ["A", "AZ"].includes(k.ha()) || (g = e = Lg(g, k, E),
                C = g.l.U);
                k.pa() && (k.pa("AO") && sd.Nb(C, uc) !== sd.cc ? (g = e = new yf(g,dc.de),
                C = Mc,
                m = -1) : k.pa("AF") && sd.Nb(C, uc) !== sd.cc && !sd.fj(C, Mc) && (g = e = new yf(g,dc.Gg),
                C = Nc,
                m = -1),
                k.pa("AS") && C.pa("AU") && (p = !0,
                g = e = new yf(g,dc.ec),
                C = Oc))
            } else
                k.Jd() && "F" === k.$().p && (C.Jd() || (g = new Mg(g,wc,E),
                C = wc),
                k instanceof xc || (p = C.$(),
                ("FM" === p.p || "FA" === p.p) && 1 === k.j.length) || (g = new zf(g,kc(k),E)),
                p = !0);
        if (p && f)
            return g;
        -1 === m && (m = g.l.fa,
        f ||= (v | m) === v);
        if (f && 1 === m)
            return g;
        if (1 === m && !Xc(v))
            throw c = new F("An empty sequence is not allowed as the " + q.getMessage(),q.Id()),
            c;
        p = p ? sd.nc : sd.Nb(C, k);
        p === sd.cc && (p = C === oc ? sd.Rb : k === oc ? sd.nc : p);
        1 === v && (p = sd.yb);
        if (p === sd.cc)
            if (Xc(m) && Xc(v))
                1 !== m && (e = q.Vf(k, C),
                sa.Ma(e + ". The expression can succeed only if the supplied value is an empty sequence.", 1, null));
            else
                throw e = q.Vf(k, C),
                c = new F(e,"error()" === C.name ? "FOER0000" : q.Id()),
                c;
        if (p !== sd.yb && p !== sd.nc) {
            if (g.bj) {
                E = La.XS.string.fromString(g.getAttribute("val"));
                if (k.pa() && c.matches(E))
                    return g;
                e = q.Vf(k, C);
                c = new F(e,q.Id());
                throw c;
            }
            g = e = Ng(g, new gc(k,v), E);
            f = !0
        }
        if (!f) {
            if (g.bj)
                throw c = new F("Required cardinality of " + q.getMessage() + " is " + Yc(v) + "; supplied value has cardinality " + Yc(m),q.Id()),
                c;
            g = e = Kg(g, v, E)
        }
        return g
    }
    function Lg(a, c, q) {
        c = kd(c) ? "AO" : c.$().p;
        return new xf(a,c,q)
    }
    ;// Input 61
    function Df(a, c) {
        a = new La.XS.QName.fromParts("fn",Zb.Oa,a);
        c = Array.isArray(c) ? c : [c];
        a = new Bf(a,c.length);
        return new Cf(a,c,dc.Aa)
    }
    function qf(a, c, q) {
        const E = Og(q.errorCode ? q.errorCode : "XPTY0004", q.save());
        return Jg(a, c, E, q.save())
    }
    function fg(a) {
        return Zc(a.l.fa) ? new Bg(a) : a
    }
    class Pg extends Se {
        constructor(a) {
            super();
            this.value = a;
            0 === a.length ? this.l = dc.Ie : this.l = new gc(sd.Md(a.map(q=>q.l.U)),7);
            let c = !0;
            a.forEach(q=>{
                c = c && q instanceof lf
            }
            );
            c && (this.g = !0)
        }
        G(a) {
            super.start(a);
            this.g && a.ud("literal", !0);
            for (const c of this.value)
                c.G(a);
            a.end()
        }
    }
    Pg.prototype.O = "sequence";
    class Mf extends Se {
        constructor(a) {
            super();
            this.value = a;
            if (0 === a.length)
                this.l = kc(Ac);
            else {
                const c = sd.Md(a.map(E=>E.l.U));
                let q = 0;
                a.forEach(E=>q |= E.l.fa);
                this.l = kc(new ud(new gc(c,q)))
            }
        }
        G(a) {
            super.start(a);
            for (const c of this.value)
                c.G(a);
            a.end()
        }
    }
    Mf.prototype.O = "arrayBlock";
    class Qg extends Se {
        constructor(a, c) {
            super();
            this.Va = a;
            this.O = oe[a];
            this.$a = c;
            this.action = this.Ob = void 0;
            this.slot = 0;
            this.bc = this.value = null;
            this.l = dc.cb
        }
        gd() {
            return this.$a
        }
        G(a) {
            super.start(a, {
                "var": this.$a.toEQName(),
                slot: this.slot
            });
            this.value.G(a);
            this.action.G(a);
            a.end()
        }
    }
    class $f extends Te {
        constructor(a, c, q, E=!1) {
            super(a, c, q);
            this.O = 1 === c ? "union" : oe[c];
            E = E ? "XTSE0340" : "XPTY0004";
            a = qf(a, dc.be, this.Da(0, E));
            q = qf(q, dc.be, this.Da(1, E));
            a = Ig(a);
            q = Ig(q);
            this.ea = a;
            this.ga = q;
            sa.assert(a.l);
            sa.assert(q.l);
            switch (c) {
            case 24:
                this.l = a.l;
                break;
            case 23:
                c = a.l.fa & q.l.fa | 3;
                this.l = new gc(sd.Ui([a, q].map(H=>H.l.U)),c);
                break;
            case 1:
                this.l = new gc(sd.Md([a, q].map(H=>H.l.U)),Dd(a.l.fa, q.l.fa))
            }
        }
        $b() {
            return !0
        }
        Cb() {
            return this.ea.Cb && this.ga.Cb && this.ea.Cb() === this.ga.Cb() ? this.ea.Cb() : -1
        }
        Ga() {
            if (1 === this.Va)
                return new hf(this.ea.Ga(),this.ga.Ga(),this.l);
            const a = this.Cb();
            return 3 === a || 2 === a || this.ea.Kb || this.ga.Kb ? new ff(this.ea.Ga(),this.Va,this.ga.Ga(),this.l) : new bf(this)
        }
    }
    class Ef extends Se {
        constructor(a=dc.mc) {
            super();
            this.l = a
        }
        G(a) {
            Re(this, a)
        }
        Ga() {
            return new We
        }
    }
    Ef.prototype.O = "dot";
    function Rg(a) {
        return "" === a.l.$().p ? new Sg(a) : a
    }
    class Sg extends Ue {
        constructor(a) {
            super(a);
            this.l = a.l
        }
    }
    Sg.prototype.O = "homCheck";
    function Tg(a) {
        return a.global ? new Ug(a) : new Vg(a)
    }
    class Wg extends Se {
        constructor() {
            super();
            this.g = null;
            this.l = dc.Aa
        }
    }
    Wg.prototype.O = "varRef";
    Wg.prototype.Kb = !0;
    class Vg extends Wg {
        constructor(a) {
            super();
            this.g = a;
            this.l = a.bc || dc.Aa
        }
        gd() {
            return this.g.$a
        }
        G(a) {
            Re(this, a, {
                name: this.g.$a.toEQName(),
                slot: this.g.slot
            })
        }
    }
    Vg.prototype.O = "varRef";
    class Ug extends Wg {
        constructor(a) {
            super();
            this.g = a;
            this.l = a.bc
        }
        gd() {
            return this.g.$a
        }
        Ga() {
            return new af(this)
        }
        G(a) {
            Re(this, a, {
                name: this.g.$a.toEQName(),
                bSlot: "?"
            })
        }
    }
    Ug.prototype.O = "gVarRef";
    class Xg extends Te {
        constructor(a, c) {
            super(a, 213, c);
            this.ea = a = qf(a, dc.Df, this.Da(0));
            a.l && a.l.U && a.l.U.resultType && (this.l = a.l.U.resultType)
        }
    }
    Xg.prototype.O = "lookup";
    class Yg extends Se {
        constructor(a) {
            super();
            this.ea = a = qf(a, dc.Df, this.Da(0))
        }
        G(a) {
            super.start(a);
            this.ea.G(a);
            a.end()
        }
    }
    Yg.prototype.O = "lookupAll";
    class Zg extends Se {
        constructor() {
            super();
            this.l = dc.Aa
        }
    }
    Zg.prototype.O = "currentGroup";
    class $g extends Se {
        constructor() {
            super();
            this.l = dc.Ad
        }
    }
    $g.prototype.O = "currentGroupingKey";
    class Dg extends Ue {
        constructor(a) {
            super(a);
            this.l = a.l
        }
        $b() {
            return !0
        }
        Ga() {
            return this.g.Ga()
        }
    }
    Dg.prototype.O = "docOrder";
    class ah extends Ue {
        constructor(a) {
            super(a);
            this.l = a.l
        }
        G(a) {
            super.start(a, {
                flags: this.flags
            });
            this.g.G(a);
            a.end()
        }
    }
    ah.prototype.O = "copyOf";
    ah.prototype.flags = "cm";
    class yg extends Se {
        constructor(a, c) {
            super();
            sa.assert(c instanceof gc);
            this.ea = a;
            this.type = c;
            this.l = dc.cb
        }
        G(a) {
            super.start(a, {
                of: this.type.ha()
            });
            this.ea.G(a);
            a.end()
        }
    }
    yg.prototype.O = "instance";
    function Ng(a, c, q=null) {
        q || (q = new Qe(2,"treat as",0),
        q.errorCode = "XPDY0050",
        q = q.save());
        return new Mg(Kg(a, c.fa, q),c.U,q)
    }
    class gg extends Ue {
        constructor(a, c, q) {
            super(a);
            this.l = new gc(a.l.U,c);
            this.j = c;
            this.B = q
        }
        G(a) {
            super.start(a, {
                card: 2 === this.j ? "1" : Yc(this.j),
                diag: this.B
            });
            this.g.G(a);
            a.end()
        }
    }
    gg.prototype.O = "check";
    function Kg(a, c, q) {
        return 7 === c ? a : a instanceof lf && (c | 2) === c ? a : new gg(a,c,q)
    }
    class Mg extends Ue {
        constructor(a, c, q) {
            super(a);
            this.l = a.l;
            this.B = c;
            this.j = q
        }
        G(a) {
            super.start(a, {
                as: this.B.ha(),
                diag: this.j
            });
            this.g.G(a);
            a.end()
        }
    }
    Mg.prototype.O = "treat";
    // Input 62
    function bh(a, c, q) {
        a = [a, mf([La.XS.boolean.Xc], dc.cb)];
        return new ch(a,[c, q])
    }
    class ch extends Se {
        constructor(a, c) {
            super();
            this.g = a;
            this.actions = c;
            this.Wa = c.some(q=>q.Wa);
            a = sd.Md(c.map(q=>q.l.U));
            c = Cd(c.map(q=>q.l.fa));
            this.l = new gc(a,c)
        }
        G(a) {
            super.start(a);
            let c = 0;
            for (const q of this.g)
                q.G(a),
                this.actions[c++].G(a);
            a.end()
        }
    }
    ch.prototype.O = "choose";
    // Input 63
    class dh extends Se {
        constructor() {
            super();
            this.action = this.value = this.bc = this.$a = null;
            this.slot = 0
        }
        gd() {
            return this.$a
        }
        g(a) {
            this.action = a;
            this.l = a.l
        }
        j(a) {
            this.value = a;
            this.bc = a.l
        }
        G(a) {
            super.start(a, {
                name: this.$a.toEQName(),
                slot: this.slot
            });
            this.value.G(a);
            this.action.G(a);
            a.end()
        }
    }
    class eh extends dh {
        j(a) {
            this.value = a;
            this.bc = Vc(a.l, 2);
            this.action && (this.l = Wc(this.action.l, a.l.fa))
        }
        g(a) {
            this.action = a;
            this.value && (this.l = Wc(a.l, this.value.l.fa))
        }
    }
    eh.prototype.O = "for";
    class fh extends dh {
    }
    fh.prototype.O = "let";
    // Input 64
    class gh extends Te {
        constructor(a, c) {
            super(a, null, c);
            this.l = dc.cb
        }
    }
    class hh extends gh {
    }
    hh.prototype.O = "and";
    class ih extends gh {
    }
    ih.prototype.O = "or";
    // Input 65
    function jh(a) {
        return kf(a) && La.XS.integer.matches(a.value[0]) && 1E7 > a.value[0].value
    }
    class kh extends Te {
        constructor(a, c, q=!1) {
            super(a, null, c);
            q && (a = fg(a),
            c = fg(c));
            this.ea = qf(a, dc.Gf, this.Da(0));
            this.ga = qf(c, dc.Gf, this.Da(1));
            this.l = dc.Ke
        }
    }
    kh.prototype.O = "to";
    class lh extends Se {
        constructor(a, c) {
            super();
            this.g = a;
            this.j = c;
            this.l = dc.Ke
        }
        G(a) {
            Re(this, a, {
                from: this.g.value,
                to: this.j.value
            })
        }
    }
    lh.prototype.O = "range";
    class mh extends Se {
        constructor(a, c) {
            super();
            this.g = a;
            this.next = c;
            this.l = Wc(c.l, a.l.fa)
        }
        G(a) {
            super.start(a);
            this.g.G(a);
            this.next.G(a);
            a.end()
        }
    }
    mh.prototype.O = "forEach";
    // Input 66
    // Input 67
    var nh = {
        array: "http://www.w3.org/2005/xpath-functions/array",
        fn: "http://www.w3.org/2005/xpath-functions",
        map: "http://www.w3.org/2005/xpath-functions/map",
        math: "http://www.w3.org/2005/xpath-functions/math",
        saxon: "http://saxon.sf.net/",
        xml: "http://www.w3.org/XML/1998/namespace",
        xs: "http://www.w3.org/2001/XMLSchema",
        xsl: "http://www.w3.org/1999/XSL/Transform"
    }, oh = {}, ph;
    for (ph in nh)
        oh[nh[ph]] = ph;
    // Input 68
    function qh(a, c) {
        var q = new Bf(a.name,a.arity)
          , E = dc.Aa;
        switch (a.uri) {
        case Zb.map:
            E = dc.Jf;
            switch (a.name.local) {
            case "get":
                E = c[0].l.valueType;
                break;
            case "merge":
                E = dc.Jf;
                break;
            case "entry":
                E = kc(new td(c[0].l,c[1].l))
            }
            return new Gf(q,c,E);
        case Zb.Ue:
            switch (a.name.local) {
            case "_from-sequence":
                E = kc(new ud(c[0].l))
            }
            return new Hf(q,c,E);
        case Zb.wb:
            switch (a.name.local) {
            case "apply":
                a = c[0].l,
                a = a.U ? a.U : a,
                E = a.resultType ? a.resultType : dc.Aa
            }
            return new Jf(q,c,E)
        }
    }
    class rh extends Se {
        constructor(a, c, q) {
            var E = dc.Aa;
            super();
            this.name = La.XS.QName.fromParts(oh[q], q, a);
            this.arity = c;
            this.uri = q;
            this.l = dc.Qe;
            this.resultType = E
        }
    }
    rh.prototype.O = "function";
    class sh {
    }
    sh.prototype.uri = Zb.Oa;
    class th extends sh {
        constructor() {
            super()
        }
    }
    th.prototype.uri = Zb.map;
    var uh = new th;
    class vh extends sh {
        constructor() {
            super()
        }
    }
    vh.prototype.uri = Zb.Ue;
    var wh = new vh;
    class xh extends sh {
        constructor() {
            super()
        }
    }
    xh.prototype.uri = Zb.wb;
    class yh extends xh {
    }
    var zh = new yh;
    // Input 69
    const Ah = {
        FUNCTION: 0,
        Tj: 1,
        Ak: 2,
        Gk: 3,
        gk: 4,
        ak: 5,
        nk: 6,
        zk: 7,
        rk: 8,
        Dk: 9,
        Ek: 10,
        fk: 11,
        EVALUATE_RESULT: 12,
        Vj: 13,
        Rj: 14,
        mk: 15,
        Uj: 16,
        Wj: 17
    }
      , Bh = ["doc", "id", "element-with-id", "key", "root"];
    function Ch(a, c, q, E) {
        return Ah[a] + "|" + c + "|" + q + "|" + E
    }
    function Dh(a, c, q, E) {
        return {
            getMessage: function() {
                return c
            },
            Vf: E,
            Id: function() {
                return a
            },
            save: function() {
                return q
            }
        }
    }
    function Og(a, c) {
        const q = cd.Ej(c).required;
        return Dh(a, q, c, function(E, H) {
            return "Required type of " + q + " is " + E.toString() + ": actual type is " + H.toString()
        })
    }
    class Vf {
        constructor(a, c) {
            var q = null;
            this.name = a;
            this.arity = a.arity;
            if (c) {
                this.xb = c;
                q = c.alphaTree;
                const E = [];
                let H;
                c.variadic && (H = ic(q.a[0]));
                for (c = 0; c < a.arity; c++) {
                    const p = H ? H : ic(q.a[c]);
                    E.push(p)
                }
                q = q.r ? ic(q.r) : dc.Aa;
                this.l = kc(new dd(E,q))
            }
            q ? this.resultType = q : this.resultType = dc.Aa;
            this.l || (this.l = dc.Qe)
        }
    }
    Vf.prototype.resultType = dc.Aa;
    const Hh = function() {
        function a() {
            u = new Ie;
            ua = [];
            ia = [];
            Pa = 0
        }
        function c(J) {
            let X = Wa[J];
            X || H("No namespace binding for prefix '" + J + "'", "XPST0081");
            return X
        }
        function q(J, X=this.vb, ka=()=>"") {
            return La.XS.QName.fromString(J, ba=>"" === ba ? ka() : X(ba))
        }
        function E() {
            const J = oe[u.J];
            return 201 === u.J ? 'name "' + u.T + '"' : -1 === u.J ? "(unknown token)" : u.T && u.T !== oe[u.J] ? `${J} ("${u.T}")` : /^[a-z]+$/.test(J) ? `"${J}"` : J
        }
        function H(J, X="XPST0003") {
            Ge(u);
            throw new ve(J,X);
        }
        function p(J) {
            const X = Ge(u);
            console.log((J.startsWith("...") ? "near" : "in") + " " + X + ":\n    " + J)
        }
        function g() {
            try {
                u.next()
            } catch (J) {
                H(J.message)
            }
        }
        function e(J) {
            u.J !== J && H('expected "' + oe[J] + '", found ' + E())
        }
        function k(J=!1) {
            J = v(J);
            let X = null;
            for (; 7 === u.J; ) {
                null == X && (X = [],
                X.push(J));
                g();
                const ka = v();
                X.push(ka)
            }
            null != X && (J = new Pg(X));
            return J
        }
        function v(J=!1) {
            switch (u.J) {
            case 0:
                if (J)
                    return nf();
                H("Expected an expression, but reached the end of the input");
                break;
            case 211:
            case 216:
                J = 0;
                var X = u.J
                  , ka = null
                  , ba = null;
                do {
                    g();
                    e(21);
                    g();
                    e(201);
                    var ta = u.T
                      , Ca = void 0;
                    211 === X ? Ca = new eh : Ca = new fh;
                    J++;
                    ta = va(ta, "");
                    Ca.$a = ta;
                    g();
                    e(216 === X ? 58 : 31);
                    g();
                    ia.push(null);
                    Ca.j(v());
                    ia.pop();
                    da(Ca);
                    null == ba ? ka = Ca : ba.g(Ca);
                    ba = Ca
                } while (7 === u.J);
                e(25);
                g();
                ba.g(v());
                for (Ca = 0; Ca < J; Ca++)
                    ia.pop();
                return ka;
            case 32:
            case 33:
                J = 0;
                X = u.J;
                Ca = ka = null;
                do
                    g(),
                    e(21),
                    g(),
                    e(201),
                    ba = u.T,
                    J++,
                    ta = new Qg(X,va(ba, "")),
                    g(),
                    e(31),
                    g(),
                    ba = v(),
                    ta.value = ba,
                    ta.bc = Vc(ba.l, 2),
                    da(ta),
                    null != Ca ? Ca.action = ta : ka = ta,
                    Ca = ta;
                while (7 === u.J);
                e(34);
                g();
                X = v();
                Ca.action = X;
                for (Ca = 0; Ca < J; Ca++)
                    ia.pop();
                return ka;
            case 37:
                return g(),
                Ca = k(),
                e(204),
                g(),
                e(26),
                g(),
                J = v(),
                e(27),
                g(),
                ka = v(),
                bh(Ca, J, ka);
            default:
                return m(A(), 4)
            }
        }
        function t() {
            return C(u.J)
        }
        function C(J) {
            switch (J) {
            case 9:
            case 81:
                return 4;
            case 10:
            case 80:
                return 5;
            case 50:
            case 51:
            case 55:
            case 53:
            case 54:
            case 52:
            case 6:
            case 22:
            case 14:
            case 12:
            case 13:
            case 11:
            case 20:
            case 38:
            case 39:
                return 6;
            case 30:
                return 7;
            case 29:
                return 8;
            case 15:
            case 16:
                return 9;
            case 17:
            case 18:
            case 56:
            case 19:
                return 10;
            case 79:
                return 11;
            case 1:
                return 12;
            case 23:
            case 24:
                return 13;
            case 45:
                return 14;
            case 47:
                return 15;
            case 57:
                return 16;
            case 46:
                return 17;
            case 76:
                return 18;
            case 40:
                return 20;
            default:
                return -1
            }
        }
        function m(J, X) {
            for (; t() >= X; ) {
                const Qa = u.J;
                var ka = t();
                switch (Qa) {
                case 45:
                case 47:
                    g();
                    var ba = B();
                    a: switch (Qa) {
                    case 45:
                        J = new yg(J,ba);
                        break a;
                    case 47:
                        J = Ng(J, ba);
                        break a;
                    default:
                        throw new we(oe[Qa]);
                    }
                    t() >= ka && H("Left operand of '" + oe[u.J] + "' needs parentheses");
                    break;
                case 46:
                case 57:
                    g();
                    var ta = void 0;
                    if (69 === u.J && "union" === u.T)
                        throw new F("Saxon union types not supported");
                    e(201);
                    if (u.T)
                        a: {
                            try {
                                var Ca = q(u.T, P.vb, P.hc);
                                break a
                            } catch (Xa) {
                                H(Xa.message, Xa.code)
                            }
                            Ca = void 0
                        }
                    else
                        Ca = H("Parser tokenization error NAME");
                    ba = Ca;
                    ba.uri !== Zb.lc && H("Unknown simple type " + u.T + " in cast (SaxonJS is not schema-aware)");
                    g();
                    var Ka = 213 === u.J;
                    Ka && (u.J = 204,
                    g());
                    const ib = {
                        numeric: "u",
                        ENTITIES: "l",
                        NMTOKENS: "l",
                        IDREFS: "l"
                    }[ba.local] || "a";
                    if ("a" === ib) {
                        ["anyType", "anyAtomicType", "NOTATION"].includes(ba.local) && H("Casting to xs:" + ba.local + " is not possible (it's an abstract type)", "XPST0080");
                        ta = La.type[ba.local];
                        if (!ta)
                            throw new F("Cannot find type " + ba.toEQName());
                        ta = new nc(ta)
                    }
                    J = (57 === Qa ? sf : pf)(J, ib, ba, ta, Ka);
                    t() >= ka && H("Left operand of '" + oe[u.J] + "' needs parentheses");
                    break;
                case 76:
                    J = L(J);
                    break;
                default:
                    Ka = 40 === Qa;
                    g();
                    Ka && ua.push(Vc(J.l, 2));
                    ba = A();
                    for (Ka && ua.pop(); t() > ka; )
                        ba = m(ba, t());
                    if (!(ka = t() !== ka))
                        a: switch (u.J) {
                        case 50:
                        case 51:
                        case 55:
                        case 53:
                        case 54:
                        case 52:
                        case 6:
                        case 22:
                        case 14:
                        case 12:
                        case 13:
                        case 11:
                        case 20:
                        case 38:
                        case 39:
                        case 29:
                            ka = !1;
                            break a;
                        default:
                            ka = !0
                        }
                    ka || H("Left operand of '" + oe[u.J] + "' needs parentheses");
                    J = f(J, Qa, ba)
                }
            }
            return J
        }
        function f(J, X, ka) {
            switch (X) {
            case 9:
                return new ih(J,ka);
            case 10:
                return new hh(J,ka);
            case 50:
            case 51:
            case 55:
            case 53:
            case 54:
            case 52:
                return new og(J,X,ka,P);
            case 6:
            case 22:
            case 14:
            case 12:
            case 13:
            case 11:
                if (P.te())
                    X = new ng(J,X,ka,P);
                else {
                    var ba = P;
                    ka = new mg(J,X,ka,ba);
                    if (J = 2 === ka.ea.l.fa && 2 === ka.ga.l.fa && hg[X]) {
                        J = ka.ea.l.U;
                        var ta = ka.ga.l.U;
                        const Ca = J.$().p
                          , Ka = ta.$().p;
                        J = jg(Ca) || jg(Ka) ? Ca === Ka : J.isNumeric() && ta.isNumeric() ? !0 : /^A[SZU]/.test(Ca) && /^A[SZU]/.test(Ka)
                    }
                    X = J ? new og(ka.ea,hg[X],ka.ga,ba) : ka
                }
                return X;
            case 20:
            case 38:
            case 39:
                return new sg(J,X,ka,P);
            case 29:
                return ba = new kh(J,ka,P.te()),
                jh(ba.ea) && jh(ba.ga) ? (X = ba.ea.value[0],
                ba = ba.ga.value[0],
                X = X.value > ba.value ? nf() : X.value === ba.value ? new lf([X],dc.Ke) : new lh(X,ba)) : X = ba,
                X;
            case 30:
                X = [];
                if (J instanceof Cf && "concat" === J.name.name.local && J.name.name.uri === Zb.Oa)
                    for (ba of J.g)
                        X.push(ba);
                else
                    ba = Ch("BINARY_OP", 0, "", "concat"),
                    ta = Og("FOTY0013", ba),
                    J = Jg(J, dc.dc, ta, ba, P),
                    X.push(J);
                ba = Ch("BINARY_OP", 1, "", "concat");
                ta = Og("FOTY0013", ba);
                ka = Jg(ka, dc.dc, ta, ba, P);
                X.push(ka);
                X = Df("concat", X);
                X.l = dc.ec;
                return X;
            case 15:
            case 16:
            case 17:
            case 18:
            case 56:
            case 19:
                return new eg(J,X,ka,P);
            case 79:
                return X = ka,
                ka = La.XS.QName.fromParts("vv", Zb.yg, "otherwise"),
                ba = new fh,
                ba.$a = ka,
                ba.j(J),
                da(ba),
                ka = Tg(ba),
                J = [Df("exists", [ka]), mf([La.XS.boolean.Xc], dc.cb)],
                ba.g(new ch(J,[ka, X])),
                ba;
            case 1:
            case 23:
            case 24:
                return new $f(J,X,ka,1 === Ba);
            case 81:
                return ka = Df("boolean", ka),
                bh(J, mf([La.XS.boolean.Xc], dc.cb), ka);
            case 80:
                return ka = Df("boolean", ka),
                bh(J, ka, mf([La.XS.boolean.ae], dc.cb));
            default:
                throw new we(oe[X]);
            }
        }
        function A() {
            switch (u.J) {
            case 16:
                g();
                var J = A();
                J = O(299, J);
                break;
            case 15:
                g();
                J = A();
                J = O(15, J);
                break;
            default:
                for (J = d(); 40 === u.J; ) {
                    g();
                    ua.push(Vc(J.l, 2));
                    const X = d();
                    ua.pop();
                    J = new mh(J,X)
                }
            }
            return J
        }
        function O(J, X) {
            if (kf(X)) {
                const ka = X.value[0];
                return 299 === J ? mf([ka.nf()], X.l) : X
            }
            return new eg(mf([La.XS.integer.fromNumber(0)], dc.Bd),J,X,P)
        }
        function b() {
            switch (u.J) {
            case 36:
            case 3:
            case 201:
            case 208:
            case 70:
            case 207:
            case 69:
            case 205:
            case 206:
            case 35:
            case 202:
            case 209:
            case 5:
            case 21:
            case 43:
                return !0;
            case 60:
                return ["ordered", "unordered"].includes(u.T);
            default:
                return !1
            }
        }
        function d() {
            var J = u.je;
            switch (u.J) {
            case 2:
                return g(),
                J = new ag,
                b() ? l(J) : J;
            case 8:
                g();
                J = new ag;
                var X = new Yf(5,null);
                J = Ag(J, X);
                return l(J);
            default:
                201 === u.J && ["true", "false"].includes(u.T) && p("The expression is looking for a child element named '" + u.T + "' - perhaps " + u.T + "() was intended? To avoid this warning, use child::" + u.T + " or ./" + u.T + ".");
                201 === u.J && -1 !== Ce(u.T) && 1 !== Ba && (0 < J || 0 !== u.j) && (J = u.T,
                p("The keyword '" + J + "' in this context means 'child::" + J + "'. If this was intended, use 'child::" + J + "' or './" + J + "' to avoid this warning."));
                for (J = r(1 === Ba && 0 === Pa); [2, 8].includes(u.J); ) {
                    ua.push(Vc(J.l, 2));
                    var ka = u.J;
                    g();
                    X = r(!1);
                    2 === ka ? J = Ag(J, X) : X instanceof Yf && 3 === X.axis ? (X = new Yf(4,X.g),
                    J = Ag(J, X)) : (ka = new Yf(5,null),
                    J = Ag(J, ka),
                    J = Ag(J, X));
                    J = Rg(J);
                    ua.pop()
                }
                return J
            }
        }
        function l(J) {
            let X = J;
            var ka = 2;
            for (ua.push(Vc(J.l, 2)); ; ) {
                J = r(!1);
                ua.pop();
                ua.push(Vc(J.l, 2));
                2 === ka ? (X = Ag(X, J),
                X = Rg(X)) : 8 === ka ? (ka = new Yf(5,null),
                ka = Ag(ka, J),
                X = Ag(X, ka),
                X = Rg(X)) : X = new mh(X,J);
                ka = u.J;
                if (2 !== ka && 8 !== ka && 40 !== ka)
                    break;
                g()
            }
            ua.pop();
            return X
        }
        function r(J) {
            J = aa(J);
            const X = J instanceof Yf && !Le[J.Cb()];
            for (; ; )
                if (4 === u.J)
                    ua.push(Vc(J.l, 2)),
                    J = n(J),
                    ua.pop();
                else if (5 === u.J)
                    J = M(J, null);
                else if (213 === u.J)
                    J = ca(J);
                else
                    break;
            X && (J = Df("reverse", J),
            J.el = !0);
            return J
        }
        function n(J=null) {
            if (!J)
                return k(null);
            g();
            Pa++;
            const X = n();
            Pa--;
            e(203);
            g();
            return J = new vg(J,X)
        }
        function B() {
            var J = "empty-sequence" === u.T;
            const X = W();
            if (J)
                return dc.Ie;
            switch (u.J) {
            case 207:
            case 17:
                J = 7;
                u.J = 204;
                g();
                break;
            case 15:
                J = 6;
                u.J = 204;
                g();
                break;
            case 213:
                J = 3;
                u.J = 204;
                g();
                break;
            default:
                J = 2
            }
            return new gc(X,J)
        }
        function W() {
            if (5 === u.J) {
                g();
                var J = W();
                e(204);
                g()
            } else if (201 === u.J) {
                J = null;
                try {
                    J = q(u.T, P.vb, P.hc)
                } catch (ka) {
                    H(ka.message, ka.code)
                }
                {
                    var X = J;
                    let ka = X.uri;
                    "" === ka && (ka = P.hc());
                    const ba = X.local;
                    J = X.toString();
                    ka === Zb.lc ? "numeric" === ba ? J = uc : ((X = La.type[ba]) || H("Unknown atomic type " + J, "XPST0051"),
                    J = new nc(X)) : (H("Unknown atomic type " + X.toEQName() + " (SaxonJS is not schema-aware)", "XPST0051"),
                    J = void 0)
                }
                g()
            } else if (69 === u.J)
                switch (u.T) {
                case "item":
                    g();
                    e(204);
                    g();
                    J = oc;
                    break;
                case "function":
                    J = ma();
                    break;
                case "map":
                    J = qa();
                    break;
                case "array":
                    J = u;
                    g();
                    [207, 17].includes(J.J) ? (g(),
                    e(204),
                    g(),
                    J = Ac) : (J = B(),
                    e(204),
                    g(),
                    J = new ud(J));
                    break;
                case "empty-sequence":
                    g();
                    e(204);
                    g();
                    J = Cc;
                    break;
                case "switch":
                case "typeswitch":
                    H(u.T + "() is reserved in XPath; it is available only in XQuery");
                    break;
                default:
                    J = la()
                }
            else {
                if (4 === Ba && 208 === u.J)
                    return J = u.T,
                    g(),
                    h(1, J);
                if (4 === Ba && 70 === u.J)
                    return g(),
                    e(201),
                    J = u.T,
                    g(),
                    G(1, J);
                if (4 === Ba && 3 === u.J) {
                    g();
                    if (208 === u.J)
                        return J = u.T,
                        g(),
                        h(2, J);
                    if (70 === u.J)
                        return g(),
                        e(201),
                        J = u.T,
                        g(),
                        G(2, J);
                    H("Expected NodeTest after '@'");
                    return Sc
                }
                H("Expected type name in SequenceType, found " + oe[u.J]);
                return Sc
            }
            return J
        }
        function ma() {
            g();
            const J = [];
            if ([207, 17].includes(u.J))
                return g(),
                e(204),
                g(),
                wc;
            for (; 204 !== u.J; ) {
                var X = B();
                J.push(X);
                if (204 === u.J)
                    break;
                else
                    7 === u.J ? g() : H("Expected ',' or ')' after function argument type, found '" + oe[u.J] + "'")
            }
            g();
            if (71 === u.J)
                return g(),
                X = B(),
                new dd(J,X);
            0 < J.length ? H("Result type must be given if an argument type is given: expected 'as (type)'") : H("function() is not allowed for a general function type: must be function(*)");
            return null
        }
        function qa() {
            var J = u;
            g();
            if ([207, 17].includes(J.J))
                return g(),
                e(204),
                g(),
                yc;
            J = W();
            e(7);
            g();
            const X = B();
            e(204);
            g();
            return J instanceof nc ? new td(J,X) : (H("Key type of a map must be atomic"),
            null)
        }
        function L(J) {
            g();
            var X = u.J;
            if ([201, 35].includes(X))
                return ha(J);
            if (21 === X)
                return X = R(),
                e(5),
                M(X, J);
            if (5 === X)
                return X = z(),
                e(5),
                M(X, J);
            H("Unexpected " + oe[X] + " after '=>'");
            return null
        }
        function aa(J) {
            function X(ba) {
                return ba instanceof Ef || ba instanceof vg && X(ba.g)
            }
            switch (u.J) {
            case 21:
                return R();
            case 5:
                var ka = z();
                J && X(ka) && H("Predicate pattern cannot be parenthesized", "XTSE0340");
                return ka;
            case 4:
                return K();
            case 202:
                return I(!0);
            case 209:
                return D(!0);
            case 35:
                return ka = u.T,
                0 === Pa && 1 === Ba && (P.ng = !0,
                J ? Bh.includes(ka) || ka.includes(":") || H("Function " + ka + "() is not permitted at first position in pattern", "XTSE0340") : H("Function call not at first position in pattern", "XTSE0340")),
                ka = ha(null),
                P.ng = !1,
                ka;
            case 213:
                return ca(new Ef);
            case 205:
                return g(),
                new Ef(ua[ua.length - 1]);
            case 206:
                return g(),
                new Yf(9,null);
            case 69:
                if ("function" === u.T)
                    return ja();
            case 201:
            case 208:
            case 70:
            case 207:
                return ka = 3,
                69 === u.J && ["attribute", "schema-attribute"].includes(u.T) ? ka = 2 : 69 === u.J && "namespace-node" === u.T ? ka = 8 : J && 69 === u.J && "document-node" === u.T && (ka = 12),
                J = V(1),
                new Yf(ka,J);
            case 3:
                g();
                switch (u.J) {
                case 201:
                case 208:
                case 70:
                case 207:
                case 69:
                    return ka = V(2),
                    new Yf(2,ka);
                default:
                    H("@ must be followed by a NodeTest")
                }
                break;
            case 36:
                try {
                    ka = Pe(u.T)
                } catch (ba) {
                    H(ba.message),
                    ka = 3
                }
                J = Ne[ka];
                g();
                switch (u.J) {
                case 201:
                case 208:
                case 70:
                case 207:
                case 69:
                    J = V(J);
                    let ba = null;
                    if (2 === ka) {
                        const ta = sd.Nb(J, new Fc(2));
                        ta === sd.cc ? ba = "attribute axis can never yield nodes of type " + J : ta === sd.Rb && (J = new Fc(2))
                    }
                    3 === ka && 9 === J.kind && (ba = J.name + " nodes can never be children");
                    2 !== J.kind || [2, 12].includes(ka) || (ba = "axis " + Me(ka) + " can never yield attribute nodes");
                    if (ba) {
                        if (1 === Ba)
                            return new Xe(ba);
                        p(ba);
                        return nf()
                    }
                    return new Yf(ka,J);
                default:
                    H("Unexpected token " + E() + " after axis name")
                }
                break;
            case 60:
                switch (u.T) {
                case "map":
                    return x();
                case "array":
                    return U();
                case ".":
                    return Y();
                case "_":
                    H("Underscore functions not yet implemented")
                }
                break;
            case 43:
                return S();
            default:
                H("Unexpected token " + E() + " at start of expression")
            }
        }
        function z() {
            g();
            if (204 === u.J)
                return g(),
                nf();
            const J = k();
            e(204);
            g();
            return J
        }
        function D() {
            const J = u.T ? y(u.T) : H("Parser tokenization error NUMBER");
            isNaN(J) && H("Invalid numeric literal (" + u.T + ")");
            g();
            return mf([J], "AO" === J.code ? dc.de : "AD" === J.code ? dc.Fg : dc.Bd)
        }
        function y(J) {
            try {
                return 0 <= J.indexOf("e") || 0 <= J.indexOf("E") ? La.XS.double.fromString(J) : 0 <= J.indexOf(".") ? La.XS.mb.fromString(J) : La.XS.integer.fromString(J)
            } catch (X) {
                return NaN
            }
        }
        function I() {
            var J = new of(u.T);
            g();
            return J
        }
        function R() {
            g();
            e(201);
            var J = u.T;
            g();
            const X = va(J, "");
            J = fa(X);
            if (null != J)
                var ka = Tg(J);
            else if (X.uri === Zb.zi && 0 < Fa) {
                J = X.local;
                if ("code description value module line-number column-number".split(" ").includes(J))
                    return ka = new Bf(va("dynamic-error-info", Zb.wb),1),
                    ka = new Jf(ka,[mf([La.XS.string.fromString(J)], dc.ec)],dc.Aa);
                H("Unknown error variable " + X.toEQName(), "XPST0008")
            } else
                P.dg ? (ka = {
                    $a: X,
                    gd: function() {
                        return X
                    }
                },
                da(ka),
                ka = Tg(ka)) : H("No binding for variable " + X.toEQName(), "XPST0008");
            return ka
        }
        function M(J, X) {
            var ka = [];
            null != X && ka.push(X);
            X = null;
            g();
            if (204 !== u.J) {
                for (; ; ) {
                    var ba = Z();
                    if (null == ba || ba instanceof Qf)
                        null == X && (X = []),
                        X.push(ka.length);
                    ka.push(ba);
                    if (7 === u.J)
                        g();
                    else
                        break
                }
                e(204)
            }
            g();
            if (null == X) {
                var ta = ka;
                J instanceof Mf ? (X = Ch("FUNCTION", 1, "XPTY0004", "array:get"),
                ba = Og("XPTY0004", X),
                ta = Jg(ta[0], dc.Bd, ba, X, P),
                ka = new rh("get",2,wh.uri),
                J = qh(ka, [J, ta])) : (ta = new Mf(ta),
                ka = new rh("apply",2,zh.uri),
                X = Ch("FUNCTION", 0, "XPTY0004", "apply"),
                ba = Og("XPTY0004", X),
                J = Jg(J, dc.Qe, ba, X, P),
                J = qh(ka, [J, ta]))
            } else
                J = new Uf(J,ka,X);
            return J
        }
        function ca(J) {
            var X = u;
            xe(X, Je);
            X.J = 5;
            g();
            const ka = X.J;
            xe(X, ye);
            if (201 === ka)
                X = X.T,
                te(X) || H("The name following '?' must be a valid NCName"),
                g(),
                J = new Xg(J,new of(X));
            else if (209 === ka)
                X = X.T ? y(X.T) : H("Parser tokenization error NUMBER"),
                (isNaN(X) || "ADI" !== X.code) && H("Number following '?' must be an integer"),
                g(),
                J = ea(this, J, mf([X], dc.Bd));
            else if ([17, 207].includes(ka))
                g(),
                J = new Yg(J);
            else if (5 === ka)
                J = ea(this, J, z());
            else
                return H("Unexpected " + oe[ka] + " after '?'"),
                null;
            return J
        }
        function ea(J, X, ka) {
            if (Zc(X.l.fa)) {
                J = new eh;
                J.bc = Vc(X.l, 2);
                const ba = va("zibble", "")
                  , ta = Tg(J);
                J.$a = ba;
                J.j(X);
                da(J);
                J.g(new Xg(ta,ka));
                ia.pop();
                return J
            }
            return new Xg(X,ka)
        }
        function ja() {
            var J = u;
            const X = new Rf;
            X.g = [];
            for (var ka of ia)
                X.g.push(ka);
            X.B = [];
            X.j = [];
            Ua.push(X);
            g();
            var ba = [];
            ka = [];
            let ta = 0;
            for (; 204 !== J.J; ) {
                e(21);
                g();
                e(201);
                var Ca = va(J.T, "");
                for (var Ka of ba)
                    Ka.equals(Ca) && H("Duplicate parameter name $" + Ca.toString(), "XQST0039");
                ba.push(Ca);
                var Qa = dc.Aa;
                g();
                71 === J.J && (g(),
                Qa = B());
                const Xa = new Sf;
                Xa.l = Qa;
                Xa.bc = Qa;
                Xa.name = Ca;
                Xa.$a = Ca;
                Ca = ta++;
                Xa.slot = Ca;
                ka.push(Xa);
                da(Xa);
                if (204 === J.J)
                    break;
                else
                    7 === J.J ? g() : H("Expected ',' or ')' after function argument, found '" + oe[J.J] + "'")
            }
            xe(J, Je);
            g();
            if (71 === J.J) {
                xe(J, Ke);
                g();
                var ib = B()
            }
            e(59);
            xe(J, 0);
            g();
            215 === J.J ? (ze(J),
            g(),
            Ka = nf()) : (Ka = k(),
            e(215),
            ze(J),
            g(),
            ib || (ib = Ka.l));
            ib || (ib = dc.Aa);
            J = ba.length;
            for (ba = 0; ba < J; ba++)
                ia.pop();
            ib = new Tf(ka,ib,Ka);
            ia = X.g;
            Ua.pop();
            return ib
        }
        function Y() {
            var J = u;
            const X = new Rf;
            X.g = [];
            for (var ka of ia)
                X.g.push(ka);
            X.B = [];
            X.j = [];
            Ua.push(X);
            g();
            ka = [];
            var ba = La.XS.QName.fromParts("saxon", Zb.wb, "dot");
            const ta = new Sf;
            var Ca = dc.mc;
            ta.l = Ca;
            ta.bc = Ca;
            ta.name = ba;
            ta.$a = ba;
            ta.slot = 0;
            ka.push(ta);
            ba = new mh(Tg(ta),k());
            e(215);
            ze(J);
            g();
            J = new Tf(ka,ba.l,ba);
            ia = X.g;
            Ua.pop();
            return J
        }
        function V(J) {
            var X = u.T;
            switch (u.J) {
            case 201:
                g();
                var ka = X;
                X = va(ka, 1 === J ? P.hc() : "");
                1 === J && "" === X.getURI() && P.qe ? (ka = va(ka, "http://www.w3.org/1999/xhtml"),
                J = new xd(new nd(J,X),new nd(J,ka))) : J = new nd(J,X);
                return J;
            case 208:
                return g(),
                h(J, X);
            case 70:
                return g(),
                X = u.T,
                e(201),
                g(),
                G(J, X);
            case 207:
                return g(),
                ld(J);
            case 69:
                return la();
            default:
                throw H("Unrecognized node test"),
                new ve("");
            }
        }
        function la() {
            function J() {
                ka || H("No arguments are allowed in " + X + "()", "XPST0003")
            }
            const X = u.T;
            let ka = !1;
            g();
            204 === u.J && (ka = !0,
            g());
            switch (X) {
            case "item":
            case "switch":
            case "typeswitch":
                return H(X + "() is not allowed in a path expression"),
                null;
            case "node":
                return J(),
                qc;
            case "text":
                return J(),
                Ic;
            case "comment":
                return J(),
                Jc;
            case "namespace-node":
                if (ka)
                    return Lc;
                if (4 === Ba && 201 === u.J)
                    return g(),
                    e(204),
                    g(),
                    new od(13,"");
                H("No arguments are allowed in namespace-node()");
                return null;
            case "document-node":
                if (ka)
                    return Ec;
                if ("element" !== u.T)
                    return H("Argument to document-node() must be an element type"),
                    null;
                var ba = la();
                e(204);
                g();
                return new qd(kc(ba));
            case "processing-instruction":
                if (ka)
                    return Kc;
                202 === u.J ? ba = u.T ? Ha.trim(unescape(u.T)) : H("Parser tokenization error STRING_LIITERAL") : 201 === u.J ? ba = u.T : H("Processing instruction name must be an NCName or a string literal");
                te(ba) || H("Processing instruction name must be a valid NCName: '" + ba + "' is not");
                /^[Xx][Mm][Ll]$/.test(ba) && H("Processing instruction name must not be 'xml'");
                g();
                e(204);
                g();
                return new nd(7,La.XS.QName.fromParts("", "", ba));
            case "attribute":
            case "element":
                ba = "element" === X ? 1 : 2;
                let Ca = "";
                var ta = !1;
                if (ka)
                    return ld(ba);
                [207, 17].includes(u.J) ? Ca = "*" : 201 === u.J ? Ca = u.T : 70 === u.J ? (g(),
                ta = !0,
                Ca = u.T) : (H("Unexpected " + oe[u.J] + " after '(' in SequenceType"),
                Ca = "*");
                g();
                if (204 === u.J)
                    return g(),
                    "*" === Ca ? ld(ba) : ta ? new od(ba,Ca) : new nd(ba,q(Ca, P.vb, 1 === ba ? P.hc : ()=>""));
                if (7 === u.J) {
                    g();
                    e(201);
                    ta = !1;
                    const Ka = q(u.T, P.vb, P.hc);
                    Ka.uri === Zb.lc ? 1 === ba ? ["untyped", "anyType"].includes(Ka.local) || (["untypedAtomic", "anyAtomicType"].includes(Ka.local) ? ta = !0 : H("Unsupported type annotation " + u.T + " (SaxonJS is not schema-aware, so all nodes are untyped)")) : ["untypedAtomic", "anyAtomicType"].includes(Ka.local) || H("Unsupported type annotation " + u.T + " (SaxonJS is not schema-aware, so all nodes are untyped)") : H("Unsupported type annotation " + u.T + " (SaxonJS is not schema-aware, so only built-in types are recognized)");
                    g();
                    213 === u.J && g();
                    e(204);
                    g();
                    if (ta)
                        return Cc;
                    if ("*" === Ca)
                        return ld(ba);
                    Ca = q(Ca, P.vb, 1 === ba ? P.hc : ()=>"");
                    return new nd(ba,Ca)
                }
                H("Expected ')' or ',' in SequenceType");
                return null;
            case "schema-attribute":
            case "schema-element":
                return H("Type " + X + "() not allowed: SaxonJS is not schema-aware"),
                null;
            default:
                return H("Unknown node kind " + X),
                null
            }
        }
        function x() {
            var J = [];
            g();
            var X = [];
            let ka = !0;
            if (215 !== u.J)
                for (; ; ) {
                    var ba = v();
                    e(75);
                    g();
                    const ta = v()
                      , Ca = Ch("FUNCTION", 0, "", "map:entry")
                      , Ka = Og("XPTY0004", Ca);
                    ba = Jg(ba, dc.Oe, Ka, Ca, P);
                    !ka || ba instanceof lf ? -1 === X.indexOf(ba) ? X.push(ba) : ka = !1 : ka = !1;
                    ba = new Wf(ba,ta);
                    J.push(ba);
                    if (215 === u.J)
                        break;
                    else
                        e(7),
                        g()
                }
            ze(u);
            g();
            if (0 === J.length)
                return qh(new rh("_new",1,uh.uri), []);
            if (1 === J.length)
                return J[0];
            if (ka) {
                const ta = [];
                J.forEach(Ca=>{
                    ta.push([Ca.key, Ca.value])
                }
                );
                return new Xf(ta)
            }
            J = new Pg(J);
            X = [];
            X = new Xf([[new of("duplicates"), new of("reject")], [new of("duplicates-error-code"), new of("XQDY0137")]]);
            return qh(new rh("merge",2,uh.uri), [J, X])
        }
        function K() {
            const J = [];
            g();
            if (203 === u.J)
                return g(),
                new Mf(J);
            for (; ; ) {
                const X = v();
                J.push(X);
                if (7 === u.J)
                    g();
                else {
                    if (203 === u.J) {
                        g();
                        break
                    }
                    H("Expected ',' or ']', found " + oe[u.J])
                }
            }
            return new Mf(J)
        }
        function U() {
            g();
            const J = new rh("_from-sequence",1,wh.uri);
            if (215 === u.J)
                return ze(u),
                g(),
                qh(J, [nf()]);
            const X = k();
            e(215);
            ze(u);
            g();
            return qh(J, [X])
        }
        function ha(J) {
            function X() {
                if (209 === u.J)
                    return D(!0);
                if (202 === u.J)
                    return I(u.T);
                if (21 === u.J)
                    return R();
                H("The arguments to a function call in a pattern must be literals or variable references", "XTSE0340")
            }
            var ka = u.T
              , ba = u.je;
            const ta = [];
            null != J && ta.push(J);
            J = w(ka);
            ka = null;
            1 === Ba && J.uri === Zb.Oa && ["current-group", "current-grouping-key", "current-merge-group", "current-merge-key"].includes(J.local) && H(J.local + "() is not permitted in a pattern", "XTSE1060");
            g();
            if (204 !== u.J) {
                for (; ; ) {
                    var Ca = P.ng ? X() : Z();
                    if (null == Ca || Ca instanceof Qf)
                        null == ka && (ka = []),
                        ka.push(ta.length);
                    ta.push(Ca);
                    if (7 === u.J)
                        g();
                    else
                        break
                }
                e(204)
            }
            g();
            Ca = new Bf(J,ta.length);
            if (null != ka)
                return ba = P.ef().fg(Ca, P),
                null == ba && H("No function " + J.toString() + "#" + ta.length + " is known for partial application", "XPST0017"),
                new Uf(ba,ta,ka);
            ka = [];
            Ca = P.ef().bind(Ca, ta, P, ka);
            return null == Ca ? T(P, ba, J, ta, ka) : Ca
        }
        function T(J, X, ka, ba, ta) {
            let Ca = "Cannot find a " + ba.length + "-argument function named " + ka.toEQName() + "()";
            for (var Ka of ta)
                Ca += ". " + Ka;
            ta = !1;
            for (Ka = 0; Ka < ba.length + 5; Ka++)
                if (Ka !== ba.length) {
                    const Qa = new Bf(ka,Ka);
                    if (J.ef().fg(Qa, J)) {
                        ta = !0;
                        break
                    }
                }
            ta ? Ca += ". The namespace URI and local name are recognized, but the number of arguments is wrong" : (ba = ka.uri,
            ka = ba === Zb.Wc ? "original" === ka.local ? "Function name xsl:original is only available within an overriding function" : "There are no functions defined in the XSLT namespace" : ba === Zb.wb ? "Most Saxon extension functions are not available under SaxonJS" : ba.startsWith("java:") ? "Calls to Java methods are not available under SaxonJS" : ba.startsWith("clitype:") ? "Calls to .NET methods are not available under SaxonJS" : null,
            null != ka && (Ca += ka));
            if (J.te())
                return Df("error", [Df("QName", [new of(""), new of("XTDE1425")]), new of(Ca)]);
            H(Ca, "XPST0017", X)
        }
        function w(J) {
            let X = null;
            try {
                X = q(J, P.vb, P.ph)
            } catch (ka) {
                H(ka.message, ka.code)
            }
            return X
        }
        function Z() {
            return 213 === u.J && [7, 204].includes(u.j) ? (g(),
            new Qf) : v()
        }
        function S() {
            var J = u
              , X = J.T;
            const ka = J.je;
            var ba = P;
            g();
            e(209);
            J = J.T ? y(J.T) : H("Parser tokenization error NUMBER");
            isNaN(J) || "ADI" !== J.code ? H("Number following '#' is invalid") : (0 > J.value || J.value > Number.MAX_SAFE_INTEGER) && H("Number following '#' is out of range", "FOAR0002");
            J = J.value;
            g();
            let ta = null;
            try {
                ta = q(X, ba.vb, ba.ph)
            } catch (Ka) {
                H(Ka.message, Ka.code)
            }
            X = ba.ef();
            const Ca = new Bf(ta,J);
            ba = X.fg(Ca, ba);
            null == ba && H("Function " + ta.toEQName() + "#" + J + " not found", "XPST0017", ka);
            return ba.xb.wh && !ta.hasURI(re.ci) ? new Pf(ba) : new Of(ba)
        }
        function da(J) {
            J.slot = ia.length;
            ia.push(J)
        }
        function fa(J) {
            for (let X = ia.length - 1; 0 <= X; X--) {
                const ka = ia[X];
                if (ka && ka.gd().equals(J))
                    return ka
            }
        }
        function na(J, X) {
            return q(J, P.vb, ()=>X)
        }
        function va(J, X) {
            try {
                return na(J, X)
            } catch (ka) {
                H(ka.message, ka.code)
            }
        }
        function h(J, X) {
            if (X.startsWith("Q{"))
                return new pd(J,X.substring(2, X.length - 2));
            try {
                const ka = q(X + ":dummy", P.vb, ()=>"");
                return new pd(J,ka.getURI())
            } catch (ka) {
                return H(ka.message, ka.code),
                null
            }
        }
        function G(J, X) {
            te(X) || H("Local name [" + X + "] contains invalid characters");
            return new od(J,X)
        }
        function Q(J, X, ka, ba=!1) {
            this.global = ba;
            this.$a = this.name = J;
            this.bc = X;
            this.slot = ka
        }
        let u, N, P = {}, ia = [], ua = [], Ba = 0, Fa = 0, Pa = 0;
        const Ua = []
          , Na = {
            fg: function(J, X) {
                X = X.getContext();
                return (X = Eh.getFnSignature(J.name, J.arity, X)) ? new Vf(J,X) : null
            },
            bind: function(J, X, ka) {
                var ba = ka.getContext()
                  , ta = Eh.getFnSignature(J.name, J.arity, ba);
                if (ta) {
                    if (J.name.uri === Zb.Oa)
                        switch (J.name.local) {
                        case "false":
                            return mf([La.XS.boolean.ae], dc.cb);
                        case "true":
                            return mf([La.XS.boolean.Xc], dc.cb);
                        case "normalize-unicode":
                            1 === X.length && X.push(new of("NFC"));
                            break;
                        case "copy-of":
                            return new ah(X[0] ? X[0] : new Ef(ua[ua.length - 1]));
                        case "current-group":
                            return new Zg;
                        case "current-grouping-key":
                            return new $g;
                        default:
                            ta.defaultToDot && 0 === J.arity && ta.arity.includes(0) && (X.push(new Ef(ua[ua.length - 1])),
                            J.arity++)
                        }
                    else if (ta.isIdempotent && 1 === X.length)
                        return X[0];
                    ba = [];
                    var Ca;
                    const Qa = ta.alphaTree;
                    Qa && "F" === Qa.p && !Qa.r && (Qa.r = {
                        p: "",
                        o: "*"
                    });
                    Qa && "F" === Qa.p && Qa.a && Qa.r || sa.la("Bad function signature for " + J.name.local);
                    ta.variadic && (Ca = Qa.a[0]);
                    const ib = ta.collation || -1;
                    for (let Xa = 0; Xa < X.length; Xa++) {
                        var Ka = Ca ? Ca : Qa.a[Xa];
                        const ob = Ch("FUNCTION", Xa, "", J.name.toString())
                          , pb = Og("XPTY0004", ob);
                        Xa === ib ? (Ka = Jg(X[Xa], "?" === Ka.o ? dc.Dg : dc.ec, pb, ob, ka),
                        Ka = Df("resolve-uri", [Ka, Df("static-base-uri", [])]),
                        Ka.l = dc.Bg,
                        ba.push(Ka)) : ba.push(Jg(X[Xa], ic(Ka), pb, ob, ka))
                    }
                    ib > X.length - 1 && ba.push(new of(ka.Ub));
                    X = ic(Qa.r);
                    if (ta.isUserFunction)
                        return new Nf(J,ba,X,ta.componentBinding);
                    switch (J.name.uri) {
                    case Zb.Oa:
                    case Zb.lc:
                        switch (J.name.local) {
                        case "current":
                            ua[0] && (X = ua[0]);
                            break;
                        case "accumulator-before":
                        case "accumulator-after":
                            if (ba[0]instanceof of) {
                                ta = q(ba[0].value[0].value, ka.vb, ()=>"").toEQName();
                                ka = ka.Gb[ta];
                                if (!ka)
                                    throw new F("Unknown accumulator " + ta,"XTDE3340");
                                X = ec(ka);
                                ba[0] = new of(ta)
                            }
                        }
                        return new Cf(J,ba,X);
                    case Zb.map:
                        return new Gf(J,ba,X);
                    case Zb.Ue:
                        return new Hf(J,ba,X);
                    case Zb.yh:
                        return new If(J,ba,X);
                    case Zb.wb:
                        return new Jf(J,ba,X);
                    case Zb.nd:
                        return new Kf(J,ba,X);
                    case Zb.xh:
                        return new Lf(J,ba,X);
                    default:
                        return ta.wh ? new Nf(J,ba,X,ta.Jk) : new Jf(J,ba,X)
                    }
                } else {
                    if (ta = Eh.getFnSignature(J.name, null, ba))
                        if (ta && !ta.alphaTree && (ta.alphaTree = rb(ta.sig)),
                        ba = X.length,
                        Ca = ta.alphaTree.a.length,
                        ba !== Ca && (ta.variadic ? X.length < Ca : !(ta.arity || []).includes(ba)))
                            throw new F("Wrong argument arity " + X.length + " for function " + J.name.local + "()","XPST0017");
                    if (ka.Tb)
                        return Df("error", [Df("QName", [new of(""), new of("XTDE1425")]), new of("Unknown function " + J.toString())]);
                    throw new F("Unknown function " + J.toEQName() + "()","XPST0017");
                }
            }
        };
        P = {
            hc: ()=>"",
            Ub: "http://www.w3.org/2005/xpath-functions/collation/codepoint",
            qe: !1,
            fb: {},
            Gb: {},
            bb: !1,
            Jc: !1,
            dg: !1,
            Tb: !1,
            Fj: function() {
                P.hc = ()=>"";
                P.Ub = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
                P.fb = {};
                P.Gb = {};
                P.bb = !1;
                P.Jc = !1;
                P.dg = !1;
                P.Tb = !1
            },
            getContext: function() {
                return {
                    bb: P.bb,
                    Wk: 1 === Ba,
                    fb: P.fb
                }
            },
            Ni: function() {
                return P.Ub
            },
            ph: function() {
                return Zb.Oa
            },
            ef: function() {
                return Na
            },
            Qk: function() {
                return null
            },
            Vk: function() {
                return !1
            },
            te: function() {
                return P.Tb
            },
            bl: function() {
                return null
            }
        };
        let Wa = {};
        Q.prototype.gd = function() {
            return this.name
        }
        ;
        return {
            process: function(J, X, ka, ba, ta=!1, Ca=!1, Ka=!1) {
                a();
                N = J;
                Ba = X ? 1 : 0;
                J = [];
                Wa = {};
                P.Fj();
                P.vb = c;
                X && (P.bb = !0);
                Ka && (P.dg = !0);
                if (ba) {
                    Fa = ba.hf ? 1 : 0;
                    ba.Jc && (P.Jc = !0);
                    for (var Qa in ba.namespaces)
                        Wa[Qa] = ba.namespaces[Qa];
                    for (var ib in ba.Hc) {
                        Qa = q(ib, P.vb, ()=>"");
                        const pb = ba.Hc[ib]
                          , Kh = ec(pb.getAttribute("sType"));
                        J.push(new Q(Qa,Kh,pb,!0))
                    }
                    for (var Xa in ba.ac)
                        ib = q(Xa, P.vb, ()=>""),
                        J.push(new Q(ib,ba.wd[Xa],ba.ac[Xa]));
                    ia = J;
                    P.Gb = ba.Gb;
                    ba.qe && (P.qe = ba.qe);
                    ba.Ub && (P.Ub = ba.Ub);
                    ba.fb && (P.fb = ba.fb);
                    ba.bb && (P.bb = ba.bb);
                    ba.Tb && (P.Tb = ba.Tb);
                    ba.ye && (ua = [Vc(ba.ye, 2)]);
                    ba.xpathDefaultNamespace && (P.hc = ()=>ba.xpathDefaultNamespace);
                    P.Ia = ba.Ia ? ba.Ia : null
                }
                Xa = "";
                for (const pb in Wa)
                    J = Wa[pb],
                    J = J === Zb.withPrefix[pb] ? "~" : J,
                    Xa += pb + "=" + J + " ";
                De(u, N);
                let ob;
                try {
                    ob = k(Ca)
                } catch (pb) {
                    throw pb instanceof F && ba && ba.Lj && (pb.code = ba.Lj,
                    pb.message = "Invalid XPath expression supplied to xsl:evaluate {" + N + "}: " + pb.message),
                    pb;
                }
                0 !== u.J && H("Found " + E() + " beyond end of expression");
                X ? (ob = ob.Ga(),
                ob instanceof hf && ka && (ob = new jf(gf(ob)))) : ba && ba.De && (X = Ch("EVALUATE_RESULT", 0, "", null),
                ka = Og("XPTY0004", X),
                ob = Jg(ob, ba.De, ka, X));
                X = ta ? new Fh : new Gh;
                ob.G(X);
                X = X.current;
                ta ? (X = X.documentElement,
                ob.l && X.setAttribute("sType", ob.l.ha()),
                "" !== Xa && X.setAttribute("ns", Xa),
                ba && ba.Ia && X.setAttribute("baseUri", ba.Ia)) : (X = X.C[0],
                "" !== Xa && (X.gl = Xa),
                ba && ba.Ia && (X.pb = ba.Ia),
                Ka && 0 < ia.length && (X.Ii = ia.map(pb=>pb.$a.toEQName())));
                return X
            },
            parseSequenceType: function(J, X, ka) {
                a();
                P.vb = X;
                P.hc = ka;
                Ba = 0;
                Wa = {};
                De(u, J);
                J = B();
                0 !== u.J && H("Unexpected " + E() + " after SequenceType");
                return J
            },
            getTokenizer: function() {
                return u
            }
        }
    }();
    function Gh() {
        this.g = [];
        this.current = {
            C: []
        }
    }
    Gh.prototype = {
        start: function(a, c={}) {
            a = {
                N: a,
                C: []
            };
            for (const q in c)
                a[q] = c[q];
            this.current.C.push(a);
            this.g.push(this.current);
            this.current = a
        },
        ud: function(a, c) {
            this.current[a] = c
        },
        end: function() {
            this.current = this.g.pop()
        }
    };
    function Fh() {
        this.j = Jd.find("SaxonJS").getPlatform().createDocument();
        this.g = [];
        this.current = this.j
    }
    Fh.prototype = {
        start: function(a, c={}) {
            a = this.j.createElement(a);
            for (const q in c)
                a.setAttribute(q, c[q]);
            this.current.appendChild(a);
            this.g.push(this.current);
            this.current = a
        },
        ud: function(a, c) {
            this.current.setAttribute(a, c)
        },
        end: function() {
            this.current = this.g.pop()
        }
    };
    // Input 70
    const Ih = {
        ul: {
            QuantifiedExpr: "1AB",
            OrExpr: "1AB",
            AndExpr: "1AB",
            ComparisonExpr: "1AB",
            StringConcatExpr: "1AS",
            RangeExpr: "*ADI",
            AdditiveExpr: "?A",
            MultiplicativeExpr: "?A",
            IntersectExceptExpr: "*N",
            InstanceOfExpr: "1AB",
            CastableExpr: "1AB",
            UnaryExpr: "?A m[UO,UD,UF]",
            StringLiteral: "1AS",
            IntegerLiteral: "1ADI",
            DecimalLiteral: "1AD",
            DoubleLiteral: "1AO",
            NamedFunctionRef: "1F",
            InlineFunctionExpr: "1F",
            MapExpr: "1FM",
            Root: "1ND"
        },
        Qj: {
            "http://www.w3.org/2005/xpath-functions": {
                QName: {
                    sig: "1F r[1AQ] a[?AS,1AS]"
                },
                abs: {
                    sig: "1F r[?A m[AO,AD,AF]] a[?A m[AO,AD,AF]]"
                },
                "accumulator-after": {
                    XSLTonly: !0,
                    sig: "1F a[1AS] r[*]"
                },
                "accumulator-before": {
                    XSLTonly: !0,
                    sig: "1F a[1AS] r[*]"
                },
                "adjust-date-to-timezone": {
                    arity: [1, 2],
                    sig: "1F r[?AA] a[?AA,?ARD]"
                },
                "adjust-dateTime-to-timezone": {
                    arity: [1, 2],
                    sig: "1F r[?AM] a[?AM,?ARD]"
                },
                "adjust-time-to-timezone": {
                    arity: [1, 2],
                    sig: "1F r[?AT] a[?AT,?ARD]"
                },
                "analyze-string": {
                    arity: [2, 3],
                    sig: "1F r[1NE nQ{http://www.w3.org/2005/xpath-functions}analyze-string-result] a[?AS,1AS,1AS]"
                },
                apply: {
                    sig: "1F a[1F,1FA] r[*]"
                },
                "available-environment-variables": {
                    sig: "1F r[*AS] a[]"
                },
                "available-system-properties": {
                    XSLTonly: !0,
                    sig: "1F r[*AQ] a[]"
                },
                avg: {
                    sig: "1F r[?A] a[*A]"
                },
                "base-uri": {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[?AU] a[?N]"
                },
                "boolean": {
                    sig: "1F r[1AB] a[*]"
                },
                ceiling: {
                    sig: "1F r[?A m[AO,AD,AF]] a[?A m[AO,AD,AF]]"
                },
                "codepoint-equal": {
                    sig: "1F r[?AB] a[?AS,?AS]"
                },
                "codepoints-to-string": {
                    sig: "1F r[1AS] a[*ADI]"
                },
                "collation-key": {
                    arity: [1, 2],
                    collation: 1,
                    sig: "1F r[1A2] a[1AS,1AS]"
                },
                collection: {
                    arity: [0, 1],
                    sig: "1F a[?AS] r[*]"
                },
                compare: {
                    arity: [2, 3],
                    collation: 2,
                    sig: "1F r[?ADI] a[?AS,?AS,1AS]"
                },
                concat: {
                    arity: [2, Infinity],
                    sig: "1F r[1AS] a[?A,?A]",
                    variadic: !0
                },
                contains: {
                    arity: [2, 3],
                    collation: 2,
                    sig: "1F r[1AB] a[?AS,?AS,1AS]"
                },
                "contains-token": {
                    arity: [2, 3],
                    collation: 2,
                    sig: "1F r[1AB] a[*AS,1AS,1AS]"
                },
                "copy-of": {
                    XSLTonly: !0,
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F a[*] r[*]"
                },
                count: {
                    sig: "1F r[1ADI] a[*]"
                },
                current: {
                    XSLTonly: !0,
                    sig: "1F r[1] a[]"
                },
                "current-date": {
                    sig: "1F r[1AA] a[]"
                },
                "current-dateTime": {
                    sig: "1F r[1AMP] a[]"
                },
                "current-group": {
                    XSLTonly: !0,
                    sig: "1F a[] r[*]"
                },
                "current-grouping-key": {
                    XSLTonly: !0,
                    sig: "1F r[*A] a[]"
                },
                "current-merge-group": {
                    XSLTonly: !0,
                    arity: [0, 1],
                    sig: "1F a[1AS] r[*]"
                },
                "current-merge-key": {
                    XSLTonly: !0,
                    sig: "1F r[*A] a[]"
                },
                "current-output-uri": {
                    XSLTonly: !0,
                    sig: "1F r[?AU] a[]"
                },
                "current-time": {
                    sig: "1F r[1AT] a[]"
                },
                data: {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[*A] a[*]"
                },
                dateTime: {
                    sig: "1F r[?AM] a[?AA,?AT]"
                },
                "day-from-date": {
                    sig: "1F r[?ADI] a[?AA]"
                },
                "day-from-dateTime": {
                    sig: "1F r[?ADI] a[?AM]"
                },
                "days-from-duration": {
                    sig: "1F r[?ADI] a[?AR]"
                },
                "deep-equal": {
                    arity: [2, 3],
                    collation: 2,
                    sig: "1F r[1AB] a[*,*,1AS]"
                },
                "default-collation": {
                    sig: "1F r[1AS] a[]"
                },
                "default-language": {
                    sig: "1F r[1ASNTL] a[]"
                },
                "distinct-values": {
                    arity: [1, 2],
                    collation: 1,
                    sig: "1F r[*A] a[*A,1AS]"
                },
                doc: {
                    sig: "1F r[?ND] a[?AS]"
                },
                "doc-available": {
                    sig: "1F r[1AB] a[?AS]"
                },
                document: {
                    XSLTonly: !0,
                    arity: [1, 2],
                    sig: "1F r[*N] a[*,1N]"
                },
                "document-uri": {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[?AU] a[?N]"
                },
                "element-available": {
                    XSLTonly: !0,
                    sig: "1F r[1AB] a[1AS]"
                },
                "element-with-id": {
                    defaultToDot: !0,
                    arity: [1, 2],
                    sig: "1F r[*NE] a[*AS,1N]"
                },
                empty: {
                    sig: "1F r[1AB] a[*]"
                },
                "encode-for-uri": {
                    sig: "1F r[1AS] a[?AS]"
                },
                "ends-with": {
                    arity: [2, 3],
                    collation: 2,
                    sig: "1F r[1AB] a[?AS,?AS,1AS]"
                },
                "environment-variable": {
                    sig: "1F r[?AS] a[1AS]"
                },
                error: {
                    arity: [0, 1, 2, 3],
                    sig: "1F r[0E] a[?AQ,1AS,*]"
                },
                "escape-html-uri": {
                    sig: "1F r[1AS] a[?AS]"
                },
                "exactly-one": {
                    sig: "1F r[1] a[*]"
                },
                exists: {
                    sig: "1F r[1AB] a[*]"
                },
                "false": {
                    sig: "1F r[1AB] a[]"
                },
                filter: {
                    sig: "1F r[*] a[*,1F r[1AB] a[1]]"
                },
                floor: {
                    sig: "1F r[?A m[AO,AD,AF]] a[?A m[AO,AD,AF]]"
                },
                "fold-left": {
                    sig: "1F a[*,*,1F a[*,1] r[*]] r[*]"
                },
                "fold-right": {
                    sig: "1F a[*,*,1F a[1,*] r[*]] r[*]"
                },
                "for-each": {
                    sig: "1F a[*,1F a[1] r[*]] r[*]"
                },
                "for-each-pair": {
                    sig: "1F a[*,*,1F a[1,1] r[*]] r[*]"
                },
                "format-date": {
                    arity: [2, 5],
                    sig: "1F r[?AS] a[?AA,1AS,?AS,?AS,?AS]"
                },
                "format-dateTime": {
                    arity: [2, 5],
                    sig: "1F r[?AS] a[?AM,1AS,?AS,?AS,?AS]"
                },
                "format-integer": {
                    arity: [2, 3],
                    sig: "1F r[1AS] a[?ADI,1AS,?AS]"
                },
                "format-number": {
                    arity: [2, 3],
                    sig: "1F r[1AS] a[?A m[AO,AD,AF],1AS,?AS]"
                },
                "format-time": {
                    arity: [2, 5],
                    sig: "1F r[?AS] a[?AT,1AS,?AS,?AS,?AS]"
                },
                "function-arity": {
                    sig: "1F r[1ADI] a[1F]"
                },
                "function-available": {
                    XSLTonly: !0,
                    arity: [1, 2],
                    sig: "1F r[1AB] a[1AS,1ADI]"
                },
                "function-lookup": {
                    sig: "1F r[?F] a[1AQ,1ADI]"
                },
                "function-name": {
                    sig: "1F r[?AQ] a[1F]"
                },
                "generate-id": {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[1AS] a[?N]"
                },
                "has-children": {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[1AB] a[?N]"
                },
                head: {
                    sig: "1F r[?] a[*]"
                },
                "hours-from-dateTime": {
                    sig: "1F r[?ADI] a[?AM]"
                },
                "hours-from-duration": {
                    sig: "1F r[?ADI] a[?AR]"
                },
                "hours-from-time": {
                    sig: "1F r[?ADI] a[?AT]"
                },
                id: {
                    defaultToDot: !0,
                    arity: [1, 2],
                    sig: "1F r[*NE] a[*AS,1N]"
                },
                idref: {
                    defaultToDot: !0,
                    arity: [1, 2],
                    sig: "1F r[*N] a[*AS,1N]"
                },
                "implicit-timezone": {
                    sig: "1F r[1ARD] a[]"
                },
                "in-scope-prefixes": {
                    sig: "1F r[*AS] a[1NE]"
                },
                "index-of": {
                    arity: [2, 3],
                    collation: 2,
                    sig: "1F r[*ADI] a[*A,1A,1AS]"
                },
                innermost: {
                    sig: "1F r[*N] a[*N]"
                },
                "insert-before": {
                    sig: "1F a[*,1ADI,*] r[*]"
                },
                "iri-to-uri": {
                    sig: "1F r[1AS] a[?AS]"
                },
                "json-doc": {
                    arity: [1, 2],
                    sig: "1F r[?] a[?AS,1FM]"
                },
                "json-to-xml": {
                    arity: [1, 2],
                    sig: "1F r[?ND] a[?AS,1FM]"
                },
                key: {
                    XSLTonly: !0,
                    arity: [2, 3],
                    sig: "1F r[*N] a[1AS,*A,1N]"
                },
                lang: {
                    defaultToDot: !0,
                    arity: [1, 2],
                    sig: "1F r[1AB] a[?AS,1N]"
                },
                last: {
                    sig: "1F r[1ADI] a[]"
                },
                "load-xquery-module": {
                    arity: [1, 2],
                    sig: "1F r[1FM] a[1AS,1FM]"
                },
                "local-name": {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[1AS] a[?N]"
                },
                "local-name-from-QName": {
                    sig: "1F r[?ASNTNC] a[?AQ]"
                },
                "lower-case": {
                    sig: "1F r[1AS] a[?AS]"
                },
                matches: {
                    arity: [2, 3],
                    sig: "1F r[1AB] a[?AS,1AS,1AS]"
                },
                max: {
                    arity: [1, 2],
                    collation: 1,
                    sig: "1F r[?A] a[*A,1AS]"
                },
                min: {
                    arity: [1, 2],
                    collation: 1,
                    sig: "1F r[?A] a[*A,1AS]"
                },
                "minutes-from-dateTime": {
                    sig: "1F r[?ADI] a[?AM]"
                },
                "minutes-from-duration": {
                    sig: "1F r[?ADI] a[?AR]"
                },
                "minutes-from-time": {
                    sig: "1F r[?ADI] a[?AT]"
                },
                "month-from-date": {
                    sig: "1F r[?ADI] a[?AA]"
                },
                "month-from-dateTime": {
                    sig: "1F r[?ADI] a[?AM]"
                },
                "months-from-duration": {
                    sig: "1F r[?ADI] a[?AR]"
                },
                name: {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[1AS] a[?N]"
                },
                "namespace-uri": {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[1AU] a[?N]"
                },
                "namespace-uri-for-prefix": {
                    sig: "1F r[?AU] a[?AS,1NE]"
                },
                "namespace-uri-from-QName": {
                    sig: "1F r[?AU] a[?AQ]"
                },
                nilled: {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[?AB] a[?N]"
                },
                "node-name": {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[?AQ] a[?N]"
                },
                "normalize-space": {
                    arity: [0, 1],
                    sig: "1F r[1AS] a[?AS]"
                },
                "normalize-unicode": {
                    arity: [1, 2],
                    sig: "1F r[1AS] a[?AS,1AS]"
                },
                not: {
                    sig: "1F r[1AB] a[*]"
                },
                number: {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[1AO] a[?A]"
                },
                "one-or-more": {
                    sig: "1F r[+] a[*]"
                },
                outermost: {
                    sig: "1F r[*N] a[*N]"
                },
                "parse-ietf-date": {
                    sig: "1F r[?AM] a[?AS]"
                },
                "parse-json": {
                    arity: [1, 2],
                    sig: "1F r[?] a[?AS,1FM]"
                },
                "parse-xml": {
                    sig: "1F r[?ND e[NE]] a[?AS]"
                },
                "parse-xml-fragment": {
                    sig: "1F r[?ND] a[?AS]"
                },
                path: {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[?AS] a[?N]"
                },
                position: {
                    sig: "1F r[1ADI] a[]"
                },
                "prefix-from-QName": {
                    sig: "1F r[?ASNTNC] a[?AQ]"
                },
                "random-number-generator": {
                    arity: [0, 1],
                    sig: "1F r[1FM k[AS] v[1]] a[?A]"
                },
                "regex-group": {
                    XSLTonly: !0,
                    sig: "1F r[1AS] a[1ADI]"
                },
                remove: {
                    sig: "1F r[*] a[*,1ADI]"
                },
                replace: {
                    arity: [3, 4],
                    sig: "1F r[1AS] a[?AS,1AS,1AS,1AS]"
                },
                "resolve-QName": {
                    sig: "1F r[?AQ] a[?AS,1NE]"
                },
                "resolve-uri": {
                    arity: [1, 2],
                    sig: "1F r[?AU] a[?AS,1AS]"
                },
                reverse: {
                    sig: "1F a[*] r[*]"
                },
                root: {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[?N] a[?N]"
                },
                round: {
                    arity: [1, 2],
                    sig: "1F r[?A m[AO,AD,AF]] a[?A m[AO,AD,AF],1ADI]"
                },
                "round-half-to-even": {
                    arity: [1, 2],
                    sig: "1F r[?A m[AO,AD,AF]] a[?A m[AO,AD,AF],1ADI]"
                },
                "seconds-from-dateTime": {
                    sig: "1F r[?AD] a[?AM]"
                },
                "seconds-from-duration": {
                    sig: "1F r[?AD] a[?AR]"
                },
                "seconds-from-time": {
                    sig: "1F r[?AD] a[?AT]"
                },
                serialize: {
                    arity: [1, 2],
                    sig: "1F r[1AS] a[*,?]"
                },
                snapshot: {
                    XSLTonly: !0,
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F a[*] r[*]"
                },
                sort: {
                    arity: [1, 2, 3],
                    collation: 1,
                    sig: "1F r[*] a[*,?AS,1F r[*A] a[1]]"
                },
                "starts-with": {
                    arity: [2, 3],
                    collation: 2,
                    sig: "1F r[1AB] a[?AS,?AS,1AS]"
                },
                "static-base-uri": {
                    sig: "1F r[?AU] a[]"
                },
                "stream-available": {
                    XSLTonly: !0,
                    sig: "1F r[1AB] a[?AS]"
                },
                string: {
                    defaultToDot: !0,
                    arity: [0, 1],
                    sig: "1F r[1AS] a[?]"
                },
                "string-join": {
                    arity: [1, 2],
                    sig: "1F r[1AS] a[*A,1AS]"
                },
                "string-length": {
                    arity: [0, 1],
                    sig: "1F r[1ADI] a[?AS]"
                },
                "string-to-codepoints": {
                    sig: "1F r[*ADI] a[?AS]"
                },
                subsequence: {
                    arity: [2, 3],
                    sig: "1F a[*,1AO,1AO] r[*]"
                },
                substring: {
                    arity: [2, 3],
                    sig: "1F r[1AS] a[?AS,1AO,1AO]"
                },
                "substring-after": {
                    arity: [2, 3],
                    collation: 2,
                    sig: "1F r[1AS] a[?AS,?AS,1AS]"
                },
                "substring-before": {
                    arity: [2, 3],
                    collation: 2,
                    sig: "1F r[1AS] a[?AS,?AS,1AS]"
                },
                sum: {
                    arity: [1, 2],
                    sig: "1F r[?A] a[*A,?A]"
                },
                "system-property": {
                    XSLTonly: !0,
                    sig: "1F r[1AS] a[1AS]"
                },
                tail: {
                    sig: "1F a[*] r[*]"
                },
                "timezone-from-date": {
                    sig: "1F r[?ARD] a[?AA]"
                },
                "timezone-from-dateTime": {
                    sig: "1F r[?ARD] a[?AM]"
                },
                "timezone-from-time": {
                    sig: "1F r[?ARD] a[?AT]"
                },
                tokenize: {
                    arity: [1, 2, 3],
                    sig: "1F r[*AS] a[?AS,1AS,1AS]"
                },
                trace: {
                    arity: [1, 2],
                    sig: "1F a[*,1AS] r[*]"
                },
                transform: {
                    sig: "1F r[1FM] a[1FM]"
                },
                translate: {
                    sig: "1F r[1AS] a[?AS,1AS,1AS]"
                },
                "true": {
                    sig: "1F r[1AB] a[]"
                },
                "type-available": {
                    XSLTonly: !0,
                    sig: "1F r[1AB] a[1AS]"
                },
                unordered: {
                    sig: "1F r[*] a[*]"
                },
                "unparsed-entity-public-id": {
                    XSLTonly: !0,
                    arity: [1, 2],
                    sig: "1F r[1AS] a[1AS,1N]"
                },
                "unparsed-entity-uri": {
                    XSLTonly: !0,
                    arity: [1, 2],
                    sig: "1F r[1AU] a[1AS,1N]"
                },
                "unparsed-text": {
                    arity: [1, 2],
                    sig: "1F r[?AS] a[?AS,1AS]"
                },
                "unparsed-text-available": {
                    arity: [1, 2],
                    sig: "1F r[1AB] a[?AS,1AS]"
                },
                "unparsed-text-lines": {
                    arity: [1, 2],
                    sig: "1F r[*AS] a[?AS,1AS]"
                },
                "upper-case": {
                    sig: "1F r[1AS] a[?AS]"
                },
                "uri-collection": {
                    arity: [0, 1],
                    sig: "1F r[*AU] a[?AS]"
                },
                "xml-to-json": {
                    arity: [1, 2],
                    sig: "1F r[?AS] a[?N,1FM]"
                },
                "year-from-date": {
                    sig: "1F r[?ADI] a[?AA]"
                },
                "year-from-dateTime": {
                    sig: "1F r[?ADI] a[?AM]"
                },
                "years-from-duration": {
                    sig: "1F r[?ADI] a[?AR]"
                },
                "zero-or-one": {
                    sig: "1F r[?] a[*]"
                }
            },
            "http://www.w3.org/2005/xpath-functions/array": {
                append: {
                    sig: "1F r[1FA] a[1FA,*]"
                },
                filter: {
                    sig: "1F r[1FA] a[1FA,1F r[1AB] a[*]]"
                },
                flatten: {
                    sig: "1F a[*] r[*]"
                },
                "fold-left": {
                    sig: "1F a[1FA,*,1F a[*,*]] r[*]"
                },
                "fold-right": {
                    sig: "1F a[1FA,*,1F a[*,*]] r[*]"
                },
                "for-each": {
                    sig: "1F r[1FA] a[1FA,1F a[*]]"
                },
                "for-each-pair": {
                    sig: "1F r[1FA] a[1FA,1FA,1F a[*,*]]"
                },
                get: {
                    sig: "1F a[1FA,1ADI] r[*]"
                },
                head: {
                    sig: "1F a[1FA] r[*]"
                },
                "insert-before": {
                    sig: "1F r[1FA] a[1FA,1ADI,*]"
                },
                join: {
                    sig: "1F r[1FA] a[*FA]"
                },
                put: {
                    sig: "1F r[1FA] a[1FA,1ADI,*]"
                },
                remove: {
                    sig: "1F r[1FA] a[1FA,*ADI]"
                },
                reverse: {
                    sig: "1F r[1FA] a[1FA]"
                },
                size: {
                    sig: "1F r[1ADI] a[1FA]"
                },
                sort: {
                    arity: [1, 2, 3],
                    collation: 1,
                    sig: "1F r[1FA] a[1FA,?AS,1F r[*A] a[*]]"
                },
                subarray: {
                    arity: [2, 3],
                    sig: "1F r[1FA] a[1FA,1ADI,1ADI]"
                },
                tail: {
                    sig: "1F r[1FA] a[1FA]"
                }
            },
            "http://www.w3.org/2005/xpath-functions/map": {
                contains: {
                    sig: "1F r[1AB] a[1FM,1A]"
                },
                entry: {
                    sig: "1F r[1FM] a[1A,*]"
                },
                find: {
                    sig: "1F r[1FA] a[*,1A]"
                },
                "for-each": {
                    sig: "1F r[*] a[1FM,1F a[1A,*]]"
                },
                get: {
                    sig: "1F a[1FM,1A] r[*]"
                },
                keys: {
                    sig: "1F r[*A] a[1FM]"
                },
                merge: {
                    arity: [1, 2],
                    sig: "1F r[1FM] a[*FM,1FM]"
                },
                put: {
                    sig: "1F r[1FM] a[1FM,1A,*]"
                },
                remove: {
                    sig: "1F r[1FM] a[1FM,*A]"
                },
                size: {
                    sig: "1F r[1ADI] a[1FM]"
                }
            },
            "http://www.w3.org/2005/xpath-functions/math": {
                acos: {
                    sig: "1F r[?AO] a[?AO]"
                },
                asin: {
                    sig: "1F r[?AO] a[?AO]"
                },
                atan: {
                    sig: "1F r[?AO] a[?AO]"
                },
                atan2: {
                    sig: "1F r[1AO] a[1AO,1AO]"
                },
                cos: {
                    sig: "1F r[?AO] a[?AO]"
                },
                exp: {
                    sig: "1F r[?AO] a[?AO]"
                },
                exp10: {
                    sig: "1F r[?AO] a[?AO]"
                },
                log: {
                    sig: "1F r[?AO] a[?AO]"
                },
                log10: {
                    sig: "1F r[?AO] a[?AO]"
                },
                pi: {
                    sig: "1F r[1AO] a[]"
                },
                pow: {
                    sig: "1F r[?AO] a[?AO,1A m[AO,AD,AF]]"
                },
                sin: {
                    sig: "1F r[?AO] a[?AO]"
                },
                sqrt: {
                    sig: "1F r[?AO] a[?AO]"
                },
                tan: {
                    sig: "1F r[?AO] a[?AO]"
                }
            }
        }
    };
    // Input 71
    var Jh = function() {
        const a = {};
        a[Zb.wb] = {
            apply: {
                sig: "1F r[*] a[1F,1FA]"
            },
            "column-number": {
                arity: [0, 1],
                sig: "1F r[1ADI] a[1N]"
            },
            "compile-XPath": {
                arity: [1, 2, 3],
                sig: "1F r[1ND] a[1AS,?,?]"
            },
            "compile-GlobalContext": {
                sig: "1F r[1] a[1FM,1FM,1FM]"
            },
            "discard-document": {
                sig: "1F r[1ND] a[1ND]"
            },
            "has-uniform-namespaces": {
                sig: "1F r[1AB] a[1N]"
            },
            "line-number": {
                arity: [0, 1],
                sig: "1F r[1ADI] a[1N]"
            },
            "marshal-type": {
                sig: "1F r[1FM] a[1AS]"
            },
            "message-count": {
                sig: "1F r[1ADI] a[?AQ]"
            },
            "parse-sequence-type": {
                arity: [2, 3],
                sig: "1F r[1FM] a[1AS,1NE,?AS]"
            },
            "parse-XPath": {
                arity: [1, 2, 3],
                sig: "1F r[1ND] a[1AS,?AS,?]"
            },
            permute: {
                sig: "1F r[*] a[*]"
            },
            "system-id": {
                sig: "1F r[*AU] a[]"
            },
            timestamp: {
                sig: "1F r[1AMP] a[]"
            }
        };
        a[Zb.nd] = {
            apply: {
                sig: "1F r[*] a[1F,1FA]"
            },
            call: {
                sig: "1F r[*] a[1,1AS,1FA]"
            },
            contains: {
                sig: "1F r[1AB] a[1,1AS]"
            },
            eval: {
                sig: "1F r[*] a[1AS]"
            },
            event: {
                sig: "1F r[?] a[]"
            },
            get: {
                sig: "1F r[*] a[1,1AS]"
            },
            location: {
                sig: "1F r[1AS] a[]"
            },
            page: {
                sig: "1F r[1N] a[]"
            },
            "query-params": {
                sig: "1F r[1FM] a[]"
            },
            source: {
                sig: "1F r[?N] a[]"
            },
            style: {
                sig: "1F r[1FM] a[?N]"
            },
            window: {
                sig: "1F r[1] a[]"
            }
        };
        a["http://exslt.org/common"] = {
            "node-set": {
                sig: "1F r[?N] a[?N]",
                isIdempotent: !0
            }
        };
        return {
            Ri: function(c) {
                return a[c]
            },
            Nf: function(c) {
                const q = c.namespace;
                c = c.signatures;
                let E = a[q];
                E || (E = {},
                a[q] = E);
                Object.entries(c).forEach(H=>{
                    E[H[0]] = H[1]
                }
                )
            }
        }
    }();
    // Input 72
    var Lh = function() {
        function a(b) {
            var d;
            var l = {};
            for (d in b) {
                var r = b[d];
                l[d] = r
            }
            return l
        }
        function c() {}
        function q(b) {
            const d = {};
            if (b) {
                b = b.split(" ");
                for (let r = 0; r < b.length; r++) {
                    var l = b[r];
                    const n = l.indexOf("=")
                      , B = -1 === n ? l : l.substring(0, n);
                    l = -1 === n ? "" : l.substring(n + 1);
                    d[B] = "~" === l ? Zb.withPrefix[B] : l
                }
            }
            return d
        }
        function E(b) {
            const d = [];
            (b.C || []).forEach(function(l) {
                "arg" === l.N && d.push(l)
            });
            return d
        }
        function H(b, d, l) {
            let r;
            if (d.globalContext)
                r = d.globalContext.value.ba();
            else {
                r = new c;
                r.j();
                var n = d.globals;
                n && (r.Hc = n);
                if (n = d.accumulators)
                    r.Gb = n
            }
            n = d.language;
            O && O.language && (n = O.language);
            var B = d.staticContext;
            B && B.language && (n = B.language);
            B = d.html5Mode;
            r.qe = B ? B : !1;
            r.bb = n ? "XSLT" === n : !1;
            r.Jc = d.inTry;
            r.hf = d.inCatch;
            r.Tb = d.backwardCompatibility;
            let W, ma;
            if (n = d.slotMap) {
                B = -1;
                let qa;
                for (W in n)
                    qa = n[W],
                    r.ac[W] = qa,
                    B = qa > B ? qa : B;
                r.qd = B + 1
            }
            r.Gj(b);
            if (b = d.slotTypes)
                for (W in b)
                    r.wd[W] = ic(b[W]);
            for (ma in l)
                r.namespaces[ma] = l[ma];
            r.namespaces[""] = "";
            if (l = d.staticTyping)
                r.vf = l;
            if (l = d.xpathDefaultNamespace)
                r.xpathDefaultNamespace = l;
            if (l = d.defaultCollation)
                r.Ub = l;
            if (l = d.staticBaseURI)
                r.staticBaseURI = l;
            (l = d.contextType) ? r.type = new gc(jc(l),2) : r.type = r.bb ? null : dc.mc;
            r.ye = r.type;
            if (d = d.requiredType)
                r.De = ec(d);
            return r
        }
        function p(b) {
            const d = new c;
            d.type = dc.mc;
            d.aa(b.params, b.inputConvert);
            ["xs", "map", "array", "math", "saxon"].forEach(n=>d.namespaces[n] = nh[n]);
            for (var l in b.namespaceContext)
                d.namespaces[l] = b.namespaceContext[l];
            b.xpathDefaultNamespace && (d.xpathDefaultNamespace = b.xpathDefaultNamespace);
            let r;
            if (b = b.slotMap) {
                l = -1;
                let n;
                for (r in b)
                    n = b[r],
                    d.ac[r] = n,
                    l = n > l ? n : l;
                d.qd = l + 1
            }
            return d
        }
        function g(b, d, l) {
            b = Hh.process(b, "pattern" === d.type, d.splitPattern, l, "XSLT" === d.language, d.allowEmpty, d.freeVariables);
            return Pb(b)
        }
        function e(b, d=!1) {
            const l = {
                "function": {},
                globalVariable: {},
                globalParam: {}
            };
            for (const n in b) {
                if ("PRIVATE" === b[n].visibility)
                    continue;
                var r = b[n].actor;
                const B = ac.X(r) ? r.nodeName : r.N
                  , W = ac.X(r) ? r.getAttribute("name") : r.name;
                switch (B) {
                case "function":
                    if (d && "PUBLIC" !== b[n].visibility && "FINAL" !== b[n].visibility)
                        break;
                    r = (ac.X(r) ? ac.Ec(r, "arg") : E(r)).length;
                    l[B][W + "#" + r] = b[n];
                    break;
                case "globalVariable":
                case "globalParam":
                    l[B][W] = b[n]
                }
            }
            return l
        }
        function k(b, d=!0) {
            const l = {
                N: b.nodeName
            };
            var r = b.attributes, n;
            for (n = 0; n < r.length; n++) {
                var B = r[n].name;
                if ("xmlns" !== B.substring(0, 5) || 5 !== B.length && ":" !== B.charAt(5))
                    l[B] = r[n].value
            }
            b = b.childNodes || [];
            if (0 !== b.length) {
                r = [];
                for (n = 0; n < b.length; n++)
                    B = k(b[n], d),
                    d && (B.parentNode = l),
                    r.push(B);
                l.C = r
            }
            return l
        }
        function v(b) {
            b.C && b.C.forEach(function(d) {
                d.parentNode = b;
                v(d)
            })
        }
        function t(b, d, l) {
            b = {
                N: "co",
                id: b,
                binds: l,
                We: l.split(/\s+/).map(r=>parseInt(r, 10)),
                actor: d,
                C: [d]
            };
            return d.parentNode = b
        }
        function C(b) {
            if (!ac.X(b))
                return [];
            let d = [];
            b.childNodes.forEach(l=>d = d.concat(C(l)));
            return d
        }
        function m(b, d) {
            "ufRef" === b.nodeName ? b.setAttribute("bSlot", d[b.getAttribute("name")]) : b.hasChildNodes() && b.childNodes.forEach(l=>m(l, d))
        }
        function f(b, d, l) {
            var r = Jd.find("SaxonJS");
            const n = r.XError
              , B = r.convertResult;
            var W = r.getPlatform()
              , ma = W.inBrowser();
            l ||= {};
            l.params || (l.params = {});
            if (b.freeV) {
                const y = l.params;
                let I = {};
                b.freeV.forEach(R=>{
                    const M = R.startsWith("Q{}") ? y[R.substring(3)] : y[R];
                    if (!M)
                        throw new n("A value for parameter " + R + " is required","SXJS9999");
                    I[R] = M
                }
                );
                l.params = I
            }
            r = l.inputConvert || "strong";
            const qa = p(l);
            let L = b.C[0];
            L.parentNode = b;
            const aa = {
                name: "evaluate",
                Za: b,
                hb: {}
            };
            b = new ne;
            b.ja = W.createDocument();
            b.fixed = {
                Rd: {},
                tb: {},
                kc: {},
                vd: {},
                Lf: 0,
                Jb: new Date,
                hb: {
                    "Q{}": b.ja.createElement("decimal-format")
                },
                rd: {
                    evaluate: aa
                },
                staticBaseURI: ma ? window.location.href : null,
                ka: cd
            };
            l.staticBaseURI && (b.fixed.staticBaseURI = l.staticBaseURI);
            let z, D;
            if (l.namedDecimalFormats)
                for (const y in l.namedDecimalFormats) {
                    W = l.namedDecimalFormats[y];
                    ma = b.ja.createElement("decimal-format");
                    for (z in W)
                        D = W[z],
                        ma.setAttribute(z, ["infinity", "NaN"].includes(z) ? D : Da(D)[0]);
                    aa.hb[/^Q\{/.test(y) ? y : "Q{}" + y] = k(ma)
                }
            if (l.defaultDecimalFormat) {
                W = l.defaultDecimalFormat;
                ma = b.ja.createElement("decimal-format");
                for (z in W)
                    D = W[z],
                    ma.setAttribute(z, ["infinity", "NaN"].includes(z) ? D : Da(D)[0]);
                aa.hb["Q{}"] = k(ma)
            }
            b.oa = qa.xc;
            if (d)
                if (d instanceof vb)
                    b.focus = d;
                else {
                    if (Array.isArray(d) && 1 < d.length)
                        throw new n("Context item is a sequence of more than one item","XTTE3210");
                    d = cd.Ra(d);
                    "strong" === r && (d = cd.xd(d));
                    b.focus = null != d ? Rb(d[0]) : Sb(Ob)
                }
            else
                b.focus = Sb(Ob);
            d = cd.evaluate(L, b);
            return B(d, l.resultForm || "default")
        }
        const A = Hd.$c;
        let O = null;
        c.prototype = {
            type: void 0,
            De: void 0,
            ye: void 0,
            I: [],
            K: void 0,
            qd: 0,
            B: 1,
            ac: {},
            wd: {},
            g: {},
            xc: [],
            Hc: {},
            Gb: {},
            vf: !1,
            bb: !1,
            Jc: !1,
            hf: !1,
            ng: !1,
            Tb: !1,
            namespaces: {},
            xpathDefaultNamespace: "",
            Ub: A,
            j: function() {
                this.B = this.qd = 0;
                this.xc = [];
                this.ac = {};
                this.wd = {};
                this.vf = !1;
                this.g = {};
                this.Hc = {};
                this.namespaces = {
                    "": "",
                    xml: "http://www.w3.org/XML/1998/namespace",
                    fn: "http://www.w3.org/2005/xpath-functions"
                };
                this.Ub = A
            },
            toString: function() {
                var b = 0, d;
                for (d in this.Hc)
                    b++;
                return "CompileContext:\n\t" + (b + " global variables/params")
            },
            Gj: function(b) {
                if (void 0 !== b && (b = b.next(),
                null != b))
                    for (var d = Kb(b.keys()), l; null != (l = d.next()); ) {
                        var r = La.XS.QName.matches(l) ? l.toEQName() : l.toString();
                        /^Q{/.test(r) || (r = "Q{}" + r);
                        const n = this.ac.hasOwnProperty(r) ? this.ac[r] : this.qd++;
                        this.ac[r] = n;
                        l = b.get(l);
                        this.xc[n] = l;
                        this.wd[r] = dc.Aa
                    }
            },
            aa: function(b, d) {
                this.j();
                if (void 0 !== b)
                    for (const r in b) {
                        let n = r.toString();
                        /^Q{/.test(n) || (n = "Q{}" + n);
                        var l = this.qd++;
                        this.ac[n] = l;
                        let B = cd.Ra(b[r]);
                        "strong" === d && (B = cd.xd(B));
                        if (this.xc[l] = B)
                            l = B.code,
                            this.wd[n] = l ? new gc(La.codes[l],2) : dc.Aa
                    }
            },
            ba: function() {
                const b = new c;
                b.type = this.type;
                b.De = this.De;
                b.ye = this.ye;
                b.I = this.I;
                b.K = this.K;
                b.qd = this.qd;
                b.B = this.B;
                b.ac = a(this.ac);
                b.wd = a(this.wd);
                b.vf = this.vf;
                b.bb = this.bb;
                b.Jc = this.Jc;
                b.hf = this.hf;
                b.Tb = this.Tb;
                b.g = a(this.g);
                b.xc = a(this.xc);
                b.Hc = this.Hc;
                b.Gb = this.Gb;
                b.namespaces = a(this.namespaces);
                b.xpathDefaultNamespace = this.xpathDefaultNamespace;
                b.Ub = this.Ub;
                b.fb = this.fb;
                return b
            }
        };
        return {
            compile: function(b, d, l, r, n) {
                r = q(d.nsAttribute);
                l = H(l, d, r);
                if (!d.globalContext && (l.fb = e(n.fixed.La),
                n = d.globalFunctions)) {
                    r = {};
                    let W = 0;
                    for (const ma in n) {
                        var B = n[ma];
                        const qa = ac.X(B);
                        B = qa ? B.parentNode : B.parent;
                        const L = qa ? B.parentNode : B.parent;
                        r[W++] = {
                            actor: B,
                            Za: L,
                            id: parseInt(qa ? L.getAttribute("id") : L.id, 10)
                        }
                    }
                    l.fb = e(r)
                }
                return g(b, d, l)
            },
            compileOnly: function(b, d, l=!1) {
                Jd.find("SaxonJS").getPlatform();
                d ||= {};
                d.params || (d.params = {});
                d.freeVariables = !0;
                var r = p(d);
                let n = g(b, d, r).next();
                if (r = n.Ii) {
                    let W = Object.assign({}, d);
                    W.freeVariables = !1;
                    W.params = {};
                    r.forEach(ma=>{
                        W.params[ma] = "dummy"
                    }
                    );
                    d = p(W);
                    n = g(b, W, d).next()
                }
                const B = {
                    N: "package",
                    name: "evaluate",
                    C: [n]
                };
                r && (B.freeV = r);
                return l ? B : function(W, ma={}) {
                    return f(B, W, {
                        params: ma
                    })
                }
            },
            evaluateOnly: f,
            compileGlobalContext: function(b, d, l) {
                var r = new c;
                r.j();
                r.Hc = b;
                r.V = d;
                r.Gb = l;
                b = {};
                l = 0;
                for (let B in d) {
                    var n = d[B];
                    const W = ac.X(n);
                    n = W ? n.parentNode : n.parent;
                    const ma = W ? n.parentNode : n.parent;
                    b[l++] = {
                        actor: n,
                        Za: ma,
                        id: parseInt(W ? ma.getAttribute("id") : ma.id, 10)
                    }
                }
                r.fb = e(b);
                return Pb(r)
            },
            evaluateXDM: function(b, d, l, r) {
                function n(ea="") {
                    return ma[ea]
                }
                var B;
                const W = Jd.find("SaxonJS").getPlatform();
                let ma;
                const qa = H(r.params, r, r.namespaces);
                qa.La = l.fixed.La;
                qa.staticBaseURI || (qa.staticBaseURI = l.fixed.staticBaseURI);
                const L = l.fixed.La;
                qa.fb = e(l.fixed.La, r.dynamicEval);
                b = g(b, r, qa).next();
                const aa = {
                    N: "package",
                    name: "evaluate"
                };
                var z = {
                    name: "evaluate",
                    Za: aa,
                    hb: {}
                };
                b.parentNode = aa;
                let D = !1;
                var y = C(b);
                if (0 < y.length) {
                    D = !0;
                    var I = [];
                    for (var R = 0; R < y.length; R++)
                        I.push(1001 + R);
                    let ea = 1001;
                    var M = 0;
                    const ja = []
                      , Y = {};
                    y.forEach(V=>{
                        const la = t(ea, k(V), "");
                        V = V.getAttribute("name") + "#" + V.getAttribute("arity");
                        la.parentNode = aa;
                        qa.fb["function"][V] = {
                            actor: la,
                            Za: null,
                            id: ea
                        };
                        Y[V] = M++;
                        L[ea] = la;
                        ea++;
                        ja.push(la)
                    }
                    );
                    m(b, Y);
                    b = k(b);
                    I = t(1E3, b, I.join(" "));
                    I.parentNode = aa;
                    L[1E3] = I;
                    ja.unshift(I);
                    aa.C = ja
                } else
                    ac.X(b) ? b = k(b) : v(b),
                    aa.C = [t(1E3, b, "")],
                    b.parentNode = aa;
                R = cd.ke(l.sa.actor, l);
                for (B in R.hb)
                    z.hb[B] = R.hb[B];
                y = new ne;
                y.fixed = {
                    Rd: {},
                    tb: {},
                    vd: {},
                    kc: {},
                    Lf: 0,
                    Jb: new Date,
                    hb: {},
                    La: l.fixed.La,
                    ka: cd,
                    options: l.fixed.options,
                    Ib: l.fixed.Ib,
                    staticBaseURI: l.fixed.staticBaseURI,
                    Ee: null,
                    rd: {
                        evaluate: z
                    }
                };
                y.fixed.rd[R.name] = R;
                r.staticBaseURI && (y.fixed.staticBaseURI = r.staticBaseURI);
                if (R = r.staticContext) {
                    var ca = R.decimalFormats;
                    if (ca)
                        for (B in ca)
                            z.hb[B] = k(ca[B]);
                    if (z = R.resources)
                        for (B in z)
                            if (ca = z[B],
                            ca.hasOwnProperty("err")) {
                                let ea = ca.err;
                                ea = ea.replace(/Q{http:\/\/www\.w3\.org\/2005\/xqt-errors\}/, "");
                                y.fixed.kc[B] = new F(ea + " " + ca.description,ea)
                            } else
                                y.fixed.kc[B] = ca;
                    if (z = R.sources)
                        for (B in z)
                            if ("." !== B)
                                try {
                                    const ea = z[B];
                                    let ja;
                                    if ("string" == typeof ea) {
                                        let Y = W.readFile(ea);
                                        Y = Nd.Rg(Nd.Qg(Y));
                                        ja = ac.wc(W.parseXmlFromString(Y));
                                        ja._saxonBaseUri = ea;
                                        ja._saxonDocUri = ea
                                    } else
                                        ja = ea;
                                    y.fixed.tb[B] = ja
                                } catch (ea) {
                                    y.fixed.tb[B] = ea
                                }
                    if (B = R.collectionFinder)
                        ma = B,
                        y.fixed.options.Tg = n;
                    B = R.staticBaseURI;
                    "undefined" != typeof B && (y.fixed.staticBaseURI = "#UNDEFINED" === B ? null : B)
                }
                r.staticBaseURI && (y.fixed.staticBaseURI = r.staticBaseURI);
                y.masterDocument = l.masterDocument;
                y.ja = W.createDocument();
                if (null != d) {
                    r = d.next();
                    if (null != d.next())
                        throw new F("Context item is a sequence of more than one item","XTTE3210");
                    y.oa = [];
                    for (d = 0; d < qa.xc.length; d++)
                        y.oa[d] = qa.xc[d];
                    y.sa = D ? I : l.sa;
                    null != r ? (r = Rb(r),
                    y.focus = r) : y.focus = Sb(Ob);
                    return cd.evaluate(b, y)
                }
                return Ob
            },
            evaluate: function(b, d, l) {
                var r = Jd.find("SaxonJS");
                const n = r.XError
                  , B = r.convertResult;
                var W = r.getPlatform()
                  , ma = W.inBrowser();
                l ||= {};
                l.params || (l.params = {});
                r = l.inputConvert || "strong";
                const qa = p(l);
                b = g(b, l, qa).next();
                var L = {
                    N: "package",
                    name: "evaluate",
                    C: [b]
                };
                b.parentNode = L;
                const aa = {
                    name: "evaluate",
                    Za: L,
                    hb: {}
                };
                L = new ne;
                L.ja = W.createDocument();
                W = {};
                W[Hd.$c] = Hd.Sg();
                W[Hd.gh] = Hd.Ze();
                W[Hd.jg] = Hd.Mg();
                W[Hd.Zh] = Hd.Ze();
                L.fixed = {
                    Rd: {},
                    options: {
                        Ac: W
                    },
                    tb: {},
                    kc: {},
                    vd: {},
                    Lf: 0,
                    Jb: new Date,
                    hb: {
                        "Q{}": L.ja.createElement("decimal-format")
                    },
                    rd: {
                        evaluate: aa
                    },
                    staticBaseURI: ma ? window.location.href : null,
                    ka: cd
                };
                l.staticBaseURI && (L.fixed.staticBaseURI = l.staticBaseURI);
                let z, D;
                if (l.namedDecimalFormats)
                    for (const y in l.namedDecimalFormats) {
                        ma = l.namedDecimalFormats[y];
                        W = L.ja.createElement("decimal-format");
                        for (z in ma)
                            D = ma[z],
                            W.setAttribute(z, ["infinity", "NaN"].includes(z) ? D : Da(D)[0]);
                        aa.hb[/^Q\{/.test(y) ? y : "Q{}" + y] = k(W)
                    }
                if (l.defaultDecimalFormat) {
                    ma = l.defaultDecimalFormat;
                    W = L.ja.createElement("decimal-format");
                    for (z in ma)
                        D = ma[z],
                        W.setAttribute(z, ["infinity", "NaN"].includes(z) ? D : Da(D)[0]);
                    aa.hb["Q{}"] = k(W)
                }
                L.oa = qa.xc;
                if (d)
                    if (d instanceof vb)
                        L.focus = d;
                    else {
                        if (Array.isArray(d) && 1 < d.length)
                            throw new n("Context item is a sequence of more than one item","XTTE3210");
                        d = cd.Ra(d);
                        "strong" === r && (d = cd.xd(d));
                        L.focus = null != d ? Rb(d[0]) : Sb(Ob)
                    }
                else
                    L.focus = Sb(Ob);
                d = cd.evaluate(b, L);
                return B(d, l.resultForm || "default")
            },
            forceBaseURI: function(b, d) {
                b._saxonBaseUri = d;
                b._saxonDocUri = d;
                return b
            },
            getFnSignature: function(b, d, l) {
                function r(ma) {
                    ma.sig || (ma.sig = "F a[" + cd.qb(ma, "arg").map(qa=>qa.as).join(",") + "] r[" + ma.as + "]");
                    return ma.sig
                }
                var n = null
                  , B = Ih.Qj[b.uri];
                B && (n = B[b.local]);
                if (n && !l.bb && n.XSLTonly)
                    return null;
                n || b.uri !== Zb.lc || (La.type[b.local] ? n = {
                    sig: "1F a[?A] r[?" + La.type[b.local].code + "]"
                } : Bd[b.local] && (n = {
                    sig: "1F a[1AS] r[*" + Bd[b.local] + "]"
                }));
                if (!n && l.fb && l.fb["function"]) {
                    var W = b.toEQName();
                    if (l = l.fb["function"][W + "#" + d])
                        b = W,
                        n = l.actor,
                        ac.X(n) ? (ac.Ec(n, "arg"),
                        n = {
                            sig: n.getAttribute("sig")
                        }) : (E(n),
                        n = {
                            sig: r(n)
                        }),
                        n.isUserFunction = !0,
                        n.componentBinding = l.id
                } else if (!n && l.fixed && l.fixed.La)
                    if (B = `{${b.uri}}${b.local}`,
                    B in l.fixed.Rd)
                        n = l.fixed.Rd[B];
                    else {
                        const ma = b.toEQName();
                        for (W in l.fixed.La) {
                            const qa = l.fixed.La[W].actor;
                            if ("function" === qa.N && qa.name === ma && E(qa).length === d) {
                                n = {
                                    sig: r(qa),
                                    isUserFunction: !0,
                                    componentBinding: W
                                };
                                l.fixed.Rd[B] = n;
                                break
                            }
                        }
                    }
                if (!n && ((l = Jh.Ri(b.uri)) && (n = l[b.local]),
                b.uri === Zb.xh)) {
                    b = 0 < d ? "*" : "";
                    for (n = 1; n < d; n++)
                        b += ",*";
                    n = {
                        sig: "1F a[" + b + "] r[*]",
                        variadic: !0
                    }
                }
                n && !n.alphaTree && (n.alphaTree = rb(n.sig));
                return n && (b = n.alphaTree.a.length,
                null != d && d !== b && (n.variadic ? d < b : !(n.arity || []).includes(d))) ? null : n
            },
            parseNsAttribute: q,
            sefToJSON: k,
            setStaticContext: function(b) {
                O = cd.sb(b.value, !0);
                b = {};
                const d = O.resources;
                for (const l in d) {
                    const r = d[l];
                    if (r.hasOwnProperty("err")) {
                        let n = r.err;
                        n = n.replace(/Q{http:\/\/www\.w3\.org\/2005\/xqt-errors\}/, "");
                        b[l] = new F(n + " " + r.description,n)
                    } else
                        b[l] = r
                }
                O.resources = b;
                return null
            },
            resetStaticContext: function() {
                return O = null
            },
            resetNameBase: function() {}
        }
    }();
    // Input 73
    var Eh = {
        evaluateXDM: Lh.evaluateXDM,
        evaluate: Lh.evaluate,
        compileToXML: Lh.compile,
        compile: Lh.compileOnly,
        evaluateOnly: Lh.evaluateOnly,
        compileGlobalContext: Lh.compileGlobalContext,
        forceBaseURI: Lh.forceBaseURI,
        getFnSignature: Lh.getFnSignature,
        sefToJSON: Lh.sefToJSON,
        setStaticContext: Lh.setStaticContext,
        resetStaticContext: Lh.resetStaticContext,
        resetNameBase: Lh.resetNameBase
    };
    // Input 74
    // Input 75
    // Input 76
    const Mh = function() {
        function a(e, k, v, t, C) {
            switch (e) {
            case Zb.Oa + "/math":
                return H(k, v, t, C);
            case Zb.Oa + "/map":
                return E(k, v, t, C);
            case Zb.Oa + "/array":
                return q(k, v, t, C);
            case Zb.nd:
                return c(k, v, t, C);
            default:
                const m = (g[e] || {})[k];
                if (!m)
                    throw new F("Unknown function " + (g[e] ? "local name " + k : "namespace " + e),"SXJS0003",C);
                return m(v, t, C)
            }
        }
        function c(e, k, v, t) {
            function C(d, l) {
                for (let r = 0; r < l.length; r++) {
                    if (null === d)
                        return;
                    try {
                        d = d[l[r]]
                    } catch (n) {
                        if (null !== n.code && "undefined" !== typeof n.code)
                            throw n;
                        throw new F("Failed to get property " + l[r],"SXJS0007",t);
                    }
                    if ("undefined" === typeof d)
                        return
                }
                return d
            }
            function m(d) {
                if ("string" !== typeof d)
                    throw new F(`Cannot interpolate a ${typeof d}`,"SXJS0017");
                if (0 > d.indexOf("`"))
                    return d.split(".");
                let l = [""]
                  , r = 0
                  , n = 0
                  , B = !0;
                for (; n < d.length; ) {
                    const W = d.substring(n, n + 1);
                    switch (W) {
                    case "`":
                        B ? B = !1 : n + 1 < d.length && "`" === d.substring(n + 1, n + 2) ? (l[r] += "`",
                        n++) : B = !0;
                        break;
                    case ".":
                        B ? (r++,
                        l[r] = "") : l[r] += W;
                        break;
                    default:
                        l[r] += W
                    }
                    n++
                }
                if (!B)
                    throw new F(`Mismatched quotes in ${d}`,"SXJS0018");
                return l
            }
            function f(d, l, r) {
                let n;
                try {
                    n = d.apply(r, l)
                } catch (B) {
                    if (null !== B.code && "undefined" !== typeof B.code)
                        throw B;
                    throw new F("Failed to call method " + d,"SXJS0007",t);
                }
                return null === n || "undefined" === typeof n ? Ob : Kb(cd.Ra(n))
            }
            function A(d) {
                return d instanceof cd.Ef ? d.value : d
            }
            function O(d, l, r) {
                sa.Ma("Warning " + d + ": " + l, 1, r)
            }
            const b = {
                apply: function(d) {
                    const l = A(d[0].next());
                    if ("function" !== typeof l)
                        throw new F("ixsl:apply: first argument is not a function","SXJS0007",t);
                    d = cd.sb(d[1].next());
                    return f(l, d, null)
                },
                call: function(d) {
                    var l = A(d[0].next());
                    const r = d[1].next().toString();
                    var n = m(r);
                    const B = n.pop();
                    l = C(l, n);
                    if ("undefined" == typeof l || null === l)
                        throw new F("Encountered null or undefined in path to nested object for ixsl:call: '" + n.join(".") + "'","SXJS0007",t);
                    n = l[B];
                    if ("undefined" === typeof n)
                        throw new F("ixsl:call: object method '" + r + "' not found","SXJS0007",t);
                    if ("function" !== typeof n)
                        throw new F("ixsl:call: property '" + r + "' is not a function","SXJS0007",t);
                    d = cd.sb(d[2].next());
                    return f(n, d, l)
                },
                contains: function(d) {
                    var l = A(d[0].next());
                    let r = !0;
                    null === l && (r = !1);
                    d = d[1].next().toString();
                    d = m(d);
                    const n = d.pop();
                    l = C(l, d);
                    if ("undefined" == typeof l || null === l)
                        throw new F("Encountered null or undefined in path to nested object for ixsl:contains: '" + d.join(".") + "'","SXJS0007",t);
                    "undefined" == typeof l[n] && (r = !1);
                    return Kb(cd.Ra(r))
                },
                eval: function(d) {
                    d = d[0].next().toString();
                    d = new Function("return (" + d + ")");
                    return Kb(cd.Ra(d()))
                },
                event: function(d, l) {
                    return null === l.ie ? Ob : Pb(cd.Ra(l.ie)[0])
                },
                get: function(d, l) {
                    var r = A(d[0].next());
                    if (null === r)
                        throw new F("ixsl:get: specified object not found","SXJS0007",t);
                    d = d[1].next().toString();
                    const n = m(d)
                      , B = n.pop();
                    r = C(r, n);
                    if ("undefined" == typeof r || null === r)
                        throw new F("Encountered null or undefined in path to nested object for ixsl:get: '" + n.join(".") + "'","SXJS0007",t);
                    r = r[B];
                    return "undefined" == typeof r ? (O("ixsl:get", "object property '" + d + "' not found", l.fixed.Ta),
                    Ob) : null === r ? Ob : Kb(cd.Ra(r))
                },
                location: function() {
                    return Pb(cd.Ra(window.location.toString())[0])
                },
                page: function() {
                    return Pb(cd.Ra(v.masterDocument)[0])
                },
                "query-params": function() {
                    function d(ma) {
                        return p.string.fromString(decodeURIComponent(ma.replace(r, " ")))
                    }
                    let l, r = /\+/g, n = /([^&=]+)=?([^&]*)/g, B = window.location.search.substring(1), W = new cc;
                    for (; null !== (l = n.exec(B)); ) {
                        const ma = W.get(d(l[1]));
                        ma.push(d(l[2]));
                        W.inSituPut(d(l[1]), ma)
                    }
                    return Pb(W)
                },
                source: function(d, l) {
                    d = l.fixed.hd;
                    return "undefined" == typeof d || null === d ? Ob : Pb(cd.Ra(d)[0])
                },
                style: function(d) {
                    d = d[0].next();
                    d = ac.sh(d) ? window.getComputedStyle(d) : {};
                    const l = new cc;
                    for (let r = 0; r < d.length; r++) {
                        const n = d.item(r)
                          , B = d.getPropertyValue(n);
                        "undefined" === typeof B || null === B ? l.inSituPut(p.string.fromString(n), []) : l.inSituPut(p.string.fromString(n), [p.string.fromString(B.toString())])
                    }
                    return Pb(l)
                },
                window: function() {
                    return Pb(cd.Ra(pa.Si())[0])
                },
                "remove-attribute": function(d, l, r) {
                    const n = d[0].next().toString();
                    d = d[1].next();
                    if (1 !== d.nodeType || d.ownerDocument !== l.masterDocument)
                        throw new F("Context item for ixsl:remove-attribute must be an element in the master document","SXJS0007",r);
                    l = cd.sg(r, n, !1);
                    "" !== l.uri ? d.removeAttributeNS(l.uri, l.local) : d.removeAttribute(l.local);
                    return Ob
                },
                "remove-property": function(d, l, r) {
                    const n = d[0].next().toString();
                    var B = A(d[1].next());
                    const W = m(n);
                    d = W.pop();
                    B = C(B, W);
                    if ("undefined" == typeof B || null === B)
                        throw new F("Encountered null or undefined in path to nested object for ixsl:remove-property: '" + W.join(".") + "'","SXJS0007",r);
                    if ("undefined" == typeof B[d])
                        return O("ixsl:remove-property", "'" + n + "' not found for supplied object", l.fixed.Ta),
                        Ob;
                    r = B.hasOwnProperty(d);
                    delete B[d] && r || O("ixsl:remove-property", "'" + n + "' could not be removed for supplied object", l.fixed.Ta);
                    return Ob
                },
                "schedule-action": function() {
                    throw new F("ixsl:schedule-action - shouldn't be here","SXJS0007",t);
                },
                "set-attribute": function(d, l, r) {
                    const n = d[0].next().toString()
                      , B = d[1].next().toString();
                    d[2] || fd(l, "SXJS0007", "ixsl:set-attribute", r);
                    d = d[2] ? d[2].next() : ed(l);
                    l = ac.Gc(l.masterDocument);
                    if (1 !== d.nodeType || ac.Gc(d) !== l)
                        throw new F("Context item for ixsl:set-attribute must be an element in the master document","SXJS0007",r);
                    const W = cd.sg(r, n, !1);
                    "" !== W.uri ? ("" === W.prefix && ac.Ic(d).forEach(function(ma) {
                        ma.uri === W.uri && (W.prefix = ma.prefix)
                    }),
                    d.setAttributeNS(W.uri, W.toString(), B)) : d.setAttribute(W.local, B);
                    return Ob
                },
                "set-property": function(d, l, r) {
                    var n = d[0].next().toString();
                    l = cd.sb(d[1].next());
                    d = A(d[2].next());
                    n = m(n);
                    const B = n.pop();
                    d = C(d, n);
                    if ("undefined" == typeof d || null === d)
                        throw new F("Encountered null or undefined in path to nested object for ixsl:set-property: '" + n.join(".") + "'","SXJS0007",r);
                    if ("object" !== typeof d)
                        return Ob;
                    d[B] = l;
                    return Ob
                },
                "set-style": function(d, l) {
                    const r = d[0].next().toString()
                      , n = cd.sb(d[1].next());
                    d = d[2].next();
                    if (!(d instanceof Element && "style"in d))
                        return O("ixsl:set-style", "style '" + r + "' cannot be set for supplied object", l.fixed.Ta),
                        Ob;
                    d.style[r] = n;
                    return Ob
                }
            };
            if (!b[e])
                throw new F("Unknown ixsl function: " + e,"SXJS0003",t);
            return b[e](k, v, t)
        }
        function q(e, k, v, t) {
            function C(b, d) {
                if (1 > b || b > d)
                    throw new F("Array index (" + b + ") out of bounds (1 to " + d + ")","FOAY0001",t);
            }
            function m(b) {
                return b[0].next().value
            }
            function f(b) {
                return Pb(new $c(b))
            }
            function A(b, d, l, r) {
                const n = d.fixed.ka;
                let B = b[1].expand();
                const W = b[2].expand()[0]
                  , ma = Object.keys(d.oa).length;
                if (W instanceof ad.XdmFunction)
                    b = m(b),
                    r || (b = b.reverse()),
                    b.forEach(qa=>{
                        B = W.evaluate(r ? [B, qa] : [qa, B], d, l).expand()
                    }
                    );
                else {
                    let qa;
                    "function" !== W.N && (qa = W);
                    b[0].forEachItem(function(L) {
                        const aa = d.ba(!0);
                        qa && (aa.sa = qa);
                        gd(aa);
                        aa.qa = "function";
                        aa.gb = {};
                        aa.ab = null;
                        aa.focus = null;
                        r ? (aa.oa[ma] = B,
                        aa.oa[ma + 1] = [L]) : (aa.oa[ma] = [L],
                        aa.oa[ma + 1] = B);
                        B = n.evaluate(void 0, aa).expand()
                    })
                }
                return Kb(B)
            }
            const O = {
                append: function(b) {
                    return f(m(b).concat([b[1].expand()]))
                },
                filter: function(b, d, l) {
                    const r = b[1].expand()[0];
                    Object.keys(d.oa);
                    b = m(b);
                    if (r.evaluate) {
                        const n = [];
                        b.forEach(function(B) {
                            const W = r.evaluate([B], d, l).expand();
                            if (Array.isArray(W) && 1 !== W.length || !p.boolean.matches(W[0]))
                                throw new F("Wrong type for function result in filter(). Expecting xs:boolean, supplied value is " + sa.showValue(W),"XPTY0004",l);
                            W[0].toBoolean() && n.push(B)
                        });
                        return f(n)
                    }
                    throw new F("Argument supplied to array:filter is not a function","XPTY0004",l);
                },
                flatten: function(b) {
                    return cd.flatten(b[0])
                },
                "fold-left": function(b, d, l) {
                    return A(b, d, l, !0)
                },
                "fold-right": function(b, d, l) {
                    return A(b, d, l, !1)
                },
                "for-each": function(b, d, l) {
                    const r = b[1].expand()[0];
                    b = m(b);
                    Object.keys(d.oa);
                    if (r.evaluate) {
                        const n = [];
                        b.forEach(function(B) {
                            n.push(r.evaluate([B], d, l).expand())
                        });
                        return f(n)
                    }
                },
                "for-each-pair": function(b, d, l) {
                    let r = b[2].expand();
                    if (1 !== r.length)
                        throw new F("for-each-pair() must have exactly one function item as the third argument. Supplied length " + r.length,"XPTY0004",l);
                    r = r[0];
                    Object.keys(d.oa);
                    const n = []
                      , B = b[0].next().value[Symbol.iterator]();
                    b = b[1].next().value[Symbol.iterator]();
                    let W = B.next().value
                      , ma = b.next().value;
                    if (r instanceof ad.XdmFunction)
                        for (; W && ma; )
                            n.push(r.evaluate([W, ma], d, l).expand()),
                            W = B.next().value,
                            ma = b.next().value;
                    return f(n)
                },
                "_from-sequence": function(b) {
                    const d = [];
                    b[0].forEachItem(function(l) {
                        d.push([l])
                    });
                    return f(d)
                },
                get: function(b) {
                    const d = m(b);
                    b = b[1].next().toNumber();
                    C(b, d.length);
                    return Kb(d[b - 1])
                },
                head: function(b) {
                    b = m(b);
                    C(1, b.length);
                    return Kb(b[0])
                },
                "insert-before": function(b) {
                    const d = m(b)
                      , l = b[1].next().toNumber();
                    C(l, d.length + 1);
                    b = b[2].expand();
                    return f(d.slice(0, l - 1).concat([b]).concat(d.slice(l - 1)))
                },
                join: function(b) {
                    const d = [];
                    b[0].forEachItem(function(l) {
                        l.value.forEach(function(r) {
                            d.push(r)
                        })
                    });
                    return f(d)
                },
                put: function(b) {
                    const d = m(b)
                      , l = b[1].next().toNumber();
                    C(l, d.length);
                    b = b[2].expand();
                    return f(d.slice(0, l - 1).concat([b]).concat(d.slice(l)))
                },
                remove: function(b) {
                    const d = m(b)
                      , l = [];
                    b[1].forEachItem(function(r) {
                        r = r.toNumber();
                        C(r, d.length);
                        l.push(r - 1)
                    });
                    return f(d.filter(function(r, n) {
                        return 0 > l.indexOf(n)
                    }))
                },
                reverse: function(b) {
                    return f(m(b).slice().reverse())
                },
                size: function(b) {
                    return Ub(b[0].next().size())
                },
                sort: function(b, d, l) {
                    const r = Hd.df(l, b[1], d);
                    let n = cd.Sb;
                    if (b[2]) {
                        const B = b[2].next();
                        n = function(W) {
                            return B.evaluate([[W]], d, l)
                        }
                    }
                    return f(m(b).slice().sort(function(B, W) {
                        return b[1] ? Id(Kb(B).mapOneToMany(n), Kb(W).mapOneToMany(n), r) : Id(Kb(B).mapOneToMany(n), Kb(W).mapOneToMany(n))
                    }))
                },
                subarray: function(b) {
                    const d = m(b)
                      , l = b[1].next().toNumber();
                    C(l, d.length + 1);
                    b = b[2] ? b[2].next().toNumber() : d.length - l + 1;
                    if (0 > b)
                        throw new F("Length is negative","FOAY0002");
                    C(l + b, d.length + 1);
                    return f(d.slice(l - 1, l + b - 1))
                },
                tail: function(b) {
                    b = m(b);
                    C(1, b.length);
                    return f(b.slice(1))
                },
                "_to-sequence": function(b) {
                    const d = [];
                    m(b).forEach(function(l) {
                        l.forEach(function(r) {
                            d.push(r)
                        })
                    });
                    return Kb(d)
                }
            };
            if (!O[e])
                throw new F("Unknown array function: " + e,"SXJS0003",t);
            return O[e](k, v, t)
        }
        function E(e, k, v, t) {
            const C = {
                contains: function(m) {
                    const f = m[0].next();
                    m = m[1].next();
                    return Xb(f.containsKey(m))
                },
                create: function(m) {
                    const f = new cc;
                    m[0].forEachItem(function(A) {
                        A.forAllPairs(function(O) {
                            f.inSituPut(O.k, O.v)
                        })
                    });
                    return Pb(f)
                },
                entry: function(m) {
                    const f = new cc;
                    f.inSituPut(m[0].next(), m[1].expand());
                    return Pb(f)
                },
                find: function(m) {
                    function f(d) {
                        cd.isArray(d) ? d.value.forEach(A) : cd.isMap(d) && (d.containsKey(b) && O.push(d.get(b)),
                        d.keys().forEach(function(l) {
                            A(d.get(l))
                        }))
                    }
                    function A(d) {
                        d.forEach(f)
                    }
                    const O = []
                      , b = m[1].next();
                    A(m[0].expand());
                    return Pb(new $c(O))
                },
                "for-each": function(m, f, A) {
                    const O = m[0].next()
                      , b = O.keys()
                      , d = m[1].expand()[0];
                    if (d.evaluate) {
                        let l = [];
                        b.forEach(function(r) {
                            l = l.concat(d.evaluate([[r], O.get(r)], f, A).expand())
                        });
                        return Kb(l)
                    }
                    throw new F("Argument to map:for-each is not a function","XPTY0004",A);
                },
                get: function(m) {
                    const f = m[0].next();
                    m = m[1].next();
                    return Kb(f.get(m))
                },
                keys: function(m) {
                    m = m[0].next();
                    return Kb(m.keys())
                },
                merge: function(m) {
                    const f = new cc
                      , A = m[1] ? m[1].next() : null
                      , O = p.string.fromString("duplicates")
                      , b = A && A.containsKey(O) ? A.get(O).toString() : "use-first";
                    m[0].forEachItem(function(d) {
                        d.forAllPairs(function(l) {
                            if (!f.containsKey(l.k) || ["use-last", "unspecified", "use-any"].includes(b))
                                f.inSituPut(l.k, l.v);
                            else {
                                if ("reject" === b) {
                                    var r = p.string.fromString("duplicates-error-code");
                                    r = A.containsKey(r) ? A.get(r).toString() : "FOJS0003";
                                    throw new F("Duplicate key value '" + l.k.toString() + "'",r,t);
                                }
                                if ("combine" === b) {
                                    let n = [];
                                    f.get(l.k).forEach(function(B) {
                                        n.push(B)
                                    });
                                    l.v.forEach(function(B) {
                                        n.push(B)
                                    });
                                    f.inSituPut(l.k, n)
                                }
                            }
                        })
                    });
                    return Pb(f)
                },
                _new: function(m) {
                    const f = new cc;
                    m[0] && m[0].forEachItem(function(A) {
                        A.forAllPairs(function(O) {
                            if (f.containsKey(O.k))
                                throw new F("Duplicate key value '" + O.k.toString() + "'","XSLT" === v.fixed.options.language ? "XTDE3365" : "XQDY0137",t);
                            f.inSituPut(O.k, O.v)
                        })
                    });
                    return Pb(f)
                },
                put: function(m) {
                    const f = m[0].next()
                      , A = m[1].next();
                    m = m[2].expand();
                    return Pb(f.put(A, m))
                },
                remove: function(m) {
                    let f = m[0].next();
                    m[1].forEachItem(function(A) {
                        f = f.remove(A)
                    });
                    return Pb(f)
                },
                size: function(m) {
                    let f = 0;
                    m[0].next().forAllPairs(function() {
                        f++
                    });
                    return Ub(f)
                },
                "untyped-contains": function(m) {
                    const f = m[0].next();
                    m = m[1].next();
                    return Xb(f.containsKey(m))
                }
            };
            if (!C[e])
                throw new F("Unknown map function: " + e,"SXJS0003",t);
            return C[e](k, v, t)
        }
        function H(e, k, v, t) {
            function C(b) {
                return null === b ? (A = !0,
                Number.NaN) : b.toNumber()
            }
            function m() {
                const b = k[0].next();
                return C(b ? b : cd.Sa(t)(v).next())
            }
            function f() {
                const b = k[1].next();
                return C(b ? b : cd.Vg(t)(v).next())
            }
            let A = !1;
            const O = function() {
                switch (e) {
                case "pi":
                    return Math.PI;
                case "exp":
                    return Math.exp(m());
                case "exp10":
                    return Math.pow(10, m());
                case "log":
                    return Math.log(m());
                case "log10":
                    return Math.log(m()) / Math.LN10;
                case "pow":
                    const b = m()
                      , d = f();
                    return -1 === b && (Infinity === d || -Infinity === d) || 1 === b ? 1 : Math.pow(b, d);
                case "sqrt":
                    return Math.sqrt(m());
                case "sin":
                    return Math.sin(m());
                case "cos":
                    return Math.cos(m());
                case "tan":
                    return Math.tan(m());
                case "asin":
                    return Math.asin(m());
                case "acos":
                    return Math.acos(m());
                case "atan":
                    return Math.atan(m());
                case "atan2":
                    return Math.atan2(m(), f());
                default:
                    throw new F("Unknown math function " + t.name,"XPST0017",t);
                }
            }();
            return A ? Ob : Vb(O)
        }
        const p = La.XS
          , g = {};
        g[Zb.wb] = {
            apply: ke.apply,
            "compile-XPath": function(e, k, v) {
                const t = e[0].next().toString();
                let C, m;
                1 < e.length && (C = e[1].next(),
                C = null !== C ? cd.sb(C, !0) : {});
                2 < e.length && (m = e[2]);
                return Jd.find("SaxonJS").XPath.compileToXML(t, C, m, v, k)
            },
            "compile-GlobalContext": function(e, k, v) {
                let t, C;
                t = e[0].next();
                t = null !== t ? cd.sb(t, !0) : {};
                C = e[1].next();
                C = null !== C ? cd.sb(C, !0) : {};
                e = e[2].next();
                e = null !== e ? cd.sb(e, !0) : {};
                return Jd.find("SaxonJS").XPath.compileGlobalContext(t, C, e, v, k)
            },
            "discard-document": function(e, k, v) {
                e = e[0].next();
                if (null === e || 9 != e.nodeType || !e._saxonBaseUri)
                    throw new F("Node supplied to saxon:discard-document() is not a document node","XPTY0004",v);
                v = e._saxonBaseUri;
                e = k.fixed.tb[v];
                delete k.fixed.tb[v];
                delete k.fixed.vd[v];
                return Pb(e)
            },
            doc: ke.doc,
            "dynamic-error-info": function(e, k) {
                k = k.$e;
                if (null === k)
                    return Ob;
                e = e[0].next().toString();
                switch (e) {
                case "description":
                    return Tb(k.message);
                case "code":
                    return Pb(/^Q\{/.test(k.code) ? p.QName.fromString(k.code) : p.QName.fromParts("err", "http://www.w3.org/2005/xqt-errors", k.code));
                case "value":
                    return k.errorObject ? Pb(k.errorObject) : Ob;
                case "module":
                    return Tb(k.xsltModule || "");
                case "line-number":
                    return Ub(k.xsltLineNr);
                case "column-number":
                    return Ub(-1);
                default:
                    throw new F("unknown error info field " + e,"SXJS0003");
                }
            },
            "has-uniform-namespaces": function(e) {
                return Xb(ac.rh(e[0].next()))
            },
            "line-number": function(e) {
                e = e[0].next().Zk;
                return Ub(e || -1)
            },
            "marshal-type": function(e) {
                e = e[0].next().toString();
                e = rb(e);
                return Pb(cd.xd(cd.Ra(e))[0])
            },
            "message-count": function(e, k) {
                e = e[0].next();
                let v = 0;
                if (e)
                    e = e.toEQName(),
                    (v = k.uc[e]) || (v = 0);
                else
                    for (let t in k.uc)
                        v += k.uc[t];
                return Ub(v)
            },
            "parse-sequence-type": function(e) {
                var k = e[0].next().toString();
                const v = e[1].next();
                e = ac.Qi(v, Zb.Ci, "ns");
                if (null != e) {
                    const t = Lh.parseNsAttribute(e);
                    e = C=>t[C]
                } else
                    e = t=>v.lookupNamespaceURI(t);
                k = Hh.parseSequenceType(k, e, ()=>{
                    let t = v;
                    for (; t && 1 === t.nodeType; ) {
                        if (ac.ca(t).uri === Zb.Wc && t.hasAttributeNS("", "xpath-default-namespace"))
                            return t.getAttributeNS("", "xpath-default-namespace");
                        if (t.hasAttributeNS(Zb.Wc, "xpath-default-namespace"))
                            return t.getAttributeNS(Zb.Wc, "xpath-default-namespace");
                        t = ac.Xa(t)
                    }
                }
                );
                return Pb(cd.xd(cd.Ra(k.$()))[0])
            },
            "parse-XPath": function(e) {
                const k = e[0].next().toString();
                let v = "parse";
                1 < e.length && (v = e[1].next().toString());
                e = Hh.process(k, "pattern.parseFast" === v, null, !0);
                return Pb(e)
            },
            permute: function(e) {
                let k = [];
                e[0].expand().forEach(v=>k.push({
                    key: Math.random(),
                    Nj: v
                }));
                k = k.sort(function(v, t) {
                    return v.key - t.key
                });
                e = k.map(v=>v.Nj);
                return Kb(e)
            },
            "system-id": function(e, k) {
                e = ed(k);
                e = ac.X(e) ? ac.baseURI(e) : null;
                return Pb(null === e ? null : p.anyURI.fromString(e))
            },
            timestamp: function(e, k) {
                return Pb(p.Ed.fromDate(new Date, -k.fixed.Jb.getTimezoneOffset()))
            }
        };
        g["http://exslt.org/common"] = {
            "node-set": function(e) {
                return e[0]
            }
        };
        cd.Aj(a);
        return {
            evaluate: a,
            Nf: function(e) {
                const k = e.namespace;
                e = e.signatures;
                let v = g[k];
                v ||= g[k] = {};
                Object.entries(e).forEach(t=>{
                    v[t[0]] = t[1].impl
                }
                )
            }
        }
    }();
    // Input 77
    var Nh = {
        forceBaseURI: Lh.forceBaseURI
    };
    // Input 78
    const Oh = function() {
        function a(e, k) {
            return e.Eb === k.Eb ? e.Qc === k.Qc ? e.Sd === k.Sd ? k.Hh - e.Hh : e.Sd - k.Sd : e.Qc - k.Qc : e.Eb - k.Eb
        }
        function c(e, k) {
            return e.Eb === k.Eb ? e.Qc === k.Qc ? 0 : e.Qc - k.Qc : e.Eb - k.Eb
        }
        function q(e, k) {
            function v(t) {
                return t.n ? [t.n.replace(/^(\*:|Q\{.*\})/, "")] : t.u ? v(t.u[0]).concat(v(t.u[1])) : []
            }
            this.Re = e;
            this.Ch = e.onNo;
            this.Bh = k.Db(e, "t");
            k.Db(e, "F") && (this.Zf = !0);
            this.Kg = (e.C || []).map(function(t) {
                return {
                    Qd: t,
                    Eb: parseInt(t.prec, 10),
                    Qc: parseFloat(t.prio),
                    Sd: parseInt(t.seq, 10),
                    nj: parseInt(t.minImp, 10),
                    Hh: parseInt(t.rank, 10),
                    pattern: Kd.od(k.da(t, "match")),
                    matches: fc(t.matches || "1"),
                    action: k.da(t, "action")
                }
            }).sort(a).reverse();
            this.fc = {};
            this.Kg.forEach(t=>{
                const C = t.matches.$();
                let m, f = [];
                /^N[EAP]/.test(C.p) ? (m = C.p,
                C.n && !/}\*$/.test(C.n) ? (m += " " + C.n.replace(/^(\*:|Q\{.*\})/, ""),
                f = [m]) : f = C.u ? [...(new Set(v(C)))].map(A=>m + " " + A) : [m]) : f = ["."];
                f.forEach(A=>{
                    let O = this.fc[A];
                    O || (this.fc[A] = O = []);
                    O.push(t)
                }
                )
            }
            )
        }
        const E = La.XS
          , H = ac.Ja
          , p = {
            TC: function(e, k, v, t) {
                if (ac.X(e))
                    switch (e.nodeType) {
                    case 9:
                    case 11:
                    case 1:
                        v = v.ba(!1);
                        v.focus = Sb(H.Ka(e));
                        k.Hb(v, t);
                        break;
                    case 3:
                    case 4:
                        t.append(e);
                        break;
                    case 2:
                        t.text(e.value)
                    }
                else if (E.Qf.matches(e))
                    t.text(e.toString());
                else if (cd.isArray(e)) {
                    let C = [];
                    e.value.forEach(m=>{
                        C = C.concat(m)
                    }
                    );
                    e = v.ba(!1);
                    e.focus = Sb(Kb(C));
                    k.Hb(e, t)
                }
            },
            SC: function(e, k, v, t) {
                return Zd.rg(e, v, "c", function() {
                    const C = v.ba(!1);
                    C.focus = Sb(H.Ha(e));
                    k.Hb(C, t);
                    C.focus = Sb(H.Ka(e));
                    k.Hb(C, t)
                }, t)
            },
            DC: function(e, k, v, t) {
                ac.X(e) && (t.pb = ac.baseURI(e));
                t.append(e)
            },
            DS: function(e, k, v, t) {
                if (ac.X(e))
                    switch (e.nodeType) {
                    case 9:
                    case 11:
                        v = v.ba(!1),
                        v.focus = Sb(H.Ka(e)),
                        k.Hb(v, t)
                    }
            },
            SS: function(e, k, v, t) {
                if (ac.X(e))
                    switch (e.nodeType) {
                    case 9:
                    case 11:
                    case 1:
                        v = v.ba(!1),
                        v.focus = Sb(H.Ha(e)),
                        k.Hb(v, t),
                        v.focus = Sb(H.Ka(e)),
                        k.Hb(v, t)
                    }
                else if (cd.isArray(e)) {
                    let C = [];
                    e.value.forEach(m=>{
                        C = C.concat(m)
                    }
                    );
                    e = v.ba(!1);
                    e.focus = Sb(Kb(C));
                    k.Hb(e, t)
                }
            },
            bubble: function(e, k, v, t) {
                ac.X(e) ? 1 === e.nodeType && (v = v.ba(!1),
                v.focus = Sb(H.parent(e)),
                k.Hb(v, t)) : t.append(e)
            }
        };
        p.TO = p.TC;
        const g = {
            1: "NE",
            2: "NA",
            3: "NT",
            7: "NP",
            8: "NC",
            9: "ND",
            11: "ND",
            13: "NN"
        };
        q.prototype = {
            Re: null,
            Kg: null,
            Ch: "TC",
            Bh: !1,
            Zf: !1,
            Hb: function(e, k, v) {
                if (v) {
                    let t = !0;
                    e.focus.forEachItem(C=>{
                        t ? t = !1 : k.text(v.value, {});
                        this.Se(C, e, k)
                    }
                    )
                } else
                    e.focus.forEachItem(t=>this.Se(t, e, k))
            },
            ki: function(e, k) {
                const v = e.ab;
                if (!v)
                    throw new F("No current template rule","XTDE0560");
                return this.Se(ed(e), e, k, function(t) {
                    return t.Eb >= v.nj && t.Eb < v.Eb
                })
            },
            qj: function(e, k) {
                const v = e.ab;
                if (!v)
                    throw new F("No current template rule","XTDE0560");
                return this.Se(ed(e), e, k, function(t) {
                    return 0 > a(t, v)
                })
            },
            Gi: function(e, k, v) {
                let t = null
                  , C = null;
                const m = this.Zf;
                var f = [];
                if (ac.X(e)) {
                    const O = g[e.nodeType];
                    var A = ac.ca(e);
                    if (A = A ? A.local : null)
                        A = O + " " + A,
                        this.fc[A] && f.push(this.fc[A]);
                    this.fc[O] && f.push(this.fc[O]);
                    this.fc.N && f.push(this.fc.N)
                }
                this.fc["."] && f.push(this.fc["."]);
                (function(O) {
                    O.forEach(b=>{
                        b.forEach(function(d) {
                            if (!v || v(d))
                                if (!t || 0 < a(d, t) || m && 0 <= c(d, t)) {
                                    let l = !1;
                                    try {
                                        l = Kd.matches(d.pattern, e, k)
                                    } catch (r) {}
                                    l && (C = t,
                                    t = d)
                                }
                        })
                    }
                    )
                }
                )(f);
                if (this.Zf && t && C && 0 === c(t, C) && t.Sd !== C.Sd)
                    throw f = "Multiple templates matched item (" + sa.showValue(e) + "): ",
                    f += t.Qd.module + "#" + t.Qd.line,
                    f += " and " + C.Qd.module + "#" + C.Qd.line,
                    new F(f,"XTDE0540");
                return t
            },
            th: function() {
                const e = this.Re.name;
                return e && e.startsWith("Q{" + Zb.nd + "}")
            },
            Se: function(e, k, v, t) {
                var C = k.fixed.ka;
                t = this.Gi(e, k, t);
                if (null !== t)
                    C.Tf(t.Qd, k),
                    k.ab = t,
                    k.gb = k.sa,
                    t.action || sa.la("Template rule without action child"),
                    Zd.push(t.action, k, v);
                else {
                    var m;
                    this.th() ? m = "bubble" : m = this.Ch.split("+")[0];
                    if (C = p[m])
                        C(e, this, k, v);
                    else
                        throw new F("No matching template rule for " + sa.showValue(e),"XTDE0555");
                }
            }
        };
        return q
    }();
    // Input 79
    function bc(a, c, q=null) {
        this.prefix = null === a ? "" : a;
        this.uri = null === c ? "" : c;
        q && (this.parentNode = q)
    }
    bc.prototype = {
        prefix: null,
        uri: null,
        parentNode: null,
        nodeType: 13
    };
    function $b(a, c, q) {
        this.yc = a;
        this.value = c;
        this.parent = q;
        this.name = this.yc.toString();
        this.namespaceURI = this.yc.uri;
        this.localName = this.yc.local;
        this.prefix = this.yc.prefix
    }
    $b.prototype = {
        yc: null,
        value: null,
        parent: null,
        nodeType: 2
    };
    // Input 80
    (function() {
        function a(z) {
            B = z;
            B.init();
            pa.setPlatform(z)
        }
        function c(z) {
            function D(I) {
                switch (I.nodeType) {
                case 9:
                    I.documentElement && D(I.documentElement);
                    break;
                case 11:
                case 1:
                    var R = ac.ca(I)
                      , M = ac.Oi(I, "xml:space");
                    R = 11 !== I.nodeType && y(R.uri, R.local) && !(M && "preserve" === M);
                    M = I.childNodes;
                    let ca = 0;
                    for (; ca < M.length; ) {
                        let ea = M[ca];
                        if (4 === ea.nodeType) {
                            const ja = ac.rc(I).createTextNode(ea.nodeValue);
                            I.replaceChild(ja, ea);
                            ea = ja
                        }
                        3 === ea.nodeType || 4 == ea.nodeType ? R && "" === Ha.trim(ea.nodeValue) ? I.removeChild(ea) : ca++ : (D(ea),
                        ca++)
                    }
                }
            }
            let y;
            if (z)
                if ("strip.all" === z.N)
                    y = ()=>!0;
                else if ("strip.none" === z.N)
                    y = ()=>!1;
                else {
                    let I = {}
                      , R = {}
                      , M = {}
                      , ca = {}
                      , ea = {}
                      , ja = function(V, la, x) {
                        V[la] ? parseInt(x.Eb, 10) > parseInt(V[la].Eb, 10) && (V[la] = x) : V[la] = x
                    };
                    (z.C || []).forEach(V=>{
                        const la = fc(V.test);
                        la instanceof nd ? (V.PREC = parseInt(V.prec, 10),
                        V.PRIO = 2,
                        ja(I, la.name.toEQName(), V)) : la instanceof pd ? (V.PREC = parseInt(V.prec, 10),
                        V.PRIO = 1,
                        ja(R, la.uri, V)) : la instanceof od ? (V.PREC = parseInt(V.prec, 10),
                        V.PRIO = 1,
                        ja(M, la.localName, V)) : la instanceof Fc ? (V.PREC = parseInt(V.prec, 10),
                        V.PRIO = 0,
                        ja(ca, "*", V)) : sa.la("Unrecognised strip-space " + V.test)
                    }
                    );
                    const Y = (V,la)=>{
                        const x = []
                          , K = I["Q{" + V + "}" + la];
                        K && x.push(K);
                        (V = R[V]) && x.push(V);
                        (la = M[la]) && x.push(la);
                        ca["*"] && x.push(ca["*"]);
                        x.sort((U,ha)=>{
                            const T = U.PREC
                              , w = ha.PREC;
                            return T === w ? ha.PRIO - U.PRIO : w - T
                        }
                        );
                        return 0 < x.length ? "s" === x[0].N : !1
                    }
                    ;
                    y = (V,la)=>{
                        const x = "Q{" + V + "}" + la
                          , K = ea[x];
                        if (K)
                            return "s" === K;
                        V = Y(V, la);
                        ea[x] = V ? "s" : "p";
                        return V
                    }
                }
            else
                y = ()=>!1;
            return function(I) {
                D(I);
                return I
            }
        }
        function q(z, D, y) {
            function I(S) {
                S = new Ud(S);
                Y.fixed.Ji = S;
                return new Zd.Fc(S)
            }
            function R() {}
            function M() {
                W && !y.lg && m(Y)
            }
            var ca = cd.qb(z, "strip")[0] || cd.qb(z, "strip.all")[0];
            let ea = null;
            if (ca || W)
                ea = c(ca),
                D && ea && (D = ea(D));
            y.Vh && y.Vh(z);
            y.ql = null;
            const ja = y.async
              , Y = A(z, D, y);
            Y.fixed.wl = Y.fixed.yd.Za.version;
            O(Y, function(S) {
                return "globalParam" === S.N && S.flags && -1 !== S.flags.indexOf("r")
            }).map(function(S) {
                return S.name
            }).map(function(S) {
                if ("undefined" === typeof Y.fixed.options.Sh.get(La.XS.QName.fromEQName(S)))
                    throw new F("No value has been provided for required stylesheet parameter '" + S + "'","XTDE0050");
            });
            Y.fixed.Ee = ea;
            D && (ac.wc(D),
            Y.fixed.tb[D._saxonBaseUri] = D);
            const V = y.destination || "application"
              , la = y.resultForm || "default";
            if (y.dd) {
                let S = y.dd("testURI");
                ["document", "serialized", "raw"].includes(S.destination) && !S.save && (y.dd = function() {
                    return new je(S.destination,y.resultDocuments)
                }
                )
            }
            y.dd || (y.dd = W ? function() {
                return new ie("html-page",function(S, da) {
                    y.resultDocuments[S.toString()] = da
                }
                )
            }
            : ja ? function() {
                return new ie("file",function(S, da, fa) {
                    da = B.writeFileAsync(S, da, fa);
                    sa.Ma("Promising to write to " + S, 2, Y.fixed.Ta);
                    Y.fixed.zd.push(da)
                }
                )
            }
            : function() {
                return new ie("file",function(S, da, fa) {
                    sa.Ma("Writing to " + S, 2, Y.fixed.Ta);
                    B.writeFileSync(S, da, fa)
                }
                )
            }
            );
            let x;
            const K = {};
            ca = Y.fixed.yd;
            var U = ca.mg["#unnamed"];
            if (U) {
                U = U.C;
                var ha, T;
                for (var w = 0; w < U.length; w++) {
                    let S = U[w].name;
                    "parameter-document" === S ? ha = U[w].value : "Q{http://saxon.sf.net/}parameter-document-base-uri" === S ? T = U[w].value : K[S] = "use-character-maps" === S ? ge.yf(S, U[w].value, ca) : ge.zf(S, U[w].value)
                }
                ha && T && (ha = pa.Fb(ha, T),
                ha = Nd.Dc(ha, Y),
                ge.parseParamDoc(ha.documentElement, K))
            }
            if (y.Pa)
                for (let[S,da] of Object.entries(y.Pa))
                    ha = "use-character-maps" === S ? Array.isArray(da) ? ge.uj(da, ca) : ge.jj(da) : da,
                    K[S] = ge.pf(S, ha, K[S]);
            if (["appendToBody", "prependToBody", "replaceBody"].includes(V))
                if (W) {
                    Y.ja = window.document;
                    const S = Vd(Y);
                    R = function() {
                        S.fd = new Wd(S.fd);
                        const da = I(S);
                        da.Ea();
                        return da
                    }
                    ;
                    M = function() {
                        S.za();
                        S.close();
                        const da = qa.Ka(S.result()[0]);
                        if (da) {
                            const fa = window.document.body;
                            if ("appendToBody" === V)
                                da.forEachItem(function(na) {
                                    fa.appendChild(na)
                                });
                            else if ("prependToBody" === V) {
                                const na = fa.firstChild;
                                da.forEachItem(function(va) {
                                    fa.insertBefore(va, na)
                                })
                            } else if ("replaceBody" === V) {
                                for (; 0 < fa.childNodes.length; )
                                    fa.removeChild(fa.childNodes[0]);
                                da.forEachItem(function(na) {
                                    fa.appendChild(na)
                                })
                            }
                        } else
                            throw new F("No result from transformation","SXJS0006");
                        W && !y.lg && m(Y)
                    }
                } else
                    throw new F("Destination=" + V + " is allowed only when running in the browser","SXJS0006");
            else if (["serialized", "file", "stdout"].includes(V)) {
                let S;
                if ("stdout" === V)
                    S = B.getStdOut();
                else {
                    let da = ""
                      , fa = !1;
                    S = {
                        write: function(na) {
                            fa = !0;
                            da += na
                        },
                        end: "serialized" === V ? function() {
                            y.principalResult = fa ? n(Tb(da), la) : null
                        }
                        : function() {
                            var na = K.encoding || "utf-8";
                            fa && (ja ? (na = B.writeFileAsync(new URL(y.Ib), da, na),
                            Y.fixed.zd.push(na)) : B.writeFileSync(new URL(y.Ib), da, na))
                        }
                    }
                }
                R = function() {
                    x = ge.qh(K, S, Y);
                    return I(x)
                }
            } else if (["raw", "document", "application"].includes(V)) {
                let S = "document" === V;
                "application" === V && ("undefined" !== typeof K["build-tree"] ? S = K["build-tree"] : S = !0);
                const da = Vd(Y);
                R = function() {
                    x = da;
                    S && (x = new $d(da));
                    return I(x)
                }
                ;
                M = function() {
                    y.principalResult = 0 === da.result().length ? null : n(Kb(da.Ob), la);
                    W && !y.lg && m(Y, y.mi)
                }
            } else
                throw new F("Invalid SaxonJS.transform() destination: " + V + " : " + typeof V,"SXJS0006");
            ha = y.Yi;
            if (T = y.Zi)
                T = T.toString(),
                /^Q{/.test(T) || (T = "Q{}" + T);
            U = (U = y.Xi) ? U.toString() : z.defaultMode || "";
            "#unnamed" === U && (U = "");
            "#default" === U && (U = z.defaultMode || "");
            "" !== U && 0 > U.indexOf("Q{") && (U = "Q{}" + U);
            ca = d(Y, U);
            if (!ca)
                throw new F("Unknown initial mode " + U,"XTDE0045");
            w = "Q{" + Zb.Wc + "}initial-template";
            D || ha || T || l(Y, w) && (T = w);
            let Z = y.Wi;
            if (Z) {
                D = y.ih ? y.ih : [];
                ha = D.length;
                T = r(Y, Z.toString(), ha);
                if (!T)
                    throw new F("Unknown initial function " + Z + "#" + ha,"XTDE0041");
                if ("PUBLIC" !== T.Za.vis && "FINAL" !== T.Za.vis)
                    throw new F("Uninvocable initial function " + Z + "#" + ha + " with visibility " + T.Za.vis,"XTDE0041");
                const S = T.Za.C[0];
                Y.focus = {};
                Y.sa = T;
                gd(Y);
                Y.qa = "function";
                Y.gb = ca;
                Y.ab = null;
                let da = 0;
                Y.oa = D.map(function(fa) {
                    var na = S.C[da++].as;
                    na = ec(na || "*");
                    return cd.Uf(cd.Ra(fa), na, ()=>"function parameter for " + Z)
                });
                D = R();
                Zd.push(cd.da(S, "body"), Y, D);
                D.close()
            } else if (T) {
                ha = l(Y, T);
                if (!ha)
                    throw new F("Unknown initial template " + T,"XTDE0040");
                T = ha.actor;
                Y.fixed.hd ? Y.focus = Rb(D) : (Y.focus = Sb(Ob),
                Y.focus.next());
                cd.Tf(T, Y);
                Y.sa = ha;
                Y.gb = ca;
                E(y, Y);
                D = R();
                Zd.push(T.C[0], Y, D);
                D.close()
            } else {
                Array.isArray(ha) && ea && ha.filter(ac.X).map(function(S) {
                    return ac.jf(S) ? S : S.ownerDocument
                }).map(function(S) {
                    return ea(S)
                });
                if ("PRIVATE" === ca.visibility && U !== z.defaultMode && "" !== U)
                    throw new F("Uninvokable initial mode " + U + " with visibility " + ca.Za.vis,"XTDE0045");
                if (!D && !ha)
                    throw new F("No source input supplied for apply-templates invocation","XTDE0044");
                T = ca.mode;
                Y.sa = ca;
                Y.focus = Sb(ha ? Kb(Array.isArray(ha) ? ha : [ha]) : Pb(D));
                D = T.Re.useAcc;
                null != D && "#all" !== D && (Y.Ge = D.split(/\s+/));
                E(y, Y);
                D = R();
                T.Hb(Y, D);
                D.close()
            }
            M();
            if (ja) {
                function S() {
                    const da = Y.fixed.zd;
                    Y.fixed.zd = [];
                    return Promise.all(da).then(()=>{
                        if (0 < Y.fixed.zd.length)
                            return S()
                    }
                    ).catch(fa=>{
                        throw fa;
                    }
                    ).then(()=>Promise.resolve(new he(y.principalResult,y.resultDocuments,z,y.masterDocument)))
                }
                y.Dj = S()
            }
        }
        function E(z, D) {
            z.Fe && (sa.assert(z.Fe instanceof cc, "options?templateParams must be an instance of HashTrie. Supplied:" + z.Fe),
            D.Kc = z.Fe);
            z.Qb && (sa.assert(z.Fe instanceof cc, "options?tunnelParams must be an instance of HashTrie. Supplied:" + z.Qb),
            D.Qb = z.Qb)
        }
        function H(z) {
            let D = "";
            for (const y in z)
                z.hasOwnProperty(y) && z[y] && (D += y + "=" + z[y].toString().substring(0, 30) + "(" + typeof y + "), ");
            return D
        }
        function p(z) {
            let D = z.stylesheetInternal || null;
            if (!D) {
                if (z.Pb)
                    var y = B.readFile(z.Pb);
                else if (z.tg)
                    y = z.tg;
                else if (z.jc) {
                    if (W)
                        throw new F("Cannot supply stylesheetFileName in browser","SXJS0006");
                    y = B.readFile(z.jc)
                } else
                    throw new F("No stylesheet supplied","SXJS0006");
                try {
                    D = JSON.parse(y)
                } catch (R) {
                    throw new F("Supplied SEF is not in JSON format","SXJS0006");
                }
            }
            t(D, z);
            D.PRIMED || (C(D),
            g(D),
            D.PRIMED = !0);
            "true" === D.relocatable && (z.md = !0);
            y = z.tf || null;
            let I;
            y && (I = z.tf.baseURI || z.Ud) && (y._saxonBaseUri = I);
            if (!y) {
                let R;
                if (z.Uc)
                    I = z.Uc,
                    R = B.readFile(I);
                else if (z.uf)
                    I = z.Ud,
                    R = z.uf;
                else if (z.Tc) {
                    if (W)
                        throw new F("Cannot supply sourceFileName in browser","SXJS0006");
                    I = z.Tc;
                    R = B.readFile(I)
                }
                R && ("json" === z.Ph ? y = Md.ze(R, null) : (y = B.parseXmlFromString(R),
                I && (y._saxonBaseUri = y._saxonDocUri = I)))
            }
            q(D, y, z);
            return new he(z.principalResult,z.resultDocuments,D,z.masterDocument)
        }
        function g(z) {
            z.C && z.C.forEach(function(D) {
                D.parentNode = z;
                g(D)
            })
        }
        function e(z) {
            if (z instanceof cc)
                return z;
            const D = new cc;
            z && Object.keys(z).forEach(y=>D.inSituPut(La.XS.QName.fromEQName(y), cd.Ra(z[y])));
            return D
        }
        function k(z) {
            const D = {};
            for (let[y,I] of Object.entries(z))
                D[y] = "use-character-maps" === y ? I : ge.pf(y, I, null);
            return D
        }
        function v(z) {
            const D = (y,I)=>{
                let R = null;
                for (let M of I)
                    if (y[M]) {
                        if (R)
                            throw new F("The following transform options are mutually exclusive: " + I.toString(),"SXJS0006");
                        R = M
                    }
                return R
            }
            ;
            D(z, ["stylesheetText", "stylesheetInternal", "stylesheetLocation", "stylesheetFileName"]);
            D(z, ["sourceNode", "sourceText", "sourceLocation", "sourceFileName"]);
            return {
                tg: z.stylesheetText,
                stylesheetInternal: z.stylesheetInternal,
                Pb: z.stylesheetLocation,
                jc: z.stylesheetFileName,
                Vd: z.stylesheetBaseURI,
                Sh: e(z.stylesheetParams),
                tf: z.sourceNode,
                uf: z.sourceText,
                Uc: z.sourceLocation,
                Tc: z.sourceFileName,
                Ph: z.sourceType || "xml",
                Ud: z.sourceBaseURI,
                masterDocument: z.masterDocument,
                Zi: z.initialTemplate,
                Wi: z.initialFunction,
                ih: z.functionParams,
                Fe: e(z.templateParams),
                Qb: e(z.tunnelParams),
                Xi: z.initialMode,
                tb: z.documentPool,
                kc: z.textResourcePool,
                destination: z.destination,
                Ib: z.baseOutputURI || (z.masterDocument ? z.masterDocument._saxonBaseUri : void 0),
                Pa: z.outputProperties,
                principalResult: void 0,
                Xf: z.deliverMessage,
                dd: z.deliverResultDocument,
                Ac: z.collations,
                Tg: z.collectionFinder,
                Ta: z.logLevel,
                Vh: z.traceInjector,
                hd: z.globalContextItem,
                Yi: z.initialSelection,
                se: z.isDynamicStylesheet,
                md: z.isRelocatableStylesheet,
                language: z.language,
                zh: z.messages,
                resultDocuments: {},
                resultForm: z.resultForm,
                Mk: z.extraOptions,
                lg: z.nonInteractive,
                mi: z.attachEventsTo,
                async: z.async
            }
        }
        function t(z, D) {
            if ("package" === z.N) {
                const y = z.target || "not specified"
                  , I = z.targetVersion || ""
                  , R = z.saxonProduct;
                let M = z.saxonVersion || "9.8.0.5";
                R && !/Saxon/.test(M) && (M = R + " " + M);
                sa.Ma("SEF generated by " + M + " at " + (z.buildDateTime || "2000-01-01"), 2, D.Ta);
                if ("JS" !== y || "2" !== I)
                    throw new F("Supplied SEF is not customized for use with SaxonJS. The option -target:JS should be set when generating the export. target is: " + y,"SXJS0006");
                if ("9" === M.charAt(0))
                    throw new F("For use with SaxonJS 2.x, SEF must be generated by SaxonJ-EE 10.0 or later. Supplied SEF is generated by SaxonJ-EE version " + M,"SXJS0006");
                if (z.expiry && 0 > ma.cd.fromString(z.expiry).compareTo(ma.cd.fromDate(new Date, 0)))
                    throw new F("Development license for supplied stylesheet has expired","SXJS0006");
            } else
                throw new F("Supplied SEF does not have correct format","SXJS0006");
        }
        function C(z) {
            function D(ea, ja) {
                ja <<= 8;
                for (let Y = 0; Y < ea.length; Y++)
                    ja = (ja << 1) + ea.charCodeAt(Y);
                return ja
            }
            function y(ea, ja, Y) {
                return D(ea, Y) ^ D(ja, Y)
            }
            function I(ea) {
                R ^= y(ea.N, "http://ns.saxonica.com/xslt/export", M++);
                for (let ja in ea)
                    !ea.hasOwnProperty(ja) || "N" === ja || "C" === ja || "ELAB" === ja || "PUSH" === ja || "parentNode" === ja || "catch" === ea.N && "test" == ja || ja === String.fromCharCode(931) || (R ^= y(ja, "", M),
                    R ^= D(ea[ja], M));
                ea.C && ea.C.forEach(function(ja) {
                    I(ja)
                });
                R ^= 1
            }
            let R = 0
              , M = 0;
            I(z);
            z = z[String.fromCharCode(931)] || "unspecified";
            const ca = (0 > R ? 4294967295 + R + 1 : R).toString(16);
            if (ca !== z) {
                if ("unspecified" === z)
                    throw new F("No checksum found in SEF","SXJS0006");
                throw new F("Invalid checksum in SEF " + z + " != " + ca,"SXJS0006");
            }
        }
        function m(z, D=null) {
            function y(R, M) {
                function ca(ja) {
                    const Y = ja.target;
                    var V = z.ba(!0);
                    V.qa = !1;
                    V.ie = ja;
                    V.focus = Sb(Pb(cd.Ra(Y)[0]));
                    V.sa = R;
                    ja = Vd(z);
                    ja = new Zd.Fc(ja);
                    (V = ea.Hb(V, ja)) && V.expand()
                }
                const ea = R.mode;
                -1 === "httpabort afterprint beforeprint beforeunload hashchange languagechange message offline online pagehide pageshow popstate storage unhandledrejection unload resize".split(" ").indexOf(M) ? D ? D.addEventListener(M, ca, !1) : window.document.addEventListener(M, ca, !1) : window.addEventListener(M, ca, !1)
            }
            const I = z.fixed.La;
            Object.keys(I).forEach(function(R) {
                R = I[R];
                R.mode && R.mode.th() && (R.name.split("}on")[1] ? y(R, R.name.split("}on")[1]) : console.log("Invalid event handler name:", R.name))
            })
        }
        function f(z, D) {
            return z.C ? z.C.filter(function(y) {
                return y.N === D
            }) : []
        }
        function A(z, D, y) {
            function I(Y, V) {
                R(z, Y, V)
            }
            function R(Y, V, la) {
                Y.N === V && la(Y);
                Y.C && Y.C.forEach(function(x) {
                    R(x, V, la)
                })
            }
            function M(Y) {
                return (Y = Y.name) ? /^Q\{/.test(Y) ? Y : "Q{}" + Y : null
            }
            function ca(Y, V) {
                function la(x) {
                    x = f(x, "co");
                    for (let K = 0; K < x.length; K++)
                        V(x[K])
                }
                la(Y);
                Y.C && (Y = Y.C.filter(function(x) {
                    return "overridden" === x.N
                }),
                Y[0] && la(Y[0]))
            }
            function ea(Y, V) {
                const la = Y.C ? Y.C[0] : null;
                return null === la ? Y.base ? ea(V.fixed.La[parseInt(Y.base, 10)].Za, V) : null : la
            }
            const ja = new ne;
            ja.fixed = {
                Rd: {},
                Ib: y.Ib || "",
                La: {},
                Jb: new Date,
                tb: {},
                ka: cd,
                hd: y.hd || D,
                se: y.se,
                md: y.md,
                Lf: 0,
                options: y,
                rd: {},
                vd: {},
                Jh: {},
                staticBaseURI: "",
                sl: z,
                kc: {},
                yd: null,
                zd: [],
                Bj: [],
                depth: 0,
                Ta: y.Ta || sa.getLogLevel()
            };
            if (y.tb) {
                const Y = y.tb;
                Object.keys(Y).forEach(V=>{
                    const la = Y[V];
                    if (ac.jf(la))
                        ja.fixed.tb[V] = la;
                    else
                        throw new F("Supplied value for " + V + " is not a document node");
                }
                )
            }
            if (y.kc) {
                const Y = y.kc;
                Object.keys(Y).forEach(V=>{
                    ja.fixed.kc[V] = Y[V].toString()
                }
                )
            }
            y.Ac || (y.Ac = {});
            y.Ac[Hd.$c] = Hd.Sg();
            y.Ac[Hd.gh] = Hd.Ze();
            y.Ac[Hd.jg] = Hd.Mg();
            y.Ac[Hd.Zh] = Hd.Ze();
            I("package", function(Y) {
                const V = {
                    name: Y.name,
                    Za: Y,
                    Gb: {},
                    Og: {},
                    hb: {},
                    mg: {},
                    keys: {},
                    Wh: null
                };
                ja.fixed.rd[V.name] = V;
                ja.fixed.yd || (ja.fixed.yd = V);
                ca(Y, function(la) {
                    const x = parseInt(la.id, 10);
                    ja.fixed.La[x] = {
                        id: x,
                        visibility: la.vis,
                        Za: la,
                        Dh: V,
                        actor: null,
                        We: la.binds.split(" ").map(function(K) {
                            return parseInt(K, 10)
                        })
                    }
                })
            });
            I("package", function(Y) {
                const V = ja.fixed.rd[Y.name];
                ca(Y, function(T) {
                    const w = ja.fixed.La[parseInt(T.id, 10)];
                    T = w.actor = ea(T, ja);
                    null !== T && (w.name = M(T),
                    "globalVariable" === T.N || "globalParam" === T.N ? w.value = null : "mode" === T.N && (w.mode = new Oh(T,cd),
                    null === M(T) && (V.Wh = w.mode)),
                    "ABSTRACT" === T.parentNode.vis && (w.visibility = "ABSTRACT"))
                });
                if (0 < f(Y, "schema").length)
                    throw new F("Package includes xsl:import-schema but SaxonJS is not schema-aware","XTSE1650");
                var la = f(Y, "decimalFormat");
                for (var x = 0; x < la.length; x++) {
                    var K = la[x]
                      , U = M(K);
                    V.hb[null === U ? "Q{}" : U] = K
                }
                la = f(Y, "output");
                for (x = 0; x < la.length; x++)
                    K = la[x],
                    U = K.name ? M(K) : "#unnamed",
                    V.mg[U] = K;
                la = f(Y, "key");
                x = Math.floor(1E8 * Math.random());
                for (K = 0; K < la.length; K++) {
                    U = la[K];
                    var ha = M(U);
                    V.keys[ha] ? V.keys[ha].Ld.push(U) : V.keys[ha] = {
                        vg: x + "k" + K,
                        Ld: [U]
                    }
                }
                la = f(Y, "accumulator");
                x = Math.floor(1E8 * Math.random());
                for (K = 0; K < la.length; K++)
                    U = la[K],
                    ha = M(U),
                    V.Gb[ha] = {
                        vg: x + "a" + K,
                        gi: U
                    };
                Y = f(Y, "charMap");
                for (la = 0; la < Y.length; la++) {
                    x = Y[la];
                    K = M(x);
                    let T = {
                        min: 0,
                        max: 0,
                        ya: {}
                    };
                    x.C && (x.C.forEach(function(w) {
                        let Z = Number(w.c);
                        0 === T.min ? T.min = Z : Z < T.min && (T.min = Z);
                        Z > T.max && (T.max = Z);
                        T.ya[Z] = w.s
                    }),
                    55296 < T.min && (T.min = 55296));
                    V.Og[K] = T
                }
            });
            I("glob", function(Y) {
                const V = ja.fixed.hd;
                if ("req" === Y.use && (null === V || void 0 === V))
                    throw new F("The stylesheet requires a global context item","XTDE3086");
                if ("pro" === Y.use)
                    ja.fixed.hd = null;
                else {
                    let la;
                    const x = Y.cxt;
                    x && (la = fc(x).ia());
                    if (null !== V && la && !la(V))
                        throw new F("The global context item must be an instance of " + Y.type,"XTTE0590");
                }
            });
            ja.ub = y.Ib ? [y.Ib] : [];
            !y.se && y.md && (D = "",
            y.Vd ? D = y.Vd : y.Pb ? D = y.Pb : y.jc ? D = B.fileURL(y.jc) : W && (D = B.baseURL()),
            ja.fixed.staticBaseURI = D);
            y.se && y.md && y.Vd && (ja.fixed.staticBaseURI = y.Vd);
            if (W) {
                if (ja.masterDocument = y.masterDocument ? y.masterDocument : window.document,
                y.Pb && !ac.ld(y.Pb))
                    throw new F("stylesheetLocation should be absolute by now","SXJS0004");
            } else if (y.masterDocument) {
                if (!ac.X(y.masterDocument) || ![9, 11].includes(y.masterDocument.nodeType))
                    throw new F("masterDocument must be a document node","SXJS0004");
                ja.masterDocument = y.masterDocument
            }
            ja.masterDocument && !ja.masterDocument._saxonBaseUri && ja.masterDocument.baseURI && (y = ja.masterDocument.baseURI,
            D = y.indexOf("#"),
            ja.masterDocument._saxonBaseUri = 0 <= D ? y.substring(0, D) : y);
            ja.sa = null;
            ja.ja = B.createDocument();
            ja.j = ja.ja.createDocumentFragment();
            ja.oa = [];
            ja.Kc = new cc;
            ja.Qb = new cc;
            ja.uc = {};
            return ja
        }
        function O(z, D) {
            const y = []
              , I = f(z.fixed.yd.Za, "co");
            for (let R = 0; R < I.length; R++) {
                const M = z.fixed.La[parseInt(I[R].id, 10)]
                  , ca = M.actor;
                ca && D(ca) && y.push(M)
            }
            return y
        }
        function b(z, D) {
            const y = f(z.fixed.yd.Za, "co");
            for (let I = 0; I < y.length; I++) {
                const R = z.fixed.La[parseInt(y[I].id, 10)]
                  , M = R.actor;
                if (M && D(M))
                    return R
            }
        }
        function d(z, D) {
            return b(z, function(y) {
                return "mode" === y.N && (y.name ? y.name === D : "" === D)
            })
        }
        function l(z, D) {
            return b(z, function(y) {
                return "template" === y.N && y.name === D
            })
        }
        function r(z, D, y) {
            return b(z, function(I) {
                return "function" === I.N && I.name === D && f(I, "arg").length === y
            })
        }
        function n(z, D) {
            function y(M) {
                return cd.sb(M, !0)
            }
            if ("iterator" === D)
                return z.mapOneToOne(y);
            if ("xdm" === D)
                return z.expand();
            const I = [];
            let R;
            for (; null != (R = z.next()); )
                I.push(y(R));
            switch (D) {
            case "iterator":
                return Kb(I);
            case "array":
                return I;
            default:
                return 0 === I.length ? null : 1 === I.length ? I[0] : I
            }
        }
        let B = {};
        const W = "undefined" !== typeof window
          , ma = La.XS
          , qa = ac.Ja
          , L = {
            autoResetIndexes: !0
        }
          , aa = {
            atom: function(z, D) {
                if ("boolean" === typeof z)
                    z = La.XS.boolean.fromBoolean(z);
                else if ("number" === typeof z)
                    z = La.XS.double.fromNumber(z);
                else if ("string" === typeof z)
                    z = La.XS.string.fromString(z);
                else
                    throw new F("Value must be boolean, number, or string","SXJS0006");
                if (D) {
                    const y = La.type[D];
                    if (y)
                        return y.R(z);
                    throw new F("Unknown type " + D,"SXJS0006");
                }
                return z
            },
            Atomic: La,
            internals: {
                Codepoint: Ga,
                Compare: Hd,
                Diag: sa,
                DomUtils: ac,
                Expr: cd,
                Iter: Yb,
                NsConst: Zb,
                Push: Zd,
                Regex: Ha
            },
            transform: function(z, D) {
                function y(V) {
                    V = B.resolveUri(V.toString(), R);
                    return W ? V : B.fileURL(V)
                }
                D = !D || "sync" === D;
                sa.Ma((D ? "Synchronous" : "Asynchronous") + " transform with options: " + H(z), 2, z.logLevel);
                let I;
                try {
                    I = v(z),
                    I.Pa && (I.outputProperties = k(I.Pa))
                } catch (V) {
                    if (D)
                        throw V;
                    return Promise.reject(V)
                }
                const R = B.baseURL();
                if (I.Pb)
                    var M = I.Pb = y(I.Pb);
                else
                    I.jc && (M = I.jc = y(I.jc));
                I.Vd = M || I.Vd;
                if (I.Uc)
                    var ca = I.Uc = y(I.Uc);
                else
                    I.Tc && (ca = I.Tc = y(I.Tc));
                I.Ud = ca || I.Ud;
                if (D)
                    return p(I);
                I.async = !0;
                let ea, ja, Y;
                z = [];
                ea = I.stylesheetInternal || null;
                if (!ea)
                    if (M = I.tg)
                        try {
                            ea = JSON.parse(M)
                        } catch (V) {
                            z.push(Promise.reject(new F("Error parsing supplied SEF: " + V,"SXJS0006")))
                        }
                    else
                        I.jc ? (M = B.resourcePromise({
                            file: I.jc,
                            encoding: "utf-8"
                        }).then(V=>{
                            ea = JSON.parse(V)
                        }
                        ).catch(V=>Promise.reject(new F("Failed to read JSON input " + I.jc + ": " + V,"SXJS0006"))),
                        z.push(M)) : I.Pb ? (M = B.resourcePromise({
                            location: I.Pb,
                            encoding: "utf-8",
                            type: "json"
                        }).then(V=>{
                            ea = JSON.parse(V)
                        }
                        ).catch(V=>Promise.reject(new F("Failed to read JSON input " + I.Pb + ": " + V,"SXJS0006"))),
                        z.push(M)) : z.push(Promise.reject(new F("No stylesheet supplied","SXJS0006")));
                ja = I.tf || null;
                Y = I.Ph || "xml";
                ja && (M = I.tf.baseURI || I.Ud) && (ja._saxonBaseUri = M);
                if (!ja) {
                    M = (la,x)=>{
                        la = Nd.Rg(Nd.Qg(la));
                        la = B.parseXmlFromString(la);
                        x && (la._saxonBaseUri = la._saxonDocUri = x);
                        return la
                    }
                    ;
                    ca = la=>Md.ze(la, null);
                    const V = "xml" === Y ? M : ca;
                    I.uf ? ja = V(I.uf, I.Ud) : I.Tc ? (M = B.resourcePromise({
                        file: I.Tc
                    }).then(la=>ja = V(la, I.Tc)).catch(la=>Promise.reject(new F(`Failed to read ${Y.toUpperCase()} source input (${la.message})`,"SXJS0006"))),
                    z.push(M)) : I.Uc && (M = B.resourcePromise({
                        location: I.Uc
                    }).then(la=>{
                        ja = V(la, I.Uc)
                    }
                    ).catch(la=>Promise.reject(new F(`Failed to read ${Y.toUpperCase()} source input (${la.message})`,"SXJS0006"))),
                    z.push(M))
                }
                return Promise.all(z).then(()=>{
                    var V = ea
                      , la = ja
                      , x = I;
                    if (!V)
                        throw new F("No stylesheet supplied","SXJS0006");
                    try {
                        t(V, x);
                        V.PRIMED || (C(V),
                        g(V),
                        V.PRIMED = !0);
                        "true" === V.relocatable && (x.md = !0);
                        q(V, la, x);
                        var K = x.Dj
                    } catch (U) {
                        throw console.log("Transformation failure: " + (U.getMessage ? U.getMessage() : U)),
                        U;
                    }
                    return K
                }
                )
            },
            Serializer: ge,
            serialize: function(z, D) {
                const y = {
                    "iso-8859-1": "latin1",
                    "iso-646": "ascii"
                };
                z = ge.serialize(z, D);
                return D && D.encoding ? (D = D.encoding,
                D = y[D] || D,
                pa.makeBuffer(z, D)) : z
            },
            StringWriter: ge.StringWriter,
            getProcessorInfo: function() {
                return {
                    version: 3,
                    vendor: "Saxonica",
                    vendorURL: "https://www.saxonica.com/",
                    productName: "SaxonJS",
                    productVersion: "2.6",
                    isSchemaAware: !1,
                    supportsSerialization: !0,
                    supportsBackwardsCompatibility: !0,
                    supportsNamespaceAxis: !0,
                    supportsStreaming: !1,
                    supportsDynamicEvaluation: !0,
                    supportsHigherOrderFunctions: !0,
                    xPathVersion: 3.1,
                    xsdVersion: 1.1,
                    releaseDate: "2023-10-13"
                }
            },
            getResource: function(z) {
                const D = z.type || "text";
                let y;
                if (z.file) {
                    var I = B.resourcePromise(z);
                    y = B.fileURL(z.file)
                } else if (z.location)
                    if (I = z.location,
                    I instanceof URL || (I = B.newURL(I, B.baseURL()),
                    z.location = I.toString()),
                    y = I.href,
                    "file:" === I.protocol)
                        I = B.resourcePromise(z);
                    else if (["http:", "https:"].includes(I.protocol))
                        I = B.resourcePromise(z);
                    else
                        return Promise.reject(new F("Unsupported URL protocol " + I.protocol,"SXJS0006"));
                else if (z.text)
                    I = Promise.resolve(z.text),
                    z.baseURI && (y = z.baseURI);
                else
                    return Promise.reject(new F("No resource supplied","SXJS0006"));
                "xml" === D ? I = I.then(R=>{
                    try {
                        const M = ac.wc(B.parseXmlFromString(R));
                        M._saxonBaseUri = M._saxonDocUri = y;
                        return Promise.resolve(M)
                    } catch (M) {
                        return Promise.reject(new F("Failed parsing XML in " + y + ": " + M.message,M.code))
                    }
                }
                ) : "json" === D && (I = I.then(R=>{
                    try {
                        return Promise.resolve(Md.ze(R, new cc, new ne))
                    } catch (M) {
                        return Promise.reject(new F("Failed parsing JSON in " + y + ": " + M.message,M.code))
                    }
                }
                ));
                return I
            },
            setLogLevel: sa.setLogLevel,
            getLogLevel: sa.getLogLevel,
            setPlatform: a,
            getPlatform: function() {
                return B
            },
            getNavigator: function() {
                return window.navigator.userAgent
            },
            timeStamp: W && window.performance && window.performance.now ? window.performance.now : function() {
                return Date.now().valueOf()
            }
            ,
            internalTransform: q,
            checkOptions: v,
            convertResult: n,
            makeAtomicValue: function(z, D) {
                return La.type[z].fromString(D)
            },
            registerExtensionFunctions: function(z) {
                Jh.Nf(z);
                Mh.Nf(z)
            },
            getItemDetails: function(z) {
                if (La.pa(z)) {
                    const D = {
                        variety: "atomic",
                        type: z.type,
                        value: z.toString()
                    };
                    "AQ" === z.code && (D.prefix = z.prefix,
                    D.uri = z.uri,
                    D.local = z.local);
                    return D
                }
                return ac.X(z) ? {
                    variety: "node",
                    type: z.nodeType()
                } : {
                    variety: z instanceof $c ? "array" : "map"
                }
            },
            getConfigurationProperties: function() {
                const z = {};
                Object.keys(L).forEach(D=>{
                    z[D] = L[D]
                }
                );
                return z
            },
            getConfigurationProperty: function(z) {
                if (z in L)
                    return L[z]
            },
            setConfigurationProperties: function(z) {
                const D = {};
                Object.keys(L).forEach(y=>{
                    D[y] = L[y]
                }
                );
                Object.keys(z).forEach(y=>{
                    "autoResetIndexes" == y ? L[y] = !!z[y] : sa.Ma("The configuration property " + y + " is unrecognized")
                }
                );
                return D
            },
            setConfigurationProperty: function(z, D) {
                if ("autoResetIndexes" == z) {
                    let y = L[z];
                    L[z] = !!D;
                    return y
                }
                sa.Ma("The configuration property " + z + " is unrecognized")
            },
            resetIndexes: function(z) {
                W && !z && (z = window.document);
                return z && "_saxonIndexes"in z ? (delete z._saxonIndexes,
                delete z._saxonIndexesBC,
                !0) : !1
            },
            XdmArray: $c,
            XdmAtomicValue: Ja,
            XdmAttributeNode: $b,
            XdmFunction: ad,
            XdmMap: cc,
            XError: F,
            XPath: Eh,
            XS: ma
        };
        W || "undefined" !== typeof HostPlatform ? (HostPlatform.entryPoint = aa,
        a(HostPlatform),
        B.expose(aa, "SaxonJS")) : console.log("Platform binding delayed");
        aa.Developer = Nh;
        La.Kf();
        Ha.Kf();
        mc();
        Jd.register("SaxonJS", aa);
        return aa
    }
    )();
}
).call(this);
