# Coursera Code of Conduct

The Coursera platform includes people from all around the world, and from a wide variety of different backgrounds, religions, and cultural norms. This diversity is one of the things that makes our Community great but it can also make communication challenging.

The purpose of our Coursera Code of Conduct is to ensure that the Coursera platform remains a welcoming, friendly and supportive place for all members – regardless of their color, religion, national origin, sex, age, sexual orientation, gender identity or expression, personal appearance, political affiliation, marital status, family responsibilities/parenthood, veteran status, education, disability, genetic information, and any other legally protected class. 

The Code of Conduct has been prepared in conjunction with members of the community, learners, instructors, and administrators to gather input and assure representation of diverse views. These rules will continue to be developed in a manner that involves all stakeholders in the development and implementation of fair online learning rules.

The Code of Conduct reflects the ethics and values of the Coursera platform and community. To address and respond to the ongoing collection of data on violence, cyberbullying, harassment, and intimidation, the code will be reviewed annually by the Coursera community through a meeting of users, instructors, and administrators and will be disseminated annually to users via electronic and other media.

This is not intended to be an exhaustive list, rather it is intended as a guide for the kind of interactions we want to see on this platform. Ultimately, the Coursera team can make the final decision on whether a behavior is acceptable or not.

## Coursera guidelines

This Code of Conduct applies to all forum posts and private messages posted on Coursera, including [coursera.org](http://coursera.org/), the [Coursera Community](https://www.coursera.support/s/community), and all course discussion forums

- We expect all activity on the platform to follow the Code of Conduct. If you do not follow the Code of Conduct, you or your posts may be removed from Coursera.
- Coursera and our partners may provide helpful information within the platform, though we are not able to respond to every post. Peer responses, while helpful and appreciated, are not communications from Coursera or our partners.
- You own the rights to any content you post in the Coursera platform. Coursera is granted a perpetual, worldwide, royalty-free, non-exclusive license to use and commercialize any content you post in the platform. By posting on the platform, you grant Coursera the right to use any content within the post without restriction or compensation.
- Coursera is permitted to use any content you post in the Community, on other parts of [coursera.org](http://coursera.org/), on our social media channels, in our marketing materials, or in articles about Coursera printed or posted by third parties. When using your content in this way, Coursera will ask permission before using your image or full name alongside any content you’ve posted. For such use cases, all rights to the final work will be retained by Coursera.
- Unless otherwise stated, all content posted on the Coursera platform is publicly visible and searchable online.
- If you delete your Coursera account, your Community posts and private messages will be anonymized.

## Your responsibilities as a Coursera user

**All users have the responsibility to:**

- Contribute to maintaining a safe, supportive, and orderly online learning environment that is conducive to learning and to show respect and dignity to other persons and to property.
- Be familiar with and abide by all Coursera policies, rules, and regulations dealing with user conduct.
- React to direction given by instructors, administrators, and other Coursera personnel in a respectful, positive manner.
- Maintain behavior free from all forms of bullying, harassment, and discrimination.
- Ask questions when they do not understand.
- Seek help in solving problems that might lead to discipline.
- Accept responsibility for their actions.

## Inappropriate behavior

We want all Coursera users to have the best possible experience they can. In order to be clear with what that means, we've provided **a list of examples of behaviors that are inappropriate for Coursera users:**

- **Dangerous speech.** Any form of expression (e.g. speech, text, or images) that can increase the risk that its audience will condone or commit violence against members of another group. Key traits of dangerous speech: Aimed at groups, promotes fear, often false, and harms indirectly. Dangerous speech can include: Coded language (terms familiar to in-group).
- **Harassment or deliberate intimidation.** This includes offensive verbal comments related to gender, sexual orientation, disability, physical appearance, body size, race, religion, sexual images in public spaces, stalking, and/or deliberate intimidation.
- **Violence or threats of violence.** Violence and threats of violence are not acceptable - online or offline. This includes incitement of violence toward any individual, including encouraging a person to commit self-harm. This also includes posting or threatening to post other people's personally identifying information (doxxing) online.
- **Sexist, racist, homophobic, transphobic, ableist language, or otherwise exclusionary language.** This includes deliberately referring to someone by a gender that they do not identify with, and/or questioning the legitimacy of an individual's gender identity. If you're unsure if a word is derogatory, don't use it. This also includes repeated subtle and/or indirect discrimination.
- **Unwelcome sexual attention or behavior that contributes to a sexualized environment.** This includes sexualized comments, jokes or imagery in interactions, communications or presentation materials, as well as inappropriate sexual advances.
- **Influencing or encouraging inappropriate behavior.** If you influence or encourage another person to violate the Code of Conduct, you may face the same consequences as if you had violated the Code of Conduct.
- **Sustained disruption of online discussion, talks, or other events.** Sustained disruption of events, online discussions, or meetings, including talks and presentations, will not be tolerated. This includes 'talking over' or 'heckling' event speakers or influencing crowd actions that cause hostility in event sessions. 
- **Abuse of the peer review system.** This includes posing as another learner to give yourself a positive peer review; colluding with other users to give each other positive peer reviews; and posting discriminatory, violent, or otherwise abusive content in the peer review feedback space. See the [Coursera Honor Code](https://github.com/williamcwi/DeepLearning.AI-TensorFlow-Developer-Professional-Certificate/tree/master/Coursera_Honor_Code.md).
- **Retaliation.** Punishing someone for engaging in protected behavior is not permitted. This includes harassing, bullying, or filing a false report against a user for raising a sincere concern about your own behavior. It’s unacceptable to give a user a bad peer review on an assignment simply because you disliked the review you got on your assignment.

Coursera users are asked to stop any inappropriate behavior and are expected to comply immediately. If you are the subject of an incident report or if you wish to report inappropriate behavior, your personal data will be processed by Coursera as set forth in this Code of Conduct. You consent to such processing.

**Resources:**

- [Dangerous Speech: A Practical Guide](https://dangerousspeech.org/guide/) (updated August 2020). 
- The Dangerous Speech Project [Code of Conduct](https://dangerousspeech.org/code-of-conduct/)
- [Change the Terms](https://www.changetheterms.org/terms)
- [Comparing Platform Hate Speech Policies: Reddit's Inevitable Evolution](https://cyber.fsi.stanford.edu/io/news/reddit-hate-speech)
- [Citizens and Technology Lab](https://civilservant.io/)

## Community guidelines

Below is additional guidance to keep in mind when interacting in forums, like the Coursera Community or Course discussion forums.

**Respect**
Remember that context can get lost when communicating via text, and when one or more discussion participants is using a language that is not their native language. Strive to make sure your communication is clear and not unintentionally offensive. Emojis can be used to add context but cannot make up for a rude post.

- Always treat anyone using Coursera or working for Coursera with respect.
- Never make any posts which may upset or offend another person, including sexual images or descriptions, real or implied violence, or profanity.
- Never use language intended to attack, accuse, insult, harass, intimidate, oppress, derogate, or abuse another person on Coursera.
For more information, see Coursera’s [Acceptable Use Policy](https://www.coursera.org/about/terms/acceptableUse).

**Sensitivity and empathy**
Coursera has courses on many controversial or emotional subjects, such as terrorism, mental health, religion, politics, etc. Talking about things like this in our global Community helps us to learn more about the world and understand one another better. We expect discussions to be academic in nature, respectful, and open to all points of view.

- Never use any language which would be insensitive or offensive to someone based on gender, gender identity or expression, sexual orientation, disability, physical appearance, body size, race, religion, or political standpoint.

**Problems, feedback and criticism**
We welcome feedback that could be used to make the Coursera experience better.
- Please use the appropriate channels to provide such feedback or to report problems.
- Avoid simply being negative – constructive criticism is valued, unproductive negativity is not.
This Community is focused around learning, so it’s expected that members may make mistakes, get things wrong, or not understand fully. Feedback and critique are an important part of learning so please feel free to provide it when appropriate, keeping in mind the following:
- Always critique the actual work or method, not the person behind it,
- Never belittle someone for not knowing or understanding something,
- Give feedback privately if you think it may be embarrassing for the recipient, and
- If someone responds poorly to feedback don’t force them to take it, just stop interacting.

**Protecting your own privacy**
Avoid sharing your own or other people’s personal information publicly online. Don’t include any of the following in the body of a public post:
- First and last name
- Email address
- Phone number
- Address
- Account numbers
- Any other piece of information which could be used to identify or harm you or others
For more information, check out Coursera’s [Privacy Policies](https://www.coursera.org/about/privacy).

**Resolving and reporting problems**
Disagreements and misunderstandings are normal in such a diverse community. Ask for clarification and attempt to have a calm discussion before assuming that someone is being offensive. Don’t lower your own standards of communication in response.

If that isn’t possible, report the post by flagging it to our moderators.

Posts which do not adhere to the Code of Conduct may be edited or deleted.

## Potential consequences for violating the Code of Conduct
This list is not inclusive, and Coursera reserves the right to take any action it deems necessary. Possible responses to an incident include:

- Nothing, if the behavior was determined to not be a Code of Conduct violation
- A verbal or emailed warning
- Requiring that the reported person not direct message an online community member
- Requiring that the reported person not join specific Community channels or discussion forums
- Not publishing the video or slides of a talk that violated the Code of Conduct
- Immediately ending roles that the reported person holds such as translators, mentors, and beta testers
- Requiring that a person not participate as a translator, mentor, and/or beta tester
- Requiring that a person immediately leave the Course, Community Channel, and or/Coursera, and not return
- Removing the reported person from community online chat servers or mailing lists (either indefinitely or for a certain time period)
- Removing the reported person from admin or moderator rights to community infrastructure
- Removing a person from membership of relevant institutions

## Enforcement of the Code of Conduct
All reports made to Coursera will be taken seriously. Those who don’t follow the Code of Conduct in good faith may face repercussions deemed appropriate by our team. **This is how we will generally handle misconduct:** 

1. **Warning.** For most first-time misconduct, our team will remove offending content and send a warning. Most issues are resolved here.
2. **Account suspension.** For repetitive misconduct or behavior containing harassment, bigotry, or abuse, our team will impose temporary suspension. 
3. **Account expulsion.** For very rare cases, our team will expel people who display a pattern of harmful destructive behavior toward the Coursera community.

## Reporting a Code of Conduct incident
We encourage Coursera users to report any incidents that violate that Code of Conduct via this article. The report will be handled by the Coursera team and the user who violated the Code of Conduct will be contacted directly. 

[Contact our support team](https://learner.coursera.help/hc/articles/360036160591) to report a Code of Conduct incident. In your report, please provide the following information: 

- Link to the area of incident
- Screenshot of the violation and text
- Written text of the misconduct
- Visible name of user
If you are the subject of a reported incident or if you wish to report inappropriate behavior, we will strive to maintain the anonymity and confidentiality of all individuals involved. There may be times, however, when the Coursera team may request permission to identify the individual(s) in order to engage in necessary correspondence to gather additional information to be able to advocate for a fair process and resolution.

## Attribution

This Honor Code is adapted from [Coursera Code of Conduct](https://www.coursera.support/s/article/208280036-Coursera-Code-of-Conduct?). 