(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define('element/locale/en', ['module', 'exports'], factory);
    } else if (typeof exports !== "undefined") {
        factory(module, exports);
    } else {
        var mod = {
            exports: {}
        };
        factory(mod, mod.exports);
        global.ELEMENT.lang = global.ELEMENT.lang || {};
        global.ELEMENT.lang.en = mod.exports;
    }
})(this, function (module, exports) {
    'use strict';

    exports.__esModule = true;
    exports.default = {
        el: {
            colorpicker: {
                confirm: 'OK',
                clear: 'Clear'
            },
            datepicker: {
                now: 'Now',
                today: 'Today',
                cancel: 'Cancel',
                clear: 'Clear',
                confirm: 'OK',
                selectDate: 'Select date',
                selectTime: 'Select time',
                startDate: 'Start Date',
                startTime: 'Start Time',
                endDate: 'End Date',
                endTime: 'End Time',
                year: '',
                month1: 'Jan',
                month2: 'Feb',
                month3: 'Mar',
                month4: 'Apr',
                month5: 'May',
                month6: 'Jun',
                month7: 'Jul',
                month8: 'Aug',
                month9: 'Sep',
                month10: 'Oct',
                month11: 'Nov',
                month12: 'Dec',
                // week: 'week',
                weeks: {
                    sun: 'Sun',
                    mon: 'Mon',
                    tue: 'Tue',
                    wed: 'Wed',
                    thu: 'Thu',
                    fri: 'Fri',
                    sat: 'Sat'
                },
                months: {
                    jan: 'Jan',
                    feb: 'Feb',
                    mar: 'Mar',
                    apr: 'Apr',
                    may: 'May',
                    jun: 'Jun',
                    jul: 'Jul',
                    aug: 'Aug',
                    sep: 'Sep',
                    oct: 'Oct',
                    nov: 'Nov',
                    dec: 'Dec'
                }
            },
            select: {
                loading: 'Loading',
                noMatch: 'No matching data',
                noData: 'No data',
                placeholder: 'Select'
            },
            cascader: {
                noMatch: 'No matching data',
                placeholder: 'Select'
            },
            pagination: {
                goto: 'Go to',
                pagesize: '/page',
                total: 'Total {total}',
                pageClassifier: ''
            },
            messagebox: {
                title: 'Message',
                confirm: 'OK',
                cancel: 'Cancel',
                error: 'Illegal input'
            },
            upload: {
                delete: 'Delete',
                preview: 'Preview',
                continue: 'Continue'
            },
            table: {
                emptyText: 'No Data',
                confirmFilter: 'Confirm',
                resetFilter: 'Reset',
                clearFilter: 'All'
            },
            tree: {
                emptyText: 'No Data'
            }
        }
    };
    module.exports = exports['default'];
});