<h1 align="center">npm/yarn/pnpm Copilot</h1>

npm/yarn/pnpm copilot is a command-line tool that uses OpenAI's GPT-3 language model to provide suggestions for fixing errors in your code.

<div align="center">
    <img src="https://github.com/whoiskatrin/npm-copilot/blob/main/example.png" width="600" />
</div>

## 🌟 Frameworks:

- Next.js
- React
- Angular
- Vue.js

## 📖 How to use:

The CLI tool detects the project type and package manager being used in the current directory. It then runs the appropriate development server command (e.g., npm run dev, yarn run dev, pnpm run dev) and listens for logs generated by the running application. When an error is encountered, the CLI tool provides suggestions for error fixes in real-time.

## 🛠️ Installation

To install the npm-copilot package, run the following command:

```
npm install -g npm-copilot
```

Disclaimer:
The CLI tool will begin monitoring the logs generated by the Next.js application and provide suggestions for error fixes in real-time.

## ⚙️ Configuration

In order to use this package, you need to set your OpenAI API key as an environment variable. You can do this by adding the following line to your `.env` file, or by setting it directly in your terminal:

For Unix-based systems:

```
export OPENAI_API_KEY=your_api_key_here
```

For Windows systems:

```
set OPENAI_API_KEY=your_api_key_here
```

Replace your_api_key_here with your actual OpenAI API key.

## 🖥️ Usage

To use npm-copilot, navigate to the directory containing your Next.js project and run the following command:

```
npm-copilot
```

The CLI tool will begin monitoring the logs generated by the Next.js application and provide suggestions for error fixes in real-time.

## 📜 License

This package is licensed under the MIT [License](LICENSE).
