# frozen_string_literal: true

require 'test_helper'
require 'rubycritic/generators/html/turbulence'

describe RubyCritic::Turbulence do
  describe '::data' do
    it 'returns json data that maps pathname, churn and complexity to name, x and y' do
      files = [AnalysedModuleDouble.new(name: 'Foo', churn: 1, complexity: 2)]
      turbulence_data = RubyCritic::Turbulence.data(files)
      instance_parsed_json = JSON.parse(turbulence_data).first
      _(instance_parsed_json['name']).must_equal 'Foo'
      _(instance_parsed_json['x']).must_equal 1
      _(instance_parsed_json['y']).must_equal 2
    end
  end
end

class AnalysedModuleDouble < OpenStruct; end
