# frozen_string_literal: true

require 'test_helper'
require 'rubycritic/core/location'

describe RubyCritic::Location do
  describe 'attribute readers' do
    before do
      @path = './foo.rb'
      @line = '42'
      @location = RubyCritic::Location.new(@path, @line)
    end

    it 'has a pathname' do
      _(@location.pathname).must_equal Pathname.new(@path)
    end

    it 'has a line number' do
      _(@location.line).must_equal @line.to_i
    end

    it 'has a file name' do
      _(@location.file_name).must_equal 'foo'
    end
  end

  it 'is comparable' do
    location1 = RubyCritic::Location.new('./foo', 42)
    location2 = RubyCritic::Location.new('./foo', 42)
    _(location1).must_equal location2
  end

  it 'is sortable' do
    location1 = RubyCritic::Location.new('./foo', 42)
    location2 = RubyCritic::Location.new('./bar', 23)
    location3 = RubyCritic::Location.new('./bar', 16)
    _([location1, location2, location3].sort).must_equal [location3, location2, location1]
  end
end
