using Microsoft.AspNetCore.Mvc;
using recipes_api.Services;
using recipes_api.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace recipes_api.Controllers;

[ApiController]
[Route("user")]
public class UserController : ControllerBase
{    
    public readonly IUserService _service;
    
    public UserController(IUserService service)
    {
        this._service = service;        
    }

    // 6 - Sua aplicação deve ter o endpoint GET /user/:email
    [HttpGet("{email}", Name = "GetUser")]
    public IActionResult Get(string email)
    {                
        var emailExists = _service.GetUser(email);
        if (emailExists == null) return NotFound("email não encontrado");
        return Ok(emailExists);
    }

    // 7 - Sua aplicação deve ter o endpoint POST /user
    [HttpPost]
    public IActionResult Create([FromBody]User user)
    {
        _service.AddUser(user);
        var createdUser = _service.GetUser(user.Email);

        if (createdUser == null) return NotFound("Falha ao criar a receita");

        return CreatedAtAction(nameof(Get), new { email = user.Email}, user);
    }

    // "8 - Sua aplicação deve ter o endpoint PUT /user
    [HttpPut("{email}")]
    public IActionResult Update(string email, [FromBody]User user)
    {
        try
        {
            if(!_service.UserExists(email)) return NotFound();
            _service.UpdateUser(user);
            return Ok(user);
        }
        catch
        {
            
            return BadRequest();
        }
    }

    // 9 - Sua aplicação deve ter o endpoint DEL /user
    [HttpDelete("{email}")]
    public IActionResult Delete(string email)
    {
        if (!_service.UserExists(email)) return NotFound();
        _service.DeleteUser(email);
        return NoContent();
    } 
}