+++
title = "ずつ (zutsu)"
description = "Una aplicación minimalista y privada de gestión de tareas."
weight = 32

[taxonomies]
tags = ["interactivo", "productividad", "web app", "web", "JavaScript"]

[extra]
local_image = "projects/zutsu/zutsu_logo.webp"
canonical_url = "https://osc.garden/es/projects/zutsu/"
social_media_card = "social_cards/projects_zutsu.jpg"
+++

{% wide_container() %}
<video controls src="https://cdn.jsdelivr.net/gh/welpo/zutsu/assets/ずつ_demo.mov" title="demostración de zutsu"></video>
{% end %}

#### [Pruébala ahora](https://zutsu.osc.garden) • [GitHub](https://github.com/welpo/zutsu) • [Artículo](https://osc.garden/es/blog/zutsu-offline-task-planner-web-app/) {.centered-text}

<ruby>ず<rt>zu</rt>つ<rt>tsu</rt></ruby> es una aplicación web de gestión de tareas diseñada para ayudarte a centrarte en una tarea a la vez. El nombre viene de <ruby>一つ<rt>hitotsu</rt>ずつ<rt>zutsu</rt></ruby>, que significa «uno por uno» en <ruby>日本語<rt>japonés</rt></ruby>.

## ¿Por qué?

Quería sustituir la inflexibilidad del calendario para planificar las sesiones de estudio por algo simple y adaptable. Sin aplicaciones de terceros, sin sincronización en la nube —solo un espacio centrado en la gestión de tareas.

## Funcionalidades

### Principales

- Gestión de tareas con posibilidad de reordenarlas arrastrando y soltando
- Temporizador con duración personalizable por tarea
- Privada y offline —sin cuentas, seguimiento ni almacenamiento en servidor
- Importación/exportación de listas de tareas (JSON)

### Utilidades

- Temporizador Pomodoro
- Calendario de actividad (vista de 30 días)
- Contador y cronómetro
- Espacio para tomar notas
- Selectores aleatorios

### Calidad de vida

- Tema oscuro y claro
- Notificaciones del navegador y sonido
- Atajos de teclado
- Diseño responsive

[![tarjeta social de zutsu](social_cards/projects_zutsu.jpg)](https://zutsu.osc.garden)
