+++
title = "tabi"
description = "Un tema de Zola ràpid, lleuger i modern amb suport multilingüe."
weight = 40

[taxonomies]
tags = ["web", "JavaScript"]

[extra]
local_image = "projects/tabi/tabi.webp"
canonical_url = "https://osc.garden/ca/projects/tabi/"
social_media_card = "social_cards/ca_projects_tabi.jpg"
+++

[**tabi**](https://github.com/welpo/tabi) és un tema modern i ric en funcionalitat per a [Zola](https://www.getzola.org/), un generador de llocs web estàtics molt ràpid.

{{ full_width_image(src="https://cdn.jsdelivr.net/gh/welpo/tabi@main/light_dark_screenshot.png", alt="Modes clar i fosc de tabi") }}

#### [Veure a GitHub](https://github.com/welpo/tabi) • [Demo i documentación](https://welpo.github.io/tabi/ca/) {.centered-text}

## Característiques

- [Estableix qualsevol idioma com a predeterminat](https://welpo.github.io/tabi/ca/blog/faq-languages/#com-estableixo-la-llengua-predeterminada-del-meu-lloc). Configura el teu lloc en xinès, espanyol, francès, hindi… o qualsevol [altre idioma compatible](https://welpo.github.io/tabi/ca/blog/faq-languages/#quines-llengues-admet-tabi). La interfície del tema es traduirà en conseqüència.
- [Integració amb repositoris remots](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings#integracio-amb-repositoris-git) a GitHub, GitLab, Gitea i Codeberg per a l'historial de commits i mostrar el codi font del lloc.
- Tema clar i fosc. S'adapta a la configuració del sistema operatiu, amb un interruptor a la barra de navegació.
- [Suport multilingüe complet](https://welpo.github.io/tabi/ca/blog/faq-languages/#com-gestiona-tabi-el-suport-multilingue). Afegeix tants idiomes com vulguis i deixa que els teus usuaris triin amb el selector d'idioma.
- [Suport per a sèries](https://welpo.github.io/tabi/ca/blog/series/) per crear contingut seqüencial com tutorials, cursos i històries multipart.
- Puntuació perfecta en Lighthouse (Rendiment, Accessibilitat, Millors Pràctiques i SEO).
- Suport per a [diagrames de Mermaid](https://welpo.github.io/tabi/ca/blog/shortcodes/#diagrames-de-mermaid) per a crear diagrames i gràfics amb text.
- Ressaltat de sintaxi de codi amb colors basats en [Catppuccin](https://github.com/catppuccin/catppuccin) Frappé.
- Suport per a [comentaris usant giscus, utterances, Hyvor Talk o Isso](https://welpo.github.io/tabi/ca/blog/comments/).
- [Cerca local](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings/#cerca) amb una interfície accessible i multilingüe.
- Tot el JavaScript es pot [deshabilitar completament](https://welpo.github.io/tabi/ca/blog/javascript/).
- [Codificació de correu](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings/#correu-electronic-codificat) per a protecció contra spam.
- [Mapa del lloc estilitzat i llegible per humans](https://welpo.github.io/tabi/sitemap.xml).
- [Capçaleres de seguretat personalitzables](https://welpo.github.io/tabi/ca/blog/security/).
- [Feed Atom estilitzat i llegible per humans](https://welpo.github.io/tabi/ca/atom.xml).
- [Enllaços de retrocés per a notes al peu](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings/#enllacos-de-retorn-a-les-notes-a-peu-de-pagina).
- [Taula de continguts personalitzable](https://welpo.github.io/tabi/ca/blog/toc/).
- [Avís de drets d'autor personalitzat](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings/#copyright).
- [Botó de copiar per a blocs de codi](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings/#boto-de-copiar-en-blocs-de-codi).
- [URL canòniques personalitzables](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings/#url-canonica).
- [Targetes per a xarxes socials](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings/#targetes-per-a-xarxes-socials).
- [Botons de navegació ràpida](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings/#botons-de-navegacio-rapida).
- [Shortcodes personalitzats](https://welpo.github.io/tabi/ca/blog/shortcodes/).
- [Skins personalitzables](https://welpo.github.io/tabi/ca/blog/customise-tabi/).
- [Publicacions fixades](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings/#fixar-entrades).
- [Pàgina de projectes](https://welpo.github.io/tabi/ca/projects/).
- Disseny responsive.
- Suport de [KaTeX](https://katex.org/).
- [Enllaços socials](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings/#icones-de-xarxes-socials).
- [Pàgina d'arxiu](https://welpo.github.io/tabi/ca/archive/).
- [Etiquetes](https://welpo.github.io/tabi/ca/blog/mastering-tabi-settings/#etiquetes).

## Pràctiques de desenvolupament

- **[Conventional Commits](https://www.conventionalcommits.org) i [Gitmoji](https://gitmoji.dev/)**: els missatges de commit segueixen formats estandarditzats per facilitar la llegibilitat.
- **Seguiment d'incidències**: cada error o nova funcionalitat té el seu propi tiquet, que s'enllaça amb els commits de codi i PRs o problemes relacionats.
- **Comentaris detallats**: els tiquets es documenten amb imatges, vídeos i descripcions detallades per facilitar una comunicació i resolució de problemes efectives.
- **Referències creuades**: enllacem tots els tiquets amb els commits de codi, pull requests o problemes relacionats per a una traçabilitat completa.

## Evolució del projecte

**tabi** va néixer com a disseny per al meu lloc web personal, [osc.garden](https://osc.garden). Malgrat les seves arrels personals, des del principi es van implementar bones pràctiques per assegurar la qualitat i la mantenibilitat. Des d'aleshores, el tema ha aconseguit atraure una comunitat activa de col·laboradors a GitHub.

## Inicia el teu recorregut com a escriptor amb tabi

Tens alguna cosa a dir. Potser vols parlar sobre com els lingüistes encara no han acordat una [definició de "paraula"](https://ca.wikipedia.org/wiki/Mot), o sobre la teva experiència explorant els diferents [palos del flamenc](https://ca.wikipedia.org/wiki/Estils_flamencs), o de com vas aconseguir resoldre un error d'un projecte de codi obert popular.

**tabi** t'ofereix la base ideal per al teu espai d'escriptura, permetent-te centrar-te en les teves paraules mentre Zola i tabi s'encarreguen de l'aspecte tècnic. Submergeix-te en el món dels blogs amb un sistema que fa que cada publicació sigui un plaer escriure i llegir. La teva veu té valor; comparteix-la amb el món.
