+++
title = "shuku"
description = "Condensa pel·lícules i sèries per quedar-te només amb el diàleg. Dissenyat per aprendre idiomes."
weight = 20

[taxonomies]
tags = ["Python", "media", "linguistics", "CLI"]

[extra]
local_image = "projects/shuku/shuku_logo.webp"
social_media_card = "social_cards/projects_shuku.jpg"
canonical_url = "https://osc.garden/ca/projects/shuku/"
+++

**shuku** (<ruby><rb>縮</rb><rt>しゅく</rt></ruby><ruby><rb>小</rb><rt>しょう</rt></ruby>: «minificació») crea versions condensades de pel·lícules i sèries conservant només els diàlegs.

<video class="invertible-image" controls muted width="800" loop="true" autoplay="autoplay" title="demo de shuku" src="https://cdn.jsdelivr.net/gh/welpo/shuku/assets/animation_demo/shuku_demo.mov"></video>

#### [GitHub](https://github.com/welpo/shuku) • [Blog](https://osc.garden/ca/blog/shuku-condensed-media-language-learning/) • [Documentació](https://github.com/welpo/shuku#readme) • [PyPI](https://pypi.org/project/shuku/) {.centered-text}

## Característiques

### Gestió intel·ligent de continguts

- Detecció i correspondència automàtica de subtítols amb cerca difusa (fuzzy matching)
- Selecció intel·ligent de pistes d'àudio/subtítols
- Extracció de metadades (títol, temporada, número d'episodi)

### Output flexible

- Àudio condensat (MP3, FLAC, AAC, Opus…)
- Vídeo condensat
- Subtítols sincronitzats (SRT, ASS, o LRC per a apps tipus karaoke)

### Alta personalització

- Qualitat i còdecs d'àudio/vídeo configurables
- Ajust de temps de subtítols i farciment
- Filtra subtítols (efectes de so, lletres, capítols específics)
- Suport per a arguments personalitzats de FFmpeg

### Experiència de l'usuari

- Multiplataforma: GNU+Linux, macOS i Windows
- Logging detallat amb indicadors de progrés
- Suport per a processament per lots

[![targeta social de shuku](/img/social_cards/projects_shuku.jpg)](https://github.com/welpo/shuku)
