+++
title = "ラム (ramu)"
description = "A web app to practice reading and listening to Japanese numbers."
weight = 35

[taxonomies]
tags = ["Japanese", "interactive", "web app", "web", "PWA", "JavaScript"]

[extra]
local_image = "projects/ramu/ramu_logo.webp"
canonical_url = "https://osc.garden/projects/ramu/"
social_media_card = "social_cards/projects_ramu.jpg"
+++

<ruby>ラ<rt>ra</rt>ム<rt>mu</rt></ruby> is a Progressive Web App to practice reading and listening to Japanese numbers. The name reflects its purpose: achieving RAM (Random Access Memory) to numbers, as opposed to sequential memory (1, 2, 3…).

{% wide_container() %}
<video controls src="media/ラム_demo.mp4" title="ramu demo"></video>
{% end %}

#### [Try it now](https://ramu.osc.garden) • [GitHub](https://github.com/welpo/ramu) • [Blog post](https://osc.garden/blog/ramu-japanese-numbers-practice-web-app/) {.centered-text}

## Features

- Practice with both Arabic (123…) and Japanese (一二三…) numerals
- Two practice modes: reading and listening comprehension
- Configurable number ranges (from 0 to over 100,000,000)
- Counter word practice (個、本、匹…)
- Works offline as a Progressive Web App
- Full keyboard control (<kbd>space</kbd>/<kbd>→</kbd> for next, <kbd>esc</kbd> to stop)
- Screen reader friendly for Arabic numeral practice

[![ramu social media card](social_cards/projects_ramu.jpg)](https://ramu.osc.garden)
