+++
title = "Privacy Policy"
path = "privacy"
date = 2023-10-31
updated = 2024-05-12
+++

This privacy policy outlines how we collect and process your data on this website.

{{ toc() }}

## What data do we collect?

### General browsing {#what-general}

While browsing the site, no personal information is collected.

### Comments {#what-comments}

We do not collect any data when you send a comment or reaction, but GitHub does in order to provide the service.

### Analytics {#what-analytics}

For website improvement, the following non-personal data is collected:

- **Referrer**: the source that led you to this site.
- **Requested URL**: the specific page you visited.
- **User-Agent**: identifies the browser and operating system you use (e.g. "Safari 17.0, Mac OS X").
- **Country name**: the country you are visiting from, determined by your IP address.
- **Screen size**: the dimensions of your device's screen.
- **Time**: when you accessed the site.
- **Browsing session**: a temporary identification code generated from your IP address, browser information, and a random number. This is used to recognize a browsing session for 8 hours. After that time, the code is deleted from memory and is not stored anywhere.

We do not track unique visitors across sessions, and we do not track how long you stay on the site or where you go after you leave.

## How do we collect this data?

### Comments {#how-comments}

The data associated with comments is collected using [giscus](https://giscus.app/), a platform that enables GitHub-based comments.

### Analytics {#how-analytics}

The non-personal data is collected using a self-hosted instance of [GoatCounter](https://www.goatcounter.com/), an open-source privacy-friendly web analytics platform.

## How will we use the data?

The data sent to GitHub is used to display your comment on the site.

The non personal data is used to generate statistics about the site, such as the number of visitors per day, or the most popular pages and referrers. This data is used to improve this demo site and the tabi theme. You can see the statistics generated from this data on the [public stats page](https://tabi-stats.osc.garden/).

All data collected is publicly available, either in the form of comments or statistics.

We do not use the data for any other purpose.

## How do we store the data?

The comments data is not stored by Giscus, as specified in their [privacy policy](https://github.com/giscus/giscus/blob/main/PRIVACY-POLICY.md#what-data-do-we-collect). The data is stored on GitHub servers. See the [GitHub's privacy policy](https://docs.github.com/en/site-policy/privacy-policies/github-privacy-statement).

The analytics data is stored on a server hosted by [Vultr](https://www.vultr.com/). The server is located in Paris, France.

The server follows industry best practices for security, including automatic security updates, a strict Content Security Policy, a firewall, key-based SSH access, etc.

## How long will we store the data?

The comments are stored indefinitely, or until you request their deletion.

The rest of the data is stored indefinitely.

## What are your data protection rights?

Depending on the processing and the legal basis, there are a number of possibilities available to you to keep control over your personal data:

- Right to access your data
- Right to amend your data
- Right to object to the processing of your personal data
- Right to limit the processing of your data
- Right to have your data deleted
- Right to withdraw your consent

If you make a request, we have one month to respond to you. If you would like to exercise any of these rights, please contact us using the e-mail icon in the footer of the site.

## Cookies

The site does not use cookies.

## Privacy policies of other websites

This website contains links to other websites. This privacy policy applies only to this website, so if you click on a link to another website, you should read their privacy policy.

## Changes to the privacy policy

We keep this privacy policy under regular review and place any updates on this web page. You can check the date this privacy policy was updated, as well as the history of changes under the page title.

## How to contact us

If you have any questions about this privacy policy, the data we hold on you, or you would like to exercise one of your data protection rights, please do not hesitate to contact us using the e-mail icon in the footer of the site.
