+++
title = "Política de privacidad"
path = "/es/privacy"
date = 2023-10-31
updated = 2024-05-12
+++

Esta política de privacidad describe cómo recopilamos y procesamos tus datos en este sitio web.

{{ toc() }}

## ¿Qué datos recopilamos?

### Navegación general {#what-general}

Mientras navegas por el sitio, no se recopila ninguna información personal.

### Comentarios {#what-comments}

No recopilamos ningún dato cuando envías un comentario o reacción, pero GitHub sí lo hace para proporcionar el servicio.

### Análisis {#what-analytics}

Para mejorar el sitio web, se recopila la siguiente información no personal:

- **Referente**: la fuente que te llevó a este sitio.
- **URL solicitado**: la página específica que visitas.
- **Agente de usuario**: identifica el navegador y el sistema operativo que utilizas (por ejemplo, "Safari 17.0, Mac OS X").
- **Nombre del país**: el país desde el que estás visitando, determinado por tu dirección IP.
- **Tamaño de pantalla**: las dimensiones de la pantalla de tu dispositivo.
- **Fecha y hora**: cuándo accedes al sitio.
- **Sesión de navegación**: un código de identificación temporal generado a partir de tu dirección IP, información del navegador y un número aleatorio. Este código se utiliza para reconocer la sesión de navegación durante 8 horas. Después de ese tiempo, el código se elimina de la memoria y no se almacena en ningún lugar.

No rastreamos visitantes únicos a través de sesiones, ni el tiempo que permaneces en el sitio o a dónde vas después de salir.

## ¿Cómo recopilamos estos datos?

### Comentarios {#how-comments}

Los datos asociados con los comentarios se recopilan utilizando [giscus](https://giscus.app/), una plataforma que habilita comentarios basados en GitHub.

### Análisis {#how-analytics}

Los datos no personales se recopilan mediante una instancia autoalojada de [GoatCounter](https://www.goatcounter.com/), una plataforma de análisis web de código abierto y respetuosa con la privacidad.

## ¿Cómo utilizaremos los datos?

Los datos enviados a GitHub se utilizan para mostrar tu comentario en el sitio.

Los datos no personales se utilizan para generar estadísticas sobre el sitio, como el número de visitantes por día o las páginas y referentes más populares. Estos datos se utilizan para mejorar este sitio de demostración y el tema tabi. Puedes ver las estadísticas generadas a partir de estos datos en la [página de estadísticas públicas](https://tabi-stats.osc.garden/).

Todos los datos recopilados están públicamente disponibles, ya sea en forma de comentarios o estadísticas.

No utilizamos los datos para ningún otro propósito.

## ¿Cómo almacenamos los datos?

Los datos de los comentarios no son almacenados por Giscus, como se especifica en su [política de privacidad](https://github.com/giscus/giscus/blob/main/PRIVACY-POLICY.md#what-data-do-we-collect). Los datos se almacenan en servidores de GitHub. Consulta la [política de privacidad de GitHub](https://docs.github.com/en/site-policy/privacy-policies/github-privacy-statement).

Los datos de análisis se almacenan en un servidor alojado por [Vultr](https://www.vultr.com/). El servidor está ubicado en París, Francia.

El servidor sigue las mejores prácticas de la industria en cuanto a seguridad, incluidas actualizaciones de seguridad automáticas, una estricta Política de Seguridad de Contenido, un cortafuegos, acceso SSH basado en clave, etc.

## ¿Cuánto tiempo almacenaremos los datos?

Los comentarios se almacenan indefinidamente o hasta que solicites su eliminación.

El resto de los datos se almacena indefinidamente.

## ¿Cuáles son tus derechos de protección de datos?

Dependiendo del procesamiento y la base legal, dispones de varias opciones para mantener el control sobre tus datos personales:

- Derecho a acceder a tus datos
- Derecho a enmendar tus datos
- Derecho a oponerte al procesamiento de tus datos personales
- Derecho a limitar el procesamiento de tus datos
- Derecho a que se eliminen tus datos
- Derecho a retirar tu consentimiento

Si realizas una solicitud, tenemos un mes para responderte. Si deseas ejercer alguno de estos derechos, contáctanos utilizando el icono de correo electrónico en el pie de página del sitio.

## Cookies

El sitio no utiliza cookies.

## Políticas de privacidad de otros sitios web

Este sitio web contiene enlaces a otros sitios web. Esta política de privacidad sólo se aplica a este sitio web, por lo que si haces clic en un enlace a otro sitio web, debes leer su política de privacidad.

## Cambios en la política de privacidad

Mantenemos esta política de privacidad bajo revisión regular y colocamos cualquier actualización en esta página web. Puedes consultar la fecha de actualización de esta política de privacidad, así como el historial de cambios bajo el título de la página.

## Cómo contactarnos

Si tienes alguna pregunta sobre esta política de privacidad, los datos que tenemos sobre ti o si te gustaría ejercer alguno de tus derechos de protección de datos, no dudes en contactarnos utilizando el icono de correo electrónico en el pie de página del sitio.
