# Changelog

Welcome to the changelog for tabi. This document aims to provide a comprehensive list of all notable changes made to the project, organised chronologically by release version.

We use Semantic Versioning (SemVer) for our version numbers, formatted as MAJOR.MINOR.PATCH. Major version changes involve significant (breaking) changes, minor versions introduce features and improvements in a backward compatible manner, and patch versions are for bug fixes and minor tweaks.

## [3.1.0](https://github.com/welpo/tabi/compare/v3.0.0..v3.1.0) - 2024-11-14

### ✨ Features

- *(shortcodes)* Support body admonitions ([#423](https://github.com/welpo/tabi/issues/423)) by [@welpo](https://github.com/welpo)
- Allow pinned posts with pagination ([#428](https://github.com/welpo/tabi/issues/428)) by [@welpo](https://github.com/welpo)
- Add pinned posts functionality ([#424](https://github.com/welpo/tabi/issues/424)) by [@welpo](https://github.com/welpo)
- Add series functionality ([#406](https://github.com/welpo/tabi/issues/406)) by [@ZzMzaw](https://github.com/ZzMzaw) and [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- Link to "All posts" in non-default-language root ([3b7fd3d](https://github.com/welpo/tabi/commit/3b7fd3db9c33fd3ca6114ca00fffa2a91f682a0a)) by [@welpo](https://github.com/welpo)
- Isso comments in multilingual setups ([#427](https://github.com/welpo/tabi/issues/427)) by [@welpo](https://github.com/welpo)

### 💄 Styling

- Colour scrollbar to match primary colour ([#430](https://github.com/welpo/tabi/issues/430)) by [@welpo](https://github.com/welpo)
- Set accent color to match theme ([#429](https://github.com/welpo/tabi/issues/429)) by [@welpo](https://github.com/welpo)
- Fix info admonition code color ([5927409](https://github.com/welpo/tabi/commit/5927409c41e71d6943deee426fc75a94037cee36)) by [@welpo](https://github.com/welpo)
- Improve navigation bar & metadata wrapping ([#425](https://github.com/welpo/tabi/issues/425)) by [@welpo](https://github.com/welpo)
- Fix hover color for <rt> element in links ([87f1099](https://github.com/welpo/tabi/commit/87f1099caa8741bcacadf2aae2677a529395e454)) by [@welpo](https://github.com/welpo)
- Add styling for <kbd> keyboard input ([51fee5d](https://github.com/welpo/tabi/commit/51fee5d660232a1eafeb39f439fe5377f3f63406)) by [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(README)* Fix typo ([#421](https://github.com/welpo/tabi/issues/421)) by [@ZzMzaw](https://github.com/ZzMzaw)
- Highlight pinned posts feature ([c3c344a](https://github.com/welpo/tabi/commit/c3c344a76fb894ec87fc9896e7a0202788e001c5)) by [@welpo](https://github.com/welpo)
- Clarify instructions for listing recent posts ([#418](https://github.com/welpo/tabi/issues/418)) ([3442fd9](https://github.com/welpo/tabi/commit/3442fd9ff0c0a093f08bb27aaa0d92e5993df29b)) by [@welpo](https://github.com/welpo)

### ♻️ Refactor

- *(GitHub)* Update issue templates ([5687f3b](https://github.com/welpo/tabi/commit/5687f3bacb6ed69ffbe4143e93b6c95ce8fb5c59)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(CI)* Allow longer PR titles for dep updates ([e2c5c6e](https://github.com/welpo/tabi/commit/e2c5c6e9b749c3591af6a822eee65c1ee1854c01)) by [@welpo](https://github.com/welpo)
- *(CI)* Allow longer PR titles for dep updates ([fa9f160](https://github.com/welpo/tabi/commit/fa9f16034241ccee6229ef0279b3b9bc65249cfa)) by [@welpo](https://github.com/welpo)
- *(CI)* Allow longer PR titles for dep updates ([bd45a1a](https://github.com/welpo/tabi/commit/bd45a1ae45997b950c703d1ebf1e34b3b82173eb)) by [@welpo](https://github.com/welpo)
- *(deps)* Remove local release script ([2e3cff2](https://github.com/welpo/tabi/commit/2e3cff2ef1ca8396c632de48b21174601d5ff46c)) by [@welpo](https://github.com/welpo)
- *(projects)* Add ラム (ramu) project ([f300129](https://github.com/welpo/tabi/commit/f3001298c24d49d234247c9cce2a6c771778c1c3)) by [@welpo](https://github.com/welpo)
- Change codeblock language from plaintext to txt ([57a0a8e](https://github.com/welpo/tabi/commit/57a0a8e1a09d586acdf5c72464d79328e0c9b27f)) by [@welpo](https://github.com/welpo)

## [3.0.0](https://github.com/welpo/tabi/compare/v2.17.0..v3.0.0) - 2024-10-18

### 💥 BREAKING CHANGES 💥

- Force code blocks LTR rendering ([#412](https://github.com/welpo/tabi/issues/412)) ([092ccdd](https://github.com/welpo/tabi/commit/092ccdd1ba8bf08cc738664ba4fbe9e7a0ff282e)) by [@welpo](https://github.com/welpo)

### ✨ Features

- Add force_text_direction shortcode ([#414](https://github.com/welpo/tabi/issues/414)) ([c9f8d27](https://github.com/welpo/tabi/commit/c9f8d27b962217ff0fb09b30ec14aee65fe8518d)) by [@welpo](https://github.com/welpo)
- [**‼️BREAKING‼️**] Force code blocks LTR rendering ([#412](https://github.com/welpo/tabi/issues/412)) ([092ccdd](https://github.com/welpo/tabi/commit/092ccdd1ba8bf08cc738664ba4fbe9e7a0ff282e)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- Update CSP for GoatCounter ([#413](https://github.com/welpo/tabi/issues/413)) by [@noeddl](https://github.com/noeddl)

### 📝 Documentation

- *(CONTRIBUTING)* Fix broken link to commit message style ([11e246a](https://github.com/welpo/tabi/commit/11e246a876eef846e8c1e26add7331f25beb9c27)) by [@welpo](https://github.com/welpo)
- *(mastering tabi)* Mention social links rel='me' ([5db70b7](https://github.com/welpo/tabi/commit/5db70b7978e7141be9396d3f69375a87b2d44ed2)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- Update git-cliff variables to `commit.remote` ([0a36ef5](https://github.com/welpo/tabi/commit/0a36ef55ee092fe7bb1f8803c04a4cb8245b2a13)) by [@welpo](https://github.com/welpo)

### 👥 New contributors

🫶 [@noeddl](https://github.com/noeddl) made their first contribution in [#413](https://github.com/welpo/tabi/pull/413)

## [2.17.0](https://github.com/welpo/tabi/compare/v2.16.0..v2.17.0) - 2024-10-10

### ✨ Features

- Add fediverse creator metadata support ([#409](https://github.com/welpo/tabi/issues/409)) by [@arichtman](https://github.com/arichtman), [@Ariel](https://github.com/Ariel) Richtman and [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(search)* Restore highlighting functionality ([#401](https://github.com/welpo/tabi/issues/401)) by [@welpo](https://github.com/welpo)
- Set proper URL for self-hosted Umami ([#402](https://github.com/welpo/tabi/issues/402)) by [@soumendrak](https://github.com/soumendrak)

### 📝 Documentation

- Add mermaid shortcode usage ([#407](https://github.com/welpo/tabi/issues/407)) by [@ZzMzaw](https://github.com/ZzMzaw) and [@welpo](https://github.com/welpo)
- Update comment in config.toml RE: #402 ([c50edbd](https://github.com/welpo/tabi/commit/c50edbd453eca2f031bc97a5a25caa206644d568)) by [@welpo](https://github.com/welpo)

### ♻️ Refactor

- *(search)* Reduce search lag on mobile ([7ceada9](https://github.com/welpo/tabi/commit/7ceada974b7c3f2c52aaa5688af631c806901aed)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(README)* Add jmbhughes.com to showcase ([#404](https://github.com/welpo/tabi/issues/404)) by [@jmbhughes](https://github.com/jmbhughes)
- *(deps)* Replace local release script w/ git submodule ([66239be](https://github.com/welpo/tabi/commit/66239bee016406c87a227b685eb70a464546e199)) by [@welpo](https://github.com/welpo)
- *(deps)* Automate KaTeX/mermaid upgrades ([fc04ab4](https://github.com/welpo/tabi/commit/fc04ab4e40977bafa1b821c77e38554d287f69bc)) by [@welpo](https://github.com/welpo)
- Reformat social card creation tip ([47fcee8](https://github.com/welpo/tabi/commit/47fcee8f81fb10bcd7cc042cc4a80dcada244b6d)) by [@welpo](https://github.com/welpo)

### 👥 New contributors

🫶 [@jmbhughes](https://github.com/jmbhughes) made their first contribution in [#404](https://github.com/welpo/tabi/pull/404)

## [2.16.0](https://github.com/welpo/tabi/compare/v2.15.0..v2.16.0) - 2024-09-22

### ✨ Features

- *(remote_text shortcode)* Support line ranges ([#399](https://github.com/welpo/tabi/issues/399)) ([008b976](https://github.com/welpo/tabi/commit/008b976e06e0b93e021e2ca641eda42521e58f98)) by [@welpo](https://github.com/welpo)
- *(remote_text shortcode)* Support relative paths ([#398](https://github.com/welpo/tabi/issues/398)) by [@welpo](https://github.com/welpo)

## [2.15.0](https://github.com/welpo/tabi/compare/v2.14.0..v2.15.0) - 2024-09-20

### ✨ Features

- *(feed)* Make "Visit website" link context-aware ([#394](https://github.com/welpo/tabi/issues/394)) by [@welpo](https://github.com/welpo)
- *(search)* Hide "clear search" icon if input is empty ([#388](https://github.com/welpo/tabi/issues/388)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(feed)* Resolve Atom feed validation issues ([#393](https://github.com/welpo/tabi/issues/393)) by [@welpo](https://github.com/welpo)
- Allow pages within pages ([#385](https://github.com/welpo/tabi/issues/385)) by [@welpo](https://github.com/welpo)
- Improve dark mode and OS theme handling ([#380](https://github.com/welpo/tabi/issues/380)) by [@welpo](https://github.com/welpo)

### 💄 Styling

- Improve RTL styling consistency ([#381](https://github.com/welpo/tabi/issues/381)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(README)* Add Ponderosa Games to showcase ([#395](https://github.com/welpo/tabi/issues/395)) by [@JVimes](https://github.com/JVimes)
- *(deps)* Avoid masking return values ([1b11f4b](https://github.com/welpo/tabi/commit/1b11f4b321d0ae52179d88cc3ecd1b72ef2b37ae)) by [@welpo](https://github.com/welpo)
- *(deps)* Check local deps version to early exit ([b5cbad4](https://github.com/welpo/tabi/commit/b5cbad422bc14f44a620bcbb87449f2425c16af6)) by [@welpo](https://github.com/welpo)
- Set [@TheAwiteb](https://github.com/TheAwiteb) as owner of Arabic translation ([edb0873](https://github.com/welpo/tabi/commit/edb087392f2989b4f08122c81fa3e51d17fbb6b8)) by [@welpo](https://github.com/welpo)

### 👥 New contributors

🫶 [@JVimes](https://github.com/JVimes) made their first contribution in [#395](https://github.com/welpo/tabi/pull/395)

## [2.14.0](https://github.com/welpo/tabi/compare/v2.13.0..v2.14.0) - 2024-09-08

### ✨ Features

- *(i18n)* Add Odia language ([#372](https://github.com/welpo/tabi/issues/372)) by [@soumendrak](https://github.com/soumendrak)
- *(i18n)* Add Estonian language ([#365](https://github.com/welpo/tabi/issues/365)) by [@NippleOfAnApe](https://github.com/NippleOfAnApe)
- Add Mermaid diagram support ([#370](https://github.com/welpo/tabi/issues/370)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(RTL)* Fix blockquote style ([#368](https://github.com/welpo/tabi/issues/368)) by [@TheAwiteb](https://github.com/TheAwiteb) and [@welpo](https://github.com/welpo)
- Reduce main page header/list sizes ([#375](https://github.com/welpo/tabi/issues/375)) by [@welpo](https://github.com/welpo)
- Add missing quotes to HTML attributes ([#367](https://github.com/welpo/tabi/issues/367)) by [@DataTriny](https://github.com/DataTriny)

### 💄 Styling

- Use note admonition for TL;DR ([b9bf4b2](https://github.com/welpo/tabi/commit/b9bf4b2fd67c71647c0d2a1bd77dee8cb9e0ec49)) by [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(mastering tabi)* Clarify prev/next links requirements ([6219b92](https://github.com/welpo/tabi/commit/6219b9200cfd544b999b064fabfa0ca37d4815d8)) by [@welpo](https://github.com/welpo)

### ♻️ Refactor

- *(footer)* Lazy load social icons ([9e7b845](https://github.com/welpo/tabi/commit/9e7b845e544758792831da520379e04089909b78)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(deps)* Add KaTeX to dependency upgrade script ([001ec8f](https://github.com/welpo/tabi/commit/001ec8fc9a9524efbe4c3c04669fb64be4ed8efd)) by [@welpo](https://github.com/welpo)
- *(deps)* Add script to upgrade mermaid ([d73c4bd](https://github.com/welpo/tabi/commit/d73c4bde5a12d434a595be877f4452fa0c20ae30)) by [@welpo](https://github.com/welpo)
- *(release)* Ensure script is ran from default branch ([82f7a98](https://github.com/welpo/tabi/commit/82f7a984d54046a4f884461b3c5f52ac830661bf)) by [@welpo](https://github.com/welpo)
- Add funding information ([8d22a42](https://github.com/welpo/tabi/commit/8d22a42e3fd5d909eaf90f7132e818b9c45f7b07)) by [@welpo](https://github.com/welpo)

### 👥 New contributors

🫶 [@DataTriny](https://github.com/DataTriny) made their first contribution in [#367](https://github.com/welpo/tabi/pull/367)

🫶 [@NippleOfAnApe](https://github.com/NippleOfAnApe) made their first contribution in [#365](https://github.com/welpo/tabi/pull/365)

## [2.13.0](https://github.com/welpo/tabi/compare/v2.12.0..v2.13.0) - 2024-07-24

### ✨ Features

- Follow user OS theme with JS disabled ([#357](https://github.com/welpo/tabi/issues/357)) by [@welpo](https://github.com/welpo)
- Add date visibility options to post list ([#330](https://github.com/welpo/tabi/issues/330)) by [@sam9032](https://github.com/sam9032) and [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(header)* Render feed links based on config ([#358](https://github.com/welpo/tabi/issues/358)) by [@welpo](https://github.com/welpo)
- *(post_listing_date)* Show original date for unedited articles ([#355](https://github.com/welpo/tabi/issues/355)) by [@sam9032](https://github.com/sam9032)
- *(search)* Close modal when clicking current page result ([#350](https://github.com/welpo/tabi/issues/350)) by [@welpo](https://github.com/welpo)

### 💄 Styling

- *(error)* Enhance visibility of Zola errors ([#359](https://github.com/welpo/tabi/issues/359)) by [@welpo](https://github.com/welpo)
- Match footnote backlinks size on Zola v0.19 ([0f18ac2](https://github.com/welpo/tabi/commit/0f18ac264df8b9766c4d431dfd37f5f5799f3834)) by [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(mastering tabi)* Fix broken image ([1111631](https://github.com/welpo/tabi/commit/1111631325e3ebf8ae3a2f6cd18492cfc5aa44c2)) by [@welpo](https://github.com/welpo)
- Mention custom Twitter card & automatic OG tags ([fbb81f9](https://github.com/welpo/tabi/commit/fbb81f976433d93ee3787f4a9d5c6c3049f815a2)) by [@welpo](https://github.com/welpo)
- Deprecate JS footnote backlinks ([ced0cb4](https://github.com/welpo/tabi/commit/ced0cb43b6b4b4f6fba583990e428ddedbf52af3)) by [@welpo](https://github.com/welpo)
- Fix broken internal links ([4145364](https://github.com/welpo/tabi/commit/4145364e085929ae9c09ccb908a0bae77a0b7520)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(release)* Add error handling function ([9585843](https://github.com/welpo/tabi/commit/9585843b14131843775e41df67fe9cc60c95a2ea)) by [@welpo](https://github.com/welpo)
- *(release)* Ensure local repository is in good state ([617a940](https://github.com/welpo/tabi/commit/617a940cf823917bc86df5f05350236c40560dc0)) by [@welpo](https://github.com/welpo)

### 👥 New contributors

🫶 [@sam9032](https://github.com/sam9032) made their first contribution in [#355](https://github.com/welpo/tabi/pull/355)

## [2.12.0](https://github.com/welpo/tabi/compare/v2.11.0..v2.12.0) - 2024-06-29

### ✨ Features

- *(admonitions)* Allow swapping admonition icons ([#340](https://github.com/welpo/tabi/issues/340)) by [@welpo](https://github.com/welpo)
- *(socials)* Add Debian icon ([82ecbc1](https://github.com/welpo/tabi/commit/82ecbc145489bf4415d7a3500be85191524d1b53)) by [@welpo](https://github.com/welpo)
- Allow sorting tags based on post count ([#344](https://github.com/welpo/tabi/issues/344)) by [@metaleap](https://github.com/metaleap) and [@welpo](https://github.com/welpo)
- Add option to use sans-serif font everywhere ([a907f56](https://github.com/welpo/tabi/commit/a907f56bd568378b099c0706fa4c92d7102b1688)) by [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(mastering tabi)* Clarify post sorting in Archive ([c9c8ed8](https://github.com/welpo/tabi/commit/c9c8ed84a00136469a53d30b6e694b6cb845c5fa)) by [@welpo](https://github.com/welpo)

### ♻️ Refactor

- Improve "Last updated on" format ([#342](https://github.com/welpo/tabi/issues/342)) by [@welpo](https://github.com/welpo)

### 👥 New contributors

🫶 [@metaleap](https://github.com/metaleap) made their first contribution in [#344](https://github.com/welpo/tabi/pull/344)

## [2.11.0](https://github.com/welpo/tabi/compare/v2.10.0..v2.11.0) - 2024-06-24

### ✨ Features

- *(socials)* Add bluesky icon ([#333](https://github.com/welpo/tabi/issues/333)) by [@andreacfromtheapp](https://github.com/andreacfromtheapp)
- Allow HTML tags in multilingual quote author ([be7628a](https://github.com/welpo/tabi/commit/be7628aeaa573b69739a2751e93d77da0b587124)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(footer)* Show feed icon on Zola 0.19.0 ([#336](https://github.com/welpo/tabi/issues/336)) by [@welpo](https://github.com/welpo)

### 💄 Styling

- *(admonitions)* Reduce thickness of strong tag ([faa9633](https://github.com/welpo/tabi/commit/faa963353170f42ab2b05b2a35aae1431ff5c319)) by [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(README)* Fix command to update tabi submodule ([7a3380c](https://github.com/welpo/tabi/commit/7a3380c467d3bf77cfa1d9548a0b063964d73f37)) by [@welpo](https://github.com/welpo)
- *(README)* Clarify section_path format ([7d38628](https://github.com/welpo/tabi/commit/7d386283ff808576a7149a96223be3564984d783)) by [@welpo](https://github.com/welpo)
- *(README)* Add commands to update the theme ([4a47e0a](https://github.com/welpo/tabi/commit/4a47e0ad2375a9b160ab0424719f04702653970d)) by [@welpo](https://github.com/welpo)
- Explain how to use custom social icons ([5ae629d](https://github.com/welpo/tabi/commit/5ae629d171d12ed262d4862da65e7e8c8a21d87a)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(pre-commit hook)* Handle filenames with spaces ([448250f](https://github.com/welpo/tabi/commit/448250ff571d442d4608e0d7a8550c66cbe1bc2b)) by [@welpo](https://github.com/welpo)

### 👥 New contributors

🫶 [@andreacfromtheapp](https://github.com/andreacfromtheapp) made their first contribution in [#333](https://github.com/welpo/tabi/pull/333)

## [2.10.0](https://github.com/welpo/tabi/compare/v2.9.0..v2.10.0) - 2024-05-30

### ✨ Features

- *(homepage)* Allow hiding posts listing ([#317](https://github.com/welpo/tabi/issues/317)) by [@welpo](https://github.com/welpo)
- *(shortcodes)* Add inline option to image shortcodes ([#315](https://github.com/welpo/tabi/issues/315)) by [@welpo](https://github.com/welpo)
- Add option to show author in post metadata ([#322](https://github.com/welpo/tabi/issues/322)) by [@welpo](https://github.com/welpo)
- Add inline image CSS class ([6a4f424](https://github.com/welpo/tabi/commit/6a4f4244e0ae16127f207680061fa4dcb1c782dd)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(footer)* Allow showing only email/feed icons ([aef49bb](https://github.com/welpo/tabi/commit/aef49bb2251c95e1fb70f05f149ecc8af7184145)) by [@welpo](https://github.com/welpo)
- Allow quotation in page summary ([22925ca](https://github.com/welpo/tabi/commit/22925caf060d122630c02437c5fc73bc6b82e457)) by [@welpo](https://github.com/welpo)

### 💄 Styling

- Increase font size of h1 ([94b3b1d](https://github.com/welpo/tabi/commit/94b3b1d8045753187044174a4d127fdc94608923)) by [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(mastering tabi)* Fix typo ([349663f](https://github.com/welpo/tabi/commit/349663f28fc61bb19beec8ba8d42d5724c062bee)) by [@welpo](https://github.com/welpo)
- CSP requirements to use built-in syntax highlighting ([3b0d7e5](https://github.com/welpo/tabi/commit/3b0d7e5a668aa087af512f0ecb204acf61723a63)) by [@welpo](https://github.com/welpo)

### ♻️ Refactor

- Improve settings hierarchy performance ([#325](https://github.com/welpo/tabi/issues/325)) by [@faassen](https://github.com/faassen)

### 🔧 Miscellaneous tasks

- *(analytics)* Stop collecting Language data ([1894d55](https://github.com/welpo/tabi/commit/1894d550bcbd8b664c3865576aa65abd0b1db0c3)) by [@welpo](https://github.com/welpo)
- Update nani logo ([#323](https://github.com/welpo/tabi/issues/323)) by [@faassen](https://github.com/faassen)

### 👥 New contributors

🫶 [@faassen](https://github.com/faassen) made their first contribution in [#325](https://github.com/welpo/tabi/pull/325)

## [2.9.0](https://github.com/welpo/tabi/compare/v2.8.1..v2.9.0) - 2024-05-11

### ✨ Features

- *(shortcodes)* Add remote_text shortcode ([#305](https://github.com/welpo/tabi/issues/305)) by [@welpo](https://github.com/welpo)
- Enable adding URL/path to code blocks ([#307](https://github.com/welpo/tabi/issues/307)) ([b70efd1](https://github.com/welpo/tabi/commit/b70efd1642db11b060665ecf6d1bf0f11e3ffd06)) by [@welpo](https://github.com/welpo)
- Add option to display/hide date in metadata ([#306](https://github.com/welpo/tabi/issues/306)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(add_src_to_code_block)* Avoid overlapping text ([f081a92](https://github.com/welpo/tabi/commit/f081a92f5939e141b6dbd7afe8ad1a9519d47f30)) by [@welpo](https://github.com/welpo)
- *(analytics)* Allow Umami through CSP ([#310](https://github.com/welpo/tabi/issues/310)) by [@arichtman](https://github.com/arichtman)

## [2.8.1](https://github.com/welpo/tabi/compare/v2.8.0..v2.8.1) - 2024-05-01

### 🐛 Bug fixes

- Ensure spacing when all projects are shown ([50123c0](https://github.com/welpo/tabi/commit/50123c09ef7ee544d812a58a607d8a1e92369c4f)) by [@welpo](https://github.com/welpo)

## [2.8.0](https://github.com/welpo/tabi/compare/v2.7.0..v2.8.0) - 2024-04-29

### ✨ Features

- Allow showcasing featured projects on homepage ([#297](https://github.com/welpo/tabi/issues/297)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(CSP)* Add Umami API URLs to CSP ([#301](https://github.com/welpo/tabi/issues/301)) by [@arichtman](https://github.com/arichtman)
- Align projects and posts properly ([69094d6](https://github.com/welpo/tabi/commit/69094d633579a1ea4bee1fcadd77e1511d4020ca)) by [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(README)* Add arichtman blog to showcase ([#298](https://github.com/welpo/tabi/issues/298)) by [@arichtman](https://github.com/arichtman)

### ♻️ Refactor

- *(search)* Close unclosed div ([b6b48cc](https://github.com/welpo/tabi/commit/b6b48cc3b4a2ad17c2ee331664b0b2c9f1fcecc2)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(README)* Remove sites no longer using tabi ([ba5acca](https://github.com/welpo/tabi/commit/ba5acca7340a940092a9be196302b01441617720)) by [@welpo](https://github.com/welpo)

## [2.7.0](https://github.com/welpo/tabi/compare/v2.6.1..v2.7.0) - 2024-04-18

### ✨ Features

- *(i18n)* Add Dutch language ([#290](https://github.com/welpo/tabi/issues/290)) by [@Myrdincx](https://github.com/Myrdincx) and [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- Link 'All posts' to proper section ([#295](https://github.com/welpo/tabi/issues/295)) by [@Dalker](https://github.com/Dalker), [@Daniel](https://github.com/Daniel) Kessler (a.k.a. Dalker) and [@welpo](https://github.com/welpo)
- Fix history url for GitLab & Codeberg ([#294](https://github.com/welpo/tabi/issues/294)) by [@TheAwiteb](https://github.com/TheAwiteb)

### 💄 Styling

- *(shortcodes)* Use colourful admonition icons ([e965694](https://github.com/welpo/tabi/commit/e965694cdf1c588d40e167ec98961a854e2236d0)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(projects)* List Streaming Royalties Calculator ([ad289f1](https://github.com/welpo/tabi/commit/ad289f1d2caaf7781a011d610e46bd7de41e7f33)) by [@welpo](https://github.com/welpo)
- Update nani logo ([ce1a98e](https://github.com/welpo/tabi/commit/ce1a98ed93ad38214f6455ba262289a3969cbf52)) by [@welpo](https://github.com/welpo)
- Compress dōteki & git-sumi social media cards ([ec6ba01](https://github.com/welpo/tabi/commit/ec6ba01bbcbeecc684e2bfb49c5e1f7fac847aa5)) by [@welpo](https://github.com/welpo)

### 👥 New contributors

🫶 [@Dalker](https://github.com/Dalker) made their first contribution in [#295](https://github.com/welpo/tabi/pull/295)

🫶 [@Myrdincx](https://github.com/Myrdincx) made their first contribution in [#290](https://github.com/welpo/tabi/pull/290)

## [2.6.1](https://github.com/welpo/tabi/compare/v2.6.0..v2.6.1) - 2024-03-21

### 🔧 Miscellaneous tasks

- *(CI)* Use CHANGES.md for GitHub release notes ([38f3aaf](https://github.com/welpo/tabi/commit/38f3aafdd8a34ae5452ae9bb879881b807e5a7b4)) by [@welpo](https://github.com/welpo)

## [2.6.0](https://github.com/welpo/tabi/compare/v2.5.0..v2.6.0) - 2024-03-21

### ✨ Features

- *(shortcodes)* Add admonition shortcode ([#285](https://github.com/welpo/tabi/issues/285)) ([d016229](https://github.com/welpo/tabi/commit/d0162291d961734c3e5f115348655f5755b8aa54)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(feed)* Fix "Visit website" link with skin config ([#286](https://github.com/welpo/tabi/issues/286)) by [@be-next](https://github.com/be-next)

## [2.5.0](https://github.com/welpo/tabi/compare/v2.4.0..v2.5.0) - 2024-03-17

### ✨ Features

- Allow disabling CSP, following the hierarchy ([5e0cbdd](https://github.com/welpo/tabi/commit/5e0cbdd67dbe4c17d635040959133edcc5066aff)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(i18n)* Improve FR translations and correct typos ([#284](https://github.com/welpo/tabi/issues/284)) by [@be-next](https://github.com/be-next)

### ♻️ Refactor

- Set visibility hidden in "hidden" class ([8537bbc](https://github.com/welpo/tabi/commit/8537bbc10ef7a142128f8d471ee19814cb0d904c)) by [@welpo](https://github.com/welpo)
- Correct invalid attributes in search input ([d825bef](https://github.com/welpo/tabi/commit/d825bef73065c7343ec952f938f7d4a17b4e363e)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(release)* Replace both pull and issue links ([e951e95](https://github.com/welpo/tabi/commit/e951e951102249707a4c899f0d194b781c3466d2)) by [@welpo](https://github.com/welpo)

## [2.4.0](https://github.com/welpo/tabi/compare/v2.3.0..v2.4.0) - 2024-03-02

### ✨ Features

- *(i18n)* Add Persian language ([#283](https://github.com/welpo/tabi/issues/283)) by [@mehr32](https://github.com/mehr32) and [@welpo](https://github.com/welpo)
- *(socials)* Add Signal icon ([4aaa234](https://github.com/welpo/tabi/commit/4aaa2346d0c10ef0322b0033358812520e2137af)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- Allow translated drafts ([#282](https://github.com/welpo/tabi/issues/282)) by [@Smtbook](https://github.com/Smtbook) and [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(CI)* Update git-cliff's github integration ([2ede035](https://github.com/welpo/tabi/commit/2ede03550aa1ce2d2c17063fff3d5a676c3ea2be)) by [@welpo](https://github.com/welpo)
- *(release)* Fix cross-compatibility of sed command ([0192b3e](https://github.com/welpo/tabi/commit/0192b3ed9f6df26f28320fd771f445bb74750812)) by [@welpo](https://github.com/welpo)
- *(release)* Add author link only on full changelog ([8de049a](https://github.com/welpo/tabi/commit/8de049a2b588b7e3b1d09ed361bb28ee2ea65af4)) by [@welpo](https://github.com/welpo)

### 👥 New contributors

🫶 [@mehr32](https://github.com/mehr32) made their first contribution in [#283](https://github.com/welpo/tabi/pull/283)

## [2.3.0](https://github.com/welpo/tabi/compare/v2.2.0..v2.3.0) - 2024-02-19

### ✨ Features

- *(i18n)* Implement pluralization logic ([#277](https://github.com/welpo/tabi/issues/277)) by [@TheAwiteb](https://github.com/TheAwiteb) and [@welpo](https://github.com/welpo)
- *(i18n)* Add Arabic language ([#265](https://github.com/welpo/tabi/issues/265)) by [@TheAwiteb](https://github.com/TheAwiteb)
- *(shortcodes)* Support URLs for image source ([#280](https://github.com/welpo/tabi/issues/280)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(404)* Fix broken language selection from 404 page ([90def02](https://github.com/welpo/tabi/commit/90def02dd7d54e62cbfe8f4e78b6e1e198b631be)) by [@welpo](https://github.com/welpo)
- *(article-navigation)* Adjust spacing for RTL ([#275](https://github.com/welpo/tabi/issues/275)) by [@welpo](https://github.com/welpo)
- *(i18n)* Reverse arrows in RTL languages ([#272](https://github.com/welpo/tabi/issues/272)) by [@TheAwiteb](https://github.com/TheAwiteb) and [@welpo](https://github.com/welpo)
- *(i18n)* Fix header anchor for RTL ([#270](https://github.com/welpo/tabi/issues/270)) by [@TheAwiteb](https://github.com/TheAwiteb) and [@welpo](https://github.com/welpo)
- *(i18n)* Atom feed page direction for RTL langs ([#268](https://github.com/welpo/tabi/issues/268)) by [@TheAwiteb](https://github.com/TheAwiteb) and [@welpo](https://github.com/welpo)

### 💄 Styling

- *(projects)* Set entire card as link target ([22d4d68](https://github.com/welpo/tabi/commit/22d4d68a690239dfe664e8513eaaf15b525e45ec)) by [@welpo](https://github.com/welpo)
- *(projects)* Minor redesign ([#278](https://github.com/welpo/tabi/issues/278)) by [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(i18n)* Add Arabic to list of supported languages ([e5442fa](https://github.com/welpo/tabi/commit/e5442fa29f32f9c1294d980df692b1ce096ce3fc)) by [@welpo](https://github.com/welpo)
- *(mastering-tabi)* Fix unclosed codeblock ([274c414](https://github.com/welpo/tabi/commit/274c4146b2dd04c6ca188c096002a02d4b073273)) by [@welpo](https://github.com/welpo)
- Fix various broken links ([6efe2ee](https://github.com/welpo/tabi/commit/6efe2ee57db4202fb0898b12e1f5e952e97ddc3a)) by [@welpo](https://github.com/welpo)
- Update tabi screenshots ([238487b](https://github.com/welpo/tabi/commit/238487b4b2d7e04c8176d35d69e4925dc4b98d9c)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(CI)* Build before checking links ([daef403](https://github.com/welpo/tabi/commit/daef40338ccf03250da2ec2b4382d644f277e4b4)) by [@welpo](https://github.com/welpo)
- *(CI)* Improve CI to check and build for PRs ([262fcd9](https://github.com/welpo/tabi/commit/262fcd95f18e90dca17522ce2de4f07df6febedd)) by [@welpo](https://github.com/welpo)
- *(demo)* Update projects section ([d543560](https://github.com/welpo/tabi/commit/d543560431e1ddd4624a684e5e8cca7f11ea0b7f)) by [@welpo](https://github.com/welpo)
- *(git-sumi)* Improve emoji matching ([e373482](https://github.com/welpo/tabi/commit/e3734829460d4f93643e7d8fc4a33670f5bb9c6e)) by [@welpo](https://github.com/welpo)
- *(link_checker)* Skip vultr.com links ([0158097](https://github.com/welpo/tabi/commit/0158097594f1d19653f2b68c4fedf802342aa8ad)) by [@welpo](https://github.com/welpo)
- *(projects)* Load git-sumi demo from its repo ([7b13798](https://github.com/welpo/tabi/commit/7b13798a68110d1da63870ea95230ece84526a8b)) by [@welpo](https://github.com/welpo)
- *(release)* Remove link comparison ([e2358f7](https://github.com/welpo/tabi/commit/e2358f7edfc2944e34bc59cbe4b1cbff64412f21)) by [@welpo](https://github.com/welpo)
- *(release)* Update CHANGELOG format ([5b5d1fa](https://github.com/welpo/tabi/commit/5b5d1fa592b72b50e1fccf172d9245a9e087bfd3)) by [@welpo](https://github.com/welpo)
- Add renovate config ([3672a94](https://github.com/welpo/tabi/commit/3672a94e863a44e88b1ec0e1896ac6ef38833ef7)) by [@welpo](https://github.com/welpo)

## [2.2.0](https://github.com/welpo/tabi/compare/v2.1.0..v2.2.0) - 2024-02-10

### ✨ Features

- *(i18n)* Add Right-to-left script support ([#262](https://github.com/welpo/tabi/issues/262)) by [@TheAwiteb](https://github.com/TheAwiteb) and [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(tags)* Arabic tags stuck together ([#264](https://github.com/welpo/tabi/issues/264)) by [@TheAwiteb](https://github.com/TheAwiteb) and [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(README)* Add git-sumi badge ([8b5a131](https://github.com/welpo/tabi/commit/8b5a131001cbb29656ab2339cafa777938353ea3)) by [@welpo](https://github.com/welpo)
- *(README)* Add IPA notation for pronunciation ([f7c0de4](https://github.com/welpo/tabi/commit/f7c0de412daf32f14374e282863c6f7be651e0c8)) by [@welpo](https://github.com/welpo)
- *(README)* Add project badges ([bcde187](https://github.com/welpo/tabi/commit/bcde187f73a278cb534282204f9aa183cec2ec0a)) by [@welpo](https://github.com/welpo)
- *(README)* Remove quick start section ([1382b44](https://github.com/welpo/tabi/commit/1382b44c182827a5757b7aaf50b1f036ccda12b4)) by [@welpo](https://github.com/welpo)
- *(README)* Recommend installing tabi as a submodule or cloning it ([a05170c](https://github.com/welpo/tabi/commit/a05170c6895ad7f7e8d71a482e6ea9efaa69030e)) by [@welpo](https://github.com/welpo)
- *(contributing)* Enrich PR information ([28d0f70](https://github.com/welpo/tabi/commit/28d0f70e18c392b0c57cc0e818ee1b763aa0137e)) by [@welpo](https://github.com/welpo)

### 🔧 Miscellaneous tasks

- *(CHANGELOG)* Improve emoji pattern ([1bb3c91](https://github.com/welpo/tabi/commit/1bb3c91b91585bb6317ed0d82e6d0c0fbc36e0b6)) by [@welpo](https://github.com/welpo)
- *(CI)* Update git-sumi config ([1e468f4](https://github.com/welpo/tabi/commit/1e468f4acb9d671c630d4a13e2b6e11dce13ed78)) by [@welpo](https://github.com/welpo)
- *(CI)* Use git-sumi hook to lint commit messages ([71f09a8](https://github.com/welpo/tabi/commit/71f09a81b0c190d69e28a6c122b559560fc72a26)) by [@welpo](https://github.com/welpo)
- *(CI)* Fix links in tag description ([7cc74d1](https://github.com/welpo/tabi/commit/7cc74d1fd9fe10d671c240029660c0164e821db5)) by [@welpo](https://github.com/welpo)
- *(git-sumi)* Require a space after the gitmoji ([119533b](https://github.com/welpo/tabi/commit/119533b176da6bb182b1349eacc049bea85c2bac)) by [@welpo](https://github.com/welpo)
- *(release)* Verify version tag format on release ([fcf16a4](https://github.com/welpo/tabi/commit/fcf16a457eac2f6daa15c9e7159713e2c78de709)) by [@welpo](https://github.com/welpo)
- Use git-sumi to lint commit messages ([c193d4d](https://github.com/welpo/tabi/commit/c193d4d4e898def908ff923958ccab7af4023664)) by [@welpo](https://github.com/welpo)
- Update changelog sections ([0e6c5c2](https://github.com/welpo/tabi/commit/0e6c5c269177712ae58649fe24662b407315d3f1)) by [@welpo](https://github.com/welpo)
- Add continuous deployment workflow ([9b8b139](https://github.com/welpo/tabi/commit/9b8b1396cfaeefd61050cdf49bf81f01977e5899)) by [@welpo](https://github.com/welpo)

## [2.1.0](https://github.com/welpo/tabi/compare/v2.0.0..v2.1.0) - 2024-01-29

### ✨ Features

- Allow inverting previous/next article links ([#261](https://github.com/welpo/tabi/issues/261)) by [@ZzMzaw](https://github.com/ZzMzaw) and [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(README)* Add CSS code block setup in required config ([c9d6b62](https://github.com/welpo/tabi/commit/c9d6b629078f70f4392818a17a4a7ac6b11c0480)) by [@welpo](https://github.com/welpo)

### 👥 New contributors

🫶 [@andwati](https://github.com/andwati) made their first contribution in [#257](https://github.com/welpo/tabi/pull/257)

## [2.0.0](https://github.com/welpo/tabi/compare/v1.0.0..v2.0.0) - 2024-01-15

### 💥 BREAKING CHANGES 💥

- *(i18n)* Force config.toml copyright translation ([#255](https://github.com/welpo/tabi/issues/255)) ([9f39b7f](https://github.com/welpo/tabi/commit/9f39b7fe47721eb7aaea04d8b9ee66b557b7eabf)) by [@welpo](https://github.com/welpo)
- *(home-banner)* Force proper header.img path ([#254](https://github.com/welpo/tabi/issues/254)) by [@welpo](https://github.com/welpo)

### ✨ Features

- *(a11y)* Add keyboard accessibility to theme toggler ([dce495e](https://github.com/welpo/tabi/commit/dce495e71d13c50fb5d2d57698fb350d72708609)) by [@welpo](https://github.com/welpo)
- *(archive)* Allow multiple sources in Archive ([#249](https://github.com/welpo/tabi/issues/249)) by [@welpo](https://github.com/welpo)
- *(socials)* Add Keybase icon ([#231](https://github.com/welpo/tabi/issues/231)) by [@arichtman](https://github.com/arichtman)
- *(tags)* Dynamically adjust tag list columns based on tag count ([#233](https://github.com/welpo/tabi/issues/233)) by [@welpo](https://github.com/welpo)
- *(tags)* Add `compact_tags` option ([#232](https://github.com/welpo/tabi/issues/232)) by [@welpo](https://github.com/welpo) and [@arichtman](https://github.com/arichtman)
- Add search functionality ([#250](https://github.com/welpo/tabi/issues/250)) by [@welpo](https://github.com/welpo)
- Adjust width of prev/next link section ([#248](https://github.com/welpo/tabi/issues/248)) by [@welpo](https://github.com/welpo)
- Add previous/next article navigation ([#246](https://github.com/welpo/tabi/issues/246)) by [@welpo](https://github.com/welpo)
- Add taxonomy list & single term templates ([#239](https://github.com/welpo/tabi/issues/239)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(archive)* Group multi-sourced posts by year ([2c8a21d](https://github.com/welpo/tabi/commit/2c8a21d558f5f6b3a208a3caf9a88b01c92ca0e1)) by [@welpo](https://github.com/welpo)
- *(i18n)* Localise date in single taxonomy listing ([0aef23b](https://github.com/welpo/tabi/commit/0aef23b3703ddedeff080525cbdede94451e7817)) by [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(faq-languages)* Clarify setting default language ([c4e5a65](https://github.com/welpo/tabi/commit/c4e5a65908431188c0b95038ac10bd0d4a1cff8d)) by [@welpo](https://github.com/welpo)
- *(mastering-tabi)* Fix `browser_theme_color` spelling ([e2baa36](https://github.com/welpo/tabi/commit/e2baa36ddc229e2a6a4519d312045a5b89669b0d)) by [@welpo](https://github.com/welpo)
- *(mastering-tabi)* Favour GitHub discussions over comment section ([cd2cbf3](https://github.com/welpo/tabi/commit/cd2cbf36fa6cc4eafff925c7907ce2598227a88c)) by [@welpo](https://github.com/welpo)

### ♻️ Refactor

- Format JS with Prettier ([#240](https://github.com/welpo/tabi/issues/240)) by [@welpo](https://github.com/welpo)

### 🗑️️ Deprecations

- *(home-banner)* [**‼️BREAKING‼️**] Force proper header.img path ([#254](https://github.com/welpo/tabi/issues/254)) by [@welpo](https://github.com/welpo)
- *(i18n)* [**‼️BREAKING‼️**] Force config.toml copyright translation ([#255](https://github.com/welpo/tabi/issues/255)) ([9f39b7f](https://github.com/welpo/tabi/commit/9f39b7fe47721eb7aaea04d8b9ee66b557b7eabf)) by [@welpo](https://github.com/welpo)

## 1.0.0 - 2023-12-29

### 💥 BREAKING CHANGES 💥

- *(theme-switcher)* Respect `theme_default` when JS is enabled ([#224](https://github.com/welpo/tabi/issues/224)) by [@welpo](https://github.com/welpo)

### ✨ Features

- *(HTML)* Respect `external_links_…` config ([#126](https://github.com/welpo/tabi/issues/126)) by [@welpo](https://github.com/welpo)
- *(SEO)* Add description support for sections ([#179](https://github.com/welpo/tabi/issues/179)) by [@donovanglover](https://github.com/donovanglover)
- *(ToC)* Implement setting hierarchy for ToC ([695e40b](https://github.com/welpo/tabi/commit/695e40be706a57023f9a4b69f82fdb05db77b9ec)) by [@welpo](https://github.com/welpo)
- *(alias)* Style redirect page ([#156](https://github.com/welpo/tabi/issues/156)) by [@welpo](https://github.com/welpo)
- *(archive)* Allow customising section for archive ([b987439](https://github.com/welpo/tabi/commit/b9874393b448e75b90945f32c5ea41aa5465fe25)) by [@welpo](https://github.com/welpo)
- *(atom)* Add `full_content_in_feed` option ([#164](https://github.com/welpo/tabi/issues/164)) by [@welpo](https://github.com/welpo)
- *(cards.html)* Render markdown content ([#201](https://github.com/welpo/tabi/issues/201)) by [@donovanglover](https://github.com/donovanglover)
- *(comments)* Allow page override of global system ([#216](https://github.com/welpo/tabi/issues/216)) by [@welpo](https://github.com/welpo)
- *(config)* Add dynamic stylesheet loading ([#118](https://github.com/welpo/tabi/issues/118)) by [@welpo](https://github.com/welpo)
- *(copyright)* Set copyright translations outside toml files & enhance $VARs ([#215](https://github.com/welpo/tabi/issues/215)) by [@ZzMzaw](https://github.com/ZzMzaw) and [@welpo](https://github.com/welpo)
- *(feed)* Support hiding pages and sections ([#227](https://github.com/welpo/tabi/issues/227)) by [@welpo](https://github.com/welpo)
- *(fonts)* Upgrade Inter to 4.0 ([012d819](https://github.com/welpo/tabi/commit/012d819f38f5b120c05830ebf0a0fed88f057c6e)) by [@welpo](https://github.com/welpo)
- *(fonts)* Optimise font size ([#186](https://github.com/welpo/tabi/issues/186)) by [@welpo](https://github.com/welpo)
- *(fonts)* Use woff2 & update fonts ([1c06c99](https://github.com/welpo/tabi/commit/1c06c9904772dd012c9c3b3752a537aeb8e1fc08)) by [@welpo](https://github.com/welpo)
- *(footer)* Add configurable footer menu ([#197](https://github.com/welpo/tabi/issues/197)) by [@welpo](https://github.com/welpo)
- *(footer)* Add configurable copyright notice ([#112](https://github.com/welpo/tabi/issues/112)) by [@welpo](https://github.com/welpo)
- *(footer)* Add link to remote repository ([#111](https://github.com/welpo/tabi/issues/111)) by [@welpo](https://github.com/welpo)
- *(footer)* Add link to remote repository ([99f6f2d](https://github.com/welpo/tabi/commit/99f6f2dcdc7bcab449f278fbad8cc4e9350071cd)) by [@welpo](https://github.com/welpo)
- *(footer/copyright)* Replace "$SEPARATOR" to `separator` ([f1edbba](https://github.com/welpo/tabi/commit/f1edbba8bd81a9f4253c582b95af1797ab828cff)) by [@welpo](https://github.com/welpo)
- *(footer/socials)* Add base64 encoded email protection ([427ffc7](https://github.com/welpo/tabi/commit/427ffc7241b32aba85f3dee67a2d371bb1c21420)) by [@welpo](https://github.com/welpo)
- *(header)* Cachebust custom font subset ([130aa51](https://github.com/welpo/tabi/commit/130aa51144f6c8bf84b06e4d6cb9daf75dacc4a2)) by [@welpo](https://github.com/welpo)
- *(header)* Add support for canonical URLs ([#168](https://github.com/welpo/tabi/issues/168)) by [@welpo](https://github.com/welpo)
- *(header)* Support multilingual meta tags in sections ([465bc55](https://github.com/welpo/tabi/commit/465bc55b9ab8263f55e0f83b9468a669c81b6ce8)) by [@welpo](https://github.com/welpo)
- *(header)* Add img_alt attribute for customisable alt text ([#153](https://github.com/welpo/tabi/issues/153)) by [@welpo](https://github.com/welpo)
- *(i18n)* Translate quick navigation buttons' titles ([c0a07cb](https://github.com/welpo/tabi/commit/c0a07cb4678c5b23bf1a049966f725c6d2c4b88a)) by [@welpo](https://github.com/welpo)
- *(i18n)* Overhaul translation system & add languages ([#145](https://github.com/welpo/tabi/issues/145)) by [@welpo](https://github.com/welpo)
- *(image shortcodes)* Add lazy loading ([#116](https://github.com/welpo/tabi/issues/116)) by [@welpo](https://github.com/welpo)
- *(info-page)* Enable arbitrary ToC location ([05ab241](https://github.com/welpo/tabi/commit/05ab241002be39dcc92b19b179329ada1579e6f4)) by [@welpo](https://github.com/welpo)
- *(list_posts.html)* Display draft status in post list ([#203](https://github.com/welpo/tabi/issues/203)) by [@xvello](https://github.com/xvello) and [@welpo](https://github.com/welpo)
- *(meta)* Allow hiding the read time indication on pages ([#124](https://github.com/welpo/tabi/issues/124)) by [@stevenroose](https://github.com/stevenroose) and [@welpo](https://github.com/welpo)
- *(multilingual-quote)* Allow missing author ([3cf9e3a](https://github.com/welpo/tabi/commit/3cf9e3ad8d193319e5313fff3a77a83aa1254e3b)) by [@welpo](https://github.com/welpo)
- *(pre-commit)* Improve robustness checking commands ([f98d23e](https://github.com/welpo/tabi/commit/f98d23ec937d07ef220ff043c500ac824a009367)) by [@welpo](https://github.com/welpo)
- *(pre-commit)* Sync config.toml and theme.toml [extra] ([1601fbf](https://github.com/welpo/tabi/commit/1601fbf30c66b90592acbae9e96ae80450d2d692)) by [@welpo](https://github.com/welpo)
- *(pre-commit)* Show which JS compressor is best ([cffe06f](https://github.com/welpo/tabi/commit/cffe06f44e695afc7c5e154ff8ec0084875240a6)) by [@welpo](https://github.com/welpo)
- *(pre-commit)* Check for JS minification ([1027c4f](https://github.com/welpo/tabi/commit/1027c4fd02bfde8d836cc69b869523f4053ee6e0)) by [@welpo](https://github.com/welpo)
- *(quick-navigation)* Add ToC button ([#115](https://github.com/welpo/tabi/issues/115)) by [@welpo](https://github.com/welpo)
- *(settings)* Add hierarchy-based setting overrides ([#128](https://github.com/welpo/tabi/issues/128)) by [@welpo](https://github.com/welpo)
- *(shortcode)* Add spoiler shortcode ([#113](https://github.com/welpo/tabi/issues/113)) by [@welpo](https://github.com/welpo)
- *(shortcodes)* Update image path retrieval and dimensions in shortcodes ([b841969](https://github.com/welpo/tabi/commit/b841969a8fc4a783a49bd98c6d690fc06f87dc08)) by [@welpo](https://github.com/welpo)
- *(sitemap)* Mention baseurl in header & title ([381f41d](https://github.com/welpo/tabi/commit/381f41dd0dc4cee56fd13b05f05333085e668b23)) by [@welpo](https://github.com/welpo)
- *(sitemap)* Add XML styling ([#221](https://github.com/welpo/tabi/issues/221)) by [@welpo](https://github.com/welpo)
- *(social-icons)* Add Matrix icon ([28fb525](https://github.com/welpo/tabi/commit/28fb52581fc6bd20b0a2cce084bea858ce2a8b63)) by [@welpo](https://github.com/welpo)
- *(social-icons)* Add X icon ([b797879](https://github.com/welpo/tabi/commit/b797879403406063560864899b717785b1fcd359)) by [@welpo](https://github.com/welpo)
- *(social-media-cards)* Support relative paths ([#163](https://github.com/welpo/tabi/issues/163)) by [@welpo](https://github.com/welpo)
- *(social-media-cards)* Add support for twitter:image ([22579a5](https://github.com/welpo/tabi/commit/22579a59743c5f1e0531de025c8402d4379736eb)) by [@welpo](https://github.com/welpo)
- *(socials)* Add Nostr icon ([79af568](https://github.com/welpo/tabi/commit/79af5680784fe0d16644d8102863725d5bb909e5)) by [@welpo](https://github.com/welpo)
- *(socials)* Add Google Scholar icon ([dd76c18](https://github.com/welpo/tabi/commit/dd76c18faa8633713832fafe3dcf1a8b05ed0335)) by [@welpo](https://github.com/welpo)
- *(templates)* Introduce info-page template ([#147](https://github.com/welpo/tabi/issues/147)) by [@welpo](https://github.com/welpo)
- *(theme-switcher)* [**‼️BREAKING‼️**] Respect `theme_default` when JS is enabled ([#224](https://github.com/welpo/tabi/issues/224)) by [@welpo](https://github.com/welpo)
- *(theme-switcher)* Add theme reset button ([#198](https://github.com/welpo/tabi/issues/198)) by [@welpo](https://github.com/welpo)
- *(theme-switcher)* Hide button if JS is disabled ([113a7f4](https://github.com/welpo/tabi/commit/113a7f4e5d4efd87646f8c26f81b7754ea7f41e2)) by [@welpo](https://github.com/welpo)
- *(title)* Add `invert_title_order` config option ([#142](https://github.com/welpo/tabi/issues/142)) by [@welpo](https://github.com/welpo)
- Allow relative paths for image shortcodes ([#222](https://github.com/welpo/tabi/issues/222)) by [@welpo](https://github.com/welpo)
- Improve clickability cue by adding pointer cursor to details summary ([1e33b9b](https://github.com/welpo/tabi/commit/1e33b9bc1f3cc995a1ed7e265a106d194c8dfcef)) by [@welpo](https://github.com/welpo)
- Support privacy-respecting analytics ([#193](https://github.com/welpo/tabi/issues/193)) by [@welpo](https://github.com/welpo)
- Allow internal project links ([#157](https://github.com/welpo/tabi/issues/157)) by [@welpo](https://github.com/welpo)
- Enhance SEO and accessibility with meta tags ([#154](https://github.com/welpo/tabi/issues/154)) by [@welpo](https://github.com/welpo)
- Add `browser_theme_color` config option ([#143](https://github.com/welpo/tabi/issues/143)) by [@welpo](https://github.com/welpo)
- Add support for social media cards ([#130](https://github.com/welpo/tabi/issues/130)) by [@welpo](https://github.com/welpo)
- Add base64 encoded email protection ([#110](https://github.com/welpo/tabi/issues/110)) by [@welpo](https://github.com/welpo)
- Avoid commiting drafts ([6cb2327](https://github.com/welpo/tabi/commit/6cb23279075211380e748bdb535fe38853ff6199)) by [@welpo](https://github.com/welpo)
- Add pre-commit hook ([22d8ae6](https://github.com/welpo/tabi/commit/22d8ae6b8aecac19500b70488f3d8f269b7f0e96)) by [@welpo](https://github.com/welpo)
- Add support for remote codeberg repositories ([b5fae83](https://github.com/welpo/tabi/commit/b5fae83f28800ad6ef5a34180d84f05c8fe72849)) by [@welpo](https://github.com/welpo)
- Add link to commit history on updated articles ([#109](https://github.com/welpo/tabi/issues/109)) by [@welpo](https://github.com/welpo)
- Overhaul Table of Contents ([#108](https://github.com/welpo/tabi/issues/108)) by [@welpo](https://github.com/welpo)
- Enhance Table of Contents ([07ceddc](https://github.com/welpo/tabi/commit/07ceddcc007b948e697da8a2dcf62edc37d91c6e)) by [@welpo](https://github.com/welpo)
- Add `toc_levels` to control ToC depth ([965af4b](https://github.com/welpo/tabi/commit/965af4b3dd35d1c5f24b4aa0ba847804e0d3c3da)) by [@welpo](https://github.com/welpo)
- Add wide container shortcode ([#107](https://github.com/welpo/tabi/issues/107)) by [@welpo](https://github.com/welpo)
- Add wide container shortcode ([fb0dea0](https://github.com/welpo/tabi/commit/fb0dea01067c91cf9d91eeb14ac8bf41842645e8)) by [@welpo](https://github.com/welpo)
- Add `rel=me` attribute to social links ([4952ce8](https://github.com/welpo/tabi/commit/4952ce88f14d5d39d583926eaac7460b9783bff3)) by [@welpo](https://github.com/welpo)
- Introduce skins to customise the theme ([#105](https://github.com/welpo/tabi/issues/105)) by [@welpo](https://github.com/welpo)
- Add pointer cursor to image toggler ([d2780f4](https://github.com/welpo/tabi/commit/d2780f42a3b5caff5c920be4580e01f966e30362)) by [@welpo](https://github.com/welpo)
- Add `cachebust` for `main.css` ([2f83ef8](https://github.com/welpo/tabi/commit/2f83ef80621245d8a497c0a2ccfd7d4c375ce2b2)) by [@welpo](https://github.com/welpo)
- Add 2 interactive image shortcodes by [@welpo](https://github.com/welpo)
- Add 2 interactive image shortcodes ([7ccd717](https://github.com/welpo/tabi/commit/7ccd71736eb8c3e7ee1114b271e8b698bdf5df18)) by [@welpo](https://github.com/welpo)
- Allow setting default theme by [@welpo](https://github.com/welpo)
- Allow setting the default theme ([c78c7f5](https://github.com/welpo/tabi/commit/c78c7f5bd1d1f5f5d8d37daade0ff27a7a59b479)) by [@welpo](https://github.com/welpo)
- Global/individual toggle for KaTeX and copy button ([edcfa35](https://github.com/welpo/tabi/commit/edcfa359ef1abab43d5bedf77a24c3fab27f0297)) by [@welpo](https://github.com/welpo)
- Add backlinks to footnotes ([#101](https://github.com/welpo/tabi/issues/101)) by [@welpo](https://github.com/welpo)
- Optional trailing slash in menu links ([f9c18b0](https://github.com/welpo/tabi/commit/f9c18b03987a7077301992f8369f4de75e270a2a)) by [@welpo](https://github.com/welpo)
- Add JavaScript notice for comments ([09e5bc1](https://github.com/welpo/tabi/commit/09e5bc1aa3f09ccf83c126cd8dc1b0ef6edcb4dd)) by [@welpo](https://github.com/welpo)
- Add support for Isso comments by [@welpo](https://github.com/welpo)
- Add support for Isso comments ([9a98789](https://github.com/welpo/tabi/commit/9a98789922ce7dee96e0fab6ebbc9ba0c5499e80)) by [@welpo](https://github.com/welpo)
- Add support for Hyvor Talk comments by [@welpo](https://github.com/welpo)
- Add support for Hyvor Talk comments ([7924e82](https://github.com/welpo/tabi/commit/7924e8206c17423c9043453fb37bc394f8676345)) by [@welpo](https://github.com/welpo)
- Add quick navigation buttons by [@welpo](https://github.com/welpo)
- Add quick navigation buttons ([05a6d15](https://github.com/welpo/tabi/commit/05a6d15455a0ecc41f071ce03fbed5aaf16d38b5)) by [@welpo](https://github.com/welpo)
- Add support for giscus & utterances comments by [@welpo](https://github.com/welpo)
- Add support for giscus and utterances ([5993e95](https://github.com/welpo/tabi/commit/5993e950c7a6084f069403e3a98c85aa643654f7)) by [@welpo](https://github.com/welpo)
- Add support for giscus & utterances comments ([19d1200](https://github.com/welpo/tabi/commit/19d120019b6f8c7041965895dad2764dc2aa4f5d)) by [@welpo](https://github.com/welpo)
- Add utterances support ([93c8b57](https://github.com/welpo/tabi/commit/93c8b577b87aaa928a13b5696d7b3ebc91aa6cce)) by [@welpo](https://github.com/welpo)
- Add copy button to code blocks by [@welpo](https://github.com/welpo)
- Add copy button to code blocks ([2dec139](https://github.com/welpo/tabi/commit/2dec139e41ffe558b7d8fdd785ed5f1889d6723b)) by [@welpo](https://github.com/welpo)
- Add basic copy button to codeblocks ([8e1473b](https://github.com/welpo/tabi/commit/8e1473bba916523f4d1855d4c631e78d603443ba)) by [@welpo](https://github.com/welpo)
- Add full-width image option to shortcodes  by [@welpo](https://github.com/welpo)
- Add full-width image option to shortcodes ([fd50204](https://github.com/welpo/tabi/commit/fd50204e32aee4402835263f9e420adbc2f6cb8e)) by [@welpo](https://github.com/welpo)
- Custom feed content and style by [@welpo](https://github.com/welpo)
- Style xml feed ([1b60be8](https://github.com/welpo/tabi/commit/1b60be8c9d4e28645e713672eeb1b9dbdf4e1789)) by [@welpo](https://github.com/welpo)
- Use page description as summary ([54e88be](https://github.com/welpo/tabi/commit/54e88beca21976a350ce6babd9fe10b07d658cf4)) by [@welpo](https://github.com/welpo)
- Add custom quotation marks for multilingual quotes ([dd73e52](https://github.com/welpo/tabi/commit/dd73e527298c1c4357e48589314bfd9302323c27)) by [@welpo](https://github.com/welpo)
- Add multilingual quote shortcode ([ab29511](https://github.com/welpo/tabi/commit/ab29511d5e7f44ba5cc07e1a29c0d678c24b3cd4)) by [@welpo](https://github.com/welpo)
- Allow using emojis as favicon ([fb061a1](https://github.com/welpo/tabi/commit/fb061a14697d45700996f32b568826b4f02764c7)) by [@welpo](https://github.com/welpo)
- Include layout features in font subset ([534969d](https://github.com/welpo/tabi/commit/534969de11930ec957d6ea4eea658324a3d29497)) by [@welpo](https://github.com/welpo)
- Add multi-language support ([fa92293](https://github.com/welpo/tabi/commit/fa9229377d03f229b4deb68bad7cf63b2f88f9fe)) by [@welpo](https://github.com/welpo)
- Set width and height of project images ([8b5726c](https://github.com/welpo/tabi/commit/8b5726c34e04238b0371fb3dbd11cafaaff580f0)) by [@welpo](https://github.com/welpo)
- Add KaTeX support ([f9335b3](https://github.com/welpo/tabi/commit/f9335b3fa45f27788cdb9c8d26ddfe4b714070c4)) by [@welpo](https://github.com/welpo)
- Make JS light/dark toggle optional ([1803987](https://github.com/welpo/tabi/commit/1803987555cbbe0aea1ab673907192e734a55425)) by [@welpo](https://github.com/welpo)
- Use github pages for live preview ([a36823d](https://github.com/welpo/tabi/commit/a36823d672e3894ac428642d433c5506cdbbe728)) by [@welpo](https://github.com/welpo)
- Allow dual date-format (short/long) by [@welpo](https://github.com/welpo)
- Allow dual date-format (short/long) ([9887fb0](https://github.com/welpo/tabi/commit/9887fb0a6f9f0e94d9d7faca57c62fb3549bdb83)) by [@welpo](https://github.com/welpo)
- Add 'Last updated' extra tag by [@welpo](https://github.com/welpo)
- Add 'Last updated' extra tag ([ed47f25](https://github.com/welpo/tabi/commit/ed47f2580ba4f8f15188c67f3b788b7472f4d78b)) by [@welpo](https://github.com/welpo)
- Add dual image support for switching themes by [@welpo](https://github.com/welpo)
- Add dual image support for switching themes ([b3dc539](https://github.com/welpo/tabi/commit/b3dc5396b4c429537f82afb8cd63a67146b5b9ac)) by [@welpo](https://github.com/welpo)
- Use custom separator from config in meta & title ([aa00640](https://github.com/welpo/tabi/commit/aa00640e96a6e0934e7792f384f09ec476f3bdb7)) by [@welpo](https://github.com/welpo)
- Allow customizable secure headers (CSP) ([d7caa7a](https://github.com/welpo/tabi/commit/d7caa7af5fc5d0096fbb402b0b8ce53930f3d56f)) by [@welpo](https://github.com/welpo)
- Display word count when hovering over read time ([d9cd64e](https://github.com/welpo/tabi/commit/d9cd64e5a40c154c89d91b8b649348bcabfafb71)) by [@welpo](https://github.com/welpo)
- Responsive (and centered) images ([9242fa4](https://github.com/welpo/tabi/commit/9242fa4389cd2ce418c2074aa00afc8107e753d0)) by [@welpo](https://github.com/welpo)
- Clean js code ([2f80b0b](https://github.com/welpo/tabi/commit/2f80b0b5ad481d53d5621f84bffd3415fc078672)) by [@serginogal](https://github.com/serginogal)
- Change default theme to OS setting ([26ad170](https://github.com/welpo/tabi/commit/26ad170d9fee316fb3eb131cc664cd1eed9e1cfe)) by [@welpo](https://github.com/welpo)
- Add dimmable-image shortcode for dark theme ([174a37e](https://github.com/welpo/tabi/commit/174a37e221dc0b38eb1160bbf320c7b03b73d901)) by [@welpo](https://github.com/welpo)
- Showcase invertable image ([0bae051](https://github.com/welpo/tabi/commit/0bae0515ec4579e26a827dba907f890198df01eb)) by [@welpo](https://github.com/welpo)
- Showcase invertable image ([2f4695d](https://github.com/welpo/tabi/commit/2f4695dd0bcec55357f1c8829fbdf5aee8d76f9a)) by [@welpo](https://github.com/welpo)
- Add Archive page to features. ([999861b](https://github.com/welpo/tabi/commit/999861ba583706b63e73fb7f675bedacaaf5bce4)) by [@welpo](https://github.com/welpo)
- Remove Archive from TODO ([559c97d](https://github.com/welpo/tabi/commit/559c97d1f3a6f2e1da760ccb6adb5a20b5fe5b44)) by [@welpo](https://github.com/welpo)
- Add archive screen ([3434cbc](https://github.com/welpo/tabi/commit/3434cbc92630d7a60963f51990216facd586e546)) by [@serginogal](https://github.com/serginogal)
- Change markdown description style ([c29697c](https://github.com/welpo/tabi/commit/c29697c4212d59588b75013c473790cd97445164)) by [@serginogal](https://github.com/serginogal)
- Add markdown support to index page ([c6ec7c7](https://github.com/welpo/tabi/commit/c6ec7c750588562c3a14c1ee0f2a7d00f467bbd6)) by [@serginogal](https://github.com/serginogal)
- Set Table of Contents per page, not globally ([32d4a93](https://github.com/welpo/tabi/commit/32d4a9358ce14c9dce687520e7c58cb93d07a7b6)) by [@welpo](https://github.com/welpo)

### 🐛 Bug fixes

- *(SEO)* Set proper social image cards ([b26902d](https://github.com/welpo/tabi/commit/b26902da1667ecfaf5649dc9637360658c135faf)) by [@welpo](https://github.com/welpo)
- *(a11y)* Update heading tags ([#140](https://github.com/welpo/tabi/issues/140)) by [@welpo](https://github.com/welpo)
- *(analytics)* Make goatcounter use https ([#195](https://github.com/welpo/tabi/issues/195)) by [@nyadiia](https://github.com/nyadiia)
- *(atom)* Remove safe filter; allow content & summary ([#165](https://github.com/welpo/tabi/issues/165)) by [@SeaDve](https://github.com/SeaDve)
- *(atom)* Escape HTML in feed summary ([4610073](https://github.com/welpo/tabi/commit/46100730fa59d6f14d3565e87b48fad5d69afab5)) by [@welpo](https://github.com/welpo)
- *(comments)* Fix malformed URLs in Isso mails ([#211](https://github.com/welpo/tabi/issues/211)) by [@welpo](https://github.com/welpo)
- *(favicon)* Use `get_url` for favicon ([ab4b523](https://github.com/welpo/tabi/commit/ab4b523f9c7efa431dee4780c5b701c7496faa2d)) by [@welpo](https://github.com/welpo)
- *(fonts)* Fix extension woff -> woff2 ([5aece98](https://github.com/welpo/tabi/commit/5aece9856a23f79143e90e91747e9f852903810b)) by [@welpo](https://github.com/welpo)
- *(footer)* Fix external link redirection in footer ([#219](https://github.com/welpo/tabi/issues/219)) by [@joberthrogers18](https://github.com/joberthrogers18) and [@welpo](https://github.com/welpo)
- *(footer)* Render footer again ([3344f80](https://github.com/welpo/tabi/commit/3344f80539d837df10523160083d91c55b04f58f)) by [@welpo](https://github.com/welpo)
- *(footer)* Remove extra space between "tabi" and separator ([12b9184](https://github.com/welpo/tabi/commit/12b9184f15edc26acfd442923dd6d9f3bcfa9615)) by [@welpo](https://github.com/welpo)
- *(format_date)* Actually use `short_date_format` ([#119](https://github.com/welpo/tabi/issues/119)) by [@stevenroose](https://github.com/stevenroose)
- *(header)* Add quotes to custom subset links ([1221eee](https://github.com/welpo/tabi/commit/1221eeeb41c17556784c27d98d18a0d75cdbfc52)) by [@welpo](https://github.com/welpo)
- *(header)* Correct self-closing script tag ([94f7a36](https://github.com/welpo/tabi/commit/94f7a367075b0bfeacccad44742d52f7732ff3c3)) by [@welpo](https://github.com/welpo)
- *(header)* Check if translations exist while building tags ([#159](https://github.com/welpo/tabi/issues/159)) by [@welpo](https://github.com/welpo)
- *(header)* Don't fail if custom_subset absent ([#132](https://github.com/welpo/tabi/issues/132)) by [@xvello](https://github.com/xvello)
- *(home-banner)* Allow missing image & correct spacing ([#123](https://github.com/welpo/tabi/issues/123)) by [@welpo](https://github.com/welpo)
- *(html)* Remove unused self-closing tags ([#176](https://github.com/welpo/tabi/issues/176)) by [@donovanglover](https://github.com/donovanglover)
- *(hyvor-talk)* Switch from ID to class selector for initialisation ([#196](https://github.com/welpo/tabi/issues/196)) by [@welpo](https://github.com/welpo)
- *(i18n)* Use English by default in atom.xml ([#167](https://github.com/welpo/tabi/issues/167)) by [@donovanglover](https://github.com/donovanglover)
- *(i18n-es)* Correct 'of' translation ([0b6cb31](https://github.com/welpo/tabi/commit/0b6cb31bba927315c975dfe5bcf12b691a6e2573)) by [@welpo](https://github.com/welpo)
- *(isso-comments)* Actually set maxCommentsNested ([47c493b](https://github.com/welpo/tabi/commit/47c493be89cfb58ab3945ff30da618767330fe1a)) by [@welpo](https://github.com/welpo)
- *(multilingual-quote)* Open <p> regardless of attribution ([01d5322](https://github.com/welpo/tabi/commit/01d5322ef355af0b4bff9bbaf072305b45ba9f0b)) by [@welpo](https://github.com/welpo)
- *(quick-navigation)* Limit width of toc ([#204](https://github.com/welpo/tabi/issues/204)) by [@donovanglover](https://github.com/donovanglover)
- *(quick-navigation-buttons)* Fix overlapping background change ([f4c8826](https://github.com/welpo/tabi/commit/f4c88266e7160010ee739273c16e7b66c95f5e4a)) by [@welpo](https://github.com/welpo)
- *(sitemap)* Use the base url for JS/CSS loading ([c8a1705](https://github.com/welpo/tabi/commit/c8a1705b51984666af676181bf24eb0352c684c1)) by [@welpo](https://github.com/welpo)
- *(skins)* Load `teal` if set in config ([3e30557](https://github.com/welpo/tabi/commit/3e30557dca2b1d378e959eb0af41fa96fadfaf9c)) by [@welpo](https://github.com/welpo)
- *(style)* Proper nested lists spacing ([#218](https://github.com/welpo/tabi/issues/218)) by [@xvello](https://github.com/xvello)
- *(style)* Add line-height to .section-title ([#205](https://github.com/welpo/tabi/issues/205)) by [@donovanglover](https://github.com/donovanglover)
- *(style)* Prevent videos from overflowing container ([#185](https://github.com/welpo/tabi/issues/185)) by [@donovanglover](https://github.com/donovanglover)
- *(styled feed)* Url to "Visit Website" ([68e37f4](https://github.com/welpo/tabi/commit/68e37f4574d9bf0183d76286a45c39e824790e68)) by [@welpo](https://github.com/welpo)
- *(stylised-feed)* Set proper date class ([#207](https://github.com/welpo/tabi/issues/207)) by [@welpo](https://github.com/welpo)
- *(theme-switcher)* Match functionality of minified and non-minified files ([ee2b171](https://github.com/welpo/tabi/commit/ee2b171fbd0c79b7374dda807fe223c72f81e9d5)) by [@welpo](https://github.com/welpo)
- *(theme-switcher)* Properly translate aria-label ([#192](https://github.com/welpo/tabi/issues/192)) by [@Almost-Senseless-Coder](https://github.com/Almost-Senseless-Coder), [@Tim](https://github.com/Tim) Böttcher and [@welpo](https://github.com/welpo)
- Prevent background overflow on link hover ([#226](https://github.com/welpo/tabi/issues/226)) by [@welpo](https://github.com/welpo)
- Remove unnecessary description filters ([6673a06](https://github.com/welpo/tabi/commit/6673a063b8968d39b8396bc83242f779615a14c7)) by [@welpo](https://github.com/welpo)
- Improve accessibility and i18n ([#183](https://github.com/welpo/tabi/issues/183)) by [@welpo](https://github.com/welpo)
- Allow live reload when zola is in `serve` mode ([#144](https://github.com/welpo/tabi/issues/144)) by [@welpo](https://github.com/welpo)
- `is_draft` returning opposite value ([adb702f](https://github.com/welpo/tabi/commit/adb702f3c36ee19b43805b7cb27a5b97d9653ecc)) by [@welpo](https://github.com/welpo)
- Check proper `toc_ignore_pattern` ([fe872a7](https://github.com/welpo/tabi/commit/fe872a7b54f8c24c3bb4d678c72d4f17b6f6d396)) by [@welpo](https://github.com/welpo)
- Move `default_language` to proper section ([52d0ac9](https://github.com/welpo/tabi/commit/52d0ac944794d8590db5cda81015b1181ea83971)) by [@welpo](https://github.com/welpo)
- Update bug report link format ([6178e8e](https://github.com/welpo/tabi/commit/6178e8e642fce10fcb2be378dc4440b754fe804d)) by [@welpo](https://github.com/welpo)
- Revert flex display (b1b98eb) ([8cfab98](https://github.com/welpo/tabi/commit/8cfab98e721d9dccc05b2d5f187ddeb2248930b7)) by [@welpo](https://github.com/welpo)
- Remove flex display on full-width elements ([56a53dc](https://github.com/welpo/tabi/commit/56a53dce0cf131c73474d33612a429a80ab1cfdc)) by [@welpo](https://github.com/welpo)
- Improve contrast on `code` within links on hover ([f8891db](https://github.com/welpo/tabi/commit/f8891dba2cc0d1a8619bf9b01bb06e4c7560b7ec)) by [@welpo](https://github.com/welpo)
- Draft margin ([8949db4](https://github.com/welpo/tabi/commit/8949db43e136e2646bbf7ff3da4a833e838796e4)) by [@welpo](https://github.com/welpo)
- Add missing images for new shortcodes ([9ad0883](https://github.com/welpo/tabi/commit/9ad08838c78d51400bcb059781a708ccff0cdaf6)) by [@welpo](https://github.com/welpo)
- Set proper color-scheme meta ([638d75c](https://github.com/welpo/tabi/commit/638d75c819ab00f5f4812109bc87c9a9918b20c1)) by [@welpo](https://github.com/welpo)
- Remove extra newlines in final html ([ab879e3](https://github.com/welpo/tabi/commit/ab879e372705ff73b1bb4316f2ceca6b92f7cdf3)) by [@welpo](https://github.com/welpo)
- Align text to left codeblocks with line numbers ([672772a](https://github.com/welpo/tabi/commit/672772a700de4d4b23e5b18b0ae4fa1cd3aca797)) by [@welpo](https://github.com/welpo)
- Correct CSS path for GitHub pages ([b2ca636](https://github.com/welpo/tabi/commit/b2ca636eb98ff7e2361a1db5da3b349bf566846d)) by [@welpo](https://github.com/welpo)
- Path to main.css ([86ab1c5](https://github.com/welpo/tabi/commit/86ab1c5f06238ae868b06b139852b0638dba5d7d)) by [@welpo](https://github.com/welpo)
- Use relative path to main.css ([e7bd988](https://github.com/welpo/tabi/commit/e7bd988a52dc3db988e0715f8f2948aec2220360)) by [@welpo](https://github.com/welpo)
- Multilingual issues in feeds and 'nav.html' by [@welpo](https://github.com/welpo)
- Load English stylesheet as fallback ([f3a0dd7](https://github.com/welpo/tabi/commit/f3a0dd7f96dbb8fbd1073f66288133db348917e8)) by [@welpo](https://github.com/welpo)
- Multilingual issues in feeds and 'nav.html' ([e7dc5eb](https://github.com/welpo/tabi/commit/e7dc5eb44e5c7f6bd00c3d2337438b8481d8101b)) by [@Smtbook](https://github.com/Smtbook)
- Properly initialise `currentTheme` ([e1dfd2e](https://github.com/welpo/tabi/commit/e1dfd2ea0767ac7327244961c920031a8291c249)) by [@welpo](https://github.com/welpo)
- Replace "y" with "i" ([f5e9ad8](https://github.com/welpo/tabi/commit/f5e9ad8c8a689a593af88d0ca62b11d74bbb76ce)) by [@welpo](https://github.com/welpo)
- Use proper meta descriptions ([3e215e1](https://github.com/welpo/tabi/commit/3e215e18e29ec42761a9cd52c2f81612e3311acd)) by [@welpo](https://github.com/welpo)
- Ensure codeblock header visibility on iOS ([abf32b8](https://github.com/welpo/tabi/commit/abf32b8147046b03270b92b5c9cf9ea69428b863)) by [@welpo](https://github.com/welpo)
- Properly check for `theme_switcher` setting ([f710b62](https://github.com/welpo/tabi/commit/f710b62631ab2b3cb791bccd624c40b249c57fb0)) by [@welpo](https://github.com/welpo)
- Remove leading slash from css href ([a6dfd4d](https://github.com/welpo/tabi/commit/a6dfd4d1ba5e781b4d26047a37f925e307de0e6c)) by [@welpo](https://github.com/welpo)
- Remove leading slash from xsl href ([19bebde](https://github.com/welpo/tabi/commit/19bebde14819d8285e50e7ec3cdd1045c66de2a4)) by [@welpo](https://github.com/welpo)
- Set svg max-height only for social icons ([4df7cdc](https://github.com/welpo/tabi/commit/4df7cdcb7a06ce6ace7463d727e7719a4d9d8c13)) by [@welpo](https://github.com/welpo)
- Generate random id for multilingual quotes ([0e1a514](https://github.com/welpo/tabi/commit/0e1a5143c0bba6eee11de0b461400b6a85709281)) by [@welpo](https://github.com/welpo)
- Proper URL for multilingual rss/atom feeds ([56a3061](https://github.com/welpo/tabi/commit/56a3061573de3e4e7feb044d51091c7f2671cc01)) by [@welpo](https://github.com/welpo)
- Mention translations in 404 if there's more than 1 language ([58d0dd6](https://github.com/welpo/tabi/commit/58d0dd6f2f918cc0ce8eb649d521d8a385e94bd0)) by [@welpo](https://github.com/welpo)
- Show language switcher if there's more than 1 language ([5ac69fe](https://github.com/welpo/tabi/commit/5ac69fe21d3b588dea38c84f3b38d8ec5e69d5ce)) by [@welpo](https://github.com/welpo)
- Avoid empty dates when long_date_format is empty ([eded835](https://github.com/welpo/tabi/commit/eded835d3fcfce781393dd4f448ef907fd916316)) by [@welpo](https://github.com/welpo)
- Remove extra backtick ([358e78d](https://github.com/welpo/tabi/commit/358e78d25a6afa7010933bfbb18ce89845c3a4dc)) by [@welpo](https://github.com/welpo)
- Remove flashing from header text (Firefox) ([a5981e6](https://github.com/welpo/tabi/commit/a5981e6fdd5528d0c0461806c48d6ce573839621)) by [@welpo](https://github.com/welpo)
- Remove flash when navigating in dark-mode ([1efb033](https://github.com/welpo/tabi/commit/1efb0330e3926235cde79bdaec9bf157dc6d1743)) by [@welpo](https://github.com/welpo)
- Only load script when themeswitcher is enabled ([556570d](https://github.com/welpo/tabi/commit/556570d799362716c6a0b174378639206646242e)) by [@welpo](https://github.com/welpo)
- Handle missing image metadata gracefully ([b5b50cd](https://github.com/welpo/tabi/commit/b5b50cdefbf1864778fbb5bbb3a83869811b39ac)) by [@welpo](https://github.com/welpo)
- Properly end macro ([7aa6142](https://github.com/welpo/tabi/commit/7aa61422a8f642384a0be8a5e92e1e26c334e6a5)) by [@welpo](https://github.com/welpo)
- Set proper scope to transparent hover for anchor ([050f546](https://github.com/welpo/tabi/commit/050f546e27f5bcfc1e5500b33279f82ef45c0caa)) by [@welpo](https://github.com/welpo)
- Remove double equals in updated field ([dcf1af5](https://github.com/welpo/tabi/commit/dcf1af5ec5211bb8e4d97e4cafd21b08d2287ade)) by [@welpo](https://github.com/welpo)
- Fix screenshot path ([110c872](https://github.com/welpo/tabi/commit/110c8723c39dcae23baeff6f34c501c78fbc8643)) by [@welpo](https://github.com/welpo)
- Clarify requirements for A+ Observatory score ([4d18be3](https://github.com/welpo/tabi/commit/4d18be3a83557b6268f6d8b7de9f69c34ceacd27)) by [@welpo](https://github.com/welpo)
- Clarify requirements for A+ Observatory score ([65a3fce](https://github.com/welpo/tabi/commit/65a3fcebba7c66209c9ac7e779c5bfe116c5eb1a)) by [@welpo](https://github.com/welpo)
- Enable github pages ([1b5ed15](https://github.com/welpo/tabi/commit/1b5ed1546ae25bf0e5cc7e74cb922340668cf987)) by [@welpo](https://github.com/welpo)
- Use personal access token ([fded2bd](https://github.com/welpo/tabi/commit/fded2bd53ead80954c253570aad413c19cd00763)) by [@welpo](https://github.com/welpo)
- Update token ([91de9ad](https://github.com/welpo/tabi/commit/91de9ad036597aaec3ea24c29f81531bdebed523)) by [@welpo](https://github.com/welpo)
- Use latest zola-deploy-action ([19bd85f](https://github.com/welpo/tabi/commit/19bd85f8db1bb5709c85907e86f47fca8402a5f6)) by [@welpo](https://github.com/welpo)
- Remove header link background change on hover ([884cc90](https://github.com/welpo/tabi/commit/884cc9043969ac619519924f88b5b80cbc6a6b36)) by [@welpo](https://github.com/welpo)
- Remove horizontall scroll on mobile ([e93b33e](https://github.com/welpo/tabi/commit/e93b33e6b88c2016741b220dd9e0dac3ccd0dd01)) by [@welpo](https://github.com/welpo)
- Remove newlines around `<title>` from source code ([ac0495e](https://github.com/welpo/tabi/commit/ac0495ea6990f14a060cc909138b0fce32699bfd)) by [@welpo](https://github.com/welpo)
- Remove h1 permalinkbackground on hover ([667f15a](https://github.com/welpo/tabi/commit/667f15abb2ba77cbf7250c71209c3eb8d6faa125)) by [@welpo](https://github.com/welpo)
- Improve tap target sizing for tags ([9560103](https://github.com/welpo/tabi/commit/9560103ce7d35d633046f6c10d4117040a66aa47)) by [@welpo](https://github.com/welpo)
- Improve accessibility by [@welpo](https://github.com/welpo)
- Improve accessibility in lists & taps ([50b8d5f](https://github.com/welpo/tabi/commit/50b8d5fc7b022ace56ccf81dcf8766aa4963d6b8)) by [@welpo](https://github.com/welpo)
- Update year to current year ([abfe2f9](https://github.com/welpo/tabi/commit/abfe2f9dc88ce6ec05f63feacd3998db2e9696f6)) by [@welpo](https://github.com/welpo)
- Prevent malformed CSP header ([54ae781](https://github.com/welpo/tabi/commit/54ae7813529008822e4938724ecab83679db3d95)) by [@welpo](https://github.com/welpo)
- Minor typo ([799b31d](https://github.com/welpo/tabi/commit/799b31d403a45abafddd270c471b8898972c2f06)) by [@welpo](https://github.com/welpo)
- Rename sun icon reference ([2f4d065](https://github.com/welpo/tabi/commit/2f4d0658d8908785c7627362e5b2a7eaa96e48e2)) by [@welpo](https://github.com/welpo)
- Set main image path relative to base_url ([f555d34](https://github.com/welpo/tabi/commit/f555d3420778db4c27a56c89520dfd1d421b0d58)) by [@welpo](https://github.com/welpo)
- Override font-size for home subtitle <p> ([2732f49](https://github.com/welpo/tabi/commit/2732f494cfdf3314b45153f621acff6fdb4042a1)) by [@welpo](https://github.com/welpo)
- Set remote Zola url ([1845649](https://github.com/welpo/tabi/commit/1845649613482823dbf9a597452a073425aed128)) by [@welpo](https://github.com/welpo)
- Use serif as fallback ([c65eea1](https://github.com/welpo/tabi/commit/c65eea156ce391942daa61188b2f9393013af40e)) by [@welpo](https://github.com/welpo)
- Close div class"tags-item" ([5c48acb](https://github.com/welpo/tabi/commit/5c48acba582158662c13760744e8e6a4d81646dd)) by [@welpo](https://github.com/welpo)
- Atom feed alt description ([d41c9b5](https://github.com/welpo/tabi/commit/d41c9b5c86eafe34f2d3befb4bfd81a383e1ee66)) by [@welpo](https://github.com/welpo)
- Remove double bottom-boder/div on Archive ([6e47145](https://github.com/welpo/tabi/commit/6e471450c6fa5608d40e870ccb08fa4a9697c9b9)) by [@welpo](https://github.com/welpo)
- Add end-of-file newline ([099f094](https://github.com/welpo/tabi/commit/099f094f317b84b5748a9a83796fabfb29dafc7f)) by [@welpo](https://github.com/welpo)
- _archive import typo ([55d928a](https://github.com/welpo/tabi/commit/55d928a3d59279eb5c54c861c293de3714342c48)) by [@serginogal](https://github.com/serginogal)
- Capitalise Archive title ([31f70ff](https://github.com/welpo/tabi/commit/31f70fffafd0a0adc0cae41368bbfbd25fb27880)) by [@welpo](https://github.com/welpo)
- Update theme screenshot in /projects ([32ca1d3](https://github.com/welpo/tabi/commit/32ca1d3e9e8823ec05a629addbdcead5b54e2a18)) by [@welpo](https://github.com/welpo)
- Set aspect-ratio on banner-home-ig ([c6c8379](https://github.com/welpo/tabi/commit/c6c83797bff349ee0d12972264b98de0f48ea1f8)) by [@welpo](https://github.com/welpo)
- Make navbar width and margin same as content ([1c1e124](https://github.com/welpo/tabi/commit/1c1e124115a1188ee9669451e5400d2873eee558)) by [@serginogal](https://github.com/serginogal)
- Use Sentence case in Projects title ([cc93f9f](https://github.com/welpo/tabi/commit/cc93f9fb7fe44bb4fecb860669e368da63e57efd)) by [@welpo](https://github.com/welpo)
- Add end-of-file newline ([2cef2e5](https://github.com/welpo/tabi/commit/2cef2e5502c871d5bafde2296882a2de96bc8ca6)) by [@welpo](https://github.com/welpo)
- Add end-of-file newline ([095b9d0](https://github.com/welpo/tabi/commit/095b9d0d07603ec0c9fad09d9f0293f75bf11cba)) by [@welpo](https://github.com/welpo)
- Remove duplicate .bloglist-title definition ([53d28ad](https://github.com/welpo/tabi/commit/53d28ad522d15e9446ca331715e6418501f8423b)) by [@welpo](https://github.com/welpo)
- Consistent date format & remove invalid <time> tags ([1242b90](https://github.com/welpo/tabi/commit/1242b909a28250459b6f89d4670454ce934b0b24)) by [@welpo](https://github.com/welpo)
- Remove duplicated meta description ([4cef13a](https://github.com/welpo/tabi/commit/4cef13a7dd473e91a6875a0037b3e282f5460571)) by [@welpo](https://github.com/welpo)
- Remove space in atom url ([3f4259d](https://github.com/welpo/tabi/commit/3f4259d3f4669de110dea2f5b5d42b8341e72b57)) by [@welpo](https://github.com/welpo)
- Set consistent padding between nav and main content ([6a4620a](https://github.com/welpo/tabi/commit/6a4620a33b1c468e4e0bbbe7fc4eca140decdc62)) by [@welpo](https://github.com/welpo)
- Improve responsiveness of home banner ([1f11e84](https://github.com/welpo/tabi/commit/1f11e8480ef33427f5e3f74a8660a584817fa695)) by [@welpo](https://github.com/welpo)
- Ensure text remains visible during webfont load ([4d57e09](https://github.com/welpo/tabi/commit/4d57e097d1b84ad5099fd9cdf39f905458a67d17)) by [@welpo](https://github.com/welpo)
- Working live url ([898fcc8](https://github.com/welpo/tabi/commit/898fcc8975fd63e9407180460c527e628fbc3ee0)) by [@welpo](https://github.com/welpo)
- Alt text for moon/sun icons (theme switcher) ([4edbcf0](https://github.com/welpo/tabi/commit/4edbcf08b3cc6869aed6b1fcea5b979ca1473dda)) by [@welpo](https://github.com/welpo)
- Trailing space in front of nav-links ([dcaa705](https://github.com/welpo/tabi/commit/dcaa705b5636dc17d6aa28edde6c3c5ac4a2e720)) by [@serginogal](https://github.com/serginogal)
- Nav-links hover style ([b044e30](https://github.com/welpo/tabi/commit/b044e30b1ae907b7f6283dde51834bd52e8e6f4a)) by [@serginogal](https://github.com/serginogal)
- Syntax highlighting ([64ed828](https://github.com/welpo/tabi/commit/64ed8287ff89ede1ff437a149cf5230a79a2b26e)) by [@serginogal](https://github.com/serginogal)

### 💄 Styling

- *(404)* Split error statement from solution ([#213](https://github.com/welpo/tabi/issues/213)) by [@ZzMzaw](https://github.com/ZzMzaw)
- *(code blocks)* Harmonise highlight colour ([327545f](https://github.com/welpo/tabi/commit/327545f2d53899673d2446e4ee3bec370e7e584a)) by [@welpo](https://github.com/welpo)
- *(code blocks)* Change syntax highlighting theme & text size ([#131](https://github.com/welpo/tabi/issues/131)) by [@welpo](https://github.com/welpo)
- *(code tags)* Set border radius to inline code ([0a61bd3](https://github.com/welpo/tabi/commit/0a61bd340597b93a5ce26ed6852ca17e9fa99f06)) by [@welpo](https://github.com/welpo)
- *(codeblocks)* Unhide scrollbars ([ce7ac7c](https://github.com/welpo/tabi/commit/ce7ac7cf2c540d61a683c78c12427bc32fc10402)) by [@welpo](https://github.com/welpo)
- *(favicon)* Reduce emoji size for compatibility ([08ef628](https://github.com/welpo/tabi/commit/08ef628abe9ab21b58811cc74364bc088ec4d762)) by [@welpo](https://github.com/welpo)
- *(footer)* Set paragraph margin to 0 ([c7bd9b3](https://github.com/welpo/tabi/commit/c7bd9b36ce6e8db1f23eee4ce50b03090c09a0cd)) by [@welpo](https://github.com/welpo)
- *(isso)* Align buttons and input & cleanup ([9f74868](https://github.com/welpo/tabi/commit/9f74868c729bbd9430ce8b0e830159de31bb7ff2)) by [@welpo](https://github.com/welpo)
- *(isso)* Clean isso styles & use CSS variables ([85fe38f](https://github.com/welpo/tabi/commit/85fe38f8154e635f33fcc0f4e7d7ba5f847695e0)) by [@welpo](https://github.com/welpo)
- *(language-switcher)* Update icon to be lighter ([#173](https://github.com/welpo/tabi/issues/173)) by [@Jieiku](https://github.com/Jieiku) and [@welpo](https://github.com/welpo)
- *(meta)* Add "…" when using summary with `<!-- more -->` ([0c87f65](https://github.com/welpo/tabi/commit/0c87f6513bca41acba6e3cd5c55ab31e8a30ec28)) by [@welpo](https://github.com/welpo)
- *(projects)* Add border-radius and cleaner shadow ([e78451d](https://github.com/welpo/tabi/commit/e78451dbba410323ad2ee6b070bb269828fcc4fc)) by [@welpo](https://github.com/welpo)
- *(projects)* Cleaner shadow ([8b091ba](https://github.com/welpo/tabi/commit/8b091ba7e9d9d30347b4ce98adf626154f9c4771)) by [@welpo](https://github.com/welpo)
- *(quick-navigation)* Reduce max-height for ToC ([718f477](https://github.com/welpo/tabi/commit/718f477949e20204cb1bc0158f4ebd2c6c38a179)) by [@welpo](https://github.com/welpo)
- *(sans-serif)* Slightly increase bold weight ([355162e](https://github.com/welpo/tabi/commit/355162ebe1d470373bcc40ea0f18c00cfdfb52d8)) by [@welpo](https://github.com/welpo)
- Hide navigation buttons on print view ([e20e1c4](https://github.com/welpo/tabi/commit/e20e1c467cf90fd4acf71736df34c8181f2a7ff5)) by [@welpo](https://github.com/welpo)
- Fix whitespace issues ([5458b1c](https://github.com/welpo/tabi/commit/5458b1c533e6a2c66537c439c8bdd0319b8a7352)) by [@welpo](https://github.com/welpo)
- Reduce bold text font weight on sans-serif ([bcc3f83](https://github.com/welpo/tabi/commit/bcc3f83d858bda53b95c53393de0339fb527c94c)) by [@welpo](https://github.com/welpo)
- Add "…" when using summary with `<!-- more -->` ([e72a8da](https://github.com/welpo/tabi/commit/e72a8da596ad7f44cee59141dc9214736a165bb7)) by [@welpo](https://github.com/welpo)
- Use divider-color for <hr> & remove border-color ([1adf242](https://github.com/welpo/tabi/commit/1adf2423f30cf9fdcf3f3da354623d8ff7b0d662)) by [@welpo](https://github.com/welpo)
- Stylise scrollbar based on site's color scheme ([1be3fa8](https://github.com/welpo/tabi/commit/1be3fa886cb0bdbe2d8f893b16e8b3542fe8bd4b)) by [@welpo](https://github.com/welpo)
- Standardise posts' summary & description ([f03a9b3](https://github.com/welpo/tabi/commit/f03a9b3c4f734ac67f0356c89ac49ef121a55d1a)) by [@welpo](https://github.com/welpo)
- Set transparent bg for code in table headers ([a6046cd](https://github.com/welpo/tabi/commit/a6046cd9d7b2ee72dd91064d9854e7f903d1b197)) by [@welpo](https://github.com/welpo)
- Adjust font styles for <details> and <summary> ([275950f](https://github.com/welpo/tabi/commit/275950f97db8809fa37cda424b3aff4d80971073)) by [@welpo](https://github.com/welpo)
- Keep top/bottom element's margin in `full-width` ([2ebf72c](https://github.com/welpo/tabi/commit/2ebf72c83f62a391bc42ac4ff7796bae74b06a55)) by [@welpo](https://github.com/welpo)
- Retain element's spacing within `full-width` ([b1b98eb](https://github.com/welpo/tabi/commit/b1b98eb2b13ed2334bfd975b06b6f07f36796bbf)) by [@welpo](https://github.com/welpo)
- Reset margin & padding for children of `.full-width` ([4b38d53](https://github.com/welpo/tabi/commit/4b38d536933c288fcfab2003ff555d679f508b7a)) by [@welpo](https://github.com/welpo)
- Use theme variable for table borders ([fffaece](https://github.com/welpo/tabi/commit/fffaece88497c84b989618ca0d1329edb8333e8f)) by [@welpo](https://github.com/welpo)
- Remove dark primary colour variable ([c53ecdc](https://github.com/welpo/tabi/commit/c53ecdc472f6fdeba7c920a0d46ac054f190bcd0)) by [@welpo](https://github.com/welpo)
- Redesign block quotes ([e3ee95d](https://github.com/welpo/tabi/commit/e3ee95d71872cf23f0cf9c44b42f473c04a9673a)) by [@welpo](https://github.com/welpo)
- Improve footnotes and `<hr>` styling ([a1ceb74](https://github.com/welpo/tabi/commit/a1ceb747857365f5785a079efdf3d5f0c72a3c98)) by [@welpo](https://github.com/welpo)
- Center all table text ([85ccc08](https://github.com/welpo/tabi/commit/85ccc081e4865487fa1f13459a991cb46f0fb017)) by [@welpo](https://github.com/welpo)
- Remove figure & img max height ([3dc3e49](https://github.com/welpo/tabi/commit/3dc3e491319cfc9f08bed691e6b744a7a597b342)) by [@welpo](https://github.com/welpo)
- Increase body left/right margins ([b76f9bb](https://github.com/welpo/tabi/commit/b76f9bbf44228c046e0221580033a8c388fa4a07)) by [@welpo](https://github.com/welpo)
- Hide horizontal scrollbar in codeblocks ([d7b0191](https://github.com/welpo/tabi/commit/d7b01914f843b5904b06572d7921f8ebaebd77d9)) by [@welpo](https://github.com/welpo)
- Darken codeblock highlight colour ([fcc2caf](https://github.com/welpo/tabi/commit/fcc2cafcdcfd5eb14df2208829c33404feb9ae7a)) by [@welpo](https://github.com/welpo)
- Reduce bold font-weight ([f5603ac](https://github.com/welpo/tabi/commit/f5603acbdb8968126deb3818af2cef018ed79b75)) by [@welpo](https://github.com/welpo)
- Add codeblock background colours ([8415535](https://github.com/welpo/tabi/commit/8415535e1337a00c9b23e524ade3734d94fc0965)) by [@welpo](https://github.com/welpo)
- Round tables borders ([7c3463c](https://github.com/welpo/tabi/commit/7c3463c0fe1539a56202f1b36da951156a931552)) by [@welpo](https://github.com/welpo)
- Redesign code block header ([700037a](https://github.com/welpo/tabi/commit/700037afe5e3d7e74faef4776ef158f3af34fc02)) by [@welpo](https://github.com/welpo)
- Increase spacing in archive ([d1e51f5](https://github.com/welpo/tabi/commit/d1e51f5866086426890c687c6135a3bf1d7bbcde)) by [@welpo](https://github.com/welpo)
- Remove newlines around summary ([67173f2](https://github.com/welpo/tabi/commit/67173f27cdfe440126a47a4fced93e01f92d53c3)) by [@welpo](https://github.com/welpo)
- Smaller title and "Recent Posts" text ([eb8f630](https://github.com/welpo/tabi/commit/eb8f630fde1fecc04c067832283f7a16c945184a)) by [@welpo](https://github.com/welpo)
- Add styling to infobox ([0494a54](https://github.com/welpo/tabi/commit/0494a54f574b7983d4fe4bef073f730bb899787e)) by [@welpo](https://github.com/welpo)
- Add title suffix & reduce RSS icon size ([fc591f5](https://github.com/welpo/tabi/commit/fc591f549c9f5ebbee20f9c6273da27bed603fd2)) by [@welpo](https://github.com/welpo)
- Add `padding-top` class ([36930dc](https://github.com/welpo/tabi/commit/36930dc8174966e2dd718f039307f3412454d486)) by [@welpo](https://github.com/welpo)
- Rename "atom/rss feed" to "feed" ([0b02e72](https://github.com/welpo/tabi/commit/0b02e727e0ed21c1e1a8ac9ee45229a78339d361)) by [@welpo](https://github.com/welpo)
- Standarise margin in projects and archive ([da38822](https://github.com/welpo/tabi/commit/da3882294c6b6a04e8d2f8f91c6412ead4496d3d)) by [@welpo](https://github.com/welpo)
- Set custom header anchor ([5bdb804](https://github.com/welpo/tabi/commit/5bdb8045a6a517cd1ce5be945d555faea0b84922)) by [@welpo](https://github.com/welpo)
- Add dash to toggle identifier ([c47198f](https://github.com/welpo/tabi/commit/c47198facf72abf7c2a1b84ac4a9a8adaa4c1272)) by [@welpo](https://github.com/welpo)
- Widen article body; less reading saccades ([cfef1f6](https://github.com/welpo/tabi/commit/cfef1f65d79c41ba4be26cbd8683be53c874ff6f)) by [@welpo](https://github.com/welpo)
- Center wrapped menu items ([5d91a0d](https://github.com/welpo/tabi/commit/5d91a0dcacd0eca6f7ce6d24e421f9c40b85bdf2)) by [@welpo](https://github.com/welpo)
- Widen article body; less reading saccades ([00c7d15](https://github.com/welpo/tabi/commit/00c7d153c61b18c6d3a11b6f8958464b44747e54)) by [@welpo](https://github.com/welpo)
- Round down code font-size ([4af487e](https://github.com/welpo/tabi/commit/4af487ecedb71f98cb0ec1e2b38c11def7029973)) by [@welpo](https://github.com/welpo)
- Standarise font rendering across browsers ([67aad3e](https://github.com/welpo/tabi/commit/67aad3ef74472b40f878f7475a782e411cb75fdf)) by [@welpo](https://github.com/welpo)
- Reduce header-content margin in mobile ([3275e8a](https://github.com/welpo/tabi/commit/3275e8a5092cfd46b424f6e071c4d5412d66ff34)) by [@welpo](https://github.com/welpo)
- Increase margin between posts and year ([69989cc](https://github.com/welpo/tabi/commit/69989ccc94e656ee78bfdabf88995408b5f2c765)) by [@welpo](https://github.com/welpo)
- Move padding from post-time to listing-item ([5907091](https://github.com/welpo/tabi/commit/590709189331d264cd5fd470500723c5ab2b3473)) by [@welpo](https://github.com/welpo)
- Restore meta font in article to sans-serif ([25d3a4d](https://github.com/welpo/tabi/commit/25d3a4d109a698884ac1c6da081f852f7293fda2)) by [@welpo](https://github.com/welpo)
- Improve mobile date display and title spacing ([6a5670d](https://github.com/welpo/tabi/commit/6a5670d5a0b86c339a68f6bc744769c96e5081b0)) by [@welpo](https://github.com/welpo)
- Standarise font rendering across browsers ([ea00c9b](https://github.com/welpo/tabi/commit/ea00c9b9df6d8b7546900585e65acd57d955b842)) by [@welpo](https://github.com/welpo)
- Prevent header anchor selection ([1499704](https://github.com/welpo/tabi/commit/14997045d801d89706c1c76345d963768fcdb24b)) by [@welpo](https://github.com/welpo)
- Update project images ([18cab7d](https://github.com/welpo/tabi/commit/18cab7d37c49e9e4fa67f73210e4055aa8a2feca)) by [@welpo](https://github.com/welpo)
- Update project images ([77dc2be](https://github.com/welpo/tabi/commit/77dc2be14bf8cd05079bc357b6f255ea2f7fcf31)) by [@welpo](https://github.com/welpo)
- Greater resolution ([698d4eb](https://github.com/welpo/tabi/commit/698d4ebf7430e766119022ecad92851fe9f933a6)) by [@welpo](https://github.com/welpo)
- Add link to project images ([369fa97](https://github.com/welpo/tabi/commit/369fa9700abcd24c2a644be471b8ab112e66f3e7)) by [@welpo](https://github.com/welpo)
- Use shadow instead of border for cards ([99bb932](https://github.com/welpo/tabi/commit/99bb93219d7b28dc14c1e01be8695dbf1ead5446)) by [@welpo](https://github.com/welpo)
- Set a minimum value for paragraph spacing ([a89fc02](https://github.com/welpo/tabi/commit/a89fc02a96e911135f4e4b60c2e8bd252c317a8c)) by [@welpo](https://github.com/welpo)
- Use theme's primary colour for table headers ([1c07128](https://github.com/welpo/tabi/commit/1c07128aeb30695239611ed5b11695eb84a000b9)) by [@welpo](https://github.com/welpo)
- Narrower article content for blog posts ([a39306f](https://github.com/welpo/tabi/commit/a39306f6ef98ae8b1c3358535c6fd845ec02d6db)) by [@welpo](https://github.com/welpo)
- Change default long date format ([61e288d](https://github.com/welpo/tabi/commit/61e288d8d5df2d4c87dbf239af2dddc87e9e1dcf)) by [@welpo](https://github.com/welpo)
- Reduce text/background contrast ([15f2629](https://github.com/welpo/tabi/commit/15f26293b54757cd06f619afba8dc9cbbea2e835)) by [@welpo](https://github.com/welpo)
- Darken background for inline code (dark theme) ([7fbb4d7](https://github.com/welpo/tabi/commit/7fbb4d7acdf63e6e3535ced090441d54e6a15058)) by [@welpo](https://github.com/welpo)
- Update anchor links by [@welpo](https://github.com/welpo)
- Hide anchor links on small screens ([15c1280](https://github.com/welpo/tabi/commit/15c12807063d84be34bc28bd10be00421356fa69)) by [@welpo](https://github.com/welpo)
- Promise I will never go blonde like Kanye ([38a38fa](https://github.com/welpo/tabi/commit/38a38fa6063ac92a559d8e36d138deae165d5e8b)) by [@welpo](https://github.com/welpo)
- Increase content bottom margin in small screens ([845a2f1](https://github.com/welpo/tabi/commit/845a2f151a03424c210ed864bd19c8c31e39192c)) by [@welpo](https://github.com/welpo)
- Smaller socials; add Zola & tabi mention by [@welpo](https://github.com/welpo)
- Smaller socials; add Zola & tabi mention ([b7c8975](https://github.com/welpo/tabi/commit/b7c89753ecfef9e611164148b8a297a364214ade)) by [@welpo](https://github.com/welpo)
- Remove round borders on tables for consistency ([0f07a6e](https://github.com/welpo/tabi/commit/0f07a6e98b4b3fc7c0561f67c27cee3871d9346f)) by [@welpo](https://github.com/welpo)
- Fix invisible url on hover in projects ([77298d8](https://github.com/welpo/tabi/commit/77298d82b08f3567391e9d02682e4750aea6f843)) by [@welpo](https://github.com/welpo)
- Use day-month format ([28d5704](https://github.com/welpo/tabi/commit/28d5704afd71c2e58df2cac5a303aa1c3923970b)) by [@welpo](https://github.com/welpo)
- Increase contrast for link hover ([e51f531](https://github.com/welpo/tabi/commit/e51f5318d691182b1f7a626683d18f841d96b310)) by [@welpo](https://github.com/welpo)
- Decrease margin between date and post title ([283f3d3](https://github.com/welpo/tabi/commit/283f3d39344b3b02d35df55739a41000984e8fdb)) by [@welpo](https://github.com/welpo)
- Wrap post description in `<p>` ([dc64e25](https://github.com/welpo/tabi/commit/dc64e2589dc4c7fb4eaad4fb8eca43e49209c224)) by [@welpo](https://github.com/welpo)
- Major redesign by [@welpo](https://github.com/welpo)
- Increase margin between anchor and header ([1f4f3a9](https://github.com/welpo/tabi/commit/1f4f3a906fc4fe4de3a53a4be0870cfeaa2d1e2f)) by [@welpo](https://github.com/welpo)
- Redesign post listing and other minor changes ([cd2ab35](https://github.com/welpo/tabi/commit/cd2ab356bef6817122aa6fd390e1735106a99458)) by [@welpo](https://github.com/welpo)
- Remove transitions ([cec746c](https://github.com/welpo/tabi/commit/cec746c1ce58fd92275103534287e81648f1b9c3)) by [@welpo](https://github.com/welpo)
- Redesign tag pages ([8ac1894](https://github.com/welpo/tabi/commit/8ac1894a66c52e370900b2d3f1a7de43207a38de)) by [@welpo](https://github.com/welpo)
- Increase date opacity ([f5834a2](https://github.com/welpo/tabi/commit/f5834a2e39f8f18a90ac6fe99245b34fe4bad0d5)) by [@welpo](https://github.com/welpo)
- Remove "home" from navigation ([80ec217](https://github.com/welpo/tabi/commit/80ec217607efeaebe892ae53286afeb8c0fdd8ae)) by [@welpo](https://github.com/welpo)
- List tags redesign by [@welpo](https://github.com/welpo)
- Use cards/boxes for tag list ([b33a942](https://github.com/welpo/tabi/commit/b33a942766ce80e15f0a0b457d5562fb084563f2)) by [@welpo](https://github.com/welpo)
- List all posts per tag ([a761fd0](https://github.com/welpo/tabi/commit/a761fd00eebf03eaefe5647701208648e2973aed)) by [@welpo](https://github.com/welpo)
- Set style for figure & figure captions ([1496f0c](https://github.com/welpo/tabi/commit/1496f0cf73c9a7fcdf13bb752101278dd3660658)) by [@welpo](https://github.com/welpo)
- Increase iframe margins ([c2d9107](https://github.com/welpo/tabi/commit/c2d9107cd39c19be544b76c272e7c1e7c9bc581c)) by [@welpo](https://github.com/welpo)
- Center and enlarge iframes (embeds) ([372d696](https://github.com/welpo/tabi/commit/372d696eec07d9171a116a85d5e46ec3c7218a05)) by [@welpo](https://github.com/welpo)
- Update footnote styling ([f4cd6e6](https://github.com/welpo/tabi/commit/f4cd6e6a92eb4b7b5076fd2de4694316d1d328e2)) by [@welpo](https://github.com/welpo)
- Resize headers ([e4c6705](https://github.com/welpo/tabi/commit/e4c670584388c1d33e250039abafad79c09c43fe)) by [@welpo](https://github.com/welpo)
- Increase margins before content & after ToC ([83b7bb9](https://github.com/welpo/tabi/commit/83b7bb9d3a3afefab47dc5055a4167c0133f1b1d)) by [@welpo](https://github.com/welpo)
- Reduce font size for meta in cards ([0ecc656](https://github.com/welpo/tabi/commit/0ecc656b91fd3f7ce55fbaa13f65aaf610117b32)) by [@welpo](https://github.com/welpo)
- Reduce font-size and increase line-height in article-title ([367d6a8](https://github.com/welpo/tabi/commit/367d6a8be4b3b37a7c3a2f5b733417a55af6ec01)) by [@welpo](https://github.com/welpo)
- Revert background back to pure white ([0e4d274](https://github.com/welpo/tabi/commit/0e4d274de9300a104de3cb4c0dfbab31c1b206a0)) by [@welpo](https://github.com/welpo)
- Change colourscheme. improve cohesion and accesibility ([b7da112](https://github.com/welpo/tabi/commit/b7da11222e2899c85e3def883ddec58ec8b479f9)) by [@welpo](https://github.com/welpo)
- Mention all table colours change, not just header ([2b861ea](https://github.com/welpo/tabi/commit/2b861ea94068a553ebd849b5fd407b5ccefb4464)) by [@welpo](https://github.com/welpo)
- Showcase tables & invertable images ([394479d](https://github.com/welpo/tabi/commit/394479d777bcf0c03052521fbe4c9fafe437cf6c)) by [@welpo](https://github.com/welpo)
- Center tables; colour headers; round borders ([5b45351](https://github.com/welpo/tabi/commit/5b4535197014bd3dc87eb6f59ce88b963efed037)) by [@welpo](https://github.com/welpo)
- Set tab to 4 spaces; remove newlines ([f2cd044](https://github.com/welpo/tabi/commit/f2cd0440962d97d4c6f27cd37d50200627e81d42)) by [@welpo](https://github.com/welpo)
- Use Cascadia Code as code font ([9db00d1](https://github.com/welpo/tabi/commit/9db00d1f9d382c5c6d2f5383ab8c145d3b522696)) by [@welpo](https://github.com/welpo)
- Move quote author to quote block ([9f41220](https://github.com/welpo/tabi/commit/9f412205b38de9cf42cc6a1fb3baea8d3de9b2ae)) by [@welpo](https://github.com/welpo)
- Default light mode ([723b3b6](https://github.com/welpo/tabi/commit/723b3b61395ec387b422475334f98ae79e2f1474)) by [@welpo](https://github.com/welpo)
- Move main image to static path ([6783ff6](https://github.com/welpo/tabi/commit/6783ff6e49157b7149f54d8d18b962c2ecdd5ee9)) by [@welpo](https://github.com/welpo)
- Remove border from images ([2b8a053](https://github.com/welpo/tabi/commit/2b8a053f510f36958edaf8a39d9d8dde51274463)) by [@welpo](https://github.com/welpo)
- Default light mode ([722d493](https://github.com/welpo/tabi/commit/722d493a9a0c47b9c791e33226c8bf1d3a354f8d)) by [@welpo](https://github.com/welpo)
- Increase contrast and saturation ([fd7a9da](https://github.com/welpo/tabi/commit/fd7a9da61cb10827be3d0421987e2be338f0e600)) by [@welpo](https://github.com/welpo)
- Smaller home image; different circle crop ([c71065d](https://github.com/welpo/tabi/commit/c71065d75691a832cd9a60b8872513b1f1e61715)) by [@welpo](https://github.com/welpo)
- Set local main image; no border-radius ([e2edab5](https://github.com/welpo/tabi/commit/e2edab51b798b7100ed46511217f7aa27d5e7a45)) by [@welpo](https://github.com/welpo)
- Reduce headers' size ([978af11](https://github.com/welpo/tabi/commit/978af11495face1127dc30946989ecac78257207)) by [@welpo](https://github.com/welpo)
- Change posts' dates to show off Archive ([fcc7a31](https://github.com/welpo/tabi/commit/fcc7a3127030ebcab12524647886530aacf3dbac)) by [@welpo](https://github.com/welpo)
- Larger section titles ([4fe8643](https://github.com/welpo/tabi/commit/4fe8643a1a54837fd0aff85f0092ea6b4c1bd430)) by [@welpo](https://github.com/welpo)
- Add styles for archive screen ([19caf3f](https://github.com/welpo/tabi/commit/19caf3fab117121e6d7e168cb4f189e44ae1f038)) by [@serginogal](https://github.com/serginogal)
- Change switcher margin and width/height to rem ([9637e05](https://github.com/welpo/tabi/commit/9637e053c3779db7f24ea66d2738892bdd00d012)) by [@welpo](https://github.com/welpo)
- Increase padding between navs ([973e0f7](https://github.com/welpo/tabi/commit/973e0f76f8ae0bb23a40e8099f72efd1e1c16115)) by [@welpo](https://github.com/welpo)
- Set consistent underline in headers ([fa781db](https://github.com/welpo/tabi/commit/fa781db0e4f10d05117f35218b74d36b4605187f)) by [@welpo](https://github.com/welpo)
- Set equal padding on social icons ([b8e372c](https://github.com/welpo/tabi/commit/b8e372c733a1052f41b90c9a115ba5bc44f3b8b8)) by [@welpo](https://github.com/welpo)
- Increase padding between navs ([fcb8db4](https://github.com/welpo/tabi/commit/fcb8db43a60fd485927211e7c747186db5a7324d)) by [@welpo](https://github.com/welpo)
- Change various font sizes and date format ([06dae7a](https://github.com/welpo/tabi/commit/06dae7a71172be63fe93a65319827e9e687c6a63)) by [@welpo](https://github.com/welpo)
- Update screenshots and minor changes ([a3ff46b](https://github.com/welpo/tabi/commit/a3ff46be97d2792cfddb826911c97257ec7f3789)) by [@welpo](https://github.com/welpo)

### 📝 Documentation

- *(README)* Add 'Sites Using tabi' section ([0d34b98](https://github.com/welpo/tabi/commit/0d34b98e1183c1317f289cf9d976e20a5e895151)) by [@welpo](https://github.com/welpo)
- *(README)* Add link to Table of Contents documentation ([#121](https://github.com/welpo/tabi/issues/121)) by [@stevenroose](https://github.com/stevenroose)
- *(ToC)* Fix broken code block ([3f2e456](https://github.com/welpo/tabi/commit/3f2e45601aa4154f5d45119017b4f53cec3e0c98)) by [@welpo](https://github.com/welpo)
- *(config)* Clarify default short date format ([f57f313](https://github.com/welpo/tabi/commit/f57f3138c26a8187447f9bcbe9af6aa0861eb8e1)) by [@welpo](https://github.com/welpo)
- *(faq-languages)* Improve phrasing/translation ([793b063](https://github.com/welpo/tabi/commit/793b063c773addae95617e4233d5287d8ec2337c)) by [@welpo](https://github.com/welpo)
- *(i18n)* Fix language switcher description ([a7d4120](https://github.com/welpo/tabi/commit/a7d41203393817946d721f86d2eae4ee47e1c8b8)) by [@welpo](https://github.com/welpo)
- *(i18n)* Mention IETF BCP 47 codes ([78fd8b8](https://github.com/welpo/tabi/commit/78fd8b8f0e1e643bc956956b04d6c2dc1b857422)) by [@welpo](https://github.com/welpo)
- *(pre-commit)* Remove redundancy in minified error ([2833d9f](https://github.com/welpo/tabi/commit/2833d9f8c045205cf4f57499f132675433eb28d0)) by [@welpo](https://github.com/welpo)
- *(privacy)* Use GoatCounter sessions ([741a7e7](https://github.com/welpo/tabi/commit/741a7e7c6f98d2610ab8d58da4ff6c724cfd547a)) by [@welpo](https://github.com/welpo)
- *(projects)* Remove bullet points from tabi features ([3590468](https://github.com/welpo/tabi/commit/35904683e16f303a1c3c5523688957e433b8a88e)) by [@welpo](https://github.com/welpo)
- *(shortcodes)* Link commit and PR for relative image paths ([c2664c8](https://github.com/welpo/tabi/commit/c2664c85cd788791f1a42aab1e0a9e2cb892225c)) by [@welpo](https://github.com/welpo)
- Add guide to all of tabi's features ([#169](https://github.com/welpo/tabi/issues/169)) by [@welpo](https://github.com/welpo)
- Update link to multilanguage lines in config ([0cdb83e](https://github.com/welpo/tabi/commit/0cdb83e3b2fa20a498cf52040a72d50bc03b80e9)) by [@welpo](https://github.com/welpo)
- Update link to multilanguage lines in config ([a61911d](https://github.com/welpo/tabi/commit/a61911d7df1daf65da4510479ad64d41f7180cbb)) by [@welpo](https://github.com/welpo)
- Add ToC and quick navigation buttons ([a47a8be](https://github.com/welpo/tabi/commit/a47a8be01169914f7467f100c6c4136fd022e8eb)) by [@welpo](https://github.com/welpo)
- Clarify the 2 possible paths for custom skins ([41009a5](https://github.com/welpo/tabi/commit/41009a50a1f45a5ad16b044fec4e0a59393650d9)) by [@welpo](https://github.com/welpo)
- Add link to skins showcase/documentation ([6b0cc11](https://github.com/welpo/tabi/commit/6b0cc11da4a684f21211f5e19b7fdae19aae76a1)) by [@welpo](https://github.com/welpo)
- Fix skins docs link ([e210652](https://github.com/welpo/tabi/commit/e210652ac2ddad173cb3e51d4423da808bd6dc50)) by [@welpo](https://github.com/welpo)
- Improve Code tags example ([521a05b](https://github.com/welpo/tabi/commit/521a05b97f6a2c2f3dfacdd63b0a1790cfbb558e)) by [@welpo](https://github.com/welpo)
- Add Isso comments mention ([6b00aae](https://github.com/welpo/tabi/commit/6b00aae20ecc1b5359ee8ed283a83604e3a4abcd)) by [@welpo](https://github.com/welpo)
- Update [extra] settings ([da44e79](https://github.com/welpo/tabi/commit/da44e795d698899b7d577f89f3c9e3ad0f7cc4e6)) by [@welpo](https://github.com/welpo)
- Update link to multilanguage lines in config ([ae47f79](https://github.com/welpo/tabi/commit/ae47f79d9d34d744600d4abafbc073fb44021d49)) by [@welpo](https://github.com/welpo)
- Suggest editing language feed stylesheet ([588defd](https://github.com/welpo/tabi/commit/588defd7f221e8914ea8c57a66ef7509200302fa)) by [@welpo](https://github.com/welpo)
- Mention support for Isso comments ([a201c05](https://github.com/welpo/tabi/commit/a201c05823d1637e68ede5561ce9e468a2317fe7)) by [@welpo](https://github.com/welpo)
- Add code type to codeblock ([b6f7f80](https://github.com/welpo/tabi/commit/b6f7f802b49734551d2f9afad8274debde56d1d0)) by [@welpo](https://github.com/welpo)
- Add Hyvor Talk comments mention ([f859113](https://github.com/welpo/tabi/commit/f859113c815ada8e33b62c52d17ecdac9bd4ea73)) by [@welpo](https://github.com/welpo)
- Support Hyvor Talk comments ([3dcc462](https://github.com/welpo/tabi/commit/3dcc462056401492d676d3893cfeed68c989f27d)) by [@welpo](https://github.com/welpo)
- Remove `updated` date from examples ([5d99da2](https://github.com/welpo/tabi/commit/5d99da2cd0f20bd78732724026c926e36b509b45)) by [@welpo](https://github.com/welpo)
- Update for Hyvor Talk support ([31fee59](https://github.com/welpo/tabi/commit/31fee59eb21ab1ca4d3806da80c3b36338fbf706)) by [@welpo](https://github.com/welpo)
- Remove first header ([5214dd3](https://github.com/welpo/tabi/commit/5214dd35608e7935a399303aff87f520574b30a9)) by [@welpo](https://github.com/welpo)
- Update link to multilanguage lines in config ([54abe36](https://github.com/welpo/tabi/commit/54abe36d442bc73c3a0e62fc0748570deabec6d7)) by [@welpo](https://github.com/welpo)
- Fix mention of "Load comments" button ([1a74cb4](https://github.com/welpo/tabi/commit/1a74cb4496ffdced2b032c36704a26828748ee65)) by [@welpo](https://github.com/welpo)
- Add code language to bash code blocks ([33cfe77](https://github.com/welpo/tabi/commit/33cfe77344c62f9e7368cfa914da4f8ff53883a3)) by [@welpo](https://github.com/welpo)
- Remove `updated` date from example ([dcbb4c5](https://github.com/welpo/tabi/commit/dcbb4c52907c5fff30ab97841a871d8e3bbbd426)) by [@welpo](https://github.com/welpo)
- Improve KaTeX documentation ([1cd34b5](https://github.com/welpo/tabi/commit/1cd34b528efe8a8a1e0ad6ef1ee92d804aee75a9)) by [@welpo](https://github.com/welpo)
- Set proper `updated` date ([139ca04](https://github.com/welpo/tabi/commit/139ca042f41f8ca96b105ba8e03da56400486895)) by [@welpo](https://github.com/welpo)
- Translate 'Usage' header ([fa5e21f](https://github.com/welpo/tabi/commit/fa5e21feeaf40cd57f5145e2ea2273c378bf3306)) by [@welpo](https://github.com/welpo)
- Mention stylized feed ([bd2b4a3](https://github.com/welpo/tabi/commit/bd2b4a33d65bf17dfe03e6351e1d9de75eb9f8c5)) by [@welpo](https://github.com/welpo)
- Add default author ([f9d8f36](https://github.com/welpo/tabi/commit/f9d8f3668f0a268ea1799f43ee56a6a2176380de)) by [@welpo](https://github.com/welpo)
- Remove atom feed filter in script ([41c44d3](https://github.com/welpo/tabi/commit/41c44d3d842a2c8d9ef5b7b2dd94c831f356ed5b)) by [@welpo](https://github.com/welpo)
- Update URL to multilanguage lines in config ([761a18d](https://github.com/welpo/tabi/commit/761a18da752f29d42e7b75465ce53601bc2b75cf)) by [@welpo](https://github.com/welpo)
- Remove unnecessary date ([8b7f53e](https://github.com/welpo/tabi/commit/8b7f53e3ca3f20ff838a0dce321d4913b6bd43c2)) by [@welpo](https://github.com/welpo)
- Add feature request template ([e1ec7f5](https://github.com/welpo/tabi/commit/e1ec7f54d5e14fb75813745b3067e6de08152235)) by [@welpo](https://github.com/welpo)
- Create bug report issue template ([03cbf3b](https://github.com/welpo/tabi/commit/03cbf3bf0f346065d0c5adafa991d216e3b55809)) by [@welpo](https://github.com/welpo)
- Update URL to multilanguage lines in config ([3a8fa41](https://github.com/welpo/tabi/commit/3a8fa41cfc42a51bcc6a3c6b7bc688ee1814fb24)) by [@welpo](https://github.com/welpo)
- Mention Zola version requirement ([6e9bcf9](https://github.com/welpo/tabi/commit/6e9bcf92046f553f6bebdbf7d9c5291739bb1cb5)) by [@welpo](https://github.com/welpo)
- Update Zola version requirement to 0.17.0 ([a0f4f4a](https://github.com/welpo/tabi/commit/a0f4f4a6420927bb10119baf5327da4c9cf71187)) by [@welpo](https://github.com/welpo)
- Add quotation marks to quotes ([c7a411e](https://github.com/welpo/tabi/commit/c7a411e1572075b63719d3eb81b4c469b2e56b01)) by [@welpo](https://github.com/welpo)
- Add config info for multilingual sites ([397b63c](https://github.com/welpo/tabi/commit/397b63cefab3ffba87b0bf2ae5bf3c9cf641d83e)) by [@welpo](https://github.com/welpo)
- Update screenshots ([56b74ed](https://github.com/welpo/tabi/commit/56b74ed23d1f4395c8245d4c444e53a951dad78b)) by [@welpo](https://github.com/welpo)
- Revert script changes ([f657010](https://github.com/welpo/tabi/commit/f657010be4cdd028e3d17b9967b9b97221e8ef80)) by [@welpo](https://github.com/welpo)
- Include layout features in font subset ([44980f1](https://github.com/welpo/tabi/commit/44980f141883a462bc5a88cf958786f8c56a98ec)) by [@welpo](https://github.com/welpo)
- Rephrase last sentence ([e316dc2](https://github.com/welpo/tabi/commit/e316dc25ab649528be19d3f4b3ef165cbd976a2b)) by [@welpo](https://github.com/welpo)
- Rephrase description ([47caa99](https://github.com/welpo/tabi/commit/47caa99e0c438396e1ef6d5ad5ec9c3664df078a)) by [@welpo](https://github.com/welpo)
- Close codeblock ([3389638](https://github.com/welpo/tabi/commit/3389638b06efc6b534f7ac674764a6c110d38b18)) by [@welpo](https://github.com/welpo)
- Update URL ([60680fa](https://github.com/welpo/tabi/commit/60680fad3741735a75d66c185639ab1c057c6560)) by [@welpo](https://github.com/welpo)
- Update inspiration ([85a32e2](https://github.com/welpo/tabi/commit/85a32e263fa9ec324275c15bbc96398bb88c2fd0)) by [@welpo](https://github.com/welpo)
- Use full URLs for images for Zola theme page ([bc84a1f](https://github.com/welpo/tabi/commit/bc84a1f669d42b161dc07bba3424151cc17347b4)) by [@welpo](https://github.com/welpo)
- Add `data:` to CSP to load local svg ([3b22e6b](https://github.com/welpo/tabi/commit/3b22e6be6c1ff666c767cea0af4b9cd48f353c46)) by [@welpo](https://github.com/welpo)
- Stylise KaTeX ([79f8559](https://github.com/welpo/tabi/commit/79f8559a3aa87794af45a62d9644689c00b94c51)) by [@welpo](https://github.com/welpo)
- Acknowledge abridge's inspiration ([c36b66b](https://github.com/welpo/tabi/commit/c36b66b7d46dc30c2dd77386421a396dd777333c)) by [@welpo](https://github.com/welpo)
- Update theme's description ([89bfdbe](https://github.com/welpo/tabi/commit/89bfdbe6870fc05a5d8b8256d8cfb5a7b9ac8969)) by [@welpo](https://github.com/welpo)
- Update screenshots ([3ad76de](https://github.com/welpo/tabi/commit/3ad76de2fbae694522899cf9226a8f39208e83e6)) by [@welpo](https://github.com/welpo)
- Mention responsive design ([be8ec45](https://github.com/welpo/tabi/commit/be8ec45c359f6029fe1f2360f3c026f57345044d)) by [@welpo](https://github.com/welpo)
- Lowercase 'tabi' ([e422c40](https://github.com/welpo/tabi/commit/e422c405cb7bcf61c148a4b63cd0fd3537e22868)) by [@welpo](https://github.com/welpo)
- Minor changes to installation instructions ([73811bd](https://github.com/welpo/tabi/commit/73811bdb7aa251620850537fc8126d8a483462e9)) by [@welpo](https://github.com/welpo)
- Clarify installation instructions ([538cb07](https://github.com/welpo/tabi/commit/538cb07a5f79c87d3e623b35475cb8ac0d0f7cc9)) by [@welpo](https://github.com/welpo)
- Mention perfect Lighthouse score ([7543f03](https://github.com/welpo/tabi/commit/7543f03e1291a03723c3ac28e71016fbffa32c5e)) by [@welpo](https://github.com/welpo)
- Update `nani` image ([35cea72](https://github.com/welpo/tabi/commit/35cea7222c0fdb504a8fecf0b33c126f12f8b2a9)) by [@welpo](https://github.com/welpo)
- Update projects ([a2ea8c3](https://github.com/welpo/tabi/commit/a2ea8c3f885ddce0bf2facbd8c166e1c21577af8)) by [@welpo](https://github.com/welpo)
- Update description ([b5bc0d4](https://github.com/welpo/tabi/commit/b5bc0d44db80f8afe78bbd135a702933e6a9a0e1)) by [@welpo](https://github.com/welpo)
- Update description, demo URL, author info, and extra ([3ce928a](https://github.com/welpo/tabi/commit/3ce928a067c211a4da9fd36a523dc0613e388984)) by [@welpo](https://github.com/welpo)
- Update screenshot ([d98c0d0](https://github.com/welpo/tabi/commit/d98c0d0bb8bbe8f26e2f35a33569c8babb5f5d59)) by [@welpo](https://github.com/welpo)
- Replace "last lines" to "last directive" ([2a681f0](https://github.com/welpo/tabi/commit/2a681f005f3d62a49c2bda293f7289824ad73e7d)) by [@welpo](https://github.com/welpo)
- Use hierarchical headings ([bfda1df](https://github.com/welpo/tabi/commit/bfda1df9f3b640b61f0f0dfb16216b78effac4d6)) by [@welpo](https://github.com/welpo)
- Update inspiration ([4ac3207](https://github.com/welpo/tabi/commit/4ac32077eb76a9ec65321351271eec52d1eec19f)) by [@welpo](https://github.com/welpo)
- Set consistent paths for imgs ([9b680b0](https://github.com/welpo/tabi/commit/9b680b0da72b2984bff4275d2238196f3fd2cefb)) by [@welpo](https://github.com/welpo)
- Change 'Usage' section styling ([eb60527](https://github.com/welpo/tabi/commit/eb60527bfb250d15b92b300eda86993404d247d2)) by [@welpo](https://github.com/welpo)
- Add closing shortcode tag to references() ([2c4b644](https://github.com/welpo/tabi/commit/2c4b64481ca0ff05cac74b427ed031a6ee36496a)) by [@welpo](https://github.com/welpo)
- Improve punctuation ([611790a](https://github.com/welpo/tabi/commit/611790ab2b2d49bf16ed192168cabb26c9d1a8a2)) by [@welpo](https://github.com/welpo)
- Add Contributing guidelines ([5a2738f](https://github.com/welpo/tabi/commit/5a2738f66529ccb19b27de9c9914efc6a27d9e10)) by [@welpo](https://github.com/welpo)
- Add code of conduct ([5cbc33a](https://github.com/welpo/tabi/commit/5cbc33a83812091fdd3393a365cfe3878e00eb94)) by [@welpo](https://github.com/welpo)
- Replace `test` tag with `showcase` ([69d4985](https://github.com/welpo/tabi/commit/69d4985fc55fbdc37f92d07a71e1823cd107ebd5)) by [@welpo](https://github.com/welpo)
- Fix typos ([73a5638](https://github.com/welpo/tabi/commit/73a563872e8fa94dfb186e459255f4e257249429)) by [@welpo](https://github.com/welpo)
- Use markdown to showcase theme's capabilities ([2f07137](https://github.com/welpo/tabi/commit/2f07137cca2eadd73a4aaf71bd1361c07194923f)) by [@welpo](https://github.com/welpo)
- Add internetVin's blog as inspiration ([e052371](https://github.com/welpo/tabi/commit/e05237186581b8b783dfb34620d53d02f9554754)) by [@welpo](https://github.com/welpo)
- Js size has grown :( ([83e211a](https://github.com/welpo/tabi/commit/83e211a18d058e7a13da8b6a9fde752fcd194b52)) by [@welpo](https://github.com/welpo)
- Change the codeblock example ([f6cd7d3](https://github.com/welpo/tabi/commit/f6cd7d3cf20ae3d2cb72cdd4eb3011ab58720ba8)) by [@welpo](https://github.com/welpo)
- Add license ([1cb6003](https://github.com/welpo/tabi/commit/1cb60032c6d1b6b7ee048e46224c9d187c0b546f)) by [@welpo](https://github.com/welpo)

### ♻️ Refactor

- *(404)* Remove mention of translations for single language sites ([8ecd23b](https://github.com/welpo/tabi/commit/8ecd23b940b3e3079be9c248535b933ea6120030)) by [@welpo](https://github.com/welpo)
- *(HTML)* Remove X-UA-Compatible ([#177](https://github.com/welpo/tabi/issues/177)) by [@donovanglover](https://github.com/donovanglover)
- *(HTML)* Use whitespace control ([7d8ed20](https://github.com/welpo/tabi/commit/7d8ed20c2437ca285cc748359c4b2ff500a3968c)) by [@welpo](https://github.com/welpo)
- *(giscus)* Move comment box to bottom ([3822f00](https://github.com/welpo/tabi/commit/3822f00d3e3d77c8b585b10a788986d967e2011f)) by [@welpo](https://github.com/welpo)
- *(header)* Replace single %22 by `"` ([a57eb98](https://github.com/welpo/tabi/commit/a57eb98a6912889e07e923f289001975d9c3d495)) by [@welpo](https://github.com/welpo)
- *(tags)* Remove unnecessary id attribute ([b88e737](https://github.com/welpo/tabi/commit/b88e7376e4814b2d174f5ab1c8579d2a67f842df)) by [@welpo](https://github.com/welpo)
- *(translation)* Introduce translation macro ([#129](https://github.com/welpo/tabi/issues/129)) by [@welpo](https://github.com/welpo)
- *(utterances)* Further minify JS ([7251013](https://github.com/welpo/tabi/commit/725101300e77773362c2bec55d082798465aec0b)) by [@welpo](https://github.com/welpo)
- Co-locate images ([#200](https://github.com/welpo/tabi/issues/200)) by [@welpo](https://github.com/welpo)
- Turn macros into partials & sort CSS ([#146](https://github.com/welpo/tabi/issues/146)) by [@welpo](https://github.com/welpo)
- Use `get_url` for social icons ([d0babd5](https://github.com/welpo/tabi/commit/d0babd5db1717efb3822c0741612b5100e04bca9)) by [@welpo](https://github.com/welpo)
- Switch from `[@import](https://github.com/import)` to `[@use](https://github.com/use)` ([a799732](https://github.com/welpo/tabi/commit/a79973239892122f744d7c7e231a53abea46f780)) by [@welpo](https://github.com/welpo)
- Further minify theme initialization ([92e6af1](https://github.com/welpo/tabi/commit/92e6af1d5865c0e3bca8bd89082a0a0bb26b5062)) by [@welpo](https://github.com/welpo)
- Improve stylised feed translations & consolidate XSL/CSS loading ([#98](https://github.com/welpo/tabi/issues/98)) by [@welpo](https://github.com/welpo)
- Translate xsl stylesheets ([7ed295d](https://github.com/welpo/tabi/commit/7ed295db3aa003595a14a21b6c24c03bdbfeea0f)) by [@welpo](https://github.com/welpo)
- Combine and reorder media queries ([af81f88](https://github.com/welpo/tabi/commit/af81f88b925454291d4bc968bed30d0963410a17)) by [@welpo](https://github.com/welpo)
- Unify table styling ([787243c](https://github.com/welpo/tabi/commit/787243c3c5f32735e0476359901b0df79d382c11)) by [@welpo](https://github.com/welpo)
- Remove unused code ([8c5f305](https://github.com/welpo/tabi/commit/8c5f30556a9ecb412f52487eae0a9aed745b8e74)) by [@welpo](https://github.com/welpo)
- Remove Yahoo Media RSS reference ([16f1aa5](https://github.com/welpo/tabi/commit/16f1aa57fa908a44861990cf9ff40ecc5e8ffb4e)) by [@welpo](https://github.com/welpo)
- Restructure template ([e3bd75e](https://github.com/welpo/tabi/commit/e3bd75e9e384d03b070bb8bdab3c42aef645ad23)) by [@welpo](https://github.com/welpo)
- Simplify theme switching logic ([526c8a1](https://github.com/welpo/tabi/commit/526c8a1e67d71e1554f8c57706ae3adcf9229b6f)) by [@welpo](https://github.com/welpo)
- Simplify sans-serif-font declarations ([87a5c9a](https://github.com/welpo/tabi/commit/87a5c9a3a2c83d475a7e6083af8dc8fdeb37c0f8)) by [@welpo](https://github.com/welpo)
- Rename katex minified css ([0c8e0d2](https://github.com/welpo/tabi/commit/0c8e0d228ca73dec066dca8b94741807981ee976)) by [@welpo](https://github.com/welpo)
- Use `const` in theme initialization ([9512bbb](https://github.com/welpo/tabi/commit/9512bbb19400be6b770735ceb6daca4e71429630)) by [@welpo](https://github.com/welpo)
- Rename minified KaTeX css ([eb63718](https://github.com/welpo/tabi/commit/eb63718bbffce75f5eab584fab37396ac93123a0)) by [@welpo](https://github.com/welpo)
- Remove metadata in project files ([10b8525](https://github.com/welpo/tabi/commit/10b85257cd70e427a0beebadcb89f87565adbdef)) by [@welpo](https://github.com/welpo)
- Improve code format; set tabs = 4 spaces ([7a1bb1d](https://github.com/welpo/tabi/commit/7a1bb1d04c022cbefb9ab9c71ec52772522899e9)) by [@welpo](https://github.com/welpo)
- Move .last-updated to main.scss ([0f14171](https://github.com/welpo/tabi/commit/0f14171b6a7dfbf49d72c47280e7c5acbe3784b6)) by [@welpo](https://github.com/welpo)
- Standarise left/right margins ([76db25b](https://github.com/welpo/tabi/commit/76db25b44aa4d33c1f8b20cbfe3387aa8a84ed81)) by [@welpo](https://github.com/welpo)
- Remove useless css ([603ac09](https://github.com/welpo/tabi/commit/603ac09baa14b386e91047b576dcb386a53a5547)) by [@welpo](https://github.com/welpo)
- Remove useless lines ([f83c75e](https://github.com/welpo/tabi/commit/f83c75ed044834882c06d9259bb77983eeee492c)) by [@welpo](https://github.com/welpo)
- Remove unused `section_title` variable ([27dc4b9](https://github.com/welpo/tabi/commit/27dc4b9a9606772b22b944a16b5b8f9be7befe0d)) by [@welpo](https://github.com/welpo)
- Improve spacing and indentation ([dceceff](https://github.com/welpo/tabi/commit/dceceff5fda7ec791bb2e0311663bb034ec0d582)) by [@welpo](https://github.com/welpo)
- Move blog posts to `blog` section ([14156b5](https://github.com/welpo/tabi/commit/14156b590adbf274e527ecb4f9dd1be5c86a5c15)) by [@welpo](https://github.com/welpo)
- Use consistent pagination ([a8e49cf](https://github.com/welpo/tabi/commit/a8e49cfedfeba14b702db8913b984c87ce20e595)) by [@welpo](https://github.com/welpo)
- Remove 403 page ([6938ae4](https://github.com/welpo/tabi/commit/6938ae42f90be2faadae87cd9b463ed67243f306)) by [@welpo](https://github.com/welpo)
- Move blog posts `blog` section ([64449d5](https://github.com/welpo/tabi/commit/64449d5d9ffe22ed7025f07912a8137b4745c900)) by [@welpo](https://github.com/welpo)
- Rename extra.desc to extra.header ([de46a24](https://github.com/welpo/tabi/commit/de46a24d37eb47bafa379f7883b563303e67b520)) by [@welpo](https://github.com/welpo)
- Use rem instead of px ([b1728fc](https://github.com/welpo/tabi/commit/b1728fc441e47119741acf23f1781f6734417599)) by [@welpo](https://github.com/welpo)
- Rename 'Categories' to 'Tags' ([0648bc8](https://github.com/welpo/tabi/commit/0648bc80e22d05b2b13b8987a33c0e3d92a9695c)) by [@welpo](https://github.com/welpo)
- Remove extra last_updated date ([bd72fb8](https://github.com/welpo/tabi/commit/bd72fb84be73af5e303889e49df332ada970d37e)) by [@welpo](https://github.com/welpo)
- Use native `updated` field ([31ea93b](https://github.com/welpo/tabi/commit/31ea93bbbe8aba1a9fe7c3a6dc6b08b5c9cf7354)) by [@welpo](https://github.com/welpo)
- Remove unused set_title argument ([9ac1504](https://github.com/welpo/tabi/commit/9ac150423b92784041e4a84be32b36ddbc4449e0)) by [@welpo](https://github.com/welpo)
- Set font types as variables ([d6c198e](https://github.com/welpo/tabi/commit/d6c198e379abd84c877d194e052a72bc5ba0e071)) by [@welpo](https://github.com/welpo)
- Show word count as reading time tooltip ([9ed4034](https://github.com/welpo/tabi/commit/9ed40342605f079afe4cf668ed4fbb7ab87c4664)) by [@welpo](https://github.com/welpo)
- Improve table of contents accessibility ([1c93df0](https://github.com/welpo/tabi/commit/1c93df0a6fe9cc564678b5aba971f20d78c18166)) by [@welpo](https://github.com/welpo)
- Set datetime format as a variable ([988034b](https://github.com/welpo/tabi/commit/988034ba4ebf622d3e704cfee7a2bd681abcf306)) by [@welpo](https://github.com/welpo)

### 👥 New contributors

🫶 [@joberthrogers18](https://github.com/joberthrogers18) made their first contribution in [#219](https://github.com/welpo/tabi/pull/219)

🫶 [@xvello](https://github.com/xvello) made their first contribution in [#218](https://github.com/welpo/tabi/pull/218)

🫶 [@donovanglover](https://github.com/donovanglover) made their first contribution in [#205](https://github.com/welpo/tabi/pull/205)

🫶 [@nyadiia](https://github.com/nyadiia) made their first contribution in [#195](https://github.com/welpo/tabi/pull/195)

🫶 [@Almost-Senseless-Coder](https://github.com/Almost-Senseless-Coder) made their first contribution in [#192](https://github.com/welpo/tabi/pull/192)

🫶 [@Jieiku](https://github.com/Jieiku) made their first contribution in [#173](https://github.com/welpo/tabi/pull/173)

🫶 [@sandman](https://github.com/sandman) made their first contribution in [#170](https://github.com/welpo/tabi/pull/170)

🫶 [@SeaDve](https://github.com/SeaDve) made their first contribution in [#165](https://github.com/welpo/tabi/pull/165)

🫶 [@stevenroose](https://github.com/stevenroose) made their first contribution in [#124](https://github.com/welpo/tabi/pull/124)

🫶 [@serginogal](https://github.com/serginogal) made their first contribution

<!-- generated by git-cliff -->
