<!--
  Thank you for contributing to tabi!

  This template is designed to guide you through the pull request process.
  Please fill out the sections below as applicable.

  Don't worry if your PR is not complete or you're unsure about something;
  feel free to submit it and ask for feedback. We appreciate all contributions, big or small!

  Feel free to remove any section or checklist item that does not apply to your changes.
  If it's a quick fix (for example, fixing a typo), a Summary is enough.
-->

## Summary

<!-- Please provide a brief description of the changes made in this PR -->

### Related issue

<!-- Mention any relevant issues like #123 -->

## Changes

<!-- Please provide some more detail regarding the changes.
Add any additional information, configuration, or data that might be necessary for the review -->

### Accessibility

<!-- Have you taken steps to make your changes accessible? This could include:
- Semantic HTML
- ARIA attributes
- Keyboard navigation
- Voiceover or screen reader compatibility
- Colour contrast
Please elaborate on the actions taken.
If you need help, please ask! -->

### Screenshots

<!-- If applicable, add screenshots to help explain the changes made. Consider if a before/after is helpful -->

### Type of change

<!-- Mark the relevant option with an `x` like so: `[x]` (no spaces) -->

- [ ] Bug fix (fixes an issue without altering functionality)
- [ ] New feature (adds non-breaking functionality)
- [ ] Breaking change (alters existing functionality)
- [ ] UI/UX improvement (enhances user interface without altering functionality)
- [ ] Refactor (improves code quality without altering functionality)
- [ ] Documentation update
- [ ] Other (please describe below)

---

## Checklist

- [ ] I have verified the accessibility of my changes
- [ ] I have tested all possible scenarios for this change
- [ ] I have updated `theme.toml` with a sane default for the feature
- [ ] I have updated `config.toml` in [tabi-start](https://github.com/welpo/tabi-start)
- [ ] I have made corresponding changes to the documentation:
  - [ ] Updated `config.toml` comments
  - [ ] Updated `theme.toml` comments
  - [ ] Updated "Mastering tabi" post in English
  - [ ] (Optional) Updated "Mastering tabi" post in Spanish
  - [ ] (Optional) Updated "Mastering tabi" post in Catalan
