
//自定义配置 start
var welive_default = 1; //是否在调用welive.js的页面右下角显示默认的客服图标，设置为0表示不显示
var welive_popup_time = 10; //访客停留在调用客服的页面多少秒后显示临时会话, 建议5 - 60秒内, 设置为0表示不显示临时会话
var welive_popup_mode = "random"; //显示临时会话的模式： order 顺序； random 随机
var welive_popup_num = 5; //显示临时会话的条数，建议：1 - 5

var welive_popup_fade = 10; //每条会话显示多少秒后消失，可选：5 - 30
var welive_popup_next = 10; //会话消失后停留多少秒显示下一条，可选：5 - 30
var welive_popup_keep = 1; //是否保留最后一条(不消失)，设置为0时最后一条也会消失

//临时会话数组，内容支持html，建议5条以上。内容中“welive_url”会替换成WeLive安装后根目录的URL
var welive_msg = [
	'Hello，在呢！',
	'你好，需要咨询什么哟？',
	'如有疑问，请点击与客服在线交流吧。',
	'遇到困难了吗？在线客服随时恭迎你的来访。',
	'谢谢关注，我们一直努力为客户提供更优质的在线服务。',
	'亲，需要帮助吗？',
	'点我，就送你优质的在线服务，<img src="welive_url/public/smilies/16.png">',
	'欢迎您随时向客服分享意见、建议和感受！<img src="welive_url/public/smilies/1.png">',
];

var welive_msg_en = [
	'Hello, there it is!',
	'Hi, what do you need to consult?',
	'If you have any questions, please click to communicate with customer service online.',
	'Are you in trouble? Online customer service welcomes your visit at any time.',
	'Thank you for your attention. We have been trying to provide customers with better online services.',
	'Dear, can I help you?',
	'Click here, high-quality online service will be for your, <img src="welive_url/public/smilies/16.png">',
	'You are welcome to share your opinions, suggestions and feelings with customer service at any time! <img src="welive_url/public/smilies/1.png">',
];
//自定义配置 end




//***********  以下内容一般无需修改   **************

//防机器人编码
var welive_code = 6168;

//原网站用户id ---用户接口
var welive_id = weliveGetCookie("welive_id");

//原网站用户名或昵称fullname ---用户接口
var welive_fn = weliveGetCookie("welive_fn");

//选择语言
if(navigator.userAgent.toLowerCase().indexOf("msie") != -1){
	var welive_lang = navigator.browserLanguage.toLowerCase();
}else{
	var welive_lang = navigator.language.toLowerCase();
}

if(welive_lang.indexOf("zh-") < 0)  welive_msg = welive_msg_en; //选择英文

//当前页面URL(base64)
var url = window.btoa(window.location.href);

//welive所在URL
var welive_url = document.getElementsByTagName("script");
welive_url = welive_url[welive_url.length-1].src;

var welive_groupid = parseInt(welive_url.substring(welive_url.indexOf("g=") + 2)); //进入指定的客服组id
welive_url = welive_url.substring(0, welive_url.indexOf("welive.js"));

//判断是否为移动设备
var welive_mobile = navigator.userAgent.match(/(iPhone|Android|iPod|ios|iPad|Windows ce|Windows mobile|Micromessenger|webOS|Ucweb|UCBrowser|BlackBerry|midp|rv:1.2.3.4)/i);

//根据设备跳转的链接不同
if(welive_mobile){ //mobile
	var welive_link = welive_url + "mobile.php" + "?a=" + welive_code;
}else{ //web
	var welive_link = welive_url + "welive.php" + "?a=" + welive_code;
}

//点击客服URL
if(welive_groupid) welive_link += "&group=" + welive_groupid;
if(welive_id) welive_link += "&id=" + welive_id;
if(welive_fn) welive_link += "&fn=" + welive_fn;

welive_link += "&url=" + url;

//WeLive对象
var WeLive = {
	kefu: null, //客服小图标对象
	kefu_height: 0, //初始化客服小图标的高度
	popup_obj: null, //临时会话弹出层对象
	popup_content: null, //临时会话内容层
	popup_num: 1, //当前临时会话编号
	notice: null, //临时会话声音对象
	ttt: 0, //定时变量
};

//显示页面左下角客服小图标
if(welive_default){
	var welive_css = document.createElement("link");
	welive_css.setAttribute("rel", "stylesheet");
	welive_css.setAttribute("href", welive_url + "public/welive.css");
	document.getElementsByTagName("head")[0].appendChild(welive_css);

	var welive_code = '<img id="welive-kefu" src="' +  welive_url + 'public/img/kefu.png" alt="客服浮标" title="">' +
		'<div id="welive-popup">' + 
			'<div id="welive-arrow"></div>' + 
			'<div id="welive-content"></div>' + 
		'</div>' + 
		'<div style="width:1px;height:1px;display:none;overflow:hidden;float:right;"><audio src="' +  welive_url + 'public/notice.mp3" id="welive-notice"></audio></div>';

	document.write(welive_code);

	WeLive.kefu = $_$("welive-kefu");

	//初始化并开启临时会话
	if(welive_popup_time && welive_msg.length){
		welive_popup_num = parseInt(welive_popup_num);

		if(welive_popup_num < 1) welive_popup_num = 1;
		if(welive_popup_num > welive_msg.length) welive_popup_num = welive_msg.length;

		if(welive_popup_fade < 5) welive_popup_fade = 5;
		if(welive_popup_fade > 30) welive_popup_fade = 30;

		if(welive_popup_next < 5) welive_popup_next = 5;
		if(welive_popup_next > 30) welive_popup_next = 30;

		//随机模式
		if(welive_popup_mode == "random"){
			var arr = [], temp = [];

			for(var i = 0; i < welive_msg.length; i++) {
				arr.push(i);
			}
			
			arr.sort(function(){return Math.random() - 0.5;}); //数组随机排序

			//重置临时会话内容数组
			for(var i = 0; i < welive_popup_num; i++) {
				temp.push(welive_msg[arr[i]]);
			}

			welive_msg = temp;
		}
		
		WeLive.popup_obj = $_$("welive-popup");
		WeLive.popup_content = $_$("welive-content");
		WeLive.notice = $_$("welive-notice");

		//解决移动端无法自动播放声音的问题(监听touchend事件苹果手机无效)
		document.addEventListener("touchstart", welivePlay);
		document.addEventListener("click", welivePlay);

		//监听页面激活状态
		document.addEventListener("visibilitychange", function(){
			if(document.hidden){
				WeLive.popup_obj.style.display = "none";
				clearTimeout(WeLive.ttt);
			}else{
				weliveStartPopup(); //重新开启临时会话
			}			
		});
	}

	//拖动客服图标事件, 兼容web和移动端
	WeLive.kefu.addEventListener(welive_mobile ? "touchstart" : "mousedown", weliveDrag);
}

//加载客服自定义样式等
window.addEventListener("load", function(){

	//获取客服小图片的高度
	if(welive_default) WeLive.kefu_height = WeLive.kefu.offsetHeight;

	//自定义客服图标或按钮
	var open_link = "";
	var groupid = 0;
	var welive_targets = document.getElementsByClassName("welive");

	for(var i = 0; i < welive_targets.length; i++) {

		welive_targets[i].onclick = function(e){
			e.preventDefault();

			welive_popup_time = 0; //点击后关闭当前页面的临时会话

			open_link = welive_link;
			groupid = parseInt(this.getAttribute("group"));

			if(groupid){
				open_link = welive_link.replace(/&group=(\w*)&/g, ""); //去掉原默认的group
				open_link += "&group=" + groupid;
			}

			window.open(open_link);
			return false;
		};
	}

	//开启临时会话
	weliveStartPopup();
});

//开始或重新开始临时会话
function weliveStartPopup(){
	var time = welive_popup_next;
	if(WeLive.popup_num == 1) time = welive_popup_time;

	WeLive.ttt = setTimeout(function(){welivePopup();}, time * 1000);
}

//弹出显示临时会话
function welivePopup(){
	if(!welive_default || !welive_popup_time || welive_msg.length < 1) return false;

	if(WeLive.popup_num > welive_popup_num) return false; //临时会话结束

	WeLive.notice.play();

	var index = WeLive.popup_num - 1;
	var str = welive_msg[index];

	WeLive.popup_num += 1;

	//将内容中“welive_url”会替换成WeLive安装后根目录的URL
	WeLive.popup_content.innerHTML  = str.replace(/welive_url/ig, welive_url);;
	WeLive.popup_obj.style.display = "block";

	//解决动态加载内容中的图片无法点位的问题
	var imgs = WeLive.popup_obj.getElementsByTagName("img");
	for(var i = 0; i < imgs.length; i++) {
		imgs[i].onload = function(e){
			weliveAjust(); //图片加载完成后校正位置
		};
	}

	weliveAjust(); //校正位置

	if(WeLive.popup_num > welive_popup_num && welive_popup_keep) return; //是否保留最后一条不消失

	WeLive.ttt = setTimeout(function(){
		WeLive.popup_obj.style.display = "none";
		WeLive.ttt = setTimeout(function(){welivePopup();}, welive_popup_next * 1000); //消失多少秒后显示下一条
	}, welive_popup_fade * 1000); //多少秒后消失
}

//临时会话弹出层校正位置
function weliveAjust(){
	WeLive.popup_obj.style.marginTop = (WeLive.kefu_height - WeLive.popup_obj.offsetHeight) / 2 + "px";
}

//拖动
function weliveDrag(e){
	e = e||window.event;

	clearTimeout(WeLive.ttt);

	//兼容web和移动端
	if(e.targetTouches){
		var event = e.targetTouches[0];
	}else {
		var event = e;
	}
	
	var x0 = x = event.clientX;
	var y0 = y = event.clientY;

	//兼容web和移动端
	var event_move = welive_mobile ? "touchmove" : "mousemove";
	var event_up = welive_mobile ? "touchend" : "mouseup";

	function wMove(e){
		e = e||window.event;
		if(e.targetTouches) e = e.targetTouches[0];

		var right = document.documentElement.clientWidth - WeLive.kefu.offsetLeft - WeLive.kefu.offsetWidth - e.clientX + x;

		if(right > 0 && right < (document.documentElement.clientWidth - WeLive.kefu.offsetWidth - 120)){
			WeLive.kefu.style.right = right + "px";
		}

		var top = WeLive.kefu.offsetTop + e.clientY - y;

		if(top > 0 && top < (document.documentElement.clientHeight - WeLive.kefu.offsetHeight)){
			WeLive.kefu.style.top = top + "px";
		}

		x = e.clientX;
		y = e.clientY;
	}

	function wMouseup(e){
		document.removeEventListener(event_move, wMove);
		document.removeEventListener(event_up, wMouseup);

		//根据移动量判断是不是为点击
		if((Math.abs(x - x0) + Math.abs(y - y0)) < 7){
			welive_popup_time = 0; //点击后关闭当前页面的临时会话

			window.open(welive_link);
			return false;
		}

		if(welive_popup_time){
			WeLive.popup_obj.style.top = WeLive.kefu.offsetTop + "px";
			WeLive.popup_obj.style.right = document.documentElement.clientWidth - WeLive.kefu.offsetLeft - WeLive.kefu.offsetWidth + "px";

			weliveStartPopup(); //重新开启临时会话
		}
	}

	document.addEventListener(event_move, wMove);
	document.addEventListener(event_up, wMouseup);

	if(welive_popup_time) WeLive.popup_obj.style.display = "none"; //隐藏临时会话

	e.stopPropagation();
	e.preventDefault();
	return false;
}

//获取对象
function $_$(id){return document.getElementById(id);}

//获取cookie函数
function weliveGetCookie(n){
	var a = document.cookie.match(new RegExp("(^| )" + n + "=([^;]*)(;|$)"));
	if (a != null) return a[2];
	return "";
}

//解决mobile无法自动播放声音的问题
function welivePlay(){
	WeLive.notice.play();
	WeLive.notice.src  = welive_url + "public/notice.mp3"; //此句可以让上面一句的play()不发声

	document.removeEventListener("touchstart", welivePlay);
	document.removeEventListener("click", welivePlay);
}