
/* WeLive support.js  @Copyright weensoft.cn */

var userAgent = navigator.userAgent.toLowerCase();
var isIE = window.ActiveXObject && userAgent.indexOf('msie') != -1 && userAgent.substr(userAgent.indexOf('msie') + 5, 3);

//弹出消息
function popInfo(info, sec){
	if(sec){
		layer.msg(info, {time: sec * 1000});
	}else{
		layer.msg(info);
	}
}

//Ajax封装
var ajax_isOk = 1;
function ajax(url, send_data, callback) {
	if(!ajax_isOk) return false;
	$.ajax({
		url: url,
		data: send_data,
		type: "post",
		cache: false,
		dataType: "json",
		beforeSend: function(){ajax_isOk = 0;$("#ajax-loader").addClass('loading');},
		complete: function(){ajax_isOk = 1;$("#ajax-loader").removeClass('loading');},
		success: function(data){
			if(callback)	callback(data);
		},
		error: function(XHR, Status, Error) {
			file_temp_data = "";
			//showDialog("Ajax错误");
			showDialog("Data: " + XHR.responseText + "<br>Status: " + Status + "<br>Error: " + Error);
		}
	});
}

//设置cookie
function setCookie(n,val,d) {
	var e = "";
	if(d) {
		var dt = new Date();
		dt.setTime(dt.getTime() + parseInt(d)*24*60*60*1000);
		e = "; expires="+dt.toGMTString();
	}
	document.cookie = n+"="+val+e+"; path=/";
}

//获取cookie
function getCookie(n) {
	var a = document.cookie.match(new RegExp("(^| )" + n + "=([^;]*)(;|$)"));
	if (a != null) return a[2];
	return '';
}

//将已转义的字符恢复
function recoverHtml(str) {
	if(!str) return "";
	return str.replace(/\\/g, '').replace(/\&amp;/g, '&').replace(/\&#039;/g, "'").replace(/\&quot;/g, '"').replace(/\&lt;/g, '<').replace(/\&gt;/g, '>');
}

//滚动到底部
function scrollBottom(obj){
	obj.scrollTop(20000); //滚动到底部
}

//新消息闪动页面标题
function flashTitle() {
	clearInterval(tttt);
	flashtitle_step=1;
	tttt = setInterval(function(){
		if (flashtitle_step==1) {
			document.title='【新消息】'+pagetitle;
			flashtitle_step=2;
		}else{
			document.title='【　　　】'+pagetitle;
			flashtitle_step=1;
		}
	}, 500);
}

//停止闪动页面标题
function stopFlashTitle() {
	if(flashtitle_step != 0){
		flashtitle_step=0;
		clearInterval(tttt);
		document.title=pagetitle;

		if(CurrentUnread){
			CurrentUnread = 0;
			new_info.fadeOut(800);

			if(CurrentId && $.inArray(CurrentId, offline_list) < 0) weliveSend({type: "s_readed", gid: CurrentId}); //发送已读信号
		}
	}
}

//客服信息声音
function teamSound() {
	if(welive.sound) sounder.html('<audio src="' + SYSDIR + 'public/sound_b.mp3" autoplay="autoplay"></audio>');
}

//获得计算机当前时间
function getLocalTime() {
	var date = new Date();

	function addZeros(value, len) {
		var i;
		value = "" + value;
		if (value.length < len) {
			for (i=0; i<(len-value.length); i++)
				value = "0" + value;
		}
		return value;
	}
	return addZeros(date.getHours(), 2) + ':' + addZeros(date.getMinutes(), 2) + ':' + addZeros(date.getSeconds(), 2);
}

//鼠标左右划动后执行动作
function initSlider(handler, func){
	var oX = 0, oY = 0, eX = 0, eY = 0, status = false;

	function mousexy(e){
		var x, y;
		var e = e||window.event;
		return {x:e.clientX, y:e.clientY};
	}

	handler.mousedown(function(e) {
		status = true;
		oX = eX = mousexy(e).x;
		oY = eY = mousexy(e).y;
	}).mouseup(function(e){
		status = false;
		e.stopPropagation();

		var dx = Math.abs(eX - oX);
		var dy = Math.abs(eY - oY);

		if(dx > 20 || dy > 20) welive.isSlider = 1;

		if(dx > 80 && dy < 60 && func){
			var d = "left";
			if(eX - oX > 0) d = "right";
			func(d); //正常的左右滑动后执行
		}

		setTimeout(function() {
			welive.isSlider = 0;
		}, 500);

		return false;
	}).mousemove(function(e){
		if (!status) return;
		eX = mousexy(e).x;
		eY = mousexy(e).y;
		e.stopPropagation();
		return false;
	});
}

//显示确认操作对话框 callback表示按确定时执行的函数; time是自动关闭时间;
function showDialog(info, title, callback, time){
	var ti = time? time * 1000 : 0;

	easyDialog.open({
		container:{
			header: "<font color=red>" + (title? title : "系统信息") + "</font>",
			content: "<font color=#FF9900>" + info + "</font>",
			yesFn: callback,
			yesText: '确定',
			noFn:true,
			noText: '取消'
		},
		autoClose:ti
	});

	$("#easyDialogYesBtn").focus(); //确定按钮获得焦点
}

//顶部下拉菜单 b为参数对象, c为下拉菜单显示后的事件函数
(function(a) {
	a.fn.Jdropdown = function(b, c) {
		if (this.length) {
			"function" == typeof b && (c = b, b = {});
			var d = a.extend({
					event: "mouseover",
					current: "hover",
					delay: 0
				}, b || {}),
				e = "mouseover" == d.event ? "mouseout" : "mouseleave";
			a.each(this, function() {
				var b = null,f = null,g = !1;
				a(this).bind(d.event, function() {
					if (g) clearTimeout(f);
					else {
						var e = a(this);
						b = setTimeout(function() {
							e.addClass(d.current), g = !0, c && c(e)
						}, d.delay);
					}
				}).bind(e, function() {
					if (g) {
						var c = a(this);
						f = setTimeout(function() {
							c.removeClass(d.current), g = !1
						}, 0)
					} else clearTimeout(b);
				});
			});
		}
	}
})(jQuery);

//格式化输出信息
function formatOutput(data) {
	//生成URL链接
	data = data.replace(/((((https?|ftp):\/\/)|www\.)([\w\-]+\.)+[\w\.\/=\?%\-&~\':+!#;]*)/ig, function($1){return getURL($1);});
	//将表情代码换成图标路径
	data = data.replace(/\[:(\d*):\]/g, '<img src="' + SYSDIR + 'public/smilies/$1.png">').replace(/\\n/g, '<br>').replace(/\n/g, '<br>');
	return data;
}

//格式化生成URL
function getURL(url, limit) {
	if(!limit) limit = 60;
	var urllink = '<a href="' + (url.substr(0, 4).toLowerCase() == 'www.' ? 'http://' + url : url) + '" target="_blank" title="' + url + '">';
	if(url.length > limit) {
		url = url.substr(0, 30) + ' ... ' + url.substr(url.length - 18);
	}
	urllink += url + '</a>';
	return urllink;
}

//显示大图片
function showBigImage(me, width, height){
	if(width/height >= 1200/700){
		var d_w = width;
		if(d_w > 1200) d_w = 1200;
		if(width < 1) width = 1;
		var d_h = height * d_w / width;
	}else{
		var d_h = height;
		if(d_h > 700) d_h = 700;
		if(height < 1) height = 1;
		var d_w = width * d_h / height;
	}

	easyDialog.open({
		container:{
			header: "图片",
			content: '<img src="' + me.src + '" style="width: ' + d_w + 'px;height: ' + d_h + 'px;" onclick="easyDialog.close();return false;">',
		},
		width: d_w + 20,
		height: d_h + 20
	});
}

//插入表情符号
function insertSmilie(code, towhere) {
	code = '[:' + code + ':]';
	if(towhere){
		var obj = guest_msg[0];
	}else{
		var obj = s_msg[0];
	}
	var selection = document.selection;
	obj.focus();

	if(typeof obj.selectionStart != 'undefined') {
		var opn = obj.selectionStart + 0;
		obj.value = obj.value.substr(0, obj.selectionStart) + code + obj.value.substr(obj.selectionEnd);
	} else if(selection && selection.createRange) {
		var sel = selection.createRange();
		sel.text = code;
		sel.moveStart('character', -code.length);
	} else {
		obj.value += code;
	}
}

//socket连接
function weliveLink(){
	welive.ws = new WebSocket(WS_HEAD + WS_HOST + ':'+ WS_PORT);
	welive.ws.onopen = function(){setTimeout(weliveVerify, 100);}; //连接成功后, 小延时再验证用户, 否则IE下刷新时发送数据失败
	welive.ws.onclose = function(){weliveClose();};
	welive.ws.onmessage = function(get){weliveParseOut(get.data);};
}

//清空过长客服对话记录(保留40条)
function teamChatClear(){
	var rec = s_history.children("div");
	var len = rec.length;
	if(len >= 80){
		rec.slice(0, len - 40).remove();
		scrollBottom(s_history);
	}
}

//更新客服数量(在原数量上加或减n)
function adminsUpdate(n){
	var x = parseInt(s_admins.html());
	x = x + n;
	if(x < 0) x = 0;
	s_admins.html(x);
}

//更新客服新消息统计-显示
function sChatUpdate(){
	if(s_chat_isopen) return;

	var num = parseInt(s_chat_num.html());
	if(num == 0) s_chat_num.show();

	var x = num + 1;
	if(x > 99) x = "99+";

	s_chat_num.html(x);
}

//解析聊天记录
function parseRecords(reArr){
	var recs_html = '';

	$.each(reArr, function(i, rec){

		//上传图片的记录
		if(rec.ft == 1){
			var img_arr = rec.m.split("|");
			var img_w = parseInt(img_arr[1]);
			var img_h = parseInt(img_arr[2]);

			if(img_w < 1) img_w = 1;
			var img_h_new = parseInt(img_h * 200 / img_w); //CSS样式中已确定宽度为200

			var rec_i = '<img src="' + SYSDIR + 'upload/img/' +img_arr[0] + '" class="receive_img" style="height:' + img_h_new + 'px;" onclick="showBigImage(this, ' + img_w + ', ' + img_h + ');">';

		//上传的文件记录
		}else if(rec.ft == 2){
			var file_arr = rec.m.split("|");
			var rec_i = '<a href="' + SYSDIR + 'upload/file/' + file_arr[0] + '" target="_blank" download="' + file_arr[1] + '"><img src="' + SYSDIR + 'public/img/save.png">&nbsp;&nbsp;点击下载: ' +  file_arr[1] + '</a>';
		}else{
			var rec_i = formatOutput(rec.m);
		}

		if(rec.t == 1){ //客服的
			recs_html += '<div class="msg r"><u><img src="' + SYSDIR + 'avatar/' + admin.av + '"></u><div>' + rec_i + '</div><b>' + rec.d + '</b></div>';
		}else{ //客人的
			recs_html += '<div class="msg l"><u></u><div>' + rec_i + '</div><b>' + rec.d + '</b></div>';
		}
	});

	if(recs_html != ''){
		recs_html += '<div class="msg s"><div class="b"><div class="ico"></div><div class="i">... 以上为最近对话记录</div></div></div>';
	}

	return recs_html;
}

//解析数据并输出
function weliveParseOut(data){
	var gid = 0, d = false, type = 0, data = $.parseJSON(data);

	if(data.g) gid = parseInt(data.g); //统一将访客id转为数字

	switch(data.x){
		case 1: //客服群内对话
			var time = getLocalTime();
			if(data.aid == admin.aid){ //自己的发言
				d = '<div class=me><u>' + admin.fullname + ' - ' + data.p + '</u><i>' + time + '</i><p>' + formatOutput(data.i) + '</p></div>';
			}else{
				d = '<div' + ((data.t==1 || data.t==2)? ' class=a' : '') + '><u>' + data.n + ' - ' + data.p + '</u><i>' + time + '</i><p>' + formatOutput(data.i) + '</p></div>';
			}
			break;

		case 4:  //客人实时输入状态
			switch(data.a){
				case 1:
					guestRuntime(gid, data.i);
					break;

				case 2: //删除实时输入状态
					if(gid != CurrentId) return;
					guest_history.children("div.updating").remove();

					break;
			}

			return true;
			break;

		case 5:  //客人与客服文字对话
			d = data.i;
			if(data.a == 1){
				type = 1; //自己发出的对话
			}else{
				type = 2; //客人发来的
			}

			break;

		case 8: //客人发来的标记已读信息
			if(gid == CurrentId){
				var target = guest_history;
			}else{
				var target = $("#win_" + gid);
			}
			target.find("s.un").html("已读").removeClass("un");

			return true;

			break;

		case 2: //客服特别操作及反馈信息
			switch(data.a){
				case 1: //上线
					if(s_online.children('#' + data.ix).length > 0) return false; //有相同客服返回

					var status = '';
					if(data.mb == 1) status = '<u></u>';
					d = '<div class=i><b></b>' + data.n + ' 上线了</div>';

					s_online.append('<li id="' + data.ix + '" title="' + data.p + '"><div><img src="' + SYSDIR + 'avatar/' + data.av + '" title="服务中...">' + status + '</div><i' + ((data.t==1 || data.t==2)? ' class=a' : '') + '>' + data.n + '</i></li>');

					adminsUpdate(1); //更新客服在线人数
					break;

				case 2: //离线
					//解决客服重复连接时, 给新连接的窗口发送自己离线信息的问题(也就是说自己无法看到自己离线)
					if(data.aid == admin.aid) return false;

					d = '<div class=i><b></b>' + data.i + ' 已离线</div>';
					s_online.children('#' + data.ix).remove();
					adminsUpdate(-1);
					break;

				case 3: //挂起
					teamSound();
					var support = s_online.children('#' + data.ix);
					d = '<div class=i><b></b>' + support.children("i").html() + ' 已挂起</div>';
					support.children("div").append('<b></b>');
					support.children("div").children("img").attr('title', '已挂起');

					if(data.ix == welive.aix){
						$(".set_busy").hide();
						$(".set_serving").show();
					}
					break;

				case 4: //解除挂起
					var support = s_online.children('#' + data.ix);
					d = '<div class=i><b></b>' + support.children("i").html() + ' 解除挂起</div>';
					support.children("div").children("b").remove();
					support.children("div").children("img").attr('title', '服务中...');

					if(data.ix == welive.aix){
						$(".set_serving").hide();
						$(".set_busy").show();
					}
					break;

				case 5: //获取客人信息
					if(typeof data.d != "object") return false; //客人数据不存在

					profile＿loaded = 1; //设置数据已更新
					guest_profile.find("a.fromurl").attr("href", data.d.fromurl.replace(/\&amp;/g, '&')).html(data.d.fromurl);
					guest_profile.find(".ipzone").html(data.d.ipzone + " ( " + data.d.lastip + " )");
					guest_profile.find("input[name=grade]").prop("checked",false);
					guest_profile.find("input[name=grade][value=" + data.d.grade + "]").prop("checked", true);
					guest_profile.find("input[name=fullname]").val(recoverHtml(data.d.fullname));
					guest_profile.find("textarea[name=remark]").val(recoverHtml(data.d.remark));

					guest_profile.show();
					$(".t_profile").addClass("hover");

					break;

				case 6: //保存客人信息后返回的结果
					type = 3; d = '访客信息保存成功';

					if(data.fullname != ''){ //客人有姓名时, 更新之
						var ipzone = guest_online.find("#gst_" + gid + ">s").html();
						guest_online.children("#gst_" + gid).attr("title", data.fullname + " (" + ipzone + ")").find("i").html(data.fullname);
					}

					closeProfile();

					break;

				case 7: //重复连接返回的指令
					welive.autolink = 0;
					clearTimeout(welive.ttt); //停止重连	
					weliveOutput('<div class="i"><b></b><font color=red>当前客服已在其它页面登录, 此页面已废弃!!</font></div>');

					break;

				case 8: //客服连接验证成功
					var aid = parseInt(data.aid);
					if(aid != admin.aid) return false; //非法登录

					var is_robot = 0; //无人值守是否开启

					d = '<div class=i><b></b>服务器连接成功</div>';

					welive.status = 1;
					welive.aix = data.aix; //socket连接索引值
					s_history.removeClass('loading3');

					teamSound(); //声音

					//更新自己的客服列表
					var num = 0, status;

					$.each(data.alist, function(n, a){
						num += 1;

						if(a.b == 1){
							status = 'title="已挂起"><b></b>';
						}else{
							status = 'title="服务中...">';
						}

 						if(a.mb == 1) status += '<u></u>'; //移动端

						if(a.aid == admin.aid){
							admin.av = a.av; //记录当前客服的头像文件名
							admin.aix = a.aix; //记录当前客服的连接索引
						}

						s_online.append('<li id="' + a.aix + '" title="' + a.p + '"><div><img src="' + SYSDIR + 'avatar/' + a.av + '" ' + status + '</div><i' + ((a.t==1 || a.t==2)? ' class=a' : '') + '>' + a.n + '</i></li>');
					});

					adminsUpdate(num); //更新客服人数
					s_msg.focus(); //群聊输入框获焦点

					//重建所有在线客人
					$.each(data.glist, function(i, guest){
						guestCreate(guest, 1); //1表示客服重连
					});

					//初始化挂起动作
					$(".set_busy").click(function(e) {
						showDialog('确定挂起吗?<br>注: 挂起后, 将不再接受新客人加入.', '', function(){
							weliveSend({type: "s_handle", operate: "hangup", value: 1}); //发送挂起请求
						});

						e.preventDefault();
					});

					$(".set_serving").click(function(e) {
						weliveSend({type: "s_handle", operate: "hangup", value: 0}); //发送解除挂起请求
						e.preventDefault();
					});


					//开启无人值守
					$(".set_robot_on").click(function(e) {
						popInfo('免费版无此功能!', 3);
						e.preventDefault();
					});

					//设置当前无人值守按钮状态
					$(".set_robot_on").show();
					$(".set_robot_off").hide();

					//启动心跳, 即每隔26秒自动发送一个特殊信息, 解决IE下30秒自动断线的问题
					ttt_1 = setInterval(function() {						
						weliveSend({type:"ping"}); //只要连接状态, 均要发送心跳数据, 设置一个怪异的数字避免与自动离线的时间间隔重合, 避免在同一时间点上send数据上可能产生 -----幽灵bug
					}, 26125);

					break;

				case 9: //添加快捷回复返回
					var pid = parseInt(data.pid);
					var lang = parseInt(data.lang);

					if(pid && data.msg){
						var obj = s_phrases_en;
						if(lang) obj = s_phrases_cn;

						if(obj.children("li").length <= 0) obj.html("");
						obj.append('<li onclick="insertPhrase(this);">' + data.msg.replace(/\\n/g, '&lt;br&gt;') + '<b onclick="deletePhrase(this, \'' + pid + '\')"></b></li>');

						scrollBottom(obj);
					}

					break;
			}

			break;

		case 6: //客人相关
			switch(data.a){

				case 3: //客人离线
					if($.inArray(gid, guest_list) < 0) return; //客人已经删除, 不能再push到offline_list数组中, 否则各种出错

					type = 4; d = '此客人已离线';

					offline_list.push(gid); //添加到离线客人数组中
					guest_online.children('#gst_' + gid).addClass("off"); //设置为离线状态
					setChatAvatar(gid, 0); //设置聊天窗口访客头像为离线

					break;

				case 8: //客人上线

					guestCreate(data); //创建客人

					break;

				case 11: //转接客人返回信息
					type = 4;

					if(data.i == 1){
						d = '此客人转接成功';

						offline_list.push(gid); //添加到离线客人数组中
						guest_online.children('#gst_' + gid).addClass("off"); //设置为离线状态
						setChatAvatar(gid, 0); //设置聊天窗口访客头像为离线

					}else if(data.i == "busy"){
						d = '接收客服忙碌中, 转接失败';
					}else if(data.i == "other"){
						d = '此客人已转接给其他客服, 无法对其发言';
					}else{
						d = '此客人转接失败';
					}

					break;
			}

			break;

		case 7: //其它
			switch(data.a){

				case 9: //撤回最后一条消息

					if(data.i == "err"){

						popInfo("超过10分钟的消息无法撤回", 5);

					}else{

						type = 3; d = '最后一条消息已撤回';

						if(gid == CurrentId){
							var obj = guest_history;
						}else{
							var obj = $("#win_" + gid);
						}

						obj.find(".msg.r:last").remove();

					}

					break;
			}

			break;

	}

	weliveOutput(d, gid, type); //输出
}

//创建客人, 当客服刷新页面或断线重连时: relink = 1
function guestCreate(data, relink){
	var gid = parseInt(data.g); //访客id
	var oid = parseInt(data.oid); //访客原网站用户id
	var fullname = data.n; //访客昵称

	var ipzone = data.iz; //ip归属地
	var fromurl = data.fr; //来源url

	var lang = parseInt(data.l); //访客语言: 1中文  0英文
	var mobile = parseInt(data.mb); //是否为移动设备

	//无gid
	if(!gid) return false;

	//处理访客昵称
	if(fullname == '') fullname = (lang ? '访客 ' : 'Guest ') + gid;
	if(oid) fullname = fullname + " - Oid: " + oid;

	//gid在访客数组中存在时 不创建(访客重新上线)
	if($.inArray(gid, guest_list) > -1){
		offline_list.splice($.inArray(gid, offline_list), 1); //删除离线访客数组中的元素

		var curr_guest = guest_online.children("#gst_" + gid);

		//变更状态、更新访客原网站用户名及ID等
		curr_guest.removeClass("off").attr("title", fullname + ' (' + ipzone + ')').find("i").html(fullname);

		guestOutput("此客人重新上线", gid, 3); //输出信息
		setChatAvatar(gid, 1); //设置聊天窗口访客头像为在线

		//更新来源
		if(mobile == 1){
			if(curr_guest.children("div").find("u").length <= 0) curr_guest.children("div").prepend("<u></u>");
		}else{
			curr_guest.children("div").find("u").remove();
		}

		return false;
	}

	//来自URL
	if(fromurl){
		fromurl = ". 来自:<br>" + formatOutput(fromurl);
	}else{
		fromurl = "";
	}

	//提示信息
	if(relink === 1){ //指客服重新上线
		var info =  '客服重新上线, 已通知客人';
	}else{
		var info = '客人上线, 问候语已发送' + fromurl;
	}

	var lang_str = "";
	if(!lang) lang_str = "<dd>En</dd>"; //来自英文

	//创建新访客
	guest_list.push(gid);
	guestNumUpdate(); //更新访客人数统计显示

	titleSound(); //仅当是新客人时: 闪烁标题和声音

	var guestHtml = '<div onclick="selectGuest(' + gid + ');" id="gst_' + gid + '" class="g" title="' + fullname + ' (' + ipzone + ')" lang="' + lang + '"><div>' + ((mobile == 1)? '<u></u>'  : '') + '<b>1</b>' + lang_str + '</div><s>' + ipzone + '</s><i>' + fullname + '</i><a onclick="deleteGuest(' + gid + ');return false;" class="deletebtn" title="已离线, 可关闭">✕</a><p></p></div>';
	
	//新上线在访客列表前面插入
	guest_online.prepend(guestHtml);

	//创建隐藏的客人DIV
	$(document.body).append('<div id="win_' + gid + '" class="x-win">' + parseRecords(data.re) + '<div class="msg"><div class="i">' + info + '</div></div></div>');

	//第一个访客自动选择
	if(!CurrentId && guest_list.length == 1) selectGuest(gid);
}

//选择访客
function selectGuest(gid){
	guest_msg.focus();

	if(!gid || CurrentId == gid) return false;

	//上传文件时不允许切换访客
	if(file_temp_data){
		popInfo("上传文件中, 不允许切换访客!", 6);
		return false;
	}

	//保存当前访客的对话记录等
	if(CurrentId){
		$("#win_" + CurrentId).html(guest_history.html());
		guest_online.children("#gst_" + CurrentId).removeClass("curr");
	}

	CurrentId = gid; //记录当前正在对话的访客gid
	CurrentUnread = 0; //设置当前访客未读信息为0
	profile＿loaded = 0; //访客信息未加载

	var guest = guest_online.children("#gst_" + gid).addClass("curr");
	var unread = guest.find("b");

	//判断未读是否为0, 且未离线时发送已读信号
	if(isOnline(gid) && parseInt(unread.html())) weliveSend({type: "s_readed", gid: gid});

	unread.html(0).hide(); //清空并隐藏未读信息统计

	var gDiv = $("#win_" + gid); //访客对话记录窗口
	guest_history.html(gDiv.html());
	scrollBottom(guest_history); //滚动到底部
	gDiv.html(""); //清空

	selectPhrase(guest.attr("lang")) //切换中英快捷回复
	setChatAvatar(gid, isOnline(gid) ? 1 : 0); //设置聊天窗口访客头像状态
}

//设置聊天窗口访客头像状态
function setChatAvatar(gid, status){
	if(CurrentId != gid) return;

	var avatars = guest_history.children(".msg.l").children("u.off");

	if(status){ //设置为在线
		if(avatars.length > 0) avatars.removeClass("off");
	}else{ //离线
		if(avatars.length < 1) guest_history.children(".msg.l").children("u").addClass("off");
	}
}

//判断访客是否在线
function isOnline(gid){
	if($.inArray(gid, offline_list) < 0) return 1;
	return 0;
}

//客人增加信息数
function guestInfoUpdate(gid){
	var o = guest_online.find("#gst_" + gid + ">>b");
	var x = parseInt(o.html()) + 1;

	if(x > 9) x = "9+";

	o.html(x).show();
}

//更新访客人数统计-显示
function guestNumUpdate(){
	total_guests.html(guest_list.length);
}

//删除客人并清除信息
function deleteGuest(gid){
	//阻止冒泡, 否则会选择为当前访客
	var e = window.event || arguments.callee.caller.arguments[0];
	e.preventDefault();
	e.stopPropagation();

	gid = parseInt(gid);
	if(!gid) return false;

	$('#win_'+gid).remove(); //清除窗口

	guest_online.children('#gst_' + gid).remove(); //更新列表
	guest_list.splice($.inArray(gid, guest_list), 1); //删除访客数组中的元素
	offline_list.splice($.inArray(gid, offline_list), 1); //删除离线数组中的元素
	guestNumUpdate(); //更新访客人数统计显示

	//当前访客
	if(CurrentId == gid){
		guest_history.html("");
		CurrentId = 0;
	}
}

//闪烁标题和声音
function titleSound(){
	flashTitle();
	if(welive.sound) sounder.html(welive.mp3);
}

//客人实时输入状态
function guestRuntime(gid, msg){
	if(!gid || !msg || gid != CurrentId) return;

	msg = formatOutput(msg) + ' <img src="' + SYSDIR + 'public/img/writting.gif">';

	var updating = guest_history.children("div.updating");

	if(updating.length){
		updating.children("div").html(msg); //之前存在
	}else{
		msg = '<div class="msg l updating"><u></u><div>' + msg + '</div></div>';
		guest_history.append(msg);
	}

	scrollBottom(guest_history); //滚动到底部 
}

//客人窗口输出信息
function guestOutput(d, gid, type){
	if(!d || !gid || !type) return; //没有信息及类型返回

	d = formatOutput(d);

	switch(type){
		case 1: //客服
			d = '<div class="msg r"><u><img src="' + SYSDIR + 'avatar/' + admin.av + '"></u><div>' + d + '</div><b>' + getLocalTime() + '<br><s class="un">未读</s></b></div>';
			break;
		case 2: //客人
			titleSound(); //闪烁标题和声音
			d = '<div class="msg l"><u></u><div>' + d + '</div><b>' + getLocalTime() + '</b></div>';
			break;
		case 4: //错误提示信息
			d = '<div class="msg"><div class="i red">' + d + '</div></div>';
			break;
		default: //一般信息提示
			d = '<div class="msg"><div class="i">' + d + '</div></div>';
			break;
	}

	if(CurrentId == gid){ //当前访客
		if(type != 1 && type != 5) guest_history.children("div.updating").remove(); //删除输入状态

		if(type == 2){
			CurrentUnread += 1; //标记当前用户有未读消息
			new_info.html(CurrentUnread).show();
		}

		guest_history.append(d);
		scrollBottom(guest_history); //滚动到底部 
	}else{
		$("#win_" + gid).append(d);
		if(type == 2) guestInfoUpdate(gid); //增加未读消息数量
	}

	//在线时, 移动到列表顶部
	if((type == 1 || type == 2) && isOnline(gid)){
		var cur_g = guest_online.children('#gst_' + gid); //当前访客
		var prev_g = cur_g.prev(); // 获取当前节点的上一个节点

		if(prev_g.length > 0){
			guest_online.children(":first").before(cur_g);
		}
	}
}

//客服交流输出信息
function weliveOutput(d, gid, type){
	if(gid){
		guestOutput(d, gid, type);
	}else{
		if(d === false) return; //没有信息返回

		s_history.append(d);
		scrollBottom(s_history); //滚动到底部
		sChatUpdate(); //收拢时更新未读数量
	}
}

//客服连接验证
function weliveVerify(){
	welive.status = 1;
	weliveSend({type: "login", from: "backend", session_id: admin.sid, agent: admin.agent, admin_id: admin.aid, mobile: 0});

	//将挂起及解除挂起按钮恢复
	$(".set_serving").hide();
	$(".set_busy").show();
}

//连接断开时执行
function weliveClose(){
	if(welive.status){ //断线重连
		s_online.html(""); //客服在线列表
		s_admins.html(0); //客服在线人数
		welive.aix = 0; //客服连接索引

		CurrentId = 0; //无正在对话的客人
		CurrentUnread = 0; //是否有未读信息
		profile＿loaded = 0; //访客信息未加载
		guest_list = new Array(); //访客数组
		offline_list = new Array(); //访客数组
		guest_online.html(""); //客人在线列表
		guest_history.html(""); //访客信息输出窗口
		guestNumUpdate(); //更新访客人数
		closeProfile(); //关闭访客备注信息
		$(".x-win").remove(); //所有客人小窗口
	}

	welive.status = 0;
	clearInterval(ttt_1); //连接断开后停止发送心跳数据

	//允许重新连接
	if(welive.autolink){
		weliveOutput('<div class="i"><b></b>连接失败, 3秒后自动重试 ...</div>');
		welive.ttt = setTimeout(weliveLink, 3000);
	}
}

//发送信息(直接)
function weliveSend(d){
	var re = 0;

	if(welive.status) {
		re = 1;
		welive.ws.send(JSON.stringify(d)); //将json对象转换成字符串发送
	}else{
		popInfo("未就绪!");
	}

	return re; //回返是否成功
}

//点击上传图片或文件给客人(必须在线)
function doUpload(){
	if(welive.status && CurrentId && isOnline(CurrentId)){
		popInfo('免费版无此功能!', 3);
	}else{
		popInfo("未就绪!");
	}

	return false;
}


//授权上传文件
function guestAuthUpload(){
	if(!welive.status || !CurrentId){
		popInfo("未就绪!");
		return;
	}

	popInfo('免费版无此功能!', 3);

	$("#tiptip_holder").hide();
	guest_msg.focus();
}

//获取当前客人数据
function getProfile(me){
	if(!CurrentId){
		popInfo("未选择访客!");
		return;
	}

	var btn = $(me);

	if(guest_profile.is(":hidden")){
		if(profile＿loaded) {
			guest_profile.show();
			btn.addClass("hover");

			return;
		}

		weliveSend({type: "s_handle", operate: "get_guest", guestid: CurrentId}); //发送客人数据请求
	 }else{
		guest_profile.hide();
		btn.removeClass("hover");
	 }
}

//保存当前客人数据
function saveGuest(me){
	var arr = $(me).closest("form").serializeArray();
	var obj = {};
	
	//将数据转换成对象
	$.each(arr, function(index, field){
		obj[field.name] = field.value;
	});

	weliveSend({type: "s_handle", operate: "save_guest", guestid: CurrentId, msg: obj});
}

//关闭客人数据层
function closeProfile(){
	guest_profile.hide();
	$('.t_profile').removeClass("hover");
	return false;
}

//获得在线客服列表(转接访客)
function getSupporter(){
	var transfer = $('.s_transfer');

	if(!CurrentId){
		transfer.html("<font class=red>未选择访客</font>");
		return;
	}

	if($.inArray(CurrentId, offline_list) > -1){
		transfer.html("<font class=red>此客人已离线, 无法转接");
		return;
	}

	var num = 0;

	transfer.html(s_online.html()).children('li').each(function() {
		var aix = $(this).attr('id');

		if(admin.aix == aix || aix == "robot818"){
			$(this).remove(); //去掉自己或机器人
			return;
		}

		num += 1;
			
		$(this).click(function(){
			$("#tiptip_holder").hide();

			if(CurrentId && $.inArray(CurrentId, offline_list) < 0){
				weliveSend({type: "s_handle", operate: "trans_guest", guestid: CurrentId, aix: aix}); //发送转接请求
			}else{
				popInfo("此客人已离线, 无法转接!");
			}
		});
	});

	if(!num) transfer.html("<font class=red>暂无其他客服在线</font>");
}

//禁止发言
function guestBanned(){
	$("#tiptip_holder").hide();

	if(CurrentId){
		showDialog('确定禁言此访客吗?<br>注: 一旦禁言, 需要管理员才能解除其禁言状态', '禁言访客', function(){
			weliveSend({type: "s_handle", operate: "banned", guestid: CurrentId, ban: 1}); //禁止发言
			guestOutput('此客人已被禁言, 但你仍可以对其发言', CurrentId, 4);	
		});
	}else{
		popInfo("未选择访客!");
	}
}

//踢出客人
function guestKickout(){
	$("#tiptip_holder").hide();

	if(!CurrentId){
		popInfo("未选择访客!");
		return;
	}

	if(isOnline(CurrentId)){
		showDialog('当前访客仍在线，确定关闭他吗?', '关闭访客', function(){
			weliveSend({type: "s_handle", operate: "kickout", guestid: CurrentId}); //客人在线, 发送踢出请求
			deleteGuest(CurrentId);
		});
	}else{
		deleteGuest(CurrentId);
	}
}

//撤回最后一条消息
function drawBack(){
	if(!welive.status || !CurrentId || file_temp_data){
		popInfo("未就绪"); //上传文件过程中不允许撤回
		return;
	}

	weliveSend({type: "s_handle", operate: "draw_back", guestid: CurrentId}); //发送撤回指令

	$("#tiptip_holder").hide();
	guest_msg.focus();
}

//设置发送信息按钮模式
function setSendMod(mod, me){
	if(mod == send_btn_mod) return;
	send_btn_mod = mod;
	$(me).parent().children().removeClass("curr_send_mod").eq(mod).addClass("curr_send_mod");

	if(send_btn_mod == 1){
		s_msg.attr("placeholder", "Enter: 发送");
		guest_msg.attr("placeholder", "Enter: 发送");
	}else{
		s_msg.attr("placeholder", "Ctrl + Enter: 发送");
		guest_msg.attr("placeholder", "Ctrl + Enter: 发送");
	}
	setCookie(COOKIE_KEFU + "_SBM", mod, 1000);
}

//插入快捷回复(常用短语)
function insertPhrase(me) {
	if(welive.isSlider) return;

	var del_btn = $(me).children("b");
	del_btn.remove(); //去掉删除标志

	var phrase = recoverHtml($(me).html());
	phrase = $.trim(phrase.replace(/<br>/ig, '\n'));
	if(!phrase) return;

	var obj = guest_msg[0];
	var selection = document.selection;
	obj.focus();

	if(typeof obj.selectionStart != 'undefined') {
		var opn = obj.selectionStart + 0;
		obj.value = obj.value.substr(0, obj.selectionStart) + phrase + obj.value.substr(obj.selectionEnd);
	} else if(selection && selection.createRange) {
		var sel = selection.createRange();
		sel.text = phrase;
		sel.moveStart('character', -phrase.length);
	} else {
		obj.value += phrase;
	}

	$(me).append(del_btn); //恢复删除标志
}

//滑动切换中英快捷回复
function togglePhrase(direction){
	if(s_phrases_cn.is(":hidden")){
		s_phrases_en.hide();
		if(direction == "left"){
			s_phrases_cn.css({"left": "100%"}).show().animate({left:0}, 300);
		}else{
			s_phrases_cn.css({"right": "100%"}).show().animate({right:0}, 300);
		}
	}else{
		s_phrases_cn.hide();
		if(direction == "left"){
			s_phrases_en.css({"left": "100%"}).show().animate({left:0}, 300);
		}else{
			s_phrases_en.css({"right": "100%"}).show().animate({right:0}, 300);
		}
	}
}

//根据语言切换快捷回复
function selectPhrase(lang){
	if(parseInt(lang)){
		s_phrases_en.hide();
		s_phrases_cn.show();
	}else{
		s_phrases_cn.hide();
		s_phrases_en.show();
	}
}

//添加快捷回复
function addPhrase(){
	var lang = 1;
	if(s_phrases_cn.is(":hidden")) lang = 0;

	var obj = $("#sp_phrase_msg");
	obj.focus();

	var msg = $.trim(obj.val());

	if(msg){
		if(weliveSend({type: "s_handle", operate: "save_phrase", del: 0, lang: lang, msg: msg})) obj.val("");
	}else{
		popInfo("未输入快捷回复内容!");
	}
}

//删除快捷回复
function deletePhrase(me, pid){
	var e = window.event || arguments.callee.caller.arguments[0];
	e.preventDefault();
	e.stopPropagation();

	easyDialog.open({
		container:{
			header: "<font color=#FF9900>操作确认</font>",
			content: "<font color=red>确定删除此条快捷回复吗？</font>",
			yesFn: function(){
				weliveSend({type: "s_handle", operate: "save_phrase", del: 1, pid: pid});
				$(me).parent().fadeOut(600, function(){$(this).remove();});
			},
			yesText: '确定',
			noFn:true,
			noText: '取消'
		},
		autoClose: 8000,
		overlay: false,
		follow: me,
		followX: -160,
		followY: -160
	});
}

//设置访客信息提示音
function setSound(num, me){
	welive.mp3 = '<audio src="' + SYSDIR + 'public/mp3/kefu-' + num + '.mp3" autoplay="autoplay"></audio>';
	sounder.html(welive.mp3);
	sound_num = num;
	$(me).parent().children("i").removeClass("curr");
	$(me).addClass("curr");
	setCookie(COOKIE_KEFU, num, 1000);
}

//welive初始化
function weliveInit(){
	guest_list = new Array(); //所有访客gid数组
	offline_list = new Array(); //离线访客gid数组

	guest_online = $("#g88");
	sounder = $("#wl_sounder");
	total_guests = $(".total_guests");
	guest_history = $("#guest_history"); //访客信息输出窗口
	guest_send = $("#guest_send");
	guest_profile = $("#guest_profile");
	new_info = $("#new_info");

	s_history = $("#sp_history");
	s_online = $("#sp_list");
	s_admins = $("#sp_num");
	s_send = $("#sp_send");
	s_chat_num = $("#s_chat_num");
	s_phrases_cn = $("#sp_phrases_cn");
	s_phrases_en = $("#sp_phrases_en");

	pagetitle = document.title;

	//socket连接服务器
	weliveLink();

	//客服群聊Ctrl + Enter发送
	s_msg.keydown(function(e){
		var e = e||event, keyCode=e.keyCode||e.which||e.charCode;
		if((send_btn_mod == 0 && e.ctrlKey && keyCode == 13) || (send_btn_mod == 1 && keyCode == 13)){
			e.preventDefault();
			s_send.trigger("click");
		}
	});

	//客服群聊发送
	s_send.click(function(e) {
		var msg = $.trim(s_msg.val());

		if(msg){
			if(weliveSend({type: "msg", sendto: "team", msg: msg})) s_msg.val('');
		}else{
			popInfo("未输入!");
		}

		s_msg.focus();
		e.preventDefault();
	});

	//访客Ctrl + Enter发送
	guest_msg.keydown(function(e){
		var e = e||event, keyCode=e.keyCode||e.which||e.charCode;
		if((send_btn_mod == 0 && e.ctrlKey && keyCode == 13) || (send_btn_mod == 1 && keyCode == 13)){
			e.preventDefault();
			guest_send.trigger("click");
		}
	});

	//访客发送
	guest_send.click(function(e) {
		var msg = $.trim(guest_msg.val());

		//对话中且访客未断线时才能发信息
		if(msg && CurrentId){
			if(weliveSend({type: "msg", sendto: "front", gid: CurrentId, msg: msg})) guest_msg.val('');
		}else if(!CurrentId){
			popInfo("未选择访客!");
		}else{
			popInfo("未输入!");
		}

		guest_msg.focus();
		e.preventDefault();
	});

	//客服群聊区和快捷回复切换
	$(".toggle_btn").click(function(e) {
		if($(this).hasClass("curr")) return false;

		var a = $(this).attr("for");

		if(a == 2){
			var b = 1;
			s_chat_isopen = 0;
		}else{
			var b = 2;
			s_chat_isopen = 1;
			s_chat_num.html(0).hide();
		}

		$(".toggle_btn").removeClass("curr");
		$(this).addClass("curr");

		$("#div_for_btn" + a).show();
		$("#div_for_btn" + b).hide();

		if(a == 1) scrollBottom(s_history);
	});

	var smilies_div = $(".smilies_div");

	//客服表情符号
	$(".sp_face").tipTip({content: smilies_div.html().replace(/4040/ig, 0), keepAlive:true, maxWidth:"292px", defaultPosition:"top", edgeOffset:-38, delay:300});

	//访客表情符号
	$(".t_smilies").tipTip({content: smilies_div.html(), keepAlive:true, maxWidth:"292px", defaultPosition:"top", left: 122, arrowLeft: -122, edgeOffset:6, delay:300, hoverClass: "hover"});
	smilies_div.remove(); //原div清除

	//转接客人
	$(".t_transfer").tipTip({content: '<div class="sp_list scroll s_transfer"></div>', enter: function(){getSupporter();}, activation:"click", keepAlive:true, maxWidth:"420px", defaultPosition:"top", edgeOffset:6, delay:0, hoverClass: "hover"});

	//授权访客上传文件(不含图片)
	$(".t_auth").tipTip({content: '<input class="save" type="submit" value="授权访客上传文件" onclick="guestAuthUpload();return false;">', keepAlive:true, defaultPosition:"top", edgeOffset:6, delay:300, hoverClass: "hover"});

	//禁言按钮
	$(".t_ban").tipTip({content: '<input class="save" type="submit" value="禁言此访客" onclick="guestBanned();return false;">', keepAlive:true, defaultPosition:"top", edgeOffset:6, delay:300, hoverClass: "hover"});

	//关闭(踢出)
	$(".t_close").tipTip({content: '<input class="save" type="submit" value="关闭此访客" onclick="guestKickout();return false;">', keepAlive:true, defaultPosition:"top", edgeOffset:6, delay:300, hoverClass: "hover"});

	//切换信息发送方式
	$("#send_mod_btn").tipTip({content: $("#send_mod_div").html(), enter: function(){$("#tiptip_content").children().eq(send_btn_mod).addClass("curr_send_mod");}, keepAlive:true, maxWidth:"300px", defaultPosition:"top", delay:300});

	//挂起, 解除挂起提示
	$(".set_busy").tipTip({content: '1. 挂起后, 将不再接受新客人加入<br>2. 特别忙或暂时离开座席时, 可使用挂起功能<br>3. 同组的在线客服都挂起了, 挂起功能将失效', keepAlive:true, maxWidth:"300px", defaultPosition:"bottom", delay:800});
	$(".set_serving").tipTip();

 	//无人值守
	$(".set_robot_on").tipTip({content: '1. 每个客服组的无人值守状态均为独立设置, 互不影响<br>2. 无人值守开启后, 所有本组客服均可离线<br>3. 无人值守开启后, 新上线的访客将由机器人自动回复<br>4. 无人值守开启后, 已登录的客服可接受来自机器人转接人工<br>&nbsp;&nbsp;&nbsp;&nbsp;客服而来的客人<br>5. Workerman重启后, 无人值守状态需要重新设置', keepAlive:true, delay:800});

	//撤回按钮
	$("#draw_back").tipTip({content: '<input class="save" type="submit" value="撤回最后一条" onclick="drawBack();return false;">', keepAlive:true, defaultPosition:"top", edgeOffset:6, delay:300, hoverClass: "hover"});

	//中英快捷回复左右滑动切换
	initSlider(s_phrases_cn, togglePhrase);
	initSlider(s_phrases_en, togglePhrase);

	//停止页面标题闪烁、禁止刷新
	$(document).mousedown(stopFlashTitle).keydown(function(e){
		var e = e||event, keyCode=e.keyCode||e.which||e.charCode;
		stopFlashTitle();

		//有访客在线时禁止F5, ctrl或shift + F5或R键刷新
		if(guest_list.length > 0 && (guest_list.length - offline_list.length) > 0 && (keyCode == 116 || ((e.ctrlKey || e.shiftKey) && (keyCode == 82 || keyCode == 116))) ){
			popInfo("有访客在线，请勿刷新页面！");
			e.returnValue = false;
			e.cancelBubble = true;
			e.keyCode = e.which = e.charCode = 0;
			e.preventDefault();
			return false;
		}
	});

	//状态正常时, 离开当前页面时提示选择及动作
	window.onbeforeunload=function(event){
		if(welive.status){
			return " ";
		}else{
			welive.status=0;clearTimeout(welive.ttt);clearInterval(ttt_1);clearInterval(tttt);
		}		
	};

	$(window).unload(function(){welive.status=0;clearTimeout(welive.ttt);clearInterval(ttt_1);clearInterval(tttt);});

	//每20分钟清除过长的客服间对话记录
	setInterval(teamChatClear, 1000*1200);

	//访客信息声音选择
	var mp3_div = $(".mp3_div");
	$(".t_sound").tipTip({content: mp3_div.html(), enter: function(){$("#tiptip_content").find("i").eq(sound_num -1).addClass("curr");}, keepAlive:true, maxWidth:"350px", defaultPosition:"top", edgeOffset:6, delay:800, hoverClass: "hover"});
	mp3_div.html(""); //原div清除
}

//websocket
var WebSocket = window.WebSocket || window.MozWebSocket;

//定义全局变量
var tttt = 0, ttt_1 = 0, ttt_2 = 0, pagetitle, flashtitle_step = 0, sounder, sound_num, sending_mask, send_btn_mod = 0;
var s_chat, s_msg, s_history, s_online, s_send, s_admins, s_chat_num, s_phrases_cn, s_phrases_en, s_chat_isopen = 1;
var guest_list, offline_list, total_guests, guest_online, guest_send, guest_msg, guest_history, guest_profile, profile＿loaded = 0, new_info, CurrentId = 0, CurrentUnread = 0;
var welive = {ws:{}, ttt: 0, aix: 0, status: 0, sound: 1, autolink: 1, mp3: '', isSlider: 0};

var file_chunk_size = 1048576; //切片大小 默认为1M
var file_temp_data = ""; //切片上传文件时使用

//页面加载完成
$(function(){
	if(WS_HOST == "")	WS_HOST = document.domain; //先记录下来供websocket连接使用

	//访客信息提示音
	sound_num = parseInt(getCookie(COOKIE_KEFU));
	if(!sound_num) sound_num = 1;
	welive.mp3 = '<audio src="' + SYSDIR + 'public/mp3/kefu-' + sound_num + '.mp3" autoplay="autoplay"></audio>';

	s_msg = $("#sp_msg");
	guest_msg = $("#guest_msg");

	//初始化发送按钮模式
	send_btn_mod = getCookie(COOKIE_KEFU + "_SBM");
	if(!send_btn_mod) send_btn_mod = 0;
	if(send_btn_mod == 1) {
		s_msg.attr("placeholder", "Enter: 发送");
		guest_msg.attr("placeholder", "Enter: 发送");
	}

	weliveInit(); //welive初始化

	$("#topbar dl").Jdropdown({delay: 50}, function(a){});

	//退出登录
	$(".logout").click(function(e) {
		showDialog('确定退出 WeLive 在线客服系统?', '', function(){
			document.location = 'index.php?a=logout';
		});

		e.preventDefault();
	});


});