
/* WeLive mobile.js  @Copyright weensoft.cn */

//弹出消息
function popInfo(info, sec){
	if(sec){
		layer.msg(info, {time: sec * 1000});
	}else{
		layer.msg(info);
	}
}

//显示大图片
function showImage(me, width, height){
	var popup = $("#welive_big_img");
	var window_width =$(window).width();
	var window_height =$(window).height();

	var new_w = 1, new_h = 1, new_top = 0, new_left = 0;

	if(window_height < 1) window_height = 1;

	if(width/height >= window_width/window_height){
		new_w = width;
		if(new_w > window_width) new_w = window_width;
		new_h = height * new_w / width;
	}else{
		new_h = height;
		if(new_h > window_height) new_h = window_height;
		new_w = width * new_h / height;
	}

	new_w = parseInt(new_w);
	new_h = parseInt(new_h);

	new_left = parseInt((window_width - new_w)/2);
	new_top = parseInt((window_height - new_h)/2);

	//点击或者触控弹出层外的半透明遮罩层, 关闭弹出层
	popup.bind("click",  function(e) {
		popup.hide();
		$(this).unbind("click");
	});

	popup.children('.big_img_wrap').css({top: new_top, left: new_left, width: new_w, height: new_h}).html('<img src="' + me.src + '" style="width: ' + new_w + 'px;height: ' + new_h + 'px;">');
	popup.fadeIn(200);
}

//JQ闪动特效  ele: JQ要闪动的对象; cls: 闪动的类(className); times: 闪动次数
function eleShake(ele, cls, times){
	var i = 0, t = false, o = ele.attr("class")+" ", c = "", times = times||3;
	if(t) return;
	t= setInterval(function(){
		i++;
		c = i%2 ? o+cls : o;
		ele.attr("class",c);
		if(i==2*times){
			clearInterval(t);
			ele.removeClass(cls);
		}
	},200);
}

//滚动到底部
function scrollBottom(){
	historier.scrollTop(20000); //滚动到底部
}

//Ajax封装
var ajax_isOk = 1;
function ajax(url, send_data, callback) {
	if(!ajax_isOk) return false;
	$.ajax({
		url: url,
		data: send_data,
		type: "post",
		cache: false,
		dataType: "json",
		beforeSend: function(){ajax_isOk = 0;},
		complete: function(){ajax_isOk = 1;},
		success: function(data){
			if(callback)	callback(data);
		},
		error: function(XHR, Status, Error) {
			welive.status = 1;
			file_temp_data = "";
			popInfo('ajax error!', 8);
		}
	});
}

//设置cookie
function setCookie(n,val,d) {
	var e = "";
	if(d) {
		var dt = new Date();
		dt.setTime(dt.getTime() + parseInt(d)*24*60*60*1000);
		e = "; expires="+dt.toGMTString();
	}
	document.cookie = n+"="+val+e+"; path=/";
}

//获取cookie
function getCookie(n) {
	var a = document.cookie.match(new RegExp("(^| )" + n + "=([^;]*)(;|$)"));
	if (a != null) return a[2];
	return '';
}

//将json数据转换成json对象
function parseJSON(data) {
	if(window.JSON && window.JSON.parse) return window.JSON.parse(data);
	if(data === null) return data;
	if(typeof data === "string") {
		data = $.trim(data);
		if(data) {
			var rvalidchars = /^[\],:{}\s]*$/,
				rvalidbraces = /(?:^|:|,)(?:\s*\[)+/g,
				rvalidescape = /\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,
				rvalidtokens = /"[^"\\\r\n]*"|true|false|null|-?(?:\d+\.|)\d+(?:[eE][+-]?\d+|)/g;

			if(rvalidchars.test(data.replace(rvalidescape, "@").replace(rvalidtokens, "]").replace(rvalidbraces, ""))) {
				return (new Function("return " + data))();
			}
		}
	}
	return false;
}

//获得计算机当前时间
function getLocalTime() {
	var date = new Date();

	function addZeros(value, len) {
		var i;
		value = "" + value;
		if (value.length < len) {
			for (i=0; i<(len-value.length); i++)
				value = "0" + value;
		}
		return value;
	}
	return addZeros(date.getHours(), 2) + ':' + addZeros(date.getMinutes(), 2) + ':' + addZeros(date.getSeconds(), 2);
}

//格式化输出信息
function formatOutput(data) {
	//生成URL链接
	data = data.replace(/((((https?|ftp):\/\/)|www\.)([\w\-]+\.)+[\w\.\/=\?%\-&~\':+!#;]*)/ig, function($1){return getURL($1);});
	//将表情代码换成图标路径
	data = data.replace(/\[:(\d*):\]/g, '<img src="' + SYSDIR + 'public/smilies/$1.png">').replace(/\\n/g, '<br>').replace(/\n/g, '<br>');
	return data;
}

//格式化生成URL
function getURL(url, limit) {
	if(!limit) limit = 60;
	var urllink = '<a href="' + (url.substr(0, 4).toLowerCase() == 'www.' ? 'http://' + url : url) + '" target="_blank" title="' + url + '">';
	if(url.length > limit) {
		url = url.substr(0, 30) + ' ... ' + url.substr(url.length - 18);
	}
	urllink += url + '</a>';
	return urllink;
}

//插入表情符号
function insertSmilie(code) {
	code = '[:' + code + ':]';
	var obj = msger[0];

	var selection = document.selection;
	if(typeof obj.selectionStart != 'undefined') {
		var opn = obj.selectionStart + 0;
		obj.value = obj.value.substr(0, obj.selectionStart) + code + obj.value.substr(obj.selectionEnd);
	} else if(selection && selection.createRange) {
		var sel = selection.createRange();
		sel.text = code;
		sel.moveStart('character', -code.length);
	} else {
		obj.value += code;
	}
}

//重连按钮动作
function weliveRelink(me){
	weliveLink();
	$(me).parents('.msg').remove();
	return false;
}

//设置为默认头像
function setDefaultAvatar(){
	welive_op.find("#welive_avatar").attr("src", SYSDIR + "public/img/welive.png");
	welive_op.find("#welive_name").html(langs.welive);
	welive_op.find("#welive_duty").html(langs.notready);
}

//socket连接
function weliveLink(){
	welive.ws = new WebSocket(WS_HEAD + WS_HOST + ':'+ WS_PORT);

	welive.ws.onopen = function(){
		welive.linked = 1; //websocket连接成功
		welive.closeQuiet = 1; //连接成功后, websocket连接断开时不显示: 连接失败，请稍后重试
		setTimeout(function(){weliveVerify();}, 100); //连接成功后, 小延时再验证用户, 否则IE下刷新时发送数据失败
	};

	welive.ws.onclose = function(){weliveClose();};
	welive.ws.onmessage = function(get){weliveParseOut(get);};
}


//记住访客id, 上传session会话
function rememberGuest(gid, sess){
	gid = parseInt(gid);

	if(!guest.gid || guest.gid != gid){
		guest.gid = gid; //更新ID号
		setCookie(COOKIE_USER, gid, 3650); //写cookie
	}

	//产生一个session会话记录, 用于验证上传图片等, 以免产生非法操作
	guest.sess = sess; //解决safari禁止第三方cookie的问题
	setCookie(COOKIE_USER + "_sess", sess, 0); //随进程消失, 上传文件等时首先验证
}


//输出聊天记录
function outputRecords(reArr){
	var recs = '';
	$.each(reArr, function(i, rec){
		var rec_i = formatOutput(rec.m);

		if(rec.t == 1){ //客服的
			if(rec.fid == guest.aid){
				var welive_duty_i = welive_duty;
			}else{
				var welive_duty_i = langs.welive;
			}

			recs += '<div class="msg l"><div class="a">' +  rec.f + ' - ' + welive_duty_i + '<i>' + rec.d + '</i></div><b></b><div class="b"><div class="i">' + rec_i + '</div></div></div>';

		}else{ //自己的

			recs += '<div class="msg r"><b></b><div class="b"><div class="i">' + rec_i + '</div></div><i>' + rec.d + '</i></div>';
		}
	});

	if(recs != '') {
		recs += '<div class="msg s"><div class="b"><div class="i">' + langs.records + '</div></div></div>';
		historier.append(recs); //输出
		scrollBottom(); //滚动到底部
	}
}


//解析数据并输出
function weliveParseOut(get){
	var d = false, type = 0, raw = 0, data = parseJSON(get.data);
	if(!data) return; //没有数据返回

	switch(data.x){

		case 5: //客人与客服文字对话
			if(data.a == 1){ //客服发来的
				welive.playSound = 1;
				type = 1; d = data.i;

			}else{ //自己发出的对话
				type = 2; 
				welive.status = 1; //发送完成允许发送第二条信息

				d = welive.msg.replace(/</g, "&lt;").replace(/>/g, "&gt;"); //防止自己发js代码时发生显示错误
				welive.msg = ''; //清空临时信息

				sender.removeClass('loading1');
			}

			break;

		case 8: //人工客服发来的标记已读信息

			historier.find("s.un").html(langs.readed).removeClass("un");
			return true;

			break;

		case 6: //客人特别操作或返回信息
			switch(data.a){

				case 8: //客人登录成功
					welive.status = 1; //允许发信息
					welive.autolink = 6; //允许自动重连6次

					welive.isRobot = 0; //系统是否为无人值守状态

					guest.fn = data.fn; //客人姓名
					guest.aid = parseInt(data.aid); //更新客服的id, 重新连接时用
					guest.an = data.an; //客服姓名
					guest.au = parseInt(data.au); //上传授权, 强制转成数字1或0, 方便判断, JS里if("0") 是true, php里为false

					 //更新头像及身份
					welive_name = data.an;
					welive_duty = data.p;
					welive_op.find("#welive_avatar").attr("src", SYSDIR + "avatar/" + data.av);
					welive_op.find("#welive_name").html(welive_name);
					welive_op.find("#welive_duty").html(welive_duty);

					historier.removeClass('loading');
					sender.removeClass('loading1');

					welive.playSound = 0; //连接成功后不播放声音, 因为无效
					type = 8; d = welcome;
					raw = 1; //原生的, 不解析html

					outputRecords(data.re); //输出对话记录

					rememberGuest(data.gid, data.sess); //记住访客id, 上传session会话

					autoOffline(); //启动自动离线

					welive.temp = '';
					weliveRuntime(); //非机器人服务时, 启动实时输入状态
					$("#toolbar_transto").hide();

					//启动心跳, 即每隔26秒自动发送一个特殊信息, 解决IE下30秒自动断线的问题
					//设置一个怪异的数字避免与自动离线的时间间隔重合, 避免在同一时间点上send数据时, 可能产生-----幽灵bug
					ttt_1 = setInterval(function() {
						weliveSend({type: "ping"});
					}, 26125);

					break;

				case 1: //客服重新上线
					clearTimeout(welive.ttt2); //清除客服离线时自动转接

					setTwoStatus(1); //状态正常, 允许重连
					welive.playSound = 1;
					type = 3; d = welive_name + langs.aback;

					break;

				case 2: //客服离线
					welive.status = 0;
					welive.playSound = 1;
					type = 4; d = welive_name + langs.offline;

					//1分钟后发送请求重新分配客服的请求
					welive.ttt2 = setTimeout(function(){
						weliveSend({type: "g_handle", operate: "redistribute"});
					}, 59973);

					break;

				case 4: //重复连接
				case 5: //自动离线
					type = 4;
					setTwoStatus(0); //状态未正常, 不允许重连
					d = (data.a == 4 ? langs.relinked : langs.autooff) + '<br><a onclick="return weliveRelink(this);" class="relink">' + langs.rebtn + '</a>';
					setDefaultAvatar(); //设为初始头像

					break;

				case 6: //被踢出
					setTwoStatus(0);
					type = 4; d = langs.kickout;
					setDefaultAvatar(); //设为初始头像

					break;

				case 7: //被禁言
					setTwoStatus(0);

					welive.playSound = 1;
					type = 4; d = langs.banned;

					break;

				case 9: //无客服在线 或 客服组不存在或关闭时 或 禁言中
					setTwoStatus(0);
					type = 4;
					d = langs.nosuppert; //客服不在线

					if(data.i == "nogroup"){
						d = langs.team_off; //客服组不存在或关闭
					}else if(data.i == "banned"){
						d = langs.banned; //禁言中
					}

					setDefaultAvatar(); //设为初始头像

					break;

				case 11: //被转接
					setTwoStatus(1);

					welive.isRobot = 0; //系统是否为无人值守状态

					guest.aid = data.aid; //更新客服的id, 重新连接时用
					guest.an = data.an; //客服姓名
					guest.au = parseInt(data.au); //上传权限

					 //更新头像及身份
					welive_name = data.an;
					welive_duty = data.p;

					welive_op.find("#welive_avatar").attr("src", SYSDIR + "avatar/" + data.av);
					welive_op.find("#welive_name").html(welive_name);
					welive_op.find("#welive_duty").html(welive_duty);

					welive.temp = '';
					weliveRuntime(); //启动实时输入状态
					$("#toolbar_transto").hide();

					welive.playSound = 1;
					type = 4; d = langs.transfer + data.an;

					break;

				case 14: //评价返回
					if(data.s == "1"){
						welive.playSound = 1;
						type = 1; d = '<font color=red>' + langs.rating_thanks + '</font>[:16:]';
					}else{
						popInfo(langs.rating_limit, 6);
						return false;
					}

					break;
			}

			break;

		case 7: //其它
			switch(data.a){

				case 9: //客服撤回一条消息

					type = 3; d = langs.draw_back;
					historier.find(".msg.l:last").remove();

					break;
			}

			break;
	}

	weliveOutput(d, type, raw); //输出
}

//交流输出信息, raw为true时不解析html
function weliveOutput(d, type, raw){
	if(d === false || !type) return; //没有信息及类型返回

	if(welive.playSound){  //发声音
		playSound();
		welive.playSound = 0;
	}

	switch(type){
		case 1: //客服
		case 8: //问候语, 信息不解析(支持html), 不计数
			if(type == 1){
				welive.unread += 1; //有未读信息
				new_info.html(welive.unread).show();
			}

			d = '<div class="msg l"><div class="a">' + welive_name + ' - ' + welive_duty + '<i>' + getLocalTime() + '</i></div><b></b><div class="b"><div class="i">' + (raw ? d : formatOutput(d)) + '</div></div></div>';
			break;

		case 2: //客人
			d = '<div class="msg r"><b></b><div class="b"><div class="i">' + (raw ? d : formatOutput(d)) + '</div></div><i>' + getLocalTime() + '<br><s class="un">' + langs.unread + '</s></i></div>';
			break;
		case 3: //正常提示
			d = '<div class="msg s"><div class="b"><div class="i">' + d + '</div></div></div>';
			break;
		case 4: //错误提示
			d = '<div class="msg e"><div class="b"><div class="i">' + d + '</div></div></div>';
			break;
	}

	historier.append(d);

	scrollBottom(); //滚动到底部
}

//设置welive的两个状态
function setTwoStatus(option){
	if(option){
		welive.status = 1; //状态正常, 可以送消息
		welive.autolink = 1; //允许重连
	}else{
		welive.status = 0;
		welive.autolink = 0;
	}
}

//播放声音(force强制播放)
function playSound(force) {
	if(!welive.sound && !force) return;
		
	welive_sounder.src = SYSDIR + "public/sound_m.mp3";
	welive_sounder.play();
}

//访客连接验证
function weliveVerify(){
	weliveSend({type: "login", from: "front", gid: guest.gid, grid: guest.grid, oid: guest.oid, fn: guest.fn, au: guest.au, aid: guest.aid, lang: guest.lang, key: SYSKEY, code: SYSCODE, fromurl: guest.fromurl, agent: guest.agent, mobile: 1});
}

//连接断开时执行
function weliveClose(){
	welive.linked = 0; //标记连接失败
	clearTimer(); //清理定时器

	sender.addClass('loading1');

	//允许重连时
	if(welive.autolink > 0){
		welive.closeQuiet = 0;
		welive.autolink -= 1;
		weliveOutput(langs.relink, 4);
		setTimeout(function(){weliveLink();}, 6000); //6秒后自动重连
		return false;
	}

	//不允许重连时
	historier.removeClass('loading');
	if(welive.closeQuiet){
		welive.closeQuiet = 0;
	}else{
		weliveOutput(langs.failed, 4);
	}
}

//离开页面或断线时清理定时器
function clearTimer(){
	welive.status=0;
	clearTimeout(welive.ttt); //自动离线
	clearTimeout(welive.ttt2); //客服离线时自动转接
	clearInterval(ttt_1); //发送心跳数据
	clearInterval(ttt_2); //上传进度条
	clearInterval(ttt_6); //实时输入状态
}

//发送信息(直接)
function weliveSend(d){
	var re = 0;

	if(welive.linked){
		re = 1;
		welive.ws.send(JSON.stringify(d)); //将json对象转换成字符串发送
	}else{
		popInfo(langs.notready);
	}

	return re; //回返是否成功
}

//发送输入框文本
function weliveSendMsg(){
	window.scrollTo(0,0); //兼容iphone微信浏览器输入框的bug

	if(welive.status) {
		var msg = $.trim(msger.val());

		if(msg){
			if(msg.length > 2048){
				popInfo(langs.msg_too_long);
				return false;
			}

			welive.temp = ''; //终止实时输入提交数据
			sender.addClass('loading1');
			welive.msg = msg; //先记录客人的发言

			msg = {type: "msg", sendto: "back", msg: msg};
			if(!weliveSend(msg)) return false;

			welive.status = 0; //发送后，改变状态避免未完成时发送第二条信息
			autoOffline(); //信息发送完成后, 自动离线计时开始
		}else{
			popInfo(langs.notinput);
		}

		msger.val('');

		//校正相关元素的高度(恢复)
		var def = original_scrollHeight - new_scrollHeight;

		if(def != 0){
			ajustPage(def); //校正相关元素
			msger.height(original_height); //输入框恢复高度
			new_scrollHeight = original_scrollHeight;
		}

	}else{
		popInfo(langs.notready);
	}

	closeDialogs();
	searchResultHide(); //关闭搜索结果
}

//自动离线
function autoOffline(){
	if(!welive.linked) return; //未连接不自动离线
	if(welive.ttt) clearTimeout(welive.ttt);//清除自动离线

	welive.ttt = setTimeout(function(){
		weliveSend({type: "g_handle", operate: "offline"});
	}, offline_time);
}

//启动输入状态更新
function weliveRuntime(){
	ttt_6 = setInterval(function(){
		if(welive.status) {
			var msg = $.trim(msger.val());

			if(msg && msg != welive.temp){

				weliveSend({type: "runtime", msg: msg});
				welive.temp = msg; //记录正在输入的信息

			//清空输入框后, 给客服发通知, 去掉输入状态
			}else if(!msg && welive.temp){

				weliveSend({type: "runtime", msg: ""});
				welive.temp = '';
			}
		}

	}, update_time);
}


//发送服务评价
function sendEvaluate(){
	if(!welive.linked){
		closeDialogs();
		popInfo(langs.notready);
		return false;
	}

	if(rating_star == 0){
		popInfo(langs.select_star);
		return false;
	}

	closeDialogs();
	var msg = $.trim($("#rating_advise").val());

	if(msg.length > 600){
		popInfo(langs.too_long);
		return false;
	}

	weliveSend({type: "g_handle", operate: "rating", star: rating_star, msg: msg});
}

//关闭所有小对话窗口
function closeDialogs(){
	smilies_div.hide();
	star_rating.hide();

	$("#toolbar_emotion").removeClass("emotion_hover");
	$("#toolbar_evaluate").removeClass("evaluate_hover");
}

//解决无法自动播放声音的问题
function firstPay(){
	playSound("force"); //强制播放一下, 解除播放限制
	document.body.removeEventListener("touchend", firstPay);
}

//插入常见问题
function insertQuestion(me) {
	var code = $(me).children("b").text();

	msger.val(code);
	searchResultHide();
}

//关闭觉见问题搜索结果
function searchResultHide(){
	if(q_search_result){
		q_search_result.hide();
		q_search_result = null;
	}
}

//搜索觉见问题, 输入框停留1秒开始搜索
function searchQuestions(me){
	clearTimeout(ttt_3);
	searchResultHide();

	if(all_questions.length < 1) return;

	var keyword = $.trim($(me).val());

	if(keyword.length < 2 || keyword.length > 16) return; //太长或太短均不搜索

	ttt_3 = setTimeout(function(){
		var result = "", tmp = "", keywords = keyword.split(/\s+/);

		all_questions.each(function(){
			var ok = 1;
			tmp = $(this).html();

			$.each(keywords, function(i, key){
				if(tmp.indexOf(key) < 0){
					ok = 0;
					return false;
				}
			});

			if(ok) result += '<li onclick="insertQuestion(this);"><i>●</i><b>' + tmp + '</b></li>';
		});

		if(result){
			q_search_result = q_search;
			q_search_result.html('<div class="q_search_title" onclick="searchResultHide();">' + langs.search_result + '<b>X</b></div>' + result).show();
		}

	}, 1000); //延迟1秒搜索
}

//输入框高度变化时自动校正相关元素高度等
function ajustPage(def){
	if(def == 0 ) return;

	var olem = $(".enter"); //底部区域
	olem.height(olem.height() + def);
}


//定义全局变量
var WebSocket = window.WebSocket || window.MozWebSocket; //websocket

var ttt_1 = 0, ttt_2 = 0, ttt_3 = 0, ttt_4 = 0, ttt_5 = 0, ttt_6 = 0, rating_star = 0, sound_btn, sending_mask, sending_mask_h;
var welive_op, historier, new_info, sender, msger, smilies_div, star_rating, welive_sounder;

var welive_name; //客服姓名
var welive_duty; //客服职位

var file_chunk_size = 1048576; //切片大小 默认为1M
var file_temp_data = ""; //切片上传文件时使用

var q_search, q_search_result = null, all_questions = ""; //常见问题相关

//自动调整输入框高度相关
var original_padding, original_height, original_scrollHeight, new_scrollHeight;


//linked        1已连接,   0未连接
//status        1登录成功允许发信息,   0不允许发信息
//autolink     1允许重新连接,   0不允许重新连接
var welive = {ws:{}, ttt: 0, ttt2: 0, linked: 0, status: 0, autolink: 0, unread: 0, playSound: 0, sound: 1, msg: '', closeQuiet: 0, temp: '', isRobot: 0, transOk: 1};

var star_info = ['<img src="' + SYSDIR + 'public/img/star_icon1.png">' + langs.star_1, '<img src="' + SYSDIR + 'public/img/star_icon2.png">' + langs.star_2, '<img src="' + SYSDIR + 'public/img/star_icon3.png">' + langs.star_3, '<img src="' + SYSDIR + 'public/img/star_icon4.png">' + langs.star_4, '<img src="' + SYSDIR + 'public/img/star_icon5.png">' + langs.star_5];


$(function(){
	welive_op = $("#welive_operator");
	historier = $(".viewport");
	smilies_div = $(".smilies_div");
	sender = $("#send_btn");
	msger = $("#guest_msg");
	sound_btn = $("#toolbar_sound");
	star_rating = $("#starRating");
	q_search = $(".q_search");
	new_info = $("#new_info");

	welive_sounder = document.getElementById("welive_sounder");

	//获取客人的gid
	var gid = parseInt(getCookie(COOKIE_USER));
	if(gid) guest.gid = gid;

	if(WS_HOST == "")	WS_HOST = document.domain; //先记录下来供websocket连接使用

	//获取当前的声音状态
	var wl_soundoff = parseInt(getCookie(COOKIE_USER + "_soff"));
	if(wl_soundoff == 1){
		welive.sound = 0;
		sound_btn.addClass('sound_off');
	}

	//移动端声音处理, 先要播放一下声音,否则无法自动播放
	document.body.addEventListener("touchend", firstPay); 

	//发送已读消息
	document.body.addEventListener("touchend", function(){
		if(welive.unread){
			welive.unread = 0;
			new_info.fadeOut(800);

			if(welive.status && !welive.isRobot) weliveSend({type: "g_readed"});
		}
	}); 

	//socket连接
	weliveLink(); 

	//初始化输入框scrollHeight值
	original_height = msger.height();
	original_padding = msger.innerHeight() - original_height; //上下padding值
	original_scrollHeight = new_scrollHeight = msger[0].scrollHeight;

	//输入框
	msger.bind("input propertychange", function(e){
		searchQuestions(this); //搜索常见问题

		//输入框自动调整高度
		this.style.height = (original_height - original_padding) + "px"; // 此值应等于: css中height 减去 上下padding
		this.style.height = this.scrollHeight + "px";

		var def = this.scrollHeight - new_scrollHeight;

		//高度有变化时
		if(def != 0){
			new_scrollHeight = this.scrollHeight;
			ajustPage(def); //调整页面相关元素的高度等
		}
	});

	//发送信息
	sender.click(function(e) {
		weliveSendMsg();
		e.preventDefault();
	});

	//评价按钮动作
	$("#toolbar_evaluate").click(function(){
		smilies_div.hide();
		rating_star = 0;

		$("#starRating .star span").find('.high').css('z-index',0);
		$(".starInfo").html(langs.select_star);
		$("#starRating").toggle();

		$("#toolbar_emotion").removeClass("emotion_hover");
		if($(this).hasClass("evaluate_hover")){
			$(this).removeClass("evaluate_hover");
		}else{
			$(this).addClass("evaluate_hover");
		}
	});

	//星星打分
	$("#starRating .star span").click(function () {
		rating_star = parseInt($(this).attr("star_val"));

		$(this).prevAll().find('.high').css('z-index',1);
		$(this).find('.high').css('z-index',1);
		$(this).nextAll().find('.high').css('z-index',0);

		$('.starInfo').html(star_info[rating_star -1]);
	});

	//表情符号
	$("#toolbar_emotion").click(function(){
		star_rating.hide();
		smilies_div.toggle();

		$("#toolbar_evaluate").removeClass("evaluate_hover");
		if($(this).hasClass("emotion_hover")){
			$(this).removeClass("emotion_hover");
		}else{
			$(this).addClass("emotion_hover");
		}
	});

	//开关声音
	sound_btn.click(function(){
		if(welive.sound){
			welive.sound = 0;
			sound_btn.addClass('sound_off');

			setCookie(COOKIE_USER + "_soff", 1, 2); //关闭声音cookie保持2天		
		
		}else{
			welive.sound = 1;
			playSound();
			sound_btn.removeClass('sound_off');
			setCookie(COOKIE_USER + "_soff", 0, 0);
		}
	});

	//上传图片按钮
	$("#toolbar_photo").click(function(){
		closeDialogs();

		popInfo(langs.notready);
		return;
	});

	//上传文件按钮
	$("#toolbar_file").click(function(){
		closeDialogs();

		popInfo(langs.notready);
		return;
	});

	//iphone safari
	window.addEventListener("pagehide", function(){
		clearTimer();
	}, false);

	window.onbeforeunload=function(event){
		if(welive.status){
			return " ";
		}else{
			clearTimer();
		}		
	};
	$(window).unload(function(){clearTimer();});

	//常见问题
	all_questions = $("#questions_div li");
});