<?php if(!defined('ROOT')) die('Access denied.');

class MobileAuth{

	public $admin = null; //保存用户信息
	public $is_ajax = 0;
	public $cookieName;

	public function __construct($path){
		$this->cookieName = COOKIE_ADMIN . "_mb";

		if($path[1] == 'ajax') $this->is_ajax = 1;

		$this->check_auth(); //admin类构造时就进行授权
	}

	/**
	 * private 授权函数 auth
	 */
	private function check_auth(){
		$this->login();
	}

	/**
	 * private 输出用户登录窗口 login
	 */
	private function login(){
		$info = '';

		if(IsPost('submit')){
			$info = "免费版未开放客服移动端！";
		}

		$info = Iif($info, "<font color='#ff3300'>$info</font>", '请输入用户名和密码：');

		$key = PassGen(8);
		$code = authcode(md5(WEBSITE_KEY), 'ENCODE', $key, 1800);
		$cookievalue = md5(WEBSITE_KEY . $key . APP::$_CFG['KillRobotCode']);


		echo '<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="viewport" content="width=device-width, initial-scale=1,minimum-scale=1, maximum-scale=1, user-scalable=no">
<title>' . APP_NAME . ' - 客服登录</title>
<link rel="shortcut icon" href="public/img/favicon.ico" type="image/x-icon">
<link rel="stylesheet" type="text/css" href="public/login.css">
</head>
<body>
<div id="logo">
	<img src="public/img/logo.png" alt="'.APP_NAME.'"> 
</div>
<div id="login">
	<form id="loginform" action="" method="post">
		<input type="hidden" name="key" value="'.$key.'">
		<input type="hidden" name="code" value="'.$code.'">
		<p id="info">' . $info . '</p>
		<div class="control-group">
			<span class="icon-user"></span><input name="username" placeholder="Username" type="text" autocomplete="off" value="">
		</div>

		<div class="control-group">
			<span class="icon-lock"></span><input name="password" placeholder="Password" type="password">
		</div>

		<div class="remember-me">
				<input name="remember" value="1" type="checkbox" id="rm"><label for="rm"> 记住我</label>
		</div>

		<div class="login-btn">
			<input id="login-btn" value="登 录" type="submit" name="submit" onclick="setSafeCookie();return true;">
		</div>
	</form>

</div>

<div id="login-copyright">
	'.date("Y").' &copy; ' . APP_NAME . '7 <a href="' . APP_URL . '" target="_blank">为因软件 weensoft.cn</a>
</div>

<script type="text/javascript" src="' . SYSDIR . 'public/js/jquery.331.js"></script>

<script>

	function setSafeCookie() {
		document.cookie = "' . COOKIE_SAFE . '=' . $cookievalue . '; path=/";
	}

	function reset_window(){
		var margin_top = ($(window).height() - $("#logo").height() - $("#login").height() - $("#login-copyright").height() - 58)/2;

		if(margin_top < 58) margin_top = 8;
		$("#logo").css("margin-top", margin_top+"px");
	}

	$(function(){
		reset_window();

		$(window).on("orientationchange", function(){	reset_window();});
	});

</script>
</body>
</html>';

		exit(); //终止程序继续运行  important !!!!!
	}


}

?>