<?php if(!defined('ROOT')) die('Access denied.');

class Auth{

	public $admin = null; //保存用户信息
	public $is_ajax = 0;

	public function __construct($path){
		if($path[1] == 'ajax') $this->is_ajax = 1;

		$this->check_auth(); //admin类构造时就进行授权
	}

	/**
	 * private 授权函数 check_auth
	 */
	private function check_auth(){
		$sessionid = ForceCookieFrom(COOKIE_ADMIN);
		$agent = md5(substr($_SERVER['HTTP_USER_AGENT'], 0, 252) . WEBSITE_KEY);

		if($sessionid AND IsAlnum($sessionid)){//登录成功验证cookie授权
			$sql = "SELECT s.sid, a.*, ag.groupname
						FROM " . TABLE_PREFIX . "session s
						LEFT JOIN " . TABLE_PREFIX . "admin a ON a.aid = s.aid
						LEFT JOIN " . TABLE_PREFIX . "group ag ON ag.id = a.grid
						WHERE s.sid    = '$sessionid'
						AND s.agent = '$agent'
						AND a.activated = 1";

			$userinfo = APP::$DB->getOne($sql);

			if(!$userinfo OR !$userinfo['aid']){ //用户不合法, 清除cookie, 重新登录
				setcookie(COOKIE_ADMIN, '', 0, '/');

				APP::$DB->exe("DELETE FROM " . TABLE_PREFIX . "session WHERE sid = '$sessionid'"); //删除当前的session

				if(!$this->is_ajax) $this->login(); //ajax不输出登录窗口
			}else{
				$this->admin = $userinfo; //授权成功, 执行后面的程序
				$this->admin['agent'] = $agent; //用于socket连接时验证
				$this->admin['password'] = '';
			}
		}else{
			if(!$this->is_ajax) $this->login(); //ajax不输出登录窗口
		}
	}


	/**
	 * private 检查安装目录是否存在 checkInstallDir
	 */
	private function checkInstallDir(){
		$re = false;

		$handle = opendir(ROOT);

		while(($item = readdir($handle)) !== false) {
			if($item == '.' || $item == '..') continue;

			if(is_dir(ROOT . $item) AND stristr($item, "insta")){
				$re = true;
				break;
			}
		}

		closedir($handle);

		return $re;
	}


	/**
	* 判断访问地址是PC和移动方法
	* @return boolean
	*/
	private function isMobile()
	{ 
		// 如果有HTTP_X_WAP_PROFILE则一定是移动设备
		if (isset($_SERVER['HTTP_X_WAP_PROFILE'])) {
			return true;
		}

		// 如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
		if (isset($_SERVER['HTTP_VIA'])) { 
			// 找不到为flase,否则为true
			return stristr($_SERVER['HTTP_VIA'], "wap") ? true : false;
		}

		// 脑残法，判断手机发送的客户端标志,兼容性有待提高。其中'MicroMessenger'是电脑微信
		if (isset($_SERVER['HTTP_USER_AGENT'])) {
			$clientkeywords = array('nokia','sony','ericsson','mot','samsung','htc','sgh','lg','sharp','sie-','philips','panasonic','alcatel','lenovo','iphone','ipod','blackberry','meizu','android','netfront','symbian','ucweb','windowsce','palm','operamini','operamobi','openwave','nexusone','cldc','midp','wap','mobile','MicroMessenger'); 
			// 从HTTP_USER_AGENT中查找手机浏览器的关键字
			if (preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT']))) {
			  return true;
			} 
		} 

		// 协议法，因为有可能不准确，放到最后判断
		if (isset ($_SERVER['HTTP_ACCEPT'])) { 
			// 如果只支持wml并且不支持html那一定是移动设备
			// 如果支持wml和html但是wml在html之前则是移动设备
			if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html')))) {
			  return true;
			} 
		}

		return false;
	}


	/**
	 * private 输出用户登录窗口 login
	 */
	private function login(){
		//判断移动设备跳转到app目录
		if($this->isMobile()){
			echo '<script type="text/javascript">document.location="./app/";</script>';
			exit();
		}

		$info = '';
		$disabled =  '';

		if(IsPost('submit')) $info = $this->check();
		$info = Iif($info, "<font color='#ff3300'>$info</font>", '请输入用户名和密码：');

		if($this->checkInstallDir()){
			$info ="<font color='#ff3300'>请先删除系统安装目录(./install)后刷新登录";
			$disabled =  ' disabled="disabled" style="cursor:default;"';
		}

		$key = PassGen(8);
		$code = authcode(md5(WEBSITE_KEY), 'ENCODE', $key, 1800);
		$cookievalue = md5(WEBSITE_KEY . $key . APP::$_CFG['KillRobotCode']);

		echo '<!DOCTYPE html>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
<title>'.APP_NAME.' - 管理登录</title>
<link rel="shortcut icon" href="' . SYSDIR . 'public/img/favicon.ico" type="image/x-icon"> 
<link rel="stylesheet" type="text/css" href="'. SYSDIR .'public/login.css">
</head>
<body>
<div id="logo">
	<img src="'. SYSDIR .'public/img/logo.png" alt="'.APP_NAME.'"> 
</div>
<div id="login">
	<form id="loginform" action="" method="post">
		<input type="hidden" name="key" value="'.$key.'">
		<input type="hidden" name="code" value="'.$code.'">
		<p id="info">' . $info . '</p>
		<div class="control-group">
			<span class="icon-user"></span><input name="username" placeholder="Username" type="text" autocomplete="off" ' . $disabled . '>
		</div>

		<div class="control-group">
			<span class="icon-lock"></span><input name="password" placeholder="Password" type="password" ' . $disabled . '>
		</div>

		<div class="remember-me">
				<input name="remember" value="1" type="checkbox" id="rm"><label for="rm"> 记住我</label>
		</div>

		<div class="login-btn">
			<input id="login-btn" value="登 录" type="submit" name="submit" onclick="setSafeCookie();return true;" ' . $disabled . '>
		</div>
	</form>
</div>

<div id="login-copyright">
	'.date("Y").' &copy; ' . APP_NAME . '7 <a href="' . APP_URL . '" target="_blank">为因软件 weensoft.cn</a>
</div>

<script src="'. SYSDIR .'public/js/jquery.191.js" type="text/javascript"></script>
<script>
function setSafeCookie() {
	document.cookie = "' . COOKIE_SAFE . '=' . $cookievalue . '; path=/";
}

$(function(){
	$("#logo").css("margin-top", ($(window).height()-420)/2+"px");
	$("input[name=\'username\']").focus();
});
</script>
</body>
</html>';

		exit(); //终止程序继续运行  important !!!!!
	}


 	/**
	 * 登录验证
	 */
   private function check(){
		$username = ForceStringFrom('username');
		$password = ForceStringFrom('password');
		$remember = ForceIntFrom('remember');
		$key = ForceStringFrom('key');
		$code = ForceStringFrom('code');
		$decode = authcode($code, 'DECODE', $key);

		$cookievalue = ForceCookieFrom(COOKIE_SAFE);

		if(!strlen($username) OR !strlen($password)){
			$error = '请输入用户名和密码!';
		}elseif(!isName($username)){
			$error = '用户名存在非法字符!';
		}elseif($cookievalue != md5(WEBSITE_KEY . $key . APP::$_CFG['KillRobotCode'])){
			$error = '验证码不正确!';
		}elseif($decode != md5(WEBSITE_KEY)){
			$error = '验证码过期, 请刷新后重新登录!';
		}else{
			$password = md5($password);

			$user = APP::$DB->getOne("SELECT a.aid, a.type FROM " . TABLE_PREFIX . "admin a WHERE a.username = '$username' AND a.password = '$password' AND a.activated = 1");

			if(!$user OR !$user['aid']){
				$error = '用户不存在或密码错误!';
			}else{//授权成功, 执行相关操作
				$userip = GetIP();
				$timenow = time();
				$sessionid = md5(uniqid($user['aid'] . COOKIE_KEY));
				$agent = md5(substr($_SERVER['HTTP_USER_AGENT'], 0, 252) . WEBSITE_KEY);

				APP::$DB->exe("INSERT INTO " . TABLE_PREFIX . "session (sid, aid, ip, agent, time)
						  VALUES ('$sessionid', '$user[aid]', '$userip', '$agent', '$timenow')");

				APP::$DB->exe("UPDATE " . TABLE_PREFIX . "admin SET online = 0, last = '$timenow', lastip = '$userip', logins = (logins + 1)  WHERE aid = '$user[aid]'");

				$time = Iif($remember, $timenow+3600*24*180, 0); //记住我180天
				setcookie(COOKIE_ADMIN, $sessionid, $time, '/');

				if(!$user['type']) Redirect('online'); //如果是客服人员直接跳转到客服操作页面

				Redirect(); //登录验证成功后跳转到首页
			}
		}

		return $error; //提交数据有错误或验证用户失败, 返回错误信息在登录中显示
	}


	/**
	 * public 退出登录函数logout
	 */
    public function logout(){
		$sessionid = ForceCookieFrom(COOKIE_ADMIN);
		setcookie(COOKIE_ADMIN, '', 0, '/'); //清除cookie

		if($sessionid AND IsAlnum($sessionid)){
			APP::$DB->exe("DELETE FROM " . TABLE_PREFIX . "session WHERE sid = '$sessionid'"); //后台用户退出时删除当前的session
		}


		APP::$DB->exe("DELETE FROM " . TABLE_PREFIX . "vvc WHERE time < " . (time() - 3600*8)); //删除8小时前的验证码
		APP::$DB->exe("DELETE FROM " . TABLE_PREFIX . "session WHERE time < " . (time() - 3600*24*180)); //删除180天前的session

		Redirect(); //退出后跳转到后台首页
	} 

	/**
	 * public 系统操作权限验证函数 CheckAccess 无输出(用于Ajax)
	 */
	public function CheckAccess() {
		if($this->admin && $this->admin['type'] == 1) return true; //系统管理员(1系统管理员, 2组长, 0客服)
		return false;
	}

	/**
	 * public 操作授权验证输出并输出错误信息
	 */
	public function CheckAction() {
		if(!$this->CheckAccess()){
			Error('您没有进行本次操作的权限!', '权限错误');
		}
	}

	/**
	 * public 客服组设置权限验证, 无输出
	 */
	public function checkTeamAccess() {
		if($this->admin && $this->admin['type'] <> 0) return true; //管理员或组长(1系统管理员, 2组长, 0客服)
		return false;
	}

	/**
	 * public 验证组长操作权限
	 */
	public function checkTeamAction() {
		if(!$this->checkTeamAccess()){
			Error('您没有进行本次操作的权限!', '权限错误');
		}
	}

}

?>