<?php if(!defined('ROOT')) die('Access denied.');

class c_index extends Admin{

    function index($path){
		$today = DisplayDate(); //今日日期
		ini_set('date.timezone', 'GMT'); //先设置为格林威治时区, 时区会影响strtotime函数将日期转为时间戳
		$start_time = intval(strtotime($today)) - 3600 * intval(APP::$_CFG['Timezone']); //再根据welive设置的时区转为UNIX时间戳
		$end_time = $start_time + 86400;
		
		//获取统计数据
		$basedata = APP::$DB->getOne("SELECT (select COUNT(gid) FROM " . TABLE_PREFIX . "guest) AS guests, 
		(select COUNT(gid) FROM " . TABLE_PREFIX . "guest WHERE last >= '$start_time' AND last < '$end_time') AS today_guests, 
		(select COUNT(mid) FROM " . TABLE_PREFIX . "msg) AS msgs, 
		(select COUNT(mid) FROM " . TABLE_PREFIX . "msg WHERE time >= '$start_time' AND time < '$end_time') AS today_msgs, 
		(select COUNT(rmid) FROM " . TABLE_PREFIX . "robotmsg) AS robotmsgs, 
		(select COUNT(rmid) FROM " . TABLE_PREFIX . "robotmsg WHERE time >= '$start_time' AND time < '$end_time') AS today_robotmsgs, 
		(select COUNT(rid)  FROM " . TABLE_PREFIX . "rating) AS ratings,
		(select ROUND(AVG(score), 2)  FROM " . TABLE_PREFIX . "rating) AS avg_score");

		$dir_size_img = $this->dirsize(ROOT . 'upload/img/'); //上传图片文件夹的大小
		$dir_size_img = number_format($dir_size_img / 1024000, 2);

		$dir_size_file = $this->dirsize(ROOT . 'upload/file/'); //上传普通文件的文件夹大小
		$dir_size_file = number_format($dir_size_file / 1024000, 2);

		SubMenu('欢迎进入 '.APP_NAME.' 管理中心', array(
			array('客人管理', 'guests'),
			array('记录管理', 'messages'),
			array('评价管理', 'rating'),
			array('清理图片', 'upload_img'),
			array('清理文件', 'upload_file'),
			array('机器人管理', 'robot'),
			array('无解记录管理', 'robotmsgs')
		));


echo '<style type="text/css">
.statistics{padding:30px;font-size:18px;color:#666;}
.sta_item{margin-right:12px;width:240px;height:180px;border:2px solid #ddd;overflow:hidden;border-radius:7px;background:#fff;text-align:center;display:inline-block;}
.sta_item_top{padding:24px 0 14px 0;line-height:2em;}
.sta_item_top font{color:#00c1c1;font-size:24px;vertical-align:middle;}
.sta_item_bot{border-top:2px solid #ddd;padding: 20px 0;background:#f1f1f1;height:50px;overflow:hidde;white-space:nowrap;}
</style>
<div class="statistics">
	<div class="sta_item">
		<div class="sta_item_top">今日访客<br><font>' . $basedata['today_guests'] . '</font></div>
		<div class="sta_item_bot">访客总计&nbsp;&nbsp;' . $basedata['guests'] . Iif($basedata['guests'] > 10000, '<a class="alert-btn" href="' . BURL('guests') . '">清理</a>') . '</div>
	</div>		
	<div class="sta_item">
		<div class="sta_item_top">今日会话<br><font>' . $basedata['today_msgs'] . '</font></div>
		<div class="sta_item_bot">会话总计&nbsp;&nbsp;' . $basedata['msgs'] . Iif($basedata['msgs'] > 10000, '<a class="alert-btn" href="' . BURL('messages') . '">清理</a>') . '</div>
	</div>		
	<div class="sta_item">
		<div class="sta_item_top">今日机器人无解<br><font>' . $basedata['today_robotmsgs'] . '</font></div>
		<div class="sta_item_bot">无解总计&nbsp;&nbsp;' . $basedata['robotmsgs'] . Iif($basedata['robotmsgs'] > 1000, '<a class="alert-btn" href="' . BURL('robotmsgs') . '">处理</a>') . '</div>
	</div>		
	<div class="sta_item">
		<div class="sta_item_top">评价得分<br><font>' . Iif($basedata['avg_score'],  $basedata['avg_score'], 0). '</font></div>
		<div class="sta_item_bot">评价总计&nbsp;&nbsp;' . $basedata['ratings'] . Iif($basedata['ratings'] > 10000, '<a class="alert-btn" href="' . BURL('rating') . '">清理</a>') . '</div>
	</div>		
	<div class="sta_item">
		<div class="sta_item_top">图片总计<br><font>' . $dir_size_img . ' M</font>' . Iif($dir_size_img > 1000, '<a class="alert-btn" href="' . BURL('upload_img') . '">清理</a>') . '</div>
		<div class="sta_item_bot">文件总计&nbsp;&nbsp;' . $dir_size_file . ' M' . Iif($dir_size_file > 1000, '<a class="alert-btn" href="' . BURL('upload_file') . '">清理</a>') . '</div>
	</div>		
</div>';

		$welcome = '<ul><li>欢迎 <font class=greenb>'.$this->admin['fullname'].'</font> 进入后台管理面板! 为了确保系统安全, 请在关闭前点击 <a href="#" class="redb logout">退出</a> 安全离开!</li>
		<li>您在使用: '.APP_NAME.'在线客服系统[免费版'.APP_VERSION.'], 如有任何问题, 请访问: <a href="http://www.weensoft.cn/" target="_blank" class=blue>为因软件 weensoft.cn</a></li></ul>';

		ShowTips($welcome, '系统信息');

		BR(1);

		TableHeader('使用技巧');

		TableRow('<font class=grey>1)</font>&nbsp;&nbsp;将代码: <span class=note>&lt;script type="text/javascript" charset="UTF-8" src="' . BASEURL . 'welive.js"&gt;&lt;/script&gt;</span> 插入需要调用WeLive在线客服系统的页面&lt;html&gt;内<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;此时页面右下角将显示客服小图标，点击可在新页面打开客服对话窗口. 如要单独调用某客服组，需加参数，如:&nbsp;&nbsp; ...... welive.js<span class=note>?g=客服组id</span><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;还可以自定义客服图标或样式：<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;编辑页面中的元素，为其添加样式：class="welive"，那么点击该元素可在新页面打开对话窗口，如：&lt;a class="welive"&gt;打开WeLive对话窗口&lt;/a&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;还可以在同一页面显示多个客服组按钮，如：&lt;div class="welive" group="8"&gt;接8号客服组&lt;/div&gt; 或 &lt;div class="welive" group="9"&gt;接9号客服组&lt;/div&gt; 等等');

		TableRow('<font class=grey>2)</font>&nbsp;&nbsp;URL直接进入对话窗口(二维码)：<span class=note>' . BASEURL . 'kefu.php?a=6168&g=客服组id</span> 无论何种方式，访客界面自适应web和移动端, 参阅：<a href="' . BASEURL . '" target="_blank" class=greenb>WeLive前台加载演示</a>');

		TableRow('<font class=grey>3)</font>&nbsp;&nbsp;与原网站用户接口：在引入WeLive在线客服系统JS文件的页面，将原网站用户id、用户名(昵称)分别保存名称为:“welive_id”、“welive_fn”的 <span class=note>Cookie</span><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;第2种调用方式下，可通过URL传递原网站用户名或id，如：' . BASEURL . 'kefu.php?a=6168&g=客服组id<span class=note>&id=888&fn=用户名</span>');

		TableRow('<font class=grey>4)</font>&nbsp;&nbsp;在客服操作窗口群聊区，管理员、客服组长可发送特殊指令查询数据：&nbsp;&nbsp;all ---所有数据;&nbsp;&nbsp;admin ---本组客服数据;&nbsp;&nbsp;guest ---本组访客数据;&nbsp;&nbsp;robot ---本组机器人数据');

		TableRow('<font class=grey>5)</font>&nbsp;&nbsp;Linux服务器：在SSH命令行终端进入WeLive安装目录，运行 <span class=red>php start.php start -d</span> 启动Workerman，Workerman启动后可退出SSH终端<br><div style="margin-left:22px;">运行 <span class=red>php start.php stop</span> 终止运行Workerman。&nbsp;&nbsp;需要重启Workerman时，可以先终止，然后再启动。</div>');

		TableRow('<font class=grey>6)</font>&nbsp;&nbsp;Windows服务器：双击WeLive根目录下的 <span class=red>start-for-win.bat</span> 文件启动Workerman，且打开的命令行窗口不能关闭(按 Ctrl + C 可关闭)，一旦关闭，通讯服务将终止<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font class=red>注意</font>：Workerman未启动或启动不正常，WeLive在线客服系统将无法提供服务');

		TableFooter();
    }

	/**
	 * 文件夹大小
	 * @param $path
	 * @return int
	 */
	private function dirsize($path)
	{
		$size = 0;
		if(!is_dir($path)) return $size;

		$handle = opendir($path);
		while (($item = readdir($handle)) !== false) {
			if ($item == '.' || $item == '..') continue;
			$_path = $path . '/' . $item;
			if (is_file($_path)){
				$size += filesize($_path);
			}else{
				$size += $this->dirsize($_path);
			}
		}
		closedir($handle);
		return $size;
	}

}

?>