# WeCube v4.0.0升级部署文档

在这里，我们将为您说明如何在您自己的机器资源上手工安装v4.0.0版本的WeCube。

### 升级说明

#### 升级支持两种方式：   
1、(推荐)新老两套wecube并存    
2、直接替换升级，需要注意的是新版编排与老版编排不兼容，直接升级的话会看不到老编排，请慎重选择

#### 在两套并存的情况下需要注意的一些事项：
- 支持两套wecube共用一套插件实例，前提是两套的token seed得一致，因为一个插件只能有一个解token的seed,如下图    
  ![共用插件示意图](https://github.com/WeBankOpenPlatform/wecube-platform/blob/master/wecube-wiki/images/v4update.drawio.svg)
- 当共用一套插件实例时，需要在两套wecube上都点注册插件，因为两套wecube的前端资源在各自的实例里管理
- 支持两套wecube拥有各自的一套插件服务，此时seed可以配成不一样，两套wecube不互认，各自的插件实例需要在各自的界面上启停，如下图    
  ![共用插件示意图](https://github.com/WeBankOpenPlatform/wecube-platform/blob/master/wecube-wiki/images/v4update02.drawio.svg)
- 两套wecube并存时需要在系统参数中增加GATEWAY_URL_NEW，把wecube v4.0.0的Gateway地址配上去
- taskman插件只支持wecube v4.0.0或以上版本，老版本中不兼容
- 因为部分插件中有配置编排的功能，而新老版本的编排并不通用，所以在插件中可能会出现部分编排配置不可见或报错的情况，这是因为在老版本中配置选择了老编排，但在新版本中进去查看时页面请求会去拿新版本编排列表来渲染导致无法匹配到相应的编排，反过来也一样，涉及的地方主要是监控插件的告警通知回调编排配置。

### 升级准备

#### 硬件资源
1、可在原v3.x.x版本WeCube的机器上部署，但需要避开端口冲突，该文档的建议端口与老版本并不冲突    
2、可在全新的主机上部署，建议与原v3.x.x版本主机在同一局域网内部署，硬件规格建议如下    

| 资源    | 数量 | 建议配置         | 用途                                                                                                         |
|-------|----|--------------|------------------------------------------------------------------------------------------------------------|
| 主机    | 2  | 4核 8G 100G硬盘 | WeCube平台软件运行(100用户规模)                                                                                       |

如果选择在全新的主机上部署，主机初始化建议参考该文档：[私有资源上手工集群模式安装WeCube](https://webankpartners.github.io/wecube-docs/installation-cluster-mode-on-premises-offline/#_3)

#### 数据库升级ddl
- auth_server库 [wecube_platform_auth_4.0.0.sql](https://github.com/WeBankPartners/wecube-platform/blob/master/platform-auth-server/deploy/db/upgrade/wecube_platform_auth_4.0.0.sql)
- wecube库 [v4.0.0.sql](https://github.com/WeBankPartners/wecube-platform/blob/master/platform-core/wiki/database/v4.0.0.sql)

#### 容器镜像下载
```bash
WECUBE_VERSION=v4.0.0
# pull images
docker pull ccr.ccs.tencentyun.com/webankpartners/platform-core:$WECUBE_VERSION
docker pull ccr.ccs.tencentyun.com/webankpartners/wecube-portal:$WECUBE_VERSION
docker pull ccr.ccs.tencentyun.com/webankpartners/platform-gateway:$WECUBE_VERSION
docker pull ccr.ccs.tencentyun.com/webankpartners/platform-auth-server:$WECUBE_VERSION

# save images
docker save -o webankpartners-platform-core.tar ccr.ccs.tencentyun.com/webankpartners/platform-core:$WECUBE_VERSION
docker save -o webankpartners-wecube-portal.tar ccr.ccs.tencentyun.com/webankpartners/wecube-portal:$WECUBE_VERSION
docker save -o webankpartners-platform-gateway.tar ccr.ccs.tencentyun.com/webankpartners/platform-gateway:$WECUBE_VERSION
docker save -o webankpartners-platform-auth-server.tar ccr.ccs.tencentyun.com/webankpartners/platform-auth-server:$WECUBE_VERSION
```

#### 部署路径
- 建议与老版本wecube根路径分开
- 因为新版本各组件间的docker-compose分开了，所以建议platform-core、platform-auth-server、platform-gateway、wecube-portal各一个目录分开
- 映射出来的log/logs文件夹需要先授权其它用户能读写，因为容器启动用户已经不再是root，而是容器里内置的app用户
- 下面升级步骤中有建议的部署目录创建命令


### 升级docker-compose

wecube v4.0.0版本的docker compose相较于之前版本有一些变量的改动，需要重新配置    

#### 环境变量整理

**请按需修正一下环境变量值**

```bash
# wecube版本
WECUBE_VERSION='v4.0.0'
# 部署的主机ip
HOSTIP='10.0.0.1'
# 日志级别
LOG_LEVEL='info'
# (非必须)wecube内置的私钥，用于wecube yaml里数据库密码等敏感信息的加解密，rsa1024公钥加密私钥解
WECUBE_PRIVATE_KEY='key.pem'
# wecube用户token加解密种子
JWT_SIGNING_KEY='Platform+Auth+Server+Secret'
# wecube mysql服务信息
mysql_wecube_host='10.0.0.10'
mysql_wecube_port='3307'
mysql_wecube_username='root'
mysql_wecube_password='WeCube@1234'
# auth server mysql服务信息
mysql_auth_host='10.0.0.11'
mysql_auth_port='3308'
mysql_auth_username='root'
mysql_auth_password='WeCube@1234'
# s3服务信息
s3_host='10.0.1.10'
s3_port='9000'
s3_access='access_key'
s3_secret='secret_key'
# wecube主机ssh认证信息
host_wecube_username='root'
host_wecube_password='WeCube@1234'
```

#### 准备yaml内容

在本地准备以下4个yaml文件

1-wecube-platform-auth-server.yml

```yaml
version: '3'
services:
  platform-auth-server:
    image: ccr.ccs.tencentyun.com/webankpartners/platform-auth-server:{{WECUBE_VERSION}}
    container_name: platform-auth-server-{{WECUBE_VERSION}}
    restart: always
    volumes:
      - /etc/localtime:/etc/localtime
      - /data/app/platform/platform-auth-server/logs:/app/platform-auth-server/logs
      - /data/app/platform/platform-auth-server/certs:/app/platform-auth-server/config/certs
    ports:
      - "{{HOSTIP}}:8002:8080"
    environment:
      - LOG_LEVEL={{LOG_LEVEL}}
      - PASSWORD_PRIVATE_KEY_PATH=/app/platform-auth-server/config/certs/{{WECUBE_PRIVATE_KEY}}
      - MYSQL_SERVER_ADDR={{mysql_auth_host}}
      - MYSQL_SERVER_PORT={{mysql_auth_port}}
      - MYSQL_USER_NAME={{mysql_auth_username}}
      - MYSQL_USER_PASSWORD={{mysql_auth_password}}
      - MYSQL_SERVER_DATABASE_NAME=auth_server
      - SIGNING_KEY={{JWT_SIGNING_KEY}}
      - USER_ACCESS_TOKEN=20
      - USER_REFRESH_TOKEN=30
      - WECUBE_CORE_ADDRESS={{HOSTIP}}:8000
```

2-wecube-platform-core.yml

```yaml
version: '3'
services:
  platform-core:
    image: ccr.ccs.tencentyun.com/webankpartners/platform-core:{{WECUBE_VERSION}}
    container_name: platform-core-{{WECUBE_VERSION}}
    restart: always
    volumes:
      - /etc/localtime:/etc/localtime
      - /data/app/platform/platform-core/logs:/app/platform-core/logs
      - /data/app/platform/platform-core/certs:/app/platform-core/config/certs
    ports:
      - "{{HOSTIP}}:8000:8000"
    environment:
      - version={{WECUBE_VERSION}}
      - log_level={{LOG_LEVEL}}
      - password_private_key_path=/app/platform-core/config/certs/{{WECUBE_PRIVATE_KEY}}
      - https_enable=false
      - http_port=8000
      - db_server={{mysql_wecube_host}}
      - db_port={{mysql_wecube_port}}
      - db_user={{mysql_wecube_username}}
      - db_pass={{mysql_wecube_password}}
      - db_database=wecube
      - auth_server_url=http://{{HOSTIP}}:8002
      - jwt_signing_key={{JWT_SIGNING_KEY}}
      - s3_address={{s3_host}}:{{s3_port}}
      - s3_access_key={{s3_access}}
      - s3_secret_key={{s3_secret}}
      - static_resource_server_ips={{HOSTIP}}
      - static_resource_server_user={{host_wecube_username}}
      - static_resource_server_password={{host_wecube_password}}
      - static_resource_server_port=22
      - static_resource_server_path=/data/app/platform/wecube-portal/data/ui-resources
      - plugin_base_mount_path=/data
      - plugin_deploy_path=/data/app/plugin-image
      - plugin_password_pub_key_path=
      - resource_server_password_seed=defaultSeed
      - gateway_url={{HOSTIP}}:8005
      - gateway_host_ports={{HOSTIP}}:8005
      - sub_system_private_key=
      - cron_keep_batch_exec_days=20
      - host_ip={{HOSTIP}}
```

3-wecube-platform-gateway.yml

```yaml
version: '3'
services:
  platform-gateway:
    image: ccr.ccs.tencentyun.com/webankpartners/platform-gateway:{{WECUBE_VERSION}}
    container_name: platform-gateway-{{WECUBE_VERSION}}
    restart: always
    volumes:
      - /etc/localtime:/etc/localtime
      - /data/app/platform/platform-gateway/logs:/app/platform-gateway/logs
    ports:
      - "{{HOSTIP}}:8005:8080"
    environment:
      - LOG_LEVEL={{LOG_LEVEL}}
      - GATEWAY_ROUTE_CONFIG_SERVER=http://{{HOSTIP}}:8000
      - GATEWAY_ROUTE_CONFIG_URI=/platform/v1/route-items
      - WECUBE_CORE_ADDRESS={{HOSTIP}}:8000
      - AUTH_SERVER_ADDRESS={{HOSTIP}}:8002
```

4-wecube-portal.yml

```yaml
version: '3'
services:
  wecube-portal:
    image: ccr.ccs.tencentyun.com/webankpartners/wecube-portal:{{WECUBE_VERSION}}
    container_name: wecube-portal-{{WECUBE_VERSION}}
    restart: always
    volumes:
      - /etc/localtime:/etc/localtime
      - /data/app/platform/wecube-portal/log:/var/log/nginx/
      - /data/app/platform/wecube-portal/data/ui-resources:/root/app/ui-resources
    ports:
      - "{{HOSTIP}}:8080:8080"
    environment:
      - GATEWAY_HOST={{HOSTIP}}
      - GATEWAY_PORT=8005
      - PUBLIC_DOMAIN={{HOSTIP}}:8080
      - TZ=Asia/Shanghai
    command: /bin/bash -c "/etc/nginx/start_platform_portal.sh"
```

#### 修正yaml内容的值

```bash
# 请修改以下变量为正确值
# 粘贴以上整理的环境变量


sed -i "s/{{WECUBE_VERSION}}/$WECUBE_VERSION/g" 1-wecube-platform-auth-server.yml
sed -i "s/{{HOSTIP}}/$HOSTIP/g" 1-wecube-platform-auth-server.yml
sed -i "s/{{LOG_LEVEL}}/$LOG_LEVEL/g" 1-wecube-platform-auth-server.yml
sed -i "s/{{WECUBE_PRIVATE_KEY}}/$WECUBE_PRIVATE_KEY/g" 1-wecube-platform-auth-server.yml
sed -i "s/{{JWT_SIGNING_KEY}}/$JWT_SIGNING_KEY/g" 1-wecube-platform-auth-server.yml
sed -i "s/{{mysql_auth_host}}/$mysql_auth_host/g" 1-wecube-platform-auth-server.yml
sed -i "s/{{mysql_auth_port}}/$mysql_auth_port/g" 1-wecube-platform-auth-server.yml
sed -i "s/{{mysql_auth_username}}/$mysql_auth_username/g" 1-wecube-platform-auth-server.yml
sed -i "s/{{mysql_auth_password}}/$mysql_auth_password/g" 1-wecube-platform-auth-server.yml


sed -i "s/{{WECUBE_VERSION}}/$WECUBE_VERSION/g" 2-wecube-platform-core.yml
sed -i "s/{{HOSTIP}}/$HOSTIP/g" 2-wecube-platform-core.yml
sed -i "s/{{LOG_LEVEL}}/$LOG_LEVEL/g" 2-wecube-platform-core.yml
sed -i "s/{{WECUBE_PRIVATE_KEY}}/$WECUBE_PRIVATE_KEY/g" 2-wecube-platform-core.yml
sed -i "s/{{JWT_SIGNING_KEY}}/$JWT_SIGNING_KEY/g" 2-wecube-platform-core.yml
sed -i "s/{{mysql_wecube_host}}/$mysql_wecube_host/g" 2-wecube-platform-core.yml
sed -i "s/{{mysql_wecube_port}}/$mysql_wecube_port/g" 2-wecube-platform-core.yml
sed -i "s/{{mysql_wecube_username}}/$mysql_wecube_username/g" 2-wecube-platform-core.yml
sed -i "s/{{mysql_wecube_password}}/$mysql_wecube_password/g" 2-wecube-platform-core.yml
sed -i "s/{{s3_host}}/$s3_host/g" 2-wecube-platform-core.yml
sed -i "s/{{s3_port}}/$s3_port/g" 2-wecube-platform-core.yml
sed -i "s/{{s3_access}}/$s3_access/g" 2-wecube-platform-core.yml
sed -i "s/{{s3_secret}}/$s3_secret/g" 2-wecube-platform-core.yml
sed -i "s/{{host_wecube_username}}/$host_wecube_username/g" 2-wecube-platform-core.yml
sed -i "s/{{host_wecube_password}}/$host_wecube_password/g" 2-wecube-platform-core.yml


sed -i "s/{{WECUBE_VERSION}}/$WECUBE_VERSION/g" 3-wecube-platform-gateway.yml
sed -i "s/{{HOSTIP}}/$HOSTIP/g" 3-wecube-platform-gateway.yml
sed -i "s/{{LOG_LEVEL}}/$LOG_LEVEL/g" 3-wecube-platform-gateway.yml


sed -i "s/{{WECUBE_VERSION}}/$WECUBE_VERSION/g" 4-wecube-portal.yml
sed -i "s/{{HOSTIP}}/$HOSTIP/g" 4-wecube-portal.yml
```



### 升级步骤

#### 执行数据库升级ddl
- 下列ddl只做增量改动，不会影响老版本的功能
- 在auth_server数据库中执行 wecube_platform_auth_4.0.0.sql
- 在wecube数据库中执行 v4.0.0.sql

#### 部署目录创建与授权
```bash
# 创建部署路径和授权日志目录
mkdir -p /data/app/platform/platform-auth-server/logs
mkdir -p /data/app/platform/platform-core/logs
mkdir -p /data/app/platform/platform-gateway/logs
mkdir -p /data/app/platform/wecube-portal/log
chmod 777 /data/app/platform/platform-auth-server/logs /data/app/platform/platform-core/logs /data/app/platform/platform-gateway/logs /data/app/platform/wecube-portal/log
# 把docker-compose文件放进目录中
cp 1-wecube-platform-auth-server.yml /data/app/platform/platform-auth-server/
cp 2-wecube-platform-core.yml /data/app/platform/platform-core/
cp 3-wecube-platform-gateway.yml /data/app/platform/platform-gateway/
cp 4-wecube-portal.yml /data/app/platform/wecube-portal/
# 如果有秘钥文件的话放到该目录下
mkdir -p /data/app/platform/platform-auth-server/certs
mkdir -p /data/app/platform/platform-core/certs
# 插件前端静态文件目录，需要授权给上面配置的 host_wecube_username 用户读写
mkdir -p /data/app/platform/wecube-portal/data/ui-resources
chmod 777 /data/app/platform/wecube-portal/data/ui-resources
```

#### 启动docker容器
- 启动platform-auth-server服务
  ```bash
  cd /data/app/platform/platform-auth-server
  docker-compose -f 1-wecube-platform-auth-server.yml up -d
  ```

- 启动platform-core服务
  ```bash
  cd /data/app/platform/platform-core
  docker-compose -f 2-wecube-platform-core.yml up -d
  ```

- 启动platform-gateway服务
  ```bash
  cd /data/app/platform/platform-gateway
  docker-compose -f 3-wecube-platform-gateway.yml up -d
  ```

- 启动wecube-portal服务
  ```bash
  cd /data/app/platform/wecube-portal
  docker-compose -f 4-wecube-portal.yml up -d
  ```

  至此，已经可以打开系统页面进行正常访问，但还无法正常使用插件功能

  **WeCube主页：http://{HOSTIP}:8080   使用老版本账户密码登录验证**     
  **如果当前环境有负载均衡，需要把portal与gateway的服务加入到相应的负载均衡中**

#### 更改系统变量值

如果是两套新老wecube并存，需要增加系统变量GATEWAY_URL_NEW，这样才能在新wecube界面正确启动插件

Web页面：系统-系统参数

| key                               | value                              |
| --------------------------------- |------------------------------------|
| system\_\_global\_\_GATEWAY_URL_NEW   | http://\{\{HOSTIP}}:8005           |


#### 重注册插件包

- 升级完后在新wecube页面应该加载不出来当前已运行的插件前端资源，导致页面无法访问，此时需要去新wecube的插件注册页面，对已运行的插件挨个点：插件配置 - 确定 - 重注册插件包
- 然后再刷新界面，即可加载出插件前端资源

到这里，您已经完成了WeCube v4.0.0的升级安装部署，请尽情体验吧。
