## 研发分支的命名规范
按照 [版本和研发分支控制流程](版本和研发分支控制流程.md) , 分支的命名规范制定如下:

分支类别|创建来源|合并去向|分支命名规范|描述
:--|:--|:--|:--|:--
master|无|无|固定名称|主干
dev|master|master|固定名称|开发分支
hotfix|master|master<br>dev|规则：[Issue号码](https://github.com/WeBankPartners/wecube-platform/issues) + Issue描述<br>范例：23_ip_validation_issue|生产线上Bug修复分支
feature|dev|dev|规则：[Issue号码](https://github.com/WeBankPartners/wecube-platform/issues) + Issue描述<br>范例：4_resource_management|新功能特性开发分支
bug|dev|dev|规则：[Issue号码](https://github.com/WeBankPartners/wecube-platform/issues) + Issue描述<br>范例：31_new_ci_attr_not_display|开发阶段Bug修复分支

>**提示** : 分支命名单词全部小写，每个单词下划线分割

## 代码提交注释的命名规范
规则：#[Issue号码](https://github.com/WeBankPartners/wecube-platform/issues) + 提交代码的目的或理由  
范例：#4 Add resource management of mysql
>**提示** : 
> 1. 必须加Issue号码作为前缀，建立代码提交跟Issue的超链接
> 2. 第一个单词首写字母大写，后续单词遵循自然语法，空格分割

## 开发步骤
### 1. 建立分支
```
$git checkout master
$git pull
$git checkout -b <分支名>
$git push origin <分支名>
```
如果分支已创建，则用如下命令checkout至本地即可
```
$git checkout -d <分支名> origin/<分支名>
```

### 2. 开发完提交代码
```
$git status
$git add <需要提交的文件>
$git commit -m "#4 Add resource management of mysql" 
$git push
```
建议在提交代码前拉一下远程分支的代码,避免冲突发生在push时
```
$git pull
```

### 3. 创建Pull Request
1. 创建PR
2. 确认PR是无冲突可以合并的
3. 设置Reviewers

### 4. 解决Reviewers发现的问题
1. 建议此类问题由原作者处理
2. 对问题的建议处理方法无异议则按其修改,否则回复原因或见解
3. 每个问题必须做出回应 - 已处理或给出原因

### 5. 通知负责人合并PR
负责人在PR合并前，需要确保： 
1. 通过所有的自动化测试
2. 通过PO验收
3. 通过团队的Review
4. Reviewers发现的问题已经被处理

