# 应用发布规范文档


## 发布包规范

### 应用发布包
应用发布包必须是一个全量包， 包名中带版本号。

名称格式：子系统英文名_版本号_构建次数XXX..tar.gz。名称内以“-”间隔， 名称与版本号之间以“_”连接，以.tar.gz结尾。

WeCube获取版本号规则：两个下划线之间&三位数字&这三位数字之间用 ’.’ 分隔。
应用发布包名称示例：wecube-core_1.0.0_20191101001.tar.gz

脚本、配置文件按分类放在不同的目录下。

配置文件中的差异化变量支持以下格式：[@var_name]、[&var_name] 、[!var_name]。
应用发布包中有且只有一个部署脚本， 如果有多个部署脚本，请合并成一个。

按打包时的目录和结构不同， 可以分为以下三种情况：

1. 应用包中使用通用目录
应用发布包中只有一个通用目录，没有版本目录，目录结构示例如下：

`
wecube-core
	- bin
	- conf
	- lib
	- logs
`

2. 应用包中包含版本目录
应用发布包中应包含与版本同名的目录，目录结构示例如下：

`
wecube-core_1.0.0
	- bin
	- conf
	- lib
	- logs
`

3. 应用包中包含软连接及版本目录（建议）
应用发布包中包含两个目录：软连接目录、与版本同名的目录，目录结构示例如下：

`
current（注：软连接， 指向wecube-core_1.0.0）
wecube-core_1.0.0
	- bin
	- conf
	- lib
	- logs
`


### 数据库发布包
数据库发布包，包名称中带版本号， 名称以“-”间隔，名称的最后一段以”-db”结尾， 名称与版本号之间以“_”连接，以.tar.gz结尾。
名称格式：子系统英文名-db_版本号_构建次数XXX..tar.gz。
WeCube获取版本号规则：两个下划线之间&三位数字&这三位数字之间用 ’.’ 分隔。

数据库发布包名称示例：wecube-core-db_1.0.1_20191101001.tar.gz
数据库发布包应包含全量脚本和增量脚本，增量脚本应说明是从哪一个版本上增量。增量发布脚本应有与之相对应的回滚脚本。每种脚本有且只有一个脚本文件， 如有多个， 请合并成一个。
目录结构示例：

`
wecube-core-db_1.0.1
	- full-load
		- wecube-core-db_1.0.1_fullload.sql
	- increment
		- wecube-core-db_1.0.1_increment.sql
		- wecube-core-db_1.0.1_rollback.sql
`

## 发布规范

### 应用发布
1. 使用通用目录
发布时，每个版本没有独立的版本目录，使用通用目录。
示例：
wecube-core子系统的发布目录为：/data/app/wecube-core
发布目录中的目录结构示例如下：

`
wecube-core
	-bin
	-conf
	-lib
    -logs
`

发布时，直接用新的发布包里的内容覆盖原有目录。


2. 使用独立版本目录
发布时，每个版本有独立的版本目录。
示例：
wecube-core子系统的发布目录为：/data/app/wecube-core
发布目录中的目录结构示例如下：

`
wecube-core
	-wecube-core_1.0.0
	-wecube-core_1.0.1
	-wecube-core_1.0.2
`

发布时， 发布包解压出新的版本目录，原有的版本目录不受影响。
定期清理发布目录中的旧版本目录。

	
3. 使用软连接版本目录（建议）
发布时，每个版本有独立的版本目录。
在发布目录中有一个软连接，每次发布时，修改软连接的指向到相应的版本目录。
示例：
wecube-core子系统的发布目录为：/data/app/wecube-core
发布目录中的目录结构示例如下：

`
wecube-core
	-current（注：这是软连接）
	-wecube-core_1.0.0
	-wecube-core_1.0.1
	-wecube-core_1.0.2
`

其中第一个“current”是软链接，指向到最新版本。
发布时，发布包解压生成新的版本目录和软连接， 软连接会覆盖原有的软连接， 更新指向到新的版本目录。
定期清理发布目录中的旧版本目录。
注：也可以在发布包中不包含软连接目录，而是在发布时，通过部署脚本创建软连接或者修改软连接的指向。


### 数据库发布
- 数据库脚本发布时，应指定执行用户。
- 数据库脚本只支持SQL脚本。
- 数据库脚本只写跟系统业务功能相关语句，如建表，字段变更，初始化数据等。
- 数据库脚本不应包含管理语句：如建库、建用户、授权等数据库运维相关语句。
