package com.webank.wecube.platform.core.service.plugin;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.webank.wecube.platform.core.support.authserver.AuthServerRestClient;

@Service
public class ApplicationInformationService {
	
	private static final Logger log = LoggerFactory.getLogger(ApplicationInformationService.class);
	
	@Autowired
	private PluginInstanceMgmtService pluginInstanceService;
	
	@Autowired
	private AuthServerRestClient authServerRestClient;

	public void healthCheck() {
		log.debug("health checking...");
		List<String> hosts = pluginInstanceService.getAvailableContainerHosts();
		log.debug("Health Check - HOSTS:{}", hosts);
		
		authServerRestClient.healthCheck();
	}
}
