package com.webank.wecube.platform.auth.server.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = "AUTH_SYS_ROLE")
public class SysRoleEntity extends BaseStatusFeaturedEntity {
    
    public static final String STATUS_DELETED = "Deleted";
    public static final String STATUS_NOT_DELETED = "NotDeleted";

    @Column(name = "NAME")
    private String name;

    @Column(name = "DISPLAY_NAME")
    private String displayName;

    @Column(name = "EMAIL_ADDR")
    private String emailAddress;
    
    @Column(name = "DESCRIPTION")
    private String description;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getEmailAddress() {
        return emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    
    public String getRoleDeletedStatus() {
        if(isDeleted()) {
            return STATUS_DELETED;
        }else {
            return STATUS_NOT_DELETED;
        }
    }

}
