![](https://repository-images.githubusercontent.com/267562756/4fc935ef-900e-48c5-b08d-9cfd151a9782)

<div align="center">

[![Latest Stable Version](https://poser.pugx.org/webrium/webrium/v)](//packagist.org/packages/webrium/webrium) [![Total Downloads](https://poser.pugx.org/webrium/webrium/downloads)](//packagist.org/packages/webrium/webrium)  [![License](https://poser.pugx.org/webrium/webrium/license)](//packagist.org/packages/webrium/webrium)

</div>

## About Webrium

Webrium is a web application framework that prioritizes quick development, simplicity, and lightness. It offers features like Routes for handling URL mappings,FoxDB for database operations, MVC architecture for organizing the code, and Blade for creating dynamic views


✔ Fast and Lightweight <br>
✔ MVC structure <br>
✔ Tailwindcss is configured by default <br>

<br>

## Install
```
$ composer create-project webrium/webrium
```

```
$ cd webrium & npm install
```

### Run Server
```
$ npm run dev
```

Then run the following address in your browser

`http://localhost:8000`

<br>

### Core Documentation
 * [Blade Templates](https://github.com/webrium/webrium/wiki/Blade-Templates)
 * [View](https://github.com/webrium/webrium/wiki/View)
 * [Upload](https://github.com/webrium/webrium/wiki/Upload)
 * [Controllers](https://github.com/webrium/webrium/wiki/controllers)
 * [Route Documentation](https://github.com/webrium/core/wiki/Route-Class-Documentation)
 * [Session Documentation](https://github.com/webrium/core/wiki/Session-Class-Documentation)
 * [JWT (JSON Web Token) Documentation](https://github.com/webrium/core/wiki/JWT-Documentation)
 * [Hash And Password Documentation](https://github.com/webrium/core/wiki/Hash-Class-Documentation)
 * [HTTP Class Documentation](https://github.com/webrium/core/wiki/HTTP-Class-Documentation)
 * [Email Documentation](https://github.com/webrium/core/wiki/Email-Documentation)
 * [Console Documentation](https://github.com/webrium/console)
 * [Form Validation Documentation](https://github.com/webrium/core/wiki/FormValidation-Class-Documentation)

### Database Documentation
 - [Database and Query builder](https://github.com/webrium/foxdb)
   - [Select](https://github.com/webrium/foxdb#retrieving-all-rows-from-a-table)
   - [Insert](https://github.com/webrium/foxdb#insert-statements)
   - [Update](https://github.com/webrium/foxdb#update-statements)
   - [Schema](https://github.com/webrium/foxdb/wiki/Schema)
   - [Eloquent](https://github.com/webrium/foxdb/wiki/eloquent)
 
 
 
 <br>
 
 ## Using docker image
  - [Show Docker image Docs](https://github.com/webrium/docker-image)
