# [Stephen Grider] Microservices with Node JS and React [ENG, 2020]

# 16. Managing a NATS Client

<br/>

### 01. Publishing Ticket Creation

<br/>

### 02. More on Publishing

<br/>

### 03. NATS Client Singleton

<br/>

![Application](/img/pic-16-01.png?raw=true)

<br/>

### 04. Remember Mongoose

<br/>

![Application](/img/pic-16-02.png?raw=true)

<br/>

### 05. Singleton Implementation

<br/>

### 06. Accessing the NATS Client

<br/>

### 07. Graceful Shutdown

<br/>

    $ kubectl delete pod nats-deployment-cb48ddfbf-zghfq

<br/>

**Nats connection closed!**

<br/>

![Application](/img/pic-16-03.png?raw=true)

<br/>

### 08. Successful Listen!

    $ npm run listen

<br/>

```
// CREATE TICKET
```

<br/>

![Application](/img/pic-16-04.png?raw=true)

<br/>

### 09. Ticket Update Publishing

```
// UPDATE TICKET
```

<br/>

### 10. Failed Event Publishing

<br/>

### 11. Handling Publish Failures

<br/>

### 12. Fixing a Few Tests

    $ cd tickets
    $ npm run test

<br/>

![Application](/img/pic-16-05.png?raw=true)

<br/>

### 13. Redirecting Imports

<br/>

![Application](/img/pic-16-06.png?raw=true)

<br/>

### 14. Providing a Mock Implementation

<br/>

### 15. Test-Suite Wide Mocks

<br/>

### 16. Ensuring Mock Invocations

<br/>

### 17. NATS Env Variables

<br/>

---

<br/>

**Marley**

Any questions in english: <a href="https://jsdev.org/chat/">Telegram Chat</a>  
Любые вопросы на русском: <a href="https://jsdev.ru/chat/">Телеграм чат</a>
