const program = require('commander')

program
  .version(require('../../package').version)
  .name('npm run')
  .description('egs: \n  npm run start -- --type=h5 --project=test \n  npm run start:multi -- --type=h5 --project=test')
  .usage('<command> -- <options>')
  .option('-P, --project', 'project name that will be operated.')
  .option('-E, --env', 'project compilation environment.default:dev, [prod/alpha/dev]')
  .option('-G, --gzip', 'build application use gizp compress')
  .command('dll', 'dll bundle')
  .command('start', 'development mode -- sigle-page')
  .command('start:multi', 'development mode -- multi-page')
  .command('build', 'packaged project, env prod. -- sigle-page')
  .command('build:multi', 'packaged project, env prod. -- multi-page')
  .command('deploy:cli', 'deploy dist to s3. "npm run deploy:cli <profileName> <sourcePaht> <S3Path>"')
  .parse(process.argv)