/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc.annotation;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletRequest;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.portlet.util.PortletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PortletAnnotationMappingUtils {
    PortletAnnotationMappingUtils() {
    }

    public static boolean validateModeMapping(String[] modes, String[] typeLevelModes) {
        if (!ObjectUtils.isEmpty((Object[])modes) && !ObjectUtils.isEmpty((Object[])typeLevelModes)) {
            for (String mode : modes) {
                boolean match = false;
                for (String typeLevelMode : typeLevelModes) {
                    if (!mode.equalsIgnoreCase(typeLevelMode)) continue;
                    match = true;
                }
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkRequestMethod(RequestMethod[] methods, PortletRequest request) {
        if (methods.length == 0) {
            return true;
        }
        if (!(request instanceof ClientDataRequest)) {
            return false;
        }
        String method = ((ClientDataRequest)request).getMethod();
        for (RequestMethod candidate : methods) {
            if (!method.equals(candidate.name())) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRequestMethod(Set<String> methods, PortletRequest request) {
        if (!methods.isEmpty()) {
            if (!(request instanceof ClientDataRequest)) {
                return false;
            }
            String method = ((ClientDataRequest)request).getMethod();
            if (!methods.contains(method)) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkParameters(String[] params, PortletRequest request) {
        if (!ObjectUtils.isEmpty((Object[])params)) {
            for (String param : params) {
                int separator = param.indexOf(61);
                if (separator == -1) {
                    if (!(param.startsWith("!") ? PortletUtils.hasSubmitParameter(request, param.substring(1)) : !PortletUtils.hasSubmitParameter(request, param))) continue;
                    return false;
                }
                String key = param.substring(0, separator);
                String value = param.substring(separator + 1);
                if (value.equals(request.getParameter(key))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkHeaders(String[] headers, PortletRequest request) {
        if (!ObjectUtils.isEmpty((Object[])headers)) {
            for (String header : headers) {
                int separator = header.indexOf(61);
                if (separator == -1) {
                    if (!(header.startsWith("!") ? request.getProperty(header.substring(1)) != null : request.getProperty(header) == null)) continue;
                    return false;
                }
                String key = header.substring(0, separator);
                String value = header.substring(separator + 1);
                if (PortletAnnotationMappingUtils.isMediaTypeHeader(key)) {
                    List requestMediaTypes = MediaType.parseMediaTypes((String)request.getProperty(key));
                    List valueMediaTypes = MediaType.parseMediaTypes((String)value);
                    boolean found = false;
                    Iterator valIter = valueMediaTypes.iterator();
                    while (valIter.hasNext() && !found) {
                        MediaType valueMediaType = (MediaType)valIter.next();
                        Iterator reqIter = requestMediaTypes.iterator();
                        while (reqIter.hasNext() && !found) {
                            MediaType requestMediaType = (MediaType)reqIter.next();
                            if (!valueMediaType.includes(requestMediaType)) continue;
                            found = true;
                        }
                    }
                    if (found) continue;
                    return false;
                }
                if (value.equals(request.getProperty(key))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isMediaTypeHeader(String headerName) {
        return "Accept".equalsIgnoreCase(headerName) || "Content-Type".equalsIgnoreCase(headerName);
    }
}

