# Asp.Net Core MVC 3.1 tutorial with live application by Nitish
Welcome to Asp.Net Core MVC tutorial. This is a complete and step by step tutorial for all the developers.

## WebGentle Free YouTube video:
You can learn Asp.Net Core MVC tutorial from WebGentle YouTube channel free of cost.
You can access webgebtle youtube channel by clicking [here](https://www.youtube.com/watch?v=CP-zbZA5LAc&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ)

## Kindly subscribe to Wegentle Youtube channel:
Subscribe to us: [WebGentle Youtube channel](https://bit.ly/webgentle)

## Who can learn from this tutorial:
All professionals who want to start their career in asp.net core framework and want to add new skill in their bucket, can learn asp.net core from this tutorial.
* Fresher
* Experienced 
* Anyone who has basic knowledge of programming

## Key features of this course:
* Free of cost - No need to pay anything
* Complete and step by step solution
* English language - Tutorial is available in English language
* Excellent combination of Theory, practical example & Live application.

## Prerequisite:
No special knowledge is required for this tutorial. But it will be helpful if have basic knowledge of
* C# (Class, Method, Property etc.)
* OOPS Concepts
* HTML & CSS

## List of all the videos:
1. [Asp.Net Core MVC 3.1 course overview](https://www.youtube.com/watch?v=CP-zbZA5LAc&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=1)
2. [What is .Net Core & ASP.NET Core](https://www.youtube.com/watch?v=-lgNclGseLM&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=2)
3. [Setting up dot net core machine development](https://www.youtube.com/watch?v=bFsu3nup00Y&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=3)
4. [How to create asp.net core mvc web application (using Visual Studio 2019 & CLI)](https://www.youtube.com/watch?v=_AlcrY5YEww&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=4)
5. [What is MVC pattern (model view controller architecture) in .net core](https://www.youtube.com/watch?v=zBYxYgDWh4w&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=5)
6. [Convert console application to web application in asp.net core](https://www.youtube.com/watch?v=9QQSPFtZ6Uk&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=6)
7. [Setup application on GitHub repository](https://www.youtube.com/watch?v=lQMiMyMQHVg&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=7)
8. [Middleware in Asp.net Core or app.Use(), app.Next(), app.Map()](https://www.youtube.com/watch?v=10AWqnAph2g&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=8)
9. [launchsettings.json in Asp.Net Core](https://www.youtube.com/watch?v=5A68_ArtOJA&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=9)
10. [Environment variables in asp.net core](https://www.youtube.com/watch?v=nQBNkISSE_4&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=10)
11. [Setup MVC in .Net Core application using AddControllersWithViews method](https://www.youtube.com/watch?v=j_eF38mK2QI&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=11)
12. [AddMVC() vs AddControllersWithViews() vs AddControllers() vs AddRazorPages()](https://www.youtube.com/watch?v=gxu1fsHGvMo&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=12)
13. [Controller in Asp.Net Core MVC](https://www.youtube.com/watch?v=KxIMpq2btKs&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=13)
14. [Model in Asp.Net core](https://www.youtube.com/watch?v=A_LPA_c41TM&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=14)
15. [View in asp.net core application](https://www.youtube.com/watch?v=xfFQQd3m4yE&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=15)
16. [How controller finds a view (View Discovery) or Different way to return view from action method](https://www.youtube.com/watch?v=KRd-IHNRc3Y&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=16)
17. [Razor ViewEngine in Asp.Net Core](https://www.youtube.com/watch?v=U2DZMDcAke0&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=17)
18. [Conditional statements (If, Else, Ternary Operator, Switch) in Razor](https://www.youtube.com/watch?v=CayKF6qxVRI&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=18)
19. [For & ForEach Loop in Razor Syntax](https://www.youtube.com/watch?v=i41vf2l62hI&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=19)
20. [Static files (Img, css & js) in asp.net core](https://www.youtube.com/watch?v=L7J5jI6-9r4&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=20)
21. [How to install & use client side library (jQuery & Bootstrap) in asp.net core ](https://www.youtube.com/watch?v=VwqozSbQuec&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=21)
22. [Razor file compilation in asp.net core](https://www.youtube.com/watch?v=ctB8GvRouSQ&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=22)
23. [Layout in asp.net core](https://www.youtube.com/watch?v=Kv7JEOUuOdI&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=23)
24. [Design a responsive home page for real-time application (Book Store)](https://www.youtube.com/watch?v=bVGontQCB_I&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=24)
25. [How to add navigation bar (navbar) in asp.net core application](https://www.youtube.com/watch?v=4pBWKbJ9nL0&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=25)
26. [How to add footer in asp.net core application](https://www.youtube.com/watch?v=A6pyEv4EH4I&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=26)
27. [Display Model list data on view in Asp.Net Core](https://www.youtube.com/watch?v=CuA_pgkXqf0&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=27)
28. [RenderSection & Section in Asp.Net Core](https://www.youtube.com/watch?v=a0VMZ0reVXU&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=28)
29. [Design and develop a product detail page in asp.net core](https://www.youtube.com/watch?v=elJgXm1Fc80&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=29)
30. [_ViewStart.cshtml file in asp.Net core](https://www.youtube.com/watch?v=ZiB1vqj-Y1g&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=30)
31. [_ViewImports file in asp.net core](https://www.youtube.com/watch?v=rdag_suOGj4&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=31)
32. [ViewBag in Asp.Net Core MVC](https://www.youtube.com/watch?v=nbw50yMD3q0&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=32)
33. [ViewData in Asp.Net Core](https://www.youtube.com/watch?v=Clfw1GWNv58&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=33)
34. [ViewData Attribute in Asp.Net Core](https://www.youtube.com/watch?v=Bf4WjnjZobk&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=34)
35. [Dynamic views in asp.net core](https://www.youtube.com/watch?v=hOE3w9N23zQ&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=35)
36. [Tag helpers in asp.net core](https://www.youtube.com/watch?v=YsyXTIoLeZQ&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=36)
37. [Anchor Tag helper in Asp.Net Core](https://www.youtube.com/watch?v=xfUq_aMjL8w&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=37)
38. [ Image tag helper in asp.net core](https://www.youtube.com/watch?v=iJTiPHkTwGU&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=38)
39. [Environment tag helper in asp.net core](https://www.youtube.com/watch?v=V9Ie2OvbAhs&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=39)
40. [Link tag helper in asp.net core](https://www.youtube.com/watch?v=wYSh8jGsT50&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=40)
41. [Create form in asp.net core](https://www.youtube.com/watch?v=hRjzu738zgE&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=41)
42. [What is Entity Framework Core](https://www.youtube.com/watch?v=EGoYmjjU_Ko&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=42)
43. [How to install entity framework (ef) core](https://www.youtube.com/watch?v=SWkyGXN8f9g&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=43)
44. [How to setup DbContext class in entity framework core](https://www.youtube.com/watch?v=Yhmg5VJlSwY&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=44)
45. [Generate database using entity framework core CLI](https://www.youtube.com/watch?v=xPgzPQKG5n8&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=45)
46. [Insert data in database using entity framework core](https://www.youtube.com/watch?v=cE_o8piz-2Y&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=46)
47. [Making Async call using entity framework core](https://www.youtube.com/watch?v=O7NkoVMRS7M&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=47)
48. [Get list of data from database using entity framework core](https://www.youtube.com/watch?v=4flp6MQTRhQ&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=48)
49. [Get details of book from database](https://www.youtube.com/watch?v=AhMwkcvQc6w&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=49)
50. [Model validations in asp.net core](https://www.youtube.com/watch?v=ckD1tLQfyH4&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=50)
51. [Validation summary (asp-validation-summary attribute) in asp.net core](https://www.youtube.com/watch?v=5txrbp6D-gg&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=51)
52. [DataType attribute in asp.net core (Generate form fields from model)](https://www.youtube.com/watch?v=9u0EOBNHvDE&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=52)
53. [Dropdown in asp.net core (Create drop down using option tag)](https://www.youtube.com/watch?v=l6JhPyUZhHk&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=53)
54. [Dropdown in asp.net core with text and value property ](https://www.youtube.com/watch?v=P1rWY4p7-S4&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=54)
55. [Dropdown in asp.net core using SelectList](https://www.youtube.com/watch?v=MUTUjxXHzzQ&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=55)
56. [Create dropdown in asp.net core with text and value using SelectList](https://www.youtube.com/watch?v=KEpdE_Qozdk&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=56)
57. [Create dropdown in asp.net core using SelectListItem](https://www.youtube.com/watch?v=pxp7itShsZ4&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=57)
58. [Create group in asp.net core dropdown (SelectListGroup)](https://www.youtube.com/watch?v=RvzNiEUhs9Q&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=58)
59. [Multiselect dropdown in asp.net core](https://www.youtube.com/watch?v=n2gTAdpkvLg&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=59)
60. [Create dropdown using Enum in asp.net core](https://www.youtube.com/watch?v=0JDxnjcH_v0&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=60)
61. [Get and save dropdown data in database](https://www.youtube.com/watch?v=zBJVaNp9euA&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=61)
62. [Custom Validation Attribute in asp.net core](https://www.youtube.com/watch?v=KsBbcsQfSkw&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=62)
63. [Custom tag helper in asp.net core](https://www.youtube.com/watch?v=C7UkHzpOJvc&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=63)
64. [Override existing html tag in asp.net core](https://www.youtube.com/watch?v=6fgXaFux2ns&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=64)
65. [Client side validation in asp.net core using unobtrusive js](https://www.youtube.com/watch?v=foY_YOk0NTA&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=65)
66. [Using jQuery Unobtrusive AJAX in ASP.NET Core](https://www.youtube.com/watch?v=JvXYU5sHbTs&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=66)
67. [Upload file (image) in asp.net core mvc, IFormFile in asp.net core](https://www.youtube.com/watch?v=bqyZiwXOMH0&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=67)
68. [Save image URL in database and display image on view](https://www.youtube.com/watch?v=DTQMTB2ghDM&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=68)
69. [Upload multiple images in asp net core](https://www.youtube.com/watch?v=lh-oOqukZus&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=69)
70. [Upload and view a pdf file in asp.net core](https://www.youtube.com/watch?v=aUdnaAsq1ec&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=70)
71. [Partial view in asp.net core](https://www.youtube.com/watch?v=0o8zJpnHV8c&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=71)
72. [Partial tag helper vs Partial vs PartialAsync vs RenderPartial vs RenderPartialAsync](https://www.youtube.com/watch?v=D00C-KcoX7g&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=72)
73. [View Components in asp.net core](https://www.youtube.com/watch?v=qZ1-lkfb4NI&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=73)
74. [How to get data from database and use in View Component in asp.net core](https://www.youtube.com/watch?v=CLoNnyb_ok8&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=74)
75. [How to pass parameters in view components in asp.net core](https://www.youtube.com/watch?v=8raneKbOWPc&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=75)
76. [Routing in asp.net core](https://www.youtube.com/watch?v=MOVOHHFSCRI&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=76)
77. [Attribute routing in asp.net core](https://www.youtube.com/watch?v=87r-9WD7PEs&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=77)
78. [Route constraints in asp.net core](https://www.youtube.com/watch?v=vKOAdgq_PSU&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=78)
79. [Dependency Injection in Asp.net core](https://www.youtube.com/watch?v=gVXdofnkTt4&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=79)
80. [Dependency injection in view (cshtml) file](https://www.youtube.com/watch?v=KUo9HvBkiJ8&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=80)
81. [appsettings.json file in asp.net core](https://www.youtube.com/watch?v=09Q7L6CZmsE&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=81)
82. [Connection string in appsettings.json in asp.net core](https://www.youtube.com/watch?v=c4ITPctD8Hg&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=82)
83. [Read configuration using GetValue method from appsettings.json file](https://www.youtube.com/watch?v=9jNZi50kmBs&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=83)
84. [Read configuration using GetSection method from appsettings.json file](https://www.youtube.com/watch?v=P33EVo_ZmQE&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=84)
85. [Binding Configuration to objects using Bind method](https://www.youtube.com/watch?v=NiOa9-q3q3o&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=85)
86. [Read configuration using option pattern (IOptions) from appsettings](https://www.youtube.com/watch?v=M8tEubdQGP4&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=86)
87. [Reloading configuration using IOptionsSnapshot() in asp.net core](https://www.youtube.com/watch?v=YKVMRP3R96k&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=87)
88. [Reload configuration in singleton service](https://www.youtube.com/watch?v=aFE90rkJ8i4&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=88)
89. [Named options in asp.net core](https://www.youtube.com/watch?v=uUqZFfTmzJU&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=89)
90. [IOption vs IOptionsSnapshot vs IOptionsMonitor](https://www.youtube.com/watch?v=Doj9W5Rv7vs&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=90)
91. [Install Identity Core and generate Identity Core tables in database](https://www.youtube.com/watch?v=9rGeTjoKsb8&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=91)
92. [Design a registration (Signup) page in asp.net core](https://www.youtube.com/watch?v=pU2VaJaDhyE&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=92)
93. [Signup in asp.net core](https://www.youtube.com/watch?v=50velawhaP0&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=93)
94. [Add columns to aspnetusers table](https://www.youtube.com/watch?v=tYT9ykDEnjE&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=94)
95. [Configure the password complexity in Identity core](https://www.youtube.com/watch?v=ZQQNj9TLsOw&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=95)
96. [Login in asp.net core using Identity core framework from scratch](https://www.youtube.com/watch?v=ab9xnExBNF8&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=96)
97. [Logout in asp.net core](https://www.youtube.com/watch?v=x2q2yqO3Brk&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=97)
98. [Authorize attribute in asp.net core (How to secure an action method)](https://www.youtube.com/watch?v=yvN39M-MThM&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=98)
99. [Redirect user to login page (custom login url)](https://www.youtube.com/watch?v=ViDY0HvthzY&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=99)
100. [ReturnUrl without using hidden field](https://www.youtube.com/watch?v=XYQO7LNs7Eg&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=100)
101. [Claims in asp.net core identity (Display full name of logged-in user)](https://www.youtube.com/watch?v=bVEGTmHrAKg&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=101)
102. [Get logged-in user id in controller](https://www.youtube.com/watch?v=3ebCVa6ueM0&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=102)
103. [Change password in asp.net core identity](https://www.youtube.com/watch?v=UijCaQ5kDOQ&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=103)
104. [Create custom SMTP email service in asp.net core](https://www.youtube.com/watch?v=UY0AAnOhep4&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=104)
105. [Send email from asp.net core application using SMTP](https://www.youtube.com/watch?v=EDxp5Nl1xGQ&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=105)
106. [Send dynamic data (placeholders) in email from asp.net core app](https://www.youtube.com/watch?v=_rbVbTO4a5o&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=106)
107. [Allow only verified emails (accounts) to login](https://www.youtube.com/watch?v=Ktm61mqgc60&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=107)
108. [Generate email confirmation token and send email to the user in asp.net core](https://www.youtube.com/watch?v=MkXQRtgfxsQ&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=108)
109. [Click on link from email to verify the user email](https://www.youtube.com/watch?v=qNwV_YQSr6c&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=109)
110. [Resend email confirmation (verification) email in asp.net core](https://www.youtube.com/watch?v=8-DYUF_8DKE&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=110)
111. [Forgot password (Reset password) generate token and send email in asp.net core](https://www.youtube.com/watch?v=XapHo_U7hn0&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=111)
112. [Forgot (reset) password in asp.net core](https://www.youtube.com/watch?v=b8E3XS3EJOg&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=112)
113. [Area in asp.net core](https://www.youtube.com/watch?v=OduYYIc9ZUA&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=113)
114. [Routing in areas in asp.net core mvc](https://www.youtube.com/watch?v=V4Gk1nNNEWU&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=114)
115. [Roles in asp.net core (Create roles and manage roles using RoleManager & UserManager)](https://www.youtube.com/watch?v=CvTQKS95mug&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=115)
116. [Bundling and minification in asp.net core](https://www.youtube.com/watch?v=IJoxn6wQyUw&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=116)
117. [User lockout in asp.net core (Block user temporarily on wrong password attempt)](https://www.youtube.com/watch?v=YycQwCpFS0w&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=117)
118. [Token lifespan in identity core](https://www.youtube.com/watch?v=ZHVc5eJ49OE&list=PLaFzfwmPR7_LTXu0Vz9Zz_Y0OMMC7ArHZ&index=118)

To be added...

## Contact the author:
You can contact nitish on nitish@webgentle.com, nitish.webgentle@gmail.com

## Nitish Blogs:
https://nitishkaushik.com
