# Roadmap

- [x] Proof of Concept
- [x] Prototype
- [x] [WebFX CLI][webfx-cli-repo]
- [x] [WebFX Demos](https://github.com/webfx-demos)
- [x] [WebFX Website][webfx-website]
- [x] [WebFX Docs][webfx-docs]
- [x] [WebFX Blog][webfx-blog]
- [ ] <img src="plot.svg"></img> ![JavaFX](https://img.shields.io/badge/JavaFX-compatible-brightgreen.svg)
  - [ ] <img src="plot.svg"></img> javafx-base ![](https://geps.dev/progress/80)
  - [ ] <img src="plot.svg"></img> javafx-graphics ![](https://geps.dev/progress/70) ⓵
  - [ ] <img src="plot.svg"></img> javafx-controls ![](https://geps.dev/progress/33) ⓶
  - [ ] <img src="plot.svg"></img> javafx-media ![](https://geps.dev/progress/85)
  - [ ] <img src="plot.svg"></img> javafx-web ![](https://geps.dev/progress/80)
  - [ ] <img src="plot.svg"></img> javafx-fxml ![](https://geps.dev/progress/10) ⓷
- [ ] <img src="plot.svg"></img> Language, Build & Runtime Environments
  - [x] ![GWT](https://img.shields.io/badge/GWT-compatible-brightgreen.svg)
  - [x] ![Vert.x compatible](https://img.shields.io/badge/Vert.x-compatible-brightgreen.svg) ⓼
  - [ ] <img src="plot.svg"></img> ![J2CL](https://img.shields.io/badge/J2CL-compatible-brightgreen.svg) ![](https://geps.dev/progress/85) ⓸
  - [ ] <img src="plot.svg"></img> ![TeaVM](https://img.shields.io/badge/TeaVM-compatible-brightgreen.svg) ![](https://geps.dev/progress/20) ⓹
  - [ ] ![Kotlin compatible](https://img.shields.io/badge/Kotlin-compatible-brightgreen.svg) (via J2CL or TeaVM)
  - [ ] ![Scala](https://img.shields.io/badge/Scala-compatible-brightgreen.svg) (via TeaVM only)
  - [ ] ![JxBrowser](https://img.shields.io/badge/JxBrowser-debug-brightgreen.svg) ⓺
  - [ ] ![WebAssembly](https://img.shields.io/badge/WebAssembly-target-brightgreen.svg) (via J2CL or TeaVM)
- [ ] <img src="plot.svg"></img> Ecosystem
  - [ ] <img src="plot.svg"></img> [WebFX Platform][webfx-platform-repo] ![](https://geps.dev/progress/85)
  - [ ] <img src="plot.svg"></img> [WebFX Extras][webfx-extras-repo] ![](https://geps.dev/progress/70) ⓻
  - [ ] <img src="plot.svg"></img> [WebFX Stack][webfx-stack-repo] ![](https://geps.dev/progress/60) ⓼
  - [ ] <img src="plot.svg"></img> WebFX CSS ![](https://geps.dev/progress/75) ⓽
  - [x] [WebFX Libs][webfx-libs-repo] (subject to grow on demand)
- [ ] <img src="plot.svg"></img> [WebFX Maven Plugin][webfx-maven-plugin] ![](https://geps.dev/progress/40)
- [x] Enterprise application prototype
- [ ] <img src="plot.svg"></img> [Modality][modality-repo] (first Enterprise WebFX app) ![](https://geps.dev/progress/50)
- [x] CI/CD pipeline (see example of [GitHub workflow][github-workflow-example])
- [ ] GitHub workflow automatic generation by the CLI
- [ ] Unit test support in WebFX CLI
- [ ] Additional CLI features for contributors
- [ ] Syntax documentation of `webfx.xml` files
- [ ] Improvement of the OpenJFX patching process
  - [ ] Automate the process to ease a rebase on OpenJFX
  - [ ] Rebase WebFX on OpenJFX latest version
- [ ] General Availability

⓵ 100% = No 3D, no CSS. JavaFX 3D can't be easily mapped to HTML. For CSS, the WebFX approach is to rely on HTML CSS, rather than emulating JavaFX CSS in the browser. See ⓽ for more info about this approach.

⓶ WebFX supports the general javafx-controls API (allowing you to write custom controls). So far, the supported JavaFX controls are: Button, CheckBox, RadioButton, ContextMenu, Label, Hyperlink, TextField, TextArea, PasswordField, ProgressBar, Slider, ScrollPane, SplitPane & TabPane.

⓷ FXML relies on reflection, which is not supported by transpilers. Alternatively, WebFX could transform fxml files into transpilable Java code. A prototype has been made with this approach using [Memory Game](https://github.com/JaretWright/MemoryGame), a FXML-based JavaFX game (see working [demo](https://memorygame.webfx.dev)).

⓸ An effort is currently being made to make WebFX transpiler-agnostic. [J2CL][j2cl-repo] (successor of [GWT][gwt-website] in active development) will be soon supported. This future-proof step will also bring all [next goodies](https://github.com/google/j2cl/issues/93) from J2CL, such as [WebAssembly][webassembly-website] target (in addition to JavaScript) and [Kotlin][kotlin-website] language (in addition to Java).

⓹ [TeaVM][teavm-website] is another popular transpiler. Whereas GWT & J2CL are Java-source transpilers, TeaVM is a byte-code transpiler, which will open the door to other alternative JVM languages such as [Scala][scala-website]. Also, TeaVM supports Java 21, including `record` and new `switch` expressions.

⓺ The [JxBrowser][jxbrowser-website] support will offer an external web view that developers can use to run, test and debug the web version of their WebFX app directly from Java (no transpilation required!). The IDE will simply run your app with the WebFX Kit runtime (instead of OpenJFX) in the JVM, and the DOM generated by WebFX will be rendered in JxBrowser (a Chromium-based browser controlled by Java). This will considerably speed up the development cycle of web apps.

⓻ WebFX extras provides additional features for WebFX, and simpler alternative controls to the complex JavaFX controls not yet supported (ex: simple data grid and charts).

⓼ WebFX Stack provides additional enterprise-level features such as: UI router, I18n, Validation, Auth(n/z) with SSO support, client-side ORM, DB access, websocket-based event bus (for server communication - focus on [Vert.x][vertx-website]), and server push features. WebFX Stack + Vert.x is a Java full-stack solution (similar to React + Node.js).

⓽ WebFX CSS relies on dual format: JavaFX CSS & HTML CSS. WebFX developers will need to write both formats. Although it's more work, this is the most optimised approach (emulating JavaFX CSS and loading caspian.css in the browser would be a heavy approach). WebFX CSS will provide a lighter initial CSS for JavaFX that will replace caspian, using a modern sleek minimalistic flat design.

Some redesign work is also necessary to transit from the current patching process (which is mainly a manual patch of OpenJFX 8) to a more professional patching process with tooling allowing regular rebasing onto OpenJFX.

[webfx-website]: https://webfx.dev
[webfx-docs]: https://docs.webfx.dev
[webfx-guide]: https://docs.webfx.dev/#_getting_started
[webfx-blog]: https://blog.webfx.dev
[webfx-discussions]: https://github.com/webfx-project/webfx/discussions
[webfx-cli-repo]: https://github.com/webfx-project/webfx-cli
[webfx-platform-repo]: https://github.com/webfx-project/webfx-platform
[webfx-extras-repo]: https://github.com/webfx-project/webfx-extras
[webfx-stack-repo]: https://github.com/webfx-project/webfx-stack
[webfx-libs-repo]: https://github.com/webfx-libs
[webfx-maven-plugin]: https://github.com/webfx-project/webfx-maven-plugin
[modality-repo]: https://github.com/modalityone/modality
[github-workflow-example]: https://github.com/webfx-demos/webfx-demo-spacefx/blob/main/.github/workflows/builds.yml
[j2cl-repo]: https://github.com/google/j2cl
[teavm-website]: https://teavm.org
[jxbrowser-website]: https://www.teamdev.com/jxbrowser
[kotlin-website]: https://kotlinlang.org
[webassembly-website]: https://webassembly.org
[scala-website]: https://www.scala-lang.org
[vertx-website]: https://vertx.io