<h1 align="center"> Awesome Weaviate </h1>

![Awesome Weaviate](Assets/Img/Awesome_Weaviate.png)

<div align="center"> 

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Slack](https://img.shields.io/badge/slack--channel-blue?logo=slack)](https://join.slack.com/t/weaviate/shared_invite/zt-goaoifjr-o8FuVz9b1HLzhlUfyfddhw)
[![Newsletter](https://img.shields.io/badge/newsletter-blue?logo=mailchimp)](http://weaviate-newsletter.semi.technology/) 
![Issues](https://img.shields.io/github/issues/semi-technologies/weaviate)
</br>

![Forks](https://img.shields.io/github/forks/semi-technologies/weaviate)
![Stars](https://img.shields.io/github/stars/semi-technologies/weaviate?color=green)
[![Twitter](https://img.shields.io/twitter/url?style=social&url=https%3A%2F%2Ftwitter.com%2FSeMI_tech)](https://twitter.com/SeMI_tech)
[![Youtube](https://img.shields.io/youtube/channel/views/UCJKT6kJ3IFYybWnL7jbXxhQ?style=social)](https://www.youtube.com/channel/UCJKT6kJ3IFYybWnL7jbXxhQ)
[![Linkedin](https://img.shields.io/badge/Linkedin-SeMI%20Technologies-yellowgreen)](https://www.linkedin.com/company/semi-technologies/)
</div>

### Awesome list of examples and tutorials of how to use the Vector Search Engine

---

**Weaviate in a nutshell**: Weaviate is a vector search engine and vector database. Weaviate uses machine learning to vectorize and store data, and to find answers to natural language queries. With Weaviate you can also bring your custom ML models to production scale.

<div align="center">

## [📃Documentation](https://weaviate.io/developers/weaviate/current/) &emsp;  [👩‍💻Github](https://github.com/semi-technologies/weaviate) &emsp; [📑ReadMe](https://github.com/semi-technologies/weaviate#readme)
</div>

---

<h2 align="center"> Table of Contents </h2>

* ### [Examples](#examples)
  * [List of Weaviate examples](https://github.com/semi-technologies/weaviate-examples)

* ### [Blog posts](#blog-posts)

  * [Semantic search through Wikipedia with Weaviate (GraphQL, Sentence-BERT, and BERT Q&A)](https://towardsdatascience.com/semantic-search-through-wikipedia-with-weaviate-graphql-sentence-bert-and-bert-q-a-3c8a5edeacf6)
  * [SeMI blog: Getting Started with the Weaviate Vector Search Engine](https://medium.com/semi-technologies/getting-started-with-the-weaviate-vector-search-engine-10e3997ac3b)
  * [SeMI blog: Weaviate Is A Search Engine For Vector Embeddings](https://medium.com/semi-technologies/weaviate-is-a-search-engine-for-vector-embeddings-33d5b8d99014)
  * [Towards datascience: A sub-50ms neural search with DistilBERT and Weaviate](https://towardsdatascience.com/a-sub-50ms-neural-search-with-distilbert-and-weaviate-4857ae390154)
  * [Db-engines.com: Weaviate, an ANN Database with CRUD support](https://db-engines.com/en/blog_post/87)
  * [SeMI blog: How Weaviate’s GraphQL API was designed](https://medium.com/semi-technologies/how-weaviates-graphql-api-was-designed-b38885aa9cee)
  * [IEEE: Bringing Semantic Knowledge Graph Technology to Your Data](https://ieeexplore.ieee.org/document/8994851)
  * [SeMI blog: Finding Answers in a complex document using Weaviate](https://medium.com/semi-technologies/finding-answers-in-complex-standardizations-documents-using-weaviates-semantic-search-modules-4dcdb83527fb)
  * [SeMI blog: What Weaviate users should know about docker containers](https://medium.com/semi-technologies/what-weaviate-users-should-know-about-docker-containers-1601c6afa079)
  * [Hackernoon: Semantic Search Queries Return More Informed Results](https://hackernoon.com/semantic-search-queries-return-more-informed-results-nr5335nw)
  * [Hackernoon: Getting Started with the Weaviate Vector Search Engine](https://hackernoon.com/getting-started-with-the-weaviate-search-graph-673q32xn)
  * [Hackernoon: What Is Weaviate And How To Create Data Schemas In It](https://hackernoon.com/what-is-weaviate-and-how-to-create-data-schemas-in-it-7hy3460)
  * [Hackernoon: How Weaviate's GraphQL API was designed](https://hackernoon.com/how-weaviates-graphql-api-was-designed-t93932tl)
  * [Hackernoon: Weaviate is your Search Engine for Vector Embeddings](https://hackernoon.com/weaviate-is-your-search-engine-for-vector-embeddings-z43p329l)
  * [Hackernoon: The History of the Weaviate Vector Search Engine](https://hackernoon.com/the-history-of-the-weaviate-search-graph-gk9132dc)
  * [ICT Magazine (Dutch)](https://www.ictmagazine.nl/uitgelicht/wat-als-je-ongestructureerde-data-echt-kan-begrijpen/ (Dutch))
  * [Towards DataScience: Not All Vector Databases Are Made Equal](https://towardsdatascience.com/milvus-pinecone-vespa-weaviate-vald-gsi-what-unites-these-buzz-words-and-what-makes-each-9c65a3bd0696)
  * [Medium: Knowledge Graph Search of 60 Million Vectors with Weaviate](https://medium.com/keenious/knowledge-graph-search-of-60-million-vectors-with-weaviate-7964657ec911)
  * [SeMI blog: Taxonomies, Ontologies and Scehmas How they relate to Weaviate](https://medium.com/semi-technologies/taxonomies-ontologies-and-schemas-how-do-they-relate-to-weaviate-9f76739fc695)
  * [SeMI blog: Transformers with Weaviate v1.2.x](https://medium.com/semi-technologies/weaviate-version-1-2-x-now-supports-transformer-models-4a12d858cce3)
  * [SeMI blog: Build a react based frontend app for your Weaviate Neural Search Engine](https://medium.com/semi-technologies/build-a-react-based-front-end-app-for-your-weaviate-neural-search-bafac9a772b4)
  * [SeMI blog: Weaviate, an ANN DB with CRUD Support](https://medium.com/semi-technologies/weaviate-an-ann-database-with-crud-support-6016138881bd)
  * [SeMI blog: History of Weaviate Search Engine](https://medium.com/semi-technologies/the-history-of-the-weaviate-vector-search-engine-17a274f36178)
  * [SeMI blog: If you could understand your unstructured data](https://medium.com/semi-technologies/what-if-you-could-understand-your-unstructured-data-92f0861e016)
  * [Towards DataScience: Getting Started with Weaviate Python Client](https://towardsdatascience.com/getting-started-with-weaviate-python-client-e85d14f19e4f)
  * [Towards DataScience: Effects of Filtered HNSW Searches on Recall and Latency](https://towardsdatascience.com/effects-of-filtered-hnsw-searches-on-recall-and-latency-434becf8041c)
  * [Medium: Removing Near Duplicates in Semantic Search Retrieval using Weaviate](https://medium.com/codex/removing-near-duplicates-in-semantic-search-retrieval-using-weaviate-b0b2b222f47a)



* ### [Presentation at Conferences](#conference)
  * [Weaviate @ FOSDEM 2021](https://www.youtube.com/watch?v=SDOl9fRObVg)
  * [Weaviate Python client](https://www.youtube.com/watch?v=oN2WKHLYKCc)
  * [Weaviate @ FOSDEM 2020](https://www.youtube.com/watch?v=3NfcAF4qm2k)
  * [Weaviate @ Google Cloud's Stackchat](https://www.youtube.com/watch?v=SOUtWj2szOM)
  * [Weaviate @ FOSDEM 2019](https://www.youtube.com/watch?v=hm9ibPZOUcw)


* ### [Interviews](#interviews)
  * [Sagepub Journal](https://journals.sagepub.com/doi/full/10.1177/2394964320968996)

* ### [Google Colab Notebooks](#colab_notebooks)
  * [Filter Similar Documents (distractors) Weaviate](https://colab.research.google.com/drive/1Jo0kP32GI3EJhdzLc5KZ5Zs7E1rKhOs-?usp=sharing)
  * [Getting-Started-With-Weaviate-Python-Client](https://colab.research.google.com/drive/1jDJIzW1QU0vqMf2AJS_T-4IrpCvXiNIw?usp=sharing#scrollTo=communist-correction)



* ### [Podcasts](#podcast)
  * [Google Cloud Podcast](https://www.gcppodcast.com/post/episode-198-semi-technologies-with-laura-ham/)
  * [Pitch and interview for Dutch Applied AI Award 2021 (in Dutch)](https://open.spotify.com/episode/2vTC604e7cOsRIibadE9GX?si=5c50440c99514cfe)

* ### [Demo Datasets](#datasets)
  * [Weaviate Examples](https://github.com/semi-technologies/weaviate-examples)
  * [Example Datasets](https://weaviate.io/developers/weaviate/current/tutorials/example-datasets.html)

* ### [Meetups](#meetups)
  * [Horizontal Scaling, Sharding, Kubernetes, and more in Weaviate v1.8.0](https://youtu.be/gIIsZ21hdfk)
  * [Getting Started (setup, vectorizers, schemas, importing data and GraphQL)](https://youtu.be/L0Y_zZR8FRI)
  * [How to create custom modules in Weaviate?](https://youtu.be/uKYDHzjEsbU)
  * [Architecture Deep Dive, how to build a vector database](https://youtu.be/6hdEJdHWXRE)
  * [Introducing transformers (DistilBERT, BERT, Sentence-BERT)](https://youtu.be/DCQWqMecdlA)
  * [Weaviate V1.0 release](https://youtu.be/ouNlTYRHKpw)
