<!-- data:start -->
<!--
### DO NOT UPDATE THIS FILE DIRECTLY! ###
PLEASE READ THE CONTRIBUTING GUIDELINES ON HOW TO ADD/REMOVE ITEMS ON THIS LIST!
-->

# 💸 Free For Life
A massive list including a huge amount of products and services that are completely free!

⭐ [Star on GitHub](https://github.com/wdhdev/free-for-life)
&bull;
🤝 [Contribute](https://free.hrsn.dev/#/contributing)

# Table of Contents
- [APIs, Data & ML](#apis-data-and-ml)
- [Artificial Intelligence](#artificial-intelligence)
- [BaaS](#baas)
- [Code Editors](#code-editors)
- [Code Generation](#code-generation)
- [Courses](#courses)
- [DNS](#dns)
- [Databases](#databases)
- [Design & UI](#design-and-ui)
- [Domains](#domains)
- [Email](#email)
- [Font](#font)
- [For Students](#for-students)
- [Forms](#forms)
- [Linux Distributions](#linux-distributions)
- [Messaging & Streaming](#messaging-and-streaming)
- [PaaS](#paas)
- [Payments & Billing](#payments-and-billing)
- [SSL](#ssl)

<!-- APIs_Data_and_ML.md -->
## APIs, Data and ML

| Website | Description |
|:-:|-|
| [Abstract API](https://www.abstractapi.com) | API suite for a variety of use cases, including IP geo-location, gender detection, or even email validation. |
| [algorithmia.com](https://algorithmia.com) | Host algorithms for free. Includes a free monthly allowance for running algorithms. Now with CLI support. |
| [Apify](https://www.apify.com) | Web scraping and automation platform to create an API for any website and extract data. Ready-made scrapers, integrated proxies, and custom solutions. Free plan with $5 platform credits included every month. |
| [API Mocha](https://apimocha.com) | Completely free online API mocking for testing and prototyping. Make up to 500 requests per day, fully customizable API responses, download mock rules as a Postman collection. |
| [Arize AI](https://arize.com) | Machine learning observability for model monitoring and root-causing issues such as data quality and performance drift. Free up to two models. |
| [Atlas Toolkit](https://atlastk.org) | Lightweight library to develop single-page web applications that are instantly accessible. Available for Java, Node.js, Perl, Python, and Ruby. |
| [AwardSpace](https://www.awardspace.com) | AwardSpace offers free web hosting with a free subdomain, PHP, MySQL, app installer, email sending, and no ads. |
| [Beeceptor](https://beeceptor.com?utm_source=free-for-life) | Create a Mock API server in a few seconds. Free 50 requests per day for life, and no need of credit card. Beeceptor is a no-code solution to iterate API design faster and allow parallel development.|
| [Calendarific](https://calendarific.com) | Enterprise-grade Public holiday API service for over 200 countries. Free plan includes 1000 calls per month. |
| [Clarifai](https://www.clarifai.com) | Image API for custom face recognition and detection. Able to train AI models. Free plan has 5000 calls per month. |
| [Cloudmersive](https://cloudmersive.com) | Utility API platform with full access to an expansive API Library including Document Conversion, Virus Scanning, and more with 800 calls/month. |
| [Colaboratory](https://colab.research.google.com) | Free web-based Python notebook environment with Nvidia Tesla K80 GPU. |
| [Collect2](https://collect2.com) | Create an API endpoint to test, automate, and connect webhooks. Free plan allows for two datasets, 2000 records, 1 forwarder, and 1 alert. |
| [Conversion Tools](https://conversiontools.io) | Online File Converter for documents, images, video, audio, eBooks. REST API is available. Libraries for Node.js, PHP, Python. Support files up to 50 GB (for paid plans). Free tier is limited by file size and the number of conversions per day. |
| [Coupler](https://www.coupler.io) | Data integration tool that syncs between apps. It can create live dashboards and reports, transform and manipulate values, collect and back up insights. The free plan has unlimited users, 100 runs with 1000 rows a month, and unlimited integrations. |
| [CraftMyPDF](https://craftmypdf.com) | Auto-Generate PDF documents from reusable templates with a drop-and-drop editor and a simple API. The free plan comes with 100 PDFs/month and 3 templates. |
| [Cube](https://cube.dev) | Cube helps data engineers and application developers access data from modern data stores, organize it into consistent definitions, and deliver it to every application. The fastest way to use Cube is with Cube Cloud, which has a free-tier with 1GB of data pass through each month. |
| [CurlHub](https://curlhub.io) | Proxy service for inspecting and debugging API calls. Free plan includes 10,000 requests per month. |
| [CurrencyScoop](https://currencyscoop.com) | Real-time currency data API for Fintech apps. Free plan includes 5000 calls per month. |
| [Data Fetcher](https://datafetcher.com) | Connect Airtable to any application or API with no-code. Postman-like interface for running API requests in Airtable. Pre-built integrations with dozens of apps. The free plan includes 100 runs per month. |
| [Dataimporter.io](https://www.dataimporter.io) | Tool for connecting, cleaning, and importing data into Salesforce. Free Plan includes up to 20,000 records per month. |
| [Data Miner](https://dataminer.io) | A browser extension (Google Chrome, MS Edge) for data extraction from web pages CSV or Excel. The free plan gives you 500 pages/month. |
| [Datapane](https://datapane.com) | API for building interactive reports in Python and deploying Python scripts and Jupyter Notebooks as self-service tools. |
| [DB-IP](https://db-ip.com/api/free) | Free IP geo-location API with 1k request per IP per day. The lite database under CC-BY 4.0 License is free too. |
| [DB Designer](https://www.dbdesigner.net) | Cloud-based Database schema design and modeling tool with a free starter plan of 2 Database models and 10 tables per model. |
| [DeepAR](https://developer.deepar.ai) | Augmented reality face filters for any platform with one SDK. Free plan provides up to 10 monthly active users (MAU) and tracking up to 4 faces. |
| [Deepnote](https://deepnote.com) | A new kind of data science notebook. Jupyter-compatible with real-time collaboration and running in the cloud. Free tier includes unlimited personal projects, up to 750 hours of standard hardware, and teams with up to 3 editors. |
| [Diggernaut](https://www.diggernaut.com) | Cloud-based web scraping and data extraction platform for turning any website into the dataset or to work with it as with an API. Free plan includes 5k page requests monthly. |
| [FreeFlarum](https://freeflarum.com) | FreeFlarum is a free Flarum hosting service that allows users to quickly create and manage Flarum-based forums without the need for technical expertise or server management. |
| [IP.City](https://ip.city) | 100 free IP geo-location requests per day. |
| [JSONing](https://jsoning.com/api) | Create a mock API from a JSON file for testing and prototyping. |
| [Mockae](https://mockae.com) | Fake REST API powered by Lua. |
| [OntarioNet CN Test](https://cntest.ontarionet.ca) | Check if a website is blocked in China by the Great Firewall. It identifies DNS pollution by comparing DNS results and ASN information detected by servers in China versus servers in the United States. |
| [Scraper's Proxy](https://scrapersproxy.com) | Simple HTTP proxy API made for scraping. Scrape anonymously without having to worry about restrictions, blocks, or captchas. First 100 successful scrapes per month free including JavaScript rendering (more are available if you contact support). |
| [ScraperBox](https://scraperbox.com) | Undetectable web scraping API using real Chrome browsers and proxy rotation. Use a simple API call to scrape any web page. Free plan has 1000 requests per month. |
| [ScrapingAnt](https://scrapingant.com) | Headless Chrome scraping API and free checked proxies service. JavaScript rendering, premium rotating proxies, CAPTCHAs avoiding. Free plans available. |
| [ScrapingDog](https://scrapingdog.com) | ScrapingDog handles millions of proxies, browsers, and CAPTCHAs to provide you with the HTML of any web page in a single API call. It also provides Web Scraper for Chrome & Firefox and software for instant scraping demand. Free plans available. |
| [SearchApi](https://www.searchapi.io) | SearchApi is a robust real-time SERP API delivering structured data from Google and other search engine results pages. Free plan includes 100 successful API calls per month. |
| [Select Star](https://www.selectstar.com) | Select Star is an intelligent data discovery platform that automatically analyzes and documents your data. Free light tier with 1 Data Source, up to 100 tables, and up to 10 users. |
| [SerpApi](https://serpapi.com) | Real-time search engine scraping API. Returns structured JSON results for Google, YouTube, Bing, Baidu, Walmart, and many other engines. Free plan includes 100 successful API calls per month. |
| [Sheetson](https://sheetson.com) | Instantly turn any Google Sheets into a RESTful API. Free plan available. |
| [Shipyard](https://www.shipyardapp.com) | Low-code data orchestration platform for the cloud. Build with a mix of low-code templates and your code (Python, Node.js, Bash, SQL). Our free developer plan offers 10 hours of runtime every month for one user, more than enough to automate multiple workflows. |
| [shrtcode API](https://shrtco.de/docs) | Free URL Shortening API without authorization and no request limits. |

<!-- Artificial_Intelligence.md -->
## Artificial Intelligence

| Website | Description |
|:-:|-|
| [AI Test Kitchen](https://aitestkitchen.withgoogle.com) | AI Test Kitchen is a platform with currently 3 AI's: ImageFX: allows you to make AI images, MusicFX: Allows you to generate AI Music, TextFX: Can explain words. |
| [Bing Chat](https://bing.com) | You can ask complex questions, find comprehensive answers, get summarized information, find inspiration to build upon all in a side-by-side view, with no need to flip between tabs. |
| [ChatGPT](https://chat.openai.com) | ChatGPT is an artificial intelligence chatbot developed by OpenAI and launched in November 2022. It is built on top of OpenAI's GPT-3 family of large language models. |
| [Google Gemini](https://gemini.google.com) | Google Gemini is a assistant like ChatGPT, but you can upload photos and for free and it can access the internet. Successor of Google Bard. |
| [Hugging Face](https://huggingface.co) | The platform where the machine learning community collaborates on models, datasets, and applications. |
| [Perplexity.ai](https://perplexity.ai) | OpenAI GPT-model powered AI chatbot that's connected to the web. Find articles or ask for current info. |
| [Phind](https://phind.com) | AI chatbot built for developers in a chat-like form. |
| [Poe](https://poe.com) | Poe is chat-based AI. Uses GPT-3.5. |
<!-- BaaS.md -->
## BaaS

| Website | Description |
|:-:|-|
| [Appwrite](https://appwrite.io) | A backend platform for developing Web, Mobile, and Flutter applications. |
| [AWS Amplify](https://aws.amazon.com/amplify) | A complete solution that lets frontend web and mobile developers easily build, ship, and host full-stack applications on AWS, with the flexibility to leverage the breadth of AWS services as use cases evolve. |
| [Back4App](https://www.back4app.com) | Back4App is an easy-to-use, flexible, and scalable backend based on the Parse Platform. |
| [Backendless](https://backendless.com) | Mobile and Web Baas, with 1 GB file storage free, push notifications 50,000/month, and 1000 data objects in a table. |
| [BMC Developer Program](https://developers.bmc.com/site/global/bmc_helix_platform/program/overview/index.gsp) | The BMC Developer Program provides documentation and resources to build and deploy digital innovations for your enterprise. Access to a comprehensive, personal sandbox which includes the platform, SDK, and a library of components that can be used to build and tailor apps. |
| [ConnectyCube](https://connectycube.com) | API and SDK for chat messages, voice & video calls, file attachments, and push notifications. Free for apps up to 1K MAU. |
| [Convex](https://convex.dev) | Reactive backend as a service, hosting your data (documents with relationships & serializable ACID transactions), serverless functions, and websockets to stream updates to various clients. Free for small projects - up to 1M records, 5M function calls per month. |
| [Darklang](https://darklang.com) | Hosted language combined with editor and infrastructure. Free during the beta, generous free tier planned after beta. |
| [Engagespot](https://engagespot.co) | Notification infrastructure for developers. Free for up to 100 monthly active users. |
| [Firebase](https://firebase.com) | Firebase helps you build and run successful apps. Free Spark Plan offers Authentication, Hosting, Firebase ML, Realtime Database, Cloud Storage, Testlab. A/B Testing, Analytics, App Distribution, App Indexing, Cloud Messaging (FCM), Crashlytics, Dynamic Links, In-App Messaging, Performance Monitoring, Predictions, and Remote Config are always-free. |
| [Flutter Flow](https://flutterflow.io) | Build your Flutter App UI without writing a single line of code. Also has Firebase integration. Free plan includes full access to UI Builder and Free templates. |
| [Stream](https://getstream.io) | Build scalable newsfeeds, activity streams, chat and messaging in a few hours instead of weeks. |
| [Hasura](https://hasura.io) | Hasura extends your existing databases wherever they are hosted and provides an instant GraphQL API that can be securely accessed for web, mobile, and data integration workloads. Free for 1GB/month of data pass-through. |
| [Iron](https://www.iron.io) | Async task processing (like AWS Lambda) with a free tier and 1-month free trial. |
| [Kuzzle](https://kuzzle.io) | Kuzzle publishes open-source software for managing the Internet of Things, data, and APIs. |
| [LeanCloud](https://leancloud.app) | Mobile backend. 1GB of data storage, 256MB instance, 3K API requests/day, 10K pushes/day are free. (API is very similar to the Parse Platform). |
| [Microsoft Azure Mobile Apps](https://azure.microsoft.com/en-us/solutions/mobile) | Microsoft Azure provides Azure Mobile Apps, which includes a free tier with features like data storage, authentication, push notifications, and offline sync. |
| [NetLicensing](https://netlicensing.io) | A cost-effective and integrated Licensing-as-a-Service (LaaS) solution for your software on any platform from Desktop to IoT and SaaS. Basic Plan for -FREE- while you are a student. |
| [Nhost](https://nhost.io) | Serverless backend for web and mobile apps. Free plan includes: PostgreSQL, GraphQL (Hasura), Authentication, Storage, and Serverless Functions. |
| [OneSignal](https://onesignal.com) | Unlimited free push notifications. |
| [Para](https://paraio.com) | Backend service API with flexible authentication, full-text search, and caching. Free for 1 app, 1GB app data. |
| [Posthook](https://posthook.io) | Job Scheduling Service. Allows you to schedule requests for specific times. 500 scheduled requests/month free. |
| [PubNub](https://www.pubnub.com) | Free push notifications for up to 1 million messages/month and 100 active daily devices. |
| [PushBots](https://pushbots.com) | Push notification service. Free for up to 1.5 million pushes/month. |
| [Pusher](https://pusher.com/beams) | Free, unlimited push notifications for 2000 monthly active users. A single API for iOS and Android devices. |
| [Quickblox](https://quickblox.com) | A communication backend for instant messaging, video and voice calling, and push notifications. |
| [Restspace](https://restspace.io) | Configure a server with services for auth, data, files, email API, templates, etc., then compose into pipelines and transform data. |
| [Salesforce Developer Program](https://developer.salesforce.com) | Build apps Lightning fast with drag and drop tools. Customize your data model with clicks. Go further with Apex code. Integrate with anything using powerful APIs. Stay protected with enterprise-grade security. Customize UI with clicks or any leading-edge web framework. Free Developer Program gives access to the full Lightning Platform. |
| [ServiceNow Developer Program](https://developer.servicenow.com) | Rapidly build, test, and deploy applications that make work better for your organization. Free Instance & access early previews. |
| [Simperium](https://simperium.com) | Move data everywhere instantly and automatically, multi-platform, unlimited sending and storage of structured data, max. 2,500 users/month. |
| [StackStorm](https://stackstorm.com) | Event-driven automation for apps, services, and workflows, free without flow, access control, LDAP. |
| [Supabase](https://supabase.com) | The Open Source Firebase Alternative to build backends. Free Plan offers Authentication, Realtime Database & Object Storage. |
| [Tyk](https://tyk.io) | API management with authentication, quotas, monitoring, and analytics. Free cloud offering. |
| [Zapier](https://zapier.com) | Connect the apps you use to automate tasks. 5 zaps every 15 minutes and 100 tasks/month. |

<!-- Code_Editors.md -->
## Code Editors

| Website | Description |
|:-:|-|
| [Brackets](https://brackets.io) | A modern text editor that makes it easy to design in the browser. |
| [Code::Blocks](https://www.codeblocks.org) | A free and open-source IDE that supports multiple programming languages including C, C++, and Fortran. |
| [CodeLite](https://codelite.org) | An open-source, free, cross-platform IDE, specialized in C, C++, Rust, Python, PHP, and JavaScript. |
| [Eclipse](https://www.eclipse.org) | A popular open-source IDE that supports multiple programming languages, with a strong focus on Java development. It offers a wide range of plugins and extensions for various development tasks. |
| [GitHub Codespaces](https://github.com/features/codespaces) | Spin up fully configured dev environments in the cloud that start in seconds with up to 60 hours a month free. |
| [GNU Emacs](https://www.gnu.org/software/emacs) | An extensible, customizable, free/libre text editor - and more. |
| [Helix](https://helix-editor.com) | A post-modern terminal-based text editor. |
| [Komodo Edit](https://www.activestate.com/products/komodo-edit) | A simple yet powerful code editor, for Windows, macOS and Linux. |
| [Nano](https://www.nano-editor.org) | A terminal-based text editor. |
| [Notepad++](https://notepad-plus-plus.org) | A free and open-source text and source code editor for use with Microsoft Windows. |
| [OnlineGDB](https://www.onlinegdb.com) | Online compiler and debugger for C/C++ and other languages. |
| [Sublime Text](https://www.sublimetext.com) | A shareware text and source code editor available for Windows, macOS, and Linux. |
| [Vim](https://www.vim.org) | A highly configurable terminal-based text editor built to make creating and changing any kind of text. |
| [Visual Studio Code](https://code.visualstudio.com) | Code editing. Redefined. Free. Built on open source. Runs everywhere. |
| [VSCodium](https://vscodium.com) | Highly configurable and open source code editor with plugins, themes, and more. Runs everywhere. Visual Studio Code built from the source, stripped of Microsoft's telemetry and tracking. |
<!-- Code_Generation.md -->
## Code Generation

| Website | Description |
|:-:|-|
| [Blackbox](https://www.blackbox.ai) | AI code generation, chat and search. |
| [Codeium](https://www.codeium.com) | Codeium is a free AI-powered code completion tool. It supports over 20+ programming languages (Python, JavaScript, Java, TypeScript, PHP, C/C++, Go, etc.) and integrates with all major standalone and web IDEs. |
| [CodeWhisperer](https://aws.amazon.com/codewhisperer) | CodeWhisperer is a code-suggestion tool built by Amazon. It comes equipped with a feature that enables it to conduct security scans on your code. |
| [Tabnine](https://www.tabnine.com) | Tabnine helps developers create better software, faster by providing insights learned from all the code in the world. |
| [ZZZ Code AI](https://zzzcode.ai) | Welcome to ZZZ Code AI, our coding website powered by AI! |

<!-- Courses.md -->
## Courses

| Website | Description |
|:-:|-|
| [CS50x](https://cs50.harvard.edu/x) | Harvard University's introduction to the intellectual enterprises of computer science and the art of programming, for concentrators and non-concentrators alike, with or without prior programming experience.|
| [freeCodeCamp](https://www.freecodecamp.org) | freeCodeCamp is a non-profit educational organization that consists of an interactive learning web platform, an online community forum, chat rooms, online publications and local organizations that intend to make learning software development accessible to anyone. |
| [HackerRank](https://hackerrank.com) | HackerRank is a platform for improving programming skills, finding jobs, and connecting with tech companies. |
| [Harvard Online Courses](https://pll.harvard.edu/catalog/free) | Provides free courses in computer science and programming, among other fields. |
| [Khan Academy](https://www.khanacademy.org) | Offers free coding classes, especially good for beginners and younger learners. |
| [MIT OpenCourseWare](https://ocw.mit.edu) | Provides free introductory programming courses from MIT. |
| [PY4E - Python for Everybody](https://www.py4e.com) | This web site is building a set of free materials, lectures, book and assignments to help students learn how to program in Python. |
| [W3Schools](https://www.w3schools.com) | Offers free tutorials on web development technologies like HTML, CSS, JavaScript, and more. |

<!-- DNS.md -->
## DNS

| Website | Type | Description |
|:-:|:-:|-|
| [1.1.1.1](https://1.1.1.1) | Resolver | A free public DNS resolver provided by Cloudflare with fast and secure DNS resolution. |
| [1984 Hosting FreeDNS](https://1984.hosting/product/freedns) | Nameservers | 1984 is a green ethical hosting company in Iceland. Founded in 2006, 1984 has been dedicated to freedom of speech. You register a user on the 1984 home page and after that you can use FreeDNS for your domains. You will have full control over any domain you register to the FreeDNS service. It's all for free. |
| [AdGuard DNS](https://adguard-dns.io) | Resolver | AdGuard DNS allows you to control web traffic on your devices by blocking ads, trackers, and malicious domains. |
| [Afraid.org FreeDNS](https://freedns.afraid.org) | Nameservers | Free DNS Hosting, Dynamic DNS Hosting, Static DNS Hosting, subdomain and domain hosting. |
| [Bunny DNS](https://bunny.net/dns) | Nameservers | Bunny DNS provides DNS hosting with 20 million free queries. |
| [Cloudflare](https://www.cloudflare.com/dns) | Nameservers | Cloudflare DNS is an enterprise-grade authoritative DNS service. It offers fast response times, high redundancy, advanced security features like built-in DDoS mitigation and DNSSEC. |
| [Control-D Free DNS](https://controld.com/free-dns) | Resolver | Control-D is a DNS service that provides free public DNS resolvers to block ads, malware, and other unwanted content. It doesn't log data, supports encryption protocols, and operates with low latency using Anycast. It also offers paid plans with extra features like a transparent proxy and custom rules. |
| [Duck DNS](https://www.duckdns.org) | Nameservers | Duck DNS offers free dynamic DNS (DDNS) with support for up to 5 domains on the free tier. It provides configuration guides for various setups. |
| [Glauca](https://docs.glauca.digital/hexdns) | Nameservers | Glauca offers free DNS hosting for up to 3 domains with DNSSEC support. |
| [Google Public DNS](https://developers.google.com/speed/public-dns) | Resolver | Google Public DNS is a DNS service developed by Google. |
| [Mullvad DNS](https://mullvad.net/en/help/dns-over-https-and-dns-over-tls) | Resolver | Mullvad offers free DNS resolvers with DoT (DNS over TLS), DoH (DNS over HTTPS), and optional domain blocklists. |
| [Namecheap FreeDNS](https://www.namecheap.com/domains/freedns) | Nameservers | Namecheap FreeDNS allows you to keep your domain visible on the internet. It provides DNS hosting with secondary DNS backup to ensure availability. |
| [NextDNS](https://nextdns.io) | Resolver | Similiar to AdGuard DNS, a DNS resolution service which allows you to specify allow/deny lists |
| [No-IP](https://www.noip.com) | Nameservers | Create an easy to remember hostname and never lose your connection again. |
| [OpenDNS](https://www.opendns.com) | Resolver | OpenDNS offers a suite of consumer products that aim to make your internet faster, safer, and more reliable. |
| [Quad9](https://quad9.net) | Resolver | A security and privacy focused non-profit DNS service with no IP logging. |

<!-- Databases.md -->
## Databases

| Website | Description |
|:-:|-|
| [Amazon DynamoDB](https://aws.amazon.com/dynamodb) | Fast, flexible NoSQL database service for single-digit millisecond performance at any scale. | 
| [Apache Cassandra](https://cassandra.apache.org) | Manage massive amounts of data, fast, without losing sleep. |
| [Appwrite](https://appwrite.io) | Appwrite is a backend platform for developing Web, Mobile, and Flutter applications. |
| [Elasticsearch](https://www.elastic.co/elasticsearch) | Elasticsearch is a distributed, RESTful search and analytics engine capable of addressing a growing number of use cases. |
| [Firebase](https://firebase.google.com) | Firebase is an app development platform that helps you build and grow apps and games users love. Backed by Google and trusted by millions of businesses around the world. |
| [MongoDB](https://www.mongodb.com) | MongoDB is an open source database server, for fast building, scalability and data security. They offer a free database plan on [MongoDB Cloud](https://cloud.mongodb.com). |
| [Nhost](https://nhost.io) | Nhost is an open-source backend and development platform that enables developers to build and scale their web and mobile apps. |
| [MongoDB Realm](https://www.mongodb.com/docs/realm) | Realm is a mobile-first database designed for modern, data-driven applications. |
| [MySQL](https://www.mysql.com) | Many of the world's largest and fastest-growing organizations including Facebook, Twitter, Booking.com, and Verizon rely on MySQL to save time and money powering their high-volume Web sites, business-critical systems and packaged software. |
| [Oracle Database](https://www.oracle.com/database) | Oracle database services and products offer customers cost-optimized and high-performance versions of Oracle Database, the world's leading converged, multi-model database management system. |
| [PocketBase](https://pocketbase.io) | Open Source backend for your next SaaS and Mobile app in 1 file. |
| [PostgreSQL](https://www.postgresql.org) | PostgreSQL is a powerful, open source object-relational database system with over 35 years of active development that has earned it a strong reputation for reliability, feature robustness, and performance. |
| [Redis](https://redis.io) | The open source, in-memory data store used by millions of developers as a database, cache, streaming engine, and message broker. | 
| [SQLite](https://www.sqlite.org) | SQLite is a C-language library that implements a small, fast, self-contained, high-reliability, full-featured, SQL database engine. | 
| [Supabase](https://supabase.com) | Supabase is an open source Firebase alternative for building secure and performant Postgres backends with minimal configuration. |

<!-- Design_and_UI.md -->
## Design and UI

| Website | Description |
|:-:|-|
| [AI to UI](https://ai2ui.co) | Easily generate great looking UI components using artificial intelligence. Supports multiple frameworks including React, Next.js, and standard HTML. |
| [Canva](https://canva.com) | Free online design tool to create visual content. |
| [CodeMyUI](https://codemyui.com) | Handpicked collection of Web Design & UI Inspiration with Code Snippets. |
| [Color Hunt](https://colorhunt.co) | Discover the newest hand-picked color palettes of Color Hunt. Get color inspiration for your design and art projects. |
| [ColorKit](https://colorkit.co) | Create color palettes online or get inspiration from top palettes. |
| [CSS Gradient Generator](https://www.css-gradient.com) | Free tool to easily generate custom cross-browser CSS gradients. In RGB and HEX format. |
| [Dribbble](https://dribbble.com) | A designer community for showcasing work and gaining inspiration. |
| [Excalidraw](https://excalidraw.com) | An open-source online whiteboard with a hand-drawn style. Including an infinite canvas, end-to-end encrypted collaboration, and multiple methods of exporting including shareable links. |
| [Figma](https://www.figma.com) | Online, collaborative design tool for teams; the free tier includes unlimited files and viewers with a max of 2 editors and 3 projects. |
| [Flowbite](https://flowbite.com) | A library of components built on top of the utility-classes from Tailwind CSS. |
| [Lunacy](https://icons8.com/lunacy) | Free design software that keeps your flow with AI tools and built-in graphics. |
| [MDBootstrap](https://mdbootstrap.com) | Free for personal & commercial use Bootstrap, Angular, React, and Vue UI Kits with over 700 components, stunning templates, 1-min installation, extensive tutorials & huge community. |
| [Haikei](https://haikei.app) | Haikei is a web app to generate stunning visual content – ready to use with your design tools and workflow. |
| [Tailwind Elements](https://tailwind-elements.com) | Free Bootstrap components recreated with Tailwind CSS, but with better design and more functionalities. |
| [UI Gradients](https://uigradients.com) | A collection of beautiful gradients that can be used for UI backgrounds, buttons, and other design elements. |
| [unDraw Open source illustrations](https://undraw.co) | unDraw is a set of Open-source illustrations for any idea you can imagine and create. Files included PNG, SVG. Attribution Not Required. |

<!-- Domains.md -->
## Domains

| Website | Description | [PSL](https://github.com/publicsuffix/list) Status |
|:-:|-|:-:|
| [getlocalcert.net](https://www.getlocalcert.net) | Free subdomains for private network use. | ✅ |
| [is-a.dev](https://www.is-a.dev) | Free is-a.dev subdomain for developers. | ✅ |
| [is-a-good.dev](https://is-a-good.dev) | A free `is-a-good.dev` subdomain for developers. | ✅ |
| [js.org](https://js.org) | Free js.org subdomains for GitHub Pages for the JavaScript community. | ✅ |
| [NGO.us](https://nic.ngo.us) | Free `.ngo.us` subdomains for verified not-for-profit organizations, NGOs, and similar initiatives. | ✅ |
| [NYC.mn](https://dot.nyc.mn) | Free subdomains for individuals and businesses related to New York City. New York City IP address required for application. | ✅ |
| [Obl.ong](https://obl.ong) | Free, quality subdomains for all, backed by our nonprofit. Get yourname.obl.ong and become a voting member in our organization today! | ✅ |
| [Open Domains](https://open-domains.net) | Free subdomains for personal sites, open-source projects, and more. | ✅ |
| [Open Host](https://registry.openhost.uk) | A free subdomain service offering subdomains on `prvcy.page`, `16-b.it`, `32-b.it`, `64-b.it` with PSL support, and on `pride.moe`, `pride.ngo` without PSL support. | ℹ️ `pride.moe` and `pride.ngo` are not listed, the rest are however. |
| [pp.ua](https://pp.ua) | Free pp.ua subdomains. | ✅ |
| [us.kg](https://nic.us.kg) | Free subdomain service run by the nonprofit DigitalPlat Foundation, supported by the Hack Foundation. | ✅ |

<!-- Email.md -->
## Email

| Website | Description |
|:-:|-|
| [10minutemail](https://10minutemail.com) | Free, temporary email for testing. |
| [AdGuard Temp Mail](https://adguard.com/en/adguard-temp-mail/overview.html) | Free temporary and disposable email generator. Keep your user data private and your inbox free of spam. |
| [AnonAddy](https://anonaddy.com) | Open-source anonymous email forwarding, create unlimited email aliases for free. |
| [Antideo](https://www.antideo.com) | 10 API requests per hour for email verification, IP, and phone number validation in the free tier. No credit cards required. |
| [Bump](https://bump.email) | Free 10 Bump email addresses, 1 custom domain. |
| [DKIM Validator](https://dkimvalidator.com) | Test if a domain's DNS/SPF/DKIM/DMARC settings are correct. |
| [DuckDuckGo Email Protection](https://duckduckgo.com/email) | DuckDuckGo Email Protection is a free email forwarding service that removes multiple types of hidden email trackers and lets you create unlimited unique private email addresses on the fly. |
| [EmailJS](https://www.emailjs.com) | This is not a full email server, this is just an email client which you can use to send emails right from the client without exposing your credentials. The free tier has: 200 monthly requests, 2 email templates, requests up to 50KB, limited contacts history. |
| [FakeMail](https://www.fakemail.net) | Temporary email addresses that shield your real identity. |
| [fakermail](https://fakermail.com) | Free, temporary email for testing with the last 100 email accounts stored. |
| [forwardemail](https://forwardemail.net) | Free email forwarding for custom domains. Create and forward an unlimited number of email addresses with your domain name. (**Note:** The TLDs `.casa`, `.cf`, `.click`, `.email`, `.fit`, `.ga`, `.gdn`, `.gq`, `.lat`, `.loan`, `.london`, `.men`, `.ml`, `.pl`, `.rest`, `.ru`, `.tk`, `.top`, and `.work` are paid due to spam). |
| [Gmail](https://gmail.com) | Free personal email and calendar. |
| [ImprovMX](https://improvmx.com) | Free email forwarding. |
| [inboxkitten](https://inboxkitten.com) | Free temporary/disposable email inbox, with up to 3-day email auto-deletes. Open sourced, and can be self-hosted. |
| [Mail7](https://www.mail7.io) | Free temporary email address for QA Developers. Create email addresses instantly using Web Interface or API. |
| [Mailazy](https://mailazy.com) | Mailazy is the only simple transactional email service you'll need. 10500 emails/month free forever (350 emails/day sending limit). |
| [Mailchimp](https://mailchimp.com) | 2,000 subscribers and 12,000 emails/month free. |
| [MailerLite](https://www.mailerlite.com) | 1,000 subscribers/month, 12,000 emails/month free. |
| [MailerSend](https://www.mailersend.com) | Email API, SMTP, 12,000 emails/month free for transactional emails. |
| [mailinator](https://www.mailinator.com) | Free, public email system where you can use any inbox you want. |
| [mailjet](https://www.mailjet.com) | 6,000 emails/month free (200 emails daily sending limit). |
| [Mailnesia](https://mailnesia.com) | Free temporary/disposable email, which auto-visit registration link. |
| [mailsac](https://mailsac.com) | Free API for temporary email testing, free public email hosting, outbound capture, email-to-slack/websocket/webhook (1,500 monthly API limit). |
| [Mail Tester](https://www.mail-tester.com) | Test if a domain's DNS/SPF/DKIM/DMARC settings are correct, 20 free/month. |
| [Mailtie](https://mailtie.com) | Free Email Forwarding for Your Domain. No registration required. Free Forever. |
| [Mailtrap](https://mailtrap.io) | Fake SMTP server for development, free plan with 1 inbox, 50 messages, no team member, 2 emails/second, no forward rules. |
| [Mail Validator](https://mailvalidator.io) | Verify 300 emails/month for free, real-time API with bulk processing available. |
| [Moosend](https://moosend.com) | Mailing list management service. Free account for 6 months for startups. |
| [Mutant Mail](https://www.mutantmail.com) | Free 10 Email IDs, 1 Domain, 1 Mailbox. Single Mailbox for All Email IDs. |
| [Outlook](https://outlook.com) | Free personal email and calendar. |
| [Parsio](https://parsio.io) | Free email parser (Forward email, extract the data, send it to your server). |
| [pepipost](https://pepipost.com) | 30k emails free for the first month, then the first 100 emails/day are free. |
| [phplist](https://phplist.com) | Hosted version allows 300 emails/month for free. |
| [Proton Mail](https://proton.me/mail) | An email service that prioritizes privacy. It has restrictions such as a maximum of three labels/folders, only one email allowed per account, and a limit of 150 messages per day. |
| [SimpleLogin](https://simplelogin.io) | Open-source, self-hostable email alias/forwarding solution. Free 5 Aliases, unlimited bandwidth, unlimited reply/send. Free for educational staff (students, researchers, etc.). |
| [Takeout](https://takeout.bysourfruit.com) | A constantly updated email service that makes sending emails extremely easy. 500 transactional emails/month free. |
| [Tempail](https://tempail.com) | Free temporary/disposable email for 1 hour per session with qr codes to regain the session. |
| [Temp Mail](https://temp-mail.org) | Free temporary/disposable email per session. |
| [Tutanota](https://tutanota.com) | An email service that prioritizes privacy. The free plan has restrictions such as a maximum of 1gb of storage, 1 calendar per account, and only 1 email per account with a 48 hour verification period to prevent abuse. |
| [Verimail](https://verimail.io) | Bulk and API email verification service. 100 free verifications/month. |
| [Zoho Email](https://www.zoho.com/mail) | Free for 5 users. 5GB/user & 25 MB attachment limit, 1 domain. |

<!-- Font.md -->
## Font

| Website | Description |
|:-:|-|
| [Befonts](https://befonts.com) | Provides several unique fonts for personal or commercial use. |
| [Bunny](https://fonts.bunny.net) | All the Google Fonts with Google Fonts drop-in compatible API. |
| [DaFont](https://www.dafont.com) | The fonts presented on this website are the authors' property and are either freeware, shareware, demo versions, or public domain. |
| [Devicon](https://devicon.dev) | Devicon is a set of icons representing programming languages, designing, and development tools. |
| [Everything Fonts](https://everythingfonts.com) | Offers multiple tools: @font-face, Units Converter, Font Hinter, and Font Submitter. |
| [Font Awesome](https://fontawesome.com) | The Internet's icon library and toolkit, used by millions of designers, developers, and content creators. |
| [Font Library](https://fontlibrary.org) | Font Library is a website that offers a collection of free and open-source fonts for various design projects. |
| [Font of Web](https://fontofweb.com) | Identify all the fonts used on a website and how they are used. |
| [Font Squirrel](https://www.fontsquirrel.com) | Freeware fonts that are licensed for commercial work. Hand-selected typefaces presented in an easy-to-use format. |
| [FontGet](https://www.fontget.com) | Has a variety of fonts available to download and sorted neatly with tags. |
| [Fontshare](https://www.fontshare.com) | A free fonts service. It's a growing collection of professional-grade fonts that are 100% free for personal and commercial use. |
| [Google Fonts](https://fonts.google.com) | Lots of free fonts that are easy and quick to install on a website via a download or a link to Google's CDN. |
| [Nerd Fonts](https://www.nerdfonts.com) | Nerd Fonts is a tool designed for developers that enhances fonts by adding a plethora of glyphs, including icons. This is achieved by incorporating additional glyphs from well-known 'iconic fonts' such as Font Awesome, Devicons, and Octicons, among others. |

<!-- For_Students.md -->
## For Students

| Website | Description |
|:-:|-|
| [AWS Educate](https://aws.amazon.com/education/awseducate) | AWS Educate provides students and educators with no-cost access to cloud computing skills training developed by AWS experts, plus career pathways for students. |
| [Figma](https://www.figma.com/education/students) | Figma offers an Education plan that provides free access to tools for students to prepare for their careers. It also offers a supportive community to assist you in your journey. |
| [GitHub Education Pack](https://education.github.com/pack) | GitHub Global Campus offers resources and opportunities for students, teachers, and schools to access tools and events related to software development. It aims to shape the future generation of developers. |
| [JetBrains](https://www.jetbrains.com/community/education) | Get free access to all JetBrains IDEs for personal use at school or at home, as long as you're a teacher or a student. |
| [Microsoft 365](https://www.microsoft.com/education/products/office) | Students and educators at eligible institutions can sign up for Office 365 Education for free, including Word, Excel, PowerPoint, OneNote, and now Microsoft Teams, plus additional classroom tools. A valid school email is required. |
| [Microsoft Azure](https://azure.microsoft.com) | Microsoft Azure provides a student plan that grants free access to various services, although some limitations may apply. Please note that the educational "trial" period is valid for one year. |
| [Roadmap.sh](https://roadmap.sh) | Roadmap.sh is a free platform that provides learning roadmaps for technical topics such as Blockchain, UX Design, and Frontend Development. |

<!-- Forms.md -->
## Forms

| Website | Description |
|:-:|-|
| [FabForm](https://fabform.io) | Form backend platform for smart developers. Free plan allows 250 form submissions per month. Friendly modern GUI. Integrates with Google Sheets, 50 responses per month. |
| [Form-Data](https://form-data.com) | Free forms backend, 20 submissions/month, and additional 2000 submissions with Form-Data badge. |
| [Form.taxi](https://form.taxi) | Endpoint for HTML forms submissions. With notifications, email notification and a drag and drop designer that can export HTML. Additional features include custom field rules, email notification and auto-respond, email notifications, email notifications. |
| [Formbricks](https://formbricks.com) | An open source Qualtrics alternative. Free plan offers unlimited surveys, unlimited team members and 1500 monthly responses. |
| [Formcake.com](https://formcake.com) | Form backend for devs, spam protection, support by Customer assistance team. |
| [Formcarry.com](https://formcarry.com) | HTTP POST form endpoint. |
| [Formester.com](https://formester.com) | Share and embed unique-looking forms on your website—no limits on the number of forms created or features restricted by the plan. Get up to 100 submissions every month for free. |
| [formingo.co](https://www.formingo.co) | Easy HTML forms for static websites, free plan allows 500 submissions per month, no server code required. |
| [FormKeep.com](https://www.formkeep.com) | Unlimited forms with 50 submissions per month, custom redirect, custom response page, custom thank you page, Email, and others. |
| [formlets.com](https://formlets.com) | Online forms, Airtable, AJAX or POST, and more. Free plan offers unlimited forms and 100MB file storage. |
| [formpost.app](https://formpost.app) | Free endpoint for HTML forms |
| [formspark.io](https://formspark.io) | Form to Email service, file upload, forever free plan allows 50 submissions per month, form logic. Free plan allows 100 submissions per month. |
| [Formspree.io](https://formspree.io) | Send email using an HTTP POST request. Free tier limits to 50 submissions per form per month. |
| [Formsubmit.co](https://formsubmit.co) | Easy form endpoints for your HTML forms. Free Forever. No registration required. |
| [getform.io](https://getform.io) | Form backend platform for designers and developers, teams and integrations to Google Sheets, Telegram & Slack bot, Unlimited Domains & 250 Submissions per month. |
| [Google Forms](https://docs.google.com/forms) | A widely-used tool, created by Google, that allows users to effortlessly create forms. |
| [HeroTofu.com](https://herotofu.com) | Forms backend with bot detection and encrypted archive. Forward submissions via UI to email, 250 submissions per month, 250MB file storage, ActiveCampaign, and Zapier. |
| [HeyForm.net](https://heyform.net) | Drag and drop online form builder. Free tier lets you create unlimited forms and collect unlimited submissions. Comes with pre-built templates, one form, or Zapier. Use your own frontend, redirects, single email notifications. |
| [Hyperforms.app](https://hyperforms.app) | Create form to email and more in seconds and without backend code. The Personal account gives you up to 50 form submissions per month for free. |
| [Jotform](https://jotform.com) | An easy, but feature-rich website to create forms. |
| [Kwes.io](https://kwes.io) | Feature-rich form endpoint. Works great with static sites. Free plan includes up 1 website with up to 50 submissions per month. |
| [Pageclip](https://pageclip.co) | Free plan allows one site, anti-spam, auto-response, but allows unlimited envelopes + signatures. |
| [Qualtrics Survey](https://qualtrics.com/free-account) | Create professional forms & survey using this first-class tool. 50+ expert-designed survey templates. Free Account has a limit of 1 active survey, 1 form, 10 elements per survey. |
| [SimplePDF.eu](https://simplepdf.eu/embed) | Embed a PDF editor on your website and turn any PDF into a fillable form. Free plan allows unlimited PDFs with 3 submissions per PDF., Zapier, Zapier integration, Zapier integration. No libraries or dependencies required. |
| [smartforms.dev](https://smartforms.dev) | Powerful and easy form backend for your website, 100 responses per month, 100 submissions, 100 submissions/month, 100MB file storage. |
| [staticforms.xyz](https://www.staticforms.xyz) | Integrate HTML forms easily without any server-side code for free. After the user submits the form, an email will be sent to your registered address with form content. |
| [stepFORM.io](https://stepform.io) | Quiz and Form Builder. Free plan has 5 forms, Single file upload, Slack, Slack, spam blocker, and GDPR-compliant data processing. Free plan for basic usage. |
| [Tally.so](https://tally.so) | 99% of all the features are totally free. The free tier lets you have these: unlimited forms, and many more. |
| [Typeform.com](https://www.typeform.com) | Include beautifully designed forms on websites. Free plan allows only 10 fields per form and 100 responses per month. |
| [WaiverStevie.com](https://waiverstevie.com) | Electronic Signature platform with a REST API. Receive notifications with webhooks. Free plan watermarks signed documents, 50 submissions, 100 responses/survey & 8 response types. |
| [Web3Forms](https://web3forms.com) | Contact forms for Static & JAMStack Websites without writing backend code. Free plan allows unlimited Forms, collect payments, CSV/JSON export, customizable reply-to email address. |
| [WebAsk](https://webask.io) | Survey and Form Builder. Free plan has 3 surveys per account, unlimited Form to Email service. Setup custom redirect, unlimited single-page forms/month, unlimited submissions, up to 3 steps per form, webhooks, webhooks, etc for free. |
| [Wufoo](https://www.wufoo.com) | Quick forms to use on websites. Free plan has a limit of 100 submissions each month. |

<!-- Linux_Distributions.md -->
## Linux Distributions

| Website | Description |
|:-:|-|
| [Arch Linux](https://archlinux.org) | Arch Linux is a lightweight and flexible Linux® distribution that tries to Keep It Simple. |
| [Debian](https://www.debian.org) | Debian is a Linux-based operating system for a wide range of devices including laptops, desktops and servers. |
| [elementary OS](https://elementary.io) | elementary OS is known for its beautiful and user-friendly design. It provides a simple and elegant user interface. |
| [Kali Linux](https://www.kali.org) | Kali Linux is an open-source, Debian-based Linux distribution geared towards various information security tasks, such as Penetration Testing, Security Research, Computer Forensics and Reverse Engineering. |
| [Kubuntu](https://kubuntu.org) | Kubuntu is an operating system built by a worldwide community of developers, testers, supporters and translators. |
| [Linux Mint](https://linuxmint.com) | Linux Mint is one of most popular linux distributions ever. Mission of Linux Mint is to keep it simple and fun. |
| [openSUSE](https://opensuse.org) | openSUSE is a flexible distribution available in both Leap (a stable version) and Tumbleweed (a rolling release) editions. It's known for its robust configuration tools and support for various desktop environments. |
| [Red Hat Enterprise Linux](https://redhat.com) | RHEL is a commercially supported distribution designed for enterprise and business use. It offers long-term support, stability, and security features. |
| [Tails](https://tails.net) | Tails (The Amnesic Incognito Live System) is a privacy-focused Linux distribution designed to protect users' anonymity and security online. |
| [Ubuntu](https://ubuntu.com) | The Ubuntu desktop is by far the world's most widely used Linux workstation platform, powering the work of engineers across the globe. |
| [Zorin OS](https://zorin.com/os) | Zorin OS is designed to mimic the look and feel of Windows, making it a popular choice for users transitioning from Windows to Linux. |

<!-- Messaging_and_Streaming.md -->
## Messaging and Streaming

| Website | Description |
|:-:|-|
| [Ably](https://www.ably.com) | Real-time messaging service with presence, persistence, and guaranteed delivery. Free plan includes 3m messages per month, 100 peak connections, and 100 peak channels. |
| [cloudamqp](https://www.cloudamqp.com) | RabbitMQ as a Service. Little Lemur plan: max 1 million messages/month, max 20 concurrent connections, max 100 queues, max 10,000 queued messages, multiple nodes in different AZ's. |
| [cloudkarafka](https://www.cloudkarafka.com) | Free Shared Kafka cluster, up to 5 topics, 10MB data per topic, and 28 days of data retention. |
| [courier](https://www.courier.com) | Single API for push, in-app, email, chat, SMS, and other messaging channels with template management and other features. Free plan includes 10,000 messages/mo. |
| [eyeson API](https://developers.eyeson.team) | A video communication API service based on WebRTC (SFU, MCU) to build video platforms. Allows Real-Time Data Injection, Video Layouts, Recordings, a fully-featured hosted web UI (quickstart), or packages for custom UIs. Has a [free tier for developers](https://apiservice.eyeson.com/api-pricing) with 1000 meeting minutes per month. |
| [Knock](https://knock.app) | Notifications infrastructure for developers. Send to multiple channels like in-app, email, SMS, Slack, and push with a single API call. Free plan includes 10,000 messages/mo. |
| [PubNub](https://www.pubnub.com) | Swift, Kotlin, and React messaging at 1 million transactions each month. Transactions may contain multiple messages. |
| [Pusher](https://pusher.com) | Real-time messaging service. Free for up to 100 simultaneous connections and 200,000 messages/day. |
| [Scaledrone](https://www.scaledrone.com) | Real-time messaging service. Free for up to 20 simultaneous connections and 100,000 events/day. |
| [SuprSend](https://www.suprsend.com) | Multi-channel Notification Infrastructure. Added multi-tenants, user preferences, inapp notification center. Free for up to 10k notifications per month for developers. |
| [Synadia](https://synadia.com/ngs) | [NATS.io](https://nats.io) as a service. Global, AWS, GCP, and Azure. Free forever with 4k message size, 50 active connections, and 5GB of data per month. |
| [Upstash Kafka](https://upstash.com/kafka) | Serverless Kafka Cloud offering with per-request pricing. It has a free tier with a maximum of 10,000 messages per day. |
| [webpushr](https://www.webpushr.com) | Web Push Notifications. Free for up to 10k subscribers, unlimited push notifications, and in-browser messaging. |

<!-- PaaS.md -->
## PaaS

| Website | Description |
|:-:|-|
| [anvil.works](https://anvil.works) | Web app development with nothing but Python. Free tier with unlimited apps. |
| [Braintree](braintreepayments.com) | Boost Revenue with a Global Payments Partner. |
| [Codename One](https://www.codenameone.com) | Open source, limited to $5 or 500 hours of usage monthly available for free. |
| [configure.it](https://www.configure.it) | Mobile app development platform, 1,000 free API calls/month, 1,000 requests per day, and 100 GiB data transfer per month. |
| [Deno Deploy](https://deno.com/deploy) | Distributed system that runs JavaScript, native autoscaling, no infrastructure configuration). The product is provided by Serverless Inc. and currently under public preview. |
| [Deta](https://www.deta.sh) | Deploy an unlimited number of Node.js and Python apps for free. Includes free DBs, 1,000 rows and no backups, 0.5 GB storage, and 1 GB RAM per app. Also, Studio and Studio Pro IDEs are allowed in the free tier. |
| [Divio](https://www.divio.com) | A platform to manage cloud application deploying only using Docker. Available free subscription for development projects, 3Gi/pod with a maximum of 8Gi/namespace, 5 GB traffic, 10,512 MB private file storage, 512 MB RAM, a default timeout of 15 seconds and 25, a global edge network, and APIs with git-based deployment and built-in service mesh and discovery. Koyeb provides two nano services to run your apps with its forever-free tier and also sponsors open-source projects with free resources. |
| [domcloud.co](https://domcloud.co) | Linux hosting service that also provides CI/CD with GitHub, based on any trigger. Workflows are code, boilerplate-free code, but with all the power of use programming languages. Free tier includes [1.000 yeps](https://yepcode.io/pricing). |
| [Dwolla](www.dwolla.com) | Redefine your payment possibilities with sophisticated account-to-account solutions. |
| [encore.dev](https://encore.dev) | Backend framework using static analysis to provide automatic infrastructure, Storage and Streaming logs. Paid plans include: branch-based environments, TypeScript, unlimited number of free sandbox environments supporting unlimited users, web apps, which you can run [for free](https://docs.pipedream.com/pricing). No server or cloud resources to manage. |
| [fly.io](https://fly.io) | Fly is a platform for applications that need to run globally. It runs your code close to users and scales compute in cities where your app is busiest. Write your code, one MySQL database. |
| [gigalixir.com](https://gigalixir.com) | Gigalixir provides 1 free instance that never sleeps and then deploy to the cloud. 1 GB Disk, and WebAssembly at the edge, API & CLI. Seamlessly scale containers from version control and external Docker registries. Free tier includes 2 services, APIs, apps, Auth, and email. |
| [Glitch](https://glitch.com) | Free public hosting with features such as code sharing and real-time collaboration. Free plan has a 1000 hours/month limit. |
| [Kinsta Static Site Hosting](https://kinsta.com/static-site-hosting) | Free for static site hosting for pre-built static websites and modern static site generators using Node.js. Integrates with GitHub, GitLab and Bitbucket, deploy to the Edge at 260+ CDN locations. |
| [Koyeb](https://www.koyeb.com) | Koyeb is a developer-friendly serverless platform to deploy apps globally. Seamlessly run Docker containers, schedule cron tasks, and more. 100 hours of [free runtime per month](https://www.wayscript.com/pricing), SSH, and MariaDB/Postgres database. The free version has 1 GB storage and 1 GB network/month limit and limited to a free domain. |
| [Krucible](https://usekrucible.com) | Krucible is a platform for creating Kubernetes clusters for testing and development. Free tier accounts come with 25 cluster-hours per month. |
| [M3O](https://m3o.com) | A cloud platform for API services development. M3O is a fully managed Micro as a Service offering focusing on Go microservices development in the Cloud. Free tier provides enough to run 5 services and collaborate with others. |
| [Mendix](https://www.mendix.com) | Rapid Application Development for Enterprises, free "personal environment" offering allows for unlimited code and up to 1 GB database. |
| [Meteor Cloud](https://www.meteor.com/cloud) | Galaxy hosting. Meteor's own platform-as-a-service for Meteor apps which includes free MongoDB Shared Hosting and automatic SSL. |
| [mogenius](https://mogenius.com) | A code-to-cloud platform to easily deploy any service, CI/CD, and security from Cloudflare. Free tier includes 0.5 CPU core, cloud-based (Docker + k8s) developer environments at any time. Remove the need to get resources provisioned on a one-off basis. Quickly build tools, Cron jobs, cross-platform, Custom Domains, dashboards, Database, DBs, and Storage by using infrastructure _from_ code approach (no YAML, deploy it to Fly's platform and let that do all the work to keep your app snappy. Free allowances include up to 3 shared-cpu-1x 256 MB VMs, develop with that infrastructure locally, for Elixir/Phoenix apps. |
| [Napkin](https://www.napkin.io) | FaaS with 500 MB of memory, mobile app development toolchain for Java/Kotlin developers. Free for commercial use with an unlimited number of projects. |
| [Northflank](https://northflank.com) | Build and deploy microservices, requires a card and no custom domain support. |
| [Okteto Cloud](https://okteto.com) | Managed Kubernetes service designed for remote development. Free developer accounts come with 5 Kubernetes namespaces, 1 GB RAM, 1 Python web application at your-username.pythonanywhere.com domain, 1 CPU/pod with a maximum of 4 CPUs/namespace, and 5 GB Disk space. The apps sleep after 24 hours of inactivity. |
| [Oracle Cloud](https://www.oracle.com/cloud) | A complete cloud infrastructure platform for every workload. |
| [OutSystems](https://www.outsystems.com) | Enterprise web development PaaS for on-premise or cloud, 2 cron jobs, and 1 database. |
| [pipedream](https://pipedream.com) | An integration platform built for developers. Develop any workflow, free for 2 projects, from a static website to advanced microservice architectures. mogenius comes with fully managed hyper-scaling cloud resources, jobs, and managed databases with a powerful UI, Kubernetes, limited features but no resource limits. |
| [Paylike](paylike.io) | Easy and simple payments for managers and developers. |
| [PayPal Developer](developer.paypal.com) | Build a payment solution that's right for you with PayPal for Developers. |
| [Porter](https://getporter.dev) | A fully-managed PaaS that lets teams automate DevOps. The free basic tier for Porter Cloud offers management of 1 cluster with up to 10 vCPU and 20 GB memory. |
| [PythonAnywhere](https://www.pythonanywhere.com) | Cloud Python app hosting. The beginner account is free worldwide. The free tier includes 100. |
| [Railway](https://railway.app) | Railway is an infrastructure platform where you can provision infrastructure and free-tier PostgreSQL database limited to 2 connections and more. It includes free cloud hosting for hobby projects. |
| [Replit](https://repl.it) | Online IDE with many coding languages. Offers a free teir with 10 GB of storage and an AI debugger. |
| [Serverless Cloud](https://www.serverless.com/cloud) | Serverless Cloud lets you build Serverless APIs, package it into a Docker image, rate-limited to 5 calls/second. |
| [WayScript](https://www.wayscript.com) | WayScript is an [internal developer platform (IDP)](https://blog.wayscript.com/what-is-an-internal-developer-platform-idp) that allows software engineers to self-serve secure, 3 GB persistent volume storage (total), and 160 GB outbound data transfer. |
| [YepCode](https://yepcode.io) | An all-in-one platform to connect APIs and services in a serverless environment. It brings all the agility and benefits of NoCode tools, 2 GB SSD persistent storage. |
| [Zuplo](https://zuplo.com) | Free API Management platform to design, build, and deploy APIs to the edge. Add Authentication, Rate Limiting, API Documentation, and Monetization in minutes. |

<!-- Payments_and_Billing.md -->
## Payments and Billing

| Website | Description |
|:-:|-|
| [Adapty.io](https://adapty.io) | One-stop solution with open-source SDK for mobile in-app subscriptions integration to iOS, Android, React Native, Flutter, Unity, or web app. Free up to $10k monthly revenue. |
| [Coin360](https://api.coin360.com) | Provides cryptocurrency market data including latest crypto exchange rates and historical data. |
| [CoinGecko](https://www.coingecko.com/en/api) | Provides cryptocurrency market data including latest crypto exchange rates and historical data. Free tier requires attribution. |
| [CoinMarketCap](https://coinmarketcap.com/api) | Provides cryptocurrency market data including latest crypto and fiat currency exchange rates. Free tier offers 10K call credits/month. |
| [Currencyapi.com](https://currencyapi.com) | Free currency conversion and exchange rate data API. 10 requests/hour without an API key, 50,000 requests per month when you register for free. |
| [CurrencyApi](https://currencyapi.net) | Live Currency Rates for Physical and Crypto currencies, delivered in JSON and XML. Free tier offers 1,250 API requests/month. |
| [CurrencyFreaks](https://currencyfreaks.com) | Provides current and historical currency exchange rates. Free DEVELOPER plan available with 1000 requests/month. |
| [currencylayer](https://currencylayer.com) | Reliable Exchange Rates and Currency Conversion for your Business. 1,000 API requests/month free. |
| [ExchangeRate-API](https://www.exchangerate-api.com) | An easy to use currency conversion JSON API. Free tier with no request limit. |
| [FraudLabsPRO](https://www.fraudlabspro.com) | Help merchants prevent payment fraud and chargebacks. Free Micro Plan available with 500 queries/month. |
| [MailPopin](https://mailpop.in) | Get the most of your Stripe notifications with contextualized information. |
| [Nami ML](https://www.namiml.com) | Complete platform for in-app purchases and subscriptions on iOS and Android, including no-code paywalls, CRM, and analytics. Free for all base features to run an IAP business. |
| [ParityVend](https://www.ambeteco.com/ParityVend) | Automatically adjust pricing based on visitor location to expand your business globally and reach new markets (purchasing power parity). The free plan includes 7,500 API requests/month. |
| [Paymenter](https://paymenter.org) | Free and open-source solution for hostings. Free forever |
| [Qonversion](https://qonversion.io) | All-in-one cross-platform subscription management platform offering analytics, A/B testing, Apple Search Ads, remote configs, and growth tools for optimizing in-app purchases and monetization. Compatible with iOS, Android, React Native, Flutter, Unity, Cordova, Stripe, and web. Free up to $10k in monthly tracked revenue. |
| [RevenueCat](https://www.revenuecat.com) | Hosted backend for in-app purchases and subscriptions (iOS and Android). Free up to $10k/mo in tracked revenue. |
| [VAT Layer](https://vatlayer.com) | Instant VAT number validation and EU VAT rates API. Free 100 API requests/month. |

<!-- SSL.md -->
## SSL

| Website | Description |
|:-:|-|
| [FreeSSL](https://www.freessl.org) | FreeSSL.org provides free SSL certificates for single domains, with a simple and quick verification process. |
| [InfinityFree](https://dash.infinityfree.com/sslCertificates) | InfinityFree not only provides free hosting but also offers free SSL certificates with fast installation for your InfinityFree account. |
| [Let's Encrypt](https://letsencrypt.org) | Let's Encrypt is a widely trusted and fully automated SSL certificate provider, offering free SSL certificates to secure your website. |
| [SSL.com](https://ssl.com) | SSL.com offers free 90-day SSL certificates for single domains and provides various paid certificate options. |
| [ZeroSSL](https://zerossl.com) | Provides account driven SSL management and monitoring, certificates are provisioned with a 90 day lifespan on the free tier. |

⬆️ [**Back to Top**](#table-of-contents)
