module.exports = Object.freeze({
  BLANK_PNG: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAAtJREFUCB1jYAACAAAFAAGNu5vzAAAAAElFTkSuQmCC',
  TICK_SVG: 'data:image/svg+xml;base64,PHN2ZyBmaWxsPSIjMDAwMDAwIiBoZWlnaHQ9IjI0IiB2aWV3Qm94PSIwIDAgMjQgMjQiIHdpZHRoPSIyNCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4gICAgPHBhdGggZD0iTTAgMGgyNHYyNEgweiIgZmlsbD0ibm9uZSIvPiAgICA8cGF0aCBkPSJNOSAxNi4xN0w0LjgzIDEybC0xLjQyIDEuNDFMOSAxOSAyMSA3bC0xLjQxLTEuNDF6Ii8+PC9zdmc+',
  AUTOFILL: 'data:image/png;base64,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',
  AUTOFILL_HOVER: 'data:image/png;base64,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',
  AUTOFILL_MENU: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAVlpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KTMInWQAAAShJREFUOBGlks0qRkEch+f1kpLyVQo7FlbuwC1YWUopW8odWNmxs3YD7JWVYm1hZ2EhKcSbhUT5ep4xR2M6eONXz/nP/D9nzjkh/FPNor6TvXTAWxH7cWtB2cyCOt+XRiZY/ApO7IEx8BQPoK/t08yTvA8ncARrMACqG7pqsHnUMk+nlex8hL9/NghNwAGMwFVaT2KnQG3AIfSCA6yppD/MQjV5NUWmsa3MX8VLu/B5h1T4JzNO1UWadondhuO0d6JXmIE52AN9Z7ACXjtqiWd5PPc2y0+5lfLOsYMQv7d2E+5gEUbhHnZhHfxHmuDLu4UnOIV+aOl0gknKH2kYbHADyuKXuAphCNsHj3ANzxBlExNL1fnynEb+TQ1YIN7f7tpcv8Xz3PbW76UMS6zs0aE+AAAAAElFTkSuQmCC'
})
