# Roke

A Wasp starter with sensible defaults.

## What's he building in there?

I built Roke because I was tired of repeating the same setup ritual for every
new Wasp project. Instead of continuing that cycle, I created the starting point
I always wished I had.

This isn't just another blank slate. It's a thoughtfully crafted foundation that
includes:

- Preconfigured shadcn/ui components
- Motion animation presets
- Helper scripts for common tasks
- Real-world examples beyond the basics
- Best practices baked in

## Philosophy

While most starters give you an empty canvas, Roke provides opinionated defaults
that reflect how modern web apps are actually built. It embraces shadcn/ui's
principles of being "Accessible. Customizable. Open Source." and extends them to
the entire project structure.

The goal isn't just to give you boilerplate - it's to provide a foundation that
makes web development more enjoyable and accessible. Batteries included, but
replaceable.

## Getting Started

Click "Use this template" button at the top of the repository

```bash
# Start the development server
wasp db start
wasp db migrate-dev
wasp start
```

Visit [roke.dev](https://roke.dev) for comprehensive documentation.  
<br /> ![Format & Lint pipeline status](https://github.com/wardbox/roke/actions/workflows/format.yml/badge.svg)  
![Deployment pipeline status](https://github.com/wardbox/roke/actions/workflows/deploy.yml/badge.svg?branch=deploy)

## Contributing

We welcome contributions! Whether it's:

- 🐛 Bug fixes
- ✨ New features
- 📝 Documentation improvements
- 💡 Suggestions

Feel free to open an issue or submit a pull request.

## Learn More

- [Documentation](https://roke.dev)
- [Wasp Documentation](https://wasp-lang.dev)
- [shadcn/ui](https://ui.shadcn.com)
- [Motion](https://motion.dev)

## License

MIT License - feel free to use this in your own projects!
