# OpenHardware
Collections of hardware design related to my drone project.

Brief description for each folders.

| Folder | Description | CAD software |
|---|---|---|
| CurrentMonitor | A simple [ACS758](https://www.allegromicro.com/en/Products/Current-Sensor-ICs/Fifty-To-Two-Hundred-Amp-Integrated-Conductor-Sensor-ICs/ACS758.aspx) breakout board | EAGLE |
| LoRaModem | A board with [Ra-02](http://wiki.ai-thinker.com/_media/lora/docs/c048ps01a1_ra-02_product_specification_v1.1.pdf) LoRa Module and [STM32](https://www.st.com/en/microcontrollers/stm32f103cb.html) MCU | KiCAD |
| OscillatorBreakout | A breakout board for oscillators, supporting three different oscillator packages | KiCAD |
| SimpleFC | Simple yet powerful flight controller for drones, capable of fully autonomous GPS navigation | KiCAD |
| SimpleFCv2 | Version 2 of SimpleFC, with reduced PCB size | KiCAD |
| SimpleFC_G | SimpleFCv2 with integrated GPS receiver | KiCAD |
| MultiRotorHub | A support board in multi-rotor which makes cable management easy | EAGLE |
| PowerModule  | 2s ~ 6s Li-Po BEC with current monitoring |EAGLE  |
| SerialBTBridge | A bridge board between RFM22B telemetry module and HC05 Bluetooth module | EAGLE |
| TinyFC | A tiny flight controller module, supporting board stacking for advanced features | KiCAD |
| ReflowOvenController | A controller board used to convert a commercial oven to PCB reflow oven. | KiCAD |
| AirSensor | A barometer and differential pressure sensor board with UAVCAN support. | KiCAD |
| DIYDummyLoad | A primitive DC dummy load with STM32F103. | EAGLE |
| TinyBEC | 2s ~ 3s / 2A Li-Po BEC, board size 23x18mm. | KiCAD |
